/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpixmapcache_wrapper.h"

// inner classes
#include "qpixmapcache_key_wrapper.h"

// Extra includes
#include <QtGui/qpixmap.h>
#include <QtGui/qpixmapcache.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPixmapCache_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPixmapCache >()))
        return -1;

    ::QPixmapCache *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmapCache.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QPixmapCache()
            cptr = new ::QPixmapCache();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPixmapCache >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QPixmapCacheFunc_cacheLimit(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmapCache.cacheLimit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cacheLimit()
            int cppResult = ::QPixmapCache::cacheLimit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapCacheFunc_clear(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmapCache.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            ::QPixmapCache::clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPixmapCacheFunc_find(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPixmapCache *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPixmapCache *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmapCache.find";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "find", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPixmapCache::find(QPixmapCache::Key&)
    // 1: static QPixmapCache::find(QPixmapCache::Key,QPixmap*)
    // 2: static QPixmapCache::find(QString)
    // 3: static QPixmapCache::find(QString,QPixmap&)
    // 4: static QPixmapCache::find(QString,QPixmap*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // find(QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
            overloadId = 3; // find(QString,QPixmap&)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_KEY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // find(QPixmapCache::Key&)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
            overloadId = 1; // find(QPixmapCache::Key,QPixmap*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapCacheFunc_find_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // find(QPixmapCache::Key & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmapCache::Key cppArg0_local;
            ::QPixmapCache::Key *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_KEY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // find(QPixmapCache::Key&)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qpixmapcache-find)]
                QPixmap p;
                if (cppSelf->find(*cppArg0, &p)) {
                    pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &p);
                } else {
                    pyResult = Py_None;
                    Py_INCREF(pyResult);
                }
                // END of custom code block [file: ../glue/qtgui.cpp (qpixmapcache-find)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // find(const QPixmapCache::Key & key, QPixmap * pixmap)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmapCache::Key cppArg0_local;
            ::QPixmapCache::Key *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_KEY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // find(QPixmapCache::Key,QPixmap*)
                bool cppResult = ::QPixmapCache::find(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // find(const QString & key)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // find(QString)
                QPixmap * cppResult = ::QPixmapCache::find(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPixmapCache.find(const QString & key) is deprecated", 1);
            break;
        }
        case 3: // find(const QString & key, QPixmap & pixmap)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // find(QString,QPixmap&)
                bool cppResult = ::QPixmapCache::find(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPixmapCache.find(const QString & key, QPixmap & pixmap) is deprecated", 1);
            break;
        }
        case 4: // find(const QString & key, QPixmap * pixmap)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // find(QString,QPixmap*)
                bool cppResult = ::QPixmapCache::find(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapCacheFunc_find_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapCacheFunc_insert(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmapCache.insert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insert", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QPixmapCache::insert(QPixmap)
    // 1: static QPixmapCache::insert(QString,QPixmap)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
        overloadId = 1; // insert(QString,QPixmap)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[0])))) {
        overloadId = 0; // insert(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapCacheFunc_insert_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insert(const QPixmap & pixmap)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // insert(QPixmap)
                QPixmapCache::Key cppResult = ::QPixmapCache::insert(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_KEY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // insert(const QString & key, const QPixmap & pixmap)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // insert(QString,QPixmap)
                bool cppResult = ::QPixmapCache::insert(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapCacheFunc_insert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapCacheFunc_remove(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmapCache.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QPixmapCache::remove(QPixmapCache::Key)
    // 1: static QPixmapCache::remove(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // remove(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_KEY_IDX]), (pyArg)))) {
        overloadId = 0; // remove(QPixmapCache::Key)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapCacheFunc_remove_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // remove(const QPixmapCache::Key & key)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPixmapCache::Key cppArg0_local;
            ::QPixmapCache::Key *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_KEY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // remove(QPixmapCache::Key)
                ::QPixmapCache::remove(*cppArg0);
            }
            break;
        }
        case 1: // remove(const QString & key)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // remove(QString)
                ::QPixmapCache::remove(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPixmapCacheFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapCacheFunc_replace(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmapCache.replace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QPixmapCache::replace(QPixmapCache::Key,QPixmap)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_KEY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
        overloadId = 0; // replace(QPixmapCache::Key,QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapCacheFunc_replace_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPixmapCache::Key cppArg0_local;
        ::QPixmapCache::Key *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_KEY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPixmap cppArg1_local;
        ::QPixmap *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // replace(QPixmapCache::Key,QPixmap)
            bool cppResult = ::QPixmapCache::replace(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapCacheFunc_replace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapCacheFunc_setCacheLimit(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmapCache.setCacheLimit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QPixmapCache::setCacheLimit(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCacheLimit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapCacheFunc_setCacheLimit_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCacheLimit(int)
            ::QPixmapCache::setCacheLimit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPixmapCacheFunc_setCacheLimit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyMethodDef Sbk_QPixmapCacheMethod_find = {
    "find", reinterpret_cast<PyCFunction>(Sbk_QPixmapCacheFunc_find), METH_VARARGS|METH_STATIC
};


static const char *Sbk_QPixmapCache_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPixmapCache_methods[] = {
    {"cacheLimit", reinterpret_cast<PyCFunction>(Sbk_QPixmapCacheFunc_cacheLimit), METH_NOARGS|METH_STATIC},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QPixmapCacheFunc_clear), METH_NOARGS|METH_STATIC},
    Sbk_QPixmapCacheMethod_find,
    {"insert", reinterpret_cast<PyCFunction>(Sbk_QPixmapCacheFunc_insert), METH_VARARGS|METH_STATIC},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QPixmapCacheFunc_remove), METH_O|METH_STATIC},
    {"replace", reinterpret_cast<PyCFunction>(Sbk_QPixmapCacheFunc_replace), METH_VARARGS|METH_STATIC},
    {"setCacheLimit", reinterpret_cast<PyCFunction>(Sbk_QPixmapCacheFunc_setCacheLimit), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QPixmapCache_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PyObject_GenericGetAttr(self, name);
    }
    static PyMethodDef non_static_Sbk_QPixmapCacheMethod_find = {
        Sbk_QPixmapCacheMethod_find.ml_name,
        Sbk_QPixmapCacheMethod_find.ml_meth,
        Sbk_QPixmapCacheMethod_find.ml_flags & (~METH_STATIC),
        Sbk_QPixmapCacheMethod_find.ml_doc,
    };
    if (Shiboken::String::compare(name, "find") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPixmapCacheMethod_find, self, 0);
    return PyObject_GenericGetAttr(self, name);
}

} // extern "C"

static int Sbk_QPixmapCache_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPixmapCache_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPixmapCache_Type = nullptr;
static SbkObjectType *Sbk_QPixmapCache_TypeF(void)
{
    return _Sbk_QPixmapCache_Type;
}

static PyType_Slot Sbk_QPixmapCache_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QPixmapCache_getattro)},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPixmapCache_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPixmapCache_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPixmapCache_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPixmapCache_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPixmapCache_spec = {
    "2:PySide2.QtGui.QPixmapCache",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPixmapCache_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPixmapCache_PythonToCpp_QPixmapCache_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPixmapCache_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPixmapCache_PythonToCpp_QPixmapCache_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPixmapCache_TypeF())))
        return QPixmapCache_PythonToCpp_QPixmapCache_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPixmapCache_PTR_CppToPython_QPixmapCache(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPixmapCache *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPixmapCache_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPixmapCache_SignatureStrings[] = {
    "PySide2.QtGui.QPixmapCache(self)",
    "PySide2.QtGui.QPixmapCache.cacheLimit()->int",
    "PySide2.QtGui.QPixmapCache.clear()",
    "4:PySide2.QtGui.QPixmapCache.find(self,arg__1:PySide2.QtGui.QPixmapCache.Key)",
    "3:PySide2.QtGui.QPixmapCache.find(key:PySide2.QtGui.QPixmapCache.Key,pixmap:PySide2.QtGui.QPixmap)->bool",
    "2:PySide2.QtGui.QPixmapCache.find(key:QString)->PySide2.QtGui.QPixmap",
    "1:PySide2.QtGui.QPixmapCache.find(key:QString,pixmap:PySide2.QtGui.QPixmap)->bool",
    "0:PySide2.QtGui.QPixmapCache.find(key:QString,pixmap:PySide2.QtGui.QPixmap)->bool",
    "1:PySide2.QtGui.QPixmapCache.insert(pixmap:PySide2.QtGui.QPixmap)->PySide2.QtGui.QPixmapCache.Key",
    "0:PySide2.QtGui.QPixmapCache.insert(key:QString,pixmap:PySide2.QtGui.QPixmap)->bool",
    "1:PySide2.QtGui.QPixmapCache.remove(key:PySide2.QtGui.QPixmapCache.Key)",
    "0:PySide2.QtGui.QPixmapCache.remove(key:QString)",
    "PySide2.QtGui.QPixmapCache.replace(key:PySide2.QtGui.QPixmapCache.Key,pixmap:PySide2.QtGui.QPixmap)->bool",
    "PySide2.QtGui.QPixmapCache.setCacheLimit(arg__1:int)",
    nullptr}; // Sentinel

void init_QPixmapCache(PyObject *module)
{
    _Sbk_QPixmapCache_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPixmapCache",
        "QPixmapCache*",
        &Sbk_QPixmapCache_spec,
        &Shiboken::callCppDestructor< ::QPixmapCache >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPixmapCache_Type);
    InitSignatureStrings(pyType, QPixmapCache_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPixmapCache_Type), Sbk_QPixmapCache_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPixmapCache_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPixmapCache_TypeF(),
        QPixmapCache_PythonToCpp_QPixmapCache_PTR,
        is_QPixmapCache_PythonToCpp_QPixmapCache_PTR_Convertible,
        QPixmapCache_PTR_CppToPython_QPixmapCache);

    Shiboken::Conversions::registerConverterName(converter, "QPixmapCache");
    Shiboken::Conversions::registerConverterName(converter, "QPixmapCache*");
    Shiboken::Conversions::registerConverterName(converter, "QPixmapCache&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPixmapCache).name());


}
