/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpainter_wrapper.h"

// inner classes
#include "qpainter_pixmapfragment_wrapper.h"

// Extra includes
#include <QPainter>
#include <QPainterPath>
#include <QPixmap>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qfont.h>
#include <QtGui/qfontinfo.h>
#include <QtGui/qfontmetrics.h>
#include <QtGui/qimage.h>
#include <QtGui/qmatrix.h>
#include <QtGui/qpaintdevice.h>
#include <QtGui/qpaintengine.h>
#include <QtGui/qpainterpath.h>
#include <QtGui/qpen.h>
#include <QtGui/qpicture.h>
#include <QtGui/qpixmap.h>
#include <QtGui/qpolygon.h>
#include <QtGui/qregion.h>
#include <QtGui/qstatictext.h>
#include <QtGui/qtextoption.h>
#include <QtGui/qtransform.h>
#include <qline.h>
#include <qobject.h>
#include <qpoint.h>
#include <qrect.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPainter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPainter >()))
        return -1;

    ::QPainter *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPainter", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPainter::QPainter()
    // 1: QPainter::QPainter(QPaintDevice*)
    if (numArgs == 0) {
        overloadId = 0; // QPainter()
    } else if (numArgs == 1
        && (pyArgs[0] != Py_None && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArgs[0]))))) {
        overloadId = 1; // QPainter(QPaintDevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainter_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPainter()
        {

            if (!PyErr_Occurred()) {
                // QPainter()
                cptr = new ::QPainter();
            }
            break;
        }
        case 1: // QPainter(QPaintDevice * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPaintDevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QPainter(QPaintDevice*)
                cptr = new ::QPainter(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPainter >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPainter_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPainter_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPainterFunc_background(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.background";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // background()const
            const QBrush & cppResult = const_cast<const ::QPainter *>(cppSelf)->background();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_backgroundMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.backgroundMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backgroundMode()const
            Qt::BGMode cppResult = const_cast<const ::QPainter *>(cppSelf)->backgroundMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_begin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.begin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::begin(QPaintDevice*)
    if ((pyArg != Py_None && (pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArg))))) {
        overloadId = 0; // begin(QPaintDevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_begin_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintDevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // begin(QPaintDevice*)
            bool cppResult = cppSelf->begin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPainterFunc_begin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_beginNativePainting(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.beginNativePainting";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // beginNativePainting()
            cppSelf->beginNativePainting();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPainterFunc_boundingRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.boundingRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_boundingRect_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_boundingRect_TypeError;
    } else if (numArgs == 4 || numArgs == 5)
        goto Sbk_QPainterFunc_boundingRect_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOO:boundingRect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::boundingRect(QRect,int,QString)
    // 1: QPainter::boundingRect(QRectF,QString,QTextOption)
    // 2: QPainter::boundingRect(QRectF,int,QString)
    // 3: QPainter::boundingRect(int,int,int,int,int,QString)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
        overloadId = 3; // boundingRect(int,int,int,int,int,QString)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // boundingRect(QRect,int,QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            overloadId = 2; // boundingRect(QRectF,int,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // boundingRect(QRectF,QString,QTextOption)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), (pyArgs[2])))) {
                overloadId = 1; // boundingRect(QRectF,QString,QTextOption)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_boundingRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // boundingRect(const QRect & rect, int flags, const QString & text)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_boundingRect_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // boundingRect(QRect,int,QString)
                QRect cppResult = cppSelf->boundingRect(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
            }
            break;
        }
        case 1: // boundingRect(const QRectF & rect, const QString & text, const QTextOption & o)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_o = Shiboken::String::createStaticString("o");
                if (PyDict_Contains(kwds, key_o)) {
                    value = PyDict_GetItem(kwds, key_o);
                    if (value && pyArgs[2]) {
                        errInfo = key_o;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_boundingRect_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), (pyArgs[2]))))
                            goto Sbk_QPainterFunc_boundingRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_o);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_boundingRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QTextOption cppArg2_local = QTextOption();
            ::QTextOption *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // boundingRect(QRectF,QString,QTextOption)
                QRectF cppResult = cppSelf->boundingRect(*cppArg0, cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
        case 2: // boundingRect(const QRectF & rect, int flags, const QString & text)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_boundingRect_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // boundingRect(QRectF,int,QString)
                QRectF cppResult = cppSelf->boundingRect(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
        case 3: // boundingRect(int x, int y, int w, int h, int flags, const QString & text)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_boundingRect_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // boundingRect(int,int,int,int,int,QString)
                QRect cppResult = cppSelf->boundingRect(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPainterFunc_boundingRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_brush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.brush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brush()const
            const QBrush & cppResult = const_cast<const ::QPainter *>(cppSelf)->brush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_brushOrigin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.brushOrigin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brushOrigin()const
            QPoint cppResult = const_cast<const ::QPainter *>(cppSelf)->brushOrigin();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_clipBoundingRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.clipBoundingRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipBoundingRect()const
            QRectF cppResult = const_cast<const ::QPainter *>(cppSelf)->clipBoundingRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_clipPath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.clipPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipPath()const
            QPainterPath cppResult = const_cast<const ::QPainter *>(cppSelf)->clipPath();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_clipRegion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.clipRegion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipRegion()const
            QRegion cppResult = const_cast<const ::QPainter *>(cppSelf)->clipRegion();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_combinedMatrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.combinedMatrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // combinedMatrix()const
            QMatrix cppResult = const_cast<const ::QPainter *>(cppSelf)->combinedMatrix();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_combinedTransform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.combinedTransform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // combinedTransform()const
            QTransform cppResult = const_cast<const ::QPainter *>(cppSelf)->combinedTransform();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_compositionMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.compositionMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // compositionMode()const
            QPainter::CompositionMode cppResult = const_cast<const ::QPainter *>(cppSelf)->compositionMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QPaintDevice * cppResult = const_cast<const ::QPainter *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_deviceMatrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.deviceMatrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deviceMatrix()const
            const QMatrix & cppResult = const_cast<const ::QPainter *>(cppSelf)->deviceMatrix();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_deviceTransform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.deviceTransform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deviceTransform()const
            const QTransform & cppResult = const_cast<const ::QPainter *>(cppSelf)->deviceTransform();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_drawArc(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawArc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto Sbk_QPainterFunc_drawArc_TypeError;

    if (!PyArg_UnpackTuple(args, "drawArc", 3, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawArc(QRect,int,int)
    // 1: QPainter::drawArc(QRectF,int,int)
    // 2: QPainter::drawArc(int,int,int,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 2; // drawArc(int,int,int,int,int,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // drawArc(QRect,int,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 1; // drawArc(QRectF,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawArc_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawArc(const QRect & arg__1, int a, int alen)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawArc(QRect,int,int)
                cppSelf->drawArc(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // drawArc(const QRectF & rect, int a, int alen)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawArc(QRectF,int,int)
                cppSelf->drawArc(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // drawArc(int x, int y, int w, int h, int a, int alen)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // drawArc(int,int,int,int,int,int)
                cppSelf->drawArc(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawArc_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawChord(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawChord";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto Sbk_QPainterFunc_drawChord_TypeError;

    if (!PyArg_UnpackTuple(args, "drawChord", 3, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawChord(QRect,int,int)
    // 1: QPainter::drawChord(QRectF,int,int)
    // 2: QPainter::drawChord(int,int,int,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 2; // drawChord(int,int,int,int,int,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // drawChord(QRect,int,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 1; // drawChord(QRectF,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawChord_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawChord(const QRect & arg__1, int a, int alen)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawChord(QRect,int,int)
                cppSelf->drawChord(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // drawChord(const QRectF & rect, int a, int alen)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawChord(QRectF,int,int)
                cppSelf->drawChord(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // drawChord(int x, int y, int w, int h, int a, int alen)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // drawChord(int,int,int,int,int,int)
                cppSelf->drawChord(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawChord_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawConvexPolygon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawConvexPolygon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::drawConvexPolygon(QVector<QPoint>)
    // 1: QPainter::drawConvexPolygon(QVector<QPointF>)
    // 2: QPainter::drawConvexPolygon(QPolygon)
    // 3: QPainter::drawConvexPolygon(QPolygonF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINT_IDX], (pyArg)))) {
        overloadId = 0; // drawConvexPolygon(QVector<QPoint>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGON_IDX]), (pyArg)))) {
        overloadId = 2; // drawConvexPolygon(QPolygon)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], (pyArg)))) {
        overloadId = 1; // drawConvexPolygon(QVector<QPointF>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), (pyArg)))) {
        overloadId = 3; // drawConvexPolygon(QPolygonF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawConvexPolygon_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawConvexPolygon(QVector<QPoint > arg__1)
        {
            ::QVector<QPoint > cppArg0;
            pythonToCpp(pyArg, &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // drawConvexPolygon(QVector<QPoint>)
                // Begin code injection
                // TEMPLATE - qpainter_drawlist - START
                cppSelf->drawConvexPolygon(cppArg0.data(), cppArg0.size());
                // TEMPLATE - qpainter_drawlist - END

                // End of code injection

            }
            break;
        }
        case 1: // drawConvexPolygon(QVector<QPointF > arg__1)
        {
            ::QVector<QPointF > cppArg0;
            pythonToCpp(pyArg, &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // drawConvexPolygon(QVector<QPointF>)
                // Begin code injection
                // TEMPLATE - qpainter_drawlist - START
                cppSelf->drawConvexPolygon(cppArg0.data(), cppArg0.size());
                // TEMPLATE - qpainter_drawlist - END

                // End of code injection

            }
            break;
        }
        case 2: // drawConvexPolygon(const QPolygon & polygon)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPolygon cppArg0_local;
            ::QPolygon *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGON_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // drawConvexPolygon(QPolygon)
                cppSelf->drawConvexPolygon(*cppArg0);
            }
            break;
        }
        case 3: // drawConvexPolygon(const QPolygonF & polygon)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPolygonF cppArg0_local;
            ::QPolygonF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // drawConvexPolygon(QPolygonF)
                cppSelf->drawConvexPolygon(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawConvexPolygon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawEllipse(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawEllipse";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto Sbk_QPainterFunc_drawEllipse_TypeError;

    if (!PyArg_UnpackTuple(args, "drawEllipse", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawEllipse(QPoint,int,int)
    // 1: QPainter::drawEllipse(QPointF,qreal,qreal)
    // 2: QPainter::drawEllipse(QRect)
    // 3: QPainter::drawEllipse(QRectF)
    // 4: QPainter::drawEllipse(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 4; // drawEllipse(int,int,int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // drawEllipse(QRect)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 3; // drawEllipse(QRectF)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // drawEllipse(QPoint,int,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        overloadId = 1; // drawEllipse(QPointF,qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawEllipse_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawEllipse(const QPoint & center, int rx, int ry)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawEllipse(QPoint,int,int)
                cppSelf->drawEllipse(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // drawEllipse(const QPointF & center, qreal rx, qreal ry)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawEllipse(QPointF,qreal,qreal)
                cppSelf->drawEllipse(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // drawEllipse(const QRect & r)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // drawEllipse(QRect)
                cppSelf->drawEllipse(*cppArg0);
            }
            break;
        }
        case 3: // drawEllipse(const QRectF & r)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // drawEllipse(QRectF)
                cppSelf->drawEllipse(*cppArg0);
            }
            break;
        }
        case 4: // drawEllipse(int x, int y, int w, int h)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // drawEllipse(int,int,int,int)
                cppSelf->drawEllipse(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawEllipse_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 8) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawImage_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawImage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOOO:drawImage", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawImage(QPoint,QImage)
    // 1: QPainter::drawImage(QPoint,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
    // 2: QPainter::drawImage(QPointF,QImage)
    // 3: QPainter::drawImage(QPointF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
    // 4: QPainter::drawImage(QRect,QImage)
    // 5: QPainter::drawImage(QRect,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
    // 6: QPainter::drawImage(QRectF,QImage)
    // 7: QPainter::drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
    // 8: QPainter::drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 8; // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 8; // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 8; // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                    if (numArgs == 6) {
                        overloadId = 8; // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                    } else if (numArgs >= 7
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
                        if (numArgs == 7) {
                            overloadId = 8; // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                        } else if (numArgs >= 8
                            && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[7])))) {
                            overloadId = 8; // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                        }
                    }
                }
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 4; // drawImage(QRect,QImage)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 5; // drawImage(QRect,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3])))) {
                overloadId = 5; // drawImage(QRect,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 6; // drawImage(QRectF,QImage)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 7; // drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3])))) {
                overloadId = 7; // drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // drawImage(QPoint,QImage)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // drawImage(QPoint,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3])))) {
                overloadId = 1; // drawImage(QPoint,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // drawImage(QPointF,QImage)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 3; // drawImage(QPointF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3])))) {
                overloadId = 3; // drawImage(QPointF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawImage_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawImage(const QPoint & p, const QImage & image)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawImage_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QImage cppArg1_local;
            ::QImage *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawImage(QPoint,QImage)
                cppSelf->drawImage(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // drawImage(const QPoint & p, const QImage & image, const QRect & sr, QFlags<Qt::ImageConversionFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[3]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawImage_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QImage cppArg1_local;
            ::QImage *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QRect cppArg2_local;
            ::QRect *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            ::QFlags<Qt::ImageConversionFlag> cppArg3 = Qt::AutoColor;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // drawImage(QPoint,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
                cppSelf->drawImage(*cppArg0, *cppArg1, *cppArg2, cppArg3);
            }
            break;
        }
        case 2: // drawImage(const QPointF & p, const QImage & image)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawImage_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QImage cppArg1_local;
            ::QImage *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawImage(QPointF,QImage)
                cppSelf->drawImage(*cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // drawImage(const QPointF & p, const QImage & image, const QRectF & sr, QFlags<Qt::ImageConversionFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[3]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawImage_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QImage cppArg1_local;
            ::QImage *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QRectF cppArg2_local;
            ::QRectF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            ::QFlags<Qt::ImageConversionFlag> cppArg3 = Qt::AutoColor;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // drawImage(QPointF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
                cppSelf->drawImage(*cppArg0, *cppArg1, *cppArg2, cppArg3);
            }
            break;
        }
        case 4: // drawImage(const QRect & r, const QImage & image)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawImage_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QImage cppArg1_local;
            ::QImage *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawImage(QRect,QImage)
                cppSelf->drawImage(*cppArg0, *cppArg1);
            }
            break;
        }
        case 5: // drawImage(const QRect & targetRect, const QImage & image, const QRect & sourceRect, QFlags<Qt::ImageConversionFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[3]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawImage_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QImage cppArg1_local;
            ::QImage *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QRect cppArg2_local;
            ::QRect *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            ::QFlags<Qt::ImageConversionFlag> cppArg3 = Qt::AutoColor;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // drawImage(QRect,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
                cppSelf->drawImage(*cppArg0, *cppArg1, *cppArg2, cppArg3);
            }
            break;
        }
        case 6: // drawImage(const QRectF & r, const QImage & image)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawImage_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QImage cppArg1_local;
            ::QImage *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawImage(QRectF,QImage)
                cppSelf->drawImage(*cppArg0, *cppArg1);
            }
            break;
        }
        case 7: // drawImage(const QRectF & targetRect, const QImage & image, const QRectF & sourceRect, QFlags<Qt::ImageConversionFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[3]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawImage_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QImage cppArg1_local;
            ::QImage *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QRectF cppArg2_local;
            ::QRectF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            ::QFlags<Qt::ImageConversionFlag> cppArg3 = Qt::AutoColor;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
                cppSelf->drawImage(*cppArg0, *cppArg1, *cppArg2, cppArg3);
            }
            break;
        }
        case 8: // drawImage(int x, int y, const QImage & image, int sx, int sy, int sw, int sh, QFlags<Qt::ImageConversionFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_sx = Shiboken::String::createStaticString("sx");
                if (PyDict_Contains(kwds, key_sx)) {
                    value = PyDict_GetItem(kwds, key_sx);
                    if (value && pyArgs[3]) {
                        errInfo = key_sx;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sx);
                }
                static PyObject *const key_sy = Shiboken::String::createStaticString("sy");
                if (PyDict_Contains(kwds, key_sy)) {
                    value = PyDict_GetItem(kwds, key_sy);
                    if (value && pyArgs[4]) {
                        errInfo = key_sy;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sy);
                }
                static PyObject *const key_sw = Shiboken::String::createStaticString("sw");
                if (PyDict_Contains(kwds, key_sw)) {
                    value = PyDict_GetItem(kwds, key_sw);
                    if (value && pyArgs[5]) {
                        errInfo = key_sw;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                            goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sw);
                }
                static PyObject *const key_sh = Shiboken::String::createStaticString("sh");
                if (PyDict_Contains(kwds, key_sh)) {
                    value = PyDict_GetItem(kwds, key_sh);
                    if (value && pyArgs[6]) {
                        errInfo = key_sh;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6]))))
                            goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sh);
                }
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[7]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[7]))))
                            goto Sbk_QPainterFunc_drawImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawImage_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QImage cppArg2_local;
            ::QImage *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            int cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5 = -1;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6 = -1;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QFlags<Qt::ImageConversionFlag> cppArg7 = Qt::AutoColor;
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);

            if (!PyErr_Occurred()) {
                // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                cppSelf->drawImage(cppArg0, cppArg1, *cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawLine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto Sbk_QPainterFunc_drawLine_TypeError;

    if (!PyArg_UnpackTuple(args, "drawLine", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawLine(QLine)
    // 1: QPainter::drawLine(QLineF)
    // 2: QPainter::drawLine(QPoint,QPoint)
    // 3: QPainter::drawLine(QPointF,QPointF)
    // 4: QPainter::drawLine(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 4; // drawLine(int,int,int,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
        overloadId = 2; // drawLine(QPoint,QPoint)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
        overloadId = 3; // drawLine(QPointF,QPointF)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // drawLine(QLine)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArgs[0])))) {
        overloadId = 1; // drawLine(QLineF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawLine_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawLine(const QLine & line)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QLine cppArg0_local;
            ::QLine *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // drawLine(QLine)
                cppSelf->drawLine(*cppArg0);
            }
            break;
        }
        case 1: // drawLine(const QLineF & line)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QLineF cppArg0_local;
            ::QLineF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // drawLine(QLineF)
                cppSelf->drawLine(*cppArg0);
            }
            break;
        }
        case 2: // drawLine(const QPoint & p1, const QPoint & p2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawLine(QPoint,QPoint)
                cppSelf->drawLine(*cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // drawLine(const QPointF & p1, const QPointF & p2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawLine(QPointF,QPointF)
                cppSelf->drawLine(*cppArg0, *cppArg1);
            }
            break;
        }
        case 4: // drawLine(int x1, int y1, int x2, int y2)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // drawLine(int,int,int,int)
                cppSelf->drawLine(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawLines(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawLines";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::drawLines(QVector<QLine>)
    // 1: QPainter::drawLines(QVector<QLineF>)
    // 2: QPainter::drawLines(QVector<QPoint>)
    // 3: QPainter::drawLines(QVector<QPointF>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINT_IDX], (pyArg)))) {
        overloadId = 2; // drawLines(QVector<QPoint>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], (pyArg)))) {
        overloadId = 3; // drawLines(QVector<QPointF>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINE_IDX], (pyArg)))) {
        overloadId = 0; // drawLines(QVector<QLine>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINEF_IDX], (pyArg)))) {
        overloadId = 1; // drawLines(QVector<QLineF>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawLines_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawLines(const QVector<QLine > & lines)
        {
            ::QVector<QLine > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // drawLines(QVector<QLine>)
                cppSelf->drawLines(cppArg0);
            }
            break;
        }
        case 1: // drawLines(const QVector<QLineF > & lines)
        {
            ::QVector<QLineF > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // drawLines(QVector<QLineF>)
                cppSelf->drawLines(cppArg0);
            }
            break;
        }
        case 2: // drawLines(const QVector<QPoint > & pointPairs)
        {
            ::QVector<QPoint > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // drawLines(QVector<QPoint>)
                cppSelf->drawLines(cppArg0);
            }
            break;
        }
        case 3: // drawLines(const QVector<QPointF > & pointPairs)
        {
            ::QVector<QPointF > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // drawLines(QVector<QPointF>)
                cppSelf->drawLines(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawLines_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::drawPath(QPainterPath)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), (pyArg)))) {
        overloadId = 0; // drawPath(QPainterPath)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawPath_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPainterPath cppArg0_local;
        ::QPainterPath *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // drawPath(QPainterPath)
            cppSelf->drawPath(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawPicture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawPicture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawPicture", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawPicture(QPoint,QPicture)
    // 1: QPainter::drawPicture(QPointF,QPicture)
    // 2: QPainter::drawPicture(int,int,QPicture)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPICTURE_IDX]), (pyArgs[2])))) {
        overloadId = 2; // drawPicture(int,int,QPicture)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPICTURE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // drawPicture(QPoint,QPicture)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPICTURE_IDX]), (pyArgs[1])))) {
        overloadId = 1; // drawPicture(QPointF,QPicture)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawPicture_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawPicture(const QPoint & p, const QPicture & picture)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPicture cppArg1_local;
            ::QPicture *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPICTURE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawPicture(QPoint,QPicture)
                cppSelf->drawPicture(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // drawPicture(const QPointF & p, const QPicture & picture)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPicture cppArg1_local;
            ::QPicture *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPICTURE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawPicture(QPointF,QPicture)
                cppSelf->drawPicture(*cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // drawPicture(int x, int y, const QPicture & picture)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QPicture cppArg2_local;
            ::QPicture *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPICTURE_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // drawPicture(int,int,QPicture)
                cppSelf->drawPicture(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawPicture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawPie(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawPie";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto Sbk_QPainterFunc_drawPie_TypeError;

    if (!PyArg_UnpackTuple(args, "drawPie", 3, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawPie(QRect,int,int)
    // 1: QPainter::drawPie(QRectF,int,int)
    // 2: QPainter::drawPie(int,int,int,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 2; // drawPie(int,int,int,int,int,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // drawPie(QRect,int,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 1; // drawPie(QRectF,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawPie_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawPie(const QRect & arg__1, int a, int alen)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawPie(QRect,int,int)
                cppSelf->drawPie(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // drawPie(const QRectF & rect, int a, int alen)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawPie(QRectF,int,int)
                cppSelf->drawPie(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // drawPie(int x, int y, int w, int h, int a, int alen)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // drawPie(int,int,int,int,int,int)
                cppSelf->drawPie(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawPie_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawPixmap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 6 || numArgs == 8)
        goto Sbk_QPainterFunc_drawPixmap_TypeError;

    if (!PyArg_UnpackTuple(args, "drawPixmap", 2, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawPixmap(QPoint,QPixmap)
    // 1: QPainter::drawPixmap(QPoint,QPixmap,QRect)
    // 2: QPainter::drawPixmap(QPointF,QPixmap)
    // 3: QPainter::drawPixmap(QPointF,QPixmap,QRectF)
    // 4: QPainter::drawPixmap(QRect,QPixmap)
    // 5: QPainter::drawPixmap(QRect,QPixmap,QRect)
    // 6: QPainter::drawPixmap(QRectF,QPixmap,QRectF)
    // 7: QPainter::drawPixmap(int,int,QPixmap)
    // 8: QPainter::drawPixmap(int,int,QPixmap,int,int,int,int)
    // 9: QPainter::drawPixmap(int,int,int,int,QPixmap)
    // 10: QPainter::drawPixmap(int,int,int,int,QPixmap,int,int,int,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs >= 5
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 9; // drawPixmap(int,int,int,int,QPixmap)
            } else if (numArgs == 9
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
                && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
                && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[8])))) {
                overloadId = 10; // drawPixmap(int,int,int,int,QPixmap,int,int,int,int)
            }
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 7; // drawPixmap(int,int,QPixmap)
            } else if (numArgs == 7
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
                overloadId = 8; // drawPixmap(int,int,QPixmap,int,int,int,int)
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 4; // drawPixmap(QRect,QPixmap)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[2])))) {
            overloadId = 5; // drawPixmap(QRect,QPixmap,QRect)
        }
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[2])))) {
        overloadId = 6; // drawPixmap(QRectF,QPixmap,QRectF)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // drawPixmap(QPoint,QPixmap)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[2])))) {
            overloadId = 1; // drawPixmap(QPoint,QPixmap,QRect)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // drawPixmap(QPointF,QPixmap)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[2])))) {
            overloadId = 3; // drawPixmap(QPointF,QPixmap,QRectF)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawPixmap_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawPixmap(const QPoint & p, const QPixmap & pm)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawPixmap(QPoint,QPixmap)
                cppSelf->drawPixmap(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // drawPixmap(const QPoint & p, const QPixmap & pm, const QRect & sr)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QRect cppArg2_local;
            ::QRect *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // drawPixmap(QPoint,QPixmap,QRect)
                cppSelf->drawPixmap(*cppArg0, *cppArg1, *cppArg2);
            }
            break;
        }
        case 2: // drawPixmap(const QPointF & p, const QPixmap & pm)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawPixmap(QPointF,QPixmap)
                cppSelf->drawPixmap(*cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // drawPixmap(const QPointF & p, const QPixmap & pm, const QRectF & sr)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QRectF cppArg2_local;
            ::QRectF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // drawPixmap(QPointF,QPixmap,QRectF)
                cppSelf->drawPixmap(*cppArg0, *cppArg1, *cppArg2);
            }
            break;
        }
        case 4: // drawPixmap(const QRect & r, const QPixmap & pm)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawPixmap(QRect,QPixmap)
                cppSelf->drawPixmap(*cppArg0, *cppArg1);
            }
            break;
        }
        case 5: // drawPixmap(const QRect & targetRect, const QPixmap & pixmap, const QRect & sourceRect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QRect cppArg2_local;
            ::QRect *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // drawPixmap(QRect,QPixmap,QRect)
                cppSelf->drawPixmap(*cppArg0, *cppArg1, *cppArg2);
            }
            break;
        }
        case 6: // drawPixmap(const QRectF & targetRect, const QPixmap & pixmap, const QRectF & sourceRect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QRectF cppArg2_local;
            ::QRectF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // drawPixmap(QRectF,QPixmap,QRectF)
                cppSelf->drawPixmap(*cppArg0, *cppArg1, *cppArg2);
            }
            break;
        }
        case 7: // drawPixmap(int x, int y, const QPixmap & pm)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QPixmap cppArg2_local;
            ::QPixmap *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // drawPixmap(int,int,QPixmap)
                cppSelf->drawPixmap(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 8: // drawPixmap(int x, int y, const QPixmap & pm, int sx, int sy, int sw, int sh)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QPixmap cppArg2_local;
            ::QPixmap *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // drawPixmap(int,int,QPixmap,int,int,int,int)
                cppSelf->drawPixmap(cppArg0, cppArg1, *cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
            }
            break;
        }
        case 9: // drawPixmap(int x, int y, int w, int h, const QPixmap & pm)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QPixmap cppArg4_local;
            ::QPixmap *cppArg4 = &cppArg4_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);


            if (!PyErr_Occurred()) {
                // drawPixmap(int,int,int,int,QPixmap)
                cppSelf->drawPixmap(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            }
            break;
        }
        case 10: // drawPixmap(int x, int y, int w, int h, const QPixmap & pm, int sx, int sy, int sw, int sh)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QPixmap cppArg4_local;
            ::QPixmap *cppArg4 = &cppArg4_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);

            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            int cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            int cppArg8;
            pythonToCpp[8](pyArgs[8], &cppArg8);

            if (!PyErr_Occurred()) {
                // drawPixmap(int,int,int,int,QPixmap,int,int,int,int)
                cppSelf->drawPixmap(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawPixmapFragments(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawPixmapFragments";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawPixmapFragments_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawPixmapFragments_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:drawPixmapFragments", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawPixmapFragments(const QPainter::PixmapFragment*,int,QPixmap,QFlags<QPainter::PixmapFragmentHint>)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // drawPixmapFragments(const QPainter::PixmapFragment*,int,QPixmap,QFlags<QPainter::PixmapFragmentHint>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX])->converter, (pyArgs[3])))) {
            overloadId = 0; // drawPixmapFragments(const QPainter::PixmapFragment*,int,QPixmap,QFlags<QPainter::PixmapFragmentHint>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawPixmapFragments_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_hints = Shiboken::String::createStaticString("hints");
            if (PyDict_Contains(kwds, key_hints)) {
                value = PyDict_GetItem(kwds, key_hints);
                if (value && pyArgs[3]) {
                    errInfo = key_hints;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_drawPixmapFragments_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QPainterFunc_drawPixmapFragments_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_hints);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_drawPixmapFragments_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter::PixmapFragment *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPixmap cppArg2_local;
        ::QPixmap *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        ::QFlags<QPainter::PixmapFragmentHint> cppArg3 = QPainter::PixmapFragmentHints();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // drawPixmapFragments(const QPainter::PixmapFragment*,int,QPixmap,QFlags<QPainter::PixmapFragmentHint>)
            cppSelf->drawPixmapFragments(cppArg0, cppArg1, *cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawPixmapFragments_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawPoint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawPoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawPoint", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawPoint(QPoint)
    // 1: QPainter::drawPoint(QPointF)
    // 2: QPainter::drawPoint(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 2; // drawPoint(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // drawPoint(QPoint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        overloadId = 1; // drawPoint(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawPoint_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawPoint(const QPoint & p)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // drawPoint(QPoint)
                cppSelf->drawPoint(*cppArg0);
            }
            break;
        }
        case 1: // drawPoint(const QPointF & pt)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // drawPoint(QPointF)
                cppSelf->drawPoint(*cppArg0);
            }
            break;
        }
        case 2: // drawPoint(int x, int y)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawPoint(int,int)
                cppSelf->drawPoint(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawPoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawPoints(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawPoints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::drawPoints(QVector<QPoint>)
    // 1: QPainter::drawPoints(QVector<QPointF>)
    // 2: QPainter::drawPoints(QPolygon)
    // 3: QPainter::drawPoints(QPolygonF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGON_IDX]), (pyArg)))) {
        overloadId = 2; // drawPoints(QPolygon)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), (pyArg)))) {
        overloadId = 3; // drawPoints(QPolygonF)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINT_IDX], (pyArg)))) {
        overloadId = 0; // drawPoints(QVector<QPoint>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], (pyArg)))) {
        overloadId = 1; // drawPoints(QVector<QPointF>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawPoints_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawPoints(QVector<QPoint > arg__1)
        {
            ::QVector<QPoint > cppArg0;
            pythonToCpp(pyArg, &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // drawPoints(QVector<QPoint>)
                // Begin code injection
                // TEMPLATE - qpainter_drawlist - START
                cppSelf->drawPoints(cppArg0.data(), cppArg0.size());
                // TEMPLATE - qpainter_drawlist - END

                // End of code injection

            }
            break;
        }
        case 1: // drawPoints(QVector<QPointF > arg__1)
        {
            ::QVector<QPointF > cppArg0;
            pythonToCpp(pyArg, &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // drawPoints(QVector<QPointF>)
                // Begin code injection
                // TEMPLATE - qpainter_drawlist - START
                cppSelf->drawPoints(cppArg0.data(), cppArg0.size());
                // TEMPLATE - qpainter_drawlist - END

                // End of code injection

            }
            break;
        }
        case 2: // drawPoints(const QPolygon & points)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPolygon cppArg0_local;
            ::QPolygon *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGON_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // drawPoints(QPolygon)
                cppSelf->drawPoints(*cppArg0);
            }
            break;
        }
        case 3: // drawPoints(const QPolygonF & points)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPolygonF cppArg0_local;
            ::QPolygonF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // drawPoints(QPolygonF)
                cppSelf->drawPoints(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawPoints_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawPolygon(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawPolygon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawPolygon_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawPolygon_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:drawPolygon", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawPolygon(QVector<QPoint>,Qt::FillRule)
    // 1: QPainter::drawPolygon(QVector<QPointF>,Qt::FillRule)
    // 2: QPainter::drawPolygon(QPolygon,Qt::FillRule)
    // 3: QPainter::drawPolygon(QPolygonF,Qt::FillRule)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINT_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // drawPolygon(QVector<QPoint>,Qt::FillRule)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGON_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // drawPolygon(QPolygon,Qt::FillRule)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 2; // drawPolygon(QPolygon,Qt::FillRule)
        }
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 1; // drawPolygon(QVector<QPointF>,Qt::FillRule)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // drawPolygon(QPolygonF,Qt::FillRule)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 3; // drawPolygon(QPolygonF,Qt::FillRule)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawPolygon_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawPolygon(QVector<QPoint > arg__1, Qt::FillRule arg__2)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawPolygon_TypeError;
            }
            ::QVector<QPoint > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            ::Qt::FillRule cppArg1{Qt::OddEvenFill};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // drawPolygon(QVector<QPoint>,Qt::FillRule)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qpainter-drawpolygon)]
                cppSelf->drawPolygon(cppArg0.data(), cppArg0.size(), cppArg1);
                // END of custom code block [file: ../glue/qtgui.cpp (qpainter-drawpolygon)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // drawPolygon(QVector<QPointF > arg__1, Qt::FillRule arg__2)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawPolygon_TypeError;
            }
            ::QVector<QPointF > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            ::Qt::FillRule cppArg1{Qt::OddEvenFill};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // drawPolygon(QVector<QPointF>,Qt::FillRule)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qpainter-drawpolygon)]
                cppSelf->drawPolygon(cppArg0.data(), cppArg0.size(), cppArg1);
                // END of custom code block [file: ../glue/qtgui.cpp (qpainter-drawpolygon)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 2: // drawPolygon(const QPolygon & polygon, Qt::FillRule fillRule)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_fillRule = Shiboken::String::createStaticString("fillRule");
                if (PyDict_Contains(kwds, key_fillRule)) {
                    value = PyDict_GetItem(kwds, key_fillRule);
                    if (value && pyArgs[1]) {
                        errInfo = key_fillRule;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawPolygon_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QPainterFunc_drawPolygon_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_fillRule);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawPolygon_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPolygon cppArg0_local;
            ::QPolygon *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGON_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::FillRule cppArg1 = Qt::OddEvenFill;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawPolygon(QPolygon,Qt::FillRule)
                cppSelf->drawPolygon(*cppArg0, cppArg1);
            }
            break;
        }
        case 3: // drawPolygon(const QPolygonF & polygon, Qt::FillRule fillRule)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_fillRule = Shiboken::String::createStaticString("fillRule");
                if (PyDict_Contains(kwds, key_fillRule)) {
                    value = PyDict_GetItem(kwds, key_fillRule);
                    if (value && pyArgs[1]) {
                        errInfo = key_fillRule;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawPolygon_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QPainterFunc_drawPolygon_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_fillRule);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawPolygon_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPolygonF cppArg0_local;
            ::QPolygonF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::FillRule cppArg1 = Qt::OddEvenFill;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawPolygon(QPolygonF,Qt::FillRule)
                cppSelf->drawPolygon(*cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawPolygon_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawPolyline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawPolyline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::drawPolyline(QVector<QPoint>)
    // 1: QPainter::drawPolyline(QVector<QPointF>)
    // 2: QPainter::drawPolyline(QPolygon)
    // 3: QPainter::drawPolyline(QPolygonF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGON_IDX]), (pyArg)))) {
        overloadId = 2; // drawPolyline(QPolygon)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), (pyArg)))) {
        overloadId = 3; // drawPolyline(QPolygonF)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINT_IDX], (pyArg)))) {
        overloadId = 0; // drawPolyline(QVector<QPoint>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], (pyArg)))) {
        overloadId = 1; // drawPolyline(QVector<QPointF>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawPolyline_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawPolyline(QVector<QPoint > arg__1)
        {
            ::QVector<QPoint > cppArg0;
            pythonToCpp(pyArg, &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // drawPolyline(QVector<QPoint>)
                // Begin code injection
                // TEMPLATE - qpainter_drawlist - START
                cppSelf->drawPolyline(cppArg0.data(), cppArg0.size());
                // TEMPLATE - qpainter_drawlist - END

                // End of code injection

            }
            break;
        }
        case 1: // drawPolyline(QVector<QPointF > arg__1)
        {
            ::QVector<QPointF > cppArg0;
            pythonToCpp(pyArg, &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // drawPolyline(QVector<QPointF>)
                // Begin code injection
                // TEMPLATE - qpainter_drawlist - START
                cppSelf->drawPolyline(cppArg0.data(), cppArg0.size());
                // TEMPLATE - qpainter_drawlist - END

                // End of code injection

            }
            break;
        }
        case 2: // drawPolyline(const QPolygon & polygon)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPolygon cppArg0_local;
            ::QPolygon *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGON_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // drawPolyline(QPolygon)
                cppSelf->drawPolyline(*cppArg0);
            }
            break;
        }
        case 3: // drawPolyline(const QPolygonF & polyline)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPolygonF cppArg0_local;
            ::QPolygonF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // drawPolyline(QPolygonF)
                cppSelf->drawPolyline(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawPolyline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QPainterFunc_drawRect_TypeError;

    if (!PyArg_UnpackTuple(args, "drawRect", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawRect(QRect)
    // 1: QPainter::drawRect(QRectF)
    // 2: QPainter::drawRect(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 2; // drawRect(int,int,int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // drawRect(QRect)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 1; // drawRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawRect(const QRect & rect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // drawRect(QRect)
                cppSelf->drawRect(*cppArg0);
            }
            break;
        }
        case 1: // drawRect(const QRectF & rect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // drawRect(QRectF)
                cppSelf->drawRect(*cppArg0);
            }
            break;
        }
        case 2: // drawRect(int x1, int y1, int w, int h)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // drawRect(int,int,int,int)
                cppSelf->drawRect(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawRects(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawRects";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::drawRects(QVector<QRect>)
    // 1: QPainter::drawRects(QVector<QRectF>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECT_IDX], (pyArg)))) {
        overloadId = 0; // drawRects(QVector<QRect>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECTF_IDX], (pyArg)))) {
        overloadId = 1; // drawRects(QVector<QRectF>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawRects_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawRects(const QVector<QRect > & rectangles)
        {
            ::QVector<QRect > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // drawRects(QVector<QRect>)
                cppSelf->drawRects(cppArg0);
            }
            break;
        }
        case 1: // drawRects(const QVector<QRectF > & rectangles)
        {
            ::QVector<QRectF > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // drawRects(QVector<QRectF>)
                cppSelf->drawRects(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawRects_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawRoundRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawRoundRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawRoundRect_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawRoundRect_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:drawRoundRect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawRoundRect(QRect,int,int)
    // 1: QPainter::drawRoundRect(QRectF,int,int)
    // 2: QPainter::drawRoundRect(int,int,int,int,int,int)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 2; // drawRoundRect(int,int,int,int,int,int)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 2; // drawRoundRect(int,int,int,int,int,int)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                overloadId = 2; // drawRoundRect(int,int,int,int,int,int)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // drawRoundRect(QRect,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // drawRoundRect(QRect,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // drawRoundRect(QRect,int,int)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // drawRoundRect(QRectF,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // drawRoundRect(QRectF,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 1; // drawRoundRect(QRectF,int,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawRoundRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawRoundRect(const QRect & r, int xround, int yround)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_xround = Shiboken::String::createStaticString("xround");
                if (PyDict_Contains(kwds, key_xround)) {
                    value = PyDict_GetItem(kwds, key_xround);
                    if (value && pyArgs[1]) {
                        errInfo = key_xround;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_xround);
                }
                static PyObject *const key_yround = Shiboken::String::createStaticString("yround");
                if (PyDict_Contains(kwds, key_yround)) {
                    value = PyDict_GetItem(kwds, key_yround);
                    if (value && pyArgs[2]) {
                        errInfo = key_yround;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_yround);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1 = 25;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 25;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawRoundRect(QRect,int,int)
                cppSelf->drawRoundRect(*cppArg0, cppArg1, cppArg2);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPainter.drawRoundRect(const QRect & r, int xround, int yround) is deprecated", 1);
            break;
        }
        case 1: // drawRoundRect(const QRectF & r, int xround, int yround)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_xround = Shiboken::String::createStaticString("xround");
                if (PyDict_Contains(kwds, key_xround)) {
                    value = PyDict_GetItem(kwds, key_xround);
                    if (value && pyArgs[1]) {
                        errInfo = key_xround;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_xround);
                }
                static PyObject *const key_yround = Shiboken::String::createStaticString("yround");
                if (PyDict_Contains(kwds, key_yround)) {
                    value = PyDict_GetItem(kwds, key_yround);
                    if (value && pyArgs[2]) {
                        errInfo = key_yround;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_yround);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1 = 25;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 25;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawRoundRect(QRectF,int,int)
                cppSelf->drawRoundRect(*cppArg0, cppArg1, cppArg2);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPainter.drawRoundRect(const QRectF & r, int xround, int yround) is deprecated", 1);
            break;
        }
        case 2: // drawRoundRect(int x, int y, int w, int h, int xRound, int yRound)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_xRound = Shiboken::String::createStaticString("xRound");
                if (PyDict_Contains(kwds, key_xRound)) {
                    value = PyDict_GetItem(kwds, key_xRound);
                    if (value && pyArgs[4]) {
                        errInfo = key_xRound;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_xRound);
                }
                static PyObject *const key_yRound = Shiboken::String::createStaticString("yRound");
                if (PyDict_Contains(kwds, key_yRound)) {
                    value = PyDict_GetItem(kwds, key_yRound);
                    if (value && pyArgs[5]) {
                        errInfo = key_yRound;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                            goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_yRound);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawRoundRect_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = 25;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5 = 25;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // drawRoundRect(int,int,int,int,int,int)
                cppSelf->drawRoundRect(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPainter.drawRoundRect(int x, int y, int w, int h, int xRound, int yRound) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawRoundRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawRoundedRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawRoundedRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
    } else if (numArgs == 5)
        goto Sbk_QPainterFunc_drawRoundedRect_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOO:drawRoundedRect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawRoundedRect(QRect,qreal,qreal,Qt::SizeMode)
    // 1: QPainter::drawRoundedRect(QRectF,qreal,qreal,Qt::SizeMode)
    // 2: QPainter::drawRoundedRect(int,int,int,int,qreal,qreal,Qt::SizeMode)
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 2; // drawRoundedRect(int,int,int,int,qreal,qreal,Qt::SizeMode)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX])->converter, (pyArgs[6])))) {
            overloadId = 2; // drawRoundedRect(int,int,int,int,qreal,qreal,Qt::SizeMode)
        }
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // drawRoundedRect(QRect,qreal,qreal,Qt::SizeMode)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX])->converter, (pyArgs[3])))) {
            overloadId = 0; // drawRoundedRect(QRect,qreal,qreal,Qt::SizeMode)
        }
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 1; // drawRoundedRect(QRectF,qreal,qreal,Qt::SizeMode)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX])->converter, (pyArgs[3])))) {
            overloadId = 1; // drawRoundedRect(QRectF,qreal,qreal,Qt::SizeMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawRoundedRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawRoundedRect(const QRect & rect, qreal xRadius, qreal yRadius, Qt::SizeMode mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[3]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::Qt::SizeMode cppArg3 = Qt::AbsoluteSize;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // drawRoundedRect(QRect,qreal,qreal,Qt::SizeMode)
                cppSelf->drawRoundedRect(*cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // drawRoundedRect(const QRectF & rect, qreal xRadius, qreal yRadius, Qt::SizeMode mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[3]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::Qt::SizeMode cppArg3 = Qt::AbsoluteSize;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // drawRoundedRect(QRectF,qreal,qreal,Qt::SizeMode)
                cppSelf->drawRoundedRect(*cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // drawRoundedRect(int x, int y, int w, int h, qreal xRadius, qreal yRadius, Qt::SizeMode mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[6]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX])->converter, (pyArgs[6]))))
                            goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawRoundedRect_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            qreal cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            qreal cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::Qt::SizeMode cppArg6 = Qt::AbsoluteSize;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // drawRoundedRect(int,int,int,int,qreal,qreal,Qt::SizeMode)
                cppSelf->drawRoundedRect(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawRoundedRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawStaticText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawStaticText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawStaticText", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawStaticText(QPoint,QStaticText)
    // 1: QPainter::drawStaticText(QPointF,QStaticText)
    // 2: QPainter::drawStaticText(int,int,QStaticText)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), (pyArgs[2])))) {
        overloadId = 2; // drawStaticText(int,int,QStaticText)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // drawStaticText(QPoint,QStaticText)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), (pyArgs[1])))) {
        overloadId = 1; // drawStaticText(QPointF,QStaticText)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawStaticText_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawStaticText(const QPoint & topLeftPosition, const QStaticText & staticText)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QStaticText cppArg1_local;
            ::QStaticText *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawStaticText(QPoint,QStaticText)
                cppSelf->drawStaticText(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // drawStaticText(const QPointF & topLeftPosition, const QStaticText & staticText)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QStaticText cppArg1_local;
            ::QStaticText *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // drawStaticText(QPointF,QStaticText)
                cppSelf->drawStaticText(*cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // drawStaticText(int left, int top, const QStaticText & staticText)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QStaticText cppArg2_local;
            ::QStaticText *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // drawStaticText(int,int,QStaticText)
                cppSelf->drawStaticText(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawStaticText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawText_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawText_TypeError;
    } else if (numArgs == 4 || numArgs == 5)
        goto Sbk_QPainterFunc_drawText_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOO:drawText", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawText(QPoint,QString)
    // 1: QPainter::drawText(QPointF,QString)
    // 2: QPainter::drawText(QRect,int,QString,QRect*)
    // 3: QPainter::drawText(QRectF,QString,QTextOption)
    // 4: QPainter::drawText(QRectF,int,QString,QRectF*)
    // 5: QPainter::drawText(int,int,QString)
    // 6: QPainter::drawText(int,int,int,int,int,QString,QRect*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 6
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
            overloadId = 6; // drawText(int,int,int,int,int,QString,QRect*)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            overloadId = 5; // drawText(int,int,QString)
        }
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 2; // drawText(QRect,int,QString,QRect*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            overloadId = 4; // drawText(QRectF,int,QString,QRectF*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // drawText(QRectF,QString,QTextOption)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), (pyArgs[2])))) {
                overloadId = 3; // drawText(QRectF,QString,QTextOption)
            }
        }
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // drawText(QPoint,QString)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 1; // drawText(QPointF,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawText_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawText(const QPoint & p, const QString & s)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawText_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawText(QPoint,QString)
                cppSelf->drawText(*cppArg0, cppArg1);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // drawText(const QPointF & p, const QString & s)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawText_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawText(QPointF,QString)
                cppSelf->drawText(*cppArg0, cppArg1);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 2: // drawText(const QRect & r, int flags, const QString & text, QRect * br)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawText_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawText(QRect,int,QString,QRect*)
                // Begin code injection
                // TEMPLATE - fix_args,QRect* - START
                QRect rect_;
                cppSelf->drawText(*cppArg0, cppArg1, cppArg2, &rect_);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &rect_);
                // TEMPLATE - fix_args,QRect* - END

                // End of code injection

            }
            break;
        }
        case 3: // drawText(const QRectF & r, const QString & text, const QTextOption & o)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_o = Shiboken::String::createStaticString("o");
                if (PyDict_Contains(kwds, key_o)) {
                    value = PyDict_GetItem(kwds, key_o);
                    if (value && pyArgs[2]) {
                        errInfo = key_o;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawText_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), (pyArgs[2]))))
                            goto Sbk_QPainterFunc_drawText_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_o);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawText_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QTextOption cppArg2_local = QTextOption();
            ::QTextOption *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // drawText(QRectF,QString,QTextOption)
                cppSelf->drawText(*cppArg0, cppArg1, *cppArg2);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 4: // drawText(const QRectF & r, int flags, const QString & text, QRectF * br)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawText_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawText(QRectF,int,QString,QRectF*)
                // Begin code injection
                // TEMPLATE - fix_args,QRectF* - START
                QRectF rect_;
                cppSelf->drawText(*cppArg0, cppArg1, cppArg2, &rect_);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &rect_);
                // TEMPLATE - fix_args,QRectF* - END

                // End of code injection

            }
            break;
        }
        case 5: // drawText(int x, int y, const QString & s)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawText_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawText(int,int,QString)
                cppSelf->drawText(cppArg0, cppArg1, cppArg2);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 6: // drawText(int x, int y, int w, int h, int flags, const QString & text, QRect * br)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPainterFunc_drawText_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // drawText(int,int,int,int,int,QString,QRect*)
                // Begin code injection
                // TEMPLATE - fix_args,QRect* - START
                QRect rect_;
                cppSelf->drawText(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, &rect_);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &rect_);
                // TEMPLATE - fix_args,QRect* - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPainterFunc_drawText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawTextItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawTextItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawTextItem", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawTextItem(QPoint,QTextItem)
    // 1: QPainter::drawTextItem(QPointF,QTextItem)
    // 2: QPainter::drawTextItem(int,int,QTextItem)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX]), (pyArgs[2])))) {
        overloadId = 2; // drawTextItem(int,int,QTextItem)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // drawTextItem(QPoint,QTextItem)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX]), (pyArgs[1])))) {
        overloadId = 1; // drawTextItem(QPointF,QTextItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawTextItem_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawTextItem(const QPoint & p, const QTextItem & ti)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextItem *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawTextItem(QPoint,QTextItem)
                cppSelf->drawTextItem(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // drawTextItem(const QPointF & p, const QTextItem & ti)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextItem *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawTextItem(QPointF,QTextItem)
                cppSelf->drawTextItem(*cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // drawTextItem(int x, int y, const QTextItem & ti)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QTextItem *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawTextItem(int,int,QTextItem)
                cppSelf->drawTextItem(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawTextItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_drawTiledPixmap(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.drawTiledPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
    } else if (numArgs == 4)
        goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOO:drawTiledPixmap", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::drawTiledPixmap(QRect,QPixmap,QPoint)
    // 1: QPainter::drawTiledPixmap(QRectF,QPixmap,QPointF)
    // 2: QPainter::drawTiledPixmap(int,int,int,int,QPixmap,int,int)
    if (numArgs >= 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[4])))) {
        if (numArgs == 5) {
            overloadId = 2; // drawTiledPixmap(int,int,int,int,QPixmap,int,int)
        } else if (numArgs >= 6
            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
            if (numArgs == 6) {
                overloadId = 2; // drawTiledPixmap(int,int,int,int,QPixmap,int,int)
            } else if (numArgs >= 7
                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
                overloadId = 2; // drawTiledPixmap(int,int,int,int,QPixmap,int,int)
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // drawTiledPixmap(QRect,QPixmap,QPoint)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[2])))) {
            overloadId = 0; // drawTiledPixmap(QRect,QPixmap,QPoint)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // drawTiledPixmap(QRectF,QPixmap,QPointF)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[2])))) {
            overloadId = 1; // drawTiledPixmap(QRectF,QPixmap,QPointF)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawTiledPixmap(const QRect & arg__1, const QPixmap & arg__2, const QPoint & pos)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[2]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[2]))))
                            goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QPoint cppArg2_local = QPoint();
            ::QPoint *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // drawTiledPixmap(QRect,QPixmap,QPoint)
                cppSelf->drawTiledPixmap(*cppArg0, *cppArg1, *cppArg2);
            }
            break;
        }
        case 1: // drawTiledPixmap(const QRectF & rect, const QPixmap & pm, const QPointF & offset)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
                if (PyDict_Contains(kwds, key_offset)) {
                    value = PyDict_GetItem(kwds, key_offset);
                    if (value && pyArgs[2]) {
                        errInfo = key_offset;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[2]))))
                            goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offset);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPixmap cppArg1_local;
            ::QPixmap *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QPointF cppArg2_local = QPointF();
            ::QPointF *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // drawTiledPixmap(QRectF,QPixmap,QPointF)
                cppSelf->drawTiledPixmap(*cppArg0, *cppArg1, *cppArg2);
            }
            break;
        }
        case 2: // drawTiledPixmap(int x, int y, int w, int h, const QPixmap & arg__5, int sx, int sy)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_sx = Shiboken::String::createStaticString("sx");
                if (PyDict_Contains(kwds, key_sx)) {
                    value = PyDict_GetItem(kwds, key_sx);
                    if (value && pyArgs[5]) {
                        errInfo = key_sx;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                            goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sx);
                }
                static PyObject *const key_sy = Shiboken::String::createStaticString("sy");
                if (PyDict_Contains(kwds, key_sy)) {
                    value = PyDict_GetItem(kwds, key_sy);
                    if (value && pyArgs[6]) {
                        errInfo = key_sy;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6]))))
                            goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sy);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_drawTiledPixmap_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QPixmap cppArg4_local;
            ::QPixmap *cppArg4 = &cppArg4_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);

            int cppArg5 = 0;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6 = 0;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // drawTiledPixmap(int,int,int,int,QPixmap,int,int)
                cppSelf->drawTiledPixmap(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, cppArg5, cppArg6);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_drawTiledPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_end(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.end";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // end()
            bool cppResult = cppSelf->end();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_endNativePainting(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.endNativePainting";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endNativePainting()
            cppSelf->endNativePainting();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPainterFunc_eraseRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.eraseRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QPainterFunc_eraseRect_TypeError;

    if (!PyArg_UnpackTuple(args, "eraseRect", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::eraseRect(QRect)
    // 1: QPainter::eraseRect(QRectF)
    // 2: QPainter::eraseRect(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 2; // eraseRect(int,int,int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // eraseRect(QRect)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 1; // eraseRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_eraseRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // eraseRect(const QRect & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // eraseRect(QRect)
                cppSelf->eraseRect(*cppArg0);
            }
            break;
        }
        case 1: // eraseRect(const QRectF & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // eraseRect(QRectF)
                cppSelf->eraseRect(*cppArg0);
            }
            break;
        }
        case 2: // eraseRect(int x, int y, int w, int h)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // eraseRect(int,int,int,int)
                cppSelf->eraseRect(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_eraseRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_fillPath(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.fillPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "fillPath", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::fillPath(QPainterPath,QBrush)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[1])))) {
        overloadId = 0; // fillPath(QPainterPath,QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_fillPath_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainterPath cppArg0_local;
        ::QPainterPath *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QBrush cppArg1_local;
        ::QBrush *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // fillPath(QPainterPath,QBrush)
            cppSelf->fillPath(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_fillPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_fillRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.fillRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3 || numArgs == 4)
        goto Sbk_QPainterFunc_fillRect_TypeError;

    if (!PyArg_UnpackTuple(args, "fillRect", 2, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::fillRect(QRect,QBrush)
    // 1: QPainter::fillRect(QRect,QColor)
    // 2: QPainter::fillRect(QRect,QGradient::Preset)
    // 3: QPainter::fillRect(QRect,Qt::BrushStyle)
    // 4: QPainter::fillRect(QRect,Qt::GlobalColor)
    // 5: QPainter::fillRect(QRectF,QBrush)
    // 6: QPainter::fillRect(QRectF,QColor)
    // 7: QPainter::fillRect(QRectF,QGradient::Preset)
    // 8: QPainter::fillRect(QRectF,Qt::BrushStyle)
    // 9: QPainter::fillRect(QRectF,Qt::GlobalColor)
    // 10: QPainter::fillRect(int,int,int,int,QGradient::Preset)
    // 11: QPainter::fillRect(int,int,int,int,Qt::BrushStyle)
    // 12: QPainter::fillRect(int,int,int,int,Qt::GlobalColor)
    // 13: QPainter::fillRect(int,int,int,int,QBrush)
    // 14: QPainter::fillRect(int,int,int,int,QColor)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, (pyArgs[4])))) {
            overloadId = 12; // fillRect(int,int,int,int,Qt::GlobalColor)
        } else if (numArgs == 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArgs[4])))) {
            overloadId = 11; // fillRect(int,int,int,int,Qt::BrushStyle)
        } else if (numArgs == 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX])->converter, (pyArgs[4])))) {
            overloadId = 10; // fillRect(int,int,int,int,QGradient::Preset)
        } else if (numArgs == 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[4])))) {
            overloadId = 14; // fillRect(int,int,int,int,QColor)
        } else if (numArgs == 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[4])))) {
            overloadId = 13; // fillRect(int,int,int,int,QBrush)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, (pyArgs[1])))) {
            overloadId = 4; // fillRect(QRect,Qt::GlobalColor)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 3; // fillRect(QRect,Qt::BrushStyle)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX])->converter, (pyArgs[1])))) {
            overloadId = 2; // fillRect(QRect,QGradient::Preset)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 1; // fillRect(QRect,QColor)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[1])))) {
            overloadId = 0; // fillRect(QRect,QBrush)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, (pyArgs[1])))) {
            overloadId = 9; // fillRect(QRectF,Qt::GlobalColor)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 8; // fillRect(QRectF,Qt::BrushStyle)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QGRADIENT_PRESET_IDX])->converter, (pyArgs[1])))) {
            overloadId = 7; // fillRect(QRectF,QGradient::Preset)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 6; // fillRect(QRectF,QColor)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[1])))) {
            overloadId = 5; // fillRect(QRectF,QBrush)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_fillRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fillRect(const QRect & arg__1, const QBrush & arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QBrush cppArg1_local;
            ::QBrush *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // fillRect(QRect,QBrush)
                cppSelf->fillRect(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // fillRect(const QRect & arg__1, const QColor & color)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // fillRect(QRect,QColor)
                cppSelf->fillRect(*cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // fillRect(const QRect & r, QGradient::Preset preset)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QGradient::Preset cppArg1 = static_cast< ::QGradient::Preset>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fillRect(QRect,QGradient::Preset)
                cppSelf->fillRect(*cppArg0, cppArg1);
            }
            break;
        }
        case 3: // fillRect(const QRect & r, Qt::BrushStyle style)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::BrushStyle cppArg1{Qt::NoBrush};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fillRect(QRect,Qt::BrushStyle)
                cppSelf->fillRect(*cppArg0, cppArg1);
            }
            break;
        }
        case 4: // fillRect(const QRect & r, Qt::GlobalColor c)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::GlobalColor cppArg1{Qt::color0};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fillRect(QRect,Qt::GlobalColor)
                cppSelf->fillRect(*cppArg0, cppArg1);
            }
            break;
        }
        case 5: // fillRect(const QRectF & arg__1, const QBrush & arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QBrush cppArg1_local;
            ::QBrush *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // fillRect(QRectF,QBrush)
                cppSelf->fillRect(*cppArg0, *cppArg1);
            }
            break;
        }
        case 6: // fillRect(const QRectF & arg__1, const QColor & color)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // fillRect(QRectF,QColor)
                cppSelf->fillRect(*cppArg0, *cppArg1);
            }
            break;
        }
        case 7: // fillRect(const QRectF & r, QGradient::Preset preset)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QGradient::Preset cppArg1 = static_cast< ::QGradient::Preset>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fillRect(QRectF,QGradient::Preset)
                cppSelf->fillRect(*cppArg0, cppArg1);
            }
            break;
        }
        case 8: // fillRect(const QRectF & r, Qt::BrushStyle style)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::BrushStyle cppArg1{Qt::NoBrush};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fillRect(QRectF,Qt::BrushStyle)
                cppSelf->fillRect(*cppArg0, cppArg1);
            }
            break;
        }
        case 9: // fillRect(const QRectF & r, Qt::GlobalColor c)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::GlobalColor cppArg1{Qt::color0};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fillRect(QRectF,Qt::GlobalColor)
                cppSelf->fillRect(*cppArg0, cppArg1);
            }
            break;
        }
        case 10: // fillRect(int x, int y, int w, int h, QGradient::Preset preset)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QGradient::Preset cppArg4 = static_cast< ::QGradient::Preset>(0);
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // fillRect(int,int,int,int,QGradient::Preset)
                cppSelf->fillRect(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 11: // fillRect(int x, int y, int w, int h, Qt::BrushStyle style)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::Qt::BrushStyle cppArg4{Qt::NoBrush};
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // fillRect(int,int,int,int,Qt::BrushStyle)
                cppSelf->fillRect(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 12: // fillRect(int x, int y, int w, int h, Qt::GlobalColor c)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::Qt::GlobalColor cppArg4{Qt::color0};
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // fillRect(int,int,int,int,Qt::GlobalColor)
                cppSelf->fillRect(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 13: // fillRect(int x, int y, int w, int h, const QBrush & arg__5)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QBrush cppArg4_local;
            ::QBrush *cppArg4 = &cppArg4_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);


            if (!PyErr_Occurred()) {
                // fillRect(int,int,int,int,QBrush)
                cppSelf->fillRect(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            }
            break;
        }
        case 14: // fillRect(int x, int y, int w, int h, const QColor & color)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QColor cppArg4_local;
            ::QColor *cppArg4 = &cppArg4_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);


            if (!PyErr_Occurred()) {
                // fillRect(int,int,int,int,QColor)
                cppSelf->fillRect(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_fillRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_font(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.font";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // font()const
            const QFont & cppResult = const_cast<const ::QPainter *>(cppSelf)->font();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_fontInfo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.fontInfo";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontInfo()const
            QFontInfo cppResult = const_cast<const ::QPainter *>(cppSelf)->fontInfo();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_fontMetrics(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.fontMetrics";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontMetrics()const
            QFontMetrics cppResult = const_cast<const ::QPainter *>(cppSelf)->fontMetrics();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_hasClipping(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.hasClipping";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasClipping()const
            bool cppResult = const_cast<const ::QPainter *>(cppSelf)->hasClipping();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_initFrom(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.initFrom";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::initFrom(const QPaintDevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // initFrom(const QPaintDevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_initFrom_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintDevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // initFrom(const QPaintDevice*)
            cppSelf->initFrom(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_initFrom_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.isActive";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isActive()const
            bool cppResult = const_cast<const ::QPainter *>(cppSelf)->isActive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_layoutDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.layoutDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layoutDirection()const
            Qt::LayoutDirection cppResult = const_cast<const ::QPainter *>(cppSelf)->layoutDirection();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_matrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.matrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matrix()const
            const QMatrix & cppResult = const_cast<const ::QPainter *>(cppSelf)->matrix();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_matrixEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.matrixEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matrixEnabled()const
            bool cppResult = const_cast<const ::QPainter *>(cppSelf)->matrixEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_opacity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.opacity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // opacity()const
            qreal cppResult = const_cast<const ::QPainter *>(cppSelf)->opacity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_paintEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.paintEngine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paintEngine()const
            QPaintEngine * cppResult = const_cast<const ::QPainter *>(cppSelf)->paintEngine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_pen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.pen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pen()const
            const QPen & cppResult = const_cast<const ::QPainter *>(cppSelf)->pen();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_redirected(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.redirected";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_redirected_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_redirected_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:redirected", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QPainter::redirected(const QPaintDevice*,QPoint*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // redirected(const QPaintDevice*,QPoint*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // redirected(const QPaintDevice*,QPoint*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_redirected_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
            if (PyDict_Contains(kwds, key_offset)) {
                value = PyDict_GetItem(kwds, key_offset);
                if (value && pyArgs[1]) {
                    errInfo = key_offset;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_redirected_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1]))))
                        goto Sbk_QPainterFunc_redirected_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_offset);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_redirected_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPaintDevice *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPoint *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // redirected(const QPaintDevice*,QPoint*)
            QPaintDevice * cppResult = ::QPainter::redirected(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPainterFunc_redirected_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_renderHints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.renderHints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderHints()const
            QFlags<QPainter::RenderHint> cppResult = const_cast<const ::QPainter *>(cppSelf)->renderHints();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_resetMatrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.resetMatrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetMatrix()
            cppSelf->resetMatrix();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPainterFunc_resetTransform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.resetTransform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetTransform()
            cppSelf->resetTransform();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPainterFunc_restore(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.restore";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // restore()
            cppSelf->restore();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPainterFunc_restoreRedirected(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.restoreRedirected";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QPainter::restoreRedirected(const QPaintDevice*)
    if ((pyArg != Py_None && (pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArg))))) {
        overloadId = 0; // restoreRedirected(const QPaintDevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_restoreRedirected_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintDevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // restoreRedirected(const QPaintDevice*)
            ::QPainter::restoreRedirected(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_restoreRedirected_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_rotate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.rotate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::rotate(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // rotate(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_rotate_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rotate(qreal)
            cppSelf->rotate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_rotate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_save(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.save";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // save()
            cppSelf->save();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPainterFunc_scale(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.scale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "scale", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::scale(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // scale(qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_scale_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // scale(qreal,qreal)
            cppSelf->scale(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_scale_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setBackground(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setBackground";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setBackground(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setBackground(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setBackground_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBackground(QBrush)
            cppSelf->setBackground(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setBackground_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setBackgroundMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setBackgroundMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setBackgroundMode(Qt::BGMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBackgroundMode(Qt::BGMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setBackgroundMode_TypeError;

    // Call function/method
    {
        ::Qt::BGMode cppArg0{Qt::TransparentMode};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBackgroundMode(Qt::BGMode)
            cppSelf->setBackgroundMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setBackgroundMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setBrush(Qt::BrushStyle)
    // 1: QPainter::setBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBrush(Qt::BrushStyle)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 1; // setBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setBrush_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setBrush(Qt::BrushStyle style)
        {
            ::Qt::BrushStyle cppArg0{Qt::NoBrush};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setBrush(Qt::BrushStyle)
                cppSelf->setBrush(cppArg0);
            }
            break;
        }
        case 1: // setBrush(const QBrush & brush)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QBrush cppArg0_local;
            ::QBrush *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setBrush(QBrush)
                cppSelf->setBrush(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setBrushOrigin(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setBrushOrigin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setBrushOrigin", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setBrushOrigin(QPoint)
    // 1: QPainter::setBrushOrigin(QPointF)
    // 2: QPainter::setBrushOrigin(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 2; // setBrushOrigin(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setBrushOrigin(QPoint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        overloadId = 1; // setBrushOrigin(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setBrushOrigin_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setBrushOrigin(const QPoint & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setBrushOrigin(QPoint)
                cppSelf->setBrushOrigin(*cppArg0);
            }
            break;
        }
        case 1: // setBrushOrigin(const QPointF & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setBrushOrigin(QPointF)
                cppSelf->setBrushOrigin(*cppArg0);
            }
            break;
        }
        case 2: // setBrushOrigin(int x, int y)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setBrushOrigin(int,int)
                cppSelf->setBrushOrigin(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setBrushOrigin_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setClipPath(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setClipPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setClipPath_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setClipPath_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setClipPath", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setClipPath(QPainterPath,Qt::ClipOperation)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setClipPath(QPainterPath,Qt::ClipOperation)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setClipPath(QPainterPath,Qt::ClipOperation)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setClipPath_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_op = Shiboken::String::createStaticString("op");
            if (PyDict_Contains(kwds, key_op)) {
                value = PyDict_GetItem(kwds, key_op);
                if (value && pyArgs[1]) {
                    errInfo = key_op;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_setClipPath_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QPainterFunc_setClipPath_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_op);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_setClipPath_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainterPath cppArg0_local;
        ::QPainterPath *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::Qt::ClipOperation cppArg1 = Qt::ReplaceClip;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setClipPath(QPainterPath,Qt::ClipOperation)
            cppSelf->setClipPath(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setClipPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setClipRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setClipRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setClipRect_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setClipRect_TypeError;
    } else if (numArgs == 3)
        goto Sbk_QPainterFunc_setClipRect_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOO:setClipRect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setClipRect(QRect,Qt::ClipOperation)
    // 1: QPainter::setClipRect(QRectF,Qt::ClipOperation)
    // 2: QPainter::setClipRect(int,int,int,int,Qt::ClipOperation)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 2; // setClipRect(int,int,int,int,Qt::ClipOperation)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[4])))) {
            overloadId = 2; // setClipRect(int,int,int,int,Qt::ClipOperation)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setClipRect(QRect,Qt::ClipOperation)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setClipRect(QRect,Qt::ClipOperation)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // setClipRect(QRectF,Qt::ClipOperation)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // setClipRect(QRectF,Qt::ClipOperation)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setClipRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setClipRect(const QRect & arg__1, Qt::ClipOperation op)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_op = Shiboken::String::createStaticString("op");
                if (PyDict_Contains(kwds, key_op)) {
                    value = PyDict_GetItem(kwds, key_op);
                    if (value && pyArgs[1]) {
                        errInfo = key_op;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_setClipRect_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QPainterFunc_setClipRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_op);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_setClipRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::ClipOperation cppArg1 = Qt::ReplaceClip;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setClipRect(QRect,Qt::ClipOperation)
                cppSelf->setClipRect(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setClipRect(const QRectF & arg__1, Qt::ClipOperation op)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_op = Shiboken::String::createStaticString("op");
                if (PyDict_Contains(kwds, key_op)) {
                    value = PyDict_GetItem(kwds, key_op);
                    if (value && pyArgs[1]) {
                        errInfo = key_op;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_setClipRect_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QPainterFunc_setClipRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_op);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_setClipRect_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::ClipOperation cppArg1 = Qt::ReplaceClip;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setClipRect(QRectF,Qt::ClipOperation)
                cppSelf->setClipRect(*cppArg0, cppArg1);
            }
            break;
        }
        case 2: // setClipRect(int x, int y, int w, int h, Qt::ClipOperation op)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_op = Shiboken::String::createStaticString("op");
                if (PyDict_Contains(kwds, key_op)) {
                    value = PyDict_GetItem(kwds, key_op);
                    if (value && pyArgs[4]) {
                        errInfo = key_op;
                        Py_INCREF(errInfo);
                        goto Sbk_QPainterFunc_setClipRect_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[4]))))
                            goto Sbk_QPainterFunc_setClipRect_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_op);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPainterFunc_setClipRect_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::Qt::ClipOperation cppArg4 = Qt::ReplaceClip;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setClipRect(int,int,int,int,Qt::ClipOperation)
                cppSelf->setClipRect(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setClipRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setClipRegion(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setClipRegion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setClipRegion_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setClipRegion_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setClipRegion", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setClipRegion(QRegion,Qt::ClipOperation)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setClipRegion(QRegion,Qt::ClipOperation)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setClipRegion(QRegion,Qt::ClipOperation)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setClipRegion_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_op = Shiboken::String::createStaticString("op");
            if (PyDict_Contains(kwds, key_op)) {
                value = PyDict_GetItem(kwds, key_op);
                if (value && pyArgs[1]) {
                    errInfo = key_op;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_setClipRegion_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QPainterFunc_setClipRegion_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_op);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_setClipRegion_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRegion cppArg0_local;
        ::QRegion *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::Qt::ClipOperation cppArg1 = Qt::ReplaceClip;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setClipRegion(QRegion,Qt::ClipOperation)
            cppSelf->setClipRegion(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setClipRegion_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setClipping(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setClipping";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setClipping(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setClipping(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setClipping_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setClipping(bool)
            cppSelf->setClipping(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setClipping_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setCompositionMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setCompositionMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setCompositionMode(QPainter::CompositionMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCompositionMode(QPainter::CompositionMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setCompositionMode_TypeError;

    // Call function/method
    {
        ::QPainter::CompositionMode cppArg0{QPainter::CompositionMode_SourceOver};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCompositionMode(QPainter::CompositionMode)
            cppSelf->setCompositionMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setCompositionMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // setFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setFont_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFont(QFont)
            cppSelf->setFont(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setLayoutDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setLayoutDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setLayoutDirection(Qt::LayoutDirection)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setLayoutDirection(Qt::LayoutDirection)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setLayoutDirection_TypeError;

    // Call function/method
    {
        ::Qt::LayoutDirection cppArg0{Qt::LeftToRight};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLayoutDirection(Qt::LayoutDirection)
            cppSelf->setLayoutDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setLayoutDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setMatrix(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setMatrix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setMatrix_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setMatrix_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setMatrix", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setMatrix(QMatrix,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMatrix(QMatrix,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setMatrix(QMatrix,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setMatrix_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_combine = Shiboken::String::createStaticString("combine");
            if (PyDict_Contains(kwds, key_combine)) {
                value = PyDict_GetItem(kwds, key_combine);
                if (value && pyArgs[1]) {
                    errInfo = key_combine;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_setMatrix_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QPainterFunc_setMatrix_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_combine);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_setMatrix_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMatrix cppArg0_local;
        ::QMatrix *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMatrix(QMatrix,bool)
            cppSelf->setMatrix(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setMatrix_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setMatrixEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setMatrixEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setMatrixEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMatrixEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setMatrixEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMatrixEnabled(bool)
            cppSelf->setMatrixEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setMatrixEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setOpacity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setOpacity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setOpacity(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setOpacity(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setOpacity_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOpacity(qreal)
            cppSelf->setOpacity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setOpacity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setPen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setPen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setPen(Qt::PenStyle)
    // 1: QPainter::setPen(QColor)
    // 2: QPainter::setPen(QPen)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPen(Qt::PenStyle)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 1; // setPen(QColor)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
        overloadId = 2; // setPen(QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setPen_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPen(Qt::PenStyle style)
        {
            ::Qt::PenStyle cppArg0{Qt::NoPen};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setPen(Qt::PenStyle)
                cppSelf->setPen(cppArg0);
            }
            break;
        }
        case 1: // setPen(const QColor & color)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setPen(QColor)
                cppSelf->setPen(*cppArg0);
            }
            break;
        }
        case 2: // setPen(const QPen & pen)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPen cppArg0_local;
            ::QPen *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setPen(QPen)
                cppSelf->setPen(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setPen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setRedirected(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setRedirected";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setRedirected_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setRedirected_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setRedirected", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QPainter::setRedirected(const QPaintDevice*,QPaintDevice*,QPoint)
    if (numArgs >= 2
        && (pyArgs[0] != Py_None && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArgs[0]))))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setRedirected(const QPaintDevice*,QPaintDevice*,QPoint)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[2])))) {
            overloadId = 0; // setRedirected(const QPaintDevice*,QPaintDevice*,QPoint)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setRedirected_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
            if (PyDict_Contains(kwds, key_offset)) {
                value = PyDict_GetItem(kwds, key_offset);
                if (value && pyArgs[2]) {
                    errInfo = key_offset;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_setRedirected_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[2]))))
                        goto Sbk_QPainterFunc_setRedirected_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_offset);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_setRedirected_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPaintDevice *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPaintDevice *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPoint cppArg2_local = QPoint();
        ::QPoint *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }

        if (!PyErr_Occurred()) {
            // setRedirected(const QPaintDevice*,QPaintDevice*,QPoint)
            ::QPainter::setRedirected(cppArg0, cppArg1, *cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setRedirected_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setRenderHint(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setRenderHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setRenderHint_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setRenderHint_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setRenderHint", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setRenderHint(QPainter::RenderHint,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setRenderHint(QPainter::RenderHint,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setRenderHint(QPainter::RenderHint,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setRenderHint_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_on = Shiboken::String::createStaticString("on");
            if (PyDict_Contains(kwds, key_on)) {
                value = PyDict_GetItem(kwds, key_on);
                if (value && pyArgs[1]) {
                    errInfo = key_on;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_setRenderHint_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QPainterFunc_setRenderHint_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_on);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_setRenderHint_TypeError;
            }
        }
        ::QPainter::RenderHint cppArg0 = static_cast< ::QPainter::RenderHint>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setRenderHint(QPainter::RenderHint,bool)
            cppSelf->setRenderHint(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setRenderHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setRenderHints(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setRenderHints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setRenderHints_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setRenderHints_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setRenderHints", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setRenderHints(QFlags<QPainter::RenderHint>,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setRenderHints(QFlags<QPainter::RenderHint>,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setRenderHints(QFlags<QPainter::RenderHint>,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setRenderHints_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_on = Shiboken::String::createStaticString("on");
            if (PyDict_Contains(kwds, key_on)) {
                value = PyDict_GetItem(kwds, key_on);
                if (value && pyArgs[1]) {
                    errInfo = key_on;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_setRenderHints_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QPainterFunc_setRenderHints_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_on);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_setRenderHints_TypeError;
            }
        }
        ::QFlags<QPainter::RenderHint> cppArg0 = QFlags<QPainter::RenderHint>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setRenderHints(QFlags<QPainter::RenderHint>,bool)
            cppSelf->setRenderHints(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setRenderHints_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setTransform(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setTransform_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setTransform_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setTransform", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setTransform(QTransform,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setTransform(QTransform,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setTransform(QTransform,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setTransform_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_combine = Shiboken::String::createStaticString("combine");
            if (PyDict_Contains(kwds, key_combine)) {
                value = PyDict_GetItem(kwds, key_combine);
                if (value && pyArgs[1]) {
                    errInfo = key_combine;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_setTransform_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QPainterFunc_setTransform_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_combine);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_setTransform_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QTransform cppArg0_local;
        ::QTransform *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setTransform(QTransform,bool)
            cppSelf->setTransform(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setViewTransformEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setViewTransformEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setViewTransformEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setViewTransformEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setViewTransformEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setViewTransformEnabled(bool)
            cppSelf->setViewTransformEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setViewTransformEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setViewport(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setViewport";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QPainterFunc_setViewport_TypeError;

    if (!PyArg_UnpackTuple(args, "setViewport", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setViewport(QRect)
    // 1: QPainter::setViewport(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 1; // setViewport(int,int,int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setViewport(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setViewport_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setViewport(const QRect & viewport)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setViewport(QRect)
                cppSelf->setViewport(*cppArg0);
            }
            break;
        }
        case 1: // setViewport(int x, int y, int w, int h)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setViewport(int,int,int,int)
                cppSelf->setViewport(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setViewport_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setWindow(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setWindow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QPainterFunc_setWindow_TypeError;

    if (!PyArg_UnpackTuple(args, "setWindow", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setWindow(QRect)
    // 1: QPainter::setWindow(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 1; // setWindow(int,int,int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setWindow(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setWindow_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setWindow(const QRect & window)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setWindow(QRect)
                cppSelf->setWindow(*cppArg0);
            }
            break;
        }
        case 1: // setWindow(int x, int y, int w, int h)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setWindow(int,int,int,int)
                cppSelf->setWindow(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setWorldMatrix(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setWorldMatrix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setWorldMatrix_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setWorldMatrix_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setWorldMatrix", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setWorldMatrix(QMatrix,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setWorldMatrix(QMatrix,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setWorldMatrix(QMatrix,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setWorldMatrix_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_combine = Shiboken::String::createStaticString("combine");
            if (PyDict_Contains(kwds, key_combine)) {
                value = PyDict_GetItem(kwds, key_combine);
                if (value && pyArgs[1]) {
                    errInfo = key_combine;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_setWorldMatrix_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QPainterFunc_setWorldMatrix_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_combine);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_setWorldMatrix_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMatrix cppArg0_local;
        ::QMatrix *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setWorldMatrix(QMatrix,bool)
            cppSelf->setWorldMatrix(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setWorldMatrix_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setWorldMatrixEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setWorldMatrixEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::setWorldMatrixEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWorldMatrixEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setWorldMatrixEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWorldMatrixEnabled(bool)
            cppSelf->setWorldMatrixEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setWorldMatrixEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_setWorldTransform(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.setWorldTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setWorldTransform_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainterFunc_setWorldTransform_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setWorldTransform", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::setWorldTransform(QTransform,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setWorldTransform(QTransform,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setWorldTransform(QTransform,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_setWorldTransform_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_combine = Shiboken::String::createStaticString("combine");
            if (PyDict_Contains(kwds, key_combine)) {
                value = PyDict_GetItem(kwds, key_combine);
                if (value && pyArgs[1]) {
                    errInfo = key_combine;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainterFunc_setWorldTransform_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QPainterFunc_setWorldTransform_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_combine);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainterFunc_setWorldTransform_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QTransform cppArg0_local;
        ::QTransform *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setWorldTransform(QTransform,bool)
            cppSelf->setWorldTransform(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_setWorldTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_shear(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.shear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "shear", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::shear(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // shear(qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_shear_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // shear(qreal,qreal)
            cppSelf->shear(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_shear_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_strokePath(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.strokePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "strokePath", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::strokePath(QPainterPath,QPen)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[1])))) {
        overloadId = 0; // strokePath(QPainterPath,QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_strokePath_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainterPath cppArg0_local;
        ::QPainterPath *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPen cppArg1_local;
        ::QPen *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // strokePath(QPainterPath,QPen)
            cppSelf->strokePath(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_strokePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_testRenderHint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.testRenderHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPainter::testRenderHint(QPainter::RenderHint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // testRenderHint(QPainter::RenderHint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_testRenderHint_TypeError;

    // Call function/method
    {
        ::QPainter::RenderHint cppArg0 = static_cast< ::QPainter::RenderHint>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // testRenderHint(QPainter::RenderHint)const
            bool cppResult = const_cast<const ::QPainter *>(cppSelf)->testRenderHint(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPainterFunc_testRenderHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_transform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.transform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transform()const
            const QTransform & cppResult = const_cast<const ::QPainter *>(cppSelf)->transform();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_translate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.translate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPainter::translate(QPoint)
    // 1: QPainter::translate(QPointF)
    // 2: QPainter::translate(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 2; // translate(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // translate(QPoint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        overloadId = 1; // translate(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainterFunc_translate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // translate(const QPoint & offset)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // translate(QPoint)
                cppSelf->translate(*cppArg0);
            }
            break;
        }
        case 1: // translate(const QPointF & offset)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // translate(QPointF)
                cppSelf->translate(*cppArg0);
            }
            break;
        }
        case 2: // translate(qreal dx, qreal dy)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // translate(qreal,qreal)
                cppSelf->translate(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPainterFunc_translate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainterFunc_viewTransformEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.viewTransformEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewTransformEnabled()const
            bool cppResult = const_cast<const ::QPainter *>(cppSelf)->viewTransformEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_viewport(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.viewport";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewport()const
            QRect cppResult = const_cast<const ::QPainter *>(cppSelf)->viewport();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_window(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.window";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // window()const
            QRect cppResult = const_cast<const ::QPainter *>(cppSelf)->window();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_worldMatrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.worldMatrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // worldMatrix()const
            const QMatrix & cppResult = const_cast<const ::QPainter *>(cppSelf)->worldMatrix();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_worldMatrixEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.worldMatrixEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // worldMatrixEnabled()const
            bool cppResult = const_cast<const ::QPainter *>(cppSelf)->worldMatrixEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPainterFunc_worldTransform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPainter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.worldTransform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // worldTransform()const
            const QTransform & cppResult = const_cast<const ::QPainter *>(cppSelf)->worldTransform();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPainter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPainter_methods[] = {
    {"background", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_background), METH_NOARGS},
    {"backgroundMode", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_backgroundMode), METH_NOARGS},
    {"begin", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_begin), METH_O},
    {"beginNativePainting", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_beginNativePainting), METH_NOARGS},
    {"boundingRect", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_boundingRect), METH_VARARGS|METH_KEYWORDS},
    {"brush", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_brush), METH_NOARGS},
    {"brushOrigin", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_brushOrigin), METH_NOARGS},
    {"clipBoundingRect", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_clipBoundingRect), METH_NOARGS},
    {"clipPath", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_clipPath), METH_NOARGS},
    {"clipRegion", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_clipRegion), METH_NOARGS},
    {"combinedMatrix", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_combinedMatrix), METH_NOARGS},
    {"combinedTransform", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_combinedTransform), METH_NOARGS},
    {"compositionMode", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_compositionMode), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_device), METH_NOARGS},
    {"deviceMatrix", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_deviceMatrix), METH_NOARGS},
    {"deviceTransform", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_deviceTransform), METH_NOARGS},
    {"drawArc", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawArc), METH_VARARGS},
    {"drawChord", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawChord), METH_VARARGS},
    {"drawConvexPolygon", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawConvexPolygon), METH_O},
    {"drawEllipse", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawEllipse), METH_VARARGS},
    {"drawImage", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawImage), METH_VARARGS|METH_KEYWORDS},
    {"drawLine", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawLine), METH_VARARGS},
    {"drawLines", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawLines), METH_O},
    {"drawPath", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawPath), METH_O},
    {"drawPicture", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawPicture), METH_VARARGS},
    {"drawPie", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawPie), METH_VARARGS},
    {"drawPixmap", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawPixmap), METH_VARARGS},
    {"drawPixmapFragments", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawPixmapFragments), METH_VARARGS|METH_KEYWORDS},
    {"drawPoint", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawPoint), METH_VARARGS},
    {"drawPoints", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawPoints), METH_O},
    {"drawPolygon", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawPolygon), METH_VARARGS|METH_KEYWORDS},
    {"drawPolyline", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawPolyline), METH_O},
    {"drawRect", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawRect), METH_VARARGS},
    {"drawRects", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawRects), METH_O},
    {"drawRoundRect", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawRoundRect), METH_VARARGS|METH_KEYWORDS},
    {"drawRoundedRect", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawRoundedRect), METH_VARARGS|METH_KEYWORDS},
    {"drawStaticText", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawStaticText), METH_VARARGS},
    {"drawText", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawText), METH_VARARGS|METH_KEYWORDS},
    {"drawTextItem", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawTextItem), METH_VARARGS},
    {"drawTiledPixmap", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_drawTiledPixmap), METH_VARARGS|METH_KEYWORDS},
    {"end", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_end), METH_NOARGS},
    {"endNativePainting", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_endNativePainting), METH_NOARGS},
    {"eraseRect", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_eraseRect), METH_VARARGS},
    {"fillPath", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_fillPath), METH_VARARGS},
    {"fillRect", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_fillRect), METH_VARARGS},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_font), METH_NOARGS},
    {"fontInfo", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_fontInfo), METH_NOARGS},
    {"fontMetrics", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_fontMetrics), METH_NOARGS},
    {"hasClipping", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_hasClipping), METH_NOARGS},
    {"initFrom", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_initFrom), METH_O},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_isActive), METH_NOARGS},
    {"layoutDirection", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_layoutDirection), METH_NOARGS},
    {"matrix", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_matrix), METH_NOARGS},
    {"matrixEnabled", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_matrixEnabled), METH_NOARGS},
    {"opacity", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_opacity), METH_NOARGS},
    {"paintEngine", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_paintEngine), METH_NOARGS},
    {"pen", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_pen), METH_NOARGS},
    {"redirected", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_redirected), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"renderHints", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_renderHints), METH_NOARGS},
    {"resetMatrix", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_resetMatrix), METH_NOARGS},
    {"resetTransform", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_resetTransform), METH_NOARGS},
    {"restore", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_restore), METH_NOARGS},
    {"restoreRedirected", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_restoreRedirected), METH_O|METH_STATIC},
    {"rotate", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_rotate), METH_O},
    {"save", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_save), METH_NOARGS},
    {"scale", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_scale), METH_VARARGS},
    {"setBackground", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setBackground), METH_O},
    {"setBackgroundMode", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setBackgroundMode), METH_O},
    {"setBrush", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setBrush), METH_O},
    {"setBrushOrigin", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setBrushOrigin), METH_VARARGS},
    {"setClipPath", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setClipPath), METH_VARARGS|METH_KEYWORDS},
    {"setClipRect", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setClipRect), METH_VARARGS|METH_KEYWORDS},
    {"setClipRegion", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setClipRegion), METH_VARARGS|METH_KEYWORDS},
    {"setClipping", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setClipping), METH_O},
    {"setCompositionMode", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setCompositionMode), METH_O},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setFont), METH_O},
    {"setLayoutDirection", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setLayoutDirection), METH_O},
    {"setMatrix", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setMatrix), METH_VARARGS|METH_KEYWORDS},
    {"setMatrixEnabled", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setMatrixEnabled), METH_O},
    {"setOpacity", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setOpacity), METH_O},
    {"setPen", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setPen), METH_O},
    {"setRedirected", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setRedirected), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setRenderHint", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setRenderHint), METH_VARARGS|METH_KEYWORDS},
    {"setRenderHints", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setRenderHints), METH_VARARGS|METH_KEYWORDS},
    {"setTransform", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setTransform), METH_VARARGS|METH_KEYWORDS},
    {"setViewTransformEnabled", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setViewTransformEnabled), METH_O},
    {"setViewport", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setViewport), METH_VARARGS},
    {"setWindow", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setWindow), METH_VARARGS},
    {"setWorldMatrix", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setWorldMatrix), METH_VARARGS|METH_KEYWORDS},
    {"setWorldMatrixEnabled", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setWorldMatrixEnabled), METH_O},
    {"setWorldTransform", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_setWorldTransform), METH_VARARGS|METH_KEYWORDS},
    {"shear", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_shear), METH_VARARGS},
    {"strokePath", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_strokePath), METH_VARARGS},
    {"testRenderHint", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_testRenderHint), METH_O},
    {"transform", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_transform), METH_NOARGS},
    {"translate", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_translate), METH_VARARGS},
    {"viewTransformEnabled", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_viewTransformEnabled), METH_NOARGS},
    {"viewport", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_viewport), METH_NOARGS},
    {"window", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_window), METH_NOARGS},
    {"worldMatrix", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_worldMatrix), METH_NOARGS},
    {"worldMatrixEnabled", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_worldMatrixEnabled), METH_NOARGS},
    {"worldTransform", reinterpret_cast<PyCFunction>(Sbk_QPainterFunc_worldTransform), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QPainter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPainter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPainter_Type = nullptr;
static SbkObjectType *Sbk_QPainter_TypeF(void)
{
    return _Sbk_QPainter_Type;
}

static PyType_Slot Sbk_QPainter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPainter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPainter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPainter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPainter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPainter_spec = {
    "2:PySide2.QtGui.QPainter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPainter_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QPainter_RenderHint___and__(PyObject *self, PyObject *pyArg)
{
    ::QPainter::RenderHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPainter::RenderHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPainter::RenderHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPainter::RenderHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPainter::RenderHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPainter_RenderHint___or__(PyObject *self, PyObject *pyArg)
{
    ::QPainter::RenderHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPainter::RenderHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPainter::RenderHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPainter::RenderHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPainter::RenderHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPainter_RenderHint___xor__(PyObject *self, PyObject *pyArg)
{
    ::QPainter::RenderHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPainter::RenderHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPainter::RenderHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPainter::RenderHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPainter::RenderHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPainter_RenderHint___invert__(PyObject *self, PyObject *pyArg)
{
    ::QPainter::RenderHints cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, self, &cppSelf);
    ::QPainter::RenderHints cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QPainter_RenderHint_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QPainter_RenderHint__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QPainter_RenderHint_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_RenderHint_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtGui_QPainter_PixmapFragmentHint___and__(PyObject *self, PyObject *pyArg)
{
    ::QPainter::PixmapFragmentHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPainter::PixmapFragmentHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPainter::PixmapFragmentHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPainter::PixmapFragmentHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPainter::PixmapFragmentHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPainter_PixmapFragmentHint___or__(PyObject *self, PyObject *pyArg)
{
    ::QPainter::PixmapFragmentHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPainter::PixmapFragmentHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPainter::PixmapFragmentHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPainter::PixmapFragmentHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPainter::PixmapFragmentHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPainter_PixmapFragmentHint___xor__(PyObject *self, PyObject *pyArg)
{
    ::QPainter::PixmapFragmentHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPainter::PixmapFragmentHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPainter::PixmapFragmentHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPainter::PixmapFragmentHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPainter::PixmapFragmentHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPainter_PixmapFragmentHint___invert__(PyObject *self, PyObject *pyArg)
{
    ::QPainter::PixmapFragmentHints cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX])->converter, self, &cppSelf);
    ::QPainter::PixmapFragmentHints cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QPainter_PixmapFragmentHint_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QPainter_PixmapFragmentHint__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QPainter_PixmapFragmentHint_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPainter_PixmapFragmentHint_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QPainter_RenderHint_PythonToCpp_QPainter_RenderHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPainter::RenderHint *>(cppOut) =
        static_cast<::QPainter::RenderHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPainter_RenderHint_PythonToCpp_QPainter_RenderHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX]))
        return QPainter_RenderHint_PythonToCpp_QPainter_RenderHint;
    return {};
}
static PyObject *QPainter_RenderHint_CppToPython_QPainter_RenderHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPainter::RenderHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX], castCppIn);

}

static void QFlags_QPainter_RenderHint__PythonToCpp_QFlags_QPainter_RenderHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QPainter::RenderHint> *>(cppOut) =
        ::QFlags<QPainter::RenderHint>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QPainter_RenderHint__PythonToCpp_QFlags_QPainter_RenderHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX]))
        return QFlags_QPainter_RenderHint__PythonToCpp_QFlags_QPainter_RenderHint_;
    return {};
}
static PyObject *QFlags_QPainter_RenderHint__CppToPython_QFlags_QPainter_RenderHint_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QPainter::RenderHint> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX]));

}

static void QPainter_RenderHint_PythonToCpp_QFlags_QPainter_RenderHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QPainter::RenderHint> *>(cppOut) =
        ::QFlags<QPainter::RenderHint>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QPainter_RenderHint_PythonToCpp_QFlags_QPainter_RenderHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX]))
        return QPainter_RenderHint_PythonToCpp_QFlags_QPainter_RenderHint_;
    return {};
}
static void number_PythonToCpp_QFlags_QPainter_RenderHint_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QPainter::RenderHint> *>(cppOut) =
        ::QFlags<QPainter::RenderHint>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QPainter_RenderHint__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX]))
        return number_PythonToCpp_QFlags_QPainter_RenderHint_;
    return {};
}
static void QPainter_PixmapFragmentHint_PythonToCpp_QPainter_PixmapFragmentHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPainter::PixmapFragmentHint *>(cppOut) =
        static_cast<::QPainter::PixmapFragmentHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPainter_PixmapFragmentHint_PythonToCpp_QPainter_PixmapFragmentHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENTHINT_IDX]))
        return QPainter_PixmapFragmentHint_PythonToCpp_QPainter_PixmapFragmentHint;
    return {};
}
static PyObject *QPainter_PixmapFragmentHint_CppToPython_QPainter_PixmapFragmentHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPainter::PixmapFragmentHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENTHINT_IDX], castCppIn);

}

static void QFlags_QPainter_PixmapFragmentHint__PythonToCpp_QFlags_QPainter_PixmapFragmentHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QPainter::PixmapFragmentHint> *>(cppOut) =
        ::QFlags<QPainter::PixmapFragmentHint>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QPainter_PixmapFragmentHint__PythonToCpp_QFlags_QPainter_PixmapFragmentHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX]))
        return QFlags_QPainter_PixmapFragmentHint__PythonToCpp_QFlags_QPainter_PixmapFragmentHint_;
    return {};
}
static PyObject *QFlags_QPainter_PixmapFragmentHint__CppToPython_QFlags_QPainter_PixmapFragmentHint_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QPainter::PixmapFragmentHint> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX]));

}

static void QPainter_PixmapFragmentHint_PythonToCpp_QFlags_QPainter_PixmapFragmentHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QPainter::PixmapFragmentHint> *>(cppOut) =
        ::QFlags<QPainter::PixmapFragmentHint>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QPainter_PixmapFragmentHint_PythonToCpp_QFlags_QPainter_PixmapFragmentHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENTHINT_IDX]))
        return QPainter_PixmapFragmentHint_PythonToCpp_QFlags_QPainter_PixmapFragmentHint_;
    return {};
}
static void number_PythonToCpp_QFlags_QPainter_PixmapFragmentHint_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QPainter::PixmapFragmentHint> *>(cppOut) =
        ::QFlags<QPainter::PixmapFragmentHint>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QPainter_PixmapFragmentHint__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENTHINT_IDX]))
        return number_PythonToCpp_QFlags_QPainter_PixmapFragmentHint_;
    return {};
}
static void QPainter_CompositionMode_PythonToCpp_QPainter_CompositionMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPainter::CompositionMode *>(cppOut) =
        static_cast<::QPainter::CompositionMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPainter_CompositionMode_PythonToCpp_QPainter_CompositionMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX]))
        return QPainter_CompositionMode_PythonToCpp_QPainter_CompositionMode;
    return {};
}
static PyObject *QPainter_CompositionMode_CppToPython_QPainter_CompositionMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPainter::CompositionMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPainter_PythonToCpp_QPainter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPainter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPainter_PythonToCpp_QPainter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPainter_TypeF())))
        return QPainter_PythonToCpp_QPainter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPainter_PTR_CppToPython_QPainter(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPainter *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPainter_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPainter_SignatureStrings[] = {
    "1:PySide2.QtGui.QPainter(self)",
    "0:PySide2.QtGui.QPainter(self,arg__1:PySide2.QtGui.QPaintDevice)",
    "PySide2.QtGui.QPainter.background(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPainter.backgroundMode(self)->PySide2.QtCore.Qt.BGMode",
    "PySide2.QtGui.QPainter.begin(self,arg__1:PySide2.QtGui.QPaintDevice)->bool",
    "PySide2.QtGui.QPainter.beginNativePainting(self)",
    "3:PySide2.QtGui.QPainter.boundingRect(self,rect:PySide2.QtCore.QRect,flags:int,text:QString)->PySide2.QtCore.QRect",
    "2:PySide2.QtGui.QPainter.boundingRect(self,rect:PySide2.QtCore.QRectF,text:QString,o:PySide2.QtGui.QTextOption=QTextOption())->PySide2.QtCore.QRectF",
    "1:PySide2.QtGui.QPainter.boundingRect(self,rect:PySide2.QtCore.QRectF,flags:int,text:QString)->PySide2.QtCore.QRectF",
    "0:PySide2.QtGui.QPainter.boundingRect(self,x:int,y:int,w:int,h:int,flags:int,text:QString)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QPainter.brush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPainter.brushOrigin(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QPainter.clipBoundingRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QPainter.clipPath(self)->PySide2.QtGui.QPainterPath",
    "PySide2.QtGui.QPainter.clipRegion(self)->PySide2.QtGui.QRegion",
    "PySide2.QtGui.QPainter.combinedMatrix(self)->PySide2.QtGui.QMatrix",
    "PySide2.QtGui.QPainter.combinedTransform(self)->PySide2.QtGui.QTransform",
    "PySide2.QtGui.QPainter.compositionMode(self)->PySide2.QtGui.QPainter.CompositionMode",
    "PySide2.QtGui.QPainter.device(self)->PySide2.QtGui.QPaintDevice",
    "PySide2.QtGui.QPainter.deviceMatrix(self)->PySide2.QtGui.QMatrix",
    "PySide2.QtGui.QPainter.deviceTransform(self)->PySide2.QtGui.QTransform",
    "2:PySide2.QtGui.QPainter.drawArc(self,arg__1:PySide2.QtCore.QRect,a:int,alen:int)",
    "1:PySide2.QtGui.QPainter.drawArc(self,rect:PySide2.QtCore.QRectF,a:int,alen:int)",
    "0:PySide2.QtGui.QPainter.drawArc(self,x:int,y:int,w:int,h:int,a:int,alen:int)",
    "2:PySide2.QtGui.QPainter.drawChord(self,arg__1:PySide2.QtCore.QRect,a:int,alen:int)",
    "1:PySide2.QtGui.QPainter.drawChord(self,rect:PySide2.QtCore.QRectF,a:int,alen:int)",
    "0:PySide2.QtGui.QPainter.drawChord(self,x:int,y:int,w:int,h:int,a:int,alen:int)",
    "3:PySide2.QtGui.QPainter.drawConvexPolygon(self,arg__1:QVector[PySide2.QtCore.QPoint])",
    "2:PySide2.QtGui.QPainter.drawConvexPolygon(self,arg__1:QVector[PySide2.QtCore.QPointF])",
    "1:PySide2.QtGui.QPainter.drawConvexPolygon(self,polygon:PySide2.QtGui.QPolygon)",
    "0:PySide2.QtGui.QPainter.drawConvexPolygon(self,polygon:PySide2.QtGui.QPolygonF)",
    "4:PySide2.QtGui.QPainter.drawEllipse(self,center:PySide2.QtCore.QPoint,rx:int,ry:int)",
    "3:PySide2.QtGui.QPainter.drawEllipse(self,center:PySide2.QtCore.QPointF,rx:qreal,ry:qreal)",
    "2:PySide2.QtGui.QPainter.drawEllipse(self,r:PySide2.QtCore.QRect)",
    "1:PySide2.QtGui.QPainter.drawEllipse(self,r:PySide2.QtCore.QRectF)",
    "0:PySide2.QtGui.QPainter.drawEllipse(self,x:int,y:int,w:int,h:int)",
    "8:PySide2.QtGui.QPainter.drawImage(self,p:PySide2.QtCore.QPoint,image:PySide2.QtGui.QImage)",
    "7:PySide2.QtGui.QPainter.drawImage(self,p:PySide2.QtCore.QPoint,image:PySide2.QtGui.QImage,sr:PySide2.QtCore.QRect,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)",
    "6:PySide2.QtGui.QPainter.drawImage(self,p:PySide2.QtCore.QPointF,image:PySide2.QtGui.QImage)",
    "5:PySide2.QtGui.QPainter.drawImage(self,p:PySide2.QtCore.QPointF,image:PySide2.QtGui.QImage,sr:PySide2.QtCore.QRectF,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)",
    "4:PySide2.QtGui.QPainter.drawImage(self,r:PySide2.QtCore.QRect,image:PySide2.QtGui.QImage)",
    "3:PySide2.QtGui.QPainter.drawImage(self,targetRect:PySide2.QtCore.QRect,image:PySide2.QtGui.QImage,sourceRect:PySide2.QtCore.QRect,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)",
    "2:PySide2.QtGui.QPainter.drawImage(self,r:PySide2.QtCore.QRectF,image:PySide2.QtGui.QImage)",
    "1:PySide2.QtGui.QPainter.drawImage(self,targetRect:PySide2.QtCore.QRectF,image:PySide2.QtGui.QImage,sourceRect:PySide2.QtCore.QRectF,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)",
    "0:PySide2.QtGui.QPainter.drawImage(self,x:int,y:int,image:PySide2.QtGui.QImage,sx:int=0,sy:int=0,sw:int=-1,sh:int=-1,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)",
    "4:PySide2.QtGui.QPainter.drawLine(self,line:PySide2.QtCore.QLine)",
    "3:PySide2.QtGui.QPainter.drawLine(self,line:PySide2.QtCore.QLineF)",
    "2:PySide2.QtGui.QPainter.drawLine(self,p1:PySide2.QtCore.QPoint,p2:PySide2.QtCore.QPoint)",
    "1:PySide2.QtGui.QPainter.drawLine(self,p1:PySide2.QtCore.QPointF,p2:PySide2.QtCore.QPointF)",
    "0:PySide2.QtGui.QPainter.drawLine(self,x1:int,y1:int,x2:int,y2:int)",
    "3:PySide2.QtGui.QPainter.drawLines(self,lines:QVector[PySide2.QtCore.QLine])",
    "2:PySide2.QtGui.QPainter.drawLines(self,lines:QVector[PySide2.QtCore.QLineF])",
    "1:PySide2.QtGui.QPainter.drawLines(self,pointPairs:QVector[PySide2.QtCore.QPoint])",
    "0:PySide2.QtGui.QPainter.drawLines(self,pointPairs:QVector[PySide2.QtCore.QPointF])",
    "PySide2.QtGui.QPainter.drawPath(self,path:PySide2.QtGui.QPainterPath)",
    "2:PySide2.QtGui.QPainter.drawPicture(self,p:PySide2.QtCore.QPoint,picture:PySide2.QtGui.QPicture)",
    "1:PySide2.QtGui.QPainter.drawPicture(self,p:PySide2.QtCore.QPointF,picture:PySide2.QtGui.QPicture)",
    "0:PySide2.QtGui.QPainter.drawPicture(self,x:int,y:int,picture:PySide2.QtGui.QPicture)",
    "2:PySide2.QtGui.QPainter.drawPie(self,arg__1:PySide2.QtCore.QRect,a:int,alen:int)",
    "1:PySide2.QtGui.QPainter.drawPie(self,rect:PySide2.QtCore.QRectF,a:int,alen:int)",
    "0:PySide2.QtGui.QPainter.drawPie(self,x:int,y:int,w:int,h:int,a:int,alen:int)",
    "10:PySide2.QtGui.QPainter.drawPixmap(self,p:PySide2.QtCore.QPoint,pm:PySide2.QtGui.QPixmap)",
    "9:PySide2.QtGui.QPainter.drawPixmap(self,p:PySide2.QtCore.QPoint,pm:PySide2.QtGui.QPixmap,sr:PySide2.QtCore.QRect)",
    "8:PySide2.QtGui.QPainter.drawPixmap(self,p:PySide2.QtCore.QPointF,pm:PySide2.QtGui.QPixmap)",
    "7:PySide2.QtGui.QPainter.drawPixmap(self,p:PySide2.QtCore.QPointF,pm:PySide2.QtGui.QPixmap,sr:PySide2.QtCore.QRectF)",
    "6:PySide2.QtGui.QPainter.drawPixmap(self,r:PySide2.QtCore.QRect,pm:PySide2.QtGui.QPixmap)",
    "5:PySide2.QtGui.QPainter.drawPixmap(self,targetRect:PySide2.QtCore.QRect,pixmap:PySide2.QtGui.QPixmap,sourceRect:PySide2.QtCore.QRect)",
    "4:PySide2.QtGui.QPainter.drawPixmap(self,targetRect:PySide2.QtCore.QRectF,pixmap:PySide2.QtGui.QPixmap,sourceRect:PySide2.QtCore.QRectF)",
    "3:PySide2.QtGui.QPainter.drawPixmap(self,x:int,y:int,pm:PySide2.QtGui.QPixmap)",
    "2:PySide2.QtGui.QPainter.drawPixmap(self,x:int,y:int,pm:PySide2.QtGui.QPixmap,sx:int,sy:int,sw:int,sh:int)",
    "1:PySide2.QtGui.QPainter.drawPixmap(self,x:int,y:int,w:int,h:int,pm:PySide2.QtGui.QPixmap)",
    "0:PySide2.QtGui.QPainter.drawPixmap(self,x:int,y:int,w:int,h:int,pm:PySide2.QtGui.QPixmap,sx:int,sy:int,sw:int,sh:int)",
    "PySide2.QtGui.QPainter.drawPixmapFragments(self,fragments:PySide2.QtGui.QPainter.PixmapFragment,fragmentCount:int,pixmap:PySide2.QtGui.QPixmap,hints:PySide2.QtGui.QPainter.PixmapFragmentHints=QPainter.PixmapFragmentHints())",
    "2:PySide2.QtGui.QPainter.drawPoint(self,p:PySide2.QtCore.QPoint)",
    "1:PySide2.QtGui.QPainter.drawPoint(self,pt:PySide2.QtCore.QPointF)",
    "0:PySide2.QtGui.QPainter.drawPoint(self,x:int,y:int)",
    "3:PySide2.QtGui.QPainter.drawPoints(self,arg__1:QVector[PySide2.QtCore.QPoint])",
    "2:PySide2.QtGui.QPainter.drawPoints(self,arg__1:QVector[PySide2.QtCore.QPointF])",
    "1:PySide2.QtGui.QPainter.drawPoints(self,points:PySide2.QtGui.QPolygon)",
    "0:PySide2.QtGui.QPainter.drawPoints(self,points:PySide2.QtGui.QPolygonF)",
    "3:PySide2.QtGui.QPainter.drawPolygon(self,arg__1:QVector[PySide2.QtCore.QPoint],arg__2:PySide2.QtCore.Qt.FillRule)",
    "2:PySide2.QtGui.QPainter.drawPolygon(self,arg__1:QVector[PySide2.QtCore.QPointF],arg__2:PySide2.QtCore.Qt.FillRule)",
    "1:PySide2.QtGui.QPainter.drawPolygon(self,polygon:PySide2.QtGui.QPolygon,fillRule:PySide2.QtCore.Qt.FillRule=Qt.OddEvenFill)",
    "0:PySide2.QtGui.QPainter.drawPolygon(self,polygon:PySide2.QtGui.QPolygonF,fillRule:PySide2.QtCore.Qt.FillRule=Qt.OddEvenFill)",
    "3:PySide2.QtGui.QPainter.drawPolyline(self,arg__1:QVector[PySide2.QtCore.QPoint])",
    "2:PySide2.QtGui.QPainter.drawPolyline(self,arg__1:QVector[PySide2.QtCore.QPointF])",
    "1:PySide2.QtGui.QPainter.drawPolyline(self,polygon:PySide2.QtGui.QPolygon)",
    "0:PySide2.QtGui.QPainter.drawPolyline(self,polyline:PySide2.QtGui.QPolygonF)",
    "2:PySide2.QtGui.QPainter.drawRect(self,rect:PySide2.QtCore.QRect)",
    "1:PySide2.QtGui.QPainter.drawRect(self,rect:PySide2.QtCore.QRectF)",
    "0:PySide2.QtGui.QPainter.drawRect(self,x1:int,y1:int,w:int,h:int)",
    "1:PySide2.QtGui.QPainter.drawRects(self,rectangles:QVector[PySide2.QtCore.QRect])",
    "0:PySide2.QtGui.QPainter.drawRects(self,rectangles:QVector[PySide2.QtCore.QRectF])",
    "2:PySide2.QtGui.QPainter.drawRoundRect(self,r:PySide2.QtCore.QRect,xround:int=25,yround:int=25)",
    "1:PySide2.QtGui.QPainter.drawRoundRect(self,r:PySide2.QtCore.QRectF,xround:int=25,yround:int=25)",
    "0:PySide2.QtGui.QPainter.drawRoundRect(self,x:int,y:int,w:int,h:int,xRound:int=25,yRound:int=25)",
    "2:PySide2.QtGui.QPainter.drawRoundedRect(self,rect:PySide2.QtCore.QRect,xRadius:qreal,yRadius:qreal,mode:PySide2.QtCore.Qt.SizeMode=Qt.AbsoluteSize)",
    "1:PySide2.QtGui.QPainter.drawRoundedRect(self,rect:PySide2.QtCore.QRectF,xRadius:qreal,yRadius:qreal,mode:PySide2.QtCore.Qt.SizeMode=Qt.AbsoluteSize)",
    "0:PySide2.QtGui.QPainter.drawRoundedRect(self,x:int,y:int,w:int,h:int,xRadius:qreal,yRadius:qreal,mode:PySide2.QtCore.Qt.SizeMode=Qt.AbsoluteSize)",
    "2:PySide2.QtGui.QPainter.drawStaticText(self,topLeftPosition:PySide2.QtCore.QPoint,staticText:PySide2.QtGui.QStaticText)",
    "1:PySide2.QtGui.QPainter.drawStaticText(self,topLeftPosition:PySide2.QtCore.QPointF,staticText:PySide2.QtGui.QStaticText)",
    "0:PySide2.QtGui.QPainter.drawStaticText(self,left:int,top:int,staticText:PySide2.QtGui.QStaticText)",
    "6:PySide2.QtGui.QPainter.drawText(self,p:PySide2.QtCore.QPoint,s:QString)",
    "5:PySide2.QtGui.QPainter.drawText(self,p:PySide2.QtCore.QPointF,s:QString)",
    "4:PySide2.QtGui.QPainter.drawText(self,r:PySide2.QtCore.QRect,flags:int,text:QString,br:PySide2.QtCore.QRect)",
    "3:PySide2.QtGui.QPainter.drawText(self,r:PySide2.QtCore.QRectF,text:QString,o:PySide2.QtGui.QTextOption=QTextOption())",
    "2:PySide2.QtGui.QPainter.drawText(self,r:PySide2.QtCore.QRectF,flags:int,text:QString,br:PySide2.QtCore.QRectF)",
    "1:PySide2.QtGui.QPainter.drawText(self,x:int,y:int,s:QString)",
    "0:PySide2.QtGui.QPainter.drawText(self,x:int,y:int,w:int,h:int,flags:int,text:QString,br:PySide2.QtCore.QRect)",
    "2:PySide2.QtGui.QPainter.drawTextItem(self,p:PySide2.QtCore.QPoint,ti:PySide2.QtGui.QTextItem)",
    "1:PySide2.QtGui.QPainter.drawTextItem(self,p:PySide2.QtCore.QPointF,ti:PySide2.QtGui.QTextItem)",
    "0:PySide2.QtGui.QPainter.drawTextItem(self,x:int,y:int,ti:PySide2.QtGui.QTextItem)",
    "2:PySide2.QtGui.QPainter.drawTiledPixmap(self,arg__1:PySide2.QtCore.QRect,arg__2:PySide2.QtGui.QPixmap,pos:PySide2.QtCore.QPoint=QPoint())",
    "1:PySide2.QtGui.QPainter.drawTiledPixmap(self,rect:PySide2.QtCore.QRectF,pm:PySide2.QtGui.QPixmap,offset:PySide2.QtCore.QPointF=QPointF())",
    "0:PySide2.QtGui.QPainter.drawTiledPixmap(self,x:int,y:int,w:int,h:int,arg__5:PySide2.QtGui.QPixmap,sx:int=0,sy:int=0)",
    "PySide2.QtGui.QPainter.end(self)->bool",
    "PySide2.QtGui.QPainter.endNativePainting(self)",
    "2:PySide2.QtGui.QPainter.eraseRect(self,arg__1:PySide2.QtCore.QRect)",
    "1:PySide2.QtGui.QPainter.eraseRect(self,arg__1:PySide2.QtCore.QRectF)",
    "0:PySide2.QtGui.QPainter.eraseRect(self,x:int,y:int,w:int,h:int)",
    "PySide2.QtGui.QPainter.fillPath(self,path:PySide2.QtGui.QPainterPath,brush:PySide2.QtGui.QBrush)",
    "14:PySide2.QtGui.QPainter.fillRect(self,arg__1:PySide2.QtCore.QRect,arg__2:PySide2.QtGui.QBrush)",
    "13:PySide2.QtGui.QPainter.fillRect(self,arg__1:PySide2.QtCore.QRect,color:PySide2.QtGui.QColor)",
    "12:PySide2.QtGui.QPainter.fillRect(self,r:PySide2.QtCore.QRect,preset:PySide2.QtGui.QGradient.Preset)",
    "11:PySide2.QtGui.QPainter.fillRect(self,r:PySide2.QtCore.QRect,style:PySide2.QtCore.Qt.BrushStyle)",
    "10:PySide2.QtGui.QPainter.fillRect(self,r:PySide2.QtCore.QRect,c:PySide2.QtCore.Qt.GlobalColor)",
    "9:PySide2.QtGui.QPainter.fillRect(self,arg__1:PySide2.QtCore.QRectF,arg__2:PySide2.QtGui.QBrush)",
    "8:PySide2.QtGui.QPainter.fillRect(self,arg__1:PySide2.QtCore.QRectF,color:PySide2.QtGui.QColor)",
    "7:PySide2.QtGui.QPainter.fillRect(self,r:PySide2.QtCore.QRectF,preset:PySide2.QtGui.QGradient.Preset)",
    "6:PySide2.QtGui.QPainter.fillRect(self,r:PySide2.QtCore.QRectF,style:PySide2.QtCore.Qt.BrushStyle)",
    "5:PySide2.QtGui.QPainter.fillRect(self,r:PySide2.QtCore.QRectF,c:PySide2.QtCore.Qt.GlobalColor)",
    "4:PySide2.QtGui.QPainter.fillRect(self,x:int,y:int,w:int,h:int,preset:PySide2.QtGui.QGradient.Preset)",
    "3:PySide2.QtGui.QPainter.fillRect(self,x:int,y:int,w:int,h:int,style:PySide2.QtCore.Qt.BrushStyle)",
    "2:PySide2.QtGui.QPainter.fillRect(self,x:int,y:int,w:int,h:int,c:PySide2.QtCore.Qt.GlobalColor)",
    "1:PySide2.QtGui.QPainter.fillRect(self,x:int,y:int,w:int,h:int,arg__5:PySide2.QtGui.QBrush)",
    "0:PySide2.QtGui.QPainter.fillRect(self,x:int,y:int,w:int,h:int,color:PySide2.QtGui.QColor)",
    "PySide2.QtGui.QPainter.font(self)->PySide2.QtGui.QFont",
    "PySide2.QtGui.QPainter.fontInfo(self)->PySide2.QtGui.QFontInfo",
    "PySide2.QtGui.QPainter.fontMetrics(self)->PySide2.QtGui.QFontMetrics",
    "PySide2.QtGui.QPainter.hasClipping(self)->bool",
    "PySide2.QtGui.QPainter.initFrom(self,device:PySide2.QtGui.QPaintDevice)",
    "PySide2.QtGui.QPainter.isActive(self)->bool",
    "PySide2.QtGui.QPainter.layoutDirection(self)->PySide2.QtCore.Qt.LayoutDirection",
    "PySide2.QtGui.QPainter.matrix(self)->PySide2.QtGui.QMatrix",
    "PySide2.QtGui.QPainter.matrixEnabled(self)->bool",
    "PySide2.QtGui.QPainter.opacity(self)->qreal",
    "PySide2.QtGui.QPainter.paintEngine(self)->PySide2.QtGui.QPaintEngine",
    "PySide2.QtGui.QPainter.pen(self)->PySide2.QtGui.QPen",
    "PySide2.QtGui.QPainter.redirected(device:PySide2.QtGui.QPaintDevice,offset:PySide2.QtCore.QPoint=nullptr)->PySide2.QtGui.QPaintDevice",
    "PySide2.QtGui.QPainter.renderHints(self)->PySide2.QtGui.QPainter.RenderHints",
    "PySide2.QtGui.QPainter.resetMatrix(self)",
    "PySide2.QtGui.QPainter.resetTransform(self)",
    "PySide2.QtGui.QPainter.restore(self)",
    "PySide2.QtGui.QPainter.restoreRedirected(device:PySide2.QtGui.QPaintDevice)",
    "PySide2.QtGui.QPainter.rotate(self,a:qreal)",
    "PySide2.QtGui.QPainter.save(self)",
    "PySide2.QtGui.QPainter.scale(self,sx:qreal,sy:qreal)",
    "PySide2.QtGui.QPainter.setBackground(self,bg:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QPainter.setBackgroundMode(self,mode:PySide2.QtCore.Qt.BGMode)",
    "1:PySide2.QtGui.QPainter.setBrush(self,style:PySide2.QtCore.Qt.BrushStyle)",
    "0:PySide2.QtGui.QPainter.setBrush(self,brush:PySide2.QtGui.QBrush)",
    "2:PySide2.QtGui.QPainter.setBrushOrigin(self,arg__1:PySide2.QtCore.QPoint)",
    "1:PySide2.QtGui.QPainter.setBrushOrigin(self,arg__1:PySide2.QtCore.QPointF)",
    "0:PySide2.QtGui.QPainter.setBrushOrigin(self,x:int,y:int)",
    "PySide2.QtGui.QPainter.setClipPath(self,path:PySide2.QtGui.QPainterPath,op:PySide2.QtCore.Qt.ClipOperation=Qt.ReplaceClip)",
    "2:PySide2.QtGui.QPainter.setClipRect(self,arg__1:PySide2.QtCore.QRect,op:PySide2.QtCore.Qt.ClipOperation=Qt.ReplaceClip)",
    "1:PySide2.QtGui.QPainter.setClipRect(self,arg__1:PySide2.QtCore.QRectF,op:PySide2.QtCore.Qt.ClipOperation=Qt.ReplaceClip)",
    "0:PySide2.QtGui.QPainter.setClipRect(self,x:int,y:int,w:int,h:int,op:PySide2.QtCore.Qt.ClipOperation=Qt.ReplaceClip)",
    "PySide2.QtGui.QPainter.setClipRegion(self,arg__1:PySide2.QtGui.QRegion,op:PySide2.QtCore.Qt.ClipOperation=Qt.ReplaceClip)",
    "PySide2.QtGui.QPainter.setClipping(self,enable:bool)",
    "PySide2.QtGui.QPainter.setCompositionMode(self,mode:PySide2.QtGui.QPainter.CompositionMode)",
    "PySide2.QtGui.QPainter.setFont(self,f:PySide2.QtGui.QFont)",
    "PySide2.QtGui.QPainter.setLayoutDirection(self,direction:PySide2.QtCore.Qt.LayoutDirection)",
    "PySide2.QtGui.QPainter.setMatrix(self,matrix:PySide2.QtGui.QMatrix,combine:bool=false)",
    "PySide2.QtGui.QPainter.setMatrixEnabled(self,enabled:bool)",
    "PySide2.QtGui.QPainter.setOpacity(self,opacity:qreal)",
    "2:PySide2.QtGui.QPainter.setPen(self,style:PySide2.QtCore.Qt.PenStyle)",
    "1:PySide2.QtGui.QPainter.setPen(self,color:PySide2.QtGui.QColor)",
    "0:PySide2.QtGui.QPainter.setPen(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtGui.QPainter.setRedirected(device:PySide2.QtGui.QPaintDevice,replacement:PySide2.QtGui.QPaintDevice,offset:PySide2.QtCore.QPoint=QPoint())",
    "PySide2.QtGui.QPainter.setRenderHint(self,hint:PySide2.QtGui.QPainter.RenderHint,on:bool=true)",
    "PySide2.QtGui.QPainter.setRenderHints(self,hints:PySide2.QtGui.QPainter.RenderHints,on:bool=true)",
    "PySide2.QtGui.QPainter.setTransform(self,transform:PySide2.QtGui.QTransform,combine:bool=false)",
    "PySide2.QtGui.QPainter.setViewTransformEnabled(self,enable:bool)",
    "1:PySide2.QtGui.QPainter.setViewport(self,viewport:PySide2.QtCore.QRect)",
    "0:PySide2.QtGui.QPainter.setViewport(self,x:int,y:int,w:int,h:int)",
    "1:PySide2.QtGui.QPainter.setWindow(self,window:PySide2.QtCore.QRect)",
    "0:PySide2.QtGui.QPainter.setWindow(self,x:int,y:int,w:int,h:int)",
    "PySide2.QtGui.QPainter.setWorldMatrix(self,matrix:PySide2.QtGui.QMatrix,combine:bool=false)",
    "PySide2.QtGui.QPainter.setWorldMatrixEnabled(self,enabled:bool)",
    "PySide2.QtGui.QPainter.setWorldTransform(self,matrix:PySide2.QtGui.QTransform,combine:bool=false)",
    "PySide2.QtGui.QPainter.shear(self,sh:qreal,sv:qreal)",
    "PySide2.QtGui.QPainter.strokePath(self,path:PySide2.QtGui.QPainterPath,pen:PySide2.QtGui.QPen)",
    "PySide2.QtGui.QPainter.testRenderHint(self,hint:PySide2.QtGui.QPainter.RenderHint)->bool",
    "PySide2.QtGui.QPainter.transform(self)->PySide2.QtGui.QTransform",
    "2:PySide2.QtGui.QPainter.translate(self,offset:PySide2.QtCore.QPoint)",
    "1:PySide2.QtGui.QPainter.translate(self,offset:PySide2.QtCore.QPointF)",
    "0:PySide2.QtGui.QPainter.translate(self,dx:qreal,dy:qreal)",
    "PySide2.QtGui.QPainter.viewTransformEnabled(self)->bool",
    "PySide2.QtGui.QPainter.viewport(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QPainter.window(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QPainter.worldMatrix(self)->PySide2.QtGui.QMatrix",
    "PySide2.QtGui.QPainter.worldMatrixEnabled(self)->bool",
    "PySide2.QtGui.QPainter.worldTransform(self)->PySide2.QtGui.QTransform",
    nullptr}; // Sentinel

void init_QPainter(PyObject *module)
{
    _Sbk_QPainter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPainter",
        "QPainter*",
        &Sbk_QPainter_spec,
        &Shiboken::callCppDestructor< ::QPainter >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPainter_Type);
    InitSignatureStrings(pyType, QPainter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPainter_Type), Sbk_QPainter_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPainter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPainter_TypeF(),
        QPainter_PythonToCpp_QPainter_PTR,
        is_QPainter_PythonToCpp_QPainter_PTR_Convertible,
        QPainter_PTR_CppToPython_QPainter);

    Shiboken::Conversions::registerConverterName(converter, "QPainter");
    Shiboken::Conversions::registerConverterName(converter, "QPainter*");
    Shiboken::Conversions::registerConverterName(converter, "QPainter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPainter).name());


    // Initialization of enums.

    // Initialization of enum 'RenderHint'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QPainter.RenderHints", SbkPySide2_QtGui_QPainter_RenderHint_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPainter_TypeF(),
        "RenderHint",
        "2:PySide2.QtGui.QPainter.RenderHint",
        "QPainter::RenderHint",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX],
        Sbk_QPainter_TypeF(), "Antialiasing", (long) QPainter::RenderHint::Antialiasing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX],
        Sbk_QPainter_TypeF(), "TextAntialiasing", (long) QPainter::RenderHint::TextAntialiasing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX],
        Sbk_QPainter_TypeF(), "SmoothPixmapTransform", (long) QPainter::RenderHint::SmoothPixmapTransform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX],
        Sbk_QPainter_TypeF(), "HighQualityAntialiasing", (long) QPainter::RenderHint::HighQualityAntialiasing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX],
        Sbk_QPainter_TypeF(), "NonCosmeticDefaultPen", (long) QPainter::RenderHint::NonCosmeticDefaultPen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX],
        Sbk_QPainter_TypeF(), "Qt4CompatiblePainting", (long) QPainter::RenderHint::Qt4CompatiblePainting))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX],
        Sbk_QPainter_TypeF(), "LosslessImageRendering", (long) QPainter::RenderHint::LosslessImageRendering))
        return;
    // Register converter for enum 'QPainter::RenderHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX],
            QPainter_RenderHint_CppToPython_QPainter_RenderHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPainter_RenderHint_PythonToCpp_QPainter_RenderHint,
            is_QPainter_RenderHint_PythonToCpp_QPainter_RenderHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPainter::RenderHint");
        Shiboken::Conversions::registerConverterName(converter, "RenderHint");
    }
    // Register converter for flag 'QFlags<QPainter::RenderHint>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX],
            QFlags_QPainter_RenderHint__CppToPython_QFlags_QPainter_RenderHint_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPainter_RenderHint_PythonToCpp_QFlags_QPainter_RenderHint_,
            is_QPainter_RenderHint_PythonToCpp_QFlags_QPainter_RenderHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QPainter_RenderHint__PythonToCpp_QFlags_QPainter_RenderHint_,
            is_QFlags_QPainter_RenderHint__PythonToCpp_QFlags_QPainter_RenderHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QPainter_RenderHint_,
            is_number_PythonToCpp_QFlags_QPainter_RenderHint__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPainter::RenderHints");
        Shiboken::Conversions::registerConverterName(converter, "RenderHints");
    }
    // End of 'RenderHint' enum/flags.

    // Initialization of enum 'PixmapFragmentHint'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QPainter.PixmapFragmentHints", SbkPySide2_QtGui_QPainter_PixmapFragmentHint_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENTHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPainter_TypeF(),
        "PixmapFragmentHint",
        "2:PySide2.QtGui.QPainter.PixmapFragmentHint",
        "QPainter::PixmapFragmentHint",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENTHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENTHINT_IDX],
        Sbk_QPainter_TypeF(), "OpaqueHint", (long) QPainter::PixmapFragmentHint::OpaqueHint))
        return;
    // Register converter for enum 'QPainter::PixmapFragmentHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENTHINT_IDX],
            QPainter_PixmapFragmentHint_CppToPython_QPainter_PixmapFragmentHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPainter_PixmapFragmentHint_PythonToCpp_QPainter_PixmapFragmentHint,
            is_QPainter_PixmapFragmentHint_PythonToCpp_QPainter_PixmapFragmentHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENTHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPainter::PixmapFragmentHint");
        Shiboken::Conversions::registerConverterName(converter, "PixmapFragmentHint");
    }
    // Register converter for flag 'QFlags<QPainter::PixmapFragmentHint>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX],
            QFlags_QPainter_PixmapFragmentHint__CppToPython_QFlags_QPainter_PixmapFragmentHint_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPainter_PixmapFragmentHint_PythonToCpp_QFlags_QPainter_PixmapFragmentHint_,
            is_QPainter_PixmapFragmentHint_PythonToCpp_QFlags_QPainter_PixmapFragmentHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QPainter_PixmapFragmentHint__PythonToCpp_QFlags_QPainter_PixmapFragmentHint_,
            is_QFlags_QPainter_PixmapFragmentHint__PythonToCpp_QFlags_QPainter_PixmapFragmentHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QPainter_PixmapFragmentHint_,
            is_number_PythonToCpp_QFlags_QPainter_PixmapFragmentHint__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_PIXMAPFRAGMENTHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPainter::PixmapFragmentHints");
        Shiboken::Conversions::registerConverterName(converter, "PixmapFragmentHints");
    }
    // End of 'PixmapFragmentHint' enum/flags.

    // Initialization of enum 'CompositionMode'.
    SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPainter_TypeF(),
        "CompositionMode",
        "2:PySide2.QtGui.QPainter.CompositionMode",
        "QPainter::CompositionMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_SourceOver", (long) QPainter::CompositionMode::CompositionMode_SourceOver))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_DestinationOver", (long) QPainter::CompositionMode::CompositionMode_DestinationOver))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Clear", (long) QPainter::CompositionMode::CompositionMode_Clear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Source", (long) QPainter::CompositionMode::CompositionMode_Source))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Destination", (long) QPainter::CompositionMode::CompositionMode_Destination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_SourceIn", (long) QPainter::CompositionMode::CompositionMode_SourceIn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_DestinationIn", (long) QPainter::CompositionMode::CompositionMode_DestinationIn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_SourceOut", (long) QPainter::CompositionMode::CompositionMode_SourceOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_DestinationOut", (long) QPainter::CompositionMode::CompositionMode_DestinationOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_SourceAtop", (long) QPainter::CompositionMode::CompositionMode_SourceAtop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_DestinationAtop", (long) QPainter::CompositionMode::CompositionMode_DestinationAtop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Xor", (long) QPainter::CompositionMode::CompositionMode_Xor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Plus", (long) QPainter::CompositionMode::CompositionMode_Plus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Multiply", (long) QPainter::CompositionMode::CompositionMode_Multiply))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Screen", (long) QPainter::CompositionMode::CompositionMode_Screen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Overlay", (long) QPainter::CompositionMode::CompositionMode_Overlay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Darken", (long) QPainter::CompositionMode::CompositionMode_Darken))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Lighten", (long) QPainter::CompositionMode::CompositionMode_Lighten))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_ColorDodge", (long) QPainter::CompositionMode::CompositionMode_ColorDodge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_ColorBurn", (long) QPainter::CompositionMode::CompositionMode_ColorBurn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_HardLight", (long) QPainter::CompositionMode::CompositionMode_HardLight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_SoftLight", (long) QPainter::CompositionMode::CompositionMode_SoftLight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Difference", (long) QPainter::CompositionMode::CompositionMode_Difference))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "CompositionMode_Exclusion", (long) QPainter::CompositionMode::CompositionMode_Exclusion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_SourceOrDestination", (long) QPainter::CompositionMode::RasterOp_SourceOrDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_SourceAndDestination", (long) QPainter::CompositionMode::RasterOp_SourceAndDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_SourceXorDestination", (long) QPainter::CompositionMode::RasterOp_SourceXorDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_NotSourceAndNotDestination", (long) QPainter::CompositionMode::RasterOp_NotSourceAndNotDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_NotSourceOrNotDestination", (long) QPainter::CompositionMode::RasterOp_NotSourceOrNotDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_NotSourceXorDestination", (long) QPainter::CompositionMode::RasterOp_NotSourceXorDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_NotSource", (long) QPainter::CompositionMode::RasterOp_NotSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_NotSourceAndDestination", (long) QPainter::CompositionMode::RasterOp_NotSourceAndDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_SourceAndNotDestination", (long) QPainter::CompositionMode::RasterOp_SourceAndNotDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_NotSourceOrDestination", (long) QPainter::CompositionMode::RasterOp_NotSourceOrDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_SourceOrNotDestination", (long) QPainter::CompositionMode::RasterOp_SourceOrNotDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_ClearDestination", (long) QPainter::CompositionMode::RasterOp_ClearDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_SetDestination", (long) QPainter::CompositionMode::RasterOp_SetDestination))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
        Sbk_QPainter_TypeF(), "RasterOp_NotDestination", (long) QPainter::CompositionMode::RasterOp_NotDestination))
        return;
    // Register converter for enum 'QPainter::CompositionMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX],
            QPainter_CompositionMode_CppToPython_QPainter_CompositionMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPainter_CompositionMode_PythonToCpp_QPainter_CompositionMode,
            is_QPainter_CompositionMode_PythonToCpp_QPainter_CompositionMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPainter::CompositionMode");
        Shiboken::Conversions::registerConverterName(converter, "CompositionMode");
    }
    // End of 'CompositionMode' enum.

    qRegisterMetaType< ::QPainter::RenderHint >("QPainter::RenderHint");
    qRegisterMetaType< ::QPainter::RenderHints >("QPainter::RenderHints");
    qRegisterMetaType< ::QPainter::PixmapFragmentHint >("QPainter::PixmapFragmentHint");
    qRegisterMetaType< ::QPainter::PixmapFragmentHints >("QPainter::PixmapFragmentHints");
    qRegisterMetaType< ::QPainter::CompositionMode >("QPainter::CompositionMode");
}
