/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpaintengine_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPaintEngineWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPaintEngineWrapper::QPaintEngineWrapper(::QFlags<QPaintEngine::PaintEngineFeature> features) : QPaintEngine(features)
{
    resetPyMethodCache();
    // ... middle
}

bool QPaintEngineWrapper::begin(::QPaintDevice * pdev)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.begin()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "begin";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.begin()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pdev)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPaintEngine.begin", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

::QPoint QPaintEngineWrapper::coordinateOffset() const
{
    if (m_PyMethodCache[1])
        return this->::QPaintEngine::coordinateOffset();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "coordinateOffset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QPaintEngine::coordinateOffset();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPaintEngine.coordinateOffset", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPoint >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QPoint cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPaintEngineWrapper::drawEllipse(const ::QRect & r)
{
    if (m_PyMethodCache[2]) {
        return this->::QPaintEngine::drawEllipse(r);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawEllipse";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QPaintEngine::drawEllipse(r);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &r)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawEllipse(const ::QRectF & r)
{
    if (m_PyMethodCache[3]) {
        return this->::QPaintEngine::drawEllipse(r);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawEllipse";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QPaintEngine::drawEllipse(r);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &r)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawImage(const ::QRectF & r, const ::QImage & pm, const ::QRectF & sr, ::QFlags<Qt::ImageConversionFlag> flags)
{
    if (m_PyMethodCache[4]) {
        return this->::QPaintEngine::drawImage(r, pm, sr, flags);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawImage";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QPaintEngine::drawImage(r, pm, sr, flags);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &r),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &pm),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &sr),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, &flags)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawLines(const ::QLine * lines, int lineCount)
{
    if (m_PyMethodCache[5]) {
        return this->::QPaintEngine::drawLines(lines, lineCount);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawLines";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QPaintEngine::drawLines(lines, lineCount);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Ni)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), lines),
    lineCount
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawLines(const ::QLineF * lines, int lineCount)
{
    if (m_PyMethodCache[6]) {
        return this->::QPaintEngine::drawLines(lines, lineCount);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawLines";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QPaintEngine::drawLines(lines, lineCount);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Ni)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), lines),
    lineCount
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawPath(const ::QPainterPath & path)
{
    if (m_PyMethodCache[7]) {
        return this->::QPaintEngine::drawPath(path);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawPath";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QPaintEngine::drawPath(path);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), &path)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawPixmap(const ::QRectF & r, const ::QPixmap & pm, const ::QRectF & sr)
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.drawPixmap()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawPixmap";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.drawPixmap()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &r),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &pm),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &sr)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawPoints(const ::QPoint * points, int pointCount)
{
    if (m_PyMethodCache[9]) {
        return this->::QPaintEngine::drawPoints(points, pointCount);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawPoints";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QPaintEngine::drawPoints(points, pointCount);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Ni)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), points),
    pointCount
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawPoints(const ::QPointF * points, int pointCount)
{
    if (m_PyMethodCache[10]) {
        return this->::QPaintEngine::drawPoints(points, pointCount);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawPoints";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QPaintEngine::drawPoints(points, pointCount);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Ni)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), points),
    pointCount
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawPolygon(const ::QPoint * points, int pointCount, ::QPaintEngine::PolygonDrawMode mode)
{
    if (m_PyMethodCache[11]) {
        return this->::QPaintEngine::drawPolygon(points, pointCount, mode);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawPolygon";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QPaintEngine::drawPolygon(points, pointCount, mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), points),
    pointCount,
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawPolygon(const ::QPointF * points, int pointCount, ::QPaintEngine::PolygonDrawMode mode)
{
    if (m_PyMethodCache[12]) {
        return this->::QPaintEngine::drawPolygon(points, pointCount, mode);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawPolygon";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QPaintEngine::drawPolygon(points, pointCount, mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), points),
    pointCount,
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawRects(const ::QRect * rects, int rectCount)
{
    if (m_PyMethodCache[13]) {
        return this->::QPaintEngine::drawRects(rects, rectCount);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawRects";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QPaintEngine::drawRects(rects, rectCount);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Ni)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), rects),
    rectCount
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawRects(const ::QRectF * rects, int rectCount)
{
    if (m_PyMethodCache[14]) {
        return this->::QPaintEngine::drawRects(rects, rectCount);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawRects";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QPaintEngine::drawRects(rects, rectCount);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Ni)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), rects),
    rectCount
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPaintEngineWrapper::drawTextItem(const ::QPointF & p, const ::QTextItem & textItem)
{
    if (m_PyMethodCache[15]) {
        return this->::QPaintEngine::drawTextItem(p, textItem);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawTextItem";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QPaintEngine::drawTextItem(p, textItem);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &p),
    Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX]), &textItem)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
}

void QPaintEngineWrapper::drawTiledPixmap(const ::QRectF & r, const ::QPixmap & pixmap, const ::QPointF & s)
{
    if (m_PyMethodCache[16]) {
        return this->::QPaintEngine::drawTiledPixmap(r, pixmap, s);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawTiledPixmap";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QPaintEngine::drawTiledPixmap(r, pixmap, s);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &r),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &pixmap),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &s)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QPaintEngineWrapper::end()
{
    if (m_PyMethodCache[17]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.end()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "end";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.end()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPaintEngine.end", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintEngine::Type QPaintEngineWrapper::type() const
{
    if (m_PyMethodCache[18]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.type()' not implemented.");
        return QPaintEngine::X11;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QPaintEngine::X11;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "type";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.type()' not implemented.");
        return QPaintEngine::X11;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QPaintEngine::X11;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPaintEngine.type", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine::Type >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QPaintEngine::X11;
    }
    ::QPaintEngine::Type cppResult{QPaintEngine::X11};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPaintEngineWrapper::updateState(const ::QPaintEngineState & state)
{
    if (m_PyMethodCache[19]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.updateState()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateState";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.updateState()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX]), &state)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

QPaintEngineWrapper::~QPaintEngineWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPaintEngine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QPaintEngine' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPaintEngine >()))
        return -1;

    ::QPaintEngineWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPaintEngine_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QPaintEngine", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPaintEngine::QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature>)
    if (numArgs == 0) {
        overloadId = 0; // QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngine_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_features = Shiboken::String::createStaticString("features");
            if (PyDict_Contains(kwds, key_features)) {
                value = PyDict_GetItem(kwds, key_features);
                if (value && pyArgs[0]) {
                    errInfo = key_features;
                    Py_INCREF(errInfo);
                    goto Sbk_QPaintEngine_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QPaintEngine_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_features);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPaintEngine_Init_TypeError;
            }
        }
        ::QFlags<QPaintEngine::PaintEngineFeature> cppArg0 = QPaintEngine::PaintEngineFeatures();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature>)
            cptr = new ::QPaintEngineWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPaintEngine >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPaintEngine_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPaintEngine_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPaintEngineFunc_begin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.begin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::begin(QPaintDevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // begin(QPaintDevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_begin_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintDevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // begin(QPaintDevice*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.begin()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->begin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaintEngineFunc_begin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_clearDirty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.clearDirty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::clearDirty(QFlags<QPaintEngine::DirtyFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // clearDirty(QFlags<QPaintEngine::DirtyFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_clearDirty_TypeError;

    // Call function/method
    {
        ::QFlags<QPaintEngine::DirtyFlag> cppArg0 = QFlags<QPaintEngine::DirtyFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // clearDirty(QFlags<QPaintEngine::DirtyFlag>)
            cppSelf->clearDirty(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_clearDirty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_coordinateOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.coordinateOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // coordinateOffset()const
            QPoint cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QPaintEngine *>(cppSelf)->::QPaintEngine::coordinateOffset()
                : const_cast<const ::QPaintEngine *>(cppSelf)->coordinateOffset();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineFunc_drawEllipse(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawEllipse";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::drawEllipse(QRectF)
    // 1: QPaintEngine::drawEllipse(QRect)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 1; // drawEllipse(QRect)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // drawEllipse(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawEllipse_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawEllipse(const QRectF & r)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // drawEllipse(QRectF)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawEllipse(*cppArg0)
                    : cppSelf->drawEllipse(*cppArg0);
            }
            break;
        }
        case 1: // drawEllipse(const QRect & r)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // drawEllipse(QRect)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawEllipse(*cppArg0)
                    : cppSelf->drawEllipse(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawEllipse_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_drawImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPaintEngineFunc_drawImage_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPaintEngineFunc_drawImage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:drawImage", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPaintEngine::drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3])))) {
            overloadId = 0; // drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawImage_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[3]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QPaintEngineFunc_drawImage_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QPaintEngineFunc_drawImage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPaintEngineFunc_drawImage_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QImage cppArg1_local;
        ::QImage *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QRectF cppArg2_local;
        ::QRectF *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        ::QFlags<Qt::ImageConversionFlag> cppArg3 = Qt::AutoColor;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QPaintEngine::drawImage(*cppArg0, *cppArg1, *cppArg2, cppArg3)
                : cppSelf->drawImage(*cppArg0, *cppArg1, *cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_drawLines(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawLines";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawLines", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPaintEngine::drawLines(const QLineF*,int)
    // 1: QPaintEngine::drawLines(const QLine*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // drawLines(const QLine*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // drawLines(const QLineF*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawLines_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawLines(const QLineF * lines, int lineCount)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QLineF *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawLines(const QLineF*,int)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawLines(cppArg0, cppArg1)
                    : cppSelf->drawLines(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // drawLines(const QLine * lines, int lineCount)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QLine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawLines(const QLine*,int)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawLines(cppArg0, cppArg1)
                    : cppSelf->drawLines(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawLines_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_drawPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::drawPath(QPainterPath)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), (pyArg)))) {
        overloadId = 0; // drawPath(QPainterPath)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawPath_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPainterPath cppArg0_local;
        ::QPainterPath *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // drawPath(QPainterPath)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QPaintEngine::drawPath(*cppArg0)
                : cppSelf->drawPath(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_drawPixmap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawPixmap", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPaintEngine::drawPixmap(QRectF,QPixmap,QRectF)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[2])))) {
        overloadId = 0; // drawPixmap(QRectF,QPixmap,QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawPixmap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPixmap cppArg1_local;
        ::QPixmap *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QRectF cppArg2_local;
        ::QRectF *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // drawPixmap(QRectF,QPixmap,QRectF)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.drawPixmap()' not implemented.");
                return {};
            }
            cppSelf->drawPixmap(*cppArg0, *cppArg1, *cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_drawPoints(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawPoints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawPoints", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPaintEngine::drawPoints(const QPointF*,int)
    // 1: QPaintEngine::drawPoints(const QPoint*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // drawPoints(const QPoint*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // drawPoints(const QPointF*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawPoints_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawPoints(const QPointF * points, int pointCount)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawPoints(const QPointF*,int)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawPoints(cppArg0, cppArg1)
                    : cppSelf->drawPoints(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // drawPoints(const QPoint * points, int pointCount)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawPoints(const QPoint*,int)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawPoints(cppArg0, cppArg1)
                    : cppSelf->drawPoints(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawPoints_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_drawPolygon(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawPolygon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawPolygon", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPaintEngine::drawPolygon(const QPointF*,int,QPaintEngine::PolygonDrawMode)
    // 1: QPaintEngine::drawPolygon(const QPoint*,int,QPaintEngine::PolygonDrawMode)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX])->converter, (pyArgs[2])))) {
        overloadId = 1; // drawPolygon(const QPoint*,int,QPaintEngine::PolygonDrawMode)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // drawPolygon(const QPointF*,int,QPaintEngine::PolygonDrawMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawPolygon_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawPolygon(const QPointF * points, int pointCount, QPaintEngine::PolygonDrawMode mode)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QPaintEngine::PolygonDrawMode cppArg2{QPaintEngine::OddEvenMode};
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawPolygon(const QPointF*,int,QPaintEngine::PolygonDrawMode)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawPolygon(cppArg0, cppArg1, cppArg2)
                    : cppSelf->drawPolygon(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // drawPolygon(const QPoint * points, int pointCount, QPaintEngine::PolygonDrawMode mode)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QPaintEngine::PolygonDrawMode cppArg2{QPaintEngine::OddEvenMode};
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawPolygon(const QPoint*,int,QPaintEngine::PolygonDrawMode)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawPolygon(cppArg0, cppArg1, cppArg2)
                    : cppSelf->drawPolygon(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawPolygon_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_drawRects(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawRects";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawRects", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPaintEngine::drawRects(const QRectF*,int)
    // 1: QPaintEngine::drawRects(const QRect*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // drawRects(const QRect*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // drawRects(const QRectF*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawRects_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawRects(const QRectF * rects, int rectCount)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawRects(const QRectF*,int)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawRects(cppArg0, cppArg1)
                    : cppSelf->drawRects(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // drawRects(const QRect * rects, int rectCount)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // drawRects(const QRect*,int)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPaintEngine::drawRects(cppArg0, cppArg1)
                    : cppSelf->drawRects(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawRects_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_drawTextItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawTextItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawTextItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPaintEngine::drawTextItem(QPointF,QTextItem)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // drawTextItem(QPointF,QTextItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawTextItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QTextItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // drawTextItem(QPointF,QTextItem)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QPaintEngine::drawTextItem(*cppArg0, *cppArg1)
                : cppSelf->drawTextItem(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawTextItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_drawTiledPixmap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.drawTiledPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawTiledPixmap", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPaintEngine::drawTiledPixmap(QRectF,QPixmap,QPointF)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[2])))) {
        overloadId = 0; // drawTiledPixmap(QRectF,QPixmap,QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_drawTiledPixmap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPixmap cppArg1_local;
        ::QPixmap *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPointF cppArg2_local;
        ::QPointF *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // drawTiledPixmap(QRectF,QPixmap,QPointF)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QPaintEngine::drawTiledPixmap(*cppArg0, *cppArg1, *cppArg2)
                : cppSelf->drawTiledPixmap(*cppArg0, *cppArg1, *cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_drawTiledPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_end(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.end";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // end()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.end()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->end();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineFunc_hasFeature(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.hasFeature";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::hasFeature(QFlags<QPaintEngine::PaintEngineFeature>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // hasFeature(QFlags<QPaintEngine::PaintEngineFeature>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_hasFeature_TypeError;

    // Call function/method
    {
        ::QFlags<QPaintEngine::PaintEngineFeature> cppArg0 = QFlags<QPaintEngine::PaintEngineFeature>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasFeature(QFlags<QPaintEngine::PaintEngineFeature>)const
            bool cppResult = const_cast<const ::QPaintEngine *>(cppSelf)->hasFeature(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaintEngineFunc_hasFeature_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.isActive";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isActive()const
            bool cppResult = const_cast<const ::QPaintEngine *>(cppSelf)->isActive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineFunc_isExtended(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.isExtended";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isExtended()const
            bool cppResult = const_cast<const ::QPaintEngine *>(cppSelf)->isExtended();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineFunc_paintDevice(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.paintDevice";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paintDevice()const
            QPaintDevice * cppResult = const_cast<const ::QPaintEngine *>(cppSelf)->paintDevice();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineFunc_painter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.painter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // painter()const
            QPainter * cppResult = const_cast<const ::QPaintEngine *>(cppSelf)->painter();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineFunc_setActive(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.setActive";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::setActive(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setActive(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_setActive_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActive(bool)
            cppSelf->setActive(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_setActive_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_setDirty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.setDirty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::setDirty(QFlags<QPaintEngine::DirtyFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDirty(QFlags<QPaintEngine::DirtyFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_setDirty_TypeError;

    // Call function/method
    {
        ::QFlags<QPaintEngine::DirtyFlag> cppArg0 = QFlags<QPaintEngine::DirtyFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDirty(QFlags<QPaintEngine::DirtyFlag>)
            cppSelf->setDirty(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_setDirty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_setSystemClip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.setSystemClip";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::setSystemClip(QRegion)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), (pyArg)))) {
        overloadId = 0; // setSystemClip(QRegion)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_setSystemClip_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegion cppArg0_local;
        ::QRegion *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSystemClip(QRegion)
            cppSelf->setSystemClip(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_setSystemClip_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_setSystemRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.setSystemRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::setSystemRect(QRect)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // setSystemRect(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_setSystemRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSystemRect(QRect)
            cppSelf->setSystemRect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_setSystemRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_syncState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.syncState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // syncState()
            cppSelf->syncState();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPaintEngineFunc_systemClip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.systemClip";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // systemClip()const
            QRegion cppResult = const_cast<const ::QPaintEngine *>(cppSelf)->systemClip();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineFunc_systemRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.systemRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // systemRect()const
            QRect cppResult = const_cast<const ::QPaintEngine *>(cppSelf)->systemRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineFunc_testDirty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.testDirty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::testDirty(QFlags<QPaintEngine::DirtyFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // testDirty(QFlags<QPaintEngine::DirtyFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_testDirty_TypeError;

    // Call function/method
    {
        ::QFlags<QPaintEngine::DirtyFlag> cppArg0 = QFlags<QPaintEngine::DirtyFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // testDirty(QFlags<QPaintEngine::DirtyFlag>)
            bool cppResult = cppSelf->testDirty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaintEngineFunc_testDirty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaintEngineFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.type()' not implemented.");
                return {};
            }
            QPaintEngine::Type cppResult = const_cast<const ::QPaintEngine *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineFunc_updateState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngine.updateState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintEngine::updateState(QPaintEngineState)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX]), (pyArg)))) {
        overloadId = 0; // updateState(QPaintEngineState)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaintEngineFunc_updateState_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEngineState *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // updateState(QPaintEngineState)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintEngine.updateState()' not implemented.");
                return {};
            }
            cppSelf->updateState(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaintEngineFunc_updateState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QPaintEngine_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPaintEngine_methods[] = {
    {"begin", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_begin), METH_O},
    {"clearDirty", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_clearDirty), METH_O},
    {"coordinateOffset", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_coordinateOffset), METH_NOARGS},
    {"drawEllipse", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawEllipse), METH_O},
    {"drawImage", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawImage), METH_VARARGS|METH_KEYWORDS},
    {"drawLines", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawLines), METH_VARARGS},
    {"drawPath", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawPath), METH_O},
    {"drawPixmap", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawPixmap), METH_VARARGS},
    {"drawPoints", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawPoints), METH_VARARGS},
    {"drawPolygon", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawPolygon), METH_VARARGS},
    {"drawRects", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawRects), METH_VARARGS},
    {"drawTextItem", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawTextItem), METH_VARARGS},
    {"drawTiledPixmap", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_drawTiledPixmap), METH_VARARGS},
    {"end", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_end), METH_NOARGS},
    {"hasFeature", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_hasFeature), METH_O},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_isActive), METH_NOARGS},
    {"isExtended", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_isExtended), METH_NOARGS},
    {"paintDevice", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_paintDevice), METH_NOARGS},
    {"painter", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_painter), METH_NOARGS},
    {"setActive", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_setActive), METH_O},
    {"setDirty", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_setDirty), METH_O},
    {"setSystemClip", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_setSystemClip), METH_O},
    {"setSystemRect", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_setSystemRect), METH_O},
    {"syncState", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_syncState), METH_NOARGS},
    {"systemClip", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_systemClip), METH_NOARGS},
    {"systemRect", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_systemRect), METH_NOARGS},
    {"testDirty", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_testDirty), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_type), METH_NOARGS},
    {"updateState", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineFunc_updateState), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPaintEngine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPaintEngineWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_QPaintEngine_get_state(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX]), cppSelf->state);
    return pyOut;
}
static int Sbk_QPaintEngine_set_state(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'state' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'state', 'QPaintEngineState' or convertible type expected");
        return -1;
    }

    ::QPaintEngineState *& cppOut_ptr = cppSelf->state;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "state", pyIn);
    return 0;
}

static PyObject *Sbk_QPaintEngine_get_gccaps(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, &cppSelf->gccaps);
    return pyOut;
}
static int Sbk_QPaintEngine_set_gccaps(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'gccaps' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'gccaps', 'PaintEngineFeatures' or convertible type expected");
        return -1;
    }

    ::QFlags<QPaintEngine::PaintEngineFeature> cppOut_local = cppSelf->gccaps;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->gccaps = cppOut_local;

    return 0;
}

static PyObject *Sbk_QPaintEngine_get_active(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    uint cppOut_local = cppSelf->active;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QPaintEngine_set_active(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'active' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'active', 'uint' or convertible type expected");
        return -1;
    }

    uint cppOut_local = cppSelf->active;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->active = cppOut_local;

    return 0;
}

static PyObject *Sbk_QPaintEngine_get_selfDestruct(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    uint cppOut_local = cppSelf->selfDestruct;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QPaintEngine_set_selfDestruct(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selfDestruct' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selfDestruct', 'uint' or convertible type expected");
        return -1;
    }

    uint cppOut_local = cppSelf->selfDestruct;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selfDestruct = cppOut_local;

    return 0;
}

static PyObject *Sbk_QPaintEngine_get_extended(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    uint cppOut_local = cppSelf->extended;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QPaintEngine_set_extended(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPaintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'extended' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'extended', 'uint' or convertible type expected");
        return -1;
    }

    uint cppOut_local = cppSelf->extended;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->extended = cppOut_local;

    return 0;
}

// Getters and Setters for QPaintEngine
static PyGetSetDef Sbk_QPaintEngine_getsetlist[] = {
    {const_cast<char *>("state"), Sbk_QPaintEngine_get_state, Sbk_QPaintEngine_set_state},
    {const_cast<char *>("gccaps"), Sbk_QPaintEngine_get_gccaps, Sbk_QPaintEngine_set_gccaps},
    {const_cast<char *>("active"), Sbk_QPaintEngine_get_active, Sbk_QPaintEngine_set_active},
    {const_cast<char *>("selfDestruct"), Sbk_QPaintEngine_get_selfDestruct, Sbk_QPaintEngine_set_selfDestruct},
    {const_cast<char *>("extended"), Sbk_QPaintEngine_get_extended, Sbk_QPaintEngine_set_extended},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QPaintEngine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPaintEngine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPaintEngine_Type = nullptr;
static SbkObjectType *Sbk_QPaintEngine_TypeF(void)
{
    return _Sbk_QPaintEngine_Type;
}

static PyType_Slot Sbk_QPaintEngine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QPaintEngine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPaintEngine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPaintEngine_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPaintEngine_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QPaintEngine_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPaintEngine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPaintEngine_spec = {
    "2:PySide2.QtGui.QPaintEngine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPaintEngine_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QPaintEngine::PaintEngineFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPaintEngine::PaintEngineFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPaintEngine::PaintEngineFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPaintEngine::PaintEngineFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPaintEngine::PaintEngineFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QPaintEngine::PaintEngineFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPaintEngine::PaintEngineFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPaintEngine::PaintEngineFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPaintEngine::PaintEngineFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPaintEngine::PaintEngineFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QPaintEngine::PaintEngineFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPaintEngine::PaintEngineFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPaintEngine::PaintEngineFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPaintEngine::PaintEngineFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPaintEngine::PaintEngineFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QPaintEngine::PaintEngineFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, self, &cppSelf);
    ::QPaintEngine::PaintEngineFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtGui_QPaintEngine_DirtyFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QPaintEngine::DirtyFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPaintEngine::DirtyFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPaintEngine::DirtyFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPaintEngine::DirtyFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPaintEngine::DirtyFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPaintEngine_DirtyFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QPaintEngine::DirtyFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPaintEngine::DirtyFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPaintEngine::DirtyFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPaintEngine::DirtyFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPaintEngine::DirtyFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPaintEngine_DirtyFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QPaintEngine::DirtyFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QPaintEngine::DirtyFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QPaintEngine::DirtyFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QPaintEngine::DirtyFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QPaintEngine::DirtyFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QPaintEngine_DirtyFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QPaintEngine::DirtyFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, self, &cppSelf);
    ::QPaintEngine::DirtyFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QPaintEngine_DirtyFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QPaintEngine_DirtyFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QPaintEngine_DirtyFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QPaintEngine_DirtyFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QPaintEngine_PaintEngineFeature_PythonToCpp_QPaintEngine_PaintEngineFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPaintEngine::PaintEngineFeature *>(cppOut) =
        static_cast<::QPaintEngine::PaintEngineFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPaintEngine_PaintEngineFeature_PythonToCpp_QPaintEngine_PaintEngineFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX]))
        return QPaintEngine_PaintEngineFeature_PythonToCpp_QPaintEngine_PaintEngineFeature;
    return {};
}
static PyObject *QPaintEngine_PaintEngineFeature_CppToPython_QPaintEngine_PaintEngineFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPaintEngine::PaintEngineFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX], castCppIn);

}

static void QFlags_QPaintEngine_PaintEngineFeature__PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QPaintEngine::PaintEngineFeature> *>(cppOut) =
        ::QFlags<QPaintEngine::PaintEngineFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QPaintEngine_PaintEngineFeature__PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX]))
        return QFlags_QPaintEngine_PaintEngineFeature__PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature_;
    return {};
}
static PyObject *QFlags_QPaintEngine_PaintEngineFeature__CppToPython_QFlags_QPaintEngine_PaintEngineFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QPaintEngine::PaintEngineFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX]));

}

static void QPaintEngine_PaintEngineFeature_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QPaintEngine::PaintEngineFeature> *>(cppOut) =
        ::QFlags<QPaintEngine::PaintEngineFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QPaintEngine_PaintEngineFeature_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX]))
        return QPaintEngine_PaintEngineFeature_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QPaintEngine::PaintEngineFeature> *>(cppOut) =
        ::QFlags<QPaintEngine::PaintEngineFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature_;
    return {};
}
static void QPaintEngine_DirtyFlag_PythonToCpp_QPaintEngine_DirtyFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPaintEngine::DirtyFlag *>(cppOut) =
        static_cast<::QPaintEngine::DirtyFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPaintEngine_DirtyFlag_PythonToCpp_QPaintEngine_DirtyFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX]))
        return QPaintEngine_DirtyFlag_PythonToCpp_QPaintEngine_DirtyFlag;
    return {};
}
static PyObject *QPaintEngine_DirtyFlag_CppToPython_QPaintEngine_DirtyFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPaintEngine::DirtyFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX], castCppIn);

}

static void QFlags_QPaintEngine_DirtyFlag__PythonToCpp_QFlags_QPaintEngine_DirtyFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QPaintEngine::DirtyFlag> *>(cppOut) =
        ::QFlags<QPaintEngine::DirtyFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QPaintEngine_DirtyFlag__PythonToCpp_QFlags_QPaintEngine_DirtyFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX]))
        return QFlags_QPaintEngine_DirtyFlag__PythonToCpp_QFlags_QPaintEngine_DirtyFlag_;
    return {};
}
static PyObject *QFlags_QPaintEngine_DirtyFlag__CppToPython_QFlags_QPaintEngine_DirtyFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QPaintEngine::DirtyFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX]));

}

static void QPaintEngine_DirtyFlag_PythonToCpp_QFlags_QPaintEngine_DirtyFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QPaintEngine::DirtyFlag> *>(cppOut) =
        ::QFlags<QPaintEngine::DirtyFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QPaintEngine_DirtyFlag_PythonToCpp_QFlags_QPaintEngine_DirtyFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX]))
        return QPaintEngine_DirtyFlag_PythonToCpp_QFlags_QPaintEngine_DirtyFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QPaintEngine_DirtyFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QPaintEngine::DirtyFlag> *>(cppOut) =
        ::QFlags<QPaintEngine::DirtyFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QPaintEngine_DirtyFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX]))
        return number_PythonToCpp_QFlags_QPaintEngine_DirtyFlag_;
    return {};
}
static void QPaintEngine_PolygonDrawMode_PythonToCpp_QPaintEngine_PolygonDrawMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPaintEngine::PolygonDrawMode *>(cppOut) =
        static_cast<::QPaintEngine::PolygonDrawMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPaintEngine_PolygonDrawMode_PythonToCpp_QPaintEngine_PolygonDrawMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX]))
        return QPaintEngine_PolygonDrawMode_PythonToCpp_QPaintEngine_PolygonDrawMode;
    return {};
}
static PyObject *QPaintEngine_PolygonDrawMode_CppToPython_QPaintEngine_PolygonDrawMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPaintEngine::PolygonDrawMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX], castCppIn);

}

static void QPaintEngine_Type_PythonToCpp_QPaintEngine_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPaintEngine::Type *>(cppOut) =
        static_cast<::QPaintEngine::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPaintEngine_Type_PythonToCpp_QPaintEngine_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX]))
        return QPaintEngine_Type_PythonToCpp_QPaintEngine_Type;
    return {};
}
static PyObject *QPaintEngine_Type_CppToPython_QPaintEngine_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPaintEngine::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPaintEngine_PythonToCpp_QPaintEngine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPaintEngine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPaintEngine_PythonToCpp_QPaintEngine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPaintEngine_TypeF())))
        return QPaintEngine_PythonToCpp_QPaintEngine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPaintEngine_PTR_CppToPython_QPaintEngine(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPaintEngine *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPaintEngine_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPaintEngine_SignatureStrings[] = {
    "PySide2.QtGui.QPaintEngine(self,features:PySide2.QtGui.QPaintEngine.PaintEngineFeatures=QPaintEngine.PaintEngineFeatures())",
    "PySide2.QtGui.QPaintEngine.begin(self,pdev:PySide2.QtGui.QPaintDevice)->bool",
    "PySide2.QtGui.QPaintEngine.clearDirty(self,df:PySide2.QtGui.QPaintEngine.DirtyFlags)",
    "PySide2.QtGui.QPaintEngine.coordinateOffset(self)->PySide2.QtCore.QPoint",
    "1:PySide2.QtGui.QPaintEngine.drawEllipse(self,r:PySide2.QtCore.QRectF)",
    "0:PySide2.QtGui.QPaintEngine.drawEllipse(self,r:PySide2.QtCore.QRect)",
    "PySide2.QtGui.QPaintEngine.drawImage(self,r:PySide2.QtCore.QRectF,pm:PySide2.QtGui.QImage,sr:PySide2.QtCore.QRectF,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)",
    "1:PySide2.QtGui.QPaintEngine.drawLines(self,lines:PySide2.QtCore.QLineF,lineCount:int)",
    "0:PySide2.QtGui.QPaintEngine.drawLines(self,lines:PySide2.QtCore.QLine,lineCount:int)",
    "PySide2.QtGui.QPaintEngine.drawPath(self,path:PySide2.QtGui.QPainterPath)",
    "PySide2.QtGui.QPaintEngine.drawPixmap(self,r:PySide2.QtCore.QRectF,pm:PySide2.QtGui.QPixmap,sr:PySide2.QtCore.QRectF)",
    "1:PySide2.QtGui.QPaintEngine.drawPoints(self,points:PySide2.QtCore.QPointF,pointCount:int)",
    "0:PySide2.QtGui.QPaintEngine.drawPoints(self,points:PySide2.QtCore.QPoint,pointCount:int)",
    "1:PySide2.QtGui.QPaintEngine.drawPolygon(self,points:PySide2.QtCore.QPointF,pointCount:int,mode:PySide2.QtGui.QPaintEngine.PolygonDrawMode)",
    "0:PySide2.QtGui.QPaintEngine.drawPolygon(self,points:PySide2.QtCore.QPoint,pointCount:int,mode:PySide2.QtGui.QPaintEngine.PolygonDrawMode)",
    "1:PySide2.QtGui.QPaintEngine.drawRects(self,rects:PySide2.QtCore.QRectF,rectCount:int)",
    "0:PySide2.QtGui.QPaintEngine.drawRects(self,rects:PySide2.QtCore.QRect,rectCount:int)",
    "PySide2.QtGui.QPaintEngine.drawTextItem(self,p:PySide2.QtCore.QPointF,textItem:PySide2.QtGui.QTextItem)",
    "PySide2.QtGui.QPaintEngine.drawTiledPixmap(self,r:PySide2.QtCore.QRectF,pixmap:PySide2.QtGui.QPixmap,s:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QPaintEngine.end(self)->bool",
    "PySide2.QtGui.QPaintEngine.hasFeature(self,feature:PySide2.QtGui.QPaintEngine.PaintEngineFeatures)->bool",
    "PySide2.QtGui.QPaintEngine.isActive(self)->bool",
    "PySide2.QtGui.QPaintEngine.isExtended(self)->bool",
    "PySide2.QtGui.QPaintEngine.paintDevice(self)->PySide2.QtGui.QPaintDevice",
    "PySide2.QtGui.QPaintEngine.painter(self)->PySide2.QtGui.QPainter",
    "PySide2.QtGui.QPaintEngine.setActive(self,newState:bool)",
    "PySide2.QtGui.QPaintEngine.setDirty(self,df:PySide2.QtGui.QPaintEngine.DirtyFlags)",
    "PySide2.QtGui.QPaintEngine.setSystemClip(self,baseClip:PySide2.QtGui.QRegion)",
    "PySide2.QtGui.QPaintEngine.setSystemRect(self,rect:PySide2.QtCore.QRect)",
    "PySide2.QtGui.QPaintEngine.syncState(self)",
    "PySide2.QtGui.QPaintEngine.systemClip(self)->PySide2.QtGui.QRegion",
    "PySide2.QtGui.QPaintEngine.systemRect(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QPaintEngine.testDirty(self,df:PySide2.QtGui.QPaintEngine.DirtyFlags)->bool",
    "PySide2.QtGui.QPaintEngine.type(self)->PySide2.QtGui.QPaintEngine.Type",
    "PySide2.QtGui.QPaintEngine.updateState(self,state:PySide2.QtGui.QPaintEngineState)",
    nullptr}; // Sentinel

void init_QPaintEngine(PyObject *module)
{
    _Sbk_QPaintEngine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPaintEngine",
        "QPaintEngine*",
        &Sbk_QPaintEngine_spec,
        &Shiboken::callCppDestructor< ::QPaintEngine >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPaintEngine_Type);
    InitSignatureStrings(pyType, QPaintEngine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPaintEngine_Type), Sbk_QPaintEngine_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPaintEngine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPaintEngine_TypeF(),
        QPaintEngine_PythonToCpp_QPaintEngine_PTR,
        is_QPaintEngine_PythonToCpp_QPaintEngine_PTR_Convertible,
        QPaintEngine_PTR_CppToPython_QPaintEngine);

    Shiboken::Conversions::registerConverterName(converter, "QPaintEngine");
    Shiboken::Conversions::registerConverterName(converter, "QPaintEngine*");
    Shiboken::Conversions::registerConverterName(converter, "QPaintEngine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPaintEngine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPaintEngineWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'PaintEngineFeature'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QPaintEngine.PaintEngineFeatures", SbkPySide2_QtGui_QPaintEngine_PaintEngineFeature_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPaintEngine_TypeF(),
        "PaintEngineFeature",
        "2:PySide2.QtGui.QPaintEngine.PaintEngineFeature",
        "QPaintEngine::PaintEngineFeature",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "PrimitiveTransform", (long) QPaintEngine::PaintEngineFeature::PrimitiveTransform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "PatternTransform", (long) QPaintEngine::PaintEngineFeature::PatternTransform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "PixmapTransform", (long) QPaintEngine::PaintEngineFeature::PixmapTransform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "PatternBrush", (long) QPaintEngine::PaintEngineFeature::PatternBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "LinearGradientFill", (long) QPaintEngine::PaintEngineFeature::LinearGradientFill))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "RadialGradientFill", (long) QPaintEngine::PaintEngineFeature::RadialGradientFill))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "ConicalGradientFill", (long) QPaintEngine::PaintEngineFeature::ConicalGradientFill))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "AlphaBlend", (long) QPaintEngine::PaintEngineFeature::AlphaBlend))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "PorterDuff", (long) QPaintEngine::PaintEngineFeature::PorterDuff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "PainterPaths", (long) QPaintEngine::PaintEngineFeature::PainterPaths))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "Antialiasing", (long) QPaintEngine::PaintEngineFeature::Antialiasing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "BrushStroke", (long) QPaintEngine::PaintEngineFeature::BrushStroke))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "ConstantOpacity", (long) QPaintEngine::PaintEngineFeature::ConstantOpacity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "MaskedBrush", (long) QPaintEngine::PaintEngineFeature::MaskedBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "PerspectiveTransform", (long) QPaintEngine::PaintEngineFeature::PerspectiveTransform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "BlendModes", (long) QPaintEngine::PaintEngineFeature::BlendModes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "ObjectBoundingModeGradients", (long) QPaintEngine::PaintEngineFeature::ObjectBoundingModeGradients))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "RasterOpModes", (long) QPaintEngine::PaintEngineFeature::RasterOpModes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "PaintOutsidePaintEvent", (long) QPaintEngine::PaintEngineFeature::PaintOutsidePaintEvent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
        Sbk_QPaintEngine_TypeF(), "AllFeatures", (long) QPaintEngine::PaintEngineFeature::AllFeatures))
        return;
    // Register converter for enum 'QPaintEngine::PaintEngineFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
            QPaintEngine_PaintEngineFeature_CppToPython_QPaintEngine_PaintEngineFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPaintEngine_PaintEngineFeature_PythonToCpp_QPaintEngine_PaintEngineFeature,
            is_QPaintEngine_PaintEngineFeature_PythonToCpp_QPaintEngine_PaintEngineFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_PAINTENGINEFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPaintEngine::PaintEngineFeature");
        Shiboken::Conversions::registerConverterName(converter, "PaintEngineFeature");
    }
    // Register converter for flag 'QFlags<QPaintEngine::PaintEngineFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX],
            QFlags_QPaintEngine_PaintEngineFeature__CppToPython_QFlags_QPaintEngine_PaintEngineFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPaintEngine_PaintEngineFeature_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature_,
            is_QPaintEngine_PaintEngineFeature_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QPaintEngine_PaintEngineFeature__PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature_,
            is_QFlags_QPaintEngine_PaintEngineFeature__PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature_,
            is_number_PythonToCpp_QFlags_QPaintEngine_PaintEngineFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_PAINTENGINEFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPaintEngine::PaintEngineFeatures");
        Shiboken::Conversions::registerConverterName(converter, "PaintEngineFeatures");
    }
    // End of 'PaintEngineFeature' enum/flags.

    // Initialization of enum 'DirtyFlag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QPaintEngine.DirtyFlags", SbkPySide2_QtGui_QPaintEngine_DirtyFlag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPaintEngine_TypeF(),
        "DirtyFlag",
        "2:PySide2.QtGui.QPaintEngine.DirtyFlag",
        "QPaintEngine::DirtyFlag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyPen", (long) QPaintEngine::DirtyFlag::DirtyPen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyBrush", (long) QPaintEngine::DirtyFlag::DirtyBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyBrushOrigin", (long) QPaintEngine::DirtyFlag::DirtyBrushOrigin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyFont", (long) QPaintEngine::DirtyFlag::DirtyFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyBackground", (long) QPaintEngine::DirtyFlag::DirtyBackground))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyBackgroundMode", (long) QPaintEngine::DirtyFlag::DirtyBackgroundMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyTransform", (long) QPaintEngine::DirtyFlag::DirtyTransform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyClipRegion", (long) QPaintEngine::DirtyFlag::DirtyClipRegion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyClipPath", (long) QPaintEngine::DirtyFlag::DirtyClipPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyHints", (long) QPaintEngine::DirtyFlag::DirtyHints))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyCompositionMode", (long) QPaintEngine::DirtyFlag::DirtyCompositionMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyClipEnabled", (long) QPaintEngine::DirtyFlag::DirtyClipEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "DirtyOpacity", (long) QPaintEngine::DirtyFlag::DirtyOpacity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
        Sbk_QPaintEngine_TypeF(), "AllDirty", (long) QPaintEngine::DirtyFlag::AllDirty))
        return;
    // Register converter for enum 'QPaintEngine::DirtyFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX],
            QPaintEngine_DirtyFlag_CppToPython_QPaintEngine_DirtyFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPaintEngine_DirtyFlag_PythonToCpp_QPaintEngine_DirtyFlag,
            is_QPaintEngine_DirtyFlag_PythonToCpp_QPaintEngine_DirtyFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_DIRTYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPaintEngine::DirtyFlag");
        Shiboken::Conversions::registerConverterName(converter, "DirtyFlag");
    }
    // Register converter for flag 'QFlags<QPaintEngine::DirtyFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX],
            QFlags_QPaintEngine_DirtyFlag__CppToPython_QFlags_QPaintEngine_DirtyFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPaintEngine_DirtyFlag_PythonToCpp_QFlags_QPaintEngine_DirtyFlag_,
            is_QPaintEngine_DirtyFlag_PythonToCpp_QFlags_QPaintEngine_DirtyFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QPaintEngine_DirtyFlag__PythonToCpp_QFlags_QPaintEngine_DirtyFlag_,
            is_QFlags_QPaintEngine_DirtyFlag__PythonToCpp_QFlags_QPaintEngine_DirtyFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QPaintEngine_DirtyFlag_,
            is_number_PythonToCpp_QFlags_QPaintEngine_DirtyFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPaintEngine::DirtyFlags");
        Shiboken::Conversions::registerConverterName(converter, "DirtyFlags");
    }
    // End of 'DirtyFlag' enum/flags.

    // Initialization of enum 'PolygonDrawMode'.
    SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPaintEngine_TypeF(),
        "PolygonDrawMode",
        "2:PySide2.QtGui.QPaintEngine.PolygonDrawMode",
        "QPaintEngine::PolygonDrawMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX],
        Sbk_QPaintEngine_TypeF(), "OddEvenMode", (long) QPaintEngine::PolygonDrawMode::OddEvenMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX],
        Sbk_QPaintEngine_TypeF(), "WindingMode", (long) QPaintEngine::PolygonDrawMode::WindingMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX],
        Sbk_QPaintEngine_TypeF(), "ConvexMode", (long) QPaintEngine::PolygonDrawMode::ConvexMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX],
        Sbk_QPaintEngine_TypeF(), "PolylineMode", (long) QPaintEngine::PolygonDrawMode::PolylineMode))
        return;
    // Register converter for enum 'QPaintEngine::PolygonDrawMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX],
            QPaintEngine_PolygonDrawMode_CppToPython_QPaintEngine_PolygonDrawMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPaintEngine_PolygonDrawMode_PythonToCpp_QPaintEngine_PolygonDrawMode,
            is_QPaintEngine_PolygonDrawMode_PythonToCpp_QPaintEngine_PolygonDrawMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_POLYGONDRAWMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPaintEngine::PolygonDrawMode");
        Shiboken::Conversions::registerConverterName(converter, "PolygonDrawMode");
    }
    // End of 'PolygonDrawMode' enum.

    // Initialization of enum 'Type'.
    SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPaintEngine_TypeF(),
        "Type",
        "2:PySide2.QtGui.QPaintEngine.Type",
        "QPaintEngine::Type");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "X11", (long) QPaintEngine::Type::X11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "Windows", (long) QPaintEngine::Type::Windows))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "QuickDraw", (long) QPaintEngine::Type::QuickDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "CoreGraphics", (long) QPaintEngine::Type::CoreGraphics))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "MacPrinter", (long) QPaintEngine::Type::MacPrinter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "QWindowSystem", (long) QPaintEngine::Type::QWindowSystem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "PostScript", (long) QPaintEngine::Type::PostScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "OpenGL", (long) QPaintEngine::Type::OpenGL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "Picture", (long) QPaintEngine::Type::Picture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "SVG", (long) QPaintEngine::Type::SVG))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "Raster", (long) QPaintEngine::Type::Raster))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "Direct3D", (long) QPaintEngine::Type::Direct3D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "Pdf", (long) QPaintEngine::Type::Pdf))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "OpenVG", (long) QPaintEngine::Type::OpenVG))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "OpenGL2", (long) QPaintEngine::Type::OpenGL2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "PaintBuffer", (long) QPaintEngine::Type::PaintBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "Blitter", (long) QPaintEngine::Type::Blitter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "Direct2D", (long) QPaintEngine::Type::Direct2D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "User", (long) QPaintEngine::Type::User))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
        Sbk_QPaintEngine_TypeF(), "MaxUser", (long) QPaintEngine::Type::MaxUser))
        return;
    // Register converter for enum 'QPaintEngine::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX],
            QPaintEngine_Type_CppToPython_QPaintEngine_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPaintEngine_Type_PythonToCpp_QPaintEngine_Type,
            is_QPaintEngine_Type_PythonToCpp_QPaintEngine_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPaintEngine::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::QPaintEngine::PaintEngineFeature >("QPaintEngine::PaintEngineFeature");
    qRegisterMetaType< ::QPaintEngine::PaintEngineFeatures >("QPaintEngine::PaintEngineFeatures");
    qRegisterMetaType< ::QPaintEngine::DirtyFlag >("QPaintEngine::DirtyFlag");
    qRegisterMetaType< ::QPaintEngine::DirtyFlags >("QPaintEngine::DirtyFlags");
    qRegisterMetaType< ::QPaintEngine::PolygonDrawMode >("QPaintEngine::PolygonDrawMode");
    qRegisterMetaType< ::QPaintEngine::Type >("QPaintEngine::Type");
}
