/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpagesize_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qpagesize.h>
#include <qrect.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPageSize_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPageSize >()))
        return -1;

    ::QPageSize *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPageSize_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QPageSize", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QPageSize::QPageSize()
    // 1: QPageSize::QPageSize(QPageSize::PageSizeId)
    // 2: QPageSize::QPageSize(QPageSize)
    // 3: QPageSize::QPageSize(QSize,QString,QPageSize::SizeMatchPolicy)
    // 4: QPageSize::QPageSize(QSizeF,QPageSize::Unit,QString,QPageSize::SizeMatchPolicy)
    if (numArgs == 0) {
        overloadId = 0; // QPageSize()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // QPageSize(QSize,QString,QPageSize::SizeMatchPolicy)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // QPageSize(QSize,QString,QPageSize::SizeMatchPolicy)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX])->converter, (pyArgs[2])))) {
                overloadId = 3; // QPageSize(QSize,QString,QPageSize::SizeMatchPolicy)
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 4; // QPageSize(QSizeF,QPageSize::Unit,QString,QPageSize::SizeMatchPolicy)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 4; // QPageSize(QSizeF,QPageSize::Unit,QString,QPageSize::SizeMatchPolicy)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX])->converter, (pyArgs[3])))) {
                overloadId = 4; // QPageSize(QSizeF,QPageSize::Unit,QString,QPageSize::SizeMatchPolicy)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QPageSize(QPageSize::PageSizeId)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QPageSize(QPageSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSize_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPageSize()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPageSize_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QPageSize()
                cptr = new ::QPageSize();
            }
            break;
        }
        case 1: // QPageSize(QPageSize::PageSizeId pageSizeId)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPageSize_Init_TypeError;
            }
            ::QPageSize::PageSizeId cppArg0{QPageSize::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QPageSize(QPageSize::PageSizeId)
                cptr = new ::QPageSize(cppArg0);
            }
            break;
        }
        case 2: // QPageSize(const QPageSize & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPageSize_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPageSize cppArg0_local;
            ::QPageSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPageSize(QPageSize)
                cptr = new ::QPageSize(*cppArg0);
            }
            break;
        }
        case 3: // QPageSize(const QSize & pointSize, const QString & name, QPageSize::SizeMatchPolicy matchPolicy)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_name = Shiboken::String::createStaticString("name");
                if (PyDict_Contains(kwds, key_name)) {
                    value = PyDict_GetItem(kwds, key_name);
                    if (value && pyArgs[1]) {
                        errInfo = key_name;
                        Py_INCREF(errInfo);
                        goto Sbk_QPageSize_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QPageSize_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_name);
                }
                static PyObject *const key_matchPolicy = Shiboken::String::createStaticString("matchPolicy");
                if (PyDict_Contains(kwds, key_matchPolicy)) {
                    value = PyDict_GetItem(kwds, key_matchPolicy);
                    if (value && pyArgs[2]) {
                        errInfo = key_matchPolicy;
                        Py_INCREF(errInfo);
                        goto Sbk_QPageSize_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QPageSize_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchPolicy);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPageSize_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QPageSize::SizeMatchPolicy cppArg2 = QPageSize::SizeMatchPolicy::FuzzyMatch;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QPageSize(QSize,QString,QPageSize::SizeMatchPolicy)
                cptr = new ::QPageSize(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 4: // QPageSize(const QSizeF & size, QPageSize::Unit units, const QString & name, QPageSize::SizeMatchPolicy matchPolicy)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_name = Shiboken::String::createStaticString("name");
                if (PyDict_Contains(kwds, key_name)) {
                    value = PyDict_GetItem(kwds, key_name);
                    if (value && pyArgs[2]) {
                        errInfo = key_name;
                        Py_INCREF(errInfo);
                        goto Sbk_QPageSize_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                            goto Sbk_QPageSize_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_name);
                }
                static PyObject *const key_matchPolicy = Shiboken::String::createStaticString("matchPolicy");
                if (PyDict_Contains(kwds, key_matchPolicy)) {
                    value = PyDict_GetItem(kwds, key_matchPolicy);
                    if (value && pyArgs[3]) {
                        errInfo = key_matchPolicy;
                        Py_INCREF(errInfo);
                        goto Sbk_QPageSize_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPageSize_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchPolicy);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPageSize_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSizeF cppArg0_local;
            ::QSizeF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QPageSize::Unit cppArg1{QPageSize::Millimeter};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QPageSize::SizeMatchPolicy cppArg3 = QPageSize::SizeMatchPolicy::FuzzyMatch;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QPageSize(QSizeF,QPageSize::Unit,QString,QPageSize::SizeMatchPolicy)
                cptr = new ::QPageSize(*cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPageSize >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPageSize_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPageSize_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPageSizeFunc_definitionSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPageSize *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.definitionSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "definitionSize", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPageSize::definitionSize()const
    // 1: static QPageSize::definitionSize(QPageSize::PageSizeId)
    if (numArgs == 0) {
        overloadId = 0; // definitionSize()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // definitionSize(QPageSize::PageSizeId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_definitionSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // definitionSize() const
        {

            if (!PyErr_Occurred()) {
                // definitionSize()const
                QSizeF cppResult = const_cast<const ::QPageSize *>(cppSelf)->definitionSize();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
            }
            break;
        }
        case 1: // definitionSize(QPageSize::PageSizeId pageSizeId)
        {
            ::QPageSize::PageSizeId cppArg0{QPageSize::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // definitionSize(QPageSize::PageSizeId)
                QSizeF cppResult = ::QPageSize::definitionSize(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_definitionSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_definitionUnits(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPageSize *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.definitionUnits";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "definitionUnits", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPageSize::definitionUnits()const
    // 1: static QPageSize::definitionUnits(QPageSize::PageSizeId)
    if (numArgs == 0) {
        overloadId = 0; // definitionUnits()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // definitionUnits(QPageSize::PageSizeId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_definitionUnits_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // definitionUnits() const
        {

            if (!PyErr_Occurred()) {
                // definitionUnits()const
                QPageSize::Unit cppResult = const_cast<const ::QPageSize *>(cppSelf)->definitionUnits();
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX])->converter, &cppResult);
            }
            break;
        }
        case 1: // definitionUnits(QPageSize::PageSizeId pageSizeId)
        {
            ::QPageSize::PageSizeId cppArg0{QPageSize::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // definitionUnits(QPageSize::PageSizeId)
                QPageSize::Unit cppResult = ::QPageSize::definitionUnits(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX])->converter, &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_definitionUnits_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_id(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPageSize *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.id";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPageSizeFunc_id_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:id", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPageSize::id()const
    // 1: static QPageSize::id(QSize,QPageSize::SizeMatchPolicy)
    // 2: static QPageSize::id(QSizeF,QPageSize::Unit,QPageSize::SizeMatchPolicy)
    // 3: static QPageSize::id(int)
    if (numArgs == 0) {
        overloadId = 0; // id()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 3; // id(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // id(QSize,QPageSize::SizeMatchPolicy)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // id(QSize,QPageSize::SizeMatchPolicy)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // id(QSizeF,QPageSize::Unit,QPageSize::SizeMatchPolicy)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX])->converter, (pyArgs[2])))) {
            overloadId = 2; // id(QSizeF,QPageSize::Unit,QPageSize::SizeMatchPolicy)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_id_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // id() const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPageSizeFunc_id_TypeError;
            }

            if (!PyErr_Occurred()) {
                // id()const
                QPageSize::PageSizeId cppResult = const_cast<const ::QPageSize *>(cppSelf)->id();
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, &cppResult);
            }
            break;
        }
        case 1: // id(const QSize & pointSize, QPageSize::SizeMatchPolicy matchPolicy)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_matchPolicy = Shiboken::String::createStaticString("matchPolicy");
                if (PyDict_Contains(kwds, key_matchPolicy)) {
                    value = PyDict_GetItem(kwds, key_matchPolicy);
                    if (value && pyArgs[1]) {
                        errInfo = key_matchPolicy;
                        Py_INCREF(errInfo);
                        goto Sbk_QPageSizeFunc_id_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QPageSizeFunc_id_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchPolicy);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPageSizeFunc_id_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QPageSize::SizeMatchPolicy cppArg1 = QPageSize::SizeMatchPolicy::FuzzyMatch;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // id(QSize,QPageSize::SizeMatchPolicy)
                QPageSize::PageSizeId cppResult = ::QPageSize::id(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, &cppResult);
            }
            break;
        }
        case 2: // id(const QSizeF & size, QPageSize::Unit units, QPageSize::SizeMatchPolicy matchPolicy)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_matchPolicy = Shiboken::String::createStaticString("matchPolicy");
                if (PyDict_Contains(kwds, key_matchPolicy)) {
                    value = PyDict_GetItem(kwds, key_matchPolicy);
                    if (value && pyArgs[2]) {
                        errInfo = key_matchPolicy;
                        Py_INCREF(errInfo);
                        goto Sbk_QPageSizeFunc_id_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QPageSizeFunc_id_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchPolicy);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPageSizeFunc_id_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSizeF cppArg0_local;
            ::QSizeF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QPageSize::Unit cppArg1{QPageSize::Millimeter};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QPageSize::SizeMatchPolicy cppArg2 = QPageSize::SizeMatchPolicy::FuzzyMatch;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // id(QSizeF,QPageSize::Unit,QPageSize::SizeMatchPolicy)
                QPageSize::PageSizeId cppResult = ::QPageSize::id(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, &cppResult);
            }
            break;
        }
        case 3: // id(int windowsId)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPageSizeFunc_id_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // id(int)
                QPageSize::PageSizeId cppResult = ::QPageSize::id(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_id_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_isEquivalentTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.isEquivalentTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageSize::isEquivalentTo(QPageSize)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), (pyArg)))) {
        overloadId = 0; // isEquivalentTo(QPageSize)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_isEquivalentTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPageSize cppArg0_local;
        ::QPageSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isEquivalentTo(QPageSize)const
            bool cppResult = const_cast<const ::QPageSize *>(cppSelf)->isEquivalentTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_isEquivalentTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QPageSize *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageSizeFunc_key(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPageSize *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.key";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "key", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPageSize::key()const
    // 1: static QPageSize::key(QPageSize::PageSizeId)
    if (numArgs == 0) {
        overloadId = 0; // key()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // key(QPageSize::PageSizeId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_key_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // key() const
        {

            if (!PyErr_Occurred()) {
                // key()const
                QString cppResult = const_cast<const ::QPageSize *>(cppSelf)->key();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // key(QPageSize::PageSizeId pageSizeId)
        {
            ::QPageSize::PageSizeId cppArg0{QPageSize::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // key(QPageSize::PageSizeId)
                QString cppResult = ::QPageSize::key(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_key_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_name(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPageSize *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.name";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "name", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPageSize::name()const
    // 1: static QPageSize::name(QPageSize::PageSizeId)
    if (numArgs == 0) {
        overloadId = 0; // name()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // name(QPageSize::PageSizeId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_name_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // name() const
        {

            if (!PyErr_Occurred()) {
                // name()const
                QString cppResult = const_cast<const ::QPageSize *>(cppSelf)->name();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // name(QPageSize::PageSizeId pageSizeId)
        {
            ::QPageSize::PageSizeId cppArg0{QPageSize::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // name(QPageSize::PageSizeId)
                QString cppResult = ::QPageSize::name(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_name_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_rect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.rect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageSize::rect(QPageSize::Unit)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // rect(QPageSize::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_rect_TypeError;

    // Call function/method
    {
        ::QPageSize::Unit cppArg0{QPageSize::Millimeter};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rect(QPageSize::Unit)const
            QRectF cppResult = const_cast<const ::QPageSize *>(cppSelf)->rect(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_rect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_rectPixels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.rectPixels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageSize::rectPixels(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // rectPixels(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_rectPixels_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rectPixels(int)const
            QRect cppResult = const_cast<const ::QPageSize *>(cppSelf)->rectPixels(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_rectPixels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_rectPoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.rectPoints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rectPoints()const
            QRect cppResult = const_cast<const ::QPageSize *>(cppSelf)->rectPoints();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageSizeFunc_size(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPageSize *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.size";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "size", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QPageSize::size(QPageSize::PageSizeId,QPageSize::Unit)
    // 1: QPageSize::size(QPageSize::Unit)const
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // size(QPageSize::Unit)const
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // size(QPageSize::PageSizeId,QPageSize::Unit)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_size_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // size(QPageSize::PageSizeId pageSizeId, QPageSize::Unit units)
        {
            ::QPageSize::PageSizeId cppArg0{QPageSize::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QPageSize::Unit cppArg1{QPageSize::Millimeter};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // size(QPageSize::PageSizeId,QPageSize::Unit)
                QSizeF cppResult = ::QPageSize::size(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
            }
            break;
        }
        case 1: // size(QPageSize::Unit units) const
        {
            ::QPageSize::Unit cppArg0{QPageSize::Millimeter};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // size(QPageSize::Unit)const
                QSizeF cppResult = const_cast<const ::QPageSize *>(cppSelf)->size(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_size_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_sizePixels(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPageSize *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.sizePixels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sizePixels", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QPageSize::sizePixels(QPageSize::PageSizeId,int)
    // 1: QPageSize::sizePixels(int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // sizePixels(QPageSize::PageSizeId,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // sizePixels(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_sizePixels_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // sizePixels(QPageSize::PageSizeId pageSizeId, int resolution)
        {
            ::QPageSize::PageSizeId cppArg0{QPageSize::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // sizePixels(QPageSize::PageSizeId,int)
                QSize cppResult = ::QPageSize::sizePixels(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // sizePixels(int resolution) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // sizePixels(int)const
                QSize cppResult = const_cast<const ::QPageSize *>(cppSelf)->sizePixels(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_sizePixels_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_sizePoints(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPageSize *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.sizePoints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sizePoints", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPageSize::sizePoints()const
    // 1: static QPageSize::sizePoints(QPageSize::PageSizeId)
    if (numArgs == 0) {
        overloadId = 0; // sizePoints()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // sizePoints(QPageSize::PageSizeId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_sizePoints_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // sizePoints() const
        {

            if (!PyErr_Occurred()) {
                // sizePoints()const
                QSize cppResult = const_cast<const ::QPageSize *>(cppSelf)->sizePoints();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // sizePoints(QPageSize::PageSizeId pageSizeId)
        {
            ::QPageSize::PageSizeId cppArg0{QPageSize::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // sizePoints(QPageSize::PageSizeId)
                QSize cppResult = ::QPageSize::sizePoints(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_sizePoints_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageSize::swap(QPageSize&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QPageSize&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPageSize cppArg0_local;
        ::QPageSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QPageSize&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPageSizeFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSizeFunc_windowsId(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QPageSize *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageSize.windowsId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "windowsId", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPageSize::windowsId()const
    // 1: static QPageSize::windowsId(QPageSize::PageSizeId)
    if (numArgs == 0) {
        overloadId = 0; // windowsId()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // windowsId(QPageSize::PageSizeId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageSizeFunc_windowsId_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // windowsId() const
        {

            if (!PyErr_Occurred()) {
                // windowsId()const
                int cppResult = const_cast<const ::QPageSize *>(cppSelf)->windowsId();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // windowsId(QPageSize::PageSizeId pageSizeId)
        {
            ::QPageSize::PageSizeId cppArg0{QPageSize::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // windowsId(QPageSize::PageSizeId)
                int cppResult = ::QPageSize::windowsId(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageSizeFunc_windowsId_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageSize___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyMethodDef Sbk_QPageSizeMethod_definitionSize = {
    "definitionSize", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_definitionSize), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QPageSizeMethod_definitionUnits = {
    "definitionUnits", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_definitionUnits), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QPageSizeMethod_id = {
    "id", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_id), METH_VARARGS|METH_KEYWORDS|METH_STATIC
};

static PyMethodDef Sbk_QPageSizeMethod_key = {
    "key", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_key), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QPageSizeMethod_name = {
    "name", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_name), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QPageSizeMethod_size = {
    "size", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_size), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QPageSizeMethod_sizePixels = {
    "sizePixels", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_sizePixels), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QPageSizeMethod_sizePoints = {
    "sizePoints", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_sizePoints), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QPageSizeMethod_windowsId = {
    "windowsId", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_windowsId), METH_VARARGS|METH_STATIC
};


static const char *Sbk_QPageSize_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPageSize_methods[] = {
    Sbk_QPageSizeMethod_definitionSize,
    Sbk_QPageSizeMethod_definitionUnits,
    Sbk_QPageSizeMethod_id,
    {"isEquivalentTo", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_isEquivalentTo), METH_O},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_isValid), METH_NOARGS},
    Sbk_QPageSizeMethod_key,
    Sbk_QPageSizeMethod_name,
    {"rect", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_rect), METH_O},
    {"rectPixels", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_rectPixels), METH_O},
    {"rectPoints", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_rectPoints), METH_NOARGS},
    Sbk_QPageSizeMethod_size,
    Sbk_QPageSizeMethod_sizePixels,
    Sbk_QPageSizeMethod_sizePoints,
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QPageSizeFunc_swap), METH_O},
    Sbk_QPageSizeMethod_windowsId,

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPageSize___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QPageSize_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PyObject_GenericGetAttr(self, name);
    }
    static PyMethodDef non_static_Sbk_QPageSizeMethod_definitionSize = {
        Sbk_QPageSizeMethod_definitionSize.ml_name,
        Sbk_QPageSizeMethod_definitionSize.ml_meth,
        Sbk_QPageSizeMethod_definitionSize.ml_flags & (~METH_STATIC),
        Sbk_QPageSizeMethod_definitionSize.ml_doc,
    };
    if (Shiboken::String::compare(name, "definitionSize") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPageSizeMethod_definitionSize, self, 0);
    static PyMethodDef non_static_Sbk_QPageSizeMethod_definitionUnits = {
        Sbk_QPageSizeMethod_definitionUnits.ml_name,
        Sbk_QPageSizeMethod_definitionUnits.ml_meth,
        Sbk_QPageSizeMethod_definitionUnits.ml_flags & (~METH_STATIC),
        Sbk_QPageSizeMethod_definitionUnits.ml_doc,
    };
    if (Shiboken::String::compare(name, "definitionUnits") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPageSizeMethod_definitionUnits, self, 0);
    static PyMethodDef non_static_Sbk_QPageSizeMethod_id = {
        Sbk_QPageSizeMethod_id.ml_name,
        Sbk_QPageSizeMethod_id.ml_meth,
        Sbk_QPageSizeMethod_id.ml_flags & (~METH_STATIC),
        Sbk_QPageSizeMethod_id.ml_doc,
    };
    if (Shiboken::String::compare(name, "id") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPageSizeMethod_id, self, 0);
    static PyMethodDef non_static_Sbk_QPageSizeMethod_key = {
        Sbk_QPageSizeMethod_key.ml_name,
        Sbk_QPageSizeMethod_key.ml_meth,
        Sbk_QPageSizeMethod_key.ml_flags & (~METH_STATIC),
        Sbk_QPageSizeMethod_key.ml_doc,
    };
    if (Shiboken::String::compare(name, "key") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPageSizeMethod_key, self, 0);
    static PyMethodDef non_static_Sbk_QPageSizeMethod_name = {
        Sbk_QPageSizeMethod_name.ml_name,
        Sbk_QPageSizeMethod_name.ml_meth,
        Sbk_QPageSizeMethod_name.ml_flags & (~METH_STATIC),
        Sbk_QPageSizeMethod_name.ml_doc,
    };
    if (Shiboken::String::compare(name, "name") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPageSizeMethod_name, self, 0);
    static PyMethodDef non_static_Sbk_QPageSizeMethod_size = {
        Sbk_QPageSizeMethod_size.ml_name,
        Sbk_QPageSizeMethod_size.ml_meth,
        Sbk_QPageSizeMethod_size.ml_flags & (~METH_STATIC),
        Sbk_QPageSizeMethod_size.ml_doc,
    };
    if (Shiboken::String::compare(name, "size") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPageSizeMethod_size, self, 0);
    static PyMethodDef non_static_Sbk_QPageSizeMethod_sizePixels = {
        Sbk_QPageSizeMethod_sizePixels.ml_name,
        Sbk_QPageSizeMethod_sizePixels.ml_meth,
        Sbk_QPageSizeMethod_sizePixels.ml_flags & (~METH_STATIC),
        Sbk_QPageSizeMethod_sizePixels.ml_doc,
    };
    if (Shiboken::String::compare(name, "sizePixels") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPageSizeMethod_sizePixels, self, 0);
    static PyMethodDef non_static_Sbk_QPageSizeMethod_sizePoints = {
        Sbk_QPageSizeMethod_sizePoints.ml_name,
        Sbk_QPageSizeMethod_sizePoints.ml_meth,
        Sbk_QPageSizeMethod_sizePoints.ml_flags & (~METH_STATIC),
        Sbk_QPageSizeMethod_sizePoints.ml_doc,
    };
    if (Shiboken::String::compare(name, "sizePoints") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPageSizeMethod_sizePoints, self, 0);
    static PyMethodDef non_static_Sbk_QPageSizeMethod_windowsId = {
        Sbk_QPageSizeMethod_windowsId.ml_name,
        Sbk_QPageSizeMethod_windowsId.ml_meth,
        Sbk_QPageSizeMethod_windowsId.ml_flags & (~METH_STATIC),
        Sbk_QPageSizeMethod_windowsId.ml_doc,
    };
    if (Shiboken::String::compare(name, "windowsId") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QPageSizeMethod_windowsId, self, 0);
    return PyObject_GenericGetAttr(self, name);
}

// Rich comparison
static PyObject * Sbk_QPageSize_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), (pyArg)))) {
                // operator!=(const QPageSize & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPageSize cppArg0_local;
                ::QPageSize *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), (pyArg)))) {
                // operator==(const QPageSize & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPageSize cppArg0_local;
                ::QPageSize *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPageSize_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPageSize_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPageSize_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPageSize_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QPageSize__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPageSize_Type = nullptr;
static SbkObjectType *Sbk_QPageSize_TypeF(void)
{
    return _Sbk_QPageSize_Type;
}

static PyType_Slot Sbk_QPageSize_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QPageSize__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QPageSize_getattro)},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPageSize_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPageSize_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPageSize_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPageSize_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPageSize_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPageSize_spec = {
    "2:PySide2.QtGui.QPageSize",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPageSize_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QPageSize_PageSizeId_PythonToCpp_QPageSize_PageSizeId(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPageSize::PageSizeId *>(cppOut) =
        static_cast<::QPageSize::PageSizeId>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPageSize_PageSizeId_PythonToCpp_QPageSize_PageSizeId_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX]))
        return QPageSize_PageSizeId_PythonToCpp_QPageSize_PageSizeId;
    return {};
}
static PyObject *QPageSize_PageSizeId_CppToPython_QPageSize_PageSizeId(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPageSize::PageSizeId *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX], castCppIn);

}

static void QPageSize_Unit_PythonToCpp_QPageSize_Unit(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPageSize::Unit *>(cppOut) =
        static_cast<::QPageSize::Unit>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPageSize_Unit_PythonToCpp_QPageSize_Unit_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX]))
        return QPageSize_Unit_PythonToCpp_QPageSize_Unit;
    return {};
}
static PyObject *QPageSize_Unit_CppToPython_QPageSize_Unit(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPageSize::Unit *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX], castCppIn);

}

static void QPageSize_SizeMatchPolicy_PythonToCpp_QPageSize_SizeMatchPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPageSize::SizeMatchPolicy *>(cppOut) =
        static_cast<::QPageSize::SizeMatchPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPageSize_SizeMatchPolicy_PythonToCpp_QPageSize_SizeMatchPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX]))
        return QPageSize_SizeMatchPolicy_PythonToCpp_QPageSize_SizeMatchPolicy;
    return {};
}
static PyObject *QPageSize_SizeMatchPolicy_CppToPython_QPageSize_SizeMatchPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPageSize::SizeMatchPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPageSize_PythonToCpp_QPageSize_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPageSize_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPageSize_PythonToCpp_QPageSize_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPageSize_TypeF())))
        return QPageSize_PythonToCpp_QPageSize_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPageSize_PTR_CppToPython_QPageSize(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPageSize *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPageSize_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPageSize_COPY_CppToPython_QPageSize(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPageSize_TypeF(), new ::QPageSize(*reinterpret_cast<const ::QPageSize *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPageSize_PythonToCpp_QPageSize_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPageSize *>(cppOut) = *reinterpret_cast< ::QPageSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPageSize_PythonToCpp_QPageSize_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPageSize_TypeF())))
        return QPageSize_PythonToCpp_QPageSize_COPY;
    return {};
}

// Implicit conversions.
static void QPageSize_PageSizeId_PythonToCpp_QPageSize(PyObject *pyIn, void *cppOut) {
    ::QPageSize::PageSizeId cppIn{QPageSize::A4};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QPageSize *>(cppOut) = ::QPageSize(cppIn);
}
static PythonToCppFunc is_QPageSize_PageSizeId_PythonToCpp_QPageSize_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX], pyIn))
        return QPageSize_PageSizeId_PythonToCpp_QPageSize;
    return {};
}

static void PySide2_QtCore_constQSizeREF_PythonToCpp_QPageSize(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPageSize *>(cppOut) = ::QPageSize( *reinterpret_cast< ::QSize *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtCore_constQSizeREF_PythonToCpp_QPageSize_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX], pyIn))
        return PySide2_QtCore_constQSizeREF_PythonToCpp_QPageSize;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPageSize_SignatureStrings[] = {
    "4:PySide2.QtGui.QPageSize(self)",
    "3:PySide2.QtGui.QPageSize(self,pageSizeId:PySide2.QtGui.QPageSize.PageSizeId)",
    "2:PySide2.QtGui.QPageSize(self,other:PySide2.QtGui.QPageSize)",
    "1:PySide2.QtGui.QPageSize(self,pointSize:PySide2.QtCore.QSize,name:QString=QString(),matchPolicy:PySide2.QtGui.QPageSize.SizeMatchPolicy=FuzzyMatch)",
    "0:PySide2.QtGui.QPageSize(self,size:PySide2.QtCore.QSizeF,units:PySide2.QtGui.QPageSize.Unit,name:QString=QString(),matchPolicy:PySide2.QtGui.QPageSize.SizeMatchPolicy=FuzzyMatch)",
    "1:PySide2.QtGui.QPageSize.definitionSize(self)->PySide2.QtCore.QSizeF",
    "0:PySide2.QtGui.QPageSize.definitionSize(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId)->PySide2.QtCore.QSizeF",
    "1:PySide2.QtGui.QPageSize.definitionUnits(self)->PySide2.QtGui.QPageSize.Unit",
    "0:PySide2.QtGui.QPageSize.definitionUnits(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId)->PySide2.QtGui.QPageSize.Unit",
    "3:PySide2.QtGui.QPageSize.id(self)->PySide2.QtGui.QPageSize.PageSizeId",
    "2:PySide2.QtGui.QPageSize.id(pointSize:PySide2.QtCore.QSize,matchPolicy:PySide2.QtGui.QPageSize.SizeMatchPolicy=FuzzyMatch)->PySide2.QtGui.QPageSize.PageSizeId",
    "1:PySide2.QtGui.QPageSize.id(size:PySide2.QtCore.QSizeF,units:PySide2.QtGui.QPageSize.Unit,matchPolicy:PySide2.QtGui.QPageSize.SizeMatchPolicy=FuzzyMatch)->PySide2.QtGui.QPageSize.PageSizeId",
    "0:PySide2.QtGui.QPageSize.id(windowsId:int)->PySide2.QtGui.QPageSize.PageSizeId",
    "PySide2.QtGui.QPageSize.isEquivalentTo(self,other:PySide2.QtGui.QPageSize)->bool",
    "PySide2.QtGui.QPageSize.isValid(self)->bool",
    "1:PySide2.QtGui.QPageSize.key(self)->QString",
    "0:PySide2.QtGui.QPageSize.key(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId)->QString",
    "1:PySide2.QtGui.QPageSize.name(self)->QString",
    "0:PySide2.QtGui.QPageSize.name(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId)->QString",
    "PySide2.QtGui.QPageSize.rect(self,units:PySide2.QtGui.QPageSize.Unit)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QPageSize.rectPixels(self,resolution:int)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QPageSize.rectPoints(self)->PySide2.QtCore.QRect",
    "1:PySide2.QtGui.QPageSize.size(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId,units:PySide2.QtGui.QPageSize.Unit)->PySide2.QtCore.QSizeF",
    "0:PySide2.QtGui.QPageSize.size(self,units:PySide2.QtGui.QPageSize.Unit)->PySide2.QtCore.QSizeF",
    "1:PySide2.QtGui.QPageSize.sizePixels(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId,resolution:int)->PySide2.QtCore.QSize",
    "0:PySide2.QtGui.QPageSize.sizePixels(self,resolution:int)->PySide2.QtCore.QSize",
    "1:PySide2.QtGui.QPageSize.sizePoints(self)->PySide2.QtCore.QSize",
    "0:PySide2.QtGui.QPageSize.sizePoints(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QPageSize.swap(self,other:PySide2.QtGui.QPageSize)",
    "1:PySide2.QtGui.QPageSize.windowsId(self)->int",
    "0:PySide2.QtGui.QPageSize.windowsId(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId)->int",
    "PySide2.QtGui.QPageSize.__copy__()",
    nullptr}; // Sentinel

void init_QPageSize(PyObject *module)
{
    _Sbk_QPageSize_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPageSize",
        "QPageSize",
        &Sbk_QPageSize_spec,
        &Shiboken::callCppDestructor< ::QPageSize >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPageSize_Type);
    InitSignatureStrings(pyType, QPageSize_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPageSize_Type), Sbk_QPageSize_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPageSize_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPageSize_TypeF(),
        QPageSize_PythonToCpp_QPageSize_PTR,
        is_QPageSize_PythonToCpp_QPageSize_PTR_Convertible,
        QPageSize_PTR_CppToPython_QPageSize,
        QPageSize_COPY_CppToPython_QPageSize);

    Shiboken::Conversions::registerConverterName(converter, "QPageSize");
    Shiboken::Conversions::registerConverterName(converter, "QPageSize*");
    Shiboken::Conversions::registerConverterName(converter, "QPageSize&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPageSize).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPageSize_PythonToCpp_QPageSize_COPY,
        is_QPageSize_PythonToCpp_QPageSize_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPageSize_PageSizeId_PythonToCpp_QPageSize,
        is_QPageSize_PageSizeId_PythonToCpp_QPageSize_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQSizeREF_PythonToCpp_QPageSize,
        is_PySide2_QtCore_constQSizeREF_PythonToCpp_QPageSize_Convertible);

    // Initialization of enums.

    // Initialization of enum 'PageSizeId'.
    SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPageSize_TypeF(),
        "PageSizeId",
        "2:PySide2.QtGui.QPageSize.PageSizeId",
        "QPageSize::PageSizeId");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A4", (long) QPageSize::PageSizeId::A4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B5", (long) QPageSize::PageSizeId::B5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Letter", (long) QPageSize::PageSizeId::Letter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Legal", (long) QPageSize::PageSizeId::Legal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Executive", (long) QPageSize::PageSizeId::Executive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A0", (long) QPageSize::PageSizeId::A0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A1", (long) QPageSize::PageSizeId::A1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A2", (long) QPageSize::PageSizeId::A2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A3", (long) QPageSize::PageSizeId::A3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A5", (long) QPageSize::PageSizeId::A5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A6", (long) QPageSize::PageSizeId::A6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A7", (long) QPageSize::PageSizeId::A7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A8", (long) QPageSize::PageSizeId::A8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A9", (long) QPageSize::PageSizeId::A9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B0", (long) QPageSize::PageSizeId::B0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B1", (long) QPageSize::PageSizeId::B1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B10", (long) QPageSize::PageSizeId::B10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B2", (long) QPageSize::PageSizeId::B2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B3", (long) QPageSize::PageSizeId::B3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B4", (long) QPageSize::PageSizeId::B4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B6", (long) QPageSize::PageSizeId::B6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B7", (long) QPageSize::PageSizeId::B7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B8", (long) QPageSize::PageSizeId::B8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B9", (long) QPageSize::PageSizeId::B9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "C5E", (long) QPageSize::PageSizeId::C5E))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Comm10E", (long) QPageSize::PageSizeId::Comm10E))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "DLE", (long) QPageSize::PageSizeId::DLE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Folio", (long) QPageSize::PageSizeId::Folio))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Ledger", (long) QPageSize::PageSizeId::Ledger))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Tabloid", (long) QPageSize::PageSizeId::Tabloid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Custom", (long) QPageSize::PageSizeId::Custom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A10", (long) QPageSize::PageSizeId::A10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A3Extra", (long) QPageSize::PageSizeId::A3Extra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A4Extra", (long) QPageSize::PageSizeId::A4Extra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A4Plus", (long) QPageSize::PageSizeId::A4Plus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A4Small", (long) QPageSize::PageSizeId::A4Small))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "A5Extra", (long) QPageSize::PageSizeId::A5Extra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "B5Extra", (long) QPageSize::PageSizeId::B5Extra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB0", (long) QPageSize::PageSizeId::JisB0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB1", (long) QPageSize::PageSizeId::JisB1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB2", (long) QPageSize::PageSizeId::JisB2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB3", (long) QPageSize::PageSizeId::JisB3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB4", (long) QPageSize::PageSizeId::JisB4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB5", (long) QPageSize::PageSizeId::JisB5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB6", (long) QPageSize::PageSizeId::JisB6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB7", (long) QPageSize::PageSizeId::JisB7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB8", (long) QPageSize::PageSizeId::JisB8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB9", (long) QPageSize::PageSizeId::JisB9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "JisB10", (long) QPageSize::PageSizeId::JisB10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "AnsiC", (long) QPageSize::PageSizeId::AnsiC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "AnsiD", (long) QPageSize::PageSizeId::AnsiD))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "AnsiE", (long) QPageSize::PageSizeId::AnsiE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "LegalExtra", (long) QPageSize::PageSizeId::LegalExtra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "LetterExtra", (long) QPageSize::PageSizeId::LetterExtra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "LetterPlus", (long) QPageSize::PageSizeId::LetterPlus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "LetterSmall", (long) QPageSize::PageSizeId::LetterSmall))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "TabloidExtra", (long) QPageSize::PageSizeId::TabloidExtra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "ArchA", (long) QPageSize::PageSizeId::ArchA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "ArchB", (long) QPageSize::PageSizeId::ArchB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "ArchC", (long) QPageSize::PageSizeId::ArchC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "ArchD", (long) QPageSize::PageSizeId::ArchD))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "ArchE", (long) QPageSize::PageSizeId::ArchE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Imperial7x9", (long) QPageSize::PageSizeId::Imperial7x9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Imperial8x10", (long) QPageSize::PageSizeId::Imperial8x10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Imperial9x11", (long) QPageSize::PageSizeId::Imperial9x11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Imperial9x12", (long) QPageSize::PageSizeId::Imperial9x12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Imperial10x11", (long) QPageSize::PageSizeId::Imperial10x11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Imperial10x13", (long) QPageSize::PageSizeId::Imperial10x13))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Imperial10x14", (long) QPageSize::PageSizeId::Imperial10x14))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Imperial12x11", (long) QPageSize::PageSizeId::Imperial12x11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Imperial15x11", (long) QPageSize::PageSizeId::Imperial15x11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "ExecutiveStandard", (long) QPageSize::PageSizeId::ExecutiveStandard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Note", (long) QPageSize::PageSizeId::Note))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Quarto", (long) QPageSize::PageSizeId::Quarto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Statement", (long) QPageSize::PageSizeId::Statement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "SuperA", (long) QPageSize::PageSizeId::SuperA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "SuperB", (long) QPageSize::PageSizeId::SuperB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Postcard", (long) QPageSize::PageSizeId::Postcard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "DoublePostcard", (long) QPageSize::PageSizeId::DoublePostcard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Prc16K", (long) QPageSize::PageSizeId::Prc16K))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Prc32K", (long) QPageSize::PageSizeId::Prc32K))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Prc32KBig", (long) QPageSize::PageSizeId::Prc32KBig))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "FanFoldUS", (long) QPageSize::PageSizeId::FanFoldUS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "FanFoldGerman", (long) QPageSize::PageSizeId::FanFoldGerman))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "FanFoldGermanLegal", (long) QPageSize::PageSizeId::FanFoldGermanLegal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeB4", (long) QPageSize::PageSizeId::EnvelopeB4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeB5", (long) QPageSize::PageSizeId::EnvelopeB5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeB6", (long) QPageSize::PageSizeId::EnvelopeB6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeC0", (long) QPageSize::PageSizeId::EnvelopeC0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeC1", (long) QPageSize::PageSizeId::EnvelopeC1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeC2", (long) QPageSize::PageSizeId::EnvelopeC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeC3", (long) QPageSize::PageSizeId::EnvelopeC3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeC4", (long) QPageSize::PageSizeId::EnvelopeC4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeC6", (long) QPageSize::PageSizeId::EnvelopeC6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeC65", (long) QPageSize::PageSizeId::EnvelopeC65))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeC7", (long) QPageSize::PageSizeId::EnvelopeC7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Envelope9", (long) QPageSize::PageSizeId::Envelope9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Envelope11", (long) QPageSize::PageSizeId::Envelope11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Envelope12", (long) QPageSize::PageSizeId::Envelope12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Envelope14", (long) QPageSize::PageSizeId::Envelope14))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeMonarch", (long) QPageSize::PageSizeId::EnvelopeMonarch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePersonal", (long) QPageSize::PageSizeId::EnvelopePersonal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeChou3", (long) QPageSize::PageSizeId::EnvelopeChou3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeChou4", (long) QPageSize::PageSizeId::EnvelopeChou4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeInvite", (long) QPageSize::PageSizeId::EnvelopeInvite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeItalian", (long) QPageSize::PageSizeId::EnvelopeItalian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeKaku2", (long) QPageSize::PageSizeId::EnvelopeKaku2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeKaku3", (long) QPageSize::PageSizeId::EnvelopeKaku3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc1", (long) QPageSize::PageSizeId::EnvelopePrc1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc2", (long) QPageSize::PageSizeId::EnvelopePrc2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc3", (long) QPageSize::PageSizeId::EnvelopePrc3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc4", (long) QPageSize::PageSizeId::EnvelopePrc4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc5", (long) QPageSize::PageSizeId::EnvelopePrc5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc6", (long) QPageSize::PageSizeId::EnvelopePrc6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc7", (long) QPageSize::PageSizeId::EnvelopePrc7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc8", (long) QPageSize::PageSizeId::EnvelopePrc8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc9", (long) QPageSize::PageSizeId::EnvelopePrc9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopePrc10", (long) QPageSize::PageSizeId::EnvelopePrc10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeYou4", (long) QPageSize::PageSizeId::EnvelopeYou4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "LastPageSize", (long) QPageSize::PageSizeId::LastPageSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "NPageSize", (long) QPageSize::PageSizeId::NPageSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "NPaperSize", (long) QPageSize::PageSizeId::NPaperSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "AnsiA", (long) QPageSize::PageSizeId::AnsiA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "AnsiB", (long) QPageSize::PageSizeId::AnsiB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeC5", (long) QPageSize::PageSizeId::EnvelopeC5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "EnvelopeDL", (long) QPageSize::PageSizeId::EnvelopeDL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
        Sbk_QPageSize_TypeF(), "Envelope10", (long) QPageSize::PageSizeId::Envelope10))
        return;
    // Register converter for enum 'QPageSize::PageSizeId'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX],
            QPageSize_PageSizeId_CppToPython_QPageSize_PageSizeId);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPageSize_PageSizeId_PythonToCpp_QPageSize_PageSizeId,
            is_QPageSize_PageSizeId_PythonToCpp_QPageSize_PageSizeId_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_PAGESIZEID_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPageSize::PageSizeId");
        Shiboken::Conversions::registerConverterName(converter, "PageSizeId");
    }
    // End of 'PageSizeId' enum.

    // Initialization of enum 'Unit'.
    SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPageSize_TypeF(),
        "Unit",
        "2:PySide2.QtGui.QPageSize.Unit",
        "QPageSize::Unit");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX],
        Sbk_QPageSize_TypeF(), "Millimeter", (long) QPageSize::Unit::Millimeter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX],
        Sbk_QPageSize_TypeF(), "Point", (long) QPageSize::Unit::Point))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX],
        Sbk_QPageSize_TypeF(), "Inch", (long) QPageSize::Unit::Inch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX],
        Sbk_QPageSize_TypeF(), "Pica", (long) QPageSize::Unit::Pica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX],
        Sbk_QPageSize_TypeF(), "Didot", (long) QPageSize::Unit::Didot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX],
        Sbk_QPageSize_TypeF(), "Cicero", (long) QPageSize::Unit::Cicero))
        return;
    // Register converter for enum 'QPageSize::Unit'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX],
            QPageSize_Unit_CppToPython_QPageSize_Unit);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPageSize_Unit_PythonToCpp_QPageSize_Unit,
            is_QPageSize_Unit_PythonToCpp_QPageSize_Unit_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_UNIT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPageSize::Unit");
        Shiboken::Conversions::registerConverterName(converter, "Unit");
    }
    // End of 'Unit' enum.

    // Initialization of enum 'SizeMatchPolicy'.
    SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPageSize_TypeF(),
        "SizeMatchPolicy",
        "2:PySide2.QtGui.QPageSize.SizeMatchPolicy",
        "QPageSize::SizeMatchPolicy");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX],
        Sbk_QPageSize_TypeF(), "FuzzyMatch", (long) QPageSize::SizeMatchPolicy::FuzzyMatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX],
        Sbk_QPageSize_TypeF(), "FuzzyOrientationMatch", (long) QPageSize::SizeMatchPolicy::FuzzyOrientationMatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX],
        Sbk_QPageSize_TypeF(), "ExactMatch", (long) QPageSize::SizeMatchPolicy::ExactMatch))
        return;
    // Register converter for enum 'QPageSize::SizeMatchPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX],
            QPageSize_SizeMatchPolicy_CppToPython_QPageSize_SizeMatchPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPageSize_SizeMatchPolicy_PythonToCpp_QPageSize_SizeMatchPolicy,
            is_QPageSize_SizeMatchPolicy_PythonToCpp_QPageSize_SizeMatchPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_SIZEMATCHPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPageSize::SizeMatchPolicy");
        Shiboken::Conversions::registerConverterName(converter, "SizeMatchPolicy");
    }
    // End of 'SizeMatchPolicy' enum.

    qRegisterMetaType< ::QPageSize >("QPageSize");
    qRegisterMetaType< ::QPageSize::PageSizeId >("QPageSize::PageSizeId");
    qRegisterMetaType< ::QPageSize::Unit >("QPageSize::Unit");
    qRegisterMetaType< ::QPageSize::SizeMatchPolicy >("QPageSize::SizeMatchPolicy");
}
