/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopengldebugmessage_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qopengldebug.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLDebugMessage_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLDebugMessage >()))
        return -1;

    ::QOpenGLDebugMessage *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugMessage.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QOpenGLDebugMessage", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLDebugMessage::QOpenGLDebugMessage()
    // 1: QOpenGLDebugMessage::QOpenGLDebugMessage(QOpenGLDebugMessage)
    if (numArgs == 0) {
        overloadId = 0; // QOpenGLDebugMessage()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QOpenGLDebugMessage(QOpenGLDebugMessage)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugMessage_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QOpenGLDebugMessage()
        {

            if (!PyErr_Occurred()) {
                // QOpenGLDebugMessage()
                cptr = new ::QOpenGLDebugMessage();
            }
            break;
        }
        case 1: // QOpenGLDebugMessage(const QOpenGLDebugMessage & debugMessage)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QOpenGLDebugMessage cppArg0_local;
            ::QOpenGLDebugMessage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QOpenGLDebugMessage(QOpenGLDebugMessage)
                cptr = new ::QOpenGLDebugMessage(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLDebugMessage >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLDebugMessage_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QOpenGLDebugMessage_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLDebugMessageFunc_createApplicationMessage(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugMessage.createApplicationMessage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:createApplicationMessage", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLDebugMessage::createApplicationMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createApplicationMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // createApplicationMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // createApplicationMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 0; // createApplicationMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_id = Shiboken::String::createStaticString("id");
            if (PyDict_Contains(kwds, key_id)) {
                value = PyDict_GetItem(kwds, key_id);
                if (value && pyArgs[1]) {
                    errInfo = key_id;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1]))))
                        goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_id);
            }
            static PyObject *const key_severity = Shiboken::String::createStaticString("severity");
            if (PyDict_Contains(kwds, key_severity)) {
                value = PyDict_GetItem(kwds, key_severity);
                if (value && pyArgs[2]) {
                    errInfo = key_severity;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_severity);
            }
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[3]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QOpenGLDebugMessage::Severity cppArg2 = QOpenGLDebugMessage::Severity::NotificationSeverity;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QOpenGLDebugMessage::Type cppArg3 = QOpenGLDebugMessage::Type::OtherType;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // createApplicationMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
            QOpenGLDebugMessage cppResult = ::QOpenGLDebugMessage::createApplicationMessage(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLDebugMessageFunc_createApplicationMessage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugMessage.createThirdPartyMessage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:createThirdPartyMessage", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLDebugMessage::createThirdPartyMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createThirdPartyMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // createThirdPartyMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // createThirdPartyMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 0; // createThirdPartyMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_id = Shiboken::String::createStaticString("id");
            if (PyDict_Contains(kwds, key_id)) {
                value = PyDict_GetItem(kwds, key_id);
                if (value && pyArgs[1]) {
                    errInfo = key_id;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1]))))
                        goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_id);
            }
            static PyObject *const key_severity = Shiboken::String::createStaticString("severity");
            if (PyDict_Contains(kwds, key_severity)) {
                value = PyDict_GetItem(kwds, key_severity);
                if (value && pyArgs[2]) {
                    errInfo = key_severity;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_severity);
            }
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[3]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QOpenGLDebugMessage::Severity cppArg2 = QOpenGLDebugMessage::Severity::NotificationSeverity;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QOpenGLDebugMessage::Type cppArg3 = QOpenGLDebugMessage::Type::OtherType;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // createThirdPartyMessage(QString,uint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
            QOpenGLDebugMessage cppResult = ::QOpenGLDebugMessage::createThirdPartyMessage(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLDebugMessageFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugMessage.id";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // id()const
            unsigned int cppResult = const_cast<const ::QOpenGLDebugMessage *>(cppSelf)->id();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugMessageFunc_message(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugMessage.message";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // message()const
            QString cppResult = const_cast<const ::QOpenGLDebugMessage *>(cppSelf)->message();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugMessageFunc_severity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugMessage.severity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // severity()const
            QOpenGLDebugMessage::Severity cppResult = const_cast<const ::QOpenGLDebugMessage *>(cppSelf)->severity();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugMessageFunc_source(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugMessage.source";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // source()const
            QOpenGLDebugMessage::Source cppResult = const_cast<const ::QOpenGLDebugMessage *>(cppSelf)->source();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugMessageFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugMessage.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLDebugMessage::swap(QOpenGLDebugMessage&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QOpenGLDebugMessage&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugMessageFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QOpenGLDebugMessage cppArg0_local;
        ::QOpenGLDebugMessage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QOpenGLDebugMessage&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLDebugMessageFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLDebugMessageFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugMessage.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QOpenGLDebugMessage::Type cppResult = const_cast<const ::QOpenGLDebugMessage *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugMessage___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QOpenGLDebugMessage_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLDebugMessage_methods[] = {
    {"createApplicationMessage", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugMessageFunc_createApplicationMessage), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"createThirdPartyMessage", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugMessageFunc_createThirdPartyMessage), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"id", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugMessageFunc_id), METH_NOARGS},
    {"message", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugMessageFunc_message), METH_NOARGS},
    {"severity", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugMessageFunc_severity), METH_NOARGS},
    {"source", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugMessageFunc_source), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugMessageFunc_swap), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugMessageFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugMessage___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QOpenGLDebugMessage_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), (pyArg)))) {
                // operator!=(const QOpenGLDebugMessage & debugMessage) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QOpenGLDebugMessage cppArg0_local;
                ::QOpenGLDebugMessage *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), (pyArg)))) {
                // operator==(const QOpenGLDebugMessage & debugMessage) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QOpenGLDebugMessage cppArg0_local;
                ::QOpenGLDebugMessage *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QOpenGLDebugMessage_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QOpenGLDebugMessage_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QOpenGLDebugMessage_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLDebugMessage_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QOpenGLDebugMessage__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLDebugMessage_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLDebugMessage_TypeF(void)
{
    return _Sbk_QOpenGLDebugMessage_Type;
}

static PyType_Slot Sbk_QOpenGLDebugMessage_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QOpenGLDebugMessage__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLDebugMessage_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLDebugMessage_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QOpenGLDebugMessage_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLDebugMessage_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLDebugMessage_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLDebugMessage_spec = {
    "2:PySide2.QtGui.QOpenGLDebugMessage",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLDebugMessage_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Source___and__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Sources cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLDebugMessage::Sources>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Sources>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLDebugMessage::Sources>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Sources>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Source___or__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Sources cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLDebugMessage::Sources>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Sources>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLDebugMessage::Sources>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Sources>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Source___xor__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Sources cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLDebugMessage::Sources>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Sources>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLDebugMessage::Sources>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Sources>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Source___invert__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Sources cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, self, &cppSelf);
    ::QOpenGLDebugMessage::Sources cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Source_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QOpenGLDebugMessage_Source__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QOpenGLDebugMessage_Source_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Source_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Type___and__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Types cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLDebugMessage::Types>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Types>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLDebugMessage::Types>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Types>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Type___or__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Types cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLDebugMessage::Types>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Types>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLDebugMessage::Types>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Types>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Type___xor__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Types cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLDebugMessage::Types>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Types>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLDebugMessage::Types>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Types>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Type___invert__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Types cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, self, &cppSelf);
    ::QOpenGLDebugMessage::Types cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Type_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QOpenGLDebugMessage_Type__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QOpenGLDebugMessage_Type_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Type_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Severity___and__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Severities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLDebugMessage::Severities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Severities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLDebugMessage::Severities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Severities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Severity___or__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Severities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLDebugMessage::Severities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Severities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLDebugMessage::Severities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Severities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Severity___xor__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Severities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLDebugMessage::Severities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Severities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLDebugMessage::Severities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLDebugMessage::Severities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Severity___invert__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLDebugMessage::Severities cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, self, &cppSelf);
    ::QOpenGLDebugMessage::Severities cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QOpenGLDebugMessage_Severity_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QOpenGLDebugMessage_Severity__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QOpenGLDebugMessage_Severity_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLDebugMessage_Severity_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QOpenGLDebugMessage_Source_PythonToCpp_QOpenGLDebugMessage_Source(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLDebugMessage::Source *>(cppOut) =
        static_cast<::QOpenGLDebugMessage::Source>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLDebugMessage_Source_PythonToCpp_QOpenGLDebugMessage_Source_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX]))
        return QOpenGLDebugMessage_Source_PythonToCpp_QOpenGLDebugMessage_Source;
    return {};
}
static PyObject *QOpenGLDebugMessage_Source_CppToPython_QOpenGLDebugMessage_Source(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLDebugMessage::Source *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX], castCppIn);

}

static void QFlags_QOpenGLDebugMessage_Source__PythonToCpp_QFlags_QOpenGLDebugMessage_Source_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLDebugMessage::Source> *>(cppOut) =
        ::QFlags<QOpenGLDebugMessage::Source>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QOpenGLDebugMessage_Source__PythonToCpp_QFlags_QOpenGLDebugMessage_Source__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX]))
        return QFlags_QOpenGLDebugMessage_Source__PythonToCpp_QFlags_QOpenGLDebugMessage_Source_;
    return {};
}
static PyObject *QFlags_QOpenGLDebugMessage_Source__CppToPython_QFlags_QOpenGLDebugMessage_Source_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QOpenGLDebugMessage::Source> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX]));

}

static void QOpenGLDebugMessage_Source_PythonToCpp_QFlags_QOpenGLDebugMessage_Source_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLDebugMessage::Source> *>(cppOut) =
        ::QFlags<QOpenGLDebugMessage::Source>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QOpenGLDebugMessage_Source_PythonToCpp_QFlags_QOpenGLDebugMessage_Source__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX]))
        return QOpenGLDebugMessage_Source_PythonToCpp_QFlags_QOpenGLDebugMessage_Source_;
    return {};
}
static void number_PythonToCpp_QFlags_QOpenGLDebugMessage_Source_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QOpenGLDebugMessage::Source> *>(cppOut) =
        ::QFlags<QOpenGLDebugMessage::Source>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QOpenGLDebugMessage_Source__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX]))
        return number_PythonToCpp_QFlags_QOpenGLDebugMessage_Source_;
    return {};
}
static void QOpenGLDebugMessage_Type_PythonToCpp_QOpenGLDebugMessage_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLDebugMessage::Type *>(cppOut) =
        static_cast<::QOpenGLDebugMessage::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLDebugMessage_Type_PythonToCpp_QOpenGLDebugMessage_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX]))
        return QOpenGLDebugMessage_Type_PythonToCpp_QOpenGLDebugMessage_Type;
    return {};
}
static PyObject *QOpenGLDebugMessage_Type_CppToPython_QOpenGLDebugMessage_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLDebugMessage::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX], castCppIn);

}

static void QFlags_QOpenGLDebugMessage_Type__PythonToCpp_QFlags_QOpenGLDebugMessage_Type_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLDebugMessage::Type> *>(cppOut) =
        ::QFlags<QOpenGLDebugMessage::Type>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QOpenGLDebugMessage_Type__PythonToCpp_QFlags_QOpenGLDebugMessage_Type__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX]))
        return QFlags_QOpenGLDebugMessage_Type__PythonToCpp_QFlags_QOpenGLDebugMessage_Type_;
    return {};
}
static PyObject *QFlags_QOpenGLDebugMessage_Type__CppToPython_QFlags_QOpenGLDebugMessage_Type_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QOpenGLDebugMessage::Type> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX]));

}

static void QOpenGLDebugMessage_Type_PythonToCpp_QFlags_QOpenGLDebugMessage_Type_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLDebugMessage::Type> *>(cppOut) =
        ::QFlags<QOpenGLDebugMessage::Type>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QOpenGLDebugMessage_Type_PythonToCpp_QFlags_QOpenGLDebugMessage_Type__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX]))
        return QOpenGLDebugMessage_Type_PythonToCpp_QFlags_QOpenGLDebugMessage_Type_;
    return {};
}
static void number_PythonToCpp_QFlags_QOpenGLDebugMessage_Type_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QOpenGLDebugMessage::Type> *>(cppOut) =
        ::QFlags<QOpenGLDebugMessage::Type>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QOpenGLDebugMessage_Type__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX]))
        return number_PythonToCpp_QFlags_QOpenGLDebugMessage_Type_;
    return {};
}
static void QOpenGLDebugMessage_Severity_PythonToCpp_QOpenGLDebugMessage_Severity(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLDebugMessage::Severity *>(cppOut) =
        static_cast<::QOpenGLDebugMessage::Severity>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLDebugMessage_Severity_PythonToCpp_QOpenGLDebugMessage_Severity_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX]))
        return QOpenGLDebugMessage_Severity_PythonToCpp_QOpenGLDebugMessage_Severity;
    return {};
}
static PyObject *QOpenGLDebugMessage_Severity_CppToPython_QOpenGLDebugMessage_Severity(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLDebugMessage::Severity *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX], castCppIn);

}

static void QFlags_QOpenGLDebugMessage_Severity__PythonToCpp_QFlags_QOpenGLDebugMessage_Severity_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLDebugMessage::Severity> *>(cppOut) =
        ::QFlags<QOpenGLDebugMessage::Severity>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QOpenGLDebugMessage_Severity__PythonToCpp_QFlags_QOpenGLDebugMessage_Severity__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX]))
        return QFlags_QOpenGLDebugMessage_Severity__PythonToCpp_QFlags_QOpenGLDebugMessage_Severity_;
    return {};
}
static PyObject *QFlags_QOpenGLDebugMessage_Severity__CppToPython_QFlags_QOpenGLDebugMessage_Severity_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QOpenGLDebugMessage::Severity> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX]));

}

static void QOpenGLDebugMessage_Severity_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLDebugMessage::Severity> *>(cppOut) =
        ::QFlags<QOpenGLDebugMessage::Severity>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QOpenGLDebugMessage_Severity_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX]))
        return QOpenGLDebugMessage_Severity_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity_;
    return {};
}
static void number_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QOpenGLDebugMessage::Severity> *>(cppOut) =
        ::QFlags<QOpenGLDebugMessage::Severity>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX]))
        return number_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLDebugMessage_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLDebugMessage_TypeF())))
        return QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLDebugMessage_PTR_CppToPython_QOpenGLDebugMessage(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLDebugMessage *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLDebugMessage_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QOpenGLDebugMessage_COPY_CppToPython_QOpenGLDebugMessage(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QOpenGLDebugMessage_TypeF(), new ::QOpenGLDebugMessage(*reinterpret_cast<const ::QOpenGLDebugMessage *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLDebugMessage *>(cppOut) = *reinterpret_cast< ::QOpenGLDebugMessage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLDebugMessage_TypeF())))
        return QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLDebugMessage_SignatureStrings[] = {
    "1:PySide2.QtGui.QOpenGLDebugMessage(self)",
    "0:PySide2.QtGui.QOpenGLDebugMessage(self,debugMessage:PySide2.QtGui.QOpenGLDebugMessage)",
    "PySide2.QtGui.QOpenGLDebugMessage.createApplicationMessage(text:QString,id:unsigned int=0,severity:PySide2.QtGui.QOpenGLDebugMessage.Severity=NotificationSeverity,type:PySide2.QtGui.QOpenGLDebugMessage.Type=OtherType)->PySide2.QtGui.QOpenGLDebugMessage",
    "PySide2.QtGui.QOpenGLDebugMessage.createThirdPartyMessage(text:QString,id:unsigned int=0,severity:PySide2.QtGui.QOpenGLDebugMessage.Severity=NotificationSeverity,type:PySide2.QtGui.QOpenGLDebugMessage.Type=OtherType)->PySide2.QtGui.QOpenGLDebugMessage",
    "PySide2.QtGui.QOpenGLDebugMessage.id(self)->unsigned int",
    "PySide2.QtGui.QOpenGLDebugMessage.message(self)->QString",
    "PySide2.QtGui.QOpenGLDebugMessage.severity(self)->PySide2.QtGui.QOpenGLDebugMessage.Severity",
    "PySide2.QtGui.QOpenGLDebugMessage.source(self)->PySide2.QtGui.QOpenGLDebugMessage.Source",
    "PySide2.QtGui.QOpenGLDebugMessage.swap(self,other:PySide2.QtGui.QOpenGLDebugMessage)",
    "PySide2.QtGui.QOpenGLDebugMessage.type(self)->PySide2.QtGui.QOpenGLDebugMessage.Type",
    "PySide2.QtGui.QOpenGLDebugMessage.__copy__()",
    nullptr}; // Sentinel

void init_QOpenGLDebugMessage(PyObject *module)
{
    _Sbk_QOpenGLDebugMessage_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLDebugMessage",
        "QOpenGLDebugMessage",
        &Sbk_QOpenGLDebugMessage_spec,
        &Shiboken::callCppDestructor< ::QOpenGLDebugMessage >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLDebugMessage_Type);
    InitSignatureStrings(pyType, QOpenGLDebugMessage_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLDebugMessage_Type), Sbk_QOpenGLDebugMessage_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLDebugMessage_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLDebugMessage_TypeF(),
        QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_PTR,
        is_QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_PTR_Convertible,
        QOpenGLDebugMessage_PTR_CppToPython_QOpenGLDebugMessage,
        QOpenGLDebugMessage_COPY_CppToPython_QOpenGLDebugMessage);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugMessage");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugMessage*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugMessage&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLDebugMessage).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_COPY,
        is_QOpenGLDebugMessage_PythonToCpp_QOpenGLDebugMessage_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Source'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QOpenGLDebugMessage.Sources", SbkPySide2_QtGui_QOpenGLDebugMessage_Source_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLDebugMessage_TypeF(),
        "Source",
        "2:PySide2.QtGui.QOpenGLDebugMessage.Source",
        "QOpenGLDebugMessage::Source",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "InvalidSource", (long) QOpenGLDebugMessage::Source::InvalidSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "APISource", (long) QOpenGLDebugMessage::Source::APISource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "WindowSystemSource", (long) QOpenGLDebugMessage::Source::WindowSystemSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "ShaderCompilerSource", (long) QOpenGLDebugMessage::Source::ShaderCompilerSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "ThirdPartySource", (long) QOpenGLDebugMessage::Source::ThirdPartySource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "ApplicationSource", (long) QOpenGLDebugMessage::Source::ApplicationSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "OtherSource", (long) QOpenGLDebugMessage::Source::OtherSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "LastSource", (long) QOpenGLDebugMessage::Source::LastSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "AnySource", (long) QOpenGLDebugMessage::Source::AnySource))
        return;
    // Register converter for enum 'QOpenGLDebugMessage::Source'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
            QOpenGLDebugMessage_Source_CppToPython_QOpenGLDebugMessage_Source);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLDebugMessage_Source_PythonToCpp_QOpenGLDebugMessage_Source,
            is_QOpenGLDebugMessage_Source_PythonToCpp_QOpenGLDebugMessage_Source_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugMessage::Source");
        Shiboken::Conversions::registerConverterName(converter, "Source");
    }
    // Register converter for flag 'QFlags<QOpenGLDebugMessage::Source>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX],
            QFlags_QOpenGLDebugMessage_Source__CppToPython_QFlags_QOpenGLDebugMessage_Source_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLDebugMessage_Source_PythonToCpp_QFlags_QOpenGLDebugMessage_Source_,
            is_QOpenGLDebugMessage_Source_PythonToCpp_QFlags_QOpenGLDebugMessage_Source__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QOpenGLDebugMessage_Source__PythonToCpp_QFlags_QOpenGLDebugMessage_Source_,
            is_QFlags_QOpenGLDebugMessage_Source__PythonToCpp_QFlags_QOpenGLDebugMessage_Source__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QOpenGLDebugMessage_Source_,
            is_number_PythonToCpp_QFlags_QOpenGLDebugMessage_Source__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugMessage::Sources");
        Shiboken::Conversions::registerConverterName(converter, "Sources");
    }
    // End of 'Source' enum/flags.

    // Initialization of enum 'Type'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QOpenGLDebugMessage.Types", SbkPySide2_QtGui_QOpenGLDebugMessage_Type_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLDebugMessage_TypeF(),
        "Type",
        "2:PySide2.QtGui.QOpenGLDebugMessage.Type",
        "QOpenGLDebugMessage::Type",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "InvalidType", (long) QOpenGLDebugMessage::Type::InvalidType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "ErrorType", (long) QOpenGLDebugMessage::Type::ErrorType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "DeprecatedBehaviorType", (long) QOpenGLDebugMessage::Type::DeprecatedBehaviorType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "UndefinedBehaviorType", (long) QOpenGLDebugMessage::Type::UndefinedBehaviorType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "PortabilityType", (long) QOpenGLDebugMessage::Type::PortabilityType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "PerformanceType", (long) QOpenGLDebugMessage::Type::PerformanceType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "OtherType", (long) QOpenGLDebugMessage::Type::OtherType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "MarkerType", (long) QOpenGLDebugMessage::Type::MarkerType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "GroupPushType", (long) QOpenGLDebugMessage::Type::GroupPushType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "GroupPopType", (long) QOpenGLDebugMessage::Type::GroupPopType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "LastType", (long) QOpenGLDebugMessage::Type::LastType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "AnyType", (long) QOpenGLDebugMessage::Type::AnyType))
        return;
    // Register converter for enum 'QOpenGLDebugMessage::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX],
            QOpenGLDebugMessage_Type_CppToPython_QOpenGLDebugMessage_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLDebugMessage_Type_PythonToCpp_QOpenGLDebugMessage_Type,
            is_QOpenGLDebugMessage_Type_PythonToCpp_QOpenGLDebugMessage_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugMessage::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // Register converter for flag 'QFlags<QOpenGLDebugMessage::Type>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX],
            QFlags_QOpenGLDebugMessage_Type__CppToPython_QFlags_QOpenGLDebugMessage_Type_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLDebugMessage_Type_PythonToCpp_QFlags_QOpenGLDebugMessage_Type_,
            is_QOpenGLDebugMessage_Type_PythonToCpp_QFlags_QOpenGLDebugMessage_Type__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QOpenGLDebugMessage_Type__PythonToCpp_QFlags_QOpenGLDebugMessage_Type_,
            is_QFlags_QOpenGLDebugMessage_Type__PythonToCpp_QFlags_QOpenGLDebugMessage_Type__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QOpenGLDebugMessage_Type_,
            is_number_PythonToCpp_QFlags_QOpenGLDebugMessage_Type__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugMessage::Types");
        Shiboken::Conversions::registerConverterName(converter, "Types");
    }
    // End of 'Type' enum/flags.

    // Initialization of enum 'Severity'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QOpenGLDebugMessage.Severities", SbkPySide2_QtGui_QOpenGLDebugMessage_Severity_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLDebugMessage_TypeF(),
        "Severity",
        "2:PySide2.QtGui.QOpenGLDebugMessage.Severity",
        "QOpenGLDebugMessage::Severity",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "InvalidSeverity", (long) QOpenGLDebugMessage::Severity::InvalidSeverity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "HighSeverity", (long) QOpenGLDebugMessage::Severity::HighSeverity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "MediumSeverity", (long) QOpenGLDebugMessage::Severity::MediumSeverity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "LowSeverity", (long) QOpenGLDebugMessage::Severity::LowSeverity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "NotificationSeverity", (long) QOpenGLDebugMessage::Severity::NotificationSeverity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "LastSeverity", (long) QOpenGLDebugMessage::Severity::LastSeverity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX],
        Sbk_QOpenGLDebugMessage_TypeF(), "AnySeverity", (long) QOpenGLDebugMessage::Severity::AnySeverity))
        return;
    // Register converter for enum 'QOpenGLDebugMessage::Severity'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX],
            QOpenGLDebugMessage_Severity_CppToPython_QOpenGLDebugMessage_Severity);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLDebugMessage_Severity_PythonToCpp_QOpenGLDebugMessage_Severity,
            is_QOpenGLDebugMessage_Severity_PythonToCpp_QOpenGLDebugMessage_Severity_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SEVERITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugMessage::Severity");
        Shiboken::Conversions::registerConverterName(converter, "Severity");
    }
    // Register converter for flag 'QFlags<QOpenGLDebugMessage::Severity>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX],
            QFlags_QOpenGLDebugMessage_Severity__CppToPython_QFlags_QOpenGLDebugMessage_Severity_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLDebugMessage_Severity_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity_,
            is_QOpenGLDebugMessage_Severity_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QOpenGLDebugMessage_Severity__PythonToCpp_QFlags_QOpenGLDebugMessage_Severity_,
            is_QFlags_QOpenGLDebugMessage_Severity__PythonToCpp_QFlags_QOpenGLDebugMessage_Severity__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity_,
            is_number_PythonToCpp_QFlags_QOpenGLDebugMessage_Severity__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugMessage::Severities");
        Shiboken::Conversions::registerConverterName(converter, "Severities");
    }
    // End of 'Severity' enum/flags.

    qRegisterMetaType< ::QOpenGLDebugMessage >("QOpenGLDebugMessage");
    qRegisterMetaType< ::QOpenGLDebugMessage::Source >("QOpenGLDebugMessage::Source");
    qRegisterMetaType< ::QOpenGLDebugMessage::Sources >("QOpenGLDebugMessage::Sources");
    qRegisterMetaType< ::QOpenGLDebugMessage::Type >("QOpenGLDebugMessage::Type");
    qRegisterMetaType< ::QOpenGLDebugMessage::Types >("QOpenGLDebugMessage::Types");
    qRegisterMetaType< ::QOpenGLDebugMessage::Severity >("QOpenGLDebugMessage::Severity");
    qRegisterMetaType< ::QOpenGLDebugMessage::Severities >("QOpenGLDebugMessage::Severities");
}
