/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopenglbuffer_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qopenglbuffer.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLBuffer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLBuffer >()))
        return -1;

    ::QOpenGLBuffer *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QOpenGLBuffer", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLBuffer::QOpenGLBuffer()
    // 1: QOpenGLBuffer::QOpenGLBuffer(QOpenGLBuffer::Type)
    // 2: QOpenGLBuffer::QOpenGLBuffer(QOpenGLBuffer)
    if (numArgs == 0) {
        overloadId = 0; // QOpenGLBuffer()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QOpenGLBuffer(QOpenGLBuffer)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QOpenGLBuffer(QOpenGLBuffer::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLBuffer_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QOpenGLBuffer()
        {

            if (!PyErr_Occurred()) {
                // QOpenGLBuffer()
                cptr = new ::QOpenGLBuffer();
            }
            break;
        }
        case 1: // QOpenGLBuffer(QOpenGLBuffer::Type type)
        {
            ::QOpenGLBuffer::Type cppArg0 = static_cast< ::QOpenGLBuffer::Type>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QOpenGLBuffer(QOpenGLBuffer::Type)
                cptr = new ::QOpenGLBuffer(cppArg0);
            }
            break;
        }
        case 2: // QOpenGLBuffer(const QOpenGLBuffer & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QOpenGLBuffer *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QOpenGLBuffer(QOpenGLBuffer)
                cptr = new ::QOpenGLBuffer(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLBuffer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLBuffer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QOpenGLBuffer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLBufferFunc_allocate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.allocate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "allocate", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLBuffer::allocate(const void*,int)
    // 1: QOpenGLBuffer::allocate(int)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // allocate(int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // allocate(const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLBufferFunc_allocate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // allocate(const void * data, int count)
        {
            void* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // allocate(const void*,int)
                cppSelf->allocate(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // allocate(int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // allocate(int)
                cppSelf->allocate(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLBufferFunc_allocate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLBufferFunc_bind(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.bind";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bind()
            bool cppResult = cppSelf->bind();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLBufferFunc_bufferId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.bufferId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bufferId()const
            unsigned int cppResult = const_cast<const ::QOpenGLBuffer *>(cppSelf)->bufferId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLBufferFunc_create(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.create";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // create()
            bool cppResult = cppSelf->create();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLBufferFunc_destroy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.destroy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destroy()
            cppSelf->destroy();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLBufferFunc_isCreated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.isCreated";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCreated()const
            bool cppResult = const_cast<const ::QOpenGLBuffer *>(cppSelf)->isCreated();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLBufferFunc_map(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.map";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLBuffer::map(QOpenGLBuffer::Access)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // map(QOpenGLBuffer::Access)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLBufferFunc_map_TypeError;

    // Call function/method
    {
        ::QOpenGLBuffer::Access cppArg0 = static_cast< ::QOpenGLBuffer::Access>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // map(QOpenGLBuffer::Access)
            void * cppResult = cppSelf->map(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLBufferFunc_map_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLBufferFunc_mapRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.mapRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mapRange", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLBuffer::mapRange(int,int,QFlags<QOpenGLBuffer::RangeAccessFlag>)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // mapRange(int,int,QFlags<QOpenGLBuffer::RangeAccessFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLBufferFunc_mapRange_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<QOpenGLBuffer::RangeAccessFlag> cppArg2 = QFlags<QOpenGLBuffer::RangeAccessFlag>(0);
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // mapRange(int,int,QFlags<QOpenGLBuffer::RangeAccessFlag>)
            void * cppResult = cppSelf->mapRange(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLBufferFunc_mapRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLBufferFunc_read(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.read";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "read", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLBuffer::read(int,void*,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // read(int,void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLBufferFunc_read_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // read(int,void*,int)
            bool cppResult = cppSelf->read(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLBufferFunc_read_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLBufferFunc_release(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QOpenGLBuffer *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.release";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "release", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLBuffer::release()
    // 1: static QOpenGLBuffer::release(QOpenGLBuffer::Type)
    if (numArgs == 0) {
        overloadId = 0; // release()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // release(QOpenGLBuffer::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLBufferFunc_release_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // release()
        {

            if (!PyErr_Occurred()) {
                // release()
                cppSelf->release();
            }
            break;
        }
        case 1: // release(QOpenGLBuffer::Type type)
        {
            ::QOpenGLBuffer::Type cppArg0 = static_cast< ::QOpenGLBuffer::Type>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // release(QOpenGLBuffer::Type)
                ::QOpenGLBuffer::release(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLBufferFunc_release_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLBufferFunc_setUsagePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.setUsagePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLBuffer::setUsagePattern(QOpenGLBuffer::UsagePattern)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setUsagePattern(QOpenGLBuffer::UsagePattern)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLBufferFunc_setUsagePattern_TypeError;

    // Call function/method
    {
        ::QOpenGLBuffer::UsagePattern cppArg0 = static_cast< ::QOpenGLBuffer::UsagePattern>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUsagePattern(QOpenGLBuffer::UsagePattern)
            cppSelf->setUsagePattern(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLBufferFunc_setUsagePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLBufferFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QOpenGLBuffer *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLBufferFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QOpenGLBuffer::Type cppResult = const_cast<const ::QOpenGLBuffer *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLBufferFunc_unmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.unmap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unmap()
            bool cppResult = cppSelf->unmap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLBufferFunc_usagePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.usagePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // usagePattern()const
            QOpenGLBuffer::UsagePattern cppResult = const_cast<const ::QOpenGLBuffer *>(cppSelf)->usagePattern();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLBufferFunc_write(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLBuffer.write";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "write", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLBuffer::write(int,const void*,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // write(int,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLBufferFunc_write_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // write(int,const void*,int)
            cppSelf->write(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLBufferFunc_write_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyMethodDef Sbk_QOpenGLBufferMethod_release = {
    "release", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_release), METH_VARARGS|METH_STATIC
};


static const char *Sbk_QOpenGLBuffer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLBuffer_methods[] = {
    {"allocate", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_allocate), METH_VARARGS},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_bind), METH_NOARGS},
    {"bufferId", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_bufferId), METH_NOARGS},
    {"create", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_create), METH_NOARGS},
    {"destroy", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_destroy), METH_NOARGS},
    {"isCreated", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_isCreated), METH_NOARGS},
    {"map", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_map), METH_O},
    {"mapRange", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_mapRange), METH_VARARGS},
    {"read", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_read), METH_VARARGS},
    Sbk_QOpenGLBufferMethod_release,
    {"setUsagePattern", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_setUsagePattern), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_size), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_type), METH_NOARGS},
    {"unmap", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_unmap), METH_NOARGS},
    {"usagePattern", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_usagePattern), METH_NOARGS},
    {"write", reinterpret_cast<PyCFunction>(Sbk_QOpenGLBufferFunc_write), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QOpenGLBuffer_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PyObject_GenericGetAttr(self, name);
    }
    static PyMethodDef non_static_Sbk_QOpenGLBufferMethod_release = {
        Sbk_QOpenGLBufferMethod_release.ml_name,
        Sbk_QOpenGLBufferMethod_release.ml_meth,
        Sbk_QOpenGLBufferMethod_release.ml_flags & (~METH_STATIC),
        Sbk_QOpenGLBufferMethod_release.ml_doc,
    };
    if (Shiboken::String::compare(name, "release") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QOpenGLBufferMethod_release, self, 0);
    return PyObject_GenericGetAttr(self, name);
}

} // extern "C"

static int Sbk_QOpenGLBuffer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLBuffer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLBuffer_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLBuffer_TypeF(void)
{
    return _Sbk_QOpenGLBuffer_Type;
}

static PyType_Slot Sbk_QOpenGLBuffer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QOpenGLBuffer_getattro)},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLBuffer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLBuffer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLBuffer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLBuffer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLBuffer_spec = {
    "2:PySide2.QtGui.QOpenGLBuffer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLBuffer_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLBuffer::RangeAccessFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLBuffer::RangeAccessFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLBuffer::RangeAccessFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLBuffer::RangeAccessFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLBuffer::RangeAccessFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLBuffer::RangeAccessFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLBuffer::RangeAccessFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLBuffer::RangeAccessFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLBuffer::RangeAccessFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLBuffer::RangeAccessFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLBuffer::RangeAccessFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLBuffer::RangeAccessFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLBuffer::RangeAccessFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLBuffer::RangeAccessFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLBuffer::RangeAccessFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLBuffer::RangeAccessFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX])->converter, self, &cppSelf);
    ::QOpenGLBuffer::RangeAccessFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QOpenGLBuffer_Type_PythonToCpp_QOpenGLBuffer_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLBuffer::Type *>(cppOut) =
        static_cast<::QOpenGLBuffer::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLBuffer_Type_PythonToCpp_QOpenGLBuffer_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX]))
        return QOpenGLBuffer_Type_PythonToCpp_QOpenGLBuffer_Type;
    return {};
}
static PyObject *QOpenGLBuffer_Type_CppToPython_QOpenGLBuffer_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLBuffer::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX], castCppIn);

}

static void QOpenGLBuffer_UsagePattern_PythonToCpp_QOpenGLBuffer_UsagePattern(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLBuffer::UsagePattern *>(cppOut) =
        static_cast<::QOpenGLBuffer::UsagePattern>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLBuffer_UsagePattern_PythonToCpp_QOpenGLBuffer_UsagePattern_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX]))
        return QOpenGLBuffer_UsagePattern_PythonToCpp_QOpenGLBuffer_UsagePattern;
    return {};
}
static PyObject *QOpenGLBuffer_UsagePattern_CppToPython_QOpenGLBuffer_UsagePattern(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLBuffer::UsagePattern *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX], castCppIn);

}

static void QOpenGLBuffer_Access_PythonToCpp_QOpenGLBuffer_Access(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLBuffer::Access *>(cppOut) =
        static_cast<::QOpenGLBuffer::Access>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLBuffer_Access_PythonToCpp_QOpenGLBuffer_Access_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX]))
        return QOpenGLBuffer_Access_PythonToCpp_QOpenGLBuffer_Access;
    return {};
}
static PyObject *QOpenGLBuffer_Access_CppToPython_QOpenGLBuffer_Access(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLBuffer::Access *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX], castCppIn);

}

static void QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QOpenGLBuffer_RangeAccessFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLBuffer::RangeAccessFlag *>(cppOut) =
        static_cast<::QOpenGLBuffer::RangeAccessFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QOpenGLBuffer_RangeAccessFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX]))
        return QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QOpenGLBuffer_RangeAccessFlag;
    return {};
}
static PyObject *QOpenGLBuffer_RangeAccessFlag_CppToPython_QOpenGLBuffer_RangeAccessFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLBuffer::RangeAccessFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX], castCppIn);

}

static void QFlags_QOpenGLBuffer_RangeAccessFlag__PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLBuffer::RangeAccessFlag> *>(cppOut) =
        ::QFlags<QOpenGLBuffer::RangeAccessFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QOpenGLBuffer_RangeAccessFlag__PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX]))
        return QFlags_QOpenGLBuffer_RangeAccessFlag__PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag_;
    return {};
}
static PyObject *QFlags_QOpenGLBuffer_RangeAccessFlag__CppToPython_QFlags_QOpenGLBuffer_RangeAccessFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QOpenGLBuffer::RangeAccessFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX]));

}

static void QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLBuffer::RangeAccessFlag> *>(cppOut) =
        ::QFlags<QOpenGLBuffer::RangeAccessFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX]))
        return QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QOpenGLBuffer::RangeAccessFlag> *>(cppOut) =
        ::QFlags<QOpenGLBuffer::RangeAccessFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX]))
        return number_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLBuffer_PythonToCpp_QOpenGLBuffer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLBuffer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLBuffer_PythonToCpp_QOpenGLBuffer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLBuffer_TypeF())))
        return QOpenGLBuffer_PythonToCpp_QOpenGLBuffer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLBuffer_PTR_CppToPython_QOpenGLBuffer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLBuffer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLBuffer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLBuffer_SignatureStrings[] = {
    "2:PySide2.QtGui.QOpenGLBuffer(self)",
    "1:PySide2.QtGui.QOpenGLBuffer(self,type:PySide2.QtGui.QOpenGLBuffer.Type)",
    "0:PySide2.QtGui.QOpenGLBuffer(self,other:PySide2.QtGui.QOpenGLBuffer)",
    "1:PySide2.QtGui.QOpenGLBuffer.allocate(self,data:void,count:int)",
    "0:PySide2.QtGui.QOpenGLBuffer.allocate(self,count:int)",
    "PySide2.QtGui.QOpenGLBuffer.bind(self)->bool",
    "PySide2.QtGui.QOpenGLBuffer.bufferId(self)->unsigned int",
    "PySide2.QtGui.QOpenGLBuffer.create(self)->bool",
    "PySide2.QtGui.QOpenGLBuffer.destroy(self)",
    "PySide2.QtGui.QOpenGLBuffer.isCreated(self)->bool",
    "PySide2.QtGui.QOpenGLBuffer.map(self,access:PySide2.QtGui.QOpenGLBuffer.Access)->void",
    "PySide2.QtGui.QOpenGLBuffer.mapRange(self,offset:int,count:int,access:PySide2.QtGui.QOpenGLBuffer.RangeAccessFlags)->void",
    "PySide2.QtGui.QOpenGLBuffer.read(self,offset:int,data:void,count:int)->bool",
    "1:PySide2.QtGui.QOpenGLBuffer.release(self)",
    "0:PySide2.QtGui.QOpenGLBuffer.release(type:PySide2.QtGui.QOpenGLBuffer.Type)",
    "PySide2.QtGui.QOpenGLBuffer.setUsagePattern(self,value:PySide2.QtGui.QOpenGLBuffer.UsagePattern)",
    "PySide2.QtGui.QOpenGLBuffer.size(self)->int",
    "PySide2.QtGui.QOpenGLBuffer.type(self)->PySide2.QtGui.QOpenGLBuffer.Type",
    "PySide2.QtGui.QOpenGLBuffer.unmap(self)->bool",
    "PySide2.QtGui.QOpenGLBuffer.usagePattern(self)->PySide2.QtGui.QOpenGLBuffer.UsagePattern",
    "PySide2.QtGui.QOpenGLBuffer.write(self,offset:int,data:void,count:int)",
    nullptr}; // Sentinel

void init_QOpenGLBuffer(PyObject *module)
{
    _Sbk_QOpenGLBuffer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLBuffer",
        "QOpenGLBuffer*",
        &Sbk_QOpenGLBuffer_spec,
        &Shiboken::callCppDestructor< ::QOpenGLBuffer >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLBuffer_Type);
    InitSignatureStrings(pyType, QOpenGLBuffer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLBuffer_Type), Sbk_QOpenGLBuffer_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLBuffer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLBuffer_TypeF(),
        QOpenGLBuffer_PythonToCpp_QOpenGLBuffer_PTR,
        is_QOpenGLBuffer_PythonToCpp_QOpenGLBuffer_PTR_Convertible,
        QOpenGLBuffer_PTR_CppToPython_QOpenGLBuffer);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLBuffer");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLBuffer*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLBuffer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLBuffer).name());


    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLBuffer_TypeF(),
        "Type",
        "2:PySide2.QtGui.QOpenGLBuffer.Type",
        "QOpenGLBuffer::Type");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "VertexBuffer", (long) QOpenGLBuffer::Type::VertexBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "IndexBuffer", (long) QOpenGLBuffer::Type::IndexBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "PixelPackBuffer", (long) QOpenGLBuffer::Type::PixelPackBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "PixelUnpackBuffer", (long) QOpenGLBuffer::Type::PixelUnpackBuffer))
        return;
    // Register converter for enum 'QOpenGLBuffer::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX],
            QOpenGLBuffer_Type_CppToPython_QOpenGLBuffer_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLBuffer_Type_PythonToCpp_QOpenGLBuffer_Type,
            is_QOpenGLBuffer_Type_PythonToCpp_QOpenGLBuffer_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLBuffer::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    // Initialization of enum 'UsagePattern'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLBuffer_TypeF(),
        "UsagePattern",
        "2:PySide2.QtGui.QOpenGLBuffer.UsagePattern",
        "QOpenGLBuffer::UsagePattern");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "StreamDraw", (long) QOpenGLBuffer::UsagePattern::StreamDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "StreamRead", (long) QOpenGLBuffer::UsagePattern::StreamRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "StreamCopy", (long) QOpenGLBuffer::UsagePattern::StreamCopy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "StaticDraw", (long) QOpenGLBuffer::UsagePattern::StaticDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "StaticRead", (long) QOpenGLBuffer::UsagePattern::StaticRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "StaticCopy", (long) QOpenGLBuffer::UsagePattern::StaticCopy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "DynamicDraw", (long) QOpenGLBuffer::UsagePattern::DynamicDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "DynamicRead", (long) QOpenGLBuffer::UsagePattern::DynamicRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "DynamicCopy", (long) QOpenGLBuffer::UsagePattern::DynamicCopy))
        return;
    // Register converter for enum 'QOpenGLBuffer::UsagePattern'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX],
            QOpenGLBuffer_UsagePattern_CppToPython_QOpenGLBuffer_UsagePattern);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLBuffer_UsagePattern_PythonToCpp_QOpenGLBuffer_UsagePattern,
            is_QOpenGLBuffer_UsagePattern_PythonToCpp_QOpenGLBuffer_UsagePattern_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_USAGEPATTERN_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLBuffer::UsagePattern");
        Shiboken::Conversions::registerConverterName(converter, "UsagePattern");
    }
    // End of 'UsagePattern' enum.

    // Initialization of enum 'Access'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLBuffer_TypeF(),
        "Access",
        "2:PySide2.QtGui.QOpenGLBuffer.Access",
        "QOpenGLBuffer::Access");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "ReadOnly", (long) QOpenGLBuffer::Access::ReadOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "WriteOnly", (long) QOpenGLBuffer::Access::WriteOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "ReadWrite", (long) QOpenGLBuffer::Access::ReadWrite))
        return;
    // Register converter for enum 'QOpenGLBuffer::Access'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX],
            QOpenGLBuffer_Access_CppToPython_QOpenGLBuffer_Access);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLBuffer_Access_PythonToCpp_QOpenGLBuffer_Access,
            is_QOpenGLBuffer_Access_PythonToCpp_QOpenGLBuffer_Access_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_ACCESS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLBuffer::Access");
        Shiboken::Conversions::registerConverterName(converter, "Access");
    }
    // End of 'Access' enum.

    // Initialization of enum 'RangeAccessFlag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QOpenGLBuffer.RangeAccessFlags", SbkPySide2_QtGui_QOpenGLBuffer_RangeAccessFlag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLBuffer_TypeF(),
        "RangeAccessFlag",
        "2:PySide2.QtGui.QOpenGLBuffer.RangeAccessFlag",
        "QOpenGLBuffer::RangeAccessFlag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "RangeRead", (long) QOpenGLBuffer::RangeAccessFlag::RangeRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "RangeWrite", (long) QOpenGLBuffer::RangeAccessFlag::RangeWrite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "RangeInvalidate", (long) QOpenGLBuffer::RangeAccessFlag::RangeInvalidate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "RangeInvalidateBuffer", (long) QOpenGLBuffer::RangeAccessFlag::RangeInvalidateBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "RangeFlushExplicit", (long) QOpenGLBuffer::RangeAccessFlag::RangeFlushExplicit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX],
        Sbk_QOpenGLBuffer_TypeF(), "RangeUnsynchronized", (long) QOpenGLBuffer::RangeAccessFlag::RangeUnsynchronized))
        return;
    // Register converter for enum 'QOpenGLBuffer::RangeAccessFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX],
            QOpenGLBuffer_RangeAccessFlag_CppToPython_QOpenGLBuffer_RangeAccessFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QOpenGLBuffer_RangeAccessFlag,
            is_QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QOpenGLBuffer_RangeAccessFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLBUFFER_RANGEACCESSFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLBuffer::RangeAccessFlag");
        Shiboken::Conversions::registerConverterName(converter, "RangeAccessFlag");
    }
    // Register converter for flag 'QFlags<QOpenGLBuffer::RangeAccessFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX],
            QFlags_QOpenGLBuffer_RangeAccessFlag__CppToPython_QFlags_QOpenGLBuffer_RangeAccessFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag_,
            is_QOpenGLBuffer_RangeAccessFlag_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QOpenGLBuffer_RangeAccessFlag__PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag_,
            is_QFlags_QOpenGLBuffer_RangeAccessFlag__PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag_,
            is_number_PythonToCpp_QFlags_QOpenGLBuffer_RangeAccessFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLBUFFER_RANGEACCESSFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLBuffer::RangeAccessFlags");
        Shiboken::Conversions::registerConverterName(converter, "RangeAccessFlags");
    }
    // End of 'RangeAccessFlag' enum/flags.

    qRegisterMetaType< ::QOpenGLBuffer::Type >("QOpenGLBuffer::Type");
    qRegisterMetaType< ::QOpenGLBuffer::UsagePattern >("QOpenGLBuffer::UsagePattern");
    qRegisterMetaType< ::QOpenGLBuffer::Access >("QOpenGLBuffer::Access");
    qRegisterMetaType< ::QOpenGLBuffer::RangeAccessFlag >("QOpenGLBuffer::RangeAccessFlag");
    qRegisterMetaType< ::QOpenGLBuffer::RangeAccessFlags >("QOpenGLBuffer::RangeAccessFlags");
}
