/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qmatrix4x2_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qgenericmatrix.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMatrix4x2_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMatrix4x2 >()))
        return -1;

    ::QMatrix4x2 *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMatrix4x2", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMatrix4x2::QMatrix4x2()
    // 1: QMatrix4x2::QMatrix4x2(PySequence*)
    // 2: QMatrix4x2::QMatrix4x2(QMatrix4x2)
    if (numArgs == 0) {
        overloadId = 0; // QMatrix4x2()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QMatrix4x2(QMatrix4x2)
    } else if (numArgs == 1
        && Shiboken::String::checkIterable(pyArgs[0])) {
        overloadId = 1; // QMatrix4x2(PySequence*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x2_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMatrix4x2()
        {

            if (!PyErr_Occurred()) {
                // QMatrix4x2()
                cptr = new ::QMatrix4x2();
            }
            break;
        }
        case 1: // QMatrix4x2(PySequence * arg__1)
        {

            if (!PyErr_Occurred()) {
                // QMatrix4x2(PySequence*)
                // Begin code injection
                // TEMPLATE - matrix_constructor - START
                // PYSIDE-795: All PySequences can be made iterable with PySequence_Fast.
                Shiboken::AutoDecRef seq(PySequence_Fast(pyArgs[1-1], "Can't turn into sequence"));
                if (PySequence_Size(seq) == 8) {
                    Shiboken::AutoDecRef fast(PySequence_Fast(seq,
                        "Failed to parse sequence on QMatrix4x2 constructor."));
                    float values[8];
                    for(int i=0; i < 8; i++) {
                        PyObject *pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pv, &(values[i]));
                    }
                    cptr = new QMatrix4x2(values);
                }
                // TEMPLATE - matrix_constructor - END

                // End of code injection

            }
            break;
        }
        case 2: // QMatrix4x2(const QMatrix4x2 & QMatrix4x2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMatrix4x2 cppArg0_local;
            ::QMatrix4x2 *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMatrix4x2(QMatrix4x2)
                cptr = new ::QMatrix4x2(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMatrix4x2 >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMatrix4x2_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMatrix4x2_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMatrix4x2Func___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code_matrix - START
            QList< float > cppArgs;
            float data[8];
            cppSelf->copyDataTo(data);
            int matrixSize = 8;
            for(int size=0; size < matrixSize; size++)
                cppArgs.append(data[size]);

            PyObject *type = PyObject_Type(self);
            PyObject *args = Py_BuildValue("(N)",
                Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_FLOAT_IDX], &cppArgs));
            pyResult = Py_BuildValue("(NN)", type, args);
            // TEMPLATE - reduce_code_matrix - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x2Func___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code_matrix - START
            QByteArray format(Py_TYPE(self)->tp_name);
            format += QByteArray("((");

            QList< float > cppArgs;
            float data[8];
            cppSelf->copyDataTo(data);
            int matrixSize = 8;
            for(int size=0; size < matrixSize; size++) {
                if (size > 0)
                    format += ", ";
                format += QByteArray::number(data[size]);
            }
            format += "))";

            pyResult = Shiboken::String::fromStringAndSize(format, format.size());
            // TEMPLATE - repr_code_matrix - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x2Func_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()
            // Begin code injection
            // TEMPLATE - matrix_data_function - START
            const float* data = cppSelf->constData();
            PyObject *pyData = PyTuple_New(8);
            if (data) {
                for(int i=0; i < 8; i++)
                    PyTuple_SET_ITEM(pyData, i, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &data[i]));
            }
            return pyData;
            // TEMPLATE - matrix_data_function - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x2Func_fill(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.fill";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x2::fill(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // fill(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x2Func_fill_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fill(float)
            cppSelf->fill(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMatrix4x2Func_fill_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x2Func_isIdentity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.isIdentity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isIdentity()const
            bool cppResult = const_cast<const ::QMatrix4x2 *>(cppSelf)->isIdentity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x2Func___call__(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.__call__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "__call__", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMatrix4x2::operator()(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // operator()(int,int)const
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // operator()(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x2Func___call___TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // operator()(int,int)
            float & cppResult = cppSelf->operator()(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMatrix4x2Func___call___TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x2Func_setToIdentity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.setToIdentity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // setToIdentity()
            cppSelf->setToIdentity();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMatrix4x2Func_transposed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.transposed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transposed()const
            QGenericMatrix<2,4,float > cppResult = const_cast<const ::QMatrix4x2 *>(cppSelf)->transposed();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGENERICMATRIX_2_4_FLOAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMatrix4x2___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMatrix4x2_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMatrix4x2_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x2Func___reduce__), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x2Func_data), METH_NOARGS},
    {"fill", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x2Func_fill), METH_O},
    {"isIdentity", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x2Func_isIdentity), METH_NOARGS},
    {"setToIdentity", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x2Func_setToIdentity), METH_NOARGS},
    {"transposed", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x2Func_transposed), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMatrix4x2___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QMatrix4x2Func___imul__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.__imul__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x2::operator*=(float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // operator*=(float)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x2Func___imul___TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator*=(float)
            (*cppSelf) *= cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMatrix4x2Func___imul___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x2Func___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x2::operator+=(QGenericMatrix<4,2,float>)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGENERICMATRIX_4_2_FLOAT_IDX]), (pyArg)))) {
        overloadId = 0; // operator+=(QGenericMatrix<4,2,float>)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x2Func___iadd___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGenericMatrix<4,2,float > cppArg0_local;
        ::QGenericMatrix<4,2,float > *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGENERICMATRIX_4_2_FLOAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator+=(QGenericMatrix<4,2,float>)
            (*cppSelf) += (*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMatrix4x2Func___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x2Func___isub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.__isub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x2::operator-=(QGenericMatrix<4,2,float>)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGENERICMATRIX_4_2_FLOAT_IDX]), (pyArg)))) {
        overloadId = 0; // operator-=(QGenericMatrix<4,2,float>)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x2Func___isub___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGenericMatrix<4,2,float > cppArg0_local;
        ::QGenericMatrix<4,2,float > *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGENERICMATRIX_4_2_FLOAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator-=(QGenericMatrix<4,2,float>)
            (*cppSelf) -= (*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMatrix4x2Func___isub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMatrix4x2Func___idiv__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QMatrix4x2.__idiv__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMatrix4x2::operator/=(float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // operator/=(float)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMatrix4x2Func___idiv___TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator/=(float)
            (*cppSelf) /= cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMatrix4x2Func___idiv___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QMatrix4x2_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGENERICMATRIX_4_2_FLOAT_IDX]), (pyArg)))) {
                // operator!=(const QGenericMatrix<4,2,float > & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGenericMatrix<4,2,float > cppArg0_local;
                ::QGenericMatrix<4,2,float > *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGENERICMATRIX_4_2_FLOAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGENERICMATRIX_4_2_FLOAT_IDX]), (pyArg)))) {
                // operator==(const QGenericMatrix<4,2,float > & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGenericMatrix<4,2,float > cppArg0_local;
                ::QGenericMatrix<4,2,float > *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGENERICMATRIX_4_2_FLOAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QMatrix4x2_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QMatrix4x2_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QMatrix4x2_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMatrix4x2_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMatrix4x2_Type = nullptr;
static SbkObjectType *Sbk_QMatrix4x2_TypeF(void)
{
    return _Sbk_QMatrix4x2_Type;
}

static PyType_Slot Sbk_QMatrix4x2_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QMatrix4x2Func___repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        reinterpret_cast<void *>(&Sbk_QMatrix4x2Func___call__)},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMatrix4x2_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMatrix4x2_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QMatrix4x2_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMatrix4x2_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMatrix4x2_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_inplace_multiply, (void *)Sbk_QMatrix4x2Func___imul__},
    {Py_nb_inplace_add, (void *)Sbk_QMatrix4x2Func___iadd__},
    {Py_nb_inplace_subtract, (void *)Sbk_QMatrix4x2Func___isub__},
    // This function is unused in Python 3. We reference it here.
    {0, (void *)Sbk_QMatrix4x2Func___idiv__},
    // This list is ending at the first 0 entry.
    // Therefore, we need to put the unused functions at the very end.
    {0, nullptr}
};
static PyType_Spec Sbk_QMatrix4x2_spec = {
    "2:PySide2.QtGui.QMatrix4x2",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMatrix4x2_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMatrix4x2_PythonToCpp_QMatrix4x2_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMatrix4x2_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMatrix4x2_PythonToCpp_QMatrix4x2_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMatrix4x2_TypeF())))
        return QMatrix4x2_PythonToCpp_QMatrix4x2_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMatrix4x2_PTR_CppToPython_QMatrix4x2(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMatrix4x2 *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMatrix4x2_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMatrix4x2_COPY_CppToPython_QMatrix4x2(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMatrix4x2_TypeF(), new ::QMatrix4x2(*reinterpret_cast<const ::QMatrix4x2 *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMatrix4x2_PythonToCpp_QMatrix4x2_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMatrix4x2 *>(cppOut) = *reinterpret_cast< ::QMatrix4x2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMatrix4x2_PythonToCpp_QMatrix4x2_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMatrix4x2_TypeF())))
        return QMatrix4x2_PythonToCpp_QMatrix4x2_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMatrix4x2_SignatureStrings[] = {
    "2:PySide2.QtGui.QMatrix4x2(self)",
    "1:PySide2.QtGui.QMatrix4x2(self,arg__1:PySequence)",
    "0:PySide2.QtGui.QMatrix4x2(self,QMatrix4x2:PySide2.QtGui.QMatrix4x2)",
    "PySide2.QtGui.QMatrix4x2.__reduce__(self)->PyObject",
    "PySide2.QtGui.QMatrix4x2.__repr__(self)->PyObject",
    "PySide2.QtGui.QMatrix4x2.data(self)->float",
    "PySide2.QtGui.QMatrix4x2.fill(self,value:float)",
    "PySide2.QtGui.QMatrix4x2.isIdentity(self)->bool",
    "1:PySide2.QtGui.QMatrix4x2.__call__(self,row:int,column:int)->float",
    "0:PySide2.QtGui.QMatrix4x2.__call__(self,row:int,column:int)->float",
    "PySide2.QtGui.QMatrix4x2.setToIdentity(self)",
    "PySide2.QtGui.QMatrix4x2.transposed(self)->PySide2.QtGui.QGenericMatrix[2, 4, float]",
    "PySide2.QtGui.QMatrix4x2.__copy__()",
    "PySide2.QtGui.QMatrix4x2.__imul__(self,factor:float)->PySide2.QtGui.QGenericMatrix[4, 2, float]",
    "PySide2.QtGui.QMatrix4x2.__iadd__(self,other:PySide2.QtGui.QGenericMatrix[4, 2, float])->PySide2.QtGui.QGenericMatrix[4, 2, float]",
    "PySide2.QtGui.QMatrix4x2.__isub__(self,other:PySide2.QtGui.QGenericMatrix[4, 2, float])->PySide2.QtGui.QGenericMatrix[4, 2, float]",
    "PySide2.QtGui.QMatrix4x2.__idiv__(self,divisor:float)->PySide2.QtGui.QGenericMatrix[4, 2, float]",
    nullptr}; // Sentinel

void init_QMatrix4x2(PyObject *module)
{
    _Sbk_QMatrix4x2_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMatrix4x2",
        "QMatrix4x2",
        &Sbk_QMatrix4x2_spec,
        &Shiboken::callCppDestructor< ::QMatrix4x2 >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMatrix4x2_Type);
    InitSignatureStrings(pyType, QMatrix4x2_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMatrix4x2_Type), Sbk_QMatrix4x2_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMatrix4x2_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMatrix4x2_TypeF(),
        QMatrix4x2_PythonToCpp_QMatrix4x2_PTR,
        is_QMatrix4x2_PythonToCpp_QMatrix4x2_PTR_Convertible,
        QMatrix4x2_PTR_CppToPython_QMatrix4x2,
        QMatrix4x2_COPY_CppToPython_QMatrix4x2);

    Shiboken::Conversions::registerConverterName(converter, "QMatrix4x2");
    Shiboken::Conversions::registerConverterName(converter, "QMatrix4x2*");
    Shiboken::Conversions::registerConverterName(converter, "QMatrix4x2&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMatrix4x2).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMatrix4x2_PythonToCpp_QMatrix4x2_COPY,
        is_QMatrix4x2_PythonToCpp_QMatrix4x2_COPY_Convertible);

    qRegisterMetaType< ::QMatrix4x2 >("QMatrix4x2");
}
