/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qinputmethodevent_attribute_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QInputMethodEvent_Attribute_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QInputMethodEvent::Attribute >()))
        return -1;

    ::QInputMethodEvent::Attribute *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodEvent.Attribute.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto Sbk_QInputMethodEvent_Attribute_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "Attribute", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: Attribute::Attribute(QInputMethodEvent::AttributeType,int,int)
    // 1: Attribute::Attribute(QInputMethodEvent::AttributeType,int,int,QVariant)
    // 2: Attribute::Attribute(QInputMethodEvent::Attribute)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // Attribute(QInputMethodEvent::Attribute)
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // Attribute(QInputMethodEvent::AttributeType,int,int)
        } else if (numArgs == 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[3])))) {
            overloadId = 1; // Attribute(QInputMethodEvent::AttributeType,int,int,QVariant)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodEvent_Attribute_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // Attribute(QInputMethodEvent::AttributeType typ, int s, int l)
        {
            ::QInputMethodEvent::AttributeType cppArg0{QInputMethodEvent::TextFormat};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // Attribute(QInputMethodEvent::AttributeType,int,int)
                cptr = new ::QInputMethodEvent::Attribute(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // Attribute(QInputMethodEvent::AttributeType typ, int s, int l, QVariant val)
        {
            ::QInputMethodEvent::AttributeType cppArg0{QInputMethodEvent::TextFormat};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QVariant cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // Attribute(QInputMethodEvent::AttributeType,int,int,QVariant)
                cptr = new ::QInputMethodEvent::Attribute(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // Attribute(const QInputMethodEvent::Attribute & Attribute)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QInputMethodEvent::Attribute cppArg0_local = ::QInputMethodEvent::Attribute(QInputMethodEvent::TextFormat, int(0), int(0));
            ::QInputMethodEvent::Attribute *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // Attribute(QInputMethodEvent::Attribute)
                cptr = new ::QInputMethodEvent::Attribute(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QInputMethodEvent::Attribute >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QInputMethodEvent_Attribute_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QInputMethodEvent_Attribute_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QInputMethodEvent_Attribute___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QInputMethodEvent_Attribute_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QInputMethodEvent_Attribute_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QInputMethodEvent_Attribute___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QInputMethodEvent_Attribute_get_type(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QInputMethodEvent::AttributeType cppOut_local = cppSelf->type;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QInputMethodEvent_Attribute_set_type(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'AttributeType' or convertible type expected");
        return -1;
    }

    ::QInputMethodEvent::AttributeType cppOut_local = cppSelf->type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->type = cppOut_local;

    return 0;
}

static PyObject *Sbk_QInputMethodEvent_Attribute_get_start(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->start;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QInputMethodEvent_Attribute_set_start(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'start' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'start', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->start;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->start = cppOut_local;

    return 0;
}

static PyObject *Sbk_QInputMethodEvent_Attribute_get_length(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->length;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QInputMethodEvent_Attribute_set_length(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'length' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'length', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->length;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->length = cppOut_local;

    return 0;
}

static PyObject *Sbk_QInputMethodEvent_Attribute_get_value(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppSelf->value);
    return pyOut;
}
static int Sbk_QInputMethodEvent_Attribute_set_value(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'value' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'value', 'QVariant' or convertible type expected");
        return -1;
    }

    ::QVariant& cppOut_ptr = cppSelf->value;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Attribute
static PyGetSetDef Sbk_QInputMethodEvent_Attribute_getsetlist[] = {
    {const_cast<char *>("type"), Sbk_QInputMethodEvent_Attribute_get_type, Sbk_QInputMethodEvent_Attribute_set_type},
    {const_cast<char *>("start"), Sbk_QInputMethodEvent_Attribute_get_start, Sbk_QInputMethodEvent_Attribute_set_start},
    {const_cast<char *>("length"), Sbk_QInputMethodEvent_Attribute_get_length, Sbk_QInputMethodEvent_Attribute_set_length},
    {const_cast<char *>("value"), Sbk_QInputMethodEvent_Attribute_get_value, Sbk_QInputMethodEvent_Attribute_set_value},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QInputMethodEvent_Attribute_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QInputMethodEvent_Attribute_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QInputMethodEvent_Attribute_Type = nullptr;
static SbkObjectType *Sbk_QInputMethodEvent_Attribute_TypeF(void)
{
    return _Sbk_QInputMethodEvent_Attribute_Type;
}

static PyType_Slot Sbk_QInputMethodEvent_Attribute_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QInputMethodEvent_Attribute_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QInputMethodEvent_Attribute_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QInputMethodEvent_Attribute_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QInputMethodEvent_Attribute_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QInputMethodEvent_Attribute_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QInputMethodEvent_Attribute_spec = {
    "2:PySide2.QtGui.QInputMethodEvent.Attribute",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QInputMethodEvent_Attribute_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Attribute_PythonToCpp_Attribute_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QInputMethodEvent_Attribute_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Attribute_PythonToCpp_Attribute_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QInputMethodEvent_Attribute_TypeF())))
        return Attribute_PythonToCpp_Attribute_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Attribute_PTR_CppToPython_Attribute(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QInputMethodEvent::Attribute *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QInputMethodEvent_Attribute_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *Attribute_COPY_CppToPython_Attribute(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QInputMethodEvent_Attribute_TypeF(), new ::QInputMethodEvent::Attribute(*reinterpret_cast<const ::QInputMethodEvent::Attribute *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void Attribute_PythonToCpp_Attribute_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QInputMethodEvent::Attribute *>(cppOut) = *reinterpret_cast< ::QInputMethodEvent::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Attribute_PythonToCpp_Attribute_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QInputMethodEvent_Attribute_TypeF())))
        return Attribute_PythonToCpp_Attribute_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QInputMethodEvent_Attribute_SignatureStrings[] = {
    "2:PySide2.QtGui.QInputMethodEvent.Attribute(self,typ:PySide2.QtGui.QInputMethodEvent.AttributeType,s:int,l:int)",
    "1:PySide2.QtGui.QInputMethodEvent.Attribute(self,typ:PySide2.QtGui.QInputMethodEvent.AttributeType,s:int,l:int,val:QVariant)",
    "0:PySide2.QtGui.QInputMethodEvent.Attribute(self,Attribute:PySide2.QtGui.QInputMethodEvent.Attribute)",
    "PySide2.QtGui.QInputMethodEvent.Attribute.__copy__()",
    nullptr}; // Sentinel

void init_QInputMethodEvent_Attribute(PyObject *enclosingClass)
{
    _Sbk_QInputMethodEvent_Attribute_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Attribute",
        "QInputMethodEvent::Attribute",
        &Sbk_QInputMethodEvent_Attribute_spec,
        &Shiboken::callCppDestructor< ::QInputMethodEvent::Attribute >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QInputMethodEvent_Attribute_Type);
    InitSignatureStrings(pyType, QInputMethodEvent_Attribute_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QInputMethodEvent_Attribute_Type), Sbk_QInputMethodEvent_Attribute_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QInputMethodEvent_Attribute_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QInputMethodEvent_Attribute_TypeF(),
        Attribute_PythonToCpp_Attribute_PTR,
        is_Attribute_PythonToCpp_Attribute_PTR_Convertible,
        Attribute_PTR_CppToPython_Attribute,
        Attribute_COPY_CppToPython_Attribute);

    Shiboken::Conversions::registerConverterName(converter, "QInputMethodEvent::Attribute");
    Shiboken::Conversions::registerConverterName(converter, "QInputMethodEvent::Attribute*");
    Shiboken::Conversions::registerConverterName(converter, "QInputMethodEvent::Attribute&");
    Shiboken::Conversions::registerConverterName(converter, "Attribute");
    Shiboken::Conversions::registerConverterName(converter, "Attribute*");
    Shiboken::Conversions::registerConverterName(converter, "Attribute&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QInputMethodEvent::Attribute).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Attribute_PythonToCpp_Attribute_COPY,
        is_Attribute_PythonToCpp_Attribute_COPY_Convertible);

}
