/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qaccessibletextcursorevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAccessibleTextCursorEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAccessibleTextCursorEventWrapper::QAccessibleTextCursorEventWrapper(::QAccessibleInterface * iface, int cursorPos) : QAccessibleTextCursorEvent(iface, cursorPos)
{
    resetPyMethodCache();
    // ... middle
}

QAccessibleTextCursorEventWrapper::QAccessibleTextCursorEventWrapper(::QObject * obj, int cursorPos) : QAccessibleTextCursorEvent(obj, cursorPos)
{
    resetPyMethodCache();
    // ... middle
}

::QAccessibleInterface * QAccessibleTextCursorEventWrapper::accessibleInterface() const
{
    if (m_PyMethodCache[0])
        return this->::QAccessibleEvent::accessibleInterface();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "accessibleInterface";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QAccessibleEvent::accessibleInterface();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAccessibleTextCursorEvent.accessibleInterface", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAccessibleInterface >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QAccessibleInterface *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QAccessibleTextCursorEventWrapper::~QAccessibleTextCursorEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAccessibleTextCursorEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAccessibleTextCursorEvent >()))
        return -1;

    ::QAccessibleTextCursorEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextCursorEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAccessibleTextCursorEvent", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QAccessibleTextCursorEvent::QAccessibleTextCursorEvent(QAccessibleInterface*,int)
    // 1: QAccessibleTextCursorEvent::QAccessibleTextCursorEvent(QObject*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // QAccessibleTextCursorEvent(QObject*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // QAccessibleTextCursorEvent(QAccessibleInterface*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTextCursorEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAccessibleTextCursorEvent(QAccessibleInterface * iface, int cursorPos)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAccessibleInterface *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QAccessibleTextCursorEvent(QAccessibleInterface*,int)
                cptr = new ::QAccessibleTextCursorEventWrapper(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // QAccessibleTextCursorEvent(QObject * obj, int cursorPos)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QAccessibleTextCursorEvent(QObject*,int)
                cptr = new ::QAccessibleTextCursorEventWrapper(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAccessibleTextCursorEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAccessibleTextCursorEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAccessibleTextCursorEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAccessibleTextCursorEventFunc_cursorPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTextCursorEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTCURSOREVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextCursorEvent.cursorPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cursorPosition()const
            int cppResult = const_cast<const ::QAccessibleTextCursorEvent *>(cppSelf)->cursorPosition();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleTextCursorEventFunc_setCursorPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTextCursorEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTCURSOREVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTextCursorEvent.setCursorPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAccessibleTextCursorEvent::setCursorPosition(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCursorPosition(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTextCursorEventFunc_setCursorPosition_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCursorPosition(int)
            cppSelf->setCursorPosition(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleTextCursorEventFunc_setCursorPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QAccessibleTextCursorEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAccessibleTextCursorEvent_methods[] = {
    {"cursorPosition", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTextCursorEventFunc_cursorPosition), METH_NOARGS},
    {"setCursorPosition", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTextCursorEventFunc_setCursorPosition), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAccessibleTextCursorEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAccessibleTextCursorEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTCURSOREVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAccessibleTextCursorEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAccessibleTextCursorEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAccessibleTextCursorEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAccessibleTextCursorEvent_Type = nullptr;
static SbkObjectType *Sbk_QAccessibleTextCursorEvent_TypeF(void)
{
    return _Sbk_QAccessibleTextCursorEvent_Type;
}

static PyType_Slot Sbk_QAccessibleTextCursorEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAccessibleTextCursorEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAccessibleTextCursorEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAccessibleTextCursorEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAccessibleTextCursorEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAccessibleTextCursorEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAccessibleTextCursorEvent_spec = {
    "2:PySide2.QtGui.QAccessibleTextCursorEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAccessibleTextCursorEvent_slots
};

} //extern "C"

static void *Sbk_QAccessibleTextCursorEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QAccessibleTextCursorEvent *>(cptr)->type() == QAccessible::TextCaretMoved)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAccessibleTextCursorEvent_PythonToCpp_QAccessibleTextCursorEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAccessibleTextCursorEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAccessibleTextCursorEvent_PythonToCpp_QAccessibleTextCursorEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleTextCursorEvent_TypeF())))
        return QAccessibleTextCursorEvent_PythonToCpp_QAccessibleTextCursorEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAccessibleTextCursorEvent_PTR_CppToPython_QAccessibleTextCursorEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAccessibleTextCursorEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAccessibleTextCursorEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAccessibleTextCursorEvent_SignatureStrings[] = {
    "1:PySide2.QtGui.QAccessibleTextCursorEvent(self,iface:PySide2.QtGui.QAccessibleInterface,cursorPos:int)",
    "0:PySide2.QtGui.QAccessibleTextCursorEvent(self,obj:PySide2.QtCore.QObject,cursorPos:int)",
    "PySide2.QtGui.QAccessibleTextCursorEvent.cursorPosition(self)->int",
    "PySide2.QtGui.QAccessibleTextCursorEvent.setCursorPosition(self,position:int)",
    nullptr}; // Sentinel

void init_QAccessibleTextCursorEvent(PyObject *module)
{
    _Sbk_QAccessibleTextCursorEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAccessibleTextCursorEvent",
        "QAccessibleTextCursorEvent*",
        &Sbk_QAccessibleTextCursorEvent_spec,
        &Shiboken::callCppDestructor< ::QAccessibleTextCursorEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleTextCursorEvent_Type);
    InitSignatureStrings(pyType, QAccessibleTextCursorEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleTextCursorEvent_Type), Sbk_QAccessibleTextCursorEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETEXTCURSOREVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleTextCursorEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAccessibleTextCursorEvent_TypeF(),
        QAccessibleTextCursorEvent_PythonToCpp_QAccessibleTextCursorEvent_PTR,
        is_QAccessibleTextCursorEvent_PythonToCpp_QAccessibleTextCursorEvent_PTR_Convertible,
        QAccessibleTextCursorEvent_PTR_CppToPython_QAccessibleTextCursorEvent);

    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTextCursorEvent");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTextCursorEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTextCursorEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleTextCursorEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleTextCursorEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAccessibleTextCursorEvent_TypeF(), &Sbk_QAccessibleTextCursorEvent_typeDiscovery);

}
