/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qitemmodelsurfacedataproxy_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QItemModelSurfaceDataProxyWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QItemModelSurfaceDataProxyWrapper::QItemModelSurfaceDataProxyWrapper(::QAbstractItemModel * itemModel, ::QObject * parent) : QtDataVisualization::QItemModelSurfaceDataProxy(itemModel, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelSurfaceDataProxyWrapper::QItemModelSurfaceDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & rowRole, const ::QString & columnRole, const ::QString & xPosRole, const ::QString & yPosRole, const ::QString & zPosRole, ::QObject * parent) : QtDataVisualization::QItemModelSurfaceDataProxy(itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelSurfaceDataProxyWrapper::QItemModelSurfaceDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & rowRole, const ::QString & columnRole, const ::QString & xPosRole, const ::QString & yPosRole, const ::QString & zPosRole, const ::QStringList & rowCategories, const ::QStringList & columnCategories, ::QObject * parent) : QtDataVisualization::QItemModelSurfaceDataProxy(itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelSurfaceDataProxyWrapper::QItemModelSurfaceDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & rowRole, const ::QString & columnRole, const ::QString & yPosRole, ::QObject * parent) : QtDataVisualization::QItemModelSurfaceDataProxy(itemModel, rowRole, columnRole, yPosRole, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelSurfaceDataProxyWrapper::QItemModelSurfaceDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & rowRole, const ::QString & columnRole, const ::QString & yPosRole, const ::QStringList & rowCategories, const ::QStringList & columnCategories, ::QObject * parent) : QtDataVisualization::QItemModelSurfaceDataProxy(itemModel, rowRole, columnRole, yPosRole, rowCategories, columnCategories, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelSurfaceDataProxyWrapper::QItemModelSurfaceDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & yPosRole, ::QObject * parent) : QtDataVisualization::QItemModelSurfaceDataProxy(itemModel, yPosRole, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelSurfaceDataProxyWrapper::QItemModelSurfaceDataProxyWrapper(::QObject * parent) : QtDataVisualization::QItemModelSurfaceDataProxy(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QItemModelSurfaceDataProxyWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QItemModelSurfaceDataProxyWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QItemModelSurfaceDataProxyWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QItemModelSurfaceDataProxyWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QItemModelSurfaceDataProxyWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QItemModelSurfaceDataProxy.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QItemModelSurfaceDataProxyWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QItemModelSurfaceDataProxy.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QItemModelSurfaceDataProxyWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QItemModelSurfaceDataProxyWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::QItemModelSurfaceDataProxy::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QItemModelSurfaceDataProxyWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::QItemModelSurfaceDataProxy::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QItemModelSurfaceDataProxyWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QItemModelSurfaceDataProxyWrapper *>(this));
        return QtDataVisualization::QItemModelSurfaceDataProxy::qt_metacast(_clname);
}

QItemModelSurfaceDataProxyWrapper::~QItemModelSurfaceDataProxyWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtDataVisualization::QItemModelSurfaceDataProxy >()))
        return -1;

    ::QItemModelSurfaceDataProxyWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOOOOOOOO:QItemModelSurfaceDataProxy", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return -1;


    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QObject*)
    // 1: QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QObject*)
    // 2: QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QStringList,QStringList,QObject*)
    // 3: QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)
    // 4: QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)
    // 5: QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QObject*)
    // 6: QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QObject*)
    if (numArgs == 0) {
        overloadId = 6; // QItemModelSurfaceDataProxy(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 5; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QObject*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
                overloadId = 5; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QObject*)
            } else if (numArgs >= 4
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 3; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)
                } else if (numArgs >= 6
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[4])))
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[5])))) {
                    if (numArgs == 6) {
                        overloadId = 4; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)
                    } else if (numArgs >= 7
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[6])))) {
                        overloadId = 4; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)
                    }
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4])))) {
                    overloadId = 3; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)
                } else if (numArgs >= 6
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
                    if (numArgs == 6) {
                        overloadId = 1; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QObject*)
                    } else if (numArgs >= 8
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[6])))
                        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[7])))) {
                        if (numArgs == 8) {
                            overloadId = 2; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QStringList,QStringList,QObject*)
                        } else if (numArgs >= 9
                            && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[8])))) {
                            overloadId = 2; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QStringList,QStringList,QObject*)
                        }
                    } else if (numArgs >= 7
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[6])))) {
                        overloadId = 1; // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QObject*)
                    }
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 6; // QItemModelSurfaceDataProxy(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QItemModelSurfaceDataProxy(QAbstractItemModel * itemModel, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QItemModelSurfaceDataProxy(QAbstractItemModel*,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 1: // QItemModelSurfaceDataProxy(QAbstractItemModel * itemModel, const QString & rowRole, const QString & columnRole, const QString & xPosRole, const QString & yPosRole, const QString & zPosRole, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[6]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[6]))))
                            goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return -1;
            ::QObject *cppArg6 = nullptr;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                }

                Shiboken::Object::setParent(pyArgs[6], self);
            }
            break;
        }
        case 2: // QItemModelSurfaceDataProxy(QAbstractItemModel * itemModel, const QString & rowRole, const QString & columnRole, const QString & xPosRole, const QString & yPosRole, const QString & zPosRole, const QStringList & rowCategories, const QStringList & columnCategories, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[8]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[8]))))
                            goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QStringList cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QStringList cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return -1;
            ::QObject *cppArg8 = nullptr;
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);

            if (!PyErr_Occurred()) {
                // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QStringList,QStringList,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
                }

                Shiboken::Object::setParent(pyArgs[8], self);
            }
            break;
        }
        case 3: // QItemModelSurfaceDataProxy(QAbstractItemModel * itemModel, const QString & rowRole, const QString & columnRole, const QString & yPosRole, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[4]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4]))))
                            goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QObject *cppArg4 = nullptr;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                }

                Shiboken::Object::setParent(pyArgs[4], self);
            }
            break;
        }
        case 4: // QItemModelSurfaceDataProxy(QAbstractItemModel * itemModel, const QString & rowRole, const QString & columnRole, const QString & yPosRole, const QStringList & rowCategories, const QStringList & columnCategories, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[6]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[6]))))
                            goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QStringList cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QStringList cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return -1;
            ::QObject *cppArg6 = nullptr;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                }

                Shiboken::Object::setParent(pyArgs[6], self);
            }
            break;
        }
        case 5: // QItemModelSurfaceDataProxy(QAbstractItemModel * itemModel, const QString & yPosRole, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelSurfaceDataProxyWrapper(cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
        case 6: // QItemModelSurfaceDataProxy(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QItemModelSurfaceDataProxy(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelSurfaceDataProxyWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelSurfaceDataProxyWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtDataVisualization::QItemModelSurfaceDataProxy >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_autoColumnCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.autoColumnCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoColumnCategories()const
            bool cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->autoColumnCategories();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_autoRowCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.autoRowCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoRowCategories()const
            bool cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->autoRowCategories();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnCategories()const
            QStringList cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->columnCategories();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnCategoryIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnCategoryIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::columnCategoryIndex(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // columnCategoryIndex(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnCategoryIndex_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // columnCategoryIndex(QString)
            int cppResult = cppSelf->columnCategoryIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnCategoryIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnRole()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->columnRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnRolePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnRolePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnRolePattern()const
            QRegExp cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->columnRolePattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnRoleReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnRoleReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnRoleReplace()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->columnRoleReplace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_itemModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.itemModel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // itemModel()const
            QAbstractItemModel * cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->itemModel();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_multiMatchBehavior(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.multiMatchBehavior";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // multiMatchBehavior()const
            QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->multiMatchBehavior();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_remap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.remap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "remap", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::remap(QString,QString,QString,QString,QString,QStringList,QStringList)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[6])))) {
        overloadId = 0; // remap(QString,QString,QString,QString,QString,QStringList,QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_remap_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QStringList cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QStringList cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // remap(QString,QString,QString,QString,QString,QStringList,QStringList)
            cppSelf->remap(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_remap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowCategories()const
            QStringList cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->rowCategories();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowCategoryIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowCategoryIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::rowCategoryIndex(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // rowCategoryIndex(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowCategoryIndex_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rowCategoryIndex(QString)
            int cppResult = cppSelf->rowCategoryIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowCategoryIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowRole()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->rowRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowRolePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowRolePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowRolePattern()const
            QRegExp cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->rowRolePattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowRoleReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowRoleReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowRoleReplace()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->rowRoleReplace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setAutoColumnCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setAutoColumnCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setAutoColumnCategories(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoColumnCategories(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setAutoColumnCategories_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoColumnCategories(bool)
            cppSelf->setAutoColumnCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setAutoColumnCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setAutoRowCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setAutoRowCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setAutoRowCategories(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoRowCategories(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setAutoRowCategories_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoRowCategories(bool)
            cppSelf->setAutoRowCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setAutoRowCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setColumnCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setColumnCategories(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setColumnCategories(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnCategories_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColumnCategories(QStringList)
            cppSelf->setColumnCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setColumnRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setColumnRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setColumnRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColumnRole(QString)
            cppSelf->setColumnRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRolePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setColumnRolePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setColumnRolePattern(QRegExp)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // setColumnRolePattern(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRolePattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setColumnRolePattern(QRegExp)
            cppSelf->setColumnRolePattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRolePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRoleReplace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setColumnRoleReplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setColumnRoleReplace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setColumnRoleReplace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRoleReplace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColumnRoleReplace(QString)
            cppSelf->setColumnRoleReplace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRoleReplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setItemModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setItemModel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setItemModel(QAbstractItemModel*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArg)))) {
        overloadId = 0; // setItemModel(QAbstractItemModel*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setItemModel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemModel *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setItemModel(QAbstractItemModel*)
            cppSelf->setItemModel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setItemModel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setMultiMatchBehavior(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setMultiMatchBehavior";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setMultiMatchBehavior(QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMultiMatchBehavior(QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setMultiMatchBehavior_TypeError;

    // Call function/method
    {
        ::QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior cppArg0{QtDataVisualization::QItemModelSurfaceDataProxy::MMBFirst};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMultiMatchBehavior(QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior)
            cppSelf->setMultiMatchBehavior(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setMultiMatchBehavior_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setRowCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setRowCategories(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setRowCategories(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowCategories_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRowCategories(QStringList)
            cppSelf->setRowCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setRowRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setRowRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setRowRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRowRole(QString)
            cppSelf->setRowRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRolePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setRowRolePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setRowRolePattern(QRegExp)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // setRowRolePattern(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRolePattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setRowRolePattern(QRegExp)
            cppSelf->setRowRolePattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRolePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRoleReplace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setRowRoleReplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setRowRoleReplace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setRowRoleReplace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRoleReplace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRowRoleReplace(QString)
            cppSelf->setRowRoleReplace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRoleReplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setUseModelCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setUseModelCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setUseModelCategories(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUseModelCategories(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setUseModelCategories_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUseModelCategories(bool)
            cppSelf->setUseModelCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setUseModelCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setXPosRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setXPosRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setXPosRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setXPosRole(QString)
            cppSelf->setXPosRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRolePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setXPosRolePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setXPosRolePattern(QRegExp)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // setXPosRolePattern(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRolePattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setXPosRolePattern(QRegExp)
            cppSelf->setXPosRolePattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRolePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRoleReplace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setXPosRoleReplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setXPosRoleReplace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setXPosRoleReplace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRoleReplace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setXPosRoleReplace(QString)
            cppSelf->setXPosRoleReplace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRoleReplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setYPosRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setYPosRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setYPosRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setYPosRole(QString)
            cppSelf->setYPosRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRolePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setYPosRolePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setYPosRolePattern(QRegExp)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // setYPosRolePattern(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRolePattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setYPosRolePattern(QRegExp)
            cppSelf->setYPosRolePattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRolePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRoleReplace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setYPosRoleReplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setYPosRoleReplace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setYPosRoleReplace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRoleReplace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setYPosRoleReplace(QString)
            cppSelf->setYPosRoleReplace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRoleReplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setZPosRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setZPosRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setZPosRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setZPosRole(QString)
            cppSelf->setZPosRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRolePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setZPosRolePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setZPosRolePattern(QRegExp)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // setZPosRolePattern(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRolePattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setZPosRolePattern(QRegExp)
            cppSelf->setZPosRolePattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRolePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRoleReplace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setZPosRoleReplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelSurfaceDataProxy::setZPosRoleReplace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setZPosRoleReplace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRoleReplace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setZPosRoleReplace(QString)
            cppSelf->setZPosRoleReplace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRoleReplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_useModelCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.useModelCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // useModelCategories()const
            bool cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->useModelCategories();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_xPosRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.xPosRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // xPosRole()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->xPosRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_xPosRolePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.xPosRolePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // xPosRolePattern()const
            QRegExp cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->xPosRolePattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_xPosRoleReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.xPosRoleReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // xPosRoleReplace()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->xPosRoleReplace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_yPosRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.yPosRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yPosRole()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->yPosRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_yPosRolePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.yPosRolePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yPosRolePattern()const
            QRegExp cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->yPosRolePattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_yPosRoleReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.yPosRoleReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yPosRoleReplace()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->yPosRoleReplace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_zPosRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.zPosRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // zPosRole()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->zPosRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_zPosRolePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.zPosRolePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // zPosRolePattern()const
            QRegExp cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->zPosRolePattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_zPosRoleReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.zPosRoleReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // zPosRoleReplace()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy *>(cppSelf)->zPosRoleReplace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_PropertyStrings[] = {
    "autoColumnCategories::",
    "autoRowCategories::",
    "columnCategories::",
    "columnRole::",
    "columnRolePattern::",
    "columnRoleReplace::",
    "itemModel::",
    "multiMatchBehavior::",
    "rowCategories::",
    "rowRole::",
    "rowRolePattern::",
    "rowRoleReplace::",
    "useModelCategories::",
    "xPosRole::",
    "xPosRolePattern::",
    "xPosRoleReplace::",
    "yPosRole::",
    "yPosRolePattern::",
    "yPosRoleReplace::",
    "zPosRole::",
    "zPosRolePattern::",
    "zPosRoleReplace::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_methods[] = {
    {"autoColumnCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_autoColumnCategories), METH_NOARGS},
    {"autoRowCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_autoRowCategories), METH_NOARGS},
    {"columnCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnCategories), METH_NOARGS},
    {"columnCategoryIndex", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnCategoryIndex), METH_O},
    {"columnRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnRole), METH_NOARGS},
    {"columnRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnRolePattern), METH_NOARGS},
    {"columnRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_columnRoleReplace), METH_NOARGS},
    {"itemModel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_itemModel), METH_NOARGS},
    {"multiMatchBehavior", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_multiMatchBehavior), METH_NOARGS},
    {"remap", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_remap), METH_VARARGS},
    {"rowCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowCategories), METH_NOARGS},
    {"rowCategoryIndex", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowCategoryIndex), METH_O},
    {"rowRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowRole), METH_NOARGS},
    {"rowRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowRolePattern), METH_NOARGS},
    {"rowRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_rowRoleReplace), METH_NOARGS},
    {"setAutoColumnCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setAutoColumnCategories), METH_O},
    {"setAutoRowCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setAutoRowCategories), METH_O},
    {"setColumnCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnCategories), METH_O},
    {"setColumnRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRole), METH_O},
    {"setColumnRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRolePattern), METH_O},
    {"setColumnRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setColumnRoleReplace), METH_O},
    {"setItemModel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setItemModel), METH_O},
    {"setMultiMatchBehavior", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setMultiMatchBehavior), METH_O},
    {"setRowCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowCategories), METH_O},
    {"setRowRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRole), METH_O},
    {"setRowRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRolePattern), METH_O},
    {"setRowRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setRowRoleReplace), METH_O},
    {"setUseModelCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setUseModelCategories), METH_O},
    {"setXPosRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRole), METH_O},
    {"setXPosRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRolePattern), METH_O},
    {"setXPosRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setXPosRoleReplace), METH_O},
    {"setYPosRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRole), METH_O},
    {"setYPosRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRolePattern), METH_O},
    {"setYPosRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setYPosRoleReplace), METH_O},
    {"setZPosRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRole), METH_O},
    {"setZPosRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRolePattern), METH_O},
    {"setZPosRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_setZPosRoleReplace), METH_O},
    {"useModelCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_useModelCategories), METH_NOARGS},
    {"xPosRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_xPosRole), METH_NOARGS},
    {"xPosRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_xPosRolePattern), METH_NOARGS},
    {"xPosRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_xPosRoleReplace), METH_NOARGS},
    {"yPosRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_yPosRole), METH_NOARGS},
    {"yPosRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_yPosRolePattern), METH_NOARGS},
    {"yPosRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_yPosRoleReplace), METH_NOARGS},
    {"zPosRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_zPosRole), METH_NOARGS},
    {"zPosRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_zPosRolePattern), METH_NOARGS},
    {"zPosRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxyFunc_zPosRoleReplace), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QItemModelSurfaceDataProxyWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(void)
{
    return _Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::QItemModelSurfaceDataProxy *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior *>(cppOut) =
        static_cast<::QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX]))
        return QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior;
    return {};
}
static PyObject *QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior_CppToPython_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QItemModelSurfaceDataProxy_PythonToCpp_QItemModelSurfaceDataProxy_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QItemModelSurfaceDataProxy_PythonToCpp_QItemModelSurfaceDataProxy_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF())))
        return QItemModelSurfaceDataProxy_PythonToCpp_QItemModelSurfaceDataProxy_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QItemModelSurfaceDataProxy_PTR_CppToPython_QItemModelSurfaceDataProxy(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::QItemModelSurfaceDataProxy *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QItemModelSurfaceDataProxy_SignatureStrings[] = {
    "6:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,parent:PySide2.QtCore.QObject=nullptr)",
    "5:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,rowRole:QString,columnRole:QString,xPosRole:QString,yPosRole:QString,zPosRole:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "4:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,rowRole:QString,columnRole:QString,xPosRole:QString,yPosRole:QString,zPosRole:QString,rowCategories:QStringList,columnCategories:QStringList,parent:PySide2.QtCore.QObject=nullptr)",
    "3:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,rowRole:QString,columnRole:QString,yPosRole:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "2:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,rowRole:QString,columnRole:QString,yPosRole:QString,rowCategories:QStringList,columnCategories:QStringList,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,yPosRole:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.autoColumnCategories(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.autoRowCategories(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnCategories(self)->QStringList",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnCategoryIndex(self,category:QString)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnRole(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnRolePattern(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.columnRoleReplace(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.itemModel(self)->PySide2.QtCore.QAbstractItemModel",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.multiMatchBehavior(self)->PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.remap(self,rowRole:QString,columnRole:QString,xPosRole:QString,yPosRole:QString,zPosRole:QString,rowCategories:QStringList,columnCategories:QStringList)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowCategories(self)->QStringList",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowCategoryIndex(self,category:QString)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowRole(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowRolePattern(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.rowRoleReplace(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setAutoColumnCategories(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setAutoRowCategories(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setColumnCategories(self,categories:QStringList)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setColumnRole(self,role:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setColumnRolePattern(self,pattern:PySide2.QtCore.QRegExp)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setColumnRoleReplace(self,replace:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setItemModel(self,itemModel:PySide2.QtCore.QAbstractItemModel)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setMultiMatchBehavior(self,behavior:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setRowCategories(self,categories:QStringList)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setRowRole(self,role:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setRowRolePattern(self,pattern:PySide2.QtCore.QRegExp)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setRowRoleReplace(self,replace:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setUseModelCategories(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setXPosRole(self,role:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setXPosRolePattern(self,pattern:PySide2.QtCore.QRegExp)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setXPosRoleReplace(self,replace:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setYPosRole(self,role:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setYPosRolePattern(self,pattern:PySide2.QtCore.QRegExp)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setYPosRoleReplace(self,replace:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setZPosRole(self,role:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setZPosRolePattern(self,pattern:PySide2.QtCore.QRegExp)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.setZPosRoleReplace(self,replace:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.useModelCategories(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.xPosRole(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.xPosRolePattern(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.xPosRoleReplace(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.yPosRole(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.yPosRolePattern(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.yPosRoleReplace(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.zPosRole(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.zPosRolePattern(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.zPosRoleReplace(self)->QString",
    nullptr}; // Sentinel

void init_QtDataVisualization_QItemModelSurfaceDataProxy(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QItemModelSurfaceDataProxy",
        "QtDataVisualization::QItemModelSurfaceDataProxy*",
        &Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QItemModelSurfaceDataProxy >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSURFACEDATAPROXY_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QItemModelSurfaceDataProxy_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_Type), Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(),
        QItemModelSurfaceDataProxy_PythonToCpp_QItemModelSurfaceDataProxy_PTR,
        is_QItemModelSurfaceDataProxy_PythonToCpp_QItemModelSurfaceDataProxy_PTR_Convertible,
        QItemModelSurfaceDataProxy_PTR_CppToPython_QItemModelSurfaceDataProxy);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QItemModelSurfaceDataProxy");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QItemModelSurfaceDataProxy*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QItemModelSurfaceDataProxy&");
    Shiboken::Conversions::registerConverterName(converter, "QItemModelSurfaceDataProxy");
    Shiboken::Conversions::registerConverterName(converter, "QItemModelSurfaceDataProxy*");
    Shiboken::Conversions::registerConverterName(converter, "QItemModelSurfaceDataProxy&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QItemModelSurfaceDataProxy).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QItemModelSurfaceDataProxyWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(), &Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'MultiMatchBehavior'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(),
        "MultiMatchBehavior",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior",
        "QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
        Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(), "MMBFirst", (long) QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior::MMBFirst))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
        Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(), "MMBLast", (long) QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior::MMBLast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
        Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(), "MMBAverage", (long) QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior::MMBAverage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
        Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(), "MMBCumulativeY", (long) QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior::MMBCumulativeY))
        return;
    // Register converter for enum 'QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
            QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior_CppToPython_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior,
            is_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELSURFACEDATAPROXY_MULTIMATCHBEHAVIOR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior");
        Shiboken::Conversions::registerConverterName(converter, "QItemModelSurfaceDataProxy::MultiMatchBehavior");
        Shiboken::Conversions::registerConverterName(converter, "MultiMatchBehavior");
    }
    // End of 'MultiMatchBehavior' enum.

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(), &::QtDataVisualization::QItemModelSurfaceDataProxy::staticMetaObject);
    qRegisterMetaType< ::QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior >("QItemModelSurfaceDataProxy::MultiMatchBehavior");
    qRegisterMetaType< ::QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior >("QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_QItemModelSurfaceDataProxy_TypeF(), &::QtDataVisualization::QItemModelSurfaceDataProxy::staticMetaObject, sizeof(QItemModelSurfaceDataProxyWrapper));
}
