/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qbardataitem_wrapper.h"

// inner classes

// Extra includes
#include <QtDataVisualization/qbardataitem.h>


#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtDataVisualization_QBarDataItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtDataVisualization::QBarDataItem >()))
        return -1;

    ::QtDataVisualization::QBarDataItem *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QBarDataItem", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QBarDataItem::QBarDataItem()
    // 1: QBarDataItem::QBarDataItem(QtDataVisualization::QBarDataItem)
    // 2: QBarDataItem::QBarDataItem(float)
    // 3: QBarDataItem::QBarDataItem(float,float)
    if (numArgs == 0) {
        overloadId = 0; // QBarDataItem()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QBarDataItem(float)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
            overloadId = 3; // QBarDataItem(float,float)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QBarDataItem(QtDataVisualization::QBarDataItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataItem_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QBarDataItem()
        {

            if (!PyErr_Occurred()) {
                // QBarDataItem()
                cptr = new ::QtDataVisualization::QBarDataItem();
            }
            break;
        }
        case 1: // QBarDataItem(const QtDataVisualization::QBarDataItem & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QtDataVisualization::QBarDataItem cppArg0_local;
            ::QtDataVisualization::QBarDataItem *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QBarDataItem(QtDataVisualization::QBarDataItem)
                cptr = new ::QtDataVisualization::QBarDataItem(*cppArg0);
            }
            break;
        }
        case 2: // QBarDataItem(float value)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QBarDataItem(float)
                cptr = new ::QtDataVisualization::QBarDataItem(cppArg0);
            }
            break;
        }
        case 3: // QBarDataItem(float value, float angle)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QBarDataItem(float,float)
                cptr = new ::QtDataVisualization::QBarDataItem(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtDataVisualization::QBarDataItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtDataVisualization_QBarDataItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QtDataVisualization_QBarDataItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtDataVisualization_QBarDataItemFunc_createExtraData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.createExtraData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createExtraData()
            cppSelf->createExtraData();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QtDataVisualization_QBarDataItemFunc_rotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.rotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rotation()const
            float cppResult = const_cast<const ::QtDataVisualization::QBarDataItem *>(cppSelf)->rotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QBarDataItemFunc_setRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.setRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBarDataItem::setRotation(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setRotation(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataItemFunc_setRotation_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRotation(float)
            cppSelf->setRotation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataItemFunc_setRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataItemFunc_setValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.setValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBarDataItem::setValue(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setValue(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataItemFunc_setValue_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setValue(float)
            cppSelf->setValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataItemFunc_setValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataItemFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()const
            float cppResult = const_cast<const ::QtDataVisualization::QBarDataItem *>(cppSelf)->value();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QBarDataItem___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QtDataVisualization::QBarDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtDataVisualization_QBarDataItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QBarDataItem_methods[] = {
    {"createExtraData", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataItemFunc_createExtraData), METH_NOARGS},
    {"rotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataItemFunc_rotation), METH_NOARGS},
    {"setRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataItemFunc_setRotation), METH_O},
    {"setValue", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataItemFunc_setValue), METH_O},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataItemFunc_value), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataItem___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QtDataVisualization_QBarDataItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QBarDataItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QBarDataItem_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QBarDataItem_TypeF(void)
{
    return _Sbk_QtDataVisualization_QBarDataItem_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QBarDataItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QBarDataItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QBarDataItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QBarDataItem_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtDataVisualization_QBarDataItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QBarDataItem_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QBarDataItem_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBarDataItem_PythonToCpp_QBarDataItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QBarDataItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBarDataItem_PythonToCpp_QBarDataItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QBarDataItem_TypeF())))
        return QBarDataItem_PythonToCpp_QBarDataItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBarDataItem_PTR_CppToPython_QBarDataItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QtDataVisualization::QBarDataItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QtDataVisualization_QBarDataItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QBarDataItem_COPY_CppToPython_QBarDataItem(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QtDataVisualization_QBarDataItem_TypeF(), new ::QtDataVisualization::QBarDataItem(*reinterpret_cast<const ::QtDataVisualization::QBarDataItem *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QBarDataItem_PythonToCpp_QBarDataItem_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QBarDataItem *>(cppOut) = *reinterpret_cast< ::QtDataVisualization::QBarDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QBarDataItem_PythonToCpp_QBarDataItem_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QBarDataItem_TypeF())))
        return QBarDataItem_PythonToCpp_QBarDataItem_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_float_PythonToCpp_QtDataVisualization_QBarDataItem(PyObject *pyIn, void *cppOut) {
    float cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pyIn, &cppIn);
    *reinterpret_cast<::QtDataVisualization::QBarDataItem *>(cppOut) = ::QtDataVisualization::QBarDataItem(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_float_PythonToCpp_QtDataVisualization_QBarDataItem_Convertible(PyObject *pyIn) {
    if (PyFloat_Check(pyIn))
        return PySide2_QtCore_float_PythonToCpp_QtDataVisualization_QBarDataItem;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QBarDataItem_SignatureStrings[] = {
    "3:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem(self)",
    "2:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem(self,other:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem(self,value:float)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem(self,value:float,angle:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.createExtraData(self)",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.rotation(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.setRotation(self,angle:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.setValue(self,val:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.value(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem.__copy__()",
    nullptr}; // Sentinel

void init_QtDataVisualization_QBarDataItem(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QBarDataItem_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QBarDataItem",
        "QtDataVisualization::QBarDataItem",
        &Sbk_QtDataVisualization_QBarDataItem_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QBarDataItem >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QBarDataItem_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QBarDataItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QBarDataItem_Type), Sbk_QtDataVisualization_QBarDataItem_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QBarDataItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QBarDataItem_TypeF(),
        QBarDataItem_PythonToCpp_QBarDataItem_PTR,
        is_QBarDataItem_PythonToCpp_QBarDataItem_PTR_Convertible,
        QBarDataItem_PTR_CppToPython_QBarDataItem,
        QBarDataItem_COPY_CppToPython_QBarDataItem);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QBarDataItem");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QBarDataItem*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QBarDataItem&");
    Shiboken::Conversions::registerConverterName(converter, "QBarDataItem");
    Shiboken::Conversions::registerConverterName(converter, "QBarDataItem*");
    Shiboken::Conversions::registerConverterName(converter, "QBarDataItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QBarDataItem).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QBarDataItem_PythonToCpp_QBarDataItem_COPY,
        is_QBarDataItem_PythonToCpp_QBarDataItem_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_float_PythonToCpp_QtDataVisualization_QBarDataItem,
        is_PySide2_QtCore_float_PythonToCpp_QtDataVisualization_QBarDataItem_Convertible);

    qRegisterMetaType< ::QtDataVisualization::QBarDataItem >("QBarDataItem");
    qRegisterMetaType< ::QtDataVisualization::QBarDataItem >("QtDataVisualization::QBarDataItem");
}
