/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_Q3DSURFACEWRAPPER_H
#define SBK_Q3DSURFACEWRAPPER_H

#define protected public

#include <QtDataVisualization/q3dsurface.h>


// Extra includes
#include <qobject.h>
#include <QtGui/qsurfaceformat.h>
#include <QtGui/qwindow.h>
#include <QtDataVisualization/qsurface3dseries.h>
#include <QList>
#include <QtDataVisualization/qvalue3daxis.h>
#include <QtDataVisualization/qcustom3ditem.h>
#include <QtGui/qevent.h>
#include <qbytearray.h>
#include <QtDataVisualization/qabstract3dinputhandler.h>
#include <qcoreevent.h>
#include <QtDataVisualization/q3dtheme.h>
#include <QtGui/qvector3d.h>
#include <QtGui/qaccessible.h>
#include <qmetaobject.h>
#include <QtDataVisualization/q3dscene.h>
#include <qobjectdefs.h>
#include <QtDataVisualization/qabstract3daxis.h>
#include <QtGui/qimage.h>
#include <qsize.h>
#include <qlocale.h>
namespace PySide { class DynamicQMetaObject; }

class Q3DSurfaceWrapper : public QtDataVisualization::Q3DSurface
{
public:
    Q3DSurfaceWrapper(const ::QSurfaceFormat * format = nullptr, ::QWindow * parent = nullptr);
    ::QAccessibleInterface * accessibleRoot() const override;
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void exposeEvent(::QExposeEvent * event) override;
    void focusInEvent(::QFocusEvent * arg__1) override;
    ::QObject * focusObject() const override;
    void focusOutEvent(::QFocusEvent * arg__1) override;
    ::QSurfaceFormat format() const override;
    void hideEvent(::QHideEvent * arg__1) override;
    void keyPressEvent(::QKeyEvent * arg__1) override;
    void keyReleaseEvent(::QKeyEvent * arg__1) override;
    const ::QMetaObject * metaObject() const override;
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent(::QMouseEvent * event) override;
    void mousePressEvent(::QMouseEvent * event) override;
    void mouseReleaseEvent(::QMouseEvent * event) override;
    void moveEvent(::QMoveEvent * arg__1) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, long * result) override;
    void resizeEvent(::QResizeEvent * event) override;
    bool shadowsSupported() const override;
    void showEvent(::QShowEvent * arg__1) override;
    ::QSize size() const override;
    ::QSurface::SurfaceType surfaceType() const override;
    void tabletEvent(::QTabletEvent * arg__1) override;
    void timerEvent(::QTimerEvent * event) override;
    void touchEvent(::QTouchEvent * event) override;
    void wheelEvent(::QWheelEvent * event) override;
    ~Q3DSurfaceWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[32];
};

#endif // SBK_Q3DSURFACEWRAPPER_H

