/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qxmlstreamattributes_wrapper.h"

// inner classes

// Extra includes
#include <QVector>
#include <qxmlstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlStreamAttributes_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlStreamAttributes >()))
        return -1;

    ::QXmlStreamAttributes *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QXmlStreamAttributes", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::QXmlStreamAttributes()
    // 1: QXmlStreamAttributes::QXmlStreamAttributes(QXmlStreamAttributes)
    if (numArgs == 0) {
        overloadId = 0; // QXmlStreamAttributes()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QXmlStreamAttributes(QXmlStreamAttributes)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributes_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QXmlStreamAttributes()
        {

            if (!PyErr_Occurred()) {
                // QXmlStreamAttributes()
                cptr = new ::QXmlStreamAttributes();
            }
            break;
        }
        case 1: // QXmlStreamAttributes(const QXmlStreamAttributes & QXmlStreamAttributes)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlStreamAttributes cppArg0_local;
            ::QXmlStreamAttributes *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlStreamAttributes(QXmlStreamAttributes)
                cptr = new ::QXmlStreamAttributes(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlStreamAttributes >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QXmlStreamAttributes_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QXmlStreamAttributes_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_append(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.append";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "append", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::append(QString,QString,QString)
    // 1: QXmlStreamAttributes::append(QString,QString)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // append(QString,QString)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            overloadId = 0; // append(QString,QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_append_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // append(const QString & namespaceUri, const QString & name, const QString & value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // append(QString,QString,QString)
                cppSelf->append(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // append(const QString & qualifiedName, const QString & value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // append(QString,QString)
                cppSelf->append(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_append_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_at(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.at";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::at(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // at(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_at_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // at(int)const
            const QXmlStreamAttribute & cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->at(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_at_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_back(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.back";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // back()
            QXmlStreamAttribute & cppResult = cppSelf->back();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_capacity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.capacity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capacity()const
            int cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->capacity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_constData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.constData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // constData()const
            const QXmlStreamAttribute * cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->constData();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_constFirst(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.constFirst";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // constFirst()const
            const QXmlStreamAttribute & cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->constFirst();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_constLast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.constLast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // constLast()const
            const QXmlStreamAttribute & cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->constLast();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::contains(QXmlStreamAttribute)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
        overloadId = 0; // contains(QXmlStreamAttribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_contains_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // contains(QXmlStreamAttribute)const
            bool cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->contains(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_count(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.count";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "count", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::count()const
    // 1: QXmlStreamAttributes::count(QXmlStreamAttribute)const
    if (numArgs == 0) {
        overloadId = 0; // count()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // count(QXmlStreamAttribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_count_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // count() const
        {

            if (!PyErr_Occurred()) {
                // count()const
                int cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->count();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // count(const QXmlStreamAttribute & t) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QXmlStreamAttribute cppArg0_local;
            ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // count(QXmlStreamAttribute)const
                int cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->count(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_count_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()
            QXmlStreamAttribute * cppResult = cppSelf->data();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_empty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.empty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // empty()const
            bool cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->empty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_endsWith(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.endsWith";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::endsWith(QXmlStreamAttribute)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
        overloadId = 0; // endsWith(QXmlStreamAttribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_endsWith_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // endsWith(QXmlStreamAttribute)const
            bool cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->endsWith(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_endsWith_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_fill(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.fill";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamAttributesFunc_fill_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamAttributesFunc_fill_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fill", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::fill(QXmlStreamAttribute,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fill(QXmlStreamAttribute,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // fill(QXmlStreamAttribute,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_fill_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_size = Shiboken::String::createStaticString("size");
            if (PyDict_Contains(kwds, key_size)) {
                value = PyDict_GetItem(kwds, key_size);
                if (value && pyArgs[1]) {
                    errInfo = key_size;
                    Py_INCREF(errInfo);
                    goto Sbk_QXmlStreamAttributesFunc_fill_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QXmlStreamAttributesFunc_fill_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_size);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QXmlStreamAttributesFunc_fill_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fill(QXmlStreamAttribute,int)
            QVector<QXmlStreamAttribute > & cppResult = cppSelf->fill(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_fill_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_first(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.first";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // first()
            QXmlStreamAttribute & cppResult = cppSelf->first();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_front(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.front";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // front()
            QXmlStreamAttribute & cppResult = cppSelf->front();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_hasAttribute(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.hasAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "hasAttribute", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::hasAttribute(QString,QString)const
    // 1: QXmlStreamAttributes::hasAttribute(QString)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // hasAttribute(QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // hasAttribute(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_hasAttribute_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // hasAttribute(const QString & namespaceUri, const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // hasAttribute(QString,QString)const
                bool cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->hasAttribute(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // hasAttribute(const QString & qualifiedName) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // hasAttribute(QString)const
                bool cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->hasAttribute(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_hasAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_indexOf(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.indexOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamAttributesFunc_indexOf_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamAttributesFunc_indexOf_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:indexOf", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::indexOf(QXmlStreamAttribute,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // indexOf(QXmlStreamAttribute,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // indexOf(QXmlStreamAttribute,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_indexOf_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_from = Shiboken::String::createStaticString("from");
            if (PyDict_Contains(kwds, key_from)) {
                value = PyDict_GetItem(kwds, key_from);
                if (value && pyArgs[1]) {
                    errInfo = key_from;
                    Py_INCREF(errInfo);
                    goto Sbk_QXmlStreamAttributesFunc_indexOf_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QXmlStreamAttributesFunc_indexOf_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_from);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QXmlStreamAttributesFunc_indexOf_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // indexOf(QXmlStreamAttribute,int)const
            int cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->indexOf(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_indexOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_insert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.insert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insert", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::insert(int,QXmlStreamAttribute)
    // 1: QXmlStreamAttributes::insert(int,int,QXmlStreamAttribute)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArgs[2])))) {
            overloadId = 1; // insert(int,int,QXmlStreamAttribute)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArgs[1])))) {
            overloadId = 0; // insert(int,QXmlStreamAttribute)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_insert_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insert(int i, const QXmlStreamAttribute & t)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QXmlStreamAttribute cppArg1_local;
            ::QXmlStreamAttribute *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // insert(int,QXmlStreamAttribute)
                cppSelf->insert(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // insert(int i, int n, const QXmlStreamAttribute & t)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QXmlStreamAttribute cppArg2_local;
            ::QXmlStreamAttribute *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // insert(int,int,QXmlStreamAttribute)
                cppSelf->insert(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_insert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_isSharedWith(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.isSharedWith";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::isSharedWith(QVector<QXmlStreamAttribute>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], (pyArg)))) {
        overloadId = 0; // isSharedWith(QVector<QXmlStreamAttribute>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_isSharedWith_TypeError;

    // Call function/method
    {
        ::QVector<QXmlStreamAttribute > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isSharedWith(QVector<QXmlStreamAttribute>)const
            bool cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->isSharedWith(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_isSharedWith_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_last(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.last";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // last()
            QXmlStreamAttribute & cppResult = cppSelf->last();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_lastIndexOf(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.lastIndexOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamAttributesFunc_lastIndexOf_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamAttributesFunc_lastIndexOf_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:lastIndexOf", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::lastIndexOf(QXmlStreamAttribute,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // lastIndexOf(QXmlStreamAttribute,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // lastIndexOf(QXmlStreamAttribute,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_lastIndexOf_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_from = Shiboken::String::createStaticString("from");
            if (PyDict_Contains(kwds, key_from)) {
                value = PyDict_GetItem(kwds, key_from);
                if (value && pyArgs[1]) {
                    errInfo = key_from;
                    Py_INCREF(errInfo);
                    goto Sbk_QXmlStreamAttributesFunc_lastIndexOf_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QXmlStreamAttributesFunc_lastIndexOf_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_from);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QXmlStreamAttributesFunc_lastIndexOf_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // lastIndexOf(QXmlStreamAttribute,int)const
            int cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->lastIndexOf(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_lastIndexOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.length";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // length()const
            int cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->length();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_mid(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.mid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamAttributesFunc_mid_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamAttributesFunc_mid_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:mid", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::mid(int,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // mid(int,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // mid(int,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_mid_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_len = Shiboken::String::createStaticString("len");
            if (PyDict_Contains(kwds, key_len)) {
                value = PyDict_GetItem(kwds, key_len);
                if (value && pyArgs[1]) {
                    errInfo = key_len;
                    Py_INCREF(errInfo);
                    goto Sbk_QXmlStreamAttributesFunc_mid_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QXmlStreamAttributesFunc_mid_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_len);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QXmlStreamAttributesFunc_mid_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // mid(int,int)const
            QVector<QXmlStreamAttribute > cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->mid(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_mid_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_move(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.move";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "move", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::move(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // move(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_move_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // move(int,int)
            cppSelf->move(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_move_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_prepend(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.prepend";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::prepend(QXmlStreamAttribute)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
        overloadId = 0; // prepend(QXmlStreamAttribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_prepend_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // prepend(QXmlStreamAttribute)
            cppSelf->prepend(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_prepend_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_remove(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "remove", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::remove(int)
    // 1: QXmlStreamAttributes::remove(int,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // remove(int)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // remove(int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_remove_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // remove(int i)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // remove(int)
                cppSelf->remove(cppArg0);
            }
            break;
        }
        case 1: // remove(int i, int n)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // remove(int,int)
                cppSelf->remove(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_removeAll(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.removeAll";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::removeAll(QXmlStreamAttribute)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
        overloadId = 0; // removeAll(QXmlStreamAttribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_removeAll_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeAll(QXmlStreamAttribute)
            int cppResult = cppSelf->removeAll(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_removeAll_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_removeAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.removeAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::removeAt(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // removeAt(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_removeAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeAt(int)
            cppSelf->removeAt(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_removeAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_removeFirst(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.removeFirst";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeFirst()
            cppSelf->removeFirst();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_removeLast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.removeLast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeLast()
            cppSelf->removeLast();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_removeOne(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.removeOne";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::removeOne(QXmlStreamAttribute)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
        overloadId = 0; // removeOne(QXmlStreamAttribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_removeOne_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeOne(QXmlStreamAttribute)
            bool cppResult = cppSelf->removeOne(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_removeOne_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_replace(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.replace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::replace(int,QXmlStreamAttribute)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // replace(int,QXmlStreamAttribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_replace_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QXmlStreamAttribute cppArg1_local;
        ::QXmlStreamAttribute *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // replace(int,QXmlStreamAttribute)
            cppSelf->replace(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_replace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_reserve(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.reserve";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::reserve(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // reserve(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_reserve_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // reserve(int)
            cppSelf->reserve(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_reserve_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_resize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.resize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::resize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // resize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_resize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resize(int)
            cppSelf->resize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_resize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_setSharable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.setSharable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::setSharable(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSharable(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_setSharable_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSharable(bool)
            cppSelf->setSharable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_setSharable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_shrink_to_fit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.shrink_to_fit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shrink_to_fit()
            cppSelf->shrink_to_fit();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_squeeze(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.squeeze";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // squeeze()
            cppSelf->squeeze();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_startsWith(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.startsWith";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::startsWith(QXmlStreamAttribute)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
        overloadId = 0; // startsWith(QXmlStreamAttribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_startsWith_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // startsWith(QXmlStreamAttribute)const
            bool cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->startsWith(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_startsWith_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::swap(QVector<QXmlStreamAttribute>&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], (pyArg)))) {
        overloadId = 0; // swap(QVector<QXmlStreamAttribute>&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_swap_TypeError;

    // Call function/method
    {
        ::QVector<QXmlStreamAttribute > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // swap(QVector<QXmlStreamAttribute>&)
            cppSelf->swap(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_swapItemsAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.swapItemsAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "swapItemsAt", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::swapItemsAt(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // swapItemsAt(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_swapItemsAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // swapItemsAt(int,int)
            cppSelf->swapItemsAt(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamAttributesFunc_swapItemsAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_takeAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.takeAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::takeAt(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // takeAt(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_takeAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // takeAt(int)
            QXmlStreamAttribute cppResult = cppSelf->takeAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_takeAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc_takeFirst(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.takeFirst";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // takeFirst()
            QXmlStreamAttribute cppResult = cppSelf->takeFirst();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_takeLast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.takeLast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // takeLast()
            QXmlStreamAttribute cppResult = cppSelf->takeLast();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamAttributesFunc_value(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.value";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamAttributes::value(QString,QString)const
    // 1: QXmlStreamAttributes::value(QString)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // value(QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // value(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc_value_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // value(const QString & namespaceUri, const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // value(QString,QString)const
                QStringRef cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->value(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
            }
            break;
        }
        case 1: // value(const QString & qualifiedName) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // value(QString)const
                QStringRef cppResult = const_cast<const ::QXmlStreamAttributes *>(cppSelf)->value(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc_value_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributes___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QXmlStreamAttributes_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlStreamAttributes_methods[] = {
    {"append", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_append), METH_VARARGS},
    {"at", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_at), METH_O},
    {"back", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_back), METH_NOARGS},
    {"capacity", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_capacity), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_clear), METH_NOARGS},
    {"constData", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_constData), METH_NOARGS},
    {"constFirst", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_constFirst), METH_NOARGS},
    {"constLast", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_constLast), METH_NOARGS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_contains), METH_O},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_count), METH_VARARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_data), METH_NOARGS},
    {"empty", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_empty), METH_NOARGS},
    {"endsWith", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_endsWith), METH_O},
    {"fill", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_fill), METH_VARARGS|METH_KEYWORDS},
    {"first", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_first), METH_NOARGS},
    {"front", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_front), METH_NOARGS},
    {"hasAttribute", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_hasAttribute), METH_VARARGS},
    {"indexOf", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_indexOf), METH_VARARGS|METH_KEYWORDS},
    {"insert", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_insert), METH_VARARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_isEmpty), METH_NOARGS},
    {"isSharedWith", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_isSharedWith), METH_O},
    {"last", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_last), METH_NOARGS},
    {"lastIndexOf", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_lastIndexOf), METH_VARARGS|METH_KEYWORDS},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_length), METH_NOARGS},
    {"mid", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_mid), METH_VARARGS|METH_KEYWORDS},
    {"move", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_move), METH_VARARGS},
    {"prepend", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_prepend), METH_O},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_remove), METH_VARARGS},
    {"removeAll", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_removeAll), METH_O},
    {"removeAt", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_removeAt), METH_O},
    {"removeFirst", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_removeFirst), METH_NOARGS},
    {"removeLast", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_removeLast), METH_NOARGS},
    {"removeOne", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_removeOne), METH_O},
    {"replace", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_replace), METH_VARARGS},
    {"reserve", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_reserve), METH_O},
    {"resize", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_resize), METH_O},
    {"setSharable", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_setSharable), METH_O},
    {"shrink_to_fit", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_shrink_to_fit), METH_NOARGS},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_size), METH_NOARGS},
    {"squeeze", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_squeeze), METH_NOARGS},
    {"startsWith", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_startsWith), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_swap), METH_O},
    {"swapItemsAt", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_swapItemsAt), METH_VARARGS},
    {"takeAt", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_takeAt), METH_O},
    {"takeFirst", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_takeFirst), METH_NOARGS},
    {"takeLast", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_takeLast), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributesFunc_value), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamAttributes___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QXmlStreamAttributesFunc___add__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.__add__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::operator+(QVector<QXmlStreamAttribute>)const
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], (pyArg)))) {
        overloadId = 0; // operator+(QVector<QXmlStreamAttribute>)const
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc___add___TypeError;

    // Call function/method
    {
        ::QVector<QXmlStreamAttribute > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator+(QVector<QXmlStreamAttribute>)const
            QVector<QXmlStreamAttribute > cppResult = (*cppSelf) + cppArg0;
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc___add___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamAttributes::operator+=(QXmlStreamAttribute)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
        overloadId = 0; // operator+=(QXmlStreamAttribute)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc___iadd___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlStreamAttribute cppArg0_local;
        ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator+=(QXmlStreamAttribute)
            (*cppSelf) += (*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QXmlStreamAttributesFunc___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamAttributesFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamAttributes.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QXmlStreamAttributes::operator<<(QVector<QXmlStreamAttribute>)
        // 1: QXmlStreamAttributes::operator<<(QXmlStreamAttribute)
        if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
            overloadId = 1; // operator<<(QXmlStreamAttribute)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], (pyArg)))) {
            overloadId = 0; // operator<<(QVector<QXmlStreamAttribute>)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QXmlStreamAttributesFunc___lshift___TypeError;

        // Call function/method
        switch (overloadId) {
            case 0: // operator<<(const QVector<QXmlStreamAttribute > & l)
            {
                ::QVector<QXmlStreamAttribute > cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(QVector<QXmlStreamAttribute>)
                    QVector<QXmlStreamAttribute > & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], &cppResult);
                }
                break;
            }
            case 1: // operator<<(const QXmlStreamAttribute & t)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QXmlStreamAttribute cppArg0_local;
                ::QXmlStreamAttribute *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QXmlStreamAttribute)
                    QVector<QXmlStreamAttribute > & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], &cppResult);
                }
                break;
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamAttributesFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

Py_ssize_t Sbk_QXmlStreamAttributes__len__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return cppSelf->size();
}
PyObject *Sbk_QXmlStreamAttributes__getitem__(PyObject *self, Py_ssize_t _i)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (_i < 0 || _i >= (Py_ssize_t) cppSelf->size()) {
        PyErr_SetString(PyExc_IndexError, "index out of bounds");
        return 0;
    }
    QXmlStreamAttributes::const_iterator _item = cppSelf->begin();
    std::advance(_item, _i);
    return Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), &*_item);
}
int Sbk_QXmlStreamAttributes__setitem__(PyObject *self, Py_ssize_t _i, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (_i < 0 || _i >= (Py_ssize_t) cppSelf->size()) {
        PyErr_SetString(PyExc_IndexError, "list assignment index out of range");
        return -1;
    }
    PythonToCppFunc pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]), (pyArg)))) {
        PyErr_SetString(PyExc_TypeError, "attributed value with wrong type, 'QXmlStreamAttribute' or other convertible type expected");
        return -1;
    }
    if (!Shiboken::Object::isValid(pyArg))
        return -1;
    ::QXmlStreamAttribute cppValue;
    pythonToCpp(pyArg, &cppValue);
    QXmlStreamAttributes::iterator _item = cppSelf->begin();
    std::advance(_item, _i);
    *_item = cppValue;
    return {};
}
// Rich comparison
static PyObject * Sbk_QXmlStreamAttributes_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], (pyArg)))) {
                // operator!=(const QVector<QXmlStreamAttribute > & v) const
                ::QVector<QXmlStreamAttribute > cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMATTRIBUTE_IDX], (pyArg)))) {
                // operator==(const QVector<QXmlStreamAttribute > & v) const
                ::QVector<QXmlStreamAttribute > cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QXmlStreamAttributes_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QXmlStreamAttributes_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QXmlStreamAttributes_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlStreamAttributes_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlStreamAttributes_Type = nullptr;
static SbkObjectType *Sbk_QXmlStreamAttributes_TypeF(void)
{
    return _Sbk_QXmlStreamAttributes_Type;
}

static PyType_Slot Sbk_QXmlStreamAttributes_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlStreamAttributes_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlStreamAttributes_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QXmlStreamAttributes_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlStreamAttributes_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlStreamAttributes_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports sequence protocol
    {Py_sq_item, (void *)Sbk_QXmlStreamAttributes__getitem__},
    {Py_sq_ass_item, (void *)Sbk_QXmlStreamAttributes__setitem__},
    {Py_sq_length, (void *)Sbk_QXmlStreamAttributes__len__},
    // type supports number protocol
    {Py_nb_inplace_add, (void *)Sbk_QXmlStreamAttributesFunc___iadd__},
    {Py_nb_add, (void *)Sbk_QXmlStreamAttributesFunc___add__},
    {Py_nb_lshift, (void *)Sbk_QXmlStreamAttributesFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlStreamAttributes_spec = {
    "2:PySide2.QtCore.QXmlStreamAttributes",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlStreamAttributes_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlStreamAttributes_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamAttributes_TypeF())))
        return QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlStreamAttributes_PTR_CppToPython_QXmlStreamAttributes(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlStreamAttributes *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlStreamAttributes_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QXmlStreamAttributes_COPY_CppToPython_QXmlStreamAttributes(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QXmlStreamAttributes_TypeF(), new ::QXmlStreamAttributes(*reinterpret_cast<const ::QXmlStreamAttributes *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlStreamAttributes *>(cppOut) = *reinterpret_cast< ::QXmlStreamAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamAttributes_TypeF())))
        return QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlStreamAttributes_SignatureStrings[] = {
    "1:PySide2.QtCore.QXmlStreamAttributes(self)",
    "0:PySide2.QtCore.QXmlStreamAttributes(self,QXmlStreamAttributes:PySide2.QtCore.QXmlStreamAttributes)",
    "1:PySide2.QtCore.QXmlStreamAttributes.append(self,namespaceUri:QString,name:QString,value:QString)",
    "0:PySide2.QtCore.QXmlStreamAttributes.append(self,qualifiedName:QString,value:QString)",
    "PySide2.QtCore.QXmlStreamAttributes.at(self,i:int)->PySide2.QtCore.QXmlStreamAttribute",
    "1:PySide2.QtCore.QXmlStreamAttributes.back(self)->PySide2.QtCore.QXmlStreamAttribute",
    "0:PySide2.QtCore.QXmlStreamAttributes.back(self)->PySide2.QtCore.QXmlStreamAttribute",
    "PySide2.QtCore.QXmlStreamAttributes.capacity(self)->int",
    "PySide2.QtCore.QXmlStreamAttributes.clear(self)",
    "PySide2.QtCore.QXmlStreamAttributes.constData(self)->PySide2.QtCore.QXmlStreamAttribute",
    "PySide2.QtCore.QXmlStreamAttributes.constFirst(self)->PySide2.QtCore.QXmlStreamAttribute",
    "PySide2.QtCore.QXmlStreamAttributes.constLast(self)->PySide2.QtCore.QXmlStreamAttribute",
    "PySide2.QtCore.QXmlStreamAttributes.contains(self,t:PySide2.QtCore.QXmlStreamAttribute)->bool",
    "1:PySide2.QtCore.QXmlStreamAttributes.count(self)->int",
    "0:PySide2.QtCore.QXmlStreamAttributes.count(self,t:PySide2.QtCore.QXmlStreamAttribute)->int",
    "1:PySide2.QtCore.QXmlStreamAttributes.data(self)->PySide2.QtCore.QXmlStreamAttribute",
    "0:PySide2.QtCore.QXmlStreamAttributes.data(self)->PySide2.QtCore.QXmlStreamAttribute",
    "PySide2.QtCore.QXmlStreamAttributes.empty(self)->bool",
    "PySide2.QtCore.QXmlStreamAttributes.endsWith(self,t:PySide2.QtCore.QXmlStreamAttribute)->bool",
    "PySide2.QtCore.QXmlStreamAttributes.fill(self,t:PySide2.QtCore.QXmlStreamAttribute,size:int=-1)->QVector[PySide2.QtCore.QXmlStreamAttribute]",
    "1:PySide2.QtCore.QXmlStreamAttributes.first(self)->PySide2.QtCore.QXmlStreamAttribute",
    "0:PySide2.QtCore.QXmlStreamAttributes.first(self)->PySide2.QtCore.QXmlStreamAttribute",
    "1:PySide2.QtCore.QXmlStreamAttributes.front(self)->PySide2.QtCore.QXmlStreamAttribute",
    "0:PySide2.QtCore.QXmlStreamAttributes.front(self)->PySide2.QtCore.QXmlStreamAttribute",
    "1:PySide2.QtCore.QXmlStreamAttributes.hasAttribute(self,namespaceUri:QString,name:QString)->bool",
    "0:PySide2.QtCore.QXmlStreamAttributes.hasAttribute(self,qualifiedName:QString)->bool",
    "PySide2.QtCore.QXmlStreamAttributes.indexOf(self,t:PySide2.QtCore.QXmlStreamAttribute,from:int=0)->int",
    "1:PySide2.QtCore.QXmlStreamAttributes.insert(self,i:int,t:PySide2.QtCore.QXmlStreamAttribute)",
    "0:PySide2.QtCore.QXmlStreamAttributes.insert(self,i:int,n:int,t:PySide2.QtCore.QXmlStreamAttribute)",
    "PySide2.QtCore.QXmlStreamAttributes.isEmpty(self)->bool",
    "PySide2.QtCore.QXmlStreamAttributes.isSharedWith(self,other:QVector[PySide2.QtCore.QXmlStreamAttribute])->bool",
    "1:PySide2.QtCore.QXmlStreamAttributes.last(self)->PySide2.QtCore.QXmlStreamAttribute",
    "0:PySide2.QtCore.QXmlStreamAttributes.last(self)->PySide2.QtCore.QXmlStreamAttribute",
    "PySide2.QtCore.QXmlStreamAttributes.lastIndexOf(self,t:PySide2.QtCore.QXmlStreamAttribute,from:int=-1)->int",
    "PySide2.QtCore.QXmlStreamAttributes.length(self)->int",
    "PySide2.QtCore.QXmlStreamAttributes.mid(self,pos:int,len:int=-1)->QVector[PySide2.QtCore.QXmlStreamAttribute]",
    "PySide2.QtCore.QXmlStreamAttributes.move(self,from:int,to:int)",
    "PySide2.QtCore.QXmlStreamAttributes.prepend(self,t:PySide2.QtCore.QXmlStreamAttribute)",
    "1:PySide2.QtCore.QXmlStreamAttributes.remove(self,i:int)",
    "0:PySide2.QtCore.QXmlStreamAttributes.remove(self,i:int,n:int)",
    "PySide2.QtCore.QXmlStreamAttributes.removeAll(self,t:PySide2.QtCore.QXmlStreamAttribute)->int",
    "PySide2.QtCore.QXmlStreamAttributes.removeAt(self,i:int)",
    "PySide2.QtCore.QXmlStreamAttributes.removeFirst(self)",
    "PySide2.QtCore.QXmlStreamAttributes.removeLast(self)",
    "PySide2.QtCore.QXmlStreamAttributes.removeOne(self,t:PySide2.QtCore.QXmlStreamAttribute)->bool",
    "PySide2.QtCore.QXmlStreamAttributes.replace(self,i:int,t:PySide2.QtCore.QXmlStreamAttribute)",
    "PySide2.QtCore.QXmlStreamAttributes.reserve(self,size:int)",
    "PySide2.QtCore.QXmlStreamAttributes.resize(self,size:int)",
    "PySide2.QtCore.QXmlStreamAttributes.setSharable(self,sharable:bool)",
    "PySide2.QtCore.QXmlStreamAttributes.shrink_to_fit(self)",
    "PySide2.QtCore.QXmlStreamAttributes.size(self)->int",
    "PySide2.QtCore.QXmlStreamAttributes.squeeze(self)",
    "PySide2.QtCore.QXmlStreamAttributes.startsWith(self,t:PySide2.QtCore.QXmlStreamAttribute)->bool",
    "PySide2.QtCore.QXmlStreamAttributes.swap(self,other:QVector[PySide2.QtCore.QXmlStreamAttribute])",
    "PySide2.QtCore.QXmlStreamAttributes.swapItemsAt(self,i:int,j:int)",
    "PySide2.QtCore.QXmlStreamAttributes.takeAt(self,i:int)->PySide2.QtCore.QXmlStreamAttribute",
    "PySide2.QtCore.QXmlStreamAttributes.takeFirst(self)->PySide2.QtCore.QXmlStreamAttribute",
    "PySide2.QtCore.QXmlStreamAttributes.takeLast(self)->PySide2.QtCore.QXmlStreamAttribute",
    "1:PySide2.QtCore.QXmlStreamAttributes.value(self,namespaceUri:QString,name:QString)->QStringRef",
    "0:PySide2.QtCore.QXmlStreamAttributes.value(self,qualifiedName:QString)->QStringRef",
    "PySide2.QtCore.QXmlStreamAttributes.__copy__()",
    "PySide2.QtCore.QXmlStreamAttributes.__add__(self,l:QVector[PySide2.QtCore.QXmlStreamAttribute])->QVector[PySide2.QtCore.QXmlStreamAttribute]",
    "PySide2.QtCore.QXmlStreamAttributes.__iadd__(self,t:PySide2.QtCore.QXmlStreamAttribute)->QVector[PySide2.QtCore.QXmlStreamAttribute]",
    "1:PySide2.QtCore.QXmlStreamAttributes.__lshift__(self,l:QVector[PySide2.QtCore.QXmlStreamAttribute])->QVector[PySide2.QtCore.QXmlStreamAttribute]",
    "0:PySide2.QtCore.QXmlStreamAttributes.__lshift__(self,t:PySide2.QtCore.QXmlStreamAttribute)->QVector[PySide2.QtCore.QXmlStreamAttribute]",
    nullptr}; // Sentinel

void init_QXmlStreamAttributes(PyObject *module)
{
    _Sbk_QXmlStreamAttributes_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlStreamAttributes",
        "QXmlStreamAttributes",
        &Sbk_QXmlStreamAttributes_spec,
        &Shiboken::callCppDestructor< ::QXmlStreamAttributes >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlStreamAttributes_Type);
    InitSignatureStrings(pyType, QXmlStreamAttributes_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlStreamAttributes_Type), Sbk_QXmlStreamAttributes_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamAttributes_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlStreamAttributes_TypeF(),
        QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_PTR,
        is_QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_PTR_Convertible,
        QXmlStreamAttributes_PTR_CppToPython_QXmlStreamAttributes,
        QXmlStreamAttributes_COPY_CppToPython_QXmlStreamAttributes);

    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamAttributes");
    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamAttributes*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamAttributes&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlStreamAttributes).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_COPY,
        is_QXmlStreamAttributes_PythonToCpp_QXmlStreamAttributes_COPY_Convertible);

    qRegisterMetaType< ::QXmlStreamAttributes >("QXmlStreamAttributes");
}
