/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qversionnumber_wrapper.h"

// inner classes

// Extra includes
#include <QVector>
#include <qversionnumber.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QVersionNumber_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QVersionNumber >()))
        return -1;

    ::QVersionNumber *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVersionNumber", 0, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QVersionNumber::QVersionNumber()
    // 1: QVersionNumber::QVersionNumber(QVector<int>)
    // 2: QVersionNumber::QVersionNumber(int)
    // 3: QVersionNumber::QVersionNumber(int,int)
    // 4: QVersionNumber::QVersionNumber(int,int,int)
    if (numArgs == 0) {
        overloadId = 0; // QVersionNumber()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QVersionNumber(int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // QVersionNumber(int,int)
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 4; // QVersionNumber(int,int,int)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_INT_IDX], (pyArgs[0])))) {
        overloadId = 1; // QVersionNumber(QVector<int>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVersionNumber_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QVersionNumber()
        {

            if (!PyErr_Occurred()) {
                // QVersionNumber()
                cptr = new ::QVersionNumber();
            }
            break;
        }
        case 1: // QVersionNumber(const QVector<int > & seg)
        {
            ::QVector<int > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QVersionNumber(QVector<int>)
                cptr = new ::QVersionNumber(cppArg0);
            }
            break;
        }
        case 2: // QVersionNumber(int maj)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QVersionNumber(int)
                cptr = new ::QVersionNumber(cppArg0);
            }
            break;
        }
        case 3: // QVersionNumber(int maj, int min)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QVersionNumber(int,int)
                cptr = new ::QVersionNumber(cppArg0, cppArg1);
            }
            break;
        }
        case 4: // QVersionNumber(int maj, int min, int mic)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QVersionNumber(int,int,int)
                cptr = new ::QVersionNumber(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QVersionNumber >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QVersionNumber_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QVersionNumber_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QVersionNumberFunc_commonPrefix(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.commonPrefix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "commonPrefix", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QVersionNumber::commonPrefix(QVersionNumber,QVersionNumber)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArgs[1])))) {
        overloadId = 0; // commonPrefix(QVersionNumber,QVersionNumber)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVersionNumberFunc_commonPrefix_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QVersionNumber cppArg0_local;
        ::QVersionNumber *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QVersionNumber cppArg1_local;
        ::QVersionNumber *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // commonPrefix(QVersionNumber,QVersionNumber)
            QVersionNumber cppResult = ::QVersionNumber::commonPrefix(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVersionNumberFunc_commonPrefix_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVersionNumberFunc_compare(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.compare";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "compare", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QVersionNumber::compare(QVersionNumber,QVersionNumber)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArgs[1])))) {
        overloadId = 0; // compare(QVersionNumber,QVersionNumber)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVersionNumberFunc_compare_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QVersionNumber cppArg0_local;
        ::QVersionNumber *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QVersionNumber cppArg1_local;
        ::QVersionNumber *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // compare(QVersionNumber,QVersionNumber)
            int cppResult = ::QVersionNumber::compare(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVersionNumberFunc_compare_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVersionNumberFunc_fromString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.fromString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QVersionNumber::fromString(QString,int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fromString(QString,int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVersionNumberFunc_fromString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        int* removed_cppArg1 = nullptr;
        SBK_UNUSED(removed_cppArg1)

        if (!PyErr_Occurred()) {
            // fromString(QString,int*)
            QVersionNumber cppResult = ::QVersionNumber::fromString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVersionNumberFunc_fromString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVersionNumberFunc_isNormalized(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.isNormalized";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNormalized()const
            bool cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->isNormalized();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVersionNumberFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVersionNumberFunc_isPrefixOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.isPrefixOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVersionNumber::isPrefixOf(QVersionNumber)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArg)))) {
        overloadId = 0; // isPrefixOf(QVersionNumber)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVersionNumberFunc_isPrefixOf_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVersionNumber cppArg0_local;
        ::QVersionNumber *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isPrefixOf(QVersionNumber)const
            bool cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->isPrefixOf(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVersionNumberFunc_isPrefixOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVersionNumberFunc_majorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.majorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // majorVersion()const
            int cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->majorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVersionNumberFunc_microVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.microVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // microVersion()const
            int cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->microVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVersionNumberFunc_minorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.minorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minorVersion()const
            int cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->minorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVersionNumberFunc_normalized(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.normalized";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // normalized()const
            QVersionNumber cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->normalized();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVersionNumberFunc_segmentAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.segmentAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVersionNumber::segmentAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // segmentAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVersionNumberFunc_segmentAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // segmentAt(int)const
            int cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->segmentAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVersionNumberFunc_segmentAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVersionNumberFunc_segmentCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.segmentCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // segmentCount()const
            int cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->segmentCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVersionNumberFunc_segments(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.segments";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // segments()const
            QVector<int > cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->segments();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVersionNumberFunc_toString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QVersionNumber.toString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toString()const
            QString cppResult = const_cast<const ::QVersionNumber *>(cppSelf)->toString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVersionNumber___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QVersionNumber_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QVersionNumber_methods[] = {
    {"commonPrefix", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_commonPrefix), METH_VARARGS|METH_STATIC},
    {"compare", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_compare), METH_VARARGS|METH_STATIC},
    {"fromString", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_fromString), METH_O|METH_STATIC},
    {"isNormalized", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_isNormalized), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_isNull), METH_NOARGS},
    {"isPrefixOf", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_isPrefixOf), METH_O},
    {"majorVersion", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_majorVersion), METH_NOARGS},
    {"microVersion", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_microVersion), METH_NOARGS},
    {"minorVersion", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_minorVersion), METH_NOARGS},
    {"normalized", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_normalized), METH_NOARGS},
    {"segmentAt", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_segmentAt), METH_O},
    {"segmentCount", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_segmentCount), METH_NOARGS},
    {"segments", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_segments), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QVersionNumberFunc_toString), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QVersionNumber___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QVersionNumber___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QVersionNumber_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArg)))) {
                // operator!=(const QVersionNumber & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVersionNumber cppArg0_local;
                ::QVersionNumber *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArg)))) {
                // operator<(const QVersionNumber & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVersionNumber cppArg0_local;
                ::QVersionNumber *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QVersionNumber_RichComparison_TypeError;
            }

            break;
        case Py_LE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArg)))) {
                // operator<=(const QVersionNumber & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVersionNumber cppArg0_local;
                ::QVersionNumber *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QVersionNumber_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArg)))) {
                // operator==(const QVersionNumber & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVersionNumber cppArg0_local;
                ::QVersionNumber *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        case Py_GT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArg)))) {
                // operator>(const QVersionNumber & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVersionNumber cppArg0_local;
                ::QVersionNumber *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QVersionNumber_RichComparison_TypeError;
            }

            break;
        case Py_GE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArg)))) {
                // operator>=(const QVersionNumber & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVersionNumber cppArg0_local;
                ::QVersionNumber *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QVersionNumber_RichComparison_TypeError;
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QVersionNumber_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QVersionNumber_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QVersionNumber_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QVersionNumber_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QVersionNumber__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QVersionNumber_Type = nullptr;
static SbkObjectType *Sbk_QVersionNumber_TypeF(void)
{
    return _Sbk_QVersionNumber_Type;
}

static PyType_Slot Sbk_QVersionNumber_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QVersionNumber__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QVersionNumber_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QVersionNumber_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QVersionNumber_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QVersionNumber_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QVersionNumber_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QVersionNumber___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QVersionNumber___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QVersionNumber_spec = {
    "2:PySide2.QtCore.QVersionNumber",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QVersionNumber_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QVersionNumber_PythonToCpp_QVersionNumber_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QVersionNumber_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QVersionNumber_PythonToCpp_QVersionNumber_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVersionNumber_TypeF())))
        return QVersionNumber_PythonToCpp_QVersionNumber_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QVersionNumber_PTR_CppToPython_QVersionNumber(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QVersionNumber *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QVersionNumber_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QVersionNumber_COPY_CppToPython_QVersionNumber(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QVersionNumber_TypeF(), new ::QVersionNumber(*reinterpret_cast<const ::QVersionNumber *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QVersionNumber_PythonToCpp_QVersionNumber_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVersionNumber *>(cppOut) = *reinterpret_cast< ::QVersionNumber *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QVersionNumber_PythonToCpp_QVersionNumber_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVersionNumber_TypeF())))
        return QVersionNumber_PythonToCpp_QVersionNumber_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QVersionNumber_SignatureStrings[] = {
    "4:PySide2.QtCore.QVersionNumber(self)",
    "3:PySide2.QtCore.QVersionNumber(self,seg:QVector[int])",
    "2:PySide2.QtCore.QVersionNumber(self,maj:int)",
    "1:PySide2.QtCore.QVersionNumber(self,maj:int,min:int)",
    "0:PySide2.QtCore.QVersionNumber(self,maj:int,min:int,mic:int)",
    "PySide2.QtCore.QVersionNumber.commonPrefix(v1:PySide2.QtCore.QVersionNumber,v2:PySide2.QtCore.QVersionNumber)->PySide2.QtCore.QVersionNumber",
    "PySide2.QtCore.QVersionNumber.compare(v1:PySide2.QtCore.QVersionNumber,v2:PySide2.QtCore.QVersionNumber)->int",
    "PySide2.QtCore.QVersionNumber.fromString(string:QString,suffixIndex:int*=nullptr)->PySide2.QtCore.QVersionNumber",
    "PySide2.QtCore.QVersionNumber.isNormalized(self)->bool",
    "PySide2.QtCore.QVersionNumber.isNull(self)->bool",
    "PySide2.QtCore.QVersionNumber.isPrefixOf(self,other:PySide2.QtCore.QVersionNumber)->bool",
    "PySide2.QtCore.QVersionNumber.majorVersion(self)->int",
    "PySide2.QtCore.QVersionNumber.microVersion(self)->int",
    "PySide2.QtCore.QVersionNumber.minorVersion(self)->int",
    "PySide2.QtCore.QVersionNumber.normalized(self)->PySide2.QtCore.QVersionNumber",
    "PySide2.QtCore.QVersionNumber.segmentAt(self,index:int)->int",
    "PySide2.QtCore.QVersionNumber.segmentCount(self)->int",
    "PySide2.QtCore.QVersionNumber.segments(self)->QVector[int]",
    "PySide2.QtCore.QVersionNumber.toString(self)->QString",
    "PySide2.QtCore.QVersionNumber.__copy__()",
    nullptr}; // Sentinel

void init_QVersionNumber(PyObject *module)
{
    _Sbk_QVersionNumber_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QVersionNumber",
        "QVersionNumber",
        &Sbk_QVersionNumber_spec,
        &Shiboken::callCppDestructor< ::QVersionNumber >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QVersionNumber_Type);
    InitSignatureStrings(pyType, QVersionNumber_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QVersionNumber_Type), Sbk_QVersionNumber_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QVersionNumber_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QVersionNumber_TypeF(),
        QVersionNumber_PythonToCpp_QVersionNumber_PTR,
        is_QVersionNumber_PythonToCpp_QVersionNumber_PTR_Convertible,
        QVersionNumber_PTR_CppToPython_QVersionNumber,
        QVersionNumber_COPY_CppToPython_QVersionNumber);

    Shiboken::Conversions::registerConverterName(converter, "QVersionNumber");
    Shiboken::Conversions::registerConverterName(converter, "QVersionNumber*");
    Shiboken::Conversions::registerConverterName(converter, "QVersionNumber&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QVersionNumber).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QVersionNumber_PythonToCpp_QVersionNumber_COPY,
        is_QVersionNumber_PythonToCpp_QVersionNumber_COPY_Convertible);

    // Initialization of enums.

    qRegisterMetaType< ::QVersionNumber >("QVersionNumber");
}
