/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "quuid_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>
#include <quuid.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QUuid_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QUuid >()))
        return -1;

    ::QUuid *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 7 || numArgs == 8 || numArgs == 9 || numArgs == 10)
        goto Sbk_QUuid_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QUuid", 0, 11, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10])))
        return -1;


    // Overloaded function decisor
    // 0: QUuid::QUuid()
    // 1: QUuid::QUuid(QByteArray)
    // 2: QUuid::QUuid(QString)
    // 3: QUuid::QUuid(const char*)
    // 4: QUuid::QUuid(uint,ushort,ushort,uchar,uchar,uchar,uchar,uchar,uchar,uchar,uchar)
    if (numArgs == 0) {
        overloadId = 0; // QUuid()
    } else if (numArgs == 11
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[3])))
        && SbkChar_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[4])))
        && SbkChar_Check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[5])))
        && SbkChar_Check(pyArgs[6]) && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[6])))
        && SbkChar_Check(pyArgs[7]) && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[7])))
        && SbkChar_Check(pyArgs[8]) && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[8])))
        && SbkChar_Check(pyArgs[9]) && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[9])))
        && SbkChar_Check(pyArgs[10]) && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[10])))) {
        overloadId = 4; // QUuid(uint,ushort,ushort,uchar,uchar,uchar,uchar,uchar,uchar,uchar,uchar)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 3; // QUuid(const char*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 2; // QUuid(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QUuid(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUuid_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QUuid()
        {

            if (!PyErr_Occurred()) {
                // QUuid()
                cptr = new ::QUuid();
            }
            break;
        }
        case 1: // QUuid(const QByteArray & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QUuid(QByteArray)
                cptr = new ::QUuid(*cppArg0);
            }
            break;
        }
        case 2: // QUuid(const QString & arg__1)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QUuid(QString)
                cptr = new ::QUuid(cppArg0);
            }
            break;
        }
        case 3: // QUuid(const char * arg__1)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QUuid(const char*)
                cptr = new ::QUuid(cppArg0);
            }
            break;
        }
        case 4: // QUuid(uint l, ushort w1, ushort w2, uchar b1, uchar b2, uchar b3, uchar b4, uchar b5, uchar b6, uchar b7, uchar b8)
        {
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ushort cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ushort cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            uchar cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            uchar cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            uchar cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            uchar cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            uchar cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            uchar cppArg8;
            pythonToCpp[8](pyArgs[8], &cppArg8);
            uchar cppArg9;
            pythonToCpp[9](pyArgs[9], &cppArg9);
            uchar cppArg10;
            pythonToCpp[10](pyArgs[10], &cppArg10);

            if (!PyErr_Occurred()) {
                // QUuid(uint,ushort,ushort,uchar,uchar,uchar,uchar,uchar,uchar,uchar,uchar)
                cptr = new ::QUuid(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QUuid >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QUuid_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QUuid_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QUuidFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(s))", PyObject_Type(self), qPrintable(cppSelf->toString()));
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUuidFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s('%s')",
                Py_TYPE(self)->tp_name, qPrintable(cppSelf->toString()));
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUuidFunc_createUuid(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.createUuid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createUuid()
            QUuid cppResult = ::QUuid::createUuid();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUuidFunc_createUuidV3(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.createUuidV3";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createUuidV3", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QUuid::createUuidV3(QUuid,QByteArray)
    // 1: static QUuid::createUuidV3(QUuid,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // createUuidV3(QUuid,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 0; // createUuidV3(QUuid,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUuidFunc_createUuidV3_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createUuidV3(const QUuid & ns, const QByteArray & baseData)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUuid cppArg0_local;
            ::QUuid *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // createUuidV3(QUuid,QByteArray)
                QUuid cppResult = ::QUuid::createUuidV3(*cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), &cppResult);
            }
            break;
        }
        case 1: // createUuidV3(const QUuid & ns, const QString & baseData)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUuid cppArg0_local;
            ::QUuid *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // createUuidV3(QUuid,QString)
                QUuid cppResult = ::QUuid::createUuidV3(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUuidFunc_createUuidV3_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUuidFunc_createUuidV5(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.createUuidV5";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createUuidV5", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QUuid::createUuidV5(QUuid,QByteArray)
    // 1: static QUuid::createUuidV5(QUuid,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // createUuidV5(QUuid,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 0; // createUuidV5(QUuid,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUuidFunc_createUuidV5_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createUuidV5(const QUuid & ns, const QByteArray & baseData)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUuid cppArg0_local;
            ::QUuid *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // createUuidV5(QUuid,QByteArray)
                QUuid cppResult = ::QUuid::createUuidV5(*cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), &cppResult);
            }
            break;
        }
        case 1: // createUuidV5(const QUuid & ns, const QString & baseData)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUuid cppArg0_local;
            ::QUuid *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // createUuidV5(QUuid,QString)
                QUuid cppResult = ::QUuid::createUuidV5(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUuidFunc_createUuidV5_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUuidFunc_fromRfc4122(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.fromRfc4122";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QUuid::fromRfc4122(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // fromRfc4122(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUuidFunc_fromRfc4122_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // fromRfc4122(QByteArray)
            QUuid cppResult = ::QUuid::fromRfc4122(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUuidFunc_fromRfc4122_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUuidFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QUuid *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUuidFunc_toByteArray(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.toByteArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toByteArray", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUuid::toByteArray()const
    // 1: QUuid::toByteArray(QUuid::StringFormat)const
    if (numArgs == 0) {
        overloadId = 0; // toByteArray()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // toByteArray(QUuid::StringFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUuidFunc_toByteArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toByteArray() const
        {

            if (!PyErr_Occurred()) {
                // toByteArray()const
                QByteArray cppResult = const_cast<const ::QUuid *>(cppSelf)->toByteArray();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toByteArray(QUuid::StringFormat mode) const
        {
            ::QUuid::StringFormat cppArg0{QUuid::WithBraces};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toByteArray(QUuid::StringFormat)const
                QByteArray cppResult = const_cast<const ::QUuid *>(cppSelf)->toByteArray(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUuidFunc_toByteArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUuidFunc_toRfc4122(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.toRfc4122";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toRfc4122()const
            QByteArray cppResult = const_cast<const ::QUuid *>(cppSelf)->toRfc4122();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUuidFunc_toString(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toString", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUuid::toString()const
    // 1: QUuid::toString(QUuid::StringFormat)const
    if (numArgs == 0) {
        overloadId = 0; // toString()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // toString(QUuid::StringFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUuidFunc_toString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toString() const
        {

            if (!PyErr_Occurred()) {
                // toString()const
                QString cppResult = const_cast<const ::QUuid *>(cppSelf)->toString();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // toString(QUuid::StringFormat mode) const
        {
            ::QUuid::StringFormat cppArg0{QUuid::WithBraces};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(QUuid::StringFormat)const
                QString cppResult = const_cast<const ::QUuid *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUuidFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUuidFunc_variant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.variant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // variant()const
            QUuid::Variant cppResult = const_cast<const ::QUuid *>(cppSelf)->variant();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUuidFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUuid.version";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // version()const
            QUuid::Version cppResult = const_cast<const ::QUuid *>(cppSelf)->version();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUuid___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QUuid_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QUuid_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc___reduce__), METH_NOARGS},
    {"createUuid", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_createUuid), METH_NOARGS|METH_STATIC},
    {"createUuidV3", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_createUuidV3), METH_VARARGS|METH_STATIC},
    {"createUuidV5", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_createUuidV5), METH_VARARGS|METH_STATIC},
    {"fromRfc4122", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_fromRfc4122), METH_O|METH_STATIC},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_isNull), METH_NOARGS},
    {"toByteArray", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_toByteArray), METH_VARARGS},
    {"toRfc4122", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_toRfc4122), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_toString), METH_VARARGS},
    {"variant", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_variant), METH_NOARGS},
    {"version", reinterpret_cast<PyCFunction>(Sbk_QUuidFunc_version), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QUuid___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QUuid___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QUuid_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArg)))) {
                // operator!=(const QUuid & orig) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUuid cppArg0_local;
                ::QUuid *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArg)))) {
                // operator<(const QUuid & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUuid cppArg0_local;
                ::QUuid *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QUuid_RichComparison_TypeError;
            }

            break;
        case Py_LE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArg)))) {
                // operator<=(const QUuid & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUuid cppArg0_local;
                ::QUuid *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QUuid_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArg)))) {
                // operator==(const QUuid & orig) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUuid cppArg0_local;
                ::QUuid *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        case Py_GT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArg)))) {
                // operator>(const QUuid & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUuid cppArg0_local;
                ::QUuid *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QUuid_RichComparison_TypeError;
            }

            break;
        case Py_GE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArg)))) {
                // operator>=(const QUuid & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUuid cppArg0_local;
                ::QUuid *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QUuid_RichComparison_TypeError;
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QUuid_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QUuid_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QUuid_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QUuid_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QUuid_Type = nullptr;
static SbkObjectType *Sbk_QUuid_TypeF(void)
{
    return _Sbk_QUuid_Type;
}

static PyType_Slot Sbk_QUuid_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QUuidFunc___repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QUuid_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QUuid_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QUuid_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QUuid_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QUuid_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QUuid___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QUuid___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QUuid_spec = {
    "2:PySide2.QtCore.QUuid",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QUuid_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QUuid_Variant_PythonToCpp_QUuid_Variant(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUuid::Variant *>(cppOut) =
        static_cast<::QUuid::Variant>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QUuid_Variant_PythonToCpp_QUuid_Variant_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX]))
        return QUuid_Variant_PythonToCpp_QUuid_Variant;
    return {};
}
static PyObject *QUuid_Variant_CppToPython_QUuid_Variant(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QUuid::Variant *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX], castCppIn);

}

static void QUuid_Version_PythonToCpp_QUuid_Version(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUuid::Version *>(cppOut) =
        static_cast<::QUuid::Version>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QUuid_Version_PythonToCpp_QUuid_Version_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX]))
        return QUuid_Version_PythonToCpp_QUuid_Version;
    return {};
}
static PyObject *QUuid_Version_CppToPython_QUuid_Version(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QUuid::Version *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX], castCppIn);

}

static void QUuid_StringFormat_PythonToCpp_QUuid_StringFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUuid::StringFormat *>(cppOut) =
        static_cast<::QUuid::StringFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QUuid_StringFormat_PythonToCpp_QUuid_StringFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX]))
        return QUuid_StringFormat_PythonToCpp_QUuid_StringFormat;
    return {};
}
static PyObject *QUuid_StringFormat_CppToPython_QUuid_StringFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QUuid::StringFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QUuid_PythonToCpp_QUuid_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QUuid_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QUuid_PythonToCpp_QUuid_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QUuid_TypeF())))
        return QUuid_PythonToCpp_QUuid_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QUuid_PTR_CppToPython_QUuid(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QUuid *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QUuid_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QUuid_COPY_CppToPython_QUuid(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QUuid_TypeF(), new ::QUuid(*reinterpret_cast<const ::QUuid *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QUuid_PythonToCpp_QUuid_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUuid *>(cppOut) = *reinterpret_cast< ::QUuid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QUuid_PythonToCpp_QUuid_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QUuid_TypeF())))
        return QUuid_PythonToCpp_QUuid_COPY;
    return {};
}

// Implicit conversions.
static void constQByteArrayREF_PythonToCpp_QUuid(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUuid *>(cppOut) = ::QUuid( *reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQByteArrayREF_PythonToCpp_QUuid_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], pyIn))
        return constQByteArrayREF_PythonToCpp_QUuid;
    return {};
}

static void constQStringREF_PythonToCpp_QUuid(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QUuid *>(cppOut) = ::QUuid(cppIn);
}
static PythonToCppFunc is_constQStringREF_PythonToCpp_QUuid_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constQStringREF_PythonToCpp_QUuid;
    return {};
}

static void constcharPTR_PythonToCpp_QUuid(PyObject *pyIn, void *cppOut) {
    const char* cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), pyIn, &cppIn);
    *reinterpret_cast<::QUuid *>(cppOut) = ::QUuid(cppIn);
}
static PythonToCppFunc is_constcharPTR_PythonToCpp_QUuid_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constcharPTR_PythonToCpp_QUuid;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QUuid_SignatureStrings[] = {
    "4:PySide2.QtCore.QUuid(self)",
    "3:PySide2.QtCore.QUuid(self,arg__1:PySide2.QtCore.QByteArray)",
    "2:PySide2.QtCore.QUuid(self,arg__1:QString)",
    "1:PySide2.QtCore.QUuid(self,arg__1:char*)",
    "0:PySide2.QtCore.QUuid(self,l:uint,w1:ushort,w2:ushort,b1:uchar,b2:uchar,b3:uchar,b4:uchar,b5:uchar,b6:uchar,b7:uchar,b8:uchar)",
    "PySide2.QtCore.QUuid.__reduce__(self)->PyObject",
    "PySide2.QtCore.QUuid.__repr__(self)->PyObject",
    "PySide2.QtCore.QUuid.createUuid()->PySide2.QtCore.QUuid",
    "1:PySide2.QtCore.QUuid.createUuidV3(ns:PySide2.QtCore.QUuid,baseData:PySide2.QtCore.QByteArray)->PySide2.QtCore.QUuid",
    "0:PySide2.QtCore.QUuid.createUuidV3(ns:PySide2.QtCore.QUuid,baseData:QString)->PySide2.QtCore.QUuid",
    "1:PySide2.QtCore.QUuid.createUuidV5(ns:PySide2.QtCore.QUuid,baseData:PySide2.QtCore.QByteArray)->PySide2.QtCore.QUuid",
    "0:PySide2.QtCore.QUuid.createUuidV5(ns:PySide2.QtCore.QUuid,baseData:QString)->PySide2.QtCore.QUuid",
    "PySide2.QtCore.QUuid.fromRfc4122(arg__1:PySide2.QtCore.QByteArray)->PySide2.QtCore.QUuid",
    "PySide2.QtCore.QUuid.isNull(self)->bool",
    "1:PySide2.QtCore.QUuid.toByteArray(self)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QUuid.toByteArray(self,mode:PySide2.QtCore.QUuid.StringFormat)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QUuid.toRfc4122(self)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QUuid.toString(self)->QString",
    "0:PySide2.QtCore.QUuid.toString(self,mode:PySide2.QtCore.QUuid.StringFormat)->QString",
    "PySide2.QtCore.QUuid.variant(self)->PySide2.QtCore.QUuid.Variant",
    "PySide2.QtCore.QUuid.version(self)->PySide2.QtCore.QUuid.Version",
    "PySide2.QtCore.QUuid.__copy__()",
    nullptr}; // Sentinel

void init_QUuid(PyObject *module)
{
    _Sbk_QUuid_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QUuid",
        "QUuid",
        &Sbk_QUuid_spec,
        &Shiboken::callCppDestructor< ::QUuid >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QUuid_Type);
    InitSignatureStrings(pyType, QUuid_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QUuid_Type), Sbk_QUuid_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QUuid_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QUuid_TypeF(),
        QUuid_PythonToCpp_QUuid_PTR,
        is_QUuid_PythonToCpp_QUuid_PTR_Convertible,
        QUuid_PTR_CppToPython_QUuid,
        QUuid_COPY_CppToPython_QUuid);

    Shiboken::Conversions::registerConverterName(converter, "QUuid");
    Shiboken::Conversions::registerConverterName(converter, "QUuid*");
    Shiboken::Conversions::registerConverterName(converter, "QUuid&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QUuid).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QUuid_PythonToCpp_QUuid_COPY,
        is_QUuid_PythonToCpp_QUuid_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQByteArrayREF_PythonToCpp_QUuid,
        is_constQByteArrayREF_PythonToCpp_QUuid_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQStringREF_PythonToCpp_QUuid,
        is_constQStringREF_PythonToCpp_QUuid_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constcharPTR_PythonToCpp_QUuid,
        is_constcharPTR_PythonToCpp_QUuid_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Variant'.
    SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QUuid_TypeF(),
        "Variant",
        "2:PySide2.QtCore.QUuid.Variant",
        "QUuid::Variant");
    if (!SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX],
        Sbk_QUuid_TypeF(), "VarUnknown", (long) QUuid::Variant::VarUnknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX],
        Sbk_QUuid_TypeF(), "NCS", (long) QUuid::Variant::NCS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX],
        Sbk_QUuid_TypeF(), "DCE", (long) QUuid::Variant::DCE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX],
        Sbk_QUuid_TypeF(), "Microsoft", (long) QUuid::Variant::Microsoft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX],
        Sbk_QUuid_TypeF(), "Reserved", (long) QUuid::Variant::Reserved))
        return;
    // Register converter for enum 'QUuid::Variant'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX],
            QUuid_Variant_CppToPython_QUuid_Variant);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QUuid_Variant_PythonToCpp_QUuid_Variant,
            is_QUuid_Variant_PythonToCpp_QUuid_Variant_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QUUID_VARIANT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QUuid::Variant");
        Shiboken::Conversions::registerConverterName(converter, "Variant");
    }
    // End of 'Variant' enum.

    // Initialization of enum 'Version'.
    SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QUuid_TypeF(),
        "Version",
        "2:PySide2.QtCore.QUuid.Version",
        "QUuid::Version");
    if (!SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX],
        Sbk_QUuid_TypeF(), "VerUnknown", (long) QUuid::Version::VerUnknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX],
        Sbk_QUuid_TypeF(), "Time", (long) QUuid::Version::Time))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX],
        Sbk_QUuid_TypeF(), "EmbeddedPOSIX", (long) QUuid::Version::EmbeddedPOSIX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX],
        Sbk_QUuid_TypeF(), "Md5", (long) QUuid::Version::Md5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX],
        Sbk_QUuid_TypeF(), "Name", (long) QUuid::Version::Name))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX],
        Sbk_QUuid_TypeF(), "Random", (long) QUuid::Version::Random))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX],
        Sbk_QUuid_TypeF(), "Sha1", (long) QUuid::Version::Sha1))
        return;
    // Register converter for enum 'QUuid::Version'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX],
            QUuid_Version_CppToPython_QUuid_Version);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QUuid_Version_PythonToCpp_QUuid_Version,
            is_QUuid_Version_PythonToCpp_QUuid_Version_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QUUID_VERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QUuid::Version");
        Shiboken::Conversions::registerConverterName(converter, "Version");
    }
    // End of 'Version' enum.

    // Initialization of enum 'StringFormat'.
    SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QUuid_TypeF(),
        "StringFormat",
        "2:PySide2.QtCore.QUuid.StringFormat",
        "QUuid::StringFormat");
    if (!SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX],
        Sbk_QUuid_TypeF(), "WithBraces", (long) QUuid::StringFormat::WithBraces))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX],
        Sbk_QUuid_TypeF(), "WithoutBraces", (long) QUuid::StringFormat::WithoutBraces))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX],
        Sbk_QUuid_TypeF(), "Id128", (long) QUuid::StringFormat::Id128))
        return;
    // Register converter for enum 'QUuid::StringFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX],
            QUuid_StringFormat_CppToPython_QUuid_StringFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QUuid_StringFormat_PythonToCpp_QUuid_StringFormat,
            is_QUuid_StringFormat_PythonToCpp_QUuid_StringFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QUUID_STRINGFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QUuid::StringFormat");
        Shiboken::Conversions::registerConverterName(converter, "StringFormat");
    }
    // End of 'StringFormat' enum.

    qRegisterMetaType< ::QUuid >("QUuid");
    qRegisterMetaType< ::QUuid::Variant >("QUuid::Variant");
    qRegisterMetaType< ::QUuid::Version >("QUuid::Version");
    qRegisterMetaType< ::QUuid::StringFormat >("QUuid::StringFormat");
}
