/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QTEMPORARYFILEWRAPPER_H
#define SBK_QTEMPORARYFILEWRAPPER_H

#define protected public

#include <qtemporaryfile.h>


// Extra includes
#include <qobject.h>
#include <qtemporaryfile.h>
#include <qfile.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobjectdefs.h>
#include <qbytearray.h>
namespace PySide { class DynamicQMetaObject; }

class QTemporaryFileWrapper : public QTemporaryFile
{
public:
    QTemporaryFileWrapper();
    QTemporaryFileWrapper(::QObject * parent);
    QTemporaryFileWrapper(const ::QString & templateName);
    QTemporaryFileWrapper(const ::QString & templateName, ::QObject * parent);
    bool atEnd() const override;
    qint64 bytesAvailable() const override;
    qint64 bytesToWrite() const override;
    bool canReadLine() const override;
    void childEvent(::QChildEvent * event) override;
    void close() override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QString fileName() const override;
    bool isSequential() const override;
    const ::QMetaObject * metaObject() const override;
    bool open(::QFlags<QIODevice::OpenModeFlag> flags) override;
    ::QFlags<QFileDevice::Permission> permissions() const override;
    qint64 pos() const override;
    qint64 readData(char * data, qint64 maxlen) override;
    qint64 readLineData(char * data, qint64 maxlen) override;
    bool reset() override;
    bool resize(qint64 sz) override;
    bool seek(qint64 offset) override;
    bool setPermissions(::QFlags<QFileDevice::Permission> permissionSpec) override;
    qint64 size() const override;
    void timerEvent(::QTimerEvent * event) override;
    bool waitForBytesWritten(int msecs) override;
    bool waitForReadyRead(int msecs) override;
    qint64 writeData(const char * data, qint64 len) override;
    ~QTemporaryFileWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    // Inherited overloads, because the using keyword sux
    inline bool open() { return QTemporaryFile::open(); }
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[28];
};

#endif // SBK_QTEMPORARYFILEWRAPPER_H

