/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qrandomgenerator_wrapper.h"

// inner classes

// Extra includes
#include <qrandom.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRandomGenerator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRandomGenerator >()))
        return -1;

    ::QRandomGenerator *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRandomGenerator_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QRandomGenerator", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QRandomGenerator::QRandomGenerator(QRandomGenerator)
    // 1: QRandomGenerator::QRandomGenerator(const quint32*,const quint32*)
    // 2: QRandomGenerator::QRandomGenerator(const quint32*,long long)
    // 3: QRandomGenerator::QRandomGenerator(quint32)
    if (numArgs == 0) {
        overloadId = 3; // QRandomGenerator(quint32)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // QRandomGenerator(quint32)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
            overloadId = 2; // QRandomGenerator(const quint32*,long long)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[1])))) {
            overloadId = 1; // QRandomGenerator(const quint32*,const quint32*)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QRandomGenerator(QRandomGenerator)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRandomGenerator_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRandomGenerator(const QRandomGenerator & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRandomGenerator_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRandomGenerator *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QRandomGenerator(QRandomGenerator)
                cptr = new ::QRandomGenerator(*cppArg0);
            }
            break;
        }
        case 1: // QRandomGenerator(const quint32 * begin, const quint32 * end)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRandomGenerator_Init_TypeError;
            }
            quint32 *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            quint32 *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QRandomGenerator(const quint32*,const quint32*)
                cptr = new ::QRandomGenerator(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QRandomGenerator(const quint32 * seedBuffer, long long len)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRandomGenerator_Init_TypeError;
            }
            quint32 *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QRandomGenerator(const quint32*,long long)
                cptr = new ::QRandomGenerator(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QRandomGenerator(quint32 seedValue)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_seedValue = Shiboken::String::createStaticString("seedValue");
                if (PyDict_Contains(kwds, key_seedValue)) {
                    value = PyDict_GetItem(kwds, key_seedValue);
                    if (value && pyArgs[0]) {
                        errInfo = key_seedValue;
                        Py_INCREF(errInfo);
                        goto Sbk_QRandomGenerator_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0]))))
                            goto Sbk_QRandomGenerator_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_seedValue);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRandomGenerator_Init_TypeError;
                }
            }
            quint32 cppArg0 = 1;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QRandomGenerator(quint32)
                cptr = new ::QRandomGenerator(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRandomGenerator >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRandomGenerator_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QRandomGenerator_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRandomGeneratorFunc_bounded(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRandomGenerator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.bounded";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "bounded", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRandomGenerator::bounded(double)
    // 1: QRandomGenerator::bounded(int)
    // 2: QRandomGenerator::bounded(int,int)
    // 3: QRandomGenerator::bounded(quint32)
    // 4: QRandomGenerator::bounded(quint32,quint32)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // bounded(quint32)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[1])))) {
            overloadId = 4; // bounded(quint32,quint32)
        }
    } else if (numArgs == 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        overloadId = 0; // bounded(double)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // bounded(int)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 2; // bounded(int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRandomGeneratorFunc_bounded_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // bounded(double highest)
        {
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // bounded(double)
                double cppResult = cppSelf->bounded(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
            }
            break;
        }
        case 1: // bounded(int highest)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // bounded(int)
                int cppResult = cppSelf->bounded(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 2: // bounded(int lowest, int highest)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bounded(int,int)
                int cppResult = cppSelf->bounded(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 3: // bounded(quint32 highest)
        {
            quint32 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // bounded(quint32)
                quint32 cppResult = cppSelf->bounded(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
            }
            break;
        }
        case 4: // bounded(quint32 lowest, quint32 highest)
        {
            quint32 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            quint32 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bounded(quint32,quint32)
                quint32 cppResult = cppSelf->bounded(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRandomGeneratorFunc_bounded_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRandomGeneratorFunc_discard(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRandomGenerator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.discard";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRandomGenerator::discard(unsigned long long)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // discard(unsigned long long)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRandomGeneratorFunc_discard_TypeError;

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // discard(unsigned long long)
            cppSelf->discard(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRandomGeneratorFunc_discard_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRandomGeneratorFunc_generate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRandomGenerator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.generate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // generate()
            quint32 cppResult = cppSelf->generate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGeneratorFunc_generate64(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRandomGenerator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.generate64";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // generate64()
            quint64 cppResult = cppSelf->generate64();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGeneratorFunc_generateDouble(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRandomGenerator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.generateDouble";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // generateDouble()
            double cppResult = cppSelf->generateDouble();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGeneratorFunc_global_(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.global_";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // global()
            QRandomGenerator * cppResult = ::QRandomGenerator::global();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGeneratorFunc_max(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.max";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // max()
            unsigned int cppResult = ::QRandomGenerator::max();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGeneratorFunc_min(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.min";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // min()
            unsigned int cppResult = ::QRandomGenerator::min();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGeneratorFunc_securelySeeded(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.securelySeeded";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // securelySeeded()
            QRandomGenerator* cppResult = new QRandomGenerator(::QRandomGenerator::securelySeeded());
            pyResult = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX]), cppResult, true, true);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRandomGeneratorFunc_seed(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRandomGenerator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.seed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRandomGeneratorFunc_seed_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:seed", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRandomGenerator::seed(quint32)
    if (numArgs == 0) {
        overloadId = 0; // seed(quint32)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0])))) {
        overloadId = 0; // seed(quint32)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRandomGeneratorFunc_seed_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_s = Shiboken::String::createStaticString("s");
            if (PyDict_Contains(kwds, key_s)) {
                value = PyDict_GetItem(kwds, key_s);
                if (value && pyArgs[0]) {
                    errInfo = key_s;
                    Py_INCREF(errInfo);
                    goto Sbk_QRandomGeneratorFunc_seed_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0]))))
                        goto Sbk_QRandomGeneratorFunc_seed_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_s);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRandomGeneratorFunc_seed_TypeError;
            }
        }
        quint32 cppArg0 = 1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // seed(quint32)
            cppSelf->seed(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRandomGeneratorFunc_seed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRandomGeneratorFunc_system(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRandomGenerator.system";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // system()
            QRandomGenerator * cppResult = ::QRandomGenerator::system();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRandomGenerator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRandomGenerator_methods[] = {
    {"bounded", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_bounded), METH_VARARGS},
    {"discard", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_discard), METH_O},
    {"generate", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_generate), METH_NOARGS},
    {"generate64", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_generate64), METH_NOARGS},
    {"generateDouble", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_generateDouble), METH_NOARGS},
    {"global_", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_global_), METH_NOARGS|METH_STATIC},
    {"max", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_max), METH_NOARGS|METH_STATIC},
    {"min", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_min), METH_NOARGS|METH_STATIC},
    {"securelySeeded", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_securelySeeded), METH_NOARGS|METH_STATIC},
    {"seed", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_seed), METH_VARARGS|METH_KEYWORDS},
    {"system", reinterpret_cast<PyCFunction>(Sbk_QRandomGeneratorFunc_system), METH_NOARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QRandomGenerator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRandomGenerator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRandomGenerator_Type = nullptr;
static SbkObjectType *Sbk_QRandomGenerator_TypeF(void)
{
    return _Sbk_QRandomGenerator_Type;
}

static PyType_Slot Sbk_QRandomGenerator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRandomGenerator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRandomGenerator_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRandomGenerator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRandomGenerator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRandomGenerator_spec = {
    "2:PySide2.QtCore.QRandomGenerator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRandomGenerator_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRandomGenerator_PythonToCpp_QRandomGenerator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRandomGenerator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRandomGenerator_PythonToCpp_QRandomGenerator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRandomGenerator_TypeF())))
        return QRandomGenerator_PythonToCpp_QRandomGenerator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRandomGenerator_PTR_CppToPython_QRandomGenerator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QRandomGenerator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QRandomGenerator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRandomGenerator_SignatureStrings[] = {
    "3:PySide2.QtCore.QRandomGenerator(self,other:PySide2.QtCore.QRandomGenerator)",
    "2:PySide2.QtCore.QRandomGenerator(self,begin:quint32*,end:quint32*)",
    "1:PySide2.QtCore.QRandomGenerator(self,seedBuffer:quint32*,len:long long)",
    "0:PySide2.QtCore.QRandomGenerator(self,seedValue:quint32=1)",
    "4:PySide2.QtCore.QRandomGenerator.bounded(self,highest:double)->double",
    "3:PySide2.QtCore.QRandomGenerator.bounded(self,highest:int)->int",
    "2:PySide2.QtCore.QRandomGenerator.bounded(self,lowest:int,highest:int)->int",
    "1:PySide2.QtCore.QRandomGenerator.bounded(self,highest:quint32)->quint32",
    "0:PySide2.QtCore.QRandomGenerator.bounded(self,lowest:quint32,highest:quint32)->quint32",
    "PySide2.QtCore.QRandomGenerator.discard(self,z:unsigned long long)",
    "PySide2.QtCore.QRandomGenerator.generate(self)->quint32",
    "PySide2.QtCore.QRandomGenerator.generate64(self)->quint64",
    "PySide2.QtCore.QRandomGenerator.generateDouble(self)->double",
    "PySide2.QtCore.QRandomGenerator.global_()->PySide2.QtCore.QRandomGenerator",
    "PySide2.QtCore.QRandomGenerator.max()->unsigned int",
    "PySide2.QtCore.QRandomGenerator.min()->unsigned int",
    "PySide2.QtCore.QRandomGenerator.securelySeeded()->PySide2.QtCore.QRandomGenerator",
    "PySide2.QtCore.QRandomGenerator.seed(self,s:quint32=1)",
    "PySide2.QtCore.QRandomGenerator.system()->PySide2.QtCore.QRandomGenerator",
    nullptr}; // Sentinel

void init_QRandomGenerator(PyObject *module)
{
    _Sbk_QRandomGenerator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRandomGenerator",
        "QRandomGenerator*",
        &Sbk_QRandomGenerator_spec,
        &Shiboken::callCppDestructor< ::QRandomGenerator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRandomGenerator_Type);
    InitSignatureStrings(pyType, QRandomGenerator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRandomGenerator_Type), Sbk_QRandomGenerator_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QRANDOMGENERATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRandomGenerator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRandomGenerator_TypeF(),
        QRandomGenerator_PythonToCpp_QRandomGenerator_PTR,
        is_QRandomGenerator_PythonToCpp_QRandomGenerator_PTR_Convertible,
        QRandomGenerator_PTR_CppToPython_QRandomGenerator);

    Shiboken::Conversions::registerConverterName(converter, "QRandomGenerator");
    Shiboken::Conversions::registerConverterName(converter, "QRandomGenerator*");
    Shiboken::Conversions::registerConverterName(converter, "QRandomGenerator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRandomGenerator).name());


}
