/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmetaproperty_wrapper.h"

// inner classes

// Extra includes
#include <qmetaobject.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMetaProperty_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMetaProperty >()))
        return -1;

    ::QMetaProperty *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMetaProperty", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMetaProperty::QMetaProperty()
    // 1: QMetaProperty::QMetaProperty(QMetaProperty)
    if (numArgs == 0) {
        overloadId = 0; // QMetaProperty()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QMetaProperty(QMetaProperty)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaProperty_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMetaProperty()
        {

            if (!PyErr_Occurred()) {
                // QMetaProperty()
                cptr = new ::QMetaProperty();
            }
            break;
        }
        case 1: // QMetaProperty(const QMetaProperty & QMetaProperty)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMetaProperty cppArg0_local;
            ::QMetaProperty *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMetaProperty(QMetaProperty)
                cptr = new ::QMetaProperty(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMetaProperty >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMetaProperty_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMetaProperty_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMetaPropertyFunc_enumerator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.enumerator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // enumerator()const
            QMetaEnum cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->enumerator();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_hasNotifySignal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.hasNotifySignal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasNotifySignal()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->hasNotifySignal();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_hasStdCppSet(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.hasStdCppSet";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasStdCppSet()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->hasStdCppSet();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_isConstant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isConstant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isConstant()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isConstant();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_isDesignable(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isDesignable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMetaPropertyFunc_isDesignable_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:isDesignable", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QMetaProperty::isDesignable(const QObject*)const
    if (numArgs == 0) {
        overloadId = 0; // isDesignable(const QObject*)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // isDesignable(const QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_isDesignable_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_obj = Shiboken::String::createStaticString("obj");
            if (PyDict_Contains(kwds, key_obj)) {
                value = PyDict_GetItem(kwds, key_obj);
                if (value && pyArgs[0]) {
                    errInfo = key_obj;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaPropertyFunc_isDesignable_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QMetaPropertyFunc_isDesignable_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_obj);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMetaPropertyFunc_isDesignable_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // isDesignable(const QObject*)const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isDesignable(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_isDesignable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_isEditable(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isEditable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMetaPropertyFunc_isEditable_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:isEditable", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QMetaProperty::isEditable(const QObject*)const
    if (numArgs == 0) {
        overloadId = 0; // isEditable(const QObject*)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // isEditable(const QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_isEditable_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_obj = Shiboken::String::createStaticString("obj");
            if (PyDict_Contains(kwds, key_obj)) {
                value = PyDict_GetItem(kwds, key_obj);
                if (value && pyArgs[0]) {
                    errInfo = key_obj;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaPropertyFunc_isEditable_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QMetaPropertyFunc_isEditable_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_obj);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMetaPropertyFunc_isEditable_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // isEditable(const QObject*)const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isEditable(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_isEditable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_isEnumType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isEnumType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEnumType()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isEnumType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_isFinal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isFinal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinal()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isFinal();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_isFlagType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isFlagType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFlagType()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isFlagType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_isReadable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isReadable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadable()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isReadable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_isRequired(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isRequired";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRequired()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isRequired();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_isResettable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isResettable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isResettable()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isResettable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_isScriptable(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isScriptable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMetaPropertyFunc_isScriptable_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:isScriptable", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QMetaProperty::isScriptable(const QObject*)const
    if (numArgs == 0) {
        overloadId = 0; // isScriptable(const QObject*)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // isScriptable(const QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_isScriptable_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_obj = Shiboken::String::createStaticString("obj");
            if (PyDict_Contains(kwds, key_obj)) {
                value = PyDict_GetItem(kwds, key_obj);
                if (value && pyArgs[0]) {
                    errInfo = key_obj;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaPropertyFunc_isScriptable_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QMetaPropertyFunc_isScriptable_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_obj);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMetaPropertyFunc_isScriptable_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // isScriptable(const QObject*)const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isScriptable(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_isScriptable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_isStored(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isStored";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMetaPropertyFunc_isStored_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:isStored", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QMetaProperty::isStored(const QObject*)const
    if (numArgs == 0) {
        overloadId = 0; // isStored(const QObject*)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // isStored(const QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_isStored_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_obj = Shiboken::String::createStaticString("obj");
            if (PyDict_Contains(kwds, key_obj)) {
                value = PyDict_GetItem(kwds, key_obj);
                if (value && pyArgs[0]) {
                    errInfo = key_obj;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaPropertyFunc_isStored_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QMetaPropertyFunc_isStored_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_obj);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMetaPropertyFunc_isStored_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // isStored(const QObject*)const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isStored(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_isStored_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_isUser(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isUser";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMetaPropertyFunc_isUser_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:isUser", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QMetaProperty::isUser(const QObject*)const
    if (numArgs == 0) {
        overloadId = 0; // isUser(const QObject*)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // isUser(const QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_isUser_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_obj = Shiboken::String::createStaticString("obj");
            if (PyDict_Contains(kwds, key_obj)) {
                value = PyDict_GetItem(kwds, key_obj);
                if (value && pyArgs[0]) {
                    errInfo = key_obj;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaPropertyFunc_isUser_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QMetaPropertyFunc_isUser_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_obj);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMetaPropertyFunc_isUser_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // isUser(const QObject*)const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isUser(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_isUser_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_isWritable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.isWritable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isWritable()const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->isWritable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            const char * cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_notifySignal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.notifySignal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // notifySignal()const
            QMetaMethod cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->notifySignal();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_notifySignalIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.notifySignalIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // notifySignalIndex()const
            int cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->notifySignalIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_propertyIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.propertyIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // propertyIndex()const
            int cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->propertyIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_read(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.read";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaProperty::read(const QObject*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // read(const QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_read_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // read(const QObject*)const
            QVariant cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->read(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_read_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_readOnGadget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.readOnGadget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaProperty::readOnGadget(const void*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArg)))) {
        overloadId = 0; // readOnGadget(const void*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_readOnGadget_TypeError;

    // Call function/method
    {
        void* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readOnGadget(const void*)const
            QVariant cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->readOnGadget(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_readOnGadget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_relativePropertyIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.relativePropertyIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // relativePropertyIndex()const
            int cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->relativePropertyIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_reset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.reset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaProperty::reset(QObject*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // reset(QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_reset_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // reset(QObject*)const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->reset(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_reset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_resetOnGadget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.resetOnGadget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaProperty::resetOnGadget(void*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArg)))) {
        overloadId = 0; // resetOnGadget(void*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_resetOnGadget_TypeError;

    // Call function/method
    {
        void* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resetOnGadget(void*)const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->resetOnGadget(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_resetOnGadget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_revision(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.revision";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // revision()const
            int cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->revision();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QVariant::Type cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_TYPE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_typeName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.typeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // typeName()const
            const char * cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->typeName();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_userType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.userType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // userType()const
            int cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->userType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaPropertyFunc_write(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.write";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "write", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMetaProperty::write(QObject*,QVariant)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // write(QObject*,QVariant)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_write_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // write(QObject*,QVariant)const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->write(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_write_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaPropertyFunc_writeOnGadget(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaProperty.writeOnGadget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "writeOnGadget", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMetaProperty::writeOnGadget(void*,QVariant)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // writeOnGadget(void*,QVariant)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaPropertyFunc_writeOnGadget_TypeError;

    // Call function/method
    {
        void* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // writeOnGadget(void*,QVariant)const
            bool cppResult = const_cast<const ::QMetaProperty *>(cppSelf)->writeOnGadget(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaPropertyFunc_writeOnGadget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaProperty___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMetaProperty_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMetaProperty_methods[] = {
    {"enumerator", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_enumerator), METH_NOARGS},
    {"hasNotifySignal", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_hasNotifySignal), METH_NOARGS},
    {"hasStdCppSet", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_hasStdCppSet), METH_NOARGS},
    {"isConstant", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isConstant), METH_NOARGS},
    {"isDesignable", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isDesignable), METH_VARARGS|METH_KEYWORDS},
    {"isEditable", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isEditable), METH_VARARGS|METH_KEYWORDS},
    {"isEnumType", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isEnumType), METH_NOARGS},
    {"isFinal", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isFinal), METH_NOARGS},
    {"isFlagType", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isFlagType), METH_NOARGS},
    {"isReadable", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isReadable), METH_NOARGS},
    {"isRequired", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isRequired), METH_NOARGS},
    {"isResettable", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isResettable), METH_NOARGS},
    {"isScriptable", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isScriptable), METH_VARARGS|METH_KEYWORDS},
    {"isStored", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isStored), METH_VARARGS|METH_KEYWORDS},
    {"isUser", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isUser), METH_VARARGS|METH_KEYWORDS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isValid), METH_NOARGS},
    {"isWritable", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_isWritable), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_name), METH_NOARGS},
    {"notifySignal", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_notifySignal), METH_NOARGS},
    {"notifySignalIndex", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_notifySignalIndex), METH_NOARGS},
    {"propertyIndex", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_propertyIndex), METH_NOARGS},
    {"read", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_read), METH_O},
    {"readOnGadget", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_readOnGadget), METH_O},
    {"relativePropertyIndex", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_relativePropertyIndex), METH_NOARGS},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_reset), METH_O},
    {"resetOnGadget", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_resetOnGadget), METH_O},
    {"revision", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_revision), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_type), METH_NOARGS},
    {"typeName", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_typeName), METH_NOARGS},
    {"userType", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_userType), METH_NOARGS},
    {"write", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_write), METH_VARARGS},
    {"writeOnGadget", reinterpret_cast<PyCFunction>(Sbk_QMetaPropertyFunc_writeOnGadget), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMetaProperty___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QMetaProperty_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMetaProperty_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMetaProperty_Type = nullptr;
static SbkObjectType *Sbk_QMetaProperty_TypeF(void)
{
    return _Sbk_QMetaProperty_Type;
}

static PyType_Slot Sbk_QMetaProperty_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMetaProperty_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMetaProperty_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMetaProperty_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMetaProperty_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMetaProperty_spec = {
    "2:PySide2.QtCore.QMetaProperty",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMetaProperty_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMetaProperty_PythonToCpp_QMetaProperty_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMetaProperty_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMetaProperty_PythonToCpp_QMetaProperty_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMetaProperty_TypeF())))
        return QMetaProperty_PythonToCpp_QMetaProperty_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMetaProperty_PTR_CppToPython_QMetaProperty(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMetaProperty *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMetaProperty_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMetaProperty_COPY_CppToPython_QMetaProperty(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMetaProperty_TypeF(), new ::QMetaProperty(*reinterpret_cast<const ::QMetaProperty *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMetaProperty_PythonToCpp_QMetaProperty_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMetaProperty *>(cppOut) = *reinterpret_cast< ::QMetaProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMetaProperty_PythonToCpp_QMetaProperty_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMetaProperty_TypeF())))
        return QMetaProperty_PythonToCpp_QMetaProperty_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMetaProperty_SignatureStrings[] = {
    "1:PySide2.QtCore.QMetaProperty(self)",
    "0:PySide2.QtCore.QMetaProperty(self,QMetaProperty:PySide2.QtCore.QMetaProperty)",
    "PySide2.QtCore.QMetaProperty.enumerator(self)->PySide2.QtCore.QMetaEnum",
    "PySide2.QtCore.QMetaProperty.hasNotifySignal(self)->bool",
    "PySide2.QtCore.QMetaProperty.hasStdCppSet(self)->bool",
    "PySide2.QtCore.QMetaProperty.isConstant(self)->bool",
    "PySide2.QtCore.QMetaProperty.isDesignable(self,obj:PySide2.QtCore.QObject=nullptr)->bool",
    "PySide2.QtCore.QMetaProperty.isEditable(self,obj:PySide2.QtCore.QObject=nullptr)->bool",
    "PySide2.QtCore.QMetaProperty.isEnumType(self)->bool",
    "PySide2.QtCore.QMetaProperty.isFinal(self)->bool",
    "PySide2.QtCore.QMetaProperty.isFlagType(self)->bool",
    "PySide2.QtCore.QMetaProperty.isReadable(self)->bool",
    "PySide2.QtCore.QMetaProperty.isRequired(self)->bool",
    "PySide2.QtCore.QMetaProperty.isResettable(self)->bool",
    "PySide2.QtCore.QMetaProperty.isScriptable(self,obj:PySide2.QtCore.QObject=nullptr)->bool",
    "PySide2.QtCore.QMetaProperty.isStored(self,obj:PySide2.QtCore.QObject=nullptr)->bool",
    "PySide2.QtCore.QMetaProperty.isUser(self,obj:PySide2.QtCore.QObject=nullptr)->bool",
    "PySide2.QtCore.QMetaProperty.isValid(self)->bool",
    "PySide2.QtCore.QMetaProperty.isWritable(self)->bool",
    "PySide2.QtCore.QMetaProperty.name(self)->char*",
    "PySide2.QtCore.QMetaProperty.notifySignal(self)->PySide2.QtCore.QMetaMethod",
    "PySide2.QtCore.QMetaProperty.notifySignalIndex(self)->int",
    "PySide2.QtCore.QMetaProperty.propertyIndex(self)->int",
    "PySide2.QtCore.QMetaProperty.read(self,obj:PySide2.QtCore.QObject)->QVariant",
    "PySide2.QtCore.QMetaProperty.readOnGadget(self,gadget:void)->QVariant",
    "PySide2.QtCore.QMetaProperty.relativePropertyIndex(self)->int",
    "PySide2.QtCore.QMetaProperty.reset(self,obj:PySide2.QtCore.QObject)->bool",
    "PySide2.QtCore.QMetaProperty.resetOnGadget(self,gadget:void)->bool",
    "PySide2.QtCore.QMetaProperty.revision(self)->int",
    "PySide2.QtCore.QMetaProperty.type(self)->QVariant.Type",
    "PySide2.QtCore.QMetaProperty.typeName(self)->char*",
    "PySide2.QtCore.QMetaProperty.userType(self)->int",
    "PySide2.QtCore.QMetaProperty.write(self,obj:PySide2.QtCore.QObject,value:QVariant)->bool",
    "PySide2.QtCore.QMetaProperty.writeOnGadget(self,gadget:void,value:QVariant)->bool",
    "PySide2.QtCore.QMetaProperty.__copy__()",
    nullptr}; // Sentinel

void init_QMetaProperty(PyObject *module)
{
    _Sbk_QMetaProperty_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMetaProperty",
        "QMetaProperty",
        &Sbk_QMetaProperty_spec,
        &Shiboken::callCppDestructor< ::QMetaProperty >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMetaProperty_Type);
    InitSignatureStrings(pyType, QMetaProperty_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMetaProperty_Type), Sbk_QMetaProperty_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMetaProperty_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMetaProperty_TypeF(),
        QMetaProperty_PythonToCpp_QMetaProperty_PTR,
        is_QMetaProperty_PythonToCpp_QMetaProperty_PTR_Convertible,
        QMetaProperty_PTR_CppToPython_QMetaProperty,
        QMetaProperty_COPY_CppToPython_QMetaProperty);

    Shiboken::Conversions::registerConverterName(converter, "QMetaProperty");
    Shiboken::Conversions::registerConverterName(converter, "QMetaProperty*");
    Shiboken::Conversions::registerConverterName(converter, "QMetaProperty&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMetaProperty).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMetaProperty_PythonToCpp_QMetaProperty_COPY,
        is_QMetaProperty_PythonToCpp_QMetaProperty_COPY_Convertible);

    qRegisterMetaType< ::QMetaProperty >("QMetaProperty");
}
