/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmetaobject_wrapper.h"

// inner classes
#include "qmetaobject_connection_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMetaObject_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMetaObject >()))
        return -1;

    ::QMetaObject *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QMetaObject()
            cptr = new ::QMetaObject();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMetaObject >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QMetaObjectFunc_cast(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.cast";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::cast(QObject*)const
    // 1: QMetaObject::cast(const QObject*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // cast(QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_cast_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // cast(QObject * obj) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QObject *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // cast(QObject*)const
                QObject * cppResult = const_cast<const ::QMetaObject *>(cppSelf)->cast(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // cast(const QObject * obj) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QObject *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // cast(const QObject*)const
                const QObject * cppResult = const_cast<const ::QMetaObject *>(cppSelf)->cast(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_cast_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_checkConnectArgs(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.checkConnectArgs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "checkConnectArgs", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QMetaObject::checkConnectArgs(QMetaMethod,QMetaMethod)
    // 1: static QMetaObject::checkConnectArgs(const char*,const char*)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 1; // checkConnectArgs(const char*,const char*)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), (pyArgs[1])))) {
        overloadId = 0; // checkConnectArgs(QMetaMethod,QMetaMethod)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_checkConnectArgs_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // checkConnectArgs(const QMetaMethod & signal, const QMetaMethod & method)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMetaMethod cppArg0_local;
            ::QMetaMethod *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMetaMethod cppArg1_local;
            ::QMetaMethod *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // checkConnectArgs(QMetaMethod,QMetaMethod)
                bool cppResult = ::QMetaObject::checkConnectArgs(*cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // checkConnectArgs(const char * signal, const char * method)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // checkConnectArgs(const char*,const char*)
                bool cppResult = ::QMetaObject::checkConnectArgs(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_checkConnectArgs_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_classInfo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.classInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::classInfo(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // classInfo(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_classInfo_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // classInfo(int)const
            QMetaClassInfo cppResult = const_cast<const ::QMetaObject *>(cppSelf)->classInfo(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETACLASSINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_classInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_classInfoCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.classInfoCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // classInfoCount()const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->classInfoCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_classInfoOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.classInfoOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // classInfoOffset()const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->classInfoOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_className(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.className";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // className()const
            const char * cppResult = const_cast<const ::QMetaObject *>(cppSelf)->className();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_connectSlotsByName(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.connectSlotsByName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QMetaObject::connectSlotsByName(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // connectSlotsByName(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_connectSlotsByName_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // connectSlotsByName(QObject*)
            ::QMetaObject::connectSlotsByName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMetaObjectFunc_connectSlotsByName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_constructor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.constructor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::constructor(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // constructor(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_constructor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // constructor(int)const
            QMetaMethod cppResult = const_cast<const ::QMetaObject *>(cppSelf)->constructor(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_constructor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_constructorCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.constructorCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // constructorCount()const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->constructorCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_disconnect(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.disconnect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "disconnect", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QMetaObject::disconnect(const QObject*,int,const QObject*,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // disconnect(const QObject*,int,const QObject*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_disconnect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QObject *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // disconnect(const QObject*,int,const QObject*,int)
            bool cppResult = ::QMetaObject::disconnect(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_disconnect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_disconnectOne(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.disconnectOne";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "disconnectOne", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QMetaObject::disconnectOne(const QObject*,int,const QObject*,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // disconnectOne(const QObject*,int,const QObject*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_disconnectOne_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QObject *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // disconnectOne(const QObject*,int,const QObject*,int)
            bool cppResult = ::QMetaObject::disconnectOne(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_disconnectOne_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_enumerator(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.enumerator";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::enumerator(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // enumerator(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_enumerator_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // enumerator(int)const
            QMetaEnum cppResult = const_cast<const ::QMetaObject *>(cppSelf)->enumerator(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAENUM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_enumerator_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_enumeratorCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.enumeratorCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // enumeratorCount()const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->enumeratorCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_enumeratorOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.enumeratorOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // enumeratorOffset()const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->enumeratorOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_indexOfClassInfo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.indexOfClassInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::indexOfClassInfo(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // indexOfClassInfo(const char*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_indexOfClassInfo_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // indexOfClassInfo(const char*)const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->indexOfClassInfo(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_indexOfClassInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_indexOfConstructor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.indexOfConstructor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::indexOfConstructor(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // indexOfConstructor(const char*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_indexOfConstructor_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // indexOfConstructor(const char*)const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->indexOfConstructor(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_indexOfConstructor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_indexOfEnumerator(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.indexOfEnumerator";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::indexOfEnumerator(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // indexOfEnumerator(const char*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_indexOfEnumerator_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // indexOfEnumerator(const char*)const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->indexOfEnumerator(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_indexOfEnumerator_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_indexOfMethod(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.indexOfMethod";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::indexOfMethod(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // indexOfMethod(const char*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_indexOfMethod_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // indexOfMethod(const char*)const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->indexOfMethod(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_indexOfMethod_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_indexOfProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.indexOfProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::indexOfProperty(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // indexOfProperty(const char*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_indexOfProperty_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // indexOfProperty(const char*)const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->indexOfProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_indexOfProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_indexOfSignal(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.indexOfSignal";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::indexOfSignal(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // indexOfSignal(const char*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_indexOfSignal_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // indexOfSignal(const char*)const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->indexOfSignal(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_indexOfSignal_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_indexOfSlot(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.indexOfSlot";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::indexOfSlot(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // indexOfSlot(const char*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_indexOfSlot_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // indexOfSlot(const char*)const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->indexOfSlot(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_indexOfSlot_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_inherits(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.inherits";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::inherits(const QMetaObject*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // inherits(const QMetaObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_inherits_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMetaObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inherits(const QMetaObject*)const
            bool cppResult = const_cast<const ::QMetaObject *>(cppSelf)->inherits(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_inherits_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_invokeMethod(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.invokeMethod";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 14) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOOOOOOOOO:invokeMethod", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10]), &(pyArgs[11]), &(pyArgs[12]), &(pyArgs[13])))
        return {};


    // Overloaded function decisor
    // 0: static QMetaObject::invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
    // 1: static QMetaObject::invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
    // 2: static QMetaObject::invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
    // 3: static QMetaObject::invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                    if (numArgs == 5) {
                        overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                    } else if (numArgs >= 6
                        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                        if (numArgs == 6) {
                            overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                        } else if (numArgs >= 7
                            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                            if (numArgs == 7) {
                                overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                            } else if (numArgs >= 8
                                && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                if (numArgs == 8) {
                                    overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                } else if (numArgs >= 9
                                    && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                    if (numArgs == 9) {
                                        overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                    } else if (numArgs >= 10
                                        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                        if (numArgs == 10) {
                                            overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                        } else if (numArgs >= 11
                                            && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                            if (numArgs == 11) {
                                                overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                            } else if (numArgs >= 12
                                                && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11])))) {
                                                if (numArgs == 12) {
                                                    overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                } else if (numArgs >= 13
                                                    && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[12])))) {
                                                    if (numArgs == 13) {
                                                        overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                    } else if (numArgs >= 14
                                                        && (pythonToCpp[13] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[13])))) {
                                                        overloadId = 2; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                    if (numArgs == 5) {
                        overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                    } else if (numArgs >= 6
                        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                        if (numArgs == 6) {
                            overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                        } else if (numArgs >= 7
                            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                            if (numArgs == 7) {
                                overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                            } else if (numArgs >= 8
                                && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                if (numArgs == 8) {
                                    overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                } else if (numArgs >= 9
                                    && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                    if (numArgs == 9) {
                                        overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                    } else if (numArgs >= 10
                                        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                        if (numArgs == 10) {
                                            overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                        } else if (numArgs >= 11
                                            && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                            if (numArgs == 11) {
                                                overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                            } else if (numArgs >= 12
                                                && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11])))) {
                                                if (numArgs == 12) {
                                                    overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                } else if (numArgs >= 13
                                                    && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[12])))) {
                                                    overloadId = 3; // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                    if (numArgs == 5) {
                        overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                    } else if (numArgs >= 6
                        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                        if (numArgs == 6) {
                            overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                        } else if (numArgs >= 7
                            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                            if (numArgs == 7) {
                                overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                            } else if (numArgs >= 8
                                && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                if (numArgs == 8) {
                                    overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                } else if (numArgs >= 9
                                    && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                    if (numArgs == 9) {
                                        overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                    } else if (numArgs >= 10
                                        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                        if (numArgs == 10) {
                                            overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                        } else if (numArgs >= 11
                                            && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                            if (numArgs == 11) {
                                                overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                            } else if (numArgs >= 12
                                                && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11])))) {
                                                if (numArgs == 12) {
                                                    overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                } else if (numArgs >= 13
                                                    && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[12])))) {
                                                    overloadId = 1; // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                    if (numArgs == 5) {
                        overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                    } else if (numArgs >= 6
                        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                        if (numArgs == 6) {
                            overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                        } else if (numArgs >= 7
                            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                            if (numArgs == 7) {
                                overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                            } else if (numArgs >= 8
                                && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                if (numArgs == 8) {
                                    overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                } else if (numArgs >= 9
                                    && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                    if (numArgs == 9) {
                                        overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                    } else if (numArgs >= 10
                                        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                        if (numArgs == 10) {
                                            overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                        } else if (numArgs >= 11
                                            && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                            if (numArgs == 11) {
                                                overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                            } else if (numArgs >= 12
                                                && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11])))) {
                                                overloadId = 0; // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // invokeMethod(QObject * obj, const char * member, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[2]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[3]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[4]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[5]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[6]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[7]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[8]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[9]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[10]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[11]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QGenericArgument cppArg2 = QGenericArgument(nullptr);
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericArgument cppArg3 = QGenericArgument();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);
            if (!Shiboken::Object::isValid(pyArgs[11]))
                return {};
            ::QGenericArgument cppArg11 = QGenericArgument();
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);

            if (!PyErr_Occurred()) {
                // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = ::QMetaObject::invokeMethod(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // invokeMethod(QObject * obj, const char * member, QGenericReturnArgument ret, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[3]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[4]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[5]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[6]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[7]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[8]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[9]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[10]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[11]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[12]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[12] = value;
                        if (!(pythonToCpp[12] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[12]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QGenericReturnArgument cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericArgument cppArg3 = QGenericArgument(nullptr);
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);
            if (!Shiboken::Object::isValid(pyArgs[11]))
                return {};
            ::QGenericArgument cppArg11 = QGenericArgument();
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);
            if (!Shiboken::Object::isValid(pyArgs[12]))
                return {};
            ::QGenericArgument cppArg12 = QGenericArgument();
            if (pythonToCpp[12]) pythonToCpp[12](pyArgs[12], &cppArg12);

            if (!PyErr_Occurred()) {
                // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = ::QMetaObject::invokeMethod(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // invokeMethod(QObject * obj, const char * member, Qt::ConnectionType arg__3, QGenericReturnArgument ret, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[4]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[5]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[6]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[7]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[8]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[9]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[10]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[11]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[12]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[12] = value;
                        if (!(pythonToCpp[12] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[12]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[13]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[13] = value;
                        if (!(pythonToCpp[13] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[13]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::ConnectionType cppArg2{Qt::AutoConnection};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericReturnArgument cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument(nullptr);
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);
            if (!Shiboken::Object::isValid(pyArgs[11]))
                return {};
            ::QGenericArgument cppArg11 = QGenericArgument();
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);
            if (!Shiboken::Object::isValid(pyArgs[12]))
                return {};
            ::QGenericArgument cppArg12 = QGenericArgument();
            if (pythonToCpp[12]) pythonToCpp[12](pyArgs[12], &cppArg12);
            if (!Shiboken::Object::isValid(pyArgs[13]))
                return {};
            ::QGenericArgument cppArg13 = QGenericArgument();
            if (pythonToCpp[13]) pythonToCpp[13](pyArgs[13], &cppArg13);

            if (!PyErr_Occurred()) {
                // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = ::QMetaObject::invokeMethod(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12, cppArg13);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 3: // invokeMethod(QObject * obj, const char * member, Qt::ConnectionType type, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[3]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[4]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[5]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[6]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[7]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[8]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[9]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[10]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[11]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[12]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    if (value) {
                        pyArgs[12] = value;
                        if (!(pythonToCpp[12] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[12]))))
                            goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaObjectFunc_invokeMethod_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::ConnectionType cppArg2{Qt::AutoConnection};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericArgument cppArg3 = QGenericArgument(nullptr);
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);
            if (!Shiboken::Object::isValid(pyArgs[11]))
                return {};
            ::QGenericArgument cppArg11 = QGenericArgument();
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);
            if (!Shiboken::Object::isValid(pyArgs[12]))
                return {};
            ::QGenericArgument cppArg12 = QGenericArgument();
            if (pythonToCpp[12]) pythonToCpp[12](pyArgs[12], &cppArg12);

            if (!PyErr_Occurred()) {
                // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = ::QMetaObject::invokeMethod(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_invokeMethod_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_method(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.method";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::method(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // method(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_method_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // method(int)const
            QMetaMethod cppResult = const_cast<const ::QMetaObject *>(cppSelf)->method(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_method_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_methodCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.methodCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // methodCount()const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->methodCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_methodOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.methodOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // methodOffset()const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->methodOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_newInstance(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.newInstance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 10) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOOOOO:newInstance", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QMetaObject::newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
    if (numArgs == 0) {
        overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                                if (numArgs == 7) {
                                    overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                } else if (numArgs >= 8
                                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                    if (numArgs == 8) {
                                        overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                    } else if (numArgs >= 9
                                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                        if (numArgs == 9) {
                                            overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                        } else if (numArgs >= 10
                                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                            overloadId = 0; // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_newInstance_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
            if (PyDict_Contains(kwds, key_val0)) {
                value = PyDict_GetItem(kwds, key_val0);
                if (value && pyArgs[0]) {
                    errInfo = key_val0;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[0]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val0);
            }
            static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
            if (PyDict_Contains(kwds, key_val1)) {
                value = PyDict_GetItem(kwds, key_val1);
                if (value && pyArgs[1]) {
                    errInfo = key_val1;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[1]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val1);
            }
            static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
            if (PyDict_Contains(kwds, key_val2)) {
                value = PyDict_GetItem(kwds, key_val2);
                if (value && pyArgs[2]) {
                    errInfo = key_val2;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val2);
            }
            static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
            if (PyDict_Contains(kwds, key_val3)) {
                value = PyDict_GetItem(kwds, key_val3);
                if (value && pyArgs[3]) {
                    errInfo = key_val3;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val3);
            }
            static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
            if (PyDict_Contains(kwds, key_val4)) {
                value = PyDict_GetItem(kwds, key_val4);
                if (value && pyArgs[4]) {
                    errInfo = key_val4;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val4);
            }
            static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
            if (PyDict_Contains(kwds, key_val5)) {
                value = PyDict_GetItem(kwds, key_val5);
                if (value && pyArgs[5]) {
                    errInfo = key_val5;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val5);
            }
            static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
            if (PyDict_Contains(kwds, key_val6)) {
                value = PyDict_GetItem(kwds, key_val6);
                if (value && pyArgs[6]) {
                    errInfo = key_val6;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[6] = value;
                    if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val6);
            }
            static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
            if (PyDict_Contains(kwds, key_val7)) {
                value = PyDict_GetItem(kwds, key_val7);
                if (value && pyArgs[7]) {
                    errInfo = key_val7;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[7] = value;
                    if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val7);
            }
            static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
            if (PyDict_Contains(kwds, key_val8)) {
                value = PyDict_GetItem(kwds, key_val8);
                if (value && pyArgs[8]) {
                    errInfo = key_val8;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[8] = value;
                    if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val8);
            }
            static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
            if (PyDict_Contains(kwds, key_val9)) {
                value = PyDict_GetItem(kwds, key_val9);
                if (value && pyArgs[9]) {
                    errInfo = key_val9;
                    Py_INCREF(errInfo);
                    goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                if (value) {
                    pyArgs[9] = value;
                    if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                        goto Sbk_QMetaObjectFunc_newInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_val9);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMetaObjectFunc_newInstance_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGenericArgument cppArg0 = QGenericArgument(nullptr);
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QGenericArgument cppArg1 = QGenericArgument();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QGenericArgument cppArg2 = QGenericArgument();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QGenericArgument cppArg3 = QGenericArgument();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QGenericArgument cppArg4 = QGenericArgument();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::QGenericArgument cppArg5 = QGenericArgument();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
        if (!Shiboken::Object::isValid(pyArgs[6]))
            return {};
        ::QGenericArgument cppArg6 = QGenericArgument();
        if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
        if (!Shiboken::Object::isValid(pyArgs[7]))
            return {};
        ::QGenericArgument cppArg7 = QGenericArgument();
        if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
        if (!Shiboken::Object::isValid(pyArgs[8]))
            return {};
        ::QGenericArgument cppArg8 = QGenericArgument();
        if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
        if (!Shiboken::Object::isValid(pyArgs[9]))
            return {};
        ::QGenericArgument cppArg9 = QGenericArgument();
        if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
            QObject * cppResult = const_cast<const ::QMetaObject *>(cppSelf)->newInstance(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_newInstance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_normalizedSignature(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.normalizedSignature";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QMetaObject::normalizedSignature(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // normalizedSignature(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_normalizedSignature_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // normalizedSignature(const char*)
            QByteArray cppResult = ::QMetaObject::normalizedSignature(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_normalizedSignature_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_normalizedType(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.normalizedType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QMetaObject::normalizedType(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // normalizedType(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_normalizedType_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // normalizedType(const char*)
            QByteArray cppResult = ::QMetaObject::normalizedType(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_normalizedType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_property(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.property";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaObject::property(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // property(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaObjectFunc_property_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // property(int)const
            QMetaProperty cppResult = const_cast<const ::QMetaObject *>(cppSelf)->property(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaObjectFunc_property_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaObjectFunc_propertyCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.propertyCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // propertyCount()const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->propertyCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_propertyOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.propertyOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // propertyOffset()const
            int cppResult = const_cast<const ::QMetaObject *>(cppSelf)->propertyOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_superClass(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.superClass";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // superClass()const
            const QMetaObject * cppResult = const_cast<const ::QMetaObject *>(cppSelf)->superClass();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaObjectFunc_userProperty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaObject.userProperty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // userProperty()const
            QMetaProperty cppResult = const_cast<const ::QMetaObject *>(cppSelf)->userProperty();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMetaObject_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMetaObject_methods[] = {
    {"cast", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_cast), METH_O},
    {"checkConnectArgs", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_checkConnectArgs), METH_VARARGS|METH_STATIC},
    {"classInfo", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_classInfo), METH_O},
    {"classInfoCount", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_classInfoCount), METH_NOARGS},
    {"classInfoOffset", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_classInfoOffset), METH_NOARGS},
    {"className", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_className), METH_NOARGS},
    {"connectSlotsByName", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_connectSlotsByName), METH_O|METH_STATIC},
    {"constructor", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_constructor), METH_O},
    {"constructorCount", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_constructorCount), METH_NOARGS},
    {"disconnect", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_disconnect), METH_VARARGS|METH_STATIC},
    {"disconnectOne", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_disconnectOne), METH_VARARGS|METH_STATIC},
    {"enumerator", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_enumerator), METH_O},
    {"enumeratorCount", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_enumeratorCount), METH_NOARGS},
    {"enumeratorOffset", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_enumeratorOffset), METH_NOARGS},
    {"indexOfClassInfo", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_indexOfClassInfo), METH_O},
    {"indexOfConstructor", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_indexOfConstructor), METH_O},
    {"indexOfEnumerator", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_indexOfEnumerator), METH_O},
    {"indexOfMethod", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_indexOfMethod), METH_O},
    {"indexOfProperty", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_indexOfProperty), METH_O},
    {"indexOfSignal", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_indexOfSignal), METH_O},
    {"indexOfSlot", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_indexOfSlot), METH_O},
    {"inherits", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_inherits), METH_O},
    {"invokeMethod", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_invokeMethod), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"method", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_method), METH_O},
    {"methodCount", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_methodCount), METH_NOARGS},
    {"methodOffset", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_methodOffset), METH_NOARGS},
    {"newInstance", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_newInstance), METH_VARARGS|METH_KEYWORDS},
    {"normalizedSignature", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_normalizedSignature), METH_O|METH_STATIC},
    {"normalizedType", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_normalizedType), METH_O|METH_STATIC},
    {"property", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_property), METH_O},
    {"propertyCount", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_propertyCount), METH_NOARGS},
    {"propertyOffset", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_propertyOffset), METH_NOARGS},
    {"superClass", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_superClass), METH_NOARGS},
    {"userProperty", reinterpret_cast<PyCFunction>(Sbk_QMetaObjectFunc_userProperty), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QMetaObject_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMetaObject_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMetaObject_Type = nullptr;
static SbkObjectType *Sbk_QMetaObject_TypeF(void)
{
    return _Sbk_QMetaObject_Type;
}

static PyType_Slot Sbk_QMetaObject_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMetaObject_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMetaObject_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMetaObject_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMetaObject_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMetaObject_spec = {
    "2:PySide2.QtCore.QMetaObject",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMetaObject_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QMetaObject_Call_PythonToCpp_QMetaObject_Call(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMetaObject::Call *>(cppOut) =
        static_cast<::QMetaObject::Call>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMetaObject_Call_PythonToCpp_QMetaObject_Call_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX]))
        return QMetaObject_Call_PythonToCpp_QMetaObject_Call;
    return {};
}
static PyObject *QMetaObject_Call_CppToPython_QMetaObject_Call(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMetaObject::Call *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMetaObject_PythonToCpp_QMetaObject_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMetaObject_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMetaObject_PythonToCpp_QMetaObject_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMetaObject_TypeF())))
        return QMetaObject_PythonToCpp_QMetaObject_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMetaObject_PTR_CppToPython_QMetaObject(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMetaObject *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMetaObject_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMetaObject_SignatureStrings[] = {
    "PySide2.QtCore.QMetaObject(self)",
    "1:PySide2.QtCore.QMetaObject.cast(self,obj:PySide2.QtCore.QObject)->PySide2.QtCore.QObject",
    "0:PySide2.QtCore.QMetaObject.cast(self,obj:PySide2.QtCore.QObject)->PySide2.QtCore.QObject",
    "1:PySide2.QtCore.QMetaObject.checkConnectArgs(signal:PySide2.QtCore.QMetaMethod,method:PySide2.QtCore.QMetaMethod)->bool",
    "0:PySide2.QtCore.QMetaObject.checkConnectArgs(signal:char*,method:char*)->bool",
    "PySide2.QtCore.QMetaObject.classInfo(self,index:int)->PySide2.QtCore.QMetaClassInfo",
    "PySide2.QtCore.QMetaObject.classInfoCount(self)->int",
    "PySide2.QtCore.QMetaObject.classInfoOffset(self)->int",
    "PySide2.QtCore.QMetaObject.className(self)->char*",
    "PySide2.QtCore.QMetaObject.connectSlotsByName(o:PySide2.QtCore.QObject)",
    "PySide2.QtCore.QMetaObject.constructor(self,index:int)->PySide2.QtCore.QMetaMethod",
    "PySide2.QtCore.QMetaObject.constructorCount(self)->int",
    "PySide2.QtCore.QMetaObject.disconnect(sender:PySide2.QtCore.QObject,signal_index:int,receiver:PySide2.QtCore.QObject,method_index:int)->bool",
    "PySide2.QtCore.QMetaObject.disconnectOne(sender:PySide2.QtCore.QObject,signal_index:int,receiver:PySide2.QtCore.QObject,method_index:int)->bool",
    "PySide2.QtCore.QMetaObject.enumerator(self,index:int)->PySide2.QtCore.QMetaEnum",
    "PySide2.QtCore.QMetaObject.enumeratorCount(self)->int",
    "PySide2.QtCore.QMetaObject.enumeratorOffset(self)->int",
    "PySide2.QtCore.QMetaObject.indexOfClassInfo(self,name:char*)->int",
    "PySide2.QtCore.QMetaObject.indexOfConstructor(self,constructor:char*)->int",
    "PySide2.QtCore.QMetaObject.indexOfEnumerator(self,name:char*)->int",
    "PySide2.QtCore.QMetaObject.indexOfMethod(self,method:char*)->int",
    "PySide2.QtCore.QMetaObject.indexOfProperty(self,name:char*)->int",
    "PySide2.QtCore.QMetaObject.indexOfSignal(self,signal:char*)->int",
    "PySide2.QtCore.QMetaObject.indexOfSlot(self,slot:char*)->int",
    "PySide2.QtCore.QMetaObject.inherits(self,metaObject:PySide2.QtCore.QMetaObject)->bool",
    "3:PySide2.QtCore.QMetaObject.invokeMethod(obj:PySide2.QtCore.QObject,member:char*,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "2:PySide2.QtCore.QMetaObject.invokeMethod(obj:PySide2.QtCore.QObject,member:char*,ret:PySide2.QtCore.QGenericReturnArgument,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "1:PySide2.QtCore.QMetaObject.invokeMethod(obj:PySide2.QtCore.QObject,member:char*,arg__3:PySide2.QtCore.Qt.ConnectionType,ret:PySide2.QtCore.QGenericReturnArgument,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "0:PySide2.QtCore.QMetaObject.invokeMethod(obj:PySide2.QtCore.QObject,member:char*,type:PySide2.QtCore.Qt.ConnectionType,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "PySide2.QtCore.QMetaObject.method(self,index:int)->PySide2.QtCore.QMetaMethod",
    "PySide2.QtCore.QMetaObject.methodCount(self)->int",
    "PySide2.QtCore.QMetaObject.methodOffset(self)->int",
    "PySide2.QtCore.QMetaObject.newInstance(self,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->PySide2.QtCore.QObject",
    "PySide2.QtCore.QMetaObject.normalizedSignature(method:char*)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QMetaObject.normalizedType(type:char*)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QMetaObject.property(self,index:int)->PySide2.QtCore.QMetaProperty",
    "PySide2.QtCore.QMetaObject.propertyCount(self)->int",
    "PySide2.QtCore.QMetaObject.propertyOffset(self)->int",
    "PySide2.QtCore.QMetaObject.superClass(self)->PySide2.QtCore.QMetaObject",
    "PySide2.QtCore.QMetaObject.userProperty(self)->PySide2.QtCore.QMetaProperty",
    nullptr}; // Sentinel

void init_QMetaObject(PyObject *module)
{
    _Sbk_QMetaObject_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMetaObject",
        "QMetaObject*",
        &Sbk_QMetaObject_spec,
        &Shiboken::callCppDestructor< ::QMetaObject >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMetaObject_Type);
    InitSignatureStrings(pyType, QMetaObject_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMetaObject_Type), Sbk_QMetaObject_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMetaObject_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMetaObject_TypeF(),
        QMetaObject_PythonToCpp_QMetaObject_PTR,
        is_QMetaObject_PythonToCpp_QMetaObject_PTR_Convertible,
        QMetaObject_PTR_CppToPython_QMetaObject);

    Shiboken::Conversions::registerConverterName(converter, "QMetaObject");
    Shiboken::Conversions::registerConverterName(converter, "QMetaObject*");
    Shiboken::Conversions::registerConverterName(converter, "QMetaObject&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMetaObject).name());


    // Initialization of enums.

    // Initialization of enum 'Call'.
    SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMetaObject_TypeF(),
        "Call",
        "2:PySide2.QtCore.QMetaObject.Call",
        "QMetaObject::Call");
    if (!SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "InvokeMetaMethod", (long) QMetaObject::Call::InvokeMetaMethod))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "ReadProperty", (long) QMetaObject::Call::ReadProperty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "WriteProperty", (long) QMetaObject::Call::WriteProperty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "ResetProperty", (long) QMetaObject::Call::ResetProperty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "QueryPropertyDesignable", (long) QMetaObject::Call::QueryPropertyDesignable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "QueryPropertyScriptable", (long) QMetaObject::Call::QueryPropertyScriptable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "QueryPropertyStored", (long) QMetaObject::Call::QueryPropertyStored))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "QueryPropertyEditable", (long) QMetaObject::Call::QueryPropertyEditable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "QueryPropertyUser", (long) QMetaObject::Call::QueryPropertyUser))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "CreateInstance", (long) QMetaObject::Call::CreateInstance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "IndexOfMethod", (long) QMetaObject::Call::IndexOfMethod))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "RegisterPropertyMetaType", (long) QMetaObject::Call::RegisterPropertyMetaType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
        Sbk_QMetaObject_TypeF(), "RegisterMethodArgumentMetaType", (long) QMetaObject::Call::RegisterMethodArgumentMetaType))
        return;
    // Register converter for enum 'QMetaObject::Call'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX],
            QMetaObject_Call_CppToPython_QMetaObject_Call);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMetaObject_Call_PythonToCpp_QMetaObject_Call,
            is_QMetaObject_Call_PythonToCpp_QMetaObject_Call_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMetaObject::Call");
        Shiboken::Conversions::registerConverterName(converter, "Call");
    }
    // End of 'Call' enum.

    qRegisterMetaType< ::QMetaObject::Call >("QMetaObject::Call");
}
