/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmetamethod_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMetaMethod_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMetaMethod >()))
        return -1;

    ::QMetaMethod *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMetaMethod", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMetaMethod::QMetaMethod()
    // 1: QMetaMethod::QMetaMethod(QMetaMethod)
    if (numArgs == 0) {
        overloadId = 0; // QMetaMethod()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QMetaMethod(QMetaMethod)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaMethod_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMetaMethod()
        {

            if (!PyErr_Occurred()) {
                // QMetaMethod()
                cptr = new ::QMetaMethod();
            }
            break;
        }
        case 1: // QMetaMethod(const QMetaMethod & QMetaMethod)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMetaMethod cppArg0_local;
            ::QMetaMethod *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMetaMethod(QMetaMethod)
                cptr = new ::QMetaMethod(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMetaMethod >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMetaMethod_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMetaMethod_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMetaMethodFunc_access(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.access";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // access()const
            QMetaMethod::Access cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->access();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_enclosingMetaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.enclosingMetaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // enclosingMetaObject()const
            const QMetaObject * cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->enclosingMetaObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_invoke(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.invoke";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 13) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMetaMethodFunc_invoke_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMetaMethodFunc_invoke_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOOOOOOOO:invoke", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10]), &(pyArgs[11]), &(pyArgs[12])))
        return {};


    // Overloaded function decisor
    // 0: QMetaMethod::invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
    // 1: QMetaMethod::invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
    // 2: QMetaMethod::invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
    // 3: QMetaMethod::invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                                if (numArgs == 7) {
                                    overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                } else if (numArgs >= 8
                                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                    if (numArgs == 8) {
                                        overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                    } else if (numArgs >= 9
                                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                        if (numArgs == 9) {
                                            overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                        } else if (numArgs >= 10
                                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                            if (numArgs == 10) {
                                                overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            } else if (numArgs >= 11
                                                && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                                if (numArgs == 11) {
                                                    overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                                } else if (numArgs >= 12
                                                    && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11])))) {
                                                    if (numArgs == 12) {
                                                        overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                                    } else if (numArgs >= 13
                                                        && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[12])))) {
                                                        overloadId = 3; // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                                if (numArgs == 7) {
                                    overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                } else if (numArgs >= 8
                                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                    if (numArgs == 8) {
                                        overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                    } else if (numArgs >= 9
                                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                        if (numArgs == 9) {
                                            overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                        } else if (numArgs >= 10
                                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                            if (numArgs == 10) {
                                                overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            } else if (numArgs >= 11
                                                && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                                if (numArgs == 11) {
                                                    overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                                } else if (numArgs >= 12
                                                    && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11])))) {
                                                    overloadId = 2; // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                                if (numArgs == 7) {
                                    overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                } else if (numArgs >= 8
                                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                    if (numArgs == 8) {
                                        overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                    } else if (numArgs >= 9
                                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                        if (numArgs == 9) {
                                            overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                        } else if (numArgs >= 10
                                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                            if (numArgs == 10) {
                                                overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            } else if (numArgs >= 11
                                                && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                                if (numArgs == 11) {
                                                    overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                                } else if (numArgs >= 12
                                                    && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11])))) {
                                                    overloadId = 1; // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                                if (numArgs == 7) {
                                    overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                } else if (numArgs >= 8
                                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                    if (numArgs == 8) {
                                        overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                    } else if (numArgs >= 9
                                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                        if (numArgs == 9) {
                                            overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                        } else if (numArgs >= 10
                                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                            if (numArgs == 10) {
                                                overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            } else if (numArgs >= 11
                                                && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                                overloadId = 0; // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaMethodFunc_invoke_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // invoke(QObject * object, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[1]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[1]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[2]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[3]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[4]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[5]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[6]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[7]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[8]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[9]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[10]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaMethodFunc_invoke_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QGenericArgument cppArg1 = QGenericArgument(nullptr);
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QGenericArgument cppArg2 = QGenericArgument();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericArgument cppArg3 = QGenericArgument();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);

            if (!PyErr_Occurred()) {
                // invoke(QObject*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                bool cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->invoke(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // invoke(QObject * object, QGenericReturnArgument returnValue, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[2]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[3]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[4]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[5]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[6]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[7]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[8]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[9]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[10]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[11]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaMethodFunc_invoke_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QGenericReturnArgument cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QGenericArgument cppArg2 = QGenericArgument(nullptr);
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericArgument cppArg3 = QGenericArgument();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);
            if (!Shiboken::Object::isValid(pyArgs[11]))
                return {};
            ::QGenericArgument cppArg11 = QGenericArgument();
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);

            if (!PyErr_Occurred()) {
                // invoke(QObject*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                bool cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->invoke(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // invoke(QObject * object, Qt::ConnectionType connectionType, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[2]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[3]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[4]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[5]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[6]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[7]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[8]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[9]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[10]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[11]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaMethodFunc_invoke_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::ConnectionType cppArg1{Qt::AutoConnection};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QGenericArgument cppArg2 = QGenericArgument(nullptr);
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericArgument cppArg3 = QGenericArgument();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);
            if (!Shiboken::Object::isValid(pyArgs[11]))
                return {};
            ::QGenericArgument cppArg11 = QGenericArgument();
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);

            if (!PyErr_Occurred()) {
                // invoke(QObject*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                bool cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->invoke(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 3: // invoke(QObject * object, Qt::ConnectionType connectionType, QGenericReturnArgument returnValue, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[3]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[4]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[5]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[6]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[7]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[8]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[9]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[10]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[11]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[12]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    if (value) {
                        pyArgs[12] = value;
                        if (!(pythonToCpp[12] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[12]))))
                            goto Sbk_QMetaMethodFunc_invoke_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaMethodFunc_invoke_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::ConnectionType cppArg1{Qt::AutoConnection};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QGenericReturnArgument cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericArgument cppArg3 = QGenericArgument(nullptr);
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);
            if (!Shiboken::Object::isValid(pyArgs[11]))
                return {};
            ::QGenericArgument cppArg11 = QGenericArgument();
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);
            if (!Shiboken::Object::isValid(pyArgs[12]))
                return {};
            ::QGenericArgument cppArg12 = QGenericArgument();
            if (pythonToCpp[12]) pythonToCpp[12](pyArgs[12], &cppArg12);

            if (!PyErr_Occurred()) {
                // invoke(QObject*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                bool cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->invoke(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaMethodFunc_invoke_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaMethodFunc_invokeOnGadget(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.invokeOnGadget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 12) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOOOOOOO:invokeOnGadget", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10]), &(pyArgs[11])))
        return {};


    // Overloaded function decisor
    // 0: QMetaMethod::invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
    // 1: QMetaMethod::invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                                if (numArgs == 7) {
                                    overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                } else if (numArgs >= 8
                                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                    if (numArgs == 8) {
                                        overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                    } else if (numArgs >= 9
                                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                        if (numArgs == 9) {
                                            overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                        } else if (numArgs >= 10
                                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                            if (numArgs == 10) {
                                                overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            } else if (numArgs >= 11
                                                && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                                if (numArgs == 11) {
                                                    overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                                } else if (numArgs >= 12
                                                    && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11])))) {
                                                    overloadId = 1; // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6])))) {
                                if (numArgs == 7) {
                                    overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                } else if (numArgs >= 8
                                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7])))) {
                                    if (numArgs == 8) {
                                        overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                    } else if (numArgs >= 9
                                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8])))) {
                                        if (numArgs == 9) {
                                            overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                        } else if (numArgs >= 10
                                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9])))) {
                                            if (numArgs == 10) {
                                                overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            } else if (numArgs >= 11
                                                && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10])))) {
                                                overloadId = 0; // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // invokeOnGadget(void * gadget, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[1]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[1]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[2]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[3]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[4]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[5]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[6]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[7]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[8]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[9]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[10]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                }
            }
            void* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QGenericArgument cppArg1 = QGenericArgument(nullptr);
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QGenericArgument cppArg2 = QGenericArgument();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericArgument cppArg3 = QGenericArgument();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);

            if (!PyErr_Occurred()) {
                // invokeOnGadget(void*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                bool cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->invokeOnGadget(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // invokeOnGadget(void * gadget, QGenericReturnArgument returnValue, QGenericArgument val0, QGenericArgument val1, QGenericArgument val2, QGenericArgument val3, QGenericArgument val4, QGenericArgument val5, QGenericArgument val6, QGenericArgument val7, QGenericArgument val8, QGenericArgument val9) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_val0 = Shiboken::String::createStaticString("val0");
                if (PyDict_Contains(kwds, key_val0)) {
                    value = PyDict_GetItem(kwds, key_val0);
                    if (value && pyArgs[2]) {
                        errInfo = key_val0;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[2]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val0);
                }
                static PyObject *const key_val1 = Shiboken::String::createStaticString("val1");
                if (PyDict_Contains(kwds, key_val1)) {
                    value = PyDict_GetItem(kwds, key_val1);
                    if (value && pyArgs[3]) {
                        errInfo = key_val1;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[3]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val1);
                }
                static PyObject *const key_val2 = Shiboken::String::createStaticString("val2");
                if (PyDict_Contains(kwds, key_val2)) {
                    value = PyDict_GetItem(kwds, key_val2);
                    if (value && pyArgs[4]) {
                        errInfo = key_val2;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[4]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val2);
                }
                static PyObject *const key_val3 = Shiboken::String::createStaticString("val3");
                if (PyDict_Contains(kwds, key_val3)) {
                    value = PyDict_GetItem(kwds, key_val3);
                    if (value && pyArgs[5]) {
                        errInfo = key_val3;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[5]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val3);
                }
                static PyObject *const key_val4 = Shiboken::String::createStaticString("val4");
                if (PyDict_Contains(kwds, key_val4)) {
                    value = PyDict_GetItem(kwds, key_val4);
                    if (value && pyArgs[6]) {
                        errInfo = key_val4;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[6]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val4);
                }
                static PyObject *const key_val5 = Shiboken::String::createStaticString("val5");
                if (PyDict_Contains(kwds, key_val5)) {
                    value = PyDict_GetItem(kwds, key_val5);
                    if (value && pyArgs[7]) {
                        errInfo = key_val5;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[7]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val5);
                }
                static PyObject *const key_val6 = Shiboken::String::createStaticString("val6");
                if (PyDict_Contains(kwds, key_val6)) {
                    value = PyDict_GetItem(kwds, key_val6);
                    if (value && pyArgs[8]) {
                        errInfo = key_val6;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[8]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val6);
                }
                static PyObject *const key_val7 = Shiboken::String::createStaticString("val7");
                if (PyDict_Contains(kwds, key_val7)) {
                    value = PyDict_GetItem(kwds, key_val7);
                    if (value && pyArgs[9]) {
                        errInfo = key_val7;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[9]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val7);
                }
                static PyObject *const key_val8 = Shiboken::String::createStaticString("val8");
                if (PyDict_Contains(kwds, key_val8)) {
                    value = PyDict_GetItem(kwds, key_val8);
                    if (value && pyArgs[10]) {
                        errInfo = key_val8;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[10] = value;
                        if (!(pythonToCpp[10] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[10]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val8);
                }
                static PyObject *const key_val9 = Shiboken::String::createStaticString("val9");
                if (PyDict_Contains(kwds, key_val9)) {
                    value = PyDict_GetItem(kwds, key_val9);
                    if (value && pyArgs[11]) {
                        errInfo = key_val9;
                        Py_INCREF(errInfo);
                        goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]), (pyArgs[11]))))
                            goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_val9);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMetaMethodFunc_invokeOnGadget_TypeError;
                }
            }
            void* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QGenericReturnArgument cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QGenericArgument cppArg2 = QGenericArgument(nullptr);
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QGenericArgument cppArg3 = QGenericArgument();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QGenericArgument cppArg4 = QGenericArgument();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QGenericArgument cppArg5 = QGenericArgument();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QGenericArgument cppArg6 = QGenericArgument();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QGenericArgument cppArg7 = QGenericArgument();
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            if (!Shiboken::Object::isValid(pyArgs[8]))
                return {};
            ::QGenericArgument cppArg8 = QGenericArgument();
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QGenericArgument cppArg9 = QGenericArgument();
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);
            if (!Shiboken::Object::isValid(pyArgs[10]))
                return {};
            ::QGenericArgument cppArg10 = QGenericArgument();
            if (pythonToCpp[10]) pythonToCpp[10](pyArgs[10], &cppArg10);
            if (!Shiboken::Object::isValid(pyArgs[11]))
                return {};
            ::QGenericArgument cppArg11 = QGenericArgument();
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);

            if (!PyErr_Occurred()) {
                // invokeOnGadget(void*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                bool cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->invokeOnGadget(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaMethodFunc_invokeOnGadget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaMethodFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_methodIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.methodIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // methodIndex()const
            int cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->methodIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_methodSignature(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.methodSignature";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // methodSignature()const
            QByteArray cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->methodSignature();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_methodType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.methodType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // methodType()const
            QMetaMethod::MethodType cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->methodType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QByteArray cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_parameterCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.parameterCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parameterCount()const
            int cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->parameterCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_parameterNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.parameterNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parameterNames()const
            QList<QByteArray > cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->parameterNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_parameterType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.parameterType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMetaMethod::parameterType(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // parameterType(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMetaMethodFunc_parameterType_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // parameterType(int)const
            int cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->parameterType(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMetaMethodFunc_parameterType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMetaMethodFunc_parameterTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.parameterTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parameterTypes()const
            QList<QByteArray > cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->parameterTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_returnType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.returnType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // returnType()const
            int cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->returnType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_revision(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.revision";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // revision()const
            int cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->revision();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_tag(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.tag";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tag()const
            const char * cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->tag();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethodFunc_typeName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMetaMethod.typeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // typeName()const
            const char * cppResult = const_cast<const ::QMetaMethod *>(cppSelf)->typeName();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMetaMethod___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMetaMethod_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMetaMethod_methods[] = {
    {"access", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_access), METH_NOARGS},
    {"enclosingMetaObject", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_enclosingMetaObject), METH_NOARGS},
    {"invoke", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_invoke), METH_VARARGS|METH_KEYWORDS},
    {"invokeOnGadget", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_invokeOnGadget), METH_VARARGS|METH_KEYWORDS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_isValid), METH_NOARGS},
    {"methodIndex", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_methodIndex), METH_NOARGS},
    {"methodSignature", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_methodSignature), METH_NOARGS},
    {"methodType", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_methodType), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_name), METH_NOARGS},
    {"parameterCount", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_parameterCount), METH_NOARGS},
    {"parameterNames", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_parameterNames), METH_NOARGS},
    {"parameterType", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_parameterType), METH_O},
    {"parameterTypes", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_parameterTypes), METH_NOARGS},
    {"returnType", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_returnType), METH_NOARGS},
    {"revision", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_revision), METH_NOARGS},
    {"tag", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_tag), METH_NOARGS},
    {"typeName", reinterpret_cast<PyCFunction>(Sbk_QMetaMethodFunc_typeName), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMetaMethod___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QMetaMethod_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), (pyArg)))) {
                // operator!=(const QMetaMethod & m2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMetaMethod cppArg0_local;
                ::QMetaMethod *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), (pyArg)))) {
                // operator==(const QMetaMethod & m2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMetaMethod cppArg0_local;
                ::QMetaMethod *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QMetaMethod_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QMetaMethod_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QMetaMethod_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMetaMethod_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMetaMethod_Type = nullptr;
static SbkObjectType *Sbk_QMetaMethod_TypeF(void)
{
    return _Sbk_QMetaMethod_Type;
}

static PyType_Slot Sbk_QMetaMethod_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMetaMethod_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMetaMethod_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QMetaMethod_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMetaMethod_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMetaMethod_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMetaMethod_spec = {
    "2:PySide2.QtCore.QMetaMethod",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMetaMethod_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QMetaMethod_Access_PythonToCpp_QMetaMethod_Access(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMetaMethod::Access *>(cppOut) =
        static_cast<::QMetaMethod::Access>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMetaMethod_Access_PythonToCpp_QMetaMethod_Access_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX]))
        return QMetaMethod_Access_PythonToCpp_QMetaMethod_Access;
    return {};
}
static PyObject *QMetaMethod_Access_CppToPython_QMetaMethod_Access(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMetaMethod::Access *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX], castCppIn);

}

static void QMetaMethod_MethodType_PythonToCpp_QMetaMethod_MethodType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMetaMethod::MethodType *>(cppOut) =
        static_cast<::QMetaMethod::MethodType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMetaMethod_MethodType_PythonToCpp_QMetaMethod_MethodType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX]))
        return QMetaMethod_MethodType_PythonToCpp_QMetaMethod_MethodType;
    return {};
}
static PyObject *QMetaMethod_MethodType_CppToPython_QMetaMethod_MethodType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMetaMethod::MethodType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMetaMethod_PythonToCpp_QMetaMethod_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMetaMethod_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMetaMethod_PythonToCpp_QMetaMethod_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMetaMethod_TypeF())))
        return QMetaMethod_PythonToCpp_QMetaMethod_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMetaMethod_PTR_CppToPython_QMetaMethod(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMetaMethod *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMetaMethod_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMetaMethod_COPY_CppToPython_QMetaMethod(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMetaMethod_TypeF(), new ::QMetaMethod(*reinterpret_cast<const ::QMetaMethod *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMetaMethod_PythonToCpp_QMetaMethod_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMetaMethod *>(cppOut) = *reinterpret_cast< ::QMetaMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMetaMethod_PythonToCpp_QMetaMethod_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMetaMethod_TypeF())))
        return QMetaMethod_PythonToCpp_QMetaMethod_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMetaMethod_SignatureStrings[] = {
    "1:PySide2.QtCore.QMetaMethod(self)",
    "0:PySide2.QtCore.QMetaMethod(self,QMetaMethod:PySide2.QtCore.QMetaMethod)",
    "PySide2.QtCore.QMetaMethod.access(self)->PySide2.QtCore.QMetaMethod.Access",
    "PySide2.QtCore.QMetaMethod.enclosingMetaObject(self)->PySide2.QtCore.QMetaObject",
    "3:PySide2.QtCore.QMetaMethod.invoke(self,object:PySide2.QtCore.QObject,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "2:PySide2.QtCore.QMetaMethod.invoke(self,object:PySide2.QtCore.QObject,returnValue:PySide2.QtCore.QGenericReturnArgument,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "1:PySide2.QtCore.QMetaMethod.invoke(self,object:PySide2.QtCore.QObject,connectionType:PySide2.QtCore.Qt.ConnectionType,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "0:PySide2.QtCore.QMetaMethod.invoke(self,object:PySide2.QtCore.QObject,connectionType:PySide2.QtCore.Qt.ConnectionType,returnValue:PySide2.QtCore.QGenericReturnArgument,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "1:PySide2.QtCore.QMetaMethod.invokeOnGadget(self,gadget:void,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "0:PySide2.QtCore.QMetaMethod.invokeOnGadget(self,gadget:void,returnValue:PySide2.QtCore.QGenericReturnArgument,val0:PySide2.QtCore.QGenericArgument=QGenericArgument(nullptr),val1:PySide2.QtCore.QGenericArgument=QGenericArgument(),val2:PySide2.QtCore.QGenericArgument=QGenericArgument(),val3:PySide2.QtCore.QGenericArgument=QGenericArgument(),val4:PySide2.QtCore.QGenericArgument=QGenericArgument(),val5:PySide2.QtCore.QGenericArgument=QGenericArgument(),val6:PySide2.QtCore.QGenericArgument=QGenericArgument(),val7:PySide2.QtCore.QGenericArgument=QGenericArgument(),val8:PySide2.QtCore.QGenericArgument=QGenericArgument(),val9:PySide2.QtCore.QGenericArgument=QGenericArgument())->bool",
    "PySide2.QtCore.QMetaMethod.isValid(self)->bool",
    "PySide2.QtCore.QMetaMethod.methodIndex(self)->int",
    "PySide2.QtCore.QMetaMethod.methodSignature(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QMetaMethod.methodType(self)->PySide2.QtCore.QMetaMethod.MethodType",
    "PySide2.QtCore.QMetaMethod.name(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QMetaMethod.parameterCount(self)->int",
    "PySide2.QtCore.QMetaMethod.parameterNames(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtCore.QMetaMethod.parameterType(self,index:int)->int",
    "PySide2.QtCore.QMetaMethod.parameterTypes(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtCore.QMetaMethod.returnType(self)->int",
    "PySide2.QtCore.QMetaMethod.revision(self)->int",
    "PySide2.QtCore.QMetaMethod.tag(self)->char*",
    "PySide2.QtCore.QMetaMethod.typeName(self)->char*",
    "PySide2.QtCore.QMetaMethod.__copy__()",
    nullptr}; // Sentinel

void init_QMetaMethod(PyObject *module)
{
    _Sbk_QMetaMethod_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMetaMethod",
        "QMetaMethod",
        &Sbk_QMetaMethod_spec,
        &Shiboken::callCppDestructor< ::QMetaMethod >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMetaMethod_Type);
    InitSignatureStrings(pyType, QMetaMethod_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMetaMethod_Type), Sbk_QMetaMethod_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMetaMethod_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMetaMethod_TypeF(),
        QMetaMethod_PythonToCpp_QMetaMethod_PTR,
        is_QMetaMethod_PythonToCpp_QMetaMethod_PTR_Convertible,
        QMetaMethod_PTR_CppToPython_QMetaMethod,
        QMetaMethod_COPY_CppToPython_QMetaMethod);

    Shiboken::Conversions::registerConverterName(converter, "QMetaMethod");
    Shiboken::Conversions::registerConverterName(converter, "QMetaMethod*");
    Shiboken::Conversions::registerConverterName(converter, "QMetaMethod&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMetaMethod).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMetaMethod_PythonToCpp_QMetaMethod_COPY,
        is_QMetaMethod_PythonToCpp_QMetaMethod_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Access'.
    SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMetaMethod_TypeF(),
        "Access",
        "2:PySide2.QtCore.QMetaMethod.Access",
        "QMetaMethod::Access");
    if (!SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX],
        Sbk_QMetaMethod_TypeF(), "Private", (long) QMetaMethod::Access::Private))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX],
        Sbk_QMetaMethod_TypeF(), "Protected", (long) QMetaMethod::Access::Protected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX],
        Sbk_QMetaMethod_TypeF(), "Public", (long) QMetaMethod::Access::Public))
        return;
    // Register converter for enum 'QMetaMethod::Access'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX],
            QMetaMethod_Access_CppToPython_QMetaMethod_Access);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMetaMethod_Access_PythonToCpp_QMetaMethod_Access,
            is_QMetaMethod_Access_PythonToCpp_QMetaMethod_Access_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_ACCESS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMetaMethod::Access");
        Shiboken::Conversions::registerConverterName(converter, "Access");
    }
    // End of 'Access' enum.

    // Initialization of enum 'MethodType'.
    SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMetaMethod_TypeF(),
        "MethodType",
        "2:PySide2.QtCore.QMetaMethod.MethodType",
        "QMetaMethod::MethodType");
    if (!SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX],
        Sbk_QMetaMethod_TypeF(), "Method", (long) QMetaMethod::MethodType::Method))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX],
        Sbk_QMetaMethod_TypeF(), "Signal", (long) QMetaMethod::MethodType::Signal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX],
        Sbk_QMetaMethod_TypeF(), "Slot", (long) QMetaMethod::MethodType::Slot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX],
        Sbk_QMetaMethod_TypeF(), "Constructor", (long) QMetaMethod::MethodType::Constructor))
        return;
    // Register converter for enum 'QMetaMethod::MethodType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX],
            QMetaMethod_MethodType_CppToPython_QMetaMethod_MethodType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMetaMethod_MethodType_PythonToCpp_QMetaMethod_MethodType,
            is_QMetaMethod_MethodType_PythonToCpp_QMetaMethod_MethodType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_METHODTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMetaMethod::MethodType");
        Shiboken::Conversions::registerConverterName(converter, "MethodType");
    }
    // End of 'MethodType' enum.

    qRegisterMetaType< ::QMetaMethod >("QMetaMethod");
    qRegisterMetaType< ::QMetaMethod::Access >("QMetaMethod::Access");
    qRegisterMetaType< ::QMetaMethod::MethodType >("QMetaMethod::MethodType");
}
