/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qjsonparseerror_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QJsonParseError_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QJsonParseError >()))
        return -1;

    ::QJsonParseError *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonParseError.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QJsonParseError", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QJsonParseError::QJsonParseError()
    // 1: QJsonParseError::QJsonParseError(QJsonParseError)
    if (numArgs == 0) {
        overloadId = 0; // QJsonParseError()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QJsonParseError(QJsonParseError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonParseError_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QJsonParseError()
        {

            if (!PyErr_Occurred()) {
                // QJsonParseError()
                cptr = new ::QJsonParseError();
            }
            break;
        }
        case 1: // QJsonParseError(const QJsonParseError & QJsonParseError)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QJsonParseError cppArg0_local;
            ::QJsonParseError *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QJsonParseError(QJsonParseError)
                cptr = new ::QJsonParseError(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QJsonParseError >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QJsonParseError_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QJsonParseError_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QJsonParseErrorFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonParseError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonParseError.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QJsonParseError *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonParseError___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QJsonParseError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QJsonParseError_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QJsonParseError_methods[] = {
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QJsonParseErrorFunc_errorString), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QJsonParseError___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QJsonParseError_get_offset(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QJsonParseError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->offset;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QJsonParseError_set_offset(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QJsonParseError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'offset' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'offset', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->offset;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->offset = cppOut_local;

    return 0;
}

static PyObject *Sbk_QJsonParseError_get_error(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QJsonParseError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QJsonParseError::ParseError cppOut_local = cppSelf->error;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QJsonParseError_set_error(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QJsonParseError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'error' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'error', 'ParseError' or convertible type expected");
        return -1;
    }

    ::QJsonParseError::ParseError cppOut_local = cppSelf->error;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->error = cppOut_local;

    return 0;
}

// Getters and Setters for QJsonParseError
static PyGetSetDef Sbk_QJsonParseError_getsetlist[] = {
    {const_cast<char *>("offset"), Sbk_QJsonParseError_get_offset, Sbk_QJsonParseError_set_offset},
    {const_cast<char *>("error"), Sbk_QJsonParseError_get_error, Sbk_QJsonParseError_set_error},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QJsonParseError_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QJsonParseError_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QJsonParseError_Type = nullptr;
static SbkObjectType *Sbk_QJsonParseError_TypeF(void)
{
    return _Sbk_QJsonParseError_Type;
}

static PyType_Slot Sbk_QJsonParseError_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QJsonParseError_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QJsonParseError_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QJsonParseError_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QJsonParseError_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QJsonParseError_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QJsonParseError_spec = {
    "2:PySide2.QtCore.QJsonParseError",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QJsonParseError_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QJsonParseError_ParseError_PythonToCpp_QJsonParseError_ParseError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJsonParseError::ParseError *>(cppOut) =
        static_cast<::QJsonParseError::ParseError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QJsonParseError_ParseError_PythonToCpp_QJsonParseError_ParseError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX]))
        return QJsonParseError_ParseError_PythonToCpp_QJsonParseError_ParseError;
    return {};
}
static PyObject *QJsonParseError_ParseError_CppToPython_QJsonParseError_ParseError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QJsonParseError::ParseError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QJsonParseError_PythonToCpp_QJsonParseError_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QJsonParseError_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QJsonParseError_PythonToCpp_QJsonParseError_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QJsonParseError_TypeF())))
        return QJsonParseError_PythonToCpp_QJsonParseError_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QJsonParseError_PTR_CppToPython_QJsonParseError(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QJsonParseError *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QJsonParseError_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QJsonParseError_COPY_CppToPython_QJsonParseError(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QJsonParseError_TypeF(), new ::QJsonParseError(*reinterpret_cast<const ::QJsonParseError *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QJsonParseError_PythonToCpp_QJsonParseError_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJsonParseError *>(cppOut) = *reinterpret_cast< ::QJsonParseError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QJsonParseError_PythonToCpp_QJsonParseError_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QJsonParseError_TypeF())))
        return QJsonParseError_PythonToCpp_QJsonParseError_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QJsonParseError_SignatureStrings[] = {
    "1:PySide2.QtCore.QJsonParseError(self)",
    "0:PySide2.QtCore.QJsonParseError(self,QJsonParseError:PySide2.QtCore.QJsonParseError)",
    "PySide2.QtCore.QJsonParseError.errorString(self)->QString",
    "PySide2.QtCore.QJsonParseError.__copy__()",
    nullptr}; // Sentinel

void init_QJsonParseError(PyObject *module)
{
    _Sbk_QJsonParseError_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QJsonParseError",
        "QJsonParseError",
        &Sbk_QJsonParseError_spec,
        &Shiboken::callCppDestructor< ::QJsonParseError >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QJsonParseError_Type);
    InitSignatureStrings(pyType, QJsonParseError_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QJsonParseError_Type), Sbk_QJsonParseError_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QJsonParseError_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QJsonParseError_TypeF(),
        QJsonParseError_PythonToCpp_QJsonParseError_PTR,
        is_QJsonParseError_PythonToCpp_QJsonParseError_PTR_Convertible,
        QJsonParseError_PTR_CppToPython_QJsonParseError,
        QJsonParseError_COPY_CppToPython_QJsonParseError);

    Shiboken::Conversions::registerConverterName(converter, "QJsonParseError");
    Shiboken::Conversions::registerConverterName(converter, "QJsonParseError*");
    Shiboken::Conversions::registerConverterName(converter, "QJsonParseError&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QJsonParseError).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QJsonParseError_PythonToCpp_QJsonParseError_COPY,
        is_QJsonParseError_PythonToCpp_QJsonParseError_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'ParseError'.
    SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QJsonParseError_TypeF(),
        "ParseError",
        "2:PySide2.QtCore.QJsonParseError.ParseError",
        "QJsonParseError::ParseError");
    if (!SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "NoError", (long) QJsonParseError::ParseError::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "UnterminatedObject", (long) QJsonParseError::ParseError::UnterminatedObject))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "MissingNameSeparator", (long) QJsonParseError::ParseError::MissingNameSeparator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "UnterminatedArray", (long) QJsonParseError::ParseError::UnterminatedArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "MissingValueSeparator", (long) QJsonParseError::ParseError::MissingValueSeparator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "IllegalValue", (long) QJsonParseError::ParseError::IllegalValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "TerminationByNumber", (long) QJsonParseError::ParseError::TerminationByNumber))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "IllegalNumber", (long) QJsonParseError::ParseError::IllegalNumber))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "IllegalEscapeSequence", (long) QJsonParseError::ParseError::IllegalEscapeSequence))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "IllegalUTF8String", (long) QJsonParseError::ParseError::IllegalUTF8String))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "UnterminatedString", (long) QJsonParseError::ParseError::UnterminatedString))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "MissingObject", (long) QJsonParseError::ParseError::MissingObject))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "DeepNesting", (long) QJsonParseError::ParseError::DeepNesting))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "DocumentTooLarge", (long) QJsonParseError::ParseError::DocumentTooLarge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
        Sbk_QJsonParseError_TypeF(), "GarbageAtEnd", (long) QJsonParseError::ParseError::GarbageAtEnd))
        return;
    // Register converter for enum 'QJsonParseError::ParseError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX],
            QJsonParseError_ParseError_CppToPython_QJsonParseError_ParseError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QJsonParseError_ParseError_PythonToCpp_QJsonParseError_ParseError,
            is_QJsonParseError_ParseError_PythonToCpp_QJsonParseError_ParseError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_PARSEERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QJsonParseError::ParseError");
        Shiboken::Conversions::registerConverterName(converter, "ParseError");
    }
    // End of 'ParseError' enum.

    qRegisterMetaType< ::QJsonParseError >("QJsonParseError");
    qRegisterMetaType< ::QJsonParseError::ParseError >("QJsonParseError::ParseError");
}
