/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qjsondocument_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>
#include <qjsonarray.h>
#include <qjsondocument.h>
#include <qjsonvalue.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QJsonDocument_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QJsonDocument >()))
        return -1;

    ::QJsonDocument *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QJsonDocument", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QJsonDocument::QJsonDocument()
    // 1: QJsonDocument::QJsonDocument(QJsonArray)
    // 2: QJsonDocument::QJsonDocument(QJsonDocument)
    // 3: QJsonDocument::QJsonDocument(QJsonObject)
    if (numArgs == 0) {
        overloadId = 0; // QJsonDocument()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], (pyArgs[0])))) {
        overloadId = 3; // QJsonDocument(QJsonObject)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QJsonDocument(QJsonDocument)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QJsonDocument(QJsonArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocument_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QJsonDocument()
        {

            if (!PyErr_Occurred()) {
                // QJsonDocument()
                cptr = new ::QJsonDocument();
            }
            break;
        }
        case 1: // QJsonDocument(const QJsonArray & array)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QJsonArray cppArg0_local;
            ::QJsonArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QJsonDocument(QJsonArray)
                cptr = new ::QJsonDocument(*cppArg0);
            }
            break;
        }
        case 2: // QJsonDocument(const QJsonDocument & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QJsonDocument cppArg0_local;
            ::QJsonDocument *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QJsonDocument(QJsonDocument)
                cptr = new ::QJsonDocument(*cppArg0);
            }
            break;
        }
        case 3: // QJsonDocument(const QJsonObject & object)
        {
            ::QJsonObject cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJsonDocument(QJsonObject)
                cptr = new ::QJsonDocument(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QJsonDocument >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QJsonDocument_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QJsonDocument_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QJsonDocumentFunc_array(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.array";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // array()const
            QJsonArray cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->array();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonDocumentFunc_fromBinaryData(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.fromBinaryData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJsonDocumentFunc_fromBinaryData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QJsonDocumentFunc_fromBinaryData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromBinaryData", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QJsonDocument::fromBinaryData(QByteArray,QJsonDocument::DataValidation)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromBinaryData(QByteArray,QJsonDocument::DataValidation)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromBinaryData(QByteArray,QJsonDocument::DataValidation)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocumentFunc_fromBinaryData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_validation = Shiboken::String::createStaticString("validation");
            if (PyDict_Contains(kwds, key_validation)) {
                value = PyDict_GetItem(kwds, key_validation);
                if (value && pyArgs[1]) {
                    errInfo = key_validation;
                    Py_INCREF(errInfo);
                    goto Sbk_QJsonDocumentFunc_fromBinaryData_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QJsonDocumentFunc_fromBinaryData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_validation);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJsonDocumentFunc_fromBinaryData_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QJsonDocument::DataValidation cppArg1 = QJsonDocument::DataValidation::Validate;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromBinaryData(QByteArray,QJsonDocument::DataValidation)
            QJsonDocument cppResult = ::QJsonDocument::fromBinaryData(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonDocumentFunc_fromBinaryData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonDocumentFunc_fromJson(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.fromJson";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJsonDocumentFunc_fromJson_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QJsonDocumentFunc_fromJson_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromJson", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QJsonDocument::fromJson(QByteArray,QJsonParseError*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromJson(QByteArray,QJsonParseError*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX]), (pyArgs[1])))) {
            overloadId = 0; // fromJson(QByteArray,QJsonParseError*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocumentFunc_fromJson_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_error = Shiboken::String::createStaticString("error");
            if (PyDict_Contains(kwds, key_error)) {
                value = PyDict_GetItem(kwds, key_error);
                if (value && pyArgs[1]) {
                    errInfo = key_error;
                    Py_INCREF(errInfo);
                    goto Sbk_QJsonDocumentFunc_fromJson_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONPARSEERROR_IDX]), (pyArgs[1]))))
                        goto Sbk_QJsonDocumentFunc_fromJson_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_error);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJsonDocumentFunc_fromJson_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QJsonParseError *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromJson(QByteArray,QJsonParseError*)
            QJsonDocument cppResult = ::QJsonDocument::fromJson(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonDocumentFunc_fromJson_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonDocumentFunc_fromRawData(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.fromRawData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJsonDocumentFunc_fromRawData_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QJsonDocumentFunc_fromRawData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fromRawData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QJsonDocument::fromRawData(const char*,int,QJsonDocument::DataValidation)
    if (numArgs >= 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // fromRawData(const char*,int,QJsonDocument::DataValidation)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // fromRawData(const char*,int,QJsonDocument::DataValidation)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocumentFunc_fromRawData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_validation = Shiboken::String::createStaticString("validation");
            if (PyDict_Contains(kwds, key_validation)) {
                value = PyDict_GetItem(kwds, key_validation);
                if (value && pyArgs[2]) {
                    errInfo = key_validation;
                    Py_INCREF(errInfo);
                    goto Sbk_QJsonDocumentFunc_fromRawData_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QJsonDocumentFunc_fromRawData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_validation);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJsonDocumentFunc_fromRawData_TypeError;
            }
        }
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QJsonDocument::DataValidation cppArg2 = QJsonDocument::DataValidation::Validate;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // fromRawData(const char*,int,QJsonDocument::DataValidation)
            QJsonDocument cppResult = ::QJsonDocument::fromRawData(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonDocumentFunc_fromRawData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonDocumentFunc_fromVariant(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.fromVariant";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QJsonDocument::fromVariant(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // fromVariant(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocumentFunc_fromVariant_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromVariant(QVariant)
            QJsonDocument cppResult = ::QJsonDocument::fromVariant(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonDocumentFunc_fromVariant_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonDocumentFunc_isArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.isArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isArray()const
            bool cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->isArray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonDocumentFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonDocumentFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonDocumentFunc_isObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.isObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isObject()const
            bool cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->isObject();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonDocumentFunc_object(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.object";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // object()const
            QJsonObject cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->object();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonDocumentFunc_rawData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.rawData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJsonDocument::rawData(int*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // rawData(int*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocumentFunc_rawData_TypeError;

    // Call function/method
    {
        int *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rawData(int*)const
            const char * cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->rawData(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonDocumentFunc_rawData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonDocumentFunc_setArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.setArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJsonDocument::setArray(QJsonArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setArray(QJsonArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocumentFunc_setArray_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QJsonArray cppArg0_local;
        ::QJsonArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setArray(QJsonArray)
            cppSelf->setArray(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJsonDocumentFunc_setArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonDocumentFunc_setObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.setObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJsonDocument::setObject(QJsonObject)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], (pyArg)))) {
        overloadId = 0; // setObject(QJsonObject)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocumentFunc_setObject_TypeError;

    // Call function/method
    {
        ::QJsonObject cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setObject(QJsonObject)
            cppSelf->setObject(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJsonDocumentFunc_setObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonDocumentFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJsonDocument::swap(QJsonDocument&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QJsonDocument&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocumentFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QJsonDocument cppArg0_local;
        ::QJsonDocument *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QJsonDocument&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJsonDocumentFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonDocumentFunc_toBinaryData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.toBinaryData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toBinaryData()const
            QByteArray cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->toBinaryData();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonDocumentFunc_toJson(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.toJson";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toJson", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJsonDocument::toJson()const
    // 1: QJsonDocument::toJson(QJsonDocument::JsonFormat)const
    if (numArgs == 0) {
        overloadId = 0; // toJson()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_JSONFORMAT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // toJson(QJsonDocument::JsonFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonDocumentFunc_toJson_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toJson() const
        {

            if (!PyErr_Occurred()) {
                // toJson()const
                QByteArray cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->toJson();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toJson(QJsonDocument::JsonFormat format) const
        {
            ::QJsonDocument::JsonFormat cppArg0{QJsonDocument::Indented};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toJson(QJsonDocument::JsonFormat)const
                QByteArray cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->toJson(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonDocumentFunc_toJson_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonDocumentFunc_toVariant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonDocument.toVariant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toVariant()const
            QVariant cppResult = const_cast<const ::QJsonDocument *>(cppSelf)->toVariant();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonDocument___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QJsonDocument_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QJsonDocument_methods[] = {
    {"array", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_array), METH_NOARGS},
    {"fromBinaryData", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_fromBinaryData), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromJson", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_fromJson), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromRawData", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_fromRawData), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromVariant", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_fromVariant), METH_O|METH_STATIC},
    {"isArray", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_isArray), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_isEmpty), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_isNull), METH_NOARGS},
    {"isObject", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_isObject), METH_NOARGS},
    {"object", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_object), METH_NOARGS},
    {"rawData", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_rawData), METH_O},
    {"setArray", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_setArray), METH_O},
    {"setObject", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_setObject), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_swap), METH_O},
    {"toBinaryData", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_toBinaryData), METH_NOARGS},
    {"toJson", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_toJson), METH_VARARGS},
    {"toVariant", reinterpret_cast<PyCFunction>(Sbk_QJsonDocumentFunc_toVariant), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QJsonDocument___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QJsonDocument___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QJsonDocument_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), (pyArg)))) {
                // operator!=(const QJsonDocument & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonDocument cppArg0_local;
                ::QJsonDocument *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), (pyArg)))) {
                // operator==(const QJsonDocument & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonDocument cppArg0_local;
                ::QJsonDocument *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QJsonDocument_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QJsonDocument_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QJsonDocument_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QJsonDocument_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QJsonDocument__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QJsonDocument_Type = nullptr;
static SbkObjectType *Sbk_QJsonDocument_TypeF(void)
{
    return _Sbk_QJsonDocument_Type;
}

static PyType_Slot Sbk_QJsonDocument_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QJsonDocument__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QJsonDocument_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QJsonDocument_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QJsonDocument_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QJsonDocument_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QJsonDocument_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QJsonDocument___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QJsonDocument___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QJsonDocument_spec = {
    "2:PySide2.QtCore.QJsonDocument",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QJsonDocument_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QJsonDocument_DataValidation_PythonToCpp_QJsonDocument_DataValidation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJsonDocument::DataValidation *>(cppOut) =
        static_cast<::QJsonDocument::DataValidation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QJsonDocument_DataValidation_PythonToCpp_QJsonDocument_DataValidation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX]))
        return QJsonDocument_DataValidation_PythonToCpp_QJsonDocument_DataValidation;
    return {};
}
static PyObject *QJsonDocument_DataValidation_CppToPython_QJsonDocument_DataValidation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QJsonDocument::DataValidation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX], castCppIn);

}

static void QJsonDocument_JsonFormat_PythonToCpp_QJsonDocument_JsonFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJsonDocument::JsonFormat *>(cppOut) =
        static_cast<::QJsonDocument::JsonFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QJsonDocument_JsonFormat_PythonToCpp_QJsonDocument_JsonFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_JSONFORMAT_IDX]))
        return QJsonDocument_JsonFormat_PythonToCpp_QJsonDocument_JsonFormat;
    return {};
}
static PyObject *QJsonDocument_JsonFormat_CppToPython_QJsonDocument_JsonFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QJsonDocument::JsonFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_JSONFORMAT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QJsonDocument_PythonToCpp_QJsonDocument_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QJsonDocument_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QJsonDocument_PythonToCpp_QJsonDocument_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QJsonDocument_TypeF())))
        return QJsonDocument_PythonToCpp_QJsonDocument_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QJsonDocument_PTR_CppToPython_QJsonDocument(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QJsonDocument *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QJsonDocument_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QJsonDocument_COPY_CppToPython_QJsonDocument(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QJsonDocument_TypeF(), new ::QJsonDocument(*reinterpret_cast<const ::QJsonDocument *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QJsonDocument_PythonToCpp_QJsonDocument_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJsonDocument *>(cppOut) = *reinterpret_cast< ::QJsonDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QJsonDocument_PythonToCpp_QJsonDocument_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QJsonDocument_TypeF())))
        return QJsonDocument_PythonToCpp_QJsonDocument_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QJsonDocument_SignatureStrings[] = {
    "3:PySide2.QtCore.QJsonDocument(self)",
    "2:PySide2.QtCore.QJsonDocument(self,array:PySide2.QtCore.QJsonArray)",
    "1:PySide2.QtCore.QJsonDocument(self,other:PySide2.QtCore.QJsonDocument)",
    "0:PySide2.QtCore.QJsonDocument(self,object:QJsonObject)",
    "PySide2.QtCore.QJsonDocument.array(self)->PySide2.QtCore.QJsonArray",
    "PySide2.QtCore.QJsonDocument.fromBinaryData(data:PySide2.QtCore.QByteArray,validation:PySide2.QtCore.QJsonDocument.DataValidation=Validate)->PySide2.QtCore.QJsonDocument",
    "PySide2.QtCore.QJsonDocument.fromJson(json:PySide2.QtCore.QByteArray,error:PySide2.QtCore.QJsonParseError=nullptr)->PySide2.QtCore.QJsonDocument",
    "PySide2.QtCore.QJsonDocument.fromRawData(data:char*,size:int,validation:PySide2.QtCore.QJsonDocument.DataValidation=Validate)->PySide2.QtCore.QJsonDocument",
    "PySide2.QtCore.QJsonDocument.fromVariant(variant:QVariant)->PySide2.QtCore.QJsonDocument",
    "PySide2.QtCore.QJsonDocument.isArray(self)->bool",
    "PySide2.QtCore.QJsonDocument.isEmpty(self)->bool",
    "PySide2.QtCore.QJsonDocument.isNull(self)->bool",
    "PySide2.QtCore.QJsonDocument.isObject(self)->bool",
    "PySide2.QtCore.QJsonDocument.object(self)->QJsonObject",
    "PySide2.QtCore.QJsonDocument.rawData(self,size:int*)->char*",
    "PySide2.QtCore.QJsonDocument.setArray(self,array:PySide2.QtCore.QJsonArray)",
    "PySide2.QtCore.QJsonDocument.setObject(self,object:QJsonObject)",
    "PySide2.QtCore.QJsonDocument.swap(self,other:PySide2.QtCore.QJsonDocument)",
    "PySide2.QtCore.QJsonDocument.toBinaryData(self)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QJsonDocument.toJson(self)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QJsonDocument.toJson(self,format:PySide2.QtCore.QJsonDocument.JsonFormat)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QJsonDocument.toVariant(self)->QVariant",
    "PySide2.QtCore.QJsonDocument.__copy__()",
    nullptr}; // Sentinel

void init_QJsonDocument(PyObject *module)
{
    _Sbk_QJsonDocument_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QJsonDocument",
        "QJsonDocument",
        &Sbk_QJsonDocument_spec,
        &Shiboken::callCppDestructor< ::QJsonDocument >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QJsonDocument_Type);
    InitSignatureStrings(pyType, QJsonDocument_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QJsonDocument_Type), Sbk_QJsonDocument_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QJsonDocument_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QJsonDocument_TypeF(),
        QJsonDocument_PythonToCpp_QJsonDocument_PTR,
        is_QJsonDocument_PythonToCpp_QJsonDocument_PTR_Convertible,
        QJsonDocument_PTR_CppToPython_QJsonDocument,
        QJsonDocument_COPY_CppToPython_QJsonDocument);

    Shiboken::Conversions::registerConverterName(converter, "QJsonDocument");
    Shiboken::Conversions::registerConverterName(converter, "QJsonDocument*");
    Shiboken::Conversions::registerConverterName(converter, "QJsonDocument&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QJsonDocument).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QJsonDocument_PythonToCpp_QJsonDocument_COPY,
        is_QJsonDocument_PythonToCpp_QJsonDocument_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'DataValidation'.
    SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QJsonDocument_TypeF(),
        "DataValidation",
        "2:PySide2.QtCore.QJsonDocument.DataValidation",
        "QJsonDocument::DataValidation");
    if (!SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX],
        Sbk_QJsonDocument_TypeF(), "Validate", (long) QJsonDocument::DataValidation::Validate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX],
        Sbk_QJsonDocument_TypeF(), "BypassValidation", (long) QJsonDocument::DataValidation::BypassValidation))
        return;
    // Register converter for enum 'QJsonDocument::DataValidation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX],
            QJsonDocument_DataValidation_CppToPython_QJsonDocument_DataValidation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QJsonDocument_DataValidation_PythonToCpp_QJsonDocument_DataValidation,
            is_QJsonDocument_DataValidation_PythonToCpp_QJsonDocument_DataValidation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_DATAVALIDATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QJsonDocument::DataValidation");
        Shiboken::Conversions::registerConverterName(converter, "DataValidation");
    }
    // End of 'DataValidation' enum.

    // Initialization of enum 'JsonFormat'.
    SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_JSONFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QJsonDocument_TypeF(),
        "JsonFormat",
        "2:PySide2.QtCore.QJsonDocument.JsonFormat",
        "QJsonDocument::JsonFormat");
    if (!SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_JSONFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_JSONFORMAT_IDX],
        Sbk_QJsonDocument_TypeF(), "Indented", (long) QJsonDocument::JsonFormat::Indented))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_JSONFORMAT_IDX],
        Sbk_QJsonDocument_TypeF(), "Compact", (long) QJsonDocument::JsonFormat::Compact))
        return;
    // Register converter for enum 'QJsonDocument::JsonFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_JSONFORMAT_IDX],
            QJsonDocument_JsonFormat_CppToPython_QJsonDocument_JsonFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QJsonDocument_JsonFormat_PythonToCpp_QJsonDocument_JsonFormat,
            is_QJsonDocument_JsonFormat_PythonToCpp_QJsonDocument_JsonFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_JSONFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QJsonDocument::JsonFormat");
        Shiboken::Conversions::registerConverterName(converter, "JsonFormat");
    }
    // End of 'JsonFormat' enum.

    qRegisterMetaType< ::QJsonDocument >("QJsonDocument");
    qRegisterMetaType< ::QJsonDocument::DataValidation >("QJsonDocument::DataValidation");
    qRegisterMetaType< ::QJsonDocument::JsonFormat >("QJsonDocument::JsonFormat");
}
