/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qitemselection_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QSet>
#include <QVector>
#include <qabstractitemmodel.h>
#include <qitemselectionmodel.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QItemSelection_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QItemSelection >()))
        return -1;

    ::QItemSelection *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QItemSelection", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QItemSelection::QItemSelection()
    // 1: QItemSelection::QItemSelection(QItemSelection)
    // 2: QItemSelection::QItemSelection(QModelIndex,QModelIndex)
    if (numArgs == 0) {
        overloadId = 0; // QItemSelection()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[1])))) {
        overloadId = 2; // QItemSelection(QModelIndex,QModelIndex)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QItemSelection(QItemSelection)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelection_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QItemSelection()
        {

            if (!PyErr_Occurred()) {
                // QItemSelection()
                cptr = new ::QItemSelection();
            }
            break;
        }
        case 1: // QItemSelection(const QItemSelection & QItemSelection)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QItemSelection cppArg0_local;
            ::QItemSelection *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QItemSelection(QItemSelection)
                cptr = new ::QItemSelection(*cppArg0);
            }
            break;
        }
        case 2: // QItemSelection(const QModelIndex & topLeft, const QModelIndex & bottomRight)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QModelIndex cppArg1_local;
            ::QModelIndex *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QItemSelection(QModelIndex,QModelIndex)
                cptr = new ::QItemSelection(*cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QItemSelection >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QItemSelection_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QItemSelection_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QItemSelectionFunc_append(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.append";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::append(QItemSelectionRange)
    // 1: QItemSelection::append(QList<QItemSelectionRange>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // append(QItemSelectionRange)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], (pyArg)))) {
        overloadId = 1; // append(QList<QItemSelectionRange>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_append_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // append(const QItemSelectionRange & t)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QItemSelectionRange cppArg0_local;
            ::QItemSelectionRange *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // append(QItemSelectionRange)
                cppSelf->append(*cppArg0);
            }
            break;
        }
        case 1: // append(const QList<QItemSelectionRange > & t)
        {
            ::QList<QItemSelectionRange > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // append(QList<QItemSelectionRange>)
                cppSelf->append(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_append_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_at(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.at";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::at(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // at(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_at_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // at(int)const
            const QItemSelectionRange & cppResult = const_cast<const ::QItemSelection *>(cppSelf)->at(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_at_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_back(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.back";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // back()
            QItemSelectionRange & cppResult = cppSelf->back();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QItemSelectionFunc_constFirst(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.constFirst";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // constFirst()const
            const QItemSelectionRange & cppResult = const_cast<const ::QItemSelection *>(cppSelf)->constFirst();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_constLast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.constLast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // constLast()const
            const QItemSelectionRange & cppResult = const_cast<const ::QItemSelection *>(cppSelf)->constLast();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::contains(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // contains(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_contains_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // contains(QModelIndex)const
            bool cppResult = const_cast<const ::QItemSelection *>(cppSelf)->contains(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_count(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.count";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "count", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::count()const
    // 1: QItemSelection::count(QItemSelectionRange)const
    if (numArgs == 0) {
        overloadId = 0; // count()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // count(QItemSelectionRange)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_count_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // count() const
        {

            if (!PyErr_Occurred()) {
                // count()const
                int cppResult = const_cast<const ::QItemSelection *>(cppSelf)->count();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // count(const QItemSelectionRange & t) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QItemSelectionRange cppArg0_local;
            ::QItemSelectionRange *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // count(QItemSelectionRange)const
                int cppResult = const_cast<const ::QItemSelection *>(cppSelf)->count(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_count_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_detachShared(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.detachShared";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // detachShared()
            cppSelf->detachShared();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QItemSelectionFunc_empty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.empty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // empty()const
            bool cppResult = const_cast<const ::QItemSelection *>(cppSelf)->empty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_endsWith(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.endsWith";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::endsWith(QItemSelectionRange)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // endsWith(QItemSelectionRange)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_endsWith_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // endsWith(QItemSelectionRange)const
            bool cppResult = const_cast<const ::QItemSelection *>(cppSelf)->endsWith(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_endsWith_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_first(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.first";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // first()
            QItemSelectionRange & cppResult = cppSelf->first();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_fromSet(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.fromSet";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QItemSelection::fromSet(QSet<QItemSelectionRange>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QSET_QITEMSELECTIONRANGE_IDX], (pyArg)))) {
        overloadId = 0; // fromSet(QSet<QItemSelectionRange>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_fromSet_TypeError;

    // Call function/method
    {
        ::QSet<QItemSelectionRange > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromSet(QSet<QItemSelectionRange>)
            QList<QItemSelectionRange > cppResult = ::QItemSelection::fromSet(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_fromSet_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_fromVector(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.fromVector";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QItemSelection::fromVector(QVector<QItemSelectionRange>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QITEMSELECTIONRANGE_IDX], (pyArg)))) {
        overloadId = 0; // fromVector(QVector<QItemSelectionRange>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_fromVector_TypeError;

    // Call function/method
    {
        ::QVector<QItemSelectionRange > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromVector(QVector<QItemSelectionRange>)
            QList<QItemSelectionRange > cppResult = ::QItemSelection::fromVector(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_fromVector_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_front(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.front";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // front()
            QItemSelectionRange & cppResult = cppSelf->front();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_indexOf(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.indexOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QItemSelectionFunc_indexOf_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QItemSelectionFunc_indexOf_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:indexOf", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::indexOf(QItemSelectionRange,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // indexOf(QItemSelectionRange,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // indexOf(QItemSelectionRange,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_indexOf_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_from = Shiboken::String::createStaticString("from");
            if (PyDict_Contains(kwds, key_from)) {
                value = PyDict_GetItem(kwds, key_from);
                if (value && pyArgs[1]) {
                    errInfo = key_from;
                    Py_INCREF(errInfo);
                    goto Sbk_QItemSelectionFunc_indexOf_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QItemSelectionFunc_indexOf_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_from);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QItemSelectionFunc_indexOf_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // indexOf(QItemSelectionRange,int)const
            int cppResult = const_cast<const ::QItemSelection *>(cppSelf)->indexOf(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_indexOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_indexes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.indexes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indexes()const
            QModelIndexList cppResult = const_cast<const ::QItemSelection *>(cppSelf)->indexes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_insert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.insert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insert", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::insert(int,QItemSelectionRange)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insert(int,QItemSelectionRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_insert_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QItemSelectionRange cppArg1_local;
        ::QItemSelectionRange *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // insert(int,QItemSelectionRange)
            cppSelf->insert(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_insert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QItemSelection *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_isSharedWith(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.isSharedWith";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::isSharedWith(QList<QItemSelectionRange>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], (pyArg)))) {
        overloadId = 0; // isSharedWith(QList<QItemSelectionRange>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_isSharedWith_TypeError;

    // Call function/method
    {
        ::QList<QItemSelectionRange > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isSharedWith(QList<QItemSelectionRange>)const
            bool cppResult = const_cast<const ::QItemSelection *>(cppSelf)->isSharedWith(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_isSharedWith_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_last(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.last";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // last()
            QItemSelectionRange & cppResult = cppSelf->last();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_lastIndexOf(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.lastIndexOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QItemSelectionFunc_lastIndexOf_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QItemSelectionFunc_lastIndexOf_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:lastIndexOf", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::lastIndexOf(QItemSelectionRange,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // lastIndexOf(QItemSelectionRange,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // lastIndexOf(QItemSelectionRange,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_lastIndexOf_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_from = Shiboken::String::createStaticString("from");
            if (PyDict_Contains(kwds, key_from)) {
                value = PyDict_GetItem(kwds, key_from);
                if (value && pyArgs[1]) {
                    errInfo = key_from;
                    Py_INCREF(errInfo);
                    goto Sbk_QItemSelectionFunc_lastIndexOf_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QItemSelectionFunc_lastIndexOf_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_from);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QItemSelectionFunc_lastIndexOf_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // lastIndexOf(QItemSelectionRange,int)const
            int cppResult = const_cast<const ::QItemSelection *>(cppSelf)->lastIndexOf(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_lastIndexOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.length";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // length()const
            int cppResult = const_cast<const ::QItemSelection *>(cppSelf)->length();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_merge(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.merge";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "merge", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::merge(QItemSelection,QFlags<QItemSelectionModel::SelectionFlag>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QITEMSELECTIONMODEL_SELECTIONFLAG_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // merge(QItemSelection,QFlags<QItemSelectionModel::SelectionFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_merge_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QItemSelection cppArg0_local;
        ::QItemSelection *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<QItemSelectionModel::SelectionFlag> cppArg1 = QFlags<QItemSelectionModel::SelectionFlag>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // merge(QItemSelection,QFlags<QItemSelectionModel::SelectionFlag>)
            cppSelf->merge(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_merge_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_mid(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.mid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QItemSelectionFunc_mid_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QItemSelectionFunc_mid_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:mid", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::mid(int,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // mid(int,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // mid(int,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_mid_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_length = Shiboken::String::createStaticString("length");
            if (PyDict_Contains(kwds, key_length)) {
                value = PyDict_GetItem(kwds, key_length);
                if (value && pyArgs[1]) {
                    errInfo = key_length;
                    Py_INCREF(errInfo);
                    goto Sbk_QItemSelectionFunc_mid_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QItemSelectionFunc_mid_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_length);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QItemSelectionFunc_mid_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // mid(int,int)const
            QList<QItemSelectionRange > cppResult = const_cast<const ::QItemSelection *>(cppSelf)->mid(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_mid_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_move(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.move";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "move", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::move(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // move(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_move_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // move(int,int)
            cppSelf->move(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_move_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_pop_back(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.pop_back";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pop_back()
            cppSelf->pop_back();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QItemSelectionFunc_pop_front(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.pop_front";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pop_front()
            cppSelf->pop_front();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QItemSelectionFunc_prepend(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.prepend";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::prepend(QItemSelectionRange)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // prepend(QItemSelectionRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_prepend_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // prepend(QItemSelectionRange)
            cppSelf->prepend(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_prepend_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_push_back(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.push_back";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::push_back(QItemSelectionRange)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // push_back(QItemSelectionRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_push_back_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // push_back(QItemSelectionRange)
            cppSelf->push_back(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_push_back_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_push_front(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.push_front";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::push_front(QItemSelectionRange)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // push_front(QItemSelectionRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_push_front_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // push_front(QItemSelectionRange)
            cppSelf->push_front(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_push_front_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_removeAll(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.removeAll";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::removeAll(QItemSelectionRange)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // removeAll(QItemSelectionRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_removeAll_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeAll(QItemSelectionRange)
            int cppResult = cppSelf->removeAll(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_removeAll_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_removeAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.removeAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::removeAt(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // removeAt(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_removeAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeAt(int)
            cppSelf->removeAt(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_removeAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_removeFirst(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.removeFirst";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeFirst()
            cppSelf->removeFirst();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QItemSelectionFunc_removeLast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.removeLast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeLast()
            cppSelf->removeLast();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QItemSelectionFunc_removeOne(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.removeOne";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::removeOne(QItemSelectionRange)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // removeOne(QItemSelectionRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_removeOne_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeOne(QItemSelectionRange)
            bool cppResult = cppSelf->removeOne(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_removeOne_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_replace(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.replace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::replace(int,QItemSelectionRange)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // replace(int,QItemSelectionRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_replace_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QItemSelectionRange cppArg1_local;
        ::QItemSelectionRange *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // replace(int,QItemSelectionRange)
            cppSelf->replace(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_replace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_reserve(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.reserve";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::reserve(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // reserve(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_reserve_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // reserve(int)
            cppSelf->reserve(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_reserve_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_select(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.select";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "select", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::select(QModelIndex,QModelIndex)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[1])))) {
        overloadId = 0; // select(QModelIndex,QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_select_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QModelIndex cppArg1_local;
        ::QModelIndex *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // select(QModelIndex,QModelIndex)
            cppSelf->select(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_select_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_setSharable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.setSharable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::setSharable(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSharable(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_setSharable_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSharable(bool)
            cppSelf->setSharable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_setSharable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QItemSelection *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_split(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.split";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "split", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QItemSelection::split(QItemSelectionRange,QItemSelectionRange,QItemSelection*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), (pyArgs[2])))) {
        overloadId = 0; // split(QItemSelectionRange,QItemSelectionRange,QItemSelection*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_split_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QItemSelectionRange cppArg1_local;
        ::QItemSelectionRange *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QItemSelection *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // split(QItemSelectionRange,QItemSelectionRange,QItemSelection*)
            ::QItemSelection::split(*cppArg0, *cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_split_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_startsWith(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.startsWith";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::startsWith(QItemSelectionRange)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // startsWith(QItemSelectionRange)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_startsWith_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // startsWith(QItemSelectionRange)const
            bool cppResult = const_cast<const ::QItemSelection *>(cppSelf)->startsWith(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_startsWith_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_swap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "swap", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::swap(QList<QItemSelectionRange>&)
    // 1: QItemSelection::swap(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // swap(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], (pyArgs[0])))) {
        overloadId = 0; // swap(QList<QItemSelectionRange>&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_swap_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // swap(QList<QItemSelectionRange > & other)
        {
            ::QList<QItemSelectionRange > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // swap(QList<QItemSelectionRange>&)
                cppSelf->swap(cppArg0);
            }
            break;
        }
        case 1: // swap(int i, int j)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // swap(int,int)
                cppSelf->swap(cppArg0, cppArg1);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QItemSelection.swap(int i, int j) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_swapItemsAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.swapItemsAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "swapItemsAt", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::swapItemsAt(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // swapItemsAt(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_swapItemsAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // swapItemsAt(int,int)
            cppSelf->swapItemsAt(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionFunc_swapItemsAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_takeAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.takeAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::takeAt(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // takeAt(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_takeAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // takeAt(int)
            QItemSelectionRange cppResult = cppSelf->takeAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_takeAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc_takeFirst(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.takeFirst";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // takeFirst()
            QItemSelectionRange cppResult = cppSelf->takeFirst();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_takeLast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.takeLast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // takeLast()
            QItemSelectionRange cppResult = cppSelf->takeLast();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_toSet(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.toSet";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toSet()const
            QSet<QItemSelectionRange > cppResult = const_cast<const ::QItemSelection *>(cppSelf)->toSet();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QSET_QITEMSELECTIONRANGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_toVector(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.toVector";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toVector()const
            QVector<QItemSelectionRange > cppResult = const_cast<const ::QItemSelection *>(cppSelf)->toVector();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QITEMSELECTIONRANGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionFunc_value(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.value";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelection::value(int)const
    // 1: QItemSelection::value(int,QItemSelectionRange)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // value(int)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // value(int,QItemSelectionRange)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc_value_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // value(int i) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // value(int)const
                QItemSelectionRange cppResult = const_cast<const ::QItemSelection *>(cppSelf)->value(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // value(int i, const QItemSelectionRange & defaultValue) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QItemSelectionRange cppArg1_local;
            ::QItemSelectionRange *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // value(int,QItemSelectionRange)const
                QItemSelectionRange cppResult = const_cast<const ::QItemSelection *>(cppSelf)->value(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc_value_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelection___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QItemSelection_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QItemSelection_methods[] = {
    {"append", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_append), METH_O},
    {"at", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_at), METH_O},
    {"back", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_back), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_clear), METH_NOARGS},
    {"constFirst", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_constFirst), METH_NOARGS},
    {"constLast", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_constLast), METH_NOARGS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_contains), METH_O},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_count), METH_VARARGS},
    {"detachShared", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_detachShared), METH_NOARGS},
    {"empty", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_empty), METH_NOARGS},
    {"endsWith", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_endsWith), METH_O},
    {"first", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_first), METH_NOARGS},
    {"fromSet", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_fromSet), METH_O|METH_STATIC},
    {"fromVector", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_fromVector), METH_O|METH_STATIC},
    {"front", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_front), METH_NOARGS},
    {"indexOf", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_indexOf), METH_VARARGS|METH_KEYWORDS},
    {"indexes", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_indexes), METH_NOARGS},
    {"insert", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_insert), METH_VARARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_isEmpty), METH_NOARGS},
    {"isSharedWith", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_isSharedWith), METH_O},
    {"last", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_last), METH_NOARGS},
    {"lastIndexOf", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_lastIndexOf), METH_VARARGS|METH_KEYWORDS},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_length), METH_NOARGS},
    {"merge", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_merge), METH_VARARGS},
    {"mid", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_mid), METH_VARARGS|METH_KEYWORDS},
    {"move", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_move), METH_VARARGS},
    {"pop_back", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_pop_back), METH_NOARGS},
    {"pop_front", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_pop_front), METH_NOARGS},
    {"prepend", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_prepend), METH_O},
    {"push_back", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_push_back), METH_O},
    {"push_front", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_push_front), METH_O},
    {"removeAll", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_removeAll), METH_O},
    {"removeAt", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_removeAt), METH_O},
    {"removeFirst", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_removeFirst), METH_NOARGS},
    {"removeLast", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_removeLast), METH_NOARGS},
    {"removeOne", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_removeOne), METH_O},
    {"replace", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_replace), METH_VARARGS},
    {"reserve", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_reserve), METH_O},
    {"select", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_select), METH_VARARGS},
    {"setSharable", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_setSharable), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_size), METH_NOARGS},
    {"split", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_split), METH_VARARGS|METH_STATIC},
    {"startsWith", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_startsWith), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_swap), METH_VARARGS},
    {"swapItemsAt", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_swapItemsAt), METH_VARARGS},
    {"takeAt", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_takeAt), METH_O},
    {"takeFirst", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_takeFirst), METH_NOARGS},
    {"takeLast", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_takeLast), METH_NOARGS},
    {"toSet", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_toSet), METH_NOARGS},
    {"toVector", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_toVector), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionFunc_value), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QItemSelection___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QItemSelectionFunc___add__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.__add__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::operator+(QList<QItemSelectionRange>)const
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], (pyArg)))) {
        overloadId = 0; // operator+(QList<QItemSelectionRange>)const
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc___add___TypeError;

    // Call function/method
    {
        ::QList<QItemSelectionRange > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator+(QList<QItemSelectionRange>)const
            QList<QItemSelectionRange > cppResult = (*cppSelf) + cppArg0;
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc___add___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelection::operator+=(QItemSelectionRange)
    // 1: QItemSelection::operator+=(QList<QItemSelectionRange>)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // operator+=(QItemSelectionRange)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], (pyArg)))) {
        overloadId = 1; // operator+=(QList<QItemSelectionRange>)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionFunc___iadd___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator+=(const QItemSelectionRange & t)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QItemSelectionRange cppArg0_local;
            ::QItemSelectionRange *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator+=(QItemSelectionRange)
                (*cppSelf) += (*cppArg0);
            }
            break;
        }
        case 1: // operator+=(const QList<QItemSelectionRange > & l)
        {
            ::QList<QItemSelectionRange > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator+=(QList<QItemSelectionRange>)
                (*cppSelf) += cppArg0;
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QItemSelectionFunc___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelection.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QItemSelection::operator<<(QItemSelectionRange)
        // 1: QItemSelection::operator<<(QList<QItemSelectionRange>)
        if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QItemSelectionRange)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], (pyArg)))) {
            overloadId = 1; // operator<<(QList<QItemSelectionRange>)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QItemSelectionFunc___lshift___TypeError;

        // Call function/method
        switch (overloadId) {
            case 0: // operator<<(const QItemSelectionRange & t)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QItemSelectionRange cppArg0_local;
                ::QItemSelectionRange *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QItemSelectionRange)
                    QList<QItemSelectionRange > & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], &cppResult);
                }
                break;
            }
            case 1: // operator<<(const QList<QItemSelectionRange > & l)
            {
                ::QList<QItemSelectionRange > cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(QList<QItemSelectionRange>)
                    QList<QItemSelectionRange > & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], &cppResult);
                }
                break;
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

Py_ssize_t Sbk_QItemSelection__len__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return cppSelf->size();
}
PyObject *Sbk_QItemSelection__getitem__(PyObject *self, Py_ssize_t _i)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (_i < 0 || _i >= (Py_ssize_t) cppSelf->size()) {
        PyErr_SetString(PyExc_IndexError, "index out of bounds");
        return 0;
    }
    QItemSelection::const_iterator _item = cppSelf->begin();
    std::advance(_item, _i);
    return Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &*_item);
}
int Sbk_QItemSelection__setitem__(PyObject *self, Py_ssize_t _i, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (_i < 0 || _i >= (Py_ssize_t) cppSelf->size()) {
        PyErr_SetString(PyExc_IndexError, "list assignment index out of range");
        return -1;
    }
    PythonToCppFunc pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        PyErr_SetString(PyExc_TypeError, "attributed value with wrong type, 'QItemSelectionRange' or other convertible type expected");
        return -1;
    }
    if (!Shiboken::Object::isValid(pyArg))
        return -1;
    ::QItemSelectionRange cppValue;
    pythonToCpp(pyArg, &cppValue);
    QItemSelection::iterator _item = cppSelf->begin();
    std::advance(_item, _i);
    *_item = cppValue;
    return {};
}
// Rich comparison
static PyObject * Sbk_QItemSelection_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], (pyArg)))) {
                // operator!=(const QList<QItemSelectionRange > & l) const
                ::QList<QItemSelectionRange > cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QITEMSELECTIONRANGE_IDX], (pyArg)))) {
                // operator==(const QList<QItemSelectionRange > & l) const
                ::QList<QItemSelectionRange > cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QItemSelection_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QItemSelection_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QItemSelection_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QItemSelection_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QItemSelection_Type = nullptr;
static SbkObjectType *Sbk_QItemSelection_TypeF(void)
{
    return _Sbk_QItemSelection_Type;
}

static PyType_Slot Sbk_QItemSelection_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QItemSelection_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QItemSelection_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QItemSelection_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QItemSelection_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QItemSelection_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports sequence protocol
    {Py_sq_item, (void *)Sbk_QItemSelection__getitem__},
    {Py_sq_ass_item, (void *)Sbk_QItemSelection__setitem__},
    {Py_sq_length, (void *)Sbk_QItemSelection__len__},
    // type supports number protocol
    {Py_nb_inplace_add, (void *)Sbk_QItemSelectionFunc___iadd__},
    {Py_nb_add, (void *)Sbk_QItemSelectionFunc___add__},
    {Py_nb_lshift, (void *)Sbk_QItemSelectionFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QItemSelection_spec = {
    "2:PySide2.QtCore.QItemSelection",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QItemSelection_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QItemSelection_PythonToCpp_QItemSelection_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QItemSelection_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QItemSelection_PythonToCpp_QItemSelection_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QItemSelection_TypeF())))
        return QItemSelection_PythonToCpp_QItemSelection_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QItemSelection_PTR_CppToPython_QItemSelection(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QItemSelection *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QItemSelection_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QItemSelection_COPY_CppToPython_QItemSelection(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QItemSelection_TypeF(), new ::QItemSelection(*reinterpret_cast<const ::QItemSelection *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QItemSelection_PythonToCpp_QItemSelection_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QItemSelection *>(cppOut) = *reinterpret_cast< ::QItemSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QItemSelection_PythonToCpp_QItemSelection_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QItemSelection_TypeF())))
        return QItemSelection_PythonToCpp_QItemSelection_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QItemSelection_SignatureStrings[] = {
    "2:PySide2.QtCore.QItemSelection(self)",
    "1:PySide2.QtCore.QItemSelection(self,QItemSelection:PySide2.QtCore.QItemSelection)",
    "0:PySide2.QtCore.QItemSelection(self,topLeft:PySide2.QtCore.QModelIndex,bottomRight:PySide2.QtCore.QModelIndex)",
    "1:PySide2.QtCore.QItemSelection.append(self,t:PySide2.QtCore.QItemSelectionRange)",
    "0:PySide2.QtCore.QItemSelection.append(self,t:QList[PySide2.QtCore.QItemSelectionRange])",
    "PySide2.QtCore.QItemSelection.at(self,i:int)->PySide2.QtCore.QItemSelectionRange",
    "1:PySide2.QtCore.QItemSelection.back(self)->PySide2.QtCore.QItemSelectionRange",
    "0:PySide2.QtCore.QItemSelection.back(self)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.clear(self)",
    "PySide2.QtCore.QItemSelection.constFirst(self)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.constLast(self)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.contains(self,index:PySide2.QtCore.QModelIndex)->bool",
    "1:PySide2.QtCore.QItemSelection.count(self)->int",
    "0:PySide2.QtCore.QItemSelection.count(self,t:PySide2.QtCore.QItemSelectionRange)->int",
    "PySide2.QtCore.QItemSelection.detachShared(self)",
    "PySide2.QtCore.QItemSelection.empty(self)->bool",
    "PySide2.QtCore.QItemSelection.endsWith(self,t:PySide2.QtCore.QItemSelectionRange)->bool",
    "1:PySide2.QtCore.QItemSelection.first(self)->PySide2.QtCore.QItemSelectionRange",
    "0:PySide2.QtCore.QItemSelection.first(self)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.fromSet(set:QSet[PySide2.QtCore.QItemSelectionRange])->QList[PySide2.QtCore.QItemSelectionRange]",
    "PySide2.QtCore.QItemSelection.fromVector(vector:QVector[PySide2.QtCore.QItemSelectionRange])->QList[PySide2.QtCore.QItemSelectionRange]",
    "1:PySide2.QtCore.QItemSelection.front(self)->PySide2.QtCore.QItemSelectionRange",
    "0:PySide2.QtCore.QItemSelection.front(self)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.indexOf(self,t:PySide2.QtCore.QItemSelectionRange,from:int=0)->int",
    "PySide2.QtCore.QItemSelection.indexes(self)->QModelIndexList",
    "PySide2.QtCore.QItemSelection.insert(self,i:int,t:PySide2.QtCore.QItemSelectionRange)",
    "PySide2.QtCore.QItemSelection.isEmpty(self)->bool",
    "PySide2.QtCore.QItemSelection.isSharedWith(self,other:QList[PySide2.QtCore.QItemSelectionRange])->bool",
    "1:PySide2.QtCore.QItemSelection.last(self)->PySide2.QtCore.QItemSelectionRange",
    "0:PySide2.QtCore.QItemSelection.last(self)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.lastIndexOf(self,t:PySide2.QtCore.QItemSelectionRange,from:int=-1)->int",
    "PySide2.QtCore.QItemSelection.length(self)->int",
    "PySide2.QtCore.QItemSelection.merge(self,other:PySide2.QtCore.QItemSelection,command:PySide2.QtCore.QItemSelectionModel.SelectionFlags)",
    "PySide2.QtCore.QItemSelection.mid(self,pos:int,length:int=-1)->QList[PySide2.QtCore.QItemSelectionRange]",
    "PySide2.QtCore.QItemSelection.move(self,from:int,to:int)",
    "PySide2.QtCore.QItemSelection.pop_back(self)",
    "PySide2.QtCore.QItemSelection.pop_front(self)",
    "PySide2.QtCore.QItemSelection.prepend(self,t:PySide2.QtCore.QItemSelectionRange)",
    "PySide2.QtCore.QItemSelection.push_back(self,t:PySide2.QtCore.QItemSelectionRange)",
    "PySide2.QtCore.QItemSelection.push_front(self,t:PySide2.QtCore.QItemSelectionRange)",
    "PySide2.QtCore.QItemSelection.removeAll(self,t:PySide2.QtCore.QItemSelectionRange)->int",
    "PySide2.QtCore.QItemSelection.removeAt(self,i:int)",
    "PySide2.QtCore.QItemSelection.removeFirst(self)",
    "PySide2.QtCore.QItemSelection.removeLast(self)",
    "PySide2.QtCore.QItemSelection.removeOne(self,t:PySide2.QtCore.QItemSelectionRange)->bool",
    "PySide2.QtCore.QItemSelection.replace(self,i:int,t:PySide2.QtCore.QItemSelectionRange)",
    "PySide2.QtCore.QItemSelection.reserve(self,size:int)",
    "PySide2.QtCore.QItemSelection.select(self,topLeft:PySide2.QtCore.QModelIndex,bottomRight:PySide2.QtCore.QModelIndex)",
    "PySide2.QtCore.QItemSelection.setSharable(self,sharable:bool)",
    "PySide2.QtCore.QItemSelection.size(self)->int",
    "PySide2.QtCore.QItemSelection.split(range:PySide2.QtCore.QItemSelectionRange,other:PySide2.QtCore.QItemSelectionRange,result:PySide2.QtCore.QItemSelection)",
    "PySide2.QtCore.QItemSelection.startsWith(self,t:PySide2.QtCore.QItemSelectionRange)->bool",
    "1:PySide2.QtCore.QItemSelection.swap(self,other:QList[PySide2.QtCore.QItemSelectionRange])",
    "0:PySide2.QtCore.QItemSelection.swap(self,i:int,j:int)",
    "PySide2.QtCore.QItemSelection.swapItemsAt(self,i:int,j:int)",
    "PySide2.QtCore.QItemSelection.takeAt(self,i:int)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.takeFirst(self)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.takeLast(self)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.toSet(self)->QSet[PySide2.QtCore.QItemSelectionRange]",
    "PySide2.QtCore.QItemSelection.toVector(self)->QVector[PySide2.QtCore.QItemSelectionRange]",
    "1:PySide2.QtCore.QItemSelection.value(self,i:int)->PySide2.QtCore.QItemSelectionRange",
    "0:PySide2.QtCore.QItemSelection.value(self,i:int,defaultValue:PySide2.QtCore.QItemSelectionRange)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelection.__copy__()",
    "PySide2.QtCore.QItemSelection.__add__(self,l:QList[PySide2.QtCore.QItemSelectionRange])->QList[PySide2.QtCore.QItemSelectionRange]",
    "1:PySide2.QtCore.QItemSelection.__iadd__(self,t:PySide2.QtCore.QItemSelectionRange)->QList[PySide2.QtCore.QItemSelectionRange]",
    "0:PySide2.QtCore.QItemSelection.__iadd__(self,l:QList[PySide2.QtCore.QItemSelectionRange])->QList[PySide2.QtCore.QItemSelectionRange]",
    "1:PySide2.QtCore.QItemSelection.__lshift__(self,t:PySide2.QtCore.QItemSelectionRange)->QList[PySide2.QtCore.QItemSelectionRange]",
    "0:PySide2.QtCore.QItemSelection.__lshift__(self,l:QList[PySide2.QtCore.QItemSelectionRange])->QList[PySide2.QtCore.QItemSelectionRange]",
    nullptr}; // Sentinel

void init_QItemSelection(PyObject *module)
{
    _Sbk_QItemSelection_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QItemSelection",
        "QItemSelection",
        &Sbk_QItemSelection_spec,
        &Shiboken::callCppDestructor< ::QItemSelection >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QItemSelection_Type);
    InitSignatureStrings(pyType, QItemSelection_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QItemSelection_Type), Sbk_QItemSelection_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QItemSelection_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QItemSelection_TypeF(),
        QItemSelection_PythonToCpp_QItemSelection_PTR,
        is_QItemSelection_PythonToCpp_QItemSelection_PTR_Convertible,
        QItemSelection_PTR_CppToPython_QItemSelection,
        QItemSelection_COPY_CppToPython_QItemSelection);

    Shiboken::Conversions::registerConverterName(converter, "QItemSelection");
    Shiboken::Conversions::registerConverterName(converter, "QItemSelection*");
    Shiboken::Conversions::registerConverterName(converter, "QItemSelection&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QItemSelection).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QItemSelection_PythonToCpp_QItemSelection_COPY,
        is_QItemSelection_PythonToCpp_QItemSelection_COPY_Convertible);

    qRegisterMetaType< ::QItemSelection >("QItemSelection");
}
