/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qfutureinterfacebase_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QFutureInterfaceBaseWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QFutureInterfaceBaseWrapper::QFutureInterfaceBaseWrapper(::QFutureInterfaceBase::State initialState) : QFutureInterfaceBase(initialState)
{
    resetPyMethodCache();
    // ... middle
}

QFutureInterfaceBaseWrapper::~QFutureInterfaceBaseWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFutureInterfaceBase_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFutureInterfaceBase >()))
        return -1;

    ::QFutureInterfaceBaseWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFutureInterfaceBase_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QFutureInterfaceBase", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QFutureInterfaceBase::QFutureInterfaceBase(QFutureInterfaceBase::State)
    // 1: QFutureInterfaceBase::QFutureInterfaceBase(QFutureInterfaceBase)
    if (numArgs == 0) {
        overloadId = 0; // QFutureInterfaceBase(QFutureInterfaceBase::State)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QFutureInterfaceBase(QFutureInterfaceBase)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QFutureInterfaceBase(QFutureInterfaceBase::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBase_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFutureInterfaceBase(QFutureInterfaceBase::State initialState)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_initialState = Shiboken::String::createStaticString("initialState");
                if (PyDict_Contains(kwds, key_initialState)) {
                    value = PyDict_GetItem(kwds, key_initialState);
                    if (value && pyArgs[0]) {
                        errInfo = key_initialState;
                        Py_INCREF(errInfo);
                        goto Sbk_QFutureInterfaceBase_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QFutureInterfaceBase_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_initialState);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFutureInterfaceBase_Init_TypeError;
                }
            }
            ::QFutureInterfaceBase::State cppArg0 = QFutureInterfaceBase::State::NoState;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QFutureInterfaceBase(QFutureInterfaceBase::State)
                cptr = new ::QFutureInterfaceBaseWrapper(cppArg0);
            }
            break;
        }
        case 1: // QFutureInterfaceBase(const QFutureInterfaceBase & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFutureInterfaceBase_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFutureInterfaceBase *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QFutureInterfaceBase(QFutureInterfaceBase)
                cptr = new ::QFutureInterfaceBaseWrapper(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFutureInterfaceBase >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFutureInterfaceBase_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QFutureInterfaceBase_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_cancel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.cancel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cancel()
            cppSelf->cancel();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_derefT(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.derefT";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // derefT()const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->derefT();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_expectedResultCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.expectedResultCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // expectedResultCount()
            int cppResult = cppSelf->expectedResultCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_isCanceled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.isCanceled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCanceled()const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->isCanceled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.isFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->isFinished();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_isPaused(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.isPaused";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPaused()const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->isPaused();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_isProgressUpdateNeeded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.isProgressUpdateNeeded";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isProgressUpdateNeeded()const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->isProgressUpdateNeeded();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_isResultReadyAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.isResultReadyAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::isResultReadyAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // isResultReadyAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_isResultReadyAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isResultReadyAt(int)const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->isResultReadyAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFutureInterfaceBaseFunc_isResultReadyAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_isRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.isRunning";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRunning()const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->isRunning();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_isStarted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.isStarted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStarted()const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->isStarted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_isThrottled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.isThrottled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isThrottled()const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->isThrottled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_mutex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.mutex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mutex", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFutureInterfaceBase::mutex()const
    // 1: QFutureInterfaceBase::mutex(int)const
    if (numArgs == 0) {
        overloadId = 0; // mutex()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // mutex(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_mutex_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mutex() const
        {

            if (!PyErr_Occurred()) {
                // mutex()const
                QMutex * cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->mutex();
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMUTEX_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // mutex(int arg__1) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // mutex(int)const
                QMutex & cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->mutex(cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMUTEX_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFutureInterfaceBaseFunc_mutex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_progressMaximum(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.progressMaximum";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressMaximum()const
            int cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->progressMaximum();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_progressMinimum(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.progressMinimum";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressMinimum()const
            int cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->progressMinimum();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_progressText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.progressText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressText()const
            QString cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->progressText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_progressValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.progressValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressValue()const
            int cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->progressValue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_queryState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.queryState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::queryState(QFutureInterfaceBase::State)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // queryState(QFutureInterfaceBase::State)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_queryState_TypeError;

    // Call function/method
    {
        ::QFutureInterfaceBase::State cppArg0{QFutureInterfaceBase::NoState};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // queryState(QFutureInterfaceBase::State)const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->queryState(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFutureInterfaceBaseFunc_queryState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_refT(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.refT";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // refT()const
            bool cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->refT();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_reportCanceled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.reportCanceled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reportCanceled()
            cppSelf->reportCanceled();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_reportFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.reportFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reportFinished()
            cppSelf->reportFinished();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_reportResultsReady(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.reportResultsReady";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "reportResultsReady", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFutureInterfaceBase::reportResultsReady(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // reportResultsReady(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_reportResultsReady_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // reportResultsReady(int,int)
            cppSelf->reportResultsReady(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_reportResultsReady_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_reportStarted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.reportStarted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reportStarted()
            cppSelf->reportStarted();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_resultCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.resultCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resultCount()const
            int cppResult = const_cast<const ::QFutureInterfaceBase *>(cppSelf)->resultCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_setExpectedResultCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.setExpectedResultCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::setExpectedResultCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setExpectedResultCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_setExpectedResultCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExpectedResultCount(int)
            cppSelf->setExpectedResultCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_setExpectedResultCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_setFilterMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.setFilterMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::setFilterMode(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFilterMode(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_setFilterMode_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFilterMode(bool)
            cppSelf->setFilterMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_setFilterMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_setPaused(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.setPaused";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::setPaused(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPaused(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_setPaused_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPaused(bool)
            cppSelf->setPaused(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_setPaused_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_setProgressRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.setProgressRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setProgressRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFutureInterfaceBase::setProgressRange(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setProgressRange(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_setProgressRange_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setProgressRange(int,int)
            cppSelf->setProgressRange(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_setProgressRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_setProgressValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.setProgressValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::setProgressValue(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setProgressValue(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_setProgressValue_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProgressValue(int)
            cppSelf->setProgressValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_setProgressValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_setProgressValueAndText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.setProgressValueAndText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setProgressValueAndText", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFutureInterfaceBase::setProgressValueAndText(int,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // setProgressValueAndText(int,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_setProgressValueAndText_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setProgressValueAndText(int,QString)
            cppSelf->setProgressValueAndText(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_setProgressValueAndText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_setRunnable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.setRunnable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::setRunnable(QRunnable*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRUNNABLE_IDX]), (pyArg)))) {
        overloadId = 0; // setRunnable(QRunnable*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_setRunnable_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRunnable *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRunnable(QRunnable*)
            cppSelf->setRunnable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_setRunnable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_setThreadPool(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.setThreadPool";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::setThreadPool(QThreadPool*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTHREADPOOL_IDX]), (pyArg)))) {
        overloadId = 0; // setThreadPool(QThreadPool*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_setThreadPool_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QThreadPool *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setThreadPool(QThreadPool*)
            cppSelf->setThreadPool(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_setThreadPool_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_setThrottled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.setThrottled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::setThrottled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setThrottled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_setThrottled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setThrottled(bool)
            cppSelf->setThrottled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_setThrottled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_togglePaused(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.togglePaused";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // togglePaused()
            cppSelf->togglePaused();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_waitForFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.waitForFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // waitForFinished()
            cppSelf->waitForFinished();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_waitForNextResult(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.waitForNextResult";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // waitForNextResult()
            bool cppResult = cppSelf->waitForNextResult();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_waitForResult(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.waitForResult";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureInterfaceBase::waitForResult(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // waitForResult(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureInterfaceBaseFunc_waitForResult_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForResult(int)
            cppSelf->waitForResult(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureInterfaceBaseFunc_waitForResult_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureInterfaceBaseFunc_waitForResume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFutureInterfaceBase.waitForResume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // waitForResume()
            cppSelf->waitForResume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QFutureInterfaceBase_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFutureInterfaceBase_methods[] = {
    {"cancel", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_cancel), METH_NOARGS},
    {"derefT", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_derefT), METH_NOARGS},
    {"expectedResultCount", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_expectedResultCount), METH_NOARGS},
    {"isCanceled", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_isCanceled), METH_NOARGS},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_isFinished), METH_NOARGS},
    {"isPaused", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_isPaused), METH_NOARGS},
    {"isProgressUpdateNeeded", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_isProgressUpdateNeeded), METH_NOARGS},
    {"isResultReadyAt", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_isResultReadyAt), METH_O},
    {"isRunning", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_isRunning), METH_NOARGS},
    {"isStarted", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_isStarted), METH_NOARGS},
    {"isThrottled", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_isThrottled), METH_NOARGS},
    {"mutex", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_mutex), METH_VARARGS},
    {"progressMaximum", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_progressMaximum), METH_NOARGS},
    {"progressMinimum", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_progressMinimum), METH_NOARGS},
    {"progressText", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_progressText), METH_NOARGS},
    {"progressValue", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_progressValue), METH_NOARGS},
    {"queryState", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_queryState), METH_O},
    {"refT", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_refT), METH_NOARGS},
    {"reportCanceled", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_reportCanceled), METH_NOARGS},
    {"reportFinished", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_reportFinished), METH_NOARGS},
    {"reportResultsReady", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_reportResultsReady), METH_VARARGS},
    {"reportStarted", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_reportStarted), METH_NOARGS},
    {"resultCount", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_resultCount), METH_NOARGS},
    {"setExpectedResultCount", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_setExpectedResultCount), METH_O},
    {"setFilterMode", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_setFilterMode), METH_O},
    {"setPaused", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_setPaused), METH_O},
    {"setProgressRange", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_setProgressRange), METH_VARARGS},
    {"setProgressValue", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_setProgressValue), METH_O},
    {"setProgressValueAndText", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_setProgressValueAndText), METH_VARARGS},
    {"setRunnable", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_setRunnable), METH_O},
    {"setThreadPool", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_setThreadPool), METH_O},
    {"setThrottled", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_setThrottled), METH_O},
    {"togglePaused", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_togglePaused), METH_NOARGS},
    {"waitForFinished", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_waitForFinished), METH_NOARGS},
    {"waitForNextResult", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_waitForNextResult), METH_NOARGS},
    {"waitForResult", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_waitForResult), METH_O},
    {"waitForResume", reinterpret_cast<PyCFunction>(Sbk_QFutureInterfaceBaseFunc_waitForResume), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QFutureInterfaceBase_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QFutureInterfaceBaseWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

// Rich comparison
static PyObject * Sbk_QFutureInterfaceBase_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFutureInterfaceBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX]), (pyArg)))) {
                // operator!=(const QFutureInterfaceBase & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFutureInterfaceBase *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX]), (pyArg)))) {
                // operator==(const QFutureInterfaceBase & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFutureInterfaceBase *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QFutureInterfaceBase_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QFutureInterfaceBase_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QFutureInterfaceBase_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFutureInterfaceBase_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFutureInterfaceBase_Type = nullptr;
static SbkObjectType *Sbk_QFutureInterfaceBase_TypeF(void)
{
    return _Sbk_QFutureInterfaceBase_Type;
}

static PyType_Slot Sbk_QFutureInterfaceBase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QFutureInterfaceBase_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFutureInterfaceBase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFutureInterfaceBase_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QFutureInterfaceBase_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFutureInterfaceBase_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFutureInterfaceBase_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFutureInterfaceBase_spec = {
    "2:PySide2.QtCore.QFutureInterfaceBase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFutureInterfaceBase_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QFutureInterfaceBase_State_PythonToCpp_QFutureInterfaceBase_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFutureInterfaceBase::State *>(cppOut) =
        static_cast<::QFutureInterfaceBase::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFutureInterfaceBase_State_PythonToCpp_QFutureInterfaceBase_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX]))
        return QFutureInterfaceBase_State_PythonToCpp_QFutureInterfaceBase_State;
    return {};
}
static PyObject *QFutureInterfaceBase_State_CppToPython_QFutureInterfaceBase_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFutureInterfaceBase::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFutureInterfaceBase_PythonToCpp_QFutureInterfaceBase_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFutureInterfaceBase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFutureInterfaceBase_PythonToCpp_QFutureInterfaceBase_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFutureInterfaceBase_TypeF())))
        return QFutureInterfaceBase_PythonToCpp_QFutureInterfaceBase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFutureInterfaceBase_PTR_CppToPython_QFutureInterfaceBase(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFutureInterfaceBase *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFutureInterfaceBase_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFutureInterfaceBase_SignatureStrings[] = {
    "1:PySide2.QtCore.QFutureInterfaceBase(self,initialState:PySide2.QtCore.QFutureInterfaceBase.State=NoState)",
    "0:PySide2.QtCore.QFutureInterfaceBase(self,other:PySide2.QtCore.QFutureInterfaceBase)",
    "PySide2.QtCore.QFutureInterfaceBase.cancel(self)",
    "PySide2.QtCore.QFutureInterfaceBase.derefT(self)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.expectedResultCount(self)->int",
    "PySide2.QtCore.QFutureInterfaceBase.isCanceled(self)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.isFinished(self)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.isPaused(self)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.isProgressUpdateNeeded(self)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.isResultReadyAt(self,index:int)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.isRunning(self)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.isStarted(self)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.isThrottled(self)->bool",
    "1:PySide2.QtCore.QFutureInterfaceBase.mutex(self)->PySide2.QtCore.QMutex",
    "0:PySide2.QtCore.QFutureInterfaceBase.mutex(self,arg__1:int)->PySide2.QtCore.QMutex",
    "PySide2.QtCore.QFutureInterfaceBase.progressMaximum(self)->int",
    "PySide2.QtCore.QFutureInterfaceBase.progressMinimum(self)->int",
    "PySide2.QtCore.QFutureInterfaceBase.progressText(self)->QString",
    "PySide2.QtCore.QFutureInterfaceBase.progressValue(self)->int",
    "PySide2.QtCore.QFutureInterfaceBase.queryState(self,state:PySide2.QtCore.QFutureInterfaceBase.State)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.refT(self)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.reportCanceled(self)",
    "PySide2.QtCore.QFutureInterfaceBase.reportFinished(self)",
    "PySide2.QtCore.QFutureInterfaceBase.reportResultsReady(self,beginIndex:int,endIndex:int)",
    "PySide2.QtCore.QFutureInterfaceBase.reportStarted(self)",
    "PySide2.QtCore.QFutureInterfaceBase.resultCount(self)->int",
    "PySide2.QtCore.QFutureInterfaceBase.setExpectedResultCount(self,resultCount:int)",
    "PySide2.QtCore.QFutureInterfaceBase.setFilterMode(self,enable:bool)",
    "PySide2.QtCore.QFutureInterfaceBase.setPaused(self,paused:bool)",
    "PySide2.QtCore.QFutureInterfaceBase.setProgressRange(self,minimum:int,maximum:int)",
    "PySide2.QtCore.QFutureInterfaceBase.setProgressValue(self,progressValue:int)",
    "PySide2.QtCore.QFutureInterfaceBase.setProgressValueAndText(self,progressValue:int,progressText:QString)",
    "PySide2.QtCore.QFutureInterfaceBase.setRunnable(self,runnable:PySide2.QtCore.QRunnable)",
    "PySide2.QtCore.QFutureInterfaceBase.setThreadPool(self,pool:PySide2.QtCore.QThreadPool)",
    "PySide2.QtCore.QFutureInterfaceBase.setThrottled(self,enable:bool)",
    "PySide2.QtCore.QFutureInterfaceBase.togglePaused(self)",
    "PySide2.QtCore.QFutureInterfaceBase.waitForFinished(self)",
    "PySide2.QtCore.QFutureInterfaceBase.waitForNextResult(self)->bool",
    "PySide2.QtCore.QFutureInterfaceBase.waitForResult(self,resultIndex:int)",
    "PySide2.QtCore.QFutureInterfaceBase.waitForResume(self)",
    nullptr}; // Sentinel

void init_QFutureInterfaceBase(PyObject *module)
{
    _Sbk_QFutureInterfaceBase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFutureInterfaceBase",
        "QFutureInterfaceBase*",
        &Sbk_QFutureInterfaceBase_spec,
        &Shiboken::callCppDestructor< ::QFutureInterfaceBase >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFutureInterfaceBase_Type);
    InitSignatureStrings(pyType, QFutureInterfaceBase_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFutureInterfaceBase_Type), Sbk_QFutureInterfaceBase_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFutureInterfaceBase_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFutureInterfaceBase_TypeF(),
        QFutureInterfaceBase_PythonToCpp_QFutureInterfaceBase_PTR,
        is_QFutureInterfaceBase_PythonToCpp_QFutureInterfaceBase_PTR_Convertible,
        QFutureInterfaceBase_PTR_CppToPython_QFutureInterfaceBase);

    Shiboken::Conversions::registerConverterName(converter, "QFutureInterfaceBase");
    Shiboken::Conversions::registerConverterName(converter, "QFutureInterfaceBase*");
    Shiboken::Conversions::registerConverterName(converter, "QFutureInterfaceBase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFutureInterfaceBase).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFutureInterfaceBaseWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'State'.
    SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFutureInterfaceBase_TypeF(),
        "State",
        "2:PySide2.QtCore.QFutureInterfaceBase.State",
        "QFutureInterfaceBase::State");
    if (!SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX],
        Sbk_QFutureInterfaceBase_TypeF(), "NoState", (long) QFutureInterfaceBase::State::NoState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX],
        Sbk_QFutureInterfaceBase_TypeF(), "Running", (long) QFutureInterfaceBase::State::Running))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX],
        Sbk_QFutureInterfaceBase_TypeF(), "Started", (long) QFutureInterfaceBase::State::Started))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX],
        Sbk_QFutureInterfaceBase_TypeF(), "Finished", (long) QFutureInterfaceBase::State::Finished))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX],
        Sbk_QFutureInterfaceBase_TypeF(), "Canceled", (long) QFutureInterfaceBase::State::Canceled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX],
        Sbk_QFutureInterfaceBase_TypeF(), "Paused", (long) QFutureInterfaceBase::State::Paused))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX],
        Sbk_QFutureInterfaceBase_TypeF(), "Throttled", (long) QFutureInterfaceBase::State::Throttled))
        return;
    // Register converter for enum 'QFutureInterfaceBase::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX],
            QFutureInterfaceBase_State_CppToPython_QFutureInterfaceBase_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFutureInterfaceBase_State_PythonToCpp_QFutureInterfaceBase_State,
            is_QFutureInterfaceBase_State_PythonToCpp_QFutureInterfaceBase_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFUTUREINTERFACEBASE_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFutureInterfaceBase::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    qRegisterMetaType< ::QFutureInterfaceBase::State >("QFutureInterfaceBase::State");
}
