/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qeasingcurve_wrapper.h"

// inner classes

// Extra includes
#include <QVector>
#include "glue/qeasingcurve_glue.h"
#include <pysideweakref.h>
#include <qeasingcurve.h>
#include <qobject.h>
#include <qpoint.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}



// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QEasingCurve_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QEasingCurve >()))
        return -1;

    ::QEasingCurve *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QEasingCurve_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QEasingCurve", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QEasingCurve::QEasingCurve(QEasingCurve::Type)
    // 1: QEasingCurve::QEasingCurve(QEasingCurve)
    if (numArgs == 0) {
        overloadId = 0; // QEasingCurve(QEasingCurve::Type)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QEasingCurve(QEasingCurve::Type)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QEasingCurve(QEasingCurve)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurve_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QEasingCurve(QEasingCurve::Type type)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_type = Shiboken::String::createStaticString("type");
                if (PyDict_Contains(kwds, key_type)) {
                    value = PyDict_GetItem(kwds, key_type);
                    if (value && pyArgs[0]) {
                        errInfo = key_type;
                        Py_INCREF(errInfo);
                        goto Sbk_QEasingCurve_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QEasingCurve_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_type);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QEasingCurve_Init_TypeError;
                }
            }
            ::QEasingCurve::Type cppArg0 = QEasingCurve::Type::Linear;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QEasingCurve(QEasingCurve::Type)
                cptr = new ::QEasingCurve(cppArg0);
            }
            break;
        }
        case 1: // QEasingCurve(const QEasingCurve & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QEasingCurve_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QEasingCurve cppArg0_local;
            ::QEasingCurve *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QEasingCurve(QEasingCurve)
                cptr = new ::QEasingCurve(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QEasingCurve >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QEasingCurve_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QEasingCurve_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QEasingCurveFunc_addCubicBezierSegment(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.addCubicBezierSegment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addCubicBezierSegment", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QEasingCurve::addCubicBezierSegment(QPointF,QPointF,QPointF)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addCubicBezierSegment(QPointF,QPointF,QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurveFunc_addCubicBezierSegment_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPointF cppArg1_local;
        ::QPointF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPointF cppArg2_local;
        ::QPointF *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // addCubicBezierSegment(QPointF,QPointF,QPointF)
            cppSelf->addCubicBezierSegment(*cppArg0, *cppArg1, *cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEasingCurveFunc_addCubicBezierSegment_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEasingCurveFunc_addTCBSegment(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.addTCBSegment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addTCBSegment", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QEasingCurve::addTCBSegment(QPointF,qreal,qreal,qreal)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 0; // addTCBSegment(QPointF,qreal,qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurveFunc_addTCBSegment_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // addTCBSegment(QPointF,qreal,qreal,qreal)
            cppSelf->addTCBSegment(*cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEasingCurveFunc_addTCBSegment_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEasingCurveFunc_amplitude(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.amplitude";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // amplitude()const
            qreal cppResult = const_cast<const ::QEasingCurve *>(cppSelf)->amplitude();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QEasingCurveFunc_customType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.customType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // customType()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qeasingcurve-customtype)]
            //customType()
            pyResult = PySideEasingCurveFunctor::callable(self);
            // END of custom code block [file: ../glue/qtcore.cpp (qeasingcurve-customtype)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QEasingCurveFunc_overshoot(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.overshoot";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // overshoot()const
            qreal cppResult = const_cast<const ::QEasingCurve *>(cppSelf)->overshoot();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QEasingCurveFunc_period(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.period";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // period()const
            qreal cppResult = const_cast<const ::QEasingCurve *>(cppSelf)->period();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QEasingCurveFunc_setAmplitude(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.setAmplitude";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QEasingCurve::setAmplitude(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setAmplitude(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurveFunc_setAmplitude_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAmplitude(qreal)
            cppSelf->setAmplitude(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEasingCurveFunc_setAmplitude_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEasingCurveFunc_setCustomType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.setCustomType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QEasingCurve::setCustomType(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // setCustomType(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurveFunc_setCustomType_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // setCustomType(PyObject*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qeasingcurve-setcustomtype)]
            QEasingCurve::EasingFunction func = PySideEasingCurveFunctor::createCustomFuntion(self, pyArg);
            if (func)
                cppSelf->setCustomType(func);
            // END of custom code block [file: ../glue/qtcore.cpp (qeasingcurve-setcustomtype)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEasingCurveFunc_setCustomType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEasingCurveFunc_setOvershoot(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.setOvershoot";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QEasingCurve::setOvershoot(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setOvershoot(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurveFunc_setOvershoot_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOvershoot(qreal)
            cppSelf->setOvershoot(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEasingCurveFunc_setOvershoot_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEasingCurveFunc_setPeriod(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.setPeriod";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QEasingCurve::setPeriod(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setPeriod(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurveFunc_setPeriod_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPeriod(qreal)
            cppSelf->setPeriod(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEasingCurveFunc_setPeriod_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEasingCurveFunc_setType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.setType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QEasingCurve::setType(QEasingCurve::Type)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setType(QEasingCurve::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurveFunc_setType_TypeError;

    // Call function/method
    {
        ::QEasingCurve::Type cppArg0{QEasingCurve::Linear};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setType(QEasingCurve::Type)
            cppSelf->setType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEasingCurveFunc_setType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEasingCurveFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QEasingCurve::swap(QEasingCurve&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QEasingCurve&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurveFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEasingCurve cppArg0_local;
        ::QEasingCurve *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QEasingCurve&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QEasingCurveFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEasingCurveFunc_toCubicSpline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.toCubicSpline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toCubicSpline()const
            QVector<QPointF > cppResult = const_cast<const ::QEasingCurve *>(cppSelf)->toCubicSpline();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QPOINTF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QEasingCurveFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QEasingCurve::Type cppResult = const_cast<const ::QEasingCurve *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QEasingCurveFunc_valueForProgress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QEasingCurve.valueForProgress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QEasingCurve::valueForProgress(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // valueForProgress(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QEasingCurveFunc_valueForProgress_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // valueForProgress(qreal)const
            qreal cppResult = const_cast<const ::QEasingCurve *>(cppSelf)->valueForProgress(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QEasingCurveFunc_valueForProgress_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QEasingCurve___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QEasingCurve_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QEasingCurve_methods[] = {
    {"addCubicBezierSegment", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_addCubicBezierSegment), METH_VARARGS},
    {"addTCBSegment", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_addTCBSegment), METH_VARARGS},
    {"amplitude", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_amplitude), METH_NOARGS},
    {"customType", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_customType), METH_NOARGS},
    {"overshoot", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_overshoot), METH_NOARGS},
    {"period", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_period), METH_NOARGS},
    {"setAmplitude", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_setAmplitude), METH_O},
    {"setCustomType", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_setCustomType), METH_O},
    {"setOvershoot", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_setOvershoot), METH_O},
    {"setPeriod", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_setPeriod), METH_O},
    {"setType", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_setType), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_swap), METH_O},
    {"toCubicSpline", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_toCubicSpline), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_type), METH_NOARGS},
    {"valueForProgress", reinterpret_cast<PyCFunction>(Sbk_QEasingCurveFunc_valueForProgress), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QEasingCurve___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QEasingCurve_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), (pyArg)))) {
                // operator!=(const QEasingCurve & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QEasingCurve cppArg0_local;
                ::QEasingCurve *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), (pyArg)))) {
                // operator==(const QEasingCurve & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QEasingCurve cppArg0_local;
                ::QEasingCurve *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QEasingCurve_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QEasingCurve_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QEasingCurve_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QEasingCurve_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QEasingCurve__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QEasingCurve_Type = nullptr;
static SbkObjectType *Sbk_QEasingCurve_TypeF(void)
{
    return _Sbk_QEasingCurve_Type;
}

static PyType_Slot Sbk_QEasingCurve_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QEasingCurve__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QEasingCurve_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QEasingCurve_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QEasingCurve_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QEasingCurve_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QEasingCurve_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QEasingCurve_spec = {
    "2:PySide2.QtCore.QEasingCurve",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QEasingCurve_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QEasingCurve_Type_PythonToCpp_QEasingCurve_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QEasingCurve::Type *>(cppOut) =
        static_cast<::QEasingCurve::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QEasingCurve_Type_PythonToCpp_QEasingCurve_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX]))
        return QEasingCurve_Type_PythonToCpp_QEasingCurve_Type;
    return {};
}
static PyObject *QEasingCurve_Type_CppToPython_QEasingCurve_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QEasingCurve::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QEasingCurve_PythonToCpp_QEasingCurve_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QEasingCurve_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QEasingCurve_PythonToCpp_QEasingCurve_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QEasingCurve_TypeF())))
        return QEasingCurve_PythonToCpp_QEasingCurve_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QEasingCurve_PTR_CppToPython_QEasingCurve(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QEasingCurve *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QEasingCurve_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QEasingCurve_COPY_CppToPython_QEasingCurve(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QEasingCurve_TypeF(), new ::QEasingCurve(*reinterpret_cast<const ::QEasingCurve *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QEasingCurve_PythonToCpp_QEasingCurve_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QEasingCurve *>(cppOut) = *reinterpret_cast< ::QEasingCurve *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QEasingCurve_PythonToCpp_QEasingCurve_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QEasingCurve_TypeF())))
        return QEasingCurve_PythonToCpp_QEasingCurve_COPY;
    return {};
}

// Implicit conversions.
static void QEasingCurve_Type_PythonToCpp_QEasingCurve(PyObject *pyIn, void *cppOut) {
    ::QEasingCurve::Type cppIn{QEasingCurve::Linear};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QEasingCurve *>(cppOut) = ::QEasingCurve(cppIn);
}
static PythonToCppFunc is_QEasingCurve_Type_PythonToCpp_QEasingCurve_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX], pyIn))
        return QEasingCurve_Type_PythonToCpp_QEasingCurve;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QEasingCurve_SignatureStrings[] = {
    "1:PySide2.QtCore.QEasingCurve(self,type:PySide2.QtCore.QEasingCurve.Type=Linear)",
    "0:PySide2.QtCore.QEasingCurve(self,other:PySide2.QtCore.QEasingCurve)",
    "PySide2.QtCore.QEasingCurve.addCubicBezierSegment(self,c1:PySide2.QtCore.QPointF,c2:PySide2.QtCore.QPointF,endPoint:PySide2.QtCore.QPointF)",
    "PySide2.QtCore.QEasingCurve.addTCBSegment(self,nextPoint:PySide2.QtCore.QPointF,t:qreal,c:qreal,b:qreal)",
    "PySide2.QtCore.QEasingCurve.amplitude(self)->qreal",
    "PySide2.QtCore.QEasingCurve.customType(self)->PyObject",
    "PySide2.QtCore.QEasingCurve.overshoot(self)->qreal",
    "PySide2.QtCore.QEasingCurve.period(self)->qreal",
    "PySide2.QtCore.QEasingCurve.setAmplitude(self,amplitude:qreal)",
    "PySide2.QtCore.QEasingCurve.setCustomType(self,arg__1:PyObject)",
    "PySide2.QtCore.QEasingCurve.setOvershoot(self,overshoot:qreal)",
    "PySide2.QtCore.QEasingCurve.setPeriod(self,period:qreal)",
    "PySide2.QtCore.QEasingCurve.setType(self,type:PySide2.QtCore.QEasingCurve.Type)",
    "PySide2.QtCore.QEasingCurve.swap(self,other:PySide2.QtCore.QEasingCurve)",
    "PySide2.QtCore.QEasingCurve.toCubicSpline(self)->QVector[PySide2.QtCore.QPointF]",
    "PySide2.QtCore.QEasingCurve.type(self)->PySide2.QtCore.QEasingCurve.Type",
    "PySide2.QtCore.QEasingCurve.valueForProgress(self,progress:qreal)->qreal",
    "PySide2.QtCore.QEasingCurve.__copy__()",
    nullptr}; // Sentinel

void init_QEasingCurve(PyObject *module)
{
    _Sbk_QEasingCurve_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QEasingCurve",
        "QEasingCurve",
        &Sbk_QEasingCurve_spec,
        &Shiboken::callCppDestructor< ::QEasingCurve >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QEasingCurve_Type);
    InitSignatureStrings(pyType, QEasingCurve_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QEasingCurve_Type), Sbk_QEasingCurve_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QEasingCurve_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QEasingCurve_TypeF(),
        QEasingCurve_PythonToCpp_QEasingCurve_PTR,
        is_QEasingCurve_PythonToCpp_QEasingCurve_PTR_Convertible,
        QEasingCurve_PTR_CppToPython_QEasingCurve,
        QEasingCurve_COPY_CppToPython_QEasingCurve);

    Shiboken::Conversions::registerConverterName(converter, "QEasingCurve");
    Shiboken::Conversions::registerConverterName(converter, "QEasingCurve*");
    Shiboken::Conversions::registerConverterName(converter, "QEasingCurve&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QEasingCurve).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QEasingCurve_PythonToCpp_QEasingCurve_COPY,
        is_QEasingCurve_PythonToCpp_QEasingCurve_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QEasingCurve_Type_PythonToCpp_QEasingCurve,
        is_QEasingCurve_Type_PythonToCpp_QEasingCurve_Convertible);

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qeasingcurve)]
    PySideEasingCurveFunctor::init();
    // END of custom code block [file: ../glue/qtcore.cpp (qeasingcurve)]
    // ========================================================================

    // End of code injection


    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QEasingCurve_TypeF(),
        "Type",
        "2:PySide2.QtCore.QEasingCurve.Type",
        "QEasingCurve::Type");
    if (!SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "Linear", (long) QEasingCurve::Type::Linear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InQuad", (long) QEasingCurve::Type::InQuad))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutQuad", (long) QEasingCurve::Type::OutQuad))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutQuad", (long) QEasingCurve::Type::InOutQuad))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInQuad", (long) QEasingCurve::Type::OutInQuad))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InCubic", (long) QEasingCurve::Type::InCubic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutCubic", (long) QEasingCurve::Type::OutCubic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutCubic", (long) QEasingCurve::Type::InOutCubic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInCubic", (long) QEasingCurve::Type::OutInCubic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InQuart", (long) QEasingCurve::Type::InQuart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutQuart", (long) QEasingCurve::Type::OutQuart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutQuart", (long) QEasingCurve::Type::InOutQuart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInQuart", (long) QEasingCurve::Type::OutInQuart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InQuint", (long) QEasingCurve::Type::InQuint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutQuint", (long) QEasingCurve::Type::OutQuint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutQuint", (long) QEasingCurve::Type::InOutQuint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInQuint", (long) QEasingCurve::Type::OutInQuint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InSine", (long) QEasingCurve::Type::InSine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutSine", (long) QEasingCurve::Type::OutSine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutSine", (long) QEasingCurve::Type::InOutSine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInSine", (long) QEasingCurve::Type::OutInSine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InExpo", (long) QEasingCurve::Type::InExpo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutExpo", (long) QEasingCurve::Type::OutExpo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutExpo", (long) QEasingCurve::Type::InOutExpo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInExpo", (long) QEasingCurve::Type::OutInExpo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InCirc", (long) QEasingCurve::Type::InCirc))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutCirc", (long) QEasingCurve::Type::OutCirc))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutCirc", (long) QEasingCurve::Type::InOutCirc))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInCirc", (long) QEasingCurve::Type::OutInCirc))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InElastic", (long) QEasingCurve::Type::InElastic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutElastic", (long) QEasingCurve::Type::OutElastic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutElastic", (long) QEasingCurve::Type::InOutElastic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInElastic", (long) QEasingCurve::Type::OutInElastic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InBack", (long) QEasingCurve::Type::InBack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutBack", (long) QEasingCurve::Type::OutBack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutBack", (long) QEasingCurve::Type::InOutBack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInBack", (long) QEasingCurve::Type::OutInBack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InBounce", (long) QEasingCurve::Type::InBounce))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutBounce", (long) QEasingCurve::Type::OutBounce))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InOutBounce", (long) QEasingCurve::Type::InOutBounce))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutInBounce", (long) QEasingCurve::Type::OutInBounce))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "InCurve", (long) QEasingCurve::Type::InCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "OutCurve", (long) QEasingCurve::Type::OutCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "SineCurve", (long) QEasingCurve::Type::SineCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "CosineCurve", (long) QEasingCurve::Type::CosineCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "BezierSpline", (long) QEasingCurve::Type::BezierSpline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "TCBSpline", (long) QEasingCurve::Type::TCBSpline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "Custom", (long) QEasingCurve::Type::Custom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
        Sbk_QEasingCurve_TypeF(), "NCurveTypes", (long) QEasingCurve::Type::NCurveTypes))
        return;
    // Register converter for enum 'QEasingCurve::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX],
            QEasingCurve_Type_CppToPython_QEasingCurve_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QEasingCurve_Type_PythonToCpp_QEasingCurve_Type,
            is_QEasingCurve_Type_PythonToCpp_QEasingCurve_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QEasingCurve::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.


    qRegisterMetaType< ::QEasingCurve::Type >("QEasingCurve::Type");
}

