/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qdiriterator_wrapper.h"

// inner classes

// Extra includes
#include <qdir.h>
#include <qfileinfo.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDirIterator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDirIterator >()))
        return -1;

    ::QDirIterator *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDirIterator.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDirIterator_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDirIterator_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QDirIterator", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QDirIterator::QDirIterator(QDir,QFlags<QDirIterator::IteratorFlag>)
    // 1: QDirIterator::QDirIterator(QString,QFlags<QDir::Filter>,QFlags<QDirIterator::IteratorFlag>)
    // 2: QDirIterator::QDirIterator(QString,QFlags<QDirIterator::IteratorFlag>)
    // 3: QDirIterator::QDirIterator(QString,QStringList,QFlags<QDir::Filter>,QFlags<QDirIterator::IteratorFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QDirIterator(QString,QFlags<QDirIterator::IteratorFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // QDirIterator(QString,QStringList,QFlags<QDir::Filter>,QFlags<QDirIterator::IteratorFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // QDirIterator(QString,QStringList,QFlags<QDir::Filter>,QFlags<QDirIterator::IteratorFlag>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 3; // QDirIterator(QString,QStringList,QFlags<QDir::Filter>,QFlags<QDirIterator::IteratorFlag>)
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 2; // QDirIterator(QString,QFlags<QDirIterator::IteratorFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // QDirIterator(QString,QFlags<QDir::Filter>,QFlags<QDirIterator::IteratorFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // QDirIterator(QString,QFlags<QDir::Filter>,QFlags<QDirIterator::IteratorFlag>)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QDirIterator(QDir,QFlags<QDirIterator::IteratorFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // QDirIterator(QDir,QFlags<QDirIterator::IteratorFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirIterator_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDirIterator(const QDir & dir, QFlags<QDirIterator::IteratorFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[1]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirIterator_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDirIterator_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDirIterator_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDir cppArg0_local;
            ::QDir *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QFlags<QDirIterator::IteratorFlag> cppArg1 = QDirIterator::NoIteratorFlags;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QDirIterator(QDir,QFlags<QDirIterator::IteratorFlag>)
                cptr = new ::QDirIterator(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // QDirIterator(const QString & path, QFlags<QDir::Filter> filter, QFlags<QDirIterator::IteratorFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[2]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirIterator_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QDirIterator_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDirIterator_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QDir::Filter> cppArg1 = QFlags<QDir::Filter>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QDirIterator::IteratorFlag> cppArg2 = QDirIterator::NoIteratorFlags;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QDirIterator(QString,QFlags<QDir::Filter>,QFlags<QDirIterator::IteratorFlag>)
                cptr = new ::QDirIterator(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // QDirIterator(const QString & path, QFlags<QDirIterator::IteratorFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[1]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirIterator_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDirIterator_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDirIterator_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QDirIterator::IteratorFlag> cppArg1 = QDirIterator::NoIteratorFlags;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QDirIterator(QString,QFlags<QDirIterator::IteratorFlag>)
                cptr = new ::QDirIterator(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QDirIterator(const QString & path, const QStringList & nameFilters, QFlags<QDir::Filter> filters, QFlags<QDirIterator::IteratorFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_filters = Shiboken::String::createStaticString("filters");
                if (PyDict_Contains(kwds, key_filters)) {
                    value = PyDict_GetItem(kwds, key_filters);
                    if (value && pyArgs[2]) {
                        errInfo = key_filters;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirIterator_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QDirIterator_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_filters);
                }
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[3]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirIterator_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QDirIterator_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDirIterator_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QDir::Filter> cppArg2 = QDir::NoFilter;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<QDirIterator::IteratorFlag> cppArg3 = QDirIterator::NoIteratorFlags;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QDirIterator(QString,QStringList,QFlags<QDir::Filter>,QFlags<QDirIterator::IteratorFlag>)
                cptr = new ::QDirIterator(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDirIterator >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDirIterator_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDirIterator_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDirIteratorFunc_fileInfo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDirIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDirIterator.fileInfo";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileInfo()const
            QFileInfo cppResult = const_cast<const ::QDirIterator *>(cppSelf)->fileInfo();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirIteratorFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDirIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDirIterator.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = const_cast<const ::QDirIterator *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirIteratorFunc_filePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDirIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDirIterator.filePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filePath()const
            QString cppResult = const_cast<const ::QDirIterator *>(cppSelf)->filePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirIteratorFunc_hasNext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDirIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDirIterator.hasNext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasNext()const
            bool cppResult = const_cast<const ::QDirIterator *>(cppSelf)->hasNext();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirIteratorFunc_next(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDirIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDirIterator.next";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // next()
            QString cppResult = cppSelf->next();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirIteratorFunc_path(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDirIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDirIterator.path";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // path()const
            QString cppResult = const_cast<const ::QDirIterator *>(cppSelf)->path();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDirIterator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDirIterator_methods[] = {
    {"fileInfo", reinterpret_cast<PyCFunction>(Sbk_QDirIteratorFunc_fileInfo), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QDirIteratorFunc_fileName), METH_NOARGS},
    {"filePath", reinterpret_cast<PyCFunction>(Sbk_QDirIteratorFunc_filePath), METH_NOARGS},
    {"hasNext", reinterpret_cast<PyCFunction>(Sbk_QDirIteratorFunc_hasNext), METH_NOARGS},
    {"next", reinterpret_cast<PyCFunction>(Sbk_QDirIteratorFunc_next), METH_NOARGS},
    {"path", reinterpret_cast<PyCFunction>(Sbk_QDirIteratorFunc_path), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QDirIterator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDirIterator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDirIterator_Type = nullptr;
static SbkObjectType *Sbk_QDirIterator_TypeF(void)
{
    return _Sbk_QDirIterator_Type;
}

static PyType_Slot Sbk_QDirIterator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDirIterator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDirIterator_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDirIterator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDirIterator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QDirIterator_spec = {
    "2:PySide2.QtCore.QDirIterator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDirIterator_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QDirIterator_IteratorFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QDirIterator::IteratorFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QDirIterator::IteratorFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QDirIterator::IteratorFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QDirIterator::IteratorFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QDirIterator::IteratorFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QDirIterator_IteratorFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QDirIterator::IteratorFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QDirIterator::IteratorFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QDirIterator::IteratorFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QDirIterator::IteratorFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QDirIterator::IteratorFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QDirIterator_IteratorFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QDirIterator::IteratorFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QDirIterator::IteratorFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QDirIterator::IteratorFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QDirIterator::IteratorFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QDirIterator::IteratorFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QDirIterator_IteratorFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QDirIterator::IteratorFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, self, &cppSelf);
    ::QDirIterator::IteratorFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QDirIterator_IteratorFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QDirIterator_IteratorFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QDirIterator_IteratorFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QDirIterator_IteratorFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QDirIterator_IteratorFlag_PythonToCpp_QDirIterator_IteratorFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDirIterator::IteratorFlag *>(cppOut) =
        static_cast<::QDirIterator::IteratorFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDirIterator_IteratorFlag_PythonToCpp_QDirIterator_IteratorFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX]))
        return QDirIterator_IteratorFlag_PythonToCpp_QDirIterator_IteratorFlag;
    return {};
}
static PyObject *QDirIterator_IteratorFlag_CppToPython_QDirIterator_IteratorFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDirIterator::IteratorFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX], castCppIn);

}

static void QFlags_QDirIterator_IteratorFlag__PythonToCpp_QFlags_QDirIterator_IteratorFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QDirIterator::IteratorFlag> *>(cppOut) =
        ::QFlags<QDirIterator::IteratorFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QDirIterator_IteratorFlag__PythonToCpp_QFlags_QDirIterator_IteratorFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX]))
        return QFlags_QDirIterator_IteratorFlag__PythonToCpp_QFlags_QDirIterator_IteratorFlag_;
    return {};
}
static PyObject *QFlags_QDirIterator_IteratorFlag__CppToPython_QFlags_QDirIterator_IteratorFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QDirIterator::IteratorFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX]));

}

static void QDirIterator_IteratorFlag_PythonToCpp_QFlags_QDirIterator_IteratorFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QDirIterator::IteratorFlag> *>(cppOut) =
        ::QFlags<QDirIterator::IteratorFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QDirIterator_IteratorFlag_PythonToCpp_QFlags_QDirIterator_IteratorFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX]))
        return QDirIterator_IteratorFlag_PythonToCpp_QFlags_QDirIterator_IteratorFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QDirIterator_IteratorFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QDirIterator::IteratorFlag> *>(cppOut) =
        ::QFlags<QDirIterator::IteratorFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QDirIterator_IteratorFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX]))
        return number_PythonToCpp_QFlags_QDirIterator_IteratorFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDirIterator_PythonToCpp_QDirIterator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDirIterator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDirIterator_PythonToCpp_QDirIterator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDirIterator_TypeF())))
        return QDirIterator_PythonToCpp_QDirIterator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDirIterator_PTR_CppToPython_QDirIterator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDirIterator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDirIterator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDirIterator_SignatureStrings[] = {
    "3:PySide2.QtCore.QDirIterator(self,dir:PySide2.QtCore.QDir,flags:PySide2.QtCore.QDirIterator.IteratorFlags=QDirIterator.NoIteratorFlags)",
    "2:PySide2.QtCore.QDirIterator(self,path:QString,filter:PySide2.QtCore.QDir.Filters,flags:PySide2.QtCore.QDirIterator.IteratorFlags=QDirIterator.NoIteratorFlags)",
    "1:PySide2.QtCore.QDirIterator(self,path:QString,flags:PySide2.QtCore.QDirIterator.IteratorFlags=QDirIterator.NoIteratorFlags)",
    "0:PySide2.QtCore.QDirIterator(self,path:QString,nameFilters:QStringList,filters:PySide2.QtCore.QDir.Filters=QDir.NoFilter,flags:PySide2.QtCore.QDirIterator.IteratorFlags=QDirIterator.NoIteratorFlags)",
    "PySide2.QtCore.QDirIterator.fileInfo(self)->PySide2.QtCore.QFileInfo",
    "PySide2.QtCore.QDirIterator.fileName(self)->QString",
    "PySide2.QtCore.QDirIterator.filePath(self)->QString",
    "PySide2.QtCore.QDirIterator.hasNext(self)->bool",
    "PySide2.QtCore.QDirIterator.next(self)->QString",
    "PySide2.QtCore.QDirIterator.path(self)->QString",
    nullptr}; // Sentinel

void init_QDirIterator(PyObject *module)
{
    _Sbk_QDirIterator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDirIterator",
        "QDirIterator*",
        &Sbk_QDirIterator_spec,
        &Shiboken::callCppDestructor< ::QDirIterator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDirIterator_Type);
    InitSignatureStrings(pyType, QDirIterator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDirIterator_Type), Sbk_QDirIterator_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDirIterator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDirIterator_TypeF(),
        QDirIterator_PythonToCpp_QDirIterator_PTR,
        is_QDirIterator_PythonToCpp_QDirIterator_PTR_Convertible,
        QDirIterator_PTR_CppToPython_QDirIterator);

    Shiboken::Conversions::registerConverterName(converter, "QDirIterator");
    Shiboken::Conversions::registerConverterName(converter, "QDirIterator*");
    Shiboken::Conversions::registerConverterName(converter, "QDirIterator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDirIterator).name());


    // Initialization of enums.

    // Initialization of enum 'IteratorFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QDirIterator.IteratorFlags", SbkPySide2_QtCore_QDirIterator_IteratorFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDirIterator_TypeF(),
        "IteratorFlag",
        "2:PySide2.QtCore.QDirIterator.IteratorFlag",
        "QDirIterator::IteratorFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX],
        Sbk_QDirIterator_TypeF(), "NoIteratorFlags", (long) QDirIterator::IteratorFlag::NoIteratorFlags))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX],
        Sbk_QDirIterator_TypeF(), "FollowSymlinks", (long) QDirIterator::IteratorFlag::FollowSymlinks))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX],
        Sbk_QDirIterator_TypeF(), "Subdirectories", (long) QDirIterator::IteratorFlag::Subdirectories))
        return;
    // Register converter for enum 'QDirIterator::IteratorFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX],
            QDirIterator_IteratorFlag_CppToPython_QDirIterator_IteratorFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDirIterator_IteratorFlag_PythonToCpp_QDirIterator_IteratorFlag,
            is_QDirIterator_IteratorFlag_PythonToCpp_QDirIterator_IteratorFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDirIterator::IteratorFlag");
        Shiboken::Conversions::registerConverterName(converter, "IteratorFlag");
    }
    // Register converter for flag 'QFlags<QDirIterator::IteratorFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX],
            QFlags_QDirIterator_IteratorFlag__CppToPython_QFlags_QDirIterator_IteratorFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDirIterator_IteratorFlag_PythonToCpp_QFlags_QDirIterator_IteratorFlag_,
            is_QDirIterator_IteratorFlag_PythonToCpp_QFlags_QDirIterator_IteratorFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QDirIterator_IteratorFlag__PythonToCpp_QFlags_QDirIterator_IteratorFlag_,
            is_QFlags_QDirIterator_IteratorFlag__PythonToCpp_QFlags_QDirIterator_IteratorFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QDirIterator_IteratorFlag_,
            is_number_PythonToCpp_QFlags_QDirIterator_IteratorFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDirIterator::IteratorFlags");
        Shiboken::Conversions::registerConverterName(converter, "IteratorFlags");
    }
    // End of 'IteratorFlag' enum/flags.

    qRegisterMetaType< ::QDirIterator::IteratorFlag >("QDirIterator::IteratorFlag");
    qRegisterMetaType< ::QDirIterator::IteratorFlags >("QDirIterator::IteratorFlags");
}
