/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcalendar_wrapper.h"

// inner classes
#include "qcalendar_yearmonthday_wrapper.h"

// Extra includes
#include <qcalendar.h>
#include <qdatetime.h>
#include <qlocale.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCalendar_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCalendar >()))
        return -1;

    ::QCalendar *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCalendar", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCalendar::QCalendar()
    // 1: QCalendar::QCalendar(QCalendar::System)
    if (numArgs == 0) {
        overloadId = 0; // QCalendar()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QCalendar(QCalendar::System)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendar_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCalendar()
        {

            if (!PyErr_Occurred()) {
                // QCalendar()
                cptr = new ::QCalendar();
            }
            break;
        }
        case 1: // QCalendar(QCalendar::System system)
        {
            ::QCalendar::System cppArg0{QCalendar::System::Gregorian};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCalendar(QCalendar::System)
                cptr = new ::QCalendar(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCalendar >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCalendar_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCalendar_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCalendarFunc_availableCalendars(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.availableCalendars";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableCalendars()
            QStringList cppResult = ::QCalendar::availableCalendars();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_dateFromParts(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.dateFromParts";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto Sbk_QCalendarFunc_dateFromParts_TypeError;

    if (!PyArg_UnpackTuple(args, "dateFromParts", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QCalendar::dateFromParts(QCalendar::YearMonthDay)const
    // 1: QCalendar::dateFromParts(int,int,int)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 1; // dateFromParts(int,int,int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // dateFromParts(QCalendar::YearMonthDay)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_dateFromParts_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // dateFromParts(const QCalendar::YearMonthDay & parts) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCalendar::YearMonthDay cppArg0_local;
            ::QCalendar::YearMonthDay *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // dateFromParts(QCalendar::YearMonthDay)const
                QDate cppResult = const_cast<const ::QCalendar *>(cppSelf)->dateFromParts(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // dateFromParts(int year, int month, int day) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // dateFromParts(int,int,int)const
                QDate cppResult = const_cast<const ::QCalendar *>(cppSelf)->dateFromParts(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_dateFromParts_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_dayOfWeek(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.dayOfWeek";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCalendar::dayOfWeek(QDate)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
        overloadId = 0; // dayOfWeek(QDate)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_dayOfWeek_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dayOfWeek(QDate)const
            int cppResult = const_cast<const ::QCalendar *>(cppSelf)->dayOfWeek(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_dayOfWeek_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_daysInMonth(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.daysInMonth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_daysInMonth_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_daysInMonth_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:daysInMonth", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCalendar::daysInMonth(int,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // daysInMonth(int,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // daysInMonth(int,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_daysInMonth_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_year = Shiboken::String::createStaticString("year");
            if (PyDict_Contains(kwds, key_year)) {
                value = PyDict_GetItem(kwds, key_year);
                if (value && pyArgs[1]) {
                    errInfo = key_year;
                    Py_INCREF(errInfo);
                    goto Sbk_QCalendarFunc_daysInMonth_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QCalendarFunc_daysInMonth_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_year);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCalendarFunc_daysInMonth_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = QCalendar::Unspecified;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // daysInMonth(int,int)const
            int cppResult = const_cast<const ::QCalendar *>(cppSelf)->daysInMonth(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_daysInMonth_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_daysInYear(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.daysInYear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCalendar::daysInYear(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // daysInYear(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_daysInYear_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // daysInYear(int)const
            int cppResult = const_cast<const ::QCalendar *>(cppSelf)->daysInYear(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_daysInYear_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_hasYearZero(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.hasYearZero";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasYearZero()const
            bool cppResult = const_cast<const ::QCalendar *>(cppSelf)->hasYearZero();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_isDateValid(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.isDateValid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isDateValid", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QCalendar::isDateValid(int,int,int)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // isDateValid(int,int,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_isDateValid_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // isDateValid(int,int,int)const
            bool cppResult = const_cast<const ::QCalendar *>(cppSelf)->isDateValid(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_isDateValid_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_isGregorian(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.isGregorian";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isGregorian()const
            bool cppResult = const_cast<const ::QCalendar *>(cppSelf)->isGregorian();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_isLeapYear(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.isLeapYear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCalendar::isLeapYear(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // isLeapYear(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_isLeapYear_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isLeapYear(int)const
            bool cppResult = const_cast<const ::QCalendar *>(cppSelf)->isLeapYear(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_isLeapYear_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_isLunar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.isLunar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLunar()const
            bool cppResult = const_cast<const ::QCalendar *>(cppSelf)->isLunar();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_isLuniSolar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.isLuniSolar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLuniSolar()const
            bool cppResult = const_cast<const ::QCalendar *>(cppSelf)->isLuniSolar();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_isProleptic(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.isProleptic";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isProleptic()const
            bool cppResult = const_cast<const ::QCalendar *>(cppSelf)->isProleptic();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_isSolar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.isSolar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSolar()const
            bool cppResult = const_cast<const ::QCalendar *>(cppSelf)->isSolar();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QCalendar *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_maximumDaysInMonth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.maximumDaysInMonth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumDaysInMonth()const
            int cppResult = const_cast<const ::QCalendar *>(cppSelf)->maximumDaysInMonth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_maximumMonthsInYear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.maximumMonthsInYear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumMonthsInYear()const
            int cppResult = const_cast<const ::QCalendar *>(cppSelf)->maximumMonthsInYear();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_minimumDaysInMonth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.minimumDaysInMonth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumDaysInMonth()const
            int cppResult = const_cast<const ::QCalendar *>(cppSelf)->minimumDaysInMonth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_monthName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.monthName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_monthName_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_monthName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:monthName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QCalendar::monthName(QLocale,int,int,QLocale::FormatType)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // monthName(QLocale,int,int,QLocale::FormatType)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // monthName(QLocale,int,int,QLocale::FormatType)const
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[3])))) {
                overloadId = 0; // monthName(QLocale,int,int,QLocale::FormatType)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_monthName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_year = Shiboken::String::createStaticString("year");
            if (PyDict_Contains(kwds, key_year)) {
                value = PyDict_GetItem(kwds, key_year);
                if (value && pyArgs[2]) {
                    errInfo = key_year;
                    Py_INCREF(errInfo);
                    goto Sbk_QCalendarFunc_monthName_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QCalendarFunc_monthName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_year);
            }
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[3]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QCalendarFunc_monthName_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QCalendarFunc_monthName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCalendarFunc_monthName_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = QCalendar::Unspecified;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QLocale::FormatType cppArg3 = QLocale::LongFormat;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // monthName(QLocale,int,int,QLocale::FormatType)const
            QString cppResult = const_cast<const ::QCalendar *>(cppSelf)->monthName(*cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_monthName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_monthsInYear(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.monthsInYear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCalendar::monthsInYear(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // monthsInYear(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_monthsInYear_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // monthsInYear(int)const
            int cppResult = const_cast<const ::QCalendar *>(cppSelf)->monthsInYear(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_monthsInYear_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QCalendar *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendarFunc_partsFromDate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.partsFromDate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCalendar::partsFromDate(QDate)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
        overloadId = 0; // partsFromDate(QDate)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_partsFromDate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // partsFromDate(QDate)const
            QCalendar::YearMonthDay cppResult = const_cast<const ::QCalendar *>(cppSelf)->partsFromDate(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_partsFromDate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_standaloneMonthName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.standaloneMonthName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_standaloneMonthName_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_standaloneMonthName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:standaloneMonthName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QCalendar::standaloneMonthName(QLocale,int,int,QLocale::FormatType)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // standaloneMonthName(QLocale,int,int,QLocale::FormatType)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // standaloneMonthName(QLocale,int,int,QLocale::FormatType)const
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[3])))) {
                overloadId = 0; // standaloneMonthName(QLocale,int,int,QLocale::FormatType)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_standaloneMonthName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_year = Shiboken::String::createStaticString("year");
            if (PyDict_Contains(kwds, key_year)) {
                value = PyDict_GetItem(kwds, key_year);
                if (value && pyArgs[2]) {
                    errInfo = key_year;
                    Py_INCREF(errInfo);
                    goto Sbk_QCalendarFunc_standaloneMonthName_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QCalendarFunc_standaloneMonthName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_year);
            }
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[3]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QCalendarFunc_standaloneMonthName_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QCalendarFunc_standaloneMonthName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCalendarFunc_standaloneMonthName_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = QCalendar::Unspecified;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QLocale::FormatType cppArg3 = QLocale::LongFormat;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // standaloneMonthName(QLocale,int,int,QLocale::FormatType)const
            QString cppResult = const_cast<const ::QCalendar *>(cppSelf)->standaloneMonthName(*cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_standaloneMonthName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_standaloneWeekDayName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.standaloneWeekDayName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_standaloneWeekDayName_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_standaloneWeekDayName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:standaloneWeekDayName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QCalendar::standaloneWeekDayName(QLocale,int,QLocale::FormatType)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // standaloneWeekDayName(QLocale,int,QLocale::FormatType)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // standaloneWeekDayName(QLocale,int,QLocale::FormatType)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_standaloneWeekDayName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[2]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QCalendarFunc_standaloneWeekDayName_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QCalendarFunc_standaloneWeekDayName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCalendarFunc_standaloneWeekDayName_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QLocale::FormatType cppArg2 = QLocale::LongFormat;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // standaloneWeekDayName(QLocale,int,QLocale::FormatType)const
            QString cppResult = const_cast<const ::QCalendar *>(cppSelf)->standaloneWeekDayName(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_standaloneWeekDayName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendarFunc_weekDayName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.weekDayName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_weekDayName_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCalendarFunc_weekDayName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:weekDayName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QCalendar::weekDayName(QLocale,int,QLocale::FormatType)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // weekDayName(QLocale,int,QLocale::FormatType)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // weekDayName(QLocale,int,QLocale::FormatType)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendarFunc_weekDayName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[2]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QCalendarFunc_weekDayName_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QCalendarFunc_weekDayName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCalendarFunc_weekDayName_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QLocale::FormatType cppArg2 = QLocale::LongFormat;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // weekDayName(QLocale,int,QLocale::FormatType)const
            QString cppResult = const_cast<const ::QCalendar *>(cppSelf)->weekDayName(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCalendarFunc_weekDayName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCalendar___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCalendar_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCalendar_methods[] = {
    {"availableCalendars", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_availableCalendars), METH_NOARGS|METH_STATIC},
    {"dateFromParts", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_dateFromParts), METH_VARARGS},
    {"dayOfWeek", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_dayOfWeek), METH_O},
    {"daysInMonth", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_daysInMonth), METH_VARARGS|METH_KEYWORDS},
    {"daysInYear", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_daysInYear), METH_O},
    {"hasYearZero", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_hasYearZero), METH_NOARGS},
    {"isDateValid", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_isDateValid), METH_VARARGS},
    {"isGregorian", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_isGregorian), METH_NOARGS},
    {"isLeapYear", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_isLeapYear), METH_O},
    {"isLunar", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_isLunar), METH_NOARGS},
    {"isLuniSolar", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_isLuniSolar), METH_NOARGS},
    {"isProleptic", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_isProleptic), METH_NOARGS},
    {"isSolar", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_isSolar), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_isValid), METH_NOARGS},
    {"maximumDaysInMonth", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_maximumDaysInMonth), METH_NOARGS},
    {"maximumMonthsInYear", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_maximumMonthsInYear), METH_NOARGS},
    {"minimumDaysInMonth", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_minimumDaysInMonth), METH_NOARGS},
    {"monthName", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_monthName), METH_VARARGS|METH_KEYWORDS},
    {"monthsInYear", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_monthsInYear), METH_O},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_name), METH_NOARGS},
    {"partsFromDate", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_partsFromDate), METH_O},
    {"standaloneMonthName", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_standaloneMonthName), METH_VARARGS|METH_KEYWORDS},
    {"standaloneWeekDayName", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_standaloneWeekDayName), METH_VARARGS|METH_KEYWORDS},
    {"weekDayName", reinterpret_cast<PyCFunction>(Sbk_QCalendarFunc_weekDayName), METH_VARARGS|METH_KEYWORDS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCalendar___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCalendar_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCalendar_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCalendar_Type = nullptr;
static SbkObjectType *Sbk_QCalendar_TypeF(void)
{
    return _Sbk_QCalendar_Type;
}

static PyType_Slot Sbk_QCalendar_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCalendar_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCalendar_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCalendar_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCalendar_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCalendar_spec = {
    "2:PySide2.QtCore.QCalendar",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCalendar_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QCalendar_System_PythonToCpp_QCalendar_System(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCalendar::System *>(cppOut) =
        static_cast<::QCalendar::System>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCalendar_System_PythonToCpp_QCalendar_System_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX]))
        return QCalendar_System_PythonToCpp_QCalendar_System;
    return {};
}
static PyObject *QCalendar_System_CppToPython_QCalendar_System(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCalendar::System *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCalendar_PythonToCpp_QCalendar_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCalendar_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCalendar_PythonToCpp_QCalendar_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCalendar_TypeF())))
        return QCalendar_PythonToCpp_QCalendar_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCalendar_PTR_CppToPython_QCalendar(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCalendar *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCalendar_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QCalendar_COPY_CppToPython_QCalendar(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCalendar_TypeF(), new ::QCalendar(*reinterpret_cast<const ::QCalendar *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QCalendar_PythonToCpp_QCalendar_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCalendar *>(cppOut) = *reinterpret_cast< ::QCalendar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QCalendar_PythonToCpp_QCalendar_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCalendar_TypeF())))
        return QCalendar_PythonToCpp_QCalendar_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCalendar_SignatureStrings[] = {
    "1:PySide2.QtCore.QCalendar(self)",
    "0:PySide2.QtCore.QCalendar(self,system:PySide2.QtCore.QCalendar.System)",
    "PySide2.QtCore.QCalendar.availableCalendars()->QStringList",
    "1:PySide2.QtCore.QCalendar.dateFromParts(self,parts:PySide2.QtCore.QCalendar.YearMonthDay)->PySide2.QtCore.QDate",
    "0:PySide2.QtCore.QCalendar.dateFromParts(self,year:int,month:int,day:int)->PySide2.QtCore.QDate",
    "PySide2.QtCore.QCalendar.dayOfWeek(self,date:PySide2.QtCore.QDate)->int",
    "PySide2.QtCore.QCalendar.daysInMonth(self,month:int,year:int=Unspecified)->int",
    "PySide2.QtCore.QCalendar.daysInYear(self,year:int)->int",
    "PySide2.QtCore.QCalendar.hasYearZero(self)->bool",
    "PySide2.QtCore.QCalendar.isDateValid(self,year:int,month:int,day:int)->bool",
    "PySide2.QtCore.QCalendar.isGregorian(self)->bool",
    "PySide2.QtCore.QCalendar.isLeapYear(self,year:int)->bool",
    "PySide2.QtCore.QCalendar.isLunar(self)->bool",
    "PySide2.QtCore.QCalendar.isLuniSolar(self)->bool",
    "PySide2.QtCore.QCalendar.isProleptic(self)->bool",
    "PySide2.QtCore.QCalendar.isSolar(self)->bool",
    "PySide2.QtCore.QCalendar.isValid(self)->bool",
    "PySide2.QtCore.QCalendar.maximumDaysInMonth(self)->int",
    "PySide2.QtCore.QCalendar.maximumMonthsInYear(self)->int",
    "PySide2.QtCore.QCalendar.minimumDaysInMonth(self)->int",
    "PySide2.QtCore.QCalendar.monthName(self,locale:PySide2.QtCore.QLocale,month:int,year:int=Unspecified,format:PySide2.QtCore.QLocale.FormatType=QLocale.LongFormat)->QString",
    "PySide2.QtCore.QCalendar.monthsInYear(self,year:int)->int",
    "PySide2.QtCore.QCalendar.name(self)->QString",
    "PySide2.QtCore.QCalendar.partsFromDate(self,date:PySide2.QtCore.QDate)->PySide2.QtCore.QCalendar.YearMonthDay",
    "PySide2.QtCore.QCalendar.standaloneMonthName(self,locale:PySide2.QtCore.QLocale,month:int,year:int=Unspecified,format:PySide2.QtCore.QLocale.FormatType=QLocale.LongFormat)->QString",
    "PySide2.QtCore.QCalendar.standaloneWeekDayName(self,locale:PySide2.QtCore.QLocale,day:int,format:PySide2.QtCore.QLocale.FormatType=QLocale.LongFormat)->QString",
    "PySide2.QtCore.QCalendar.weekDayName(self,locale:PySide2.QtCore.QLocale,day:int,format:PySide2.QtCore.QLocale.FormatType=QLocale.LongFormat)->QString",
    "PySide2.QtCore.QCalendar.__copy__()",
    nullptr}; // Sentinel

void init_QCalendar(PyObject *module)
{
    _Sbk_QCalendar_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCalendar",
        "QCalendar",
        &Sbk_QCalendar_spec,
        &Shiboken::callCppDestructor< ::QCalendar >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCalendar_Type);
    InitSignatureStrings(pyType, QCalendar_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCalendar_Type), Sbk_QCalendar_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCalendar_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCalendar_TypeF(),
        QCalendar_PythonToCpp_QCalendar_PTR,
        is_QCalendar_PythonToCpp_QCalendar_PTR_Convertible,
        QCalendar_PTR_CppToPython_QCalendar,
        QCalendar_COPY_CppToPython_QCalendar);

    Shiboken::Conversions::registerConverterName(converter, "QCalendar");
    Shiboken::Conversions::registerConverterName(converter, "QCalendar*");
    Shiboken::Conversions::registerConverterName(converter, "QCalendar&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCalendar).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCalendar_PythonToCpp_QCalendar_COPY,
        is_QCalendar_PythonToCpp_QCalendar_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'System'.
    SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCalendar_TypeF(),
        "System",
        "2:PySide2.QtCore.QCalendar.System",
        "QCalendar::System");
    if (!SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX], "Gregorian", (long) QCalendar::System::Gregorian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX], "Julian", (long) QCalendar::System::Julian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX], "Milankovic", (long) QCalendar::System::Milankovic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX], "Jalali", (long) QCalendar::System::Jalali))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX], "IslamicCivil", (long) QCalendar::System::IslamicCivil))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX], "Last", (long) QCalendar::System::Last))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX],
        SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX], "User", (long) QCalendar::System::User))
        return;
    // Register converter for enum 'QCalendar::System'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX],
            QCalendar_System_CppToPython_QCalendar_System);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCalendar_System_PythonToCpp_QCalendar_System,
            is_QCalendar_System_PythonToCpp_QCalendar_System_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_SYSTEM_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCalendar::System");
        Shiboken::Conversions::registerConverterName(converter, "System");
    }
    // End of 'System' enum.

    qRegisterMetaType< ::QCalendar >("QCalendar");
    qRegisterMetaType< ::QCalendar::System >("QCalendar::System");
}
