/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qbytearraymatcher_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>
#include <qbytearraymatcher.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QByteArrayMatcher_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QByteArrayMatcher >()))
        return -1;

    ::QByteArrayMatcher *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArrayMatcher.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QByteArrayMatcher", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QByteArrayMatcher::QByteArrayMatcher()
    // 1: QByteArrayMatcher::QByteArrayMatcher(QByteArray)
    // 2: QByteArrayMatcher::QByteArrayMatcher(QByteArrayMatcher)
    // 3: QByteArrayMatcher::QByteArrayMatcher(const char*,int)
    if (numArgs == 0) {
        overloadId = 0; // QByteArrayMatcher()
    } else if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 3; // QByteArrayMatcher(const char*,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QByteArrayMatcher(QByteArrayMatcher)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QByteArrayMatcher(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayMatcher_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QByteArrayMatcher()
        {

            if (!PyErr_Occurred()) {
                // QByteArrayMatcher()
                cptr = new ::QByteArrayMatcher();
            }
            break;
        }
        case 1: // QByteArrayMatcher(const QByteArray & pattern)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QByteArrayMatcher(QByteArray)
                cptr = new ::QByteArrayMatcher(*cppArg0);
            }
            break;
        }
        case 2: // QByteArrayMatcher(const QByteArrayMatcher & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArrayMatcher cppArg0_local;
            ::QByteArrayMatcher *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QByteArrayMatcher(QByteArrayMatcher)
                cptr = new ::QByteArrayMatcher(*cppArg0);
            }
            break;
        }
        case 3: // QByteArrayMatcher(const char * pattern, int length)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QByteArrayMatcher(const char*,int)
                cptr = new ::QByteArrayMatcher(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QByteArrayMatcher >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QByteArrayMatcher_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QByteArrayMatcher_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QByteArrayMatcherFunc_indexIn(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArrayMatcher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArrayMatcher.indexIn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayMatcherFunc_indexIn_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayMatcherFunc_indexIn_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:indexIn", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QByteArrayMatcher::indexIn(QByteArray,int)const
    // 1: QByteArrayMatcher::indexIn(const char*,int,int)const
    if (numArgs >= 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // indexIn(const char*,int,int)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 1; // indexIn(const char*,int,int)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // indexIn(QByteArray,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // indexIn(QByteArray,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayMatcherFunc_indexIn_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // indexIn(const QByteArray & ba, int from) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_from = Shiboken::String::createStaticString("from");
                if (PyDict_Contains(kwds, key_from)) {
                    value = PyDict_GetItem(kwds, key_from);
                    if (value && pyArgs[1]) {
                        errInfo = key_from;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayMatcherFunc_indexIn_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QByteArrayMatcherFunc_indexIn_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_from);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayMatcherFunc_indexIn_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // indexIn(QByteArray,int)const
                int cppResult = const_cast<const ::QByteArrayMatcher *>(cppSelf)->indexIn(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // indexIn(const char * str, int len, int from) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_from = Shiboken::String::createStaticString("from");
                if (PyDict_Contains(kwds, key_from)) {
                    value = PyDict_GetItem(kwds, key_from);
                    if (value && pyArgs[2]) {
                        errInfo = key_from;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayMatcherFunc_indexIn_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QByteArrayMatcherFunc_indexIn_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_from);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayMatcherFunc_indexIn_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // indexIn(const char*,int,int)const
                int cppResult = const_cast<const ::QByteArrayMatcher *>(cppSelf)->indexIn(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayMatcherFunc_indexIn_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayMatcherFunc_pattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArrayMatcher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArrayMatcher.pattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pattern()const
            QByteArray cppResult = const_cast<const ::QByteArrayMatcher *>(cppSelf)->pattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayMatcherFunc_setPattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArrayMatcher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArrayMatcher.setPattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArrayMatcher::setPattern(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setPattern(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayMatcherFunc_setPattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPattern(QByteArray)
            cppSelf->setPattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QByteArrayMatcherFunc_setPattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayMatcher___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QByteArrayMatcher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QByteArrayMatcher_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QByteArrayMatcher_methods[] = {
    {"indexIn", reinterpret_cast<PyCFunction>(Sbk_QByteArrayMatcherFunc_indexIn), METH_VARARGS|METH_KEYWORDS},
    {"pattern", reinterpret_cast<PyCFunction>(Sbk_QByteArrayMatcherFunc_pattern), METH_NOARGS},
    {"setPattern", reinterpret_cast<PyCFunction>(Sbk_QByteArrayMatcherFunc_setPattern), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QByteArrayMatcher___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QByteArrayMatcher_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QByteArrayMatcher_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QByteArrayMatcher_Type = nullptr;
static SbkObjectType *Sbk_QByteArrayMatcher_TypeF(void)
{
    return _Sbk_QByteArrayMatcher_Type;
}

static PyType_Slot Sbk_QByteArrayMatcher_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QByteArrayMatcher_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QByteArrayMatcher_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QByteArrayMatcher_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QByteArrayMatcher_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QByteArrayMatcher_spec = {
    "2:PySide2.QtCore.QByteArrayMatcher",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QByteArrayMatcher_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QByteArrayMatcher_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QByteArrayMatcher_TypeF())))
        return QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QByteArrayMatcher_PTR_CppToPython_QByteArrayMatcher(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QByteArrayMatcher *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QByteArrayMatcher_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QByteArrayMatcher_COPY_CppToPython_QByteArrayMatcher(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QByteArrayMatcher_TypeF(), new ::QByteArrayMatcher(*reinterpret_cast<const ::QByteArrayMatcher *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QByteArrayMatcher *>(cppOut) = *reinterpret_cast< ::QByteArrayMatcher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QByteArrayMatcher_TypeF())))
        return QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QByteArrayMatcher_SignatureStrings[] = {
    "3:PySide2.QtCore.QByteArrayMatcher(self)",
    "2:PySide2.QtCore.QByteArrayMatcher(self,pattern:PySide2.QtCore.QByteArray)",
    "1:PySide2.QtCore.QByteArrayMatcher(self,other:PySide2.QtCore.QByteArrayMatcher)",
    "0:PySide2.QtCore.QByteArrayMatcher(self,pattern:char*,length:int)",
    "1:PySide2.QtCore.QByteArrayMatcher.indexIn(self,ba:PySide2.QtCore.QByteArray,from:int=0)->int",
    "0:PySide2.QtCore.QByteArrayMatcher.indexIn(self,str:char*,len:int,from:int=0)->int",
    "PySide2.QtCore.QByteArrayMatcher.pattern(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArrayMatcher.setPattern(self,pattern:PySide2.QtCore.QByteArray)",
    "PySide2.QtCore.QByteArrayMatcher.__copy__()",
    nullptr}; // Sentinel

void init_QByteArrayMatcher(PyObject *module)
{
    _Sbk_QByteArrayMatcher_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QByteArrayMatcher",
        "QByteArrayMatcher",
        &Sbk_QByteArrayMatcher_spec,
        &Shiboken::callCppDestructor< ::QByteArrayMatcher >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QByteArrayMatcher_Type);
    InitSignatureStrings(pyType, QByteArrayMatcher_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QByteArrayMatcher_Type), Sbk_QByteArrayMatcher_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QByteArrayMatcher_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QByteArrayMatcher_TypeF(),
        QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_PTR,
        is_QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_PTR_Convertible,
        QByteArrayMatcher_PTR_CppToPython_QByteArrayMatcher,
        QByteArrayMatcher_COPY_CppToPython_QByteArrayMatcher);

    Shiboken::Conversions::registerConverterName(converter, "QByteArrayMatcher");
    Shiboken::Conversions::registerConverterName(converter, "QByteArrayMatcher*");
    Shiboken::Conversions::registerConverterName(converter, "QByteArrayMatcher&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QByteArrayMatcher).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_COPY,
        is_QByteArrayMatcher_PythonToCpp_QByteArrayMatcher_COPY_Convertible);

    qRegisterMetaType< ::QByteArrayMatcher >("QByteArrayMatcher");
}
