/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qbytearray_frombase64result_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QByteArray_FromBase64Result_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QByteArray::FromBase64Result >()))
        return -1;

    ::QByteArray::FromBase64Result *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.FromBase64Result.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "FromBase64Result", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: FromBase64Result::FromBase64Result()
    // 1: FromBase64Result::FromBase64Result(QByteArray::FromBase64Result)
    if (numArgs == 0) {
        overloadId = 0; // FromBase64Result()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // FromBase64Result(QByteArray::FromBase64Result)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArray_FromBase64Result_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // FromBase64Result()
        {

            if (!PyErr_Occurred()) {
                // FromBase64Result()
                cptr = new ::QByteArray::FromBase64Result();
            }
            break;
        }
        case 1: // FromBase64Result(const QByteArray::FromBase64Result & FromBase64Result)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray::FromBase64Result cppArg0_local;
            ::QByteArray::FromBase64Result *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // FromBase64Result(QByteArray::FromBase64Result)
                cptr = new ::QByteArray::FromBase64Result(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QByteArray::FromBase64Result >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QByteArray_FromBase64Result_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QByteArray_FromBase64Result_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QByteArray_FromBase64ResultFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray::FromBase64Result *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.FromBase64Result.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: FromBase64Result::swap(QByteArray::FromBase64Result&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QByteArray::FromBase64Result&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArray_FromBase64ResultFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray::FromBase64Result cppArg0_local;
        ::QByteArray::FromBase64Result *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QByteArray::FromBase64Result&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QByteArray_FromBase64ResultFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArray_FromBase64Result___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QByteArray::FromBase64Result *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QByteArray_FromBase64Result_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QByteArray_FromBase64Result_methods[] = {
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QByteArray_FromBase64ResultFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QByteArray_FromBase64Result___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QByteArray_FromBase64Result_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QByteArray::FromBase64Result *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), (pyArg)))) {
                // operator!=(const QByteArray::FromBase64Result & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray::FromBase64Result cppArg0_local;
                ::QByteArray::FromBase64Result *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), (pyArg)))) {
                // operator==(const QByteArray::FromBase64Result & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray::FromBase64Result cppArg0_local;
                ::QByteArray::FromBase64Result *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QByteArray_FromBase64Result_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QByteArray_FromBase64Result_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

static PyObject *Sbk_QByteArray_FromBase64Result_get_decoded(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QByteArray::FromBase64Result *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->decoded)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->decoded))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->decoded)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &(cppSelf->decoded), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QByteArray_FromBase64Result_set_decoded(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QByteArray::FromBase64Result *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'decoded' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'decoded', 'QByteArray' or convertible type expected");
        return -1;
    }

    ::QByteArray& cppOut_ptr = cppSelf->decoded;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QByteArray_FromBase64Result_get_decodingStatus(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QByteArray::FromBase64Result *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QByteArray::Base64DecodingStatus cppOut_local = cppSelf->decodingStatus;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QByteArray_FromBase64Result_set_decodingStatus(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QByteArray::FromBase64Result *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'decodingStatus' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'decodingStatus', 'Base64DecodingStatus' or convertible type expected");
        return -1;
    }

    ::QByteArray::Base64DecodingStatus cppOut_local = cppSelf->decodingStatus;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->decodingStatus = cppOut_local;

    return 0;
}

// Getters and Setters for FromBase64Result
static PyGetSetDef Sbk_QByteArray_FromBase64Result_getsetlist[] = {
    {const_cast<char *>("decoded"), Sbk_QByteArray_FromBase64Result_get_decoded, Sbk_QByteArray_FromBase64Result_set_decoded},
    {const_cast<char *>("decodingStatus"), Sbk_QByteArray_FromBase64Result_get_decodingStatus, Sbk_QByteArray_FromBase64Result_set_decodingStatus},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QByteArray_FromBase64Result_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QByteArray_FromBase64Result_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QByteArray_FromBase64Result_Type = nullptr;
static SbkObjectType *Sbk_QByteArray_FromBase64Result_TypeF(void)
{
    return _Sbk_QByteArray_FromBase64Result_Type;
}

static PyType_Slot Sbk_QByteArray_FromBase64Result_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QByteArray_FromBase64Result_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QByteArray_FromBase64Result_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QByteArray_FromBase64Result_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QByteArray_FromBase64Result_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QByteArray_FromBase64Result_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QByteArray_FromBase64Result_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QByteArray_FromBase64Result_spec = {
    "2:PySide2.QtCore.QByteArray.FromBase64Result",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QByteArray_FromBase64Result_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void FromBase64Result_PythonToCpp_FromBase64Result_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QByteArray_FromBase64Result_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_FromBase64Result_PythonToCpp_FromBase64Result_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QByteArray_FromBase64Result_TypeF())))
        return FromBase64Result_PythonToCpp_FromBase64Result_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *FromBase64Result_PTR_CppToPython_FromBase64Result(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QByteArray::FromBase64Result *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QByteArray_FromBase64Result_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *FromBase64Result_COPY_CppToPython_FromBase64Result(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QByteArray_FromBase64Result_TypeF(), new ::QByteArray::FromBase64Result(*reinterpret_cast<const ::QByteArray::FromBase64Result *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void FromBase64Result_PythonToCpp_FromBase64Result_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QByteArray::FromBase64Result *>(cppOut) = *reinterpret_cast< ::QByteArray::FromBase64Result *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_FromBase64Result_PythonToCpp_FromBase64Result_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QByteArray_FromBase64Result_TypeF())))
        return FromBase64Result_PythonToCpp_FromBase64Result_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QByteArray_FromBase64Result_SignatureStrings[] = {
    "1:PySide2.QtCore.QByteArray.FromBase64Result(self)",
    "0:PySide2.QtCore.QByteArray.FromBase64Result(self,FromBase64Result:PySide2.QtCore.QByteArray.FromBase64Result)",
    "PySide2.QtCore.QByteArray.FromBase64Result.swap(self,other:PySide2.QtCore.QByteArray.FromBase64Result)",
    "PySide2.QtCore.QByteArray.FromBase64Result.__copy__()",
    nullptr}; // Sentinel

void init_QByteArray_FromBase64Result(PyObject *enclosingClass)
{
    _Sbk_QByteArray_FromBase64Result_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "FromBase64Result",
        "QByteArray::FromBase64Result",
        &Sbk_QByteArray_FromBase64Result_spec,
        &Shiboken::callCppDestructor< ::QByteArray::FromBase64Result >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QByteArray_FromBase64Result_Type);
    InitSignatureStrings(pyType, QByteArray_FromBase64Result_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QByteArray_FromBase64Result_Type), Sbk_QByteArray_FromBase64Result_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QByteArray_FromBase64Result_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QByteArray_FromBase64Result_TypeF(),
        FromBase64Result_PythonToCpp_FromBase64Result_PTR,
        is_FromBase64Result_PythonToCpp_FromBase64Result_PTR_Convertible,
        FromBase64Result_PTR_CppToPython_FromBase64Result,
        FromBase64Result_COPY_CppToPython_FromBase64Result);

    Shiboken::Conversions::registerConverterName(converter, "QByteArray::FromBase64Result");
    Shiboken::Conversions::registerConverterName(converter, "QByteArray::FromBase64Result*");
    Shiboken::Conversions::registerConverterName(converter, "QByteArray::FromBase64Result&");
    Shiboken::Conversions::registerConverterName(converter, "FromBase64Result");
    Shiboken::Conversions::registerConverterName(converter, "FromBase64Result*");
    Shiboken::Conversions::registerConverterName(converter, "FromBase64Result&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QByteArray::FromBase64Result).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        FromBase64Result_PythonToCpp_FromBase64Result_COPY,
        is_FromBase64Result_PythonToCpp_FromBase64Result_COPY_Convertible);

    qRegisterMetaType< ::QByteArray::FromBase64Result >("FromBase64Result");
    qRegisterMetaType< ::QByteArray::FromBase64Result >("QByteArray::FromBase64Result");
}
