/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qabstractanimation_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractAnimationWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractAnimationWrapper::QAbstractAnimationWrapper(::QObject * parent) : QAbstractAnimation(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QAbstractAnimationWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractAnimationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAnimationWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractAnimationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

int QAbstractAnimationWrapper::duration() const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.duration()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "1:duration";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.duration()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAnimation.duration", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractAnimationWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QAbstractAnimation::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QAbstractAnimation::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAnimation.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractAnimationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAnimation.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractAnimationWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractAnimationWrapper::updateCurrentTime(int currentTime)
{
    if (m_PyMethodCache[9]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.updateCurrentTime()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateCurrentTime";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.updateCurrentTime()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    currentTime
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAnimationWrapper::updateDirection(::QAbstractAnimation::Direction direction)
{
    if (m_PyMethodCache[10]) {
        return this->::QAbstractAnimation::updateDirection(direction);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateDirection";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QAbstractAnimation::updateDirection(direction);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX])->converter, &direction)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAnimationWrapper::updateState(::QAbstractAnimation::State newState, ::QAbstractAnimation::State oldState)
{
    if (m_PyMethodCache[11]) {
        return this->::QAbstractAnimation::updateState(newState, oldState);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateState";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QAbstractAnimation::updateState(newState, oldState);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX])->converter, &newState),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX])->converter, &oldState)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QAbstractAnimationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAbstractAnimation::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractAnimationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAbstractAnimation::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractAnimationWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractAnimationWrapper *>(this));
        return QAbstractAnimation::qt_metacast(_clname);
}

QAbstractAnimationWrapper::~QAbstractAnimationWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractAnimation_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractAnimation' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractAnimation >()))
        return -1;

    ::QAbstractAnimationWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QAbstractAnimation", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractAnimation::QAbstractAnimation(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QAbstractAnimation(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAbstractAnimation(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimation_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractAnimation_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QAbstractAnimation_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QAbstractAnimation(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QAbstractAnimationWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QAbstractAnimationWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractAnimation >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractAnimation_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAbstractAnimation_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAbstractAnimation_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractAnimationFunc_currentLoop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.currentLoop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentLoop()const
            int cppResult = const_cast<const ::QAbstractAnimation *>(cppSelf)->currentLoop();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAnimationFunc_currentLoopTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.currentLoopTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentLoopTime()const
            int cppResult = const_cast<const ::QAbstractAnimation *>(cppSelf)->currentLoopTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAnimationFunc_currentTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.currentTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentTime()const
            int cppResult = const_cast<const ::QAbstractAnimation *>(cppSelf)->currentTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAnimationFunc_direction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.direction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // direction()const
            QAbstractAnimation::Direction cppResult = const_cast<const ::QAbstractAnimation *>(cppSelf)->direction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAnimationFunc_duration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.duration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // duration()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.duration()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QAbstractAnimation *>(cppSelf)->duration();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAnimationFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimationFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractAnimation::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractAnimationFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAnimationFunc_group(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.group";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // group()const
            QAnimationGroup * cppResult = const_cast<const ::QAbstractAnimation *>(cppSelf)->group();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QANIMATIONGROUP_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAnimationFunc_loopCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.loopCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loopCount()const
            int cppResult = const_cast<const ::QAbstractAnimation *>(cppSelf)->loopCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAnimationFunc_pause(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.pause";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pause()
            cppSelf->pause();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractAnimationFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.resume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resume()
            cppSelf->resume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractAnimationFunc_setCurrentTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.setCurrentTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAnimation::setCurrentTime(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentTime(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimationFunc_setCurrentTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentTime(int)
            cppSelf->setCurrentTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAnimationFunc_setCurrentTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAnimationFunc_setDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.setDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAnimation::setDirection(QAbstractAnimation::Direction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDirection(QAbstractAnimation::Direction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimationFunc_setDirection_TypeError;

    // Call function/method
    {
        ::QAbstractAnimation::Direction cppArg0{QAbstractAnimation::Forward};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDirection(QAbstractAnimation::Direction)
            cppSelf->setDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAnimationFunc_setDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAnimationFunc_setLoopCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.setLoopCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAnimation::setLoopCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLoopCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimationFunc_setLoopCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLoopCount(int)
            cppSelf->setLoopCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAnimationFunc_setLoopCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAnimationFunc_setPaused(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.setPaused";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAnimation::setPaused(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPaused(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimationFunc_setPaused_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPaused(bool)
            cppSelf->setPaused(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAnimationFunc_setPaused_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAnimationFunc_start(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.start";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractAnimationFunc_start_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:start", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAnimation::start(QAbstractAnimation::DeletionPolicy)
    if (numArgs == 0) {
        overloadId = 0; // start(QAbstractAnimation::DeletionPolicy)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // start(QAbstractAnimation::DeletionPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimationFunc_start_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_policy = Shiboken::String::createStaticString("policy");
            if (PyDict_Contains(kwds, key_policy)) {
                value = PyDict_GetItem(kwds, key_policy);
                if (value && pyArgs[0]) {
                    errInfo = key_policy;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractAnimationFunc_start_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QAbstractAnimationFunc_start_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_policy);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractAnimationFunc_start_TypeError;
            }
        }
        ::QAbstractAnimation::DeletionPolicy cppArg0 = QAbstractAnimation::DeletionPolicy::KeepWhenStopped;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // start(QAbstractAnimation::DeletionPolicy)
            cppSelf->start(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAnimationFunc_start_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAnimationFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QAbstractAnimation::State cppResult = const_cast<const ::QAbstractAnimation *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAnimationFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractAnimationFunc_totalDuration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.totalDuration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // totalDuration()const
            int cppResult = const_cast<const ::QAbstractAnimation *>(cppSelf)->totalDuration();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAnimationFunc_updateCurrentTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.updateCurrentTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAnimation::updateCurrentTime(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // updateCurrentTime(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimationFunc_updateCurrentTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // updateCurrentTime(int)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.updateCurrentTime()' not implemented.");
                return {};
            }
            cppSelf->updateCurrentTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAnimationFunc_updateCurrentTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAnimationFunc_updateDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.updateDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAnimation::updateDirection(QAbstractAnimation::Direction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // updateDirection(QAbstractAnimation::Direction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimationFunc_updateDirection_TypeError;

    // Call function/method
    {
        ::QAbstractAnimation::Direction cppArg0{QAbstractAnimation::Forward};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // updateDirection(QAbstractAnimation::Direction)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractAnimation::updateDirection(cppArg0)
                : cppSelf->updateDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAnimationFunc_updateDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAnimationFunc_updateState(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractAnimation.updateState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateState", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAnimation::updateState(QAbstractAnimation::State,QAbstractAnimation::State)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // updateState(QAbstractAnimation::State,QAbstractAnimation::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAnimationFunc_updateState_TypeError;

    // Call function/method
    {
        ::QAbstractAnimation::State cppArg0{QAbstractAnimation::Stopped};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QAbstractAnimation::State cppArg1{QAbstractAnimation::Stopped};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // updateState(QAbstractAnimation::State,QAbstractAnimation::State)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractAnimation::updateState(cppArg0, cppArg1)
                : cppSelf->updateState(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAnimationFunc_updateState_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QAbstractAnimation_PropertyStrings[] = {
    "currentLoop:",
    "currentTime::",
    "direction::",
    "duration:",
    "loopCount::",
    "state:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractAnimation_methods[] = {
    {"currentLoop", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_currentLoop), METH_NOARGS},
    {"currentLoopTime", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_currentLoopTime), METH_NOARGS},
    {"currentTime", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_currentTime), METH_NOARGS},
    {"direction", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_direction), METH_NOARGS},
    {"duration", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_duration), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_event), METH_O},
    {"group", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_group), METH_NOARGS},
    {"loopCount", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_loopCount), METH_NOARGS},
    {"pause", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_pause), METH_NOARGS},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_resume), METH_NOARGS},
    {"setCurrentTime", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_setCurrentTime), METH_O},
    {"setDirection", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_setDirection), METH_O},
    {"setLoopCount", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_setLoopCount), METH_O},
    {"setPaused", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_setPaused), METH_O},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_start), METH_VARARGS|METH_KEYWORDS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_state), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_stop), METH_NOARGS},
    {"totalDuration", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_totalDuration), METH_NOARGS},
    {"updateCurrentTime", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_updateCurrentTime), METH_O},
    {"updateDirection", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_updateDirection), METH_O},
    {"updateState", reinterpret_cast<PyCFunction>(Sbk_QAbstractAnimationFunc_updateState), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractAnimation_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractAnimationWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAbstractAnimation_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractAnimation_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractAnimation_Type = nullptr;
static SbkObjectType *Sbk_QAbstractAnimation_TypeF(void)
{
    return _Sbk_QAbstractAnimation_Type;
}

static PyType_Slot Sbk_QAbstractAnimation_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractAnimation_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractAnimation_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractAnimation_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractAnimation_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractAnimation_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractAnimation_spec = {
    "2:PySide2.QtCore.QAbstractAnimation",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractAnimation_slots
};

} //extern "C"

static void *Sbk_QAbstractAnimation_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QAbstractAnimation *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QAbstractAnimation_Direction_PythonToCpp_QAbstractAnimation_Direction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractAnimation::Direction *>(cppOut) =
        static_cast<::QAbstractAnimation::Direction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractAnimation_Direction_PythonToCpp_QAbstractAnimation_Direction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX]))
        return QAbstractAnimation_Direction_PythonToCpp_QAbstractAnimation_Direction;
    return {};
}
static PyObject *QAbstractAnimation_Direction_CppToPython_QAbstractAnimation_Direction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractAnimation::Direction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX], castCppIn);

}

static void QAbstractAnimation_State_PythonToCpp_QAbstractAnimation_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractAnimation::State *>(cppOut) =
        static_cast<::QAbstractAnimation::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractAnimation_State_PythonToCpp_QAbstractAnimation_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX]))
        return QAbstractAnimation_State_PythonToCpp_QAbstractAnimation_State;
    return {};
}
static PyObject *QAbstractAnimation_State_CppToPython_QAbstractAnimation_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractAnimation::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX], castCppIn);

}

static void QAbstractAnimation_DeletionPolicy_PythonToCpp_QAbstractAnimation_DeletionPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractAnimation::DeletionPolicy *>(cppOut) =
        static_cast<::QAbstractAnimation::DeletionPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractAnimation_DeletionPolicy_PythonToCpp_QAbstractAnimation_DeletionPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX]))
        return QAbstractAnimation_DeletionPolicy_PythonToCpp_QAbstractAnimation_DeletionPolicy;
    return {};
}
static PyObject *QAbstractAnimation_DeletionPolicy_CppToPython_QAbstractAnimation_DeletionPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractAnimation::DeletionPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractAnimation_PythonToCpp_QAbstractAnimation_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractAnimation_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractAnimation_PythonToCpp_QAbstractAnimation_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractAnimation_TypeF())))
        return QAbstractAnimation_PythonToCpp_QAbstractAnimation_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractAnimation_PTR_CppToPython_QAbstractAnimation(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAbstractAnimation *>(const_cast<void *>(cppIn)), Sbk_QAbstractAnimation_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractAnimation_SignatureStrings[] = {
    "PySide2.QtCore.QAbstractAnimation(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCore.QAbstractAnimation.currentLoop(self)->int",
    "PySide2.QtCore.QAbstractAnimation.currentLoopTime(self)->int",
    "PySide2.QtCore.QAbstractAnimation.currentTime(self)->int",
    "PySide2.QtCore.QAbstractAnimation.direction(self)->PySide2.QtCore.QAbstractAnimation.Direction",
    "PySide2.QtCore.QAbstractAnimation.duration(self)->int",
    "PySide2.QtCore.QAbstractAnimation.event(self,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QAbstractAnimation.group(self)->PySide2.QtCore.QAnimationGroup",
    "PySide2.QtCore.QAbstractAnimation.loopCount(self)->int",
    "PySide2.QtCore.QAbstractAnimation.pause(self)",
    "PySide2.QtCore.QAbstractAnimation.resume(self)",
    "PySide2.QtCore.QAbstractAnimation.setCurrentTime(self,msecs:int)",
    "PySide2.QtCore.QAbstractAnimation.setDirection(self,direction:PySide2.QtCore.QAbstractAnimation.Direction)",
    "PySide2.QtCore.QAbstractAnimation.setLoopCount(self,loopCount:int)",
    "PySide2.QtCore.QAbstractAnimation.setPaused(self,arg__1:bool)",
    "PySide2.QtCore.QAbstractAnimation.start(self,policy:PySide2.QtCore.QAbstractAnimation.DeletionPolicy=KeepWhenStopped)",
    "PySide2.QtCore.QAbstractAnimation.state(self)->PySide2.QtCore.QAbstractAnimation.State",
    "PySide2.QtCore.QAbstractAnimation.stop(self)",
    "PySide2.QtCore.QAbstractAnimation.totalDuration(self)->int",
    "PySide2.QtCore.QAbstractAnimation.updateCurrentTime(self,currentTime:int)",
    "PySide2.QtCore.QAbstractAnimation.updateDirection(self,direction:PySide2.QtCore.QAbstractAnimation.Direction)",
    "PySide2.QtCore.QAbstractAnimation.updateState(self,newState:PySide2.QtCore.QAbstractAnimation.State,oldState:PySide2.QtCore.QAbstractAnimation.State)",
    nullptr}; // Sentinel

void init_QAbstractAnimation(PyObject *module)
{
    _Sbk_QAbstractAnimation_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractAnimation",
        "QAbstractAnimation*",
        &Sbk_QAbstractAnimation_spec,
        &Shiboken::callCppDestructor< ::QAbstractAnimation >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractAnimation_Type);
    InitSignatureStrings(pyType, QAbstractAnimation_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractAnimation_Type), Sbk_QAbstractAnimation_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractAnimation_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractAnimation_TypeF(),
        QAbstractAnimation_PythonToCpp_QAbstractAnimation_PTR,
        is_QAbstractAnimation_PythonToCpp_QAbstractAnimation_PTR_Convertible,
        QAbstractAnimation_PTR_CppToPython_QAbstractAnimation);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractAnimation");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractAnimation*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractAnimation&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractAnimation).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractAnimationWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAbstractAnimation_TypeF(), &Sbk_QAbstractAnimation_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Direction'.
    SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractAnimation_TypeF(),
        "Direction",
        "2:PySide2.QtCore.QAbstractAnimation.Direction",
        "QAbstractAnimation::Direction");
    if (!SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX],
        Sbk_QAbstractAnimation_TypeF(), "Forward", (long) QAbstractAnimation::Direction::Forward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX],
        Sbk_QAbstractAnimation_TypeF(), "Backward", (long) QAbstractAnimation::Direction::Backward))
        return;
    // Register converter for enum 'QAbstractAnimation::Direction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX],
            QAbstractAnimation_Direction_CppToPython_QAbstractAnimation_Direction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractAnimation_Direction_PythonToCpp_QAbstractAnimation_Direction,
            is_QAbstractAnimation_Direction_PythonToCpp_QAbstractAnimation_Direction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractAnimation::Direction");
        Shiboken::Conversions::registerConverterName(converter, "Direction");
    }
    // End of 'Direction' enum.

    // Initialization of enum 'State'.
    SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractAnimation_TypeF(),
        "State",
        "2:PySide2.QtCore.QAbstractAnimation.State",
        "QAbstractAnimation::State");
    if (!SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX],
        Sbk_QAbstractAnimation_TypeF(), "Stopped", (long) QAbstractAnimation::State::Stopped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX],
        Sbk_QAbstractAnimation_TypeF(), "Paused", (long) QAbstractAnimation::State::Paused))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX],
        Sbk_QAbstractAnimation_TypeF(), "Running", (long) QAbstractAnimation::State::Running))
        return;
    // Register converter for enum 'QAbstractAnimation::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX],
            QAbstractAnimation_State_CppToPython_QAbstractAnimation_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractAnimation_State_PythonToCpp_QAbstractAnimation_State,
            is_QAbstractAnimation_State_PythonToCpp_QAbstractAnimation_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractAnimation::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'DeletionPolicy'.
    SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractAnimation_TypeF(),
        "DeletionPolicy",
        "2:PySide2.QtCore.QAbstractAnimation.DeletionPolicy",
        "QAbstractAnimation::DeletionPolicy");
    if (!SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX],
        Sbk_QAbstractAnimation_TypeF(), "KeepWhenStopped", (long) QAbstractAnimation::DeletionPolicy::KeepWhenStopped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX],
        Sbk_QAbstractAnimation_TypeF(), "DeleteWhenStopped", (long) QAbstractAnimation::DeletionPolicy::DeleteWhenStopped))
        return;
    // Register converter for enum 'QAbstractAnimation::DeletionPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX],
            QAbstractAnimation_DeletionPolicy_CppToPython_QAbstractAnimation_DeletionPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractAnimation_DeletionPolicy_PythonToCpp_QAbstractAnimation_DeletionPolicy,
            is_QAbstractAnimation_DeletionPolicy_PythonToCpp_QAbstractAnimation_DeletionPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractAnimation::DeletionPolicy");
        Shiboken::Conversions::registerConverterName(converter, "DeletionPolicy");
    }
    // End of 'DeletionPolicy' enum.

    PySide::Signal::registerSignals(Sbk_QAbstractAnimation_TypeF(), &::QAbstractAnimation::staticMetaObject);
    qRegisterMetaType< ::QAbstractAnimation::Direction >("QAbstractAnimation::Direction");
    qRegisterMetaType< ::QAbstractAnimation::State >("QAbstractAnimation::State");
    qRegisterMetaType< ::QAbstractAnimation::DeletionPolicy >("QAbstractAnimation::DeletionPolicy");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAbstractAnimation_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAbstractAnimation_TypeF(), &::QAbstractAnimation::staticMetaObject, sizeof(QAbstractAnimationWrapper));
}
