/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtconcurrent_python.h"

// main header
#include "qtconcurrent_wrapper.h"

// inner classes

// Extra includes
#include <qtconcurrentreducekernel.h>
#include <qtconcurrentthreadengine.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {

static const char *Sbk_QtConcurrent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtConcurrent_methods[] = {

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QtConcurrent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtConcurrent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtConcurrent_Type = nullptr;
static SbkObjectType *Sbk_QtConcurrent_TypeF(void)
{
    return _Sbk_QtConcurrent_Type;
}

static PyType_Slot Sbk_QtConcurrent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtConcurrent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtConcurrent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtConcurrent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtConcurrent_spec = {
    "2:PySide2.QtConcurrent.QtConcurrent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtConcurrent_slots
};

} //extern "C"

PyObject *SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QtConcurrent::ReduceOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtConcurrent::ReduceOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtConcurrent::ReduceOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtConcurrent::ReduceOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtConcurrent::ReduceOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QtConcurrent::ReduceOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtConcurrent::ReduceOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtConcurrent::ReduceOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtConcurrent::ReduceOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtConcurrent::ReduceOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QtConcurrent::ReduceOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtConcurrent::ReduceOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtConcurrent::ReduceOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtConcurrent::ReduceOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtConcurrent::ReduceOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QtConcurrent::ReduceOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX])->converter, self, &cppSelf);
    ::QtConcurrent::ReduceOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QtConcurrent_ThreadFunctionResult_PythonToCpp_QtConcurrent_ThreadFunctionResult(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtConcurrent::ThreadFunctionResult *>(cppOut) =
        static_cast<::QtConcurrent::ThreadFunctionResult>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtConcurrent_ThreadFunctionResult_PythonToCpp_QtConcurrent_ThreadFunctionResult_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_THREADFUNCTIONRESULT_IDX]))
        return QtConcurrent_ThreadFunctionResult_PythonToCpp_QtConcurrent_ThreadFunctionResult;
    return {};
}
static PyObject *QtConcurrent_ThreadFunctionResult_CppToPython_QtConcurrent_ThreadFunctionResult(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtConcurrent::ThreadFunctionResult *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_THREADFUNCTIONRESULT_IDX], castCppIn);

}

static void QtConcurrent_ReduceOption_PythonToCpp_QtConcurrent_ReduceOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtConcurrent::ReduceOption *>(cppOut) =
        static_cast<::QtConcurrent::ReduceOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtConcurrent_ReduceOption_PythonToCpp_QtConcurrent_ReduceOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX]))
        return QtConcurrent_ReduceOption_PythonToCpp_QtConcurrent_ReduceOption;
    return {};
}
static PyObject *QtConcurrent_ReduceOption_CppToPython_QtConcurrent_ReduceOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtConcurrent::ReduceOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX], castCppIn);

}

static void QFlags_QtConcurrent_ReduceOption__PythonToCpp_QFlags_QtConcurrent_ReduceOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QtConcurrent::ReduceOption> *>(cppOut) =
        ::QFlags<QtConcurrent::ReduceOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QtConcurrent_ReduceOption__PythonToCpp_QFlags_QtConcurrent_ReduceOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX]))
        return QFlags_QtConcurrent_ReduceOption__PythonToCpp_QFlags_QtConcurrent_ReduceOption_;
    return {};
}
static PyObject *QFlags_QtConcurrent_ReduceOption__CppToPython_QFlags_QtConcurrent_ReduceOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QtConcurrent::ReduceOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX]));

}

static void QtConcurrent_ReduceOption_PythonToCpp_QFlags_QtConcurrent_ReduceOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QtConcurrent::ReduceOption> *>(cppOut) =
        ::QFlags<QtConcurrent::ReduceOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QtConcurrent_ReduceOption_PythonToCpp_QFlags_QtConcurrent_ReduceOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX]))
        return QtConcurrent_ReduceOption_PythonToCpp_QFlags_QtConcurrent_ReduceOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QtConcurrent_ReduceOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QtConcurrent::ReduceOption> *>(cppOut) =
        ::QFlags<QtConcurrent::ReduceOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QtConcurrent_ReduceOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX]))
        return number_PythonToCpp_QFlags_QtConcurrent_ReduceOption_;
    return {};
}
// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtConcurrentQtConcurrent_SignatureStrings[] = {
    nullptr}; // Sentinel

void init_QtConcurrentQtConcurrent(PyObject *module)
{
    _Sbk_QtConcurrent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QtConcurrent",
        "QtConcurrent",
        &Sbk_QtConcurrent_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtConcurrent_Type);
    InitSignatureStrings(pyType, QtConcurrentQtConcurrent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtConcurrent_Type), Sbk_QtConcurrent_PropertyStrings);
    SbkPySide2_QtConcurrentTypes[SBK_QtConcurrentQTCONCURRENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtConcurrent_TypeF());


    // Initialization of enums.

    // Initialization of enum 'ThreadFunctionResult'.
    SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_THREADFUNCTIONRESULT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtConcurrent_TypeF(),
        "ThreadFunctionResult",
        "2:PySide2.QtConcurrent.QtConcurrent.ThreadFunctionResult",
        "QtConcurrent::ThreadFunctionResult");
    if (!SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_THREADFUNCTIONRESULT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_THREADFUNCTIONRESULT_IDX],
        Sbk_QtConcurrent_TypeF(), "ThrottleThread", (long) QtConcurrent::ThreadFunctionResult::ThrottleThread))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_THREADFUNCTIONRESULT_IDX],
        Sbk_QtConcurrent_TypeF(), "ThreadFinished", (long) QtConcurrent::ThreadFunctionResult::ThreadFinished))
        return;
    // Register converter for enum 'QtConcurrent::ThreadFunctionResult'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_THREADFUNCTIONRESULT_IDX],
            QtConcurrent_ThreadFunctionResult_CppToPython_QtConcurrent_ThreadFunctionResult);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtConcurrent_ThreadFunctionResult_PythonToCpp_QtConcurrent_ThreadFunctionResult,
            is_QtConcurrent_ThreadFunctionResult_PythonToCpp_QtConcurrent_ThreadFunctionResult_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_THREADFUNCTIONRESULT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtConcurrent::ThreadFunctionResult");
        Shiboken::Conversions::registerConverterName(converter, "ThreadFunctionResult");
    }
    // End of 'ThreadFunctionResult' enum.

    // Initialization of enum 'ReduceOption'.
    SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtConcurrent.QtConcurrent.ReduceOptions", SbkPySide2_QtConcurrent_QtConcurrent_ReduceOption_number_slots);
    SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtConcurrent_TypeF(),
        "ReduceOption",
        "2:PySide2.QtConcurrent.QtConcurrent.ReduceOption",
        "QtConcurrent::ReduceOption",
        SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX]);
    if (!SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX],
        Sbk_QtConcurrent_TypeF(), "UnorderedReduce", (long) QtConcurrent::ReduceOption::UnorderedReduce))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX],
        Sbk_QtConcurrent_TypeF(), "OrderedReduce", (long) QtConcurrent::ReduceOption::OrderedReduce))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX],
        Sbk_QtConcurrent_TypeF(), "SequentialReduce", (long) QtConcurrent::ReduceOption::SequentialReduce))
        return;
    // Register converter for enum 'QtConcurrent::ReduceOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX],
            QtConcurrent_ReduceOption_CppToPython_QtConcurrent_ReduceOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtConcurrent_ReduceOption_PythonToCpp_QtConcurrent_ReduceOption,
            is_QtConcurrent_ReduceOption_PythonToCpp_QtConcurrent_ReduceOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtConcurrentTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtConcurrent::ReduceOption");
        Shiboken::Conversions::registerConverterName(converter, "ReduceOption");
    }
    // Register converter for flag 'QFlags<QtConcurrent::ReduceOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX],
            QFlags_QtConcurrent_ReduceOption__CppToPython_QFlags_QtConcurrent_ReduceOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtConcurrent_ReduceOption_PythonToCpp_QFlags_QtConcurrent_ReduceOption_,
            is_QtConcurrent_ReduceOption_PythonToCpp_QFlags_QtConcurrent_ReduceOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QtConcurrent_ReduceOption__PythonToCpp_QFlags_QtConcurrent_ReduceOption_,
            is_QFlags_QtConcurrent_ReduceOption__PythonToCpp_QFlags_QtConcurrent_ReduceOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QtConcurrent_ReduceOption_,
            is_number_PythonToCpp_QFlags_QtConcurrent_ReduceOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtConcurrentTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtConcurrent::ReduceOptions");
        Shiboken::Conversions::registerConverterName(converter, "ReduceOptions");
    }
    // End of 'ReduceOption' enum/flags.

    qRegisterMetaType< ::QtConcurrent::ThreadFunctionResult >("QtConcurrent::ThreadFunctionResult");
    qRegisterMetaType< ::QtConcurrent::ReduceOption >("QtConcurrent::ReduceOption");
    qRegisterMetaType< ::QtConcurrent::ReduceOptions >("QtConcurrent::ReduceOptions");
}
