/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcharts_python.h"

// main header
#include "qtcharts_wrapper.h"

// inner classes
#include "qtcharts_qpieslice_wrapper.h"
#include "qtcharts_qxymodelmapper_wrapper.h"
#include "qtcharts_qvxymodelmapper_wrapper.h"
#include "qtcharts_qhxymodelmapper_wrapper.h"
#include "qtcharts_qpiemodelmapper_wrapper.h"
#include "qtcharts_qvpiemodelmapper_wrapper.h"
#include "qtcharts_qhpiemodelmapper_wrapper.h"
#include "qtcharts_qchartview_wrapper.h"
#include "qtcharts_qchart_wrapper.h"
#include "qtcharts_qpolarchart_wrapper.h"
#include "qtcharts_qcandlestickset_wrapper.h"
#include "qtcharts_qcandlestickmodelmapper_wrapper.h"
#include "qtcharts_qvcandlestickmodelmapper_wrapper.h"
#include "qtcharts_qhcandlestickmodelmapper_wrapper.h"
#include "qtcharts_qboxplotmodelmapper_wrapper.h"
#include "qtcharts_qvboxplotmodelmapper_wrapper.h"
#include "qtcharts_qhboxplotmodelmapper_wrapper.h"
#include "qtcharts_qboxset_wrapper.h"
#include "qtcharts_qbarmodelmapper_wrapper.h"
#include "qtcharts_qvbarmodelmapper_wrapper.h"
#include "qtcharts_qhbarmodelmapper_wrapper.h"
#include "qtcharts_qbarset_wrapper.h"
#include "qtcharts_qlegendmarker_wrapper.h"
#include "qtcharts_qboxplotlegendmarker_wrapper.h"
#include "qtcharts_qbarlegendmarker_wrapper.h"
#include "qtcharts_qpielegendmarker_wrapper.h"
#include "qtcharts_qarealegendmarker_wrapper.h"
#include "qtcharts_qxylegendmarker_wrapper.h"
#include "qtcharts_qcandlesticklegendmarker_wrapper.h"
#include "qtcharts_qlegend_wrapper.h"
#include "qtcharts_qabstractseries_wrapper.h"
#include "qtcharts_qcandlestickseries_wrapper.h"
#include "qtcharts_qboxplotseries_wrapper.h"
#include "qtcharts_qpieseries_wrapper.h"
#include "qtcharts_qareaseries_wrapper.h"
#include "qtcharts_qabstractbarseries_wrapper.h"
#include "qtcharts_qhorizontalstackedbarseries_wrapper.h"
#include "qtcharts_qhorizontalpercentbarseries_wrapper.h"
#include "qtcharts_qstackedbarseries_wrapper.h"
#include "qtcharts_qhorizontalbarseries_wrapper.h"
#include "qtcharts_qbarseries_wrapper.h"
#include "qtcharts_qpercentbarseries_wrapper.h"
#include "qtcharts_qxyseries_wrapper.h"
#include "qtcharts_qscatterseries_wrapper.h"
#include "qtcharts_qlineseries_wrapper.h"
#include "qtcharts_qsplineseries_wrapper.h"
#include "qtcharts_qabstractaxis_wrapper.h"
#include "qtcharts_qdatetimeaxis_wrapper.h"
#include "qtcharts_qbarcategoryaxis_wrapper.h"
#include "qtcharts_qlogvalueaxis_wrapper.h"
#include "qtcharts_qvalueaxis_wrapper.h"
#include "qtcharts_qcategoryaxis_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {

static const char *Sbk_QtCharts_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtCharts_methods[] = {

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QtCharts_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtCharts_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtCharts_Type = nullptr;
static SbkObjectType *Sbk_QtCharts_TypeF(void)
{
    return _Sbk_QtCharts_Type;
}

static PyType_Slot Sbk_QtCharts_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtCharts_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtCharts_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtCharts_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtCharts_spec = {
    "2:PySide2.QtCharts.QtCharts",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtCharts_slots
};

} //extern "C"


// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtChartsQtCharts_SignatureStrings[] = {
    nullptr}; // Sentinel

void init_QtChartsQtCharts(PyObject *module)
{
    _Sbk_QtCharts_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QtCharts",
        "QtCharts",
        &Sbk_QtCharts_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_Type);
    InitSignatureStrings(pyType, QtChartsQtCharts_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_Type), Sbk_QtCharts_PropertyStrings);
    SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_TypeF());


}
