/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcharts_python.h"

// main header
#include "qtcharts_qabstractaxis_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtCharts;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractAxisWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QAbstractAxisWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractAxisWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAxisWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractAxisWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstractAxisWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAxis.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractAxisWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAxis.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractAxisWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QtCharts::QAbstractAxis::AxisType QAbstractAxisWrapper::type() const
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAxis.type()' not implemented.");
        return QtCharts::QAbstractAxis::AxisTypeNoAxis;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QtCharts::QAbstractAxis::AxisTypeNoAxis;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "type";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAxis.type()' not implemented.");
        return QtCharts::QAbstractAxis::AxisTypeNoAxis;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QtCharts::QAbstractAxis::AxisTypeNoAxis;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAxis.type", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QtCharts::QAbstractAxis::AxisType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QtCharts::QAbstractAxis::AxisTypeNoAxis;
    }
    ::QtCharts::QAbstractAxis::AxisType cppResult{QtCharts::QAbstractAxis::AxisTypeNoAxis};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QAbstractAxisWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtCharts::QAbstractAxis::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractAxisWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtCharts::QAbstractAxis::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractAxisWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractAxisWrapper *>(this));
        return QtCharts::QAbstractAxis::qt_metacast(_clname);
}

QAbstractAxisWrapper::~QAbstractAxisWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QtCharts_QAbstractAxisFunc_alignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.alignment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alignment()const
            QFlags<Qt::AlignmentFlag> cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->alignment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_gridLineColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.gridLineColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gridLineColor()
            QColor cppResult = cppSelf->gridLineColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_gridLinePen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.gridLinePen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gridLinePen()const
            QPen cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->gridLinePen();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_hide(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.hide";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hide()
            cppSelf->hide();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_isGridLineVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.isGridLineVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isGridLineVisible()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->isGridLineVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_isLineVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.isLineVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLineVisible()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->isLineVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_isMinorGridLineVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.isMinorGridLineVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMinorGridLineVisible()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->isMinorGridLineVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_isReverse(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.isReverse";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReverse()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->isReverse();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_isTitleVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.isTitleVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTitleVisible()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->isTitleVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_isVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.isVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVisible()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->isVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_labelsAngle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsAngle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsAngle()const
            int cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->labelsAngle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_labelsBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsBrush()const
            QBrush cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->labelsBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_labelsColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsColor()const
            QColor cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->labelsColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_labelsEditable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsEditable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsEditable()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->labelsEditable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_labelsFont(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsFont";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsFont()const
            QFont cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->labelsFont();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_labelsVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsVisible()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->labelsVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_linePen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.linePen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // linePen()const
            QPen cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->linePen();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_linePenColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.linePenColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // linePenColor()const
            QColor cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->linePenColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_minorGridLineColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.minorGridLineColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minorGridLineColor()
            QColor cppResult = cppSelf->minorGridLineColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_minorGridLinePen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.minorGridLinePen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minorGridLinePen()const
            QPen cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->minorGridLinePen();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_orientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.orientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // orientation()const
            Qt::Orientation cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->orientation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setGridLineColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setGridLineColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setGridLineColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setGridLineColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setGridLineColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGridLineColor(QColor)
            cppSelf->setGridLineColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setGridLineColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setGridLinePen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setGridLinePen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setGridLinePen(QPen)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
        overloadId = 0; // setGridLinePen(QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setGridLinePen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPen cppArg0_local;
        ::QPen *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGridLinePen(QPen)
            cppSelf->setGridLinePen(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setGridLinePen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setGridLineVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setGridLineVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractAxisFunc_setGridLineVisible_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setGridLineVisible", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setGridLineVisible(bool)
    if (numArgs == 0) {
        overloadId = 0; // setGridLineVisible(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setGridLineVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setGridLineVisible_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_visible = Shiboken::String::createStaticString("visible");
            if (PyDict_Contains(kwds, key_visible)) {
                value = PyDict_GetItem(kwds, key_visible);
                if (value && pyArgs[0]) {
                    errInfo = key_visible;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractAxisFunc_setGridLineVisible_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractAxisFunc_setGridLineVisible_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_visible);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractAxisFunc_setGridLineVisible_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setGridLineVisible(bool)
            cppSelf->setGridLineVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setGridLineVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setLabelsAngle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsAngle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setLabelsAngle(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLabelsAngle(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsAngle_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelsAngle(int)
            cppSelf->setLabelsAngle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setLabelsAngle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setLabelsBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setLabelsBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setLabelsBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLabelsBrush(QBrush)
            cppSelf->setLabelsBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setLabelsBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setLabelsColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setLabelsColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setLabelsColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelsColor(QColor)
            cppSelf->setLabelsColor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setLabelsColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setLabelsEditable(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsEditable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsEditable_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setLabelsEditable", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setLabelsEditable(bool)
    if (numArgs == 0) {
        overloadId = 0; // setLabelsEditable(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setLabelsEditable(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsEditable_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_editable = Shiboken::String::createStaticString("editable");
            if (PyDict_Contains(kwds, key_editable)) {
                value = PyDict_GetItem(kwds, key_editable);
                if (value && pyArgs[0]) {
                    errInfo = key_editable;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsEditable_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsEditable_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_editable);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsEditable_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelsEditable(bool)
            cppSelf->setLabelsEditable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setLabelsEditable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setLabelsFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setLabelsFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // setLabelsFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsFont_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLabelsFont(QFont)
            cppSelf->setLabelsFont(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setLabelsFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setLabelsVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsVisible_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setLabelsVisible", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setLabelsVisible(bool)
    if (numArgs == 0) {
        overloadId = 0; // setLabelsVisible(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setLabelsVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsVisible_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_visible = Shiboken::String::createStaticString("visible");
            if (PyDict_Contains(kwds, key_visible)) {
                value = PyDict_GetItem(kwds, key_visible);
                if (value && pyArgs[0]) {
                    errInfo = key_visible;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsVisible_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsVisible_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_visible);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractAxisFunc_setLabelsVisible_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelsVisible(bool)
            cppSelf->setLabelsVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setLabelsVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setLinePen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setLinePen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setLinePen(QPen)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
        overloadId = 0; // setLinePen(QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setLinePen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPen cppArg0_local;
        ::QPen *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLinePen(QPen)
            cppSelf->setLinePen(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setLinePen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setLinePenColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setLinePenColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setLinePenColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setLinePenColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setLinePenColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLinePenColor(QColor)
            cppSelf->setLinePenColor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setLinePenColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setLineVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setLineVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractAxisFunc_setLineVisible_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setLineVisible", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setLineVisible(bool)
    if (numArgs == 0) {
        overloadId = 0; // setLineVisible(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setLineVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setLineVisible_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_visible = Shiboken::String::createStaticString("visible");
            if (PyDict_Contains(kwds, key_visible)) {
                value = PyDict_GetItem(kwds, key_visible);
                if (value && pyArgs[0]) {
                    errInfo = key_visible;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractAxisFunc_setLineVisible_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractAxisFunc_setLineVisible_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_visible);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractAxisFunc_setLineVisible_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setLineVisible(bool)
            cppSelf->setLineVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setLineVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setMax(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setMax";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setMax(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setMax(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setMax_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMax(QVariant)
            cppSelf->setMax(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setMax_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setMin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setMin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setMin(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setMin(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setMin_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMin(QVariant)
            cppSelf->setMin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setMin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setMinorGridLineColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setMinorGridLineColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setMinorGridLineColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMinorGridLineColor(QColor)
            cppSelf->setMinorGridLineColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLinePen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setMinorGridLinePen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setMinorGridLinePen(QPen)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
        overloadId = 0; // setMinorGridLinePen(QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLinePen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPen cppArg0_local;
        ::QPen *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMinorGridLinePen(QPen)
            cppSelf->setMinorGridLinePen(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLinePen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setMinorGridLineVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineVisible_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setMinorGridLineVisible", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setMinorGridLineVisible(bool)
    if (numArgs == 0) {
        overloadId = 0; // setMinorGridLineVisible(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setMinorGridLineVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineVisible_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_visible = Shiboken::String::createStaticString("visible");
            if (PyDict_Contains(kwds, key_visible)) {
                value = PyDict_GetItem(kwds, key_visible);
                if (value && pyArgs[0]) {
                    errInfo = key_visible;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineVisible_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineVisible_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_visible);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineVisible_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinorGridLineVisible(bool)
            cppSelf->setMinorGridLineVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setRange(QVariant,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setRange(QVariant,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setRange_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setRange(QVariant,QVariant)
            cppSelf->setRange(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setReverse(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setReverse";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractAxisFunc_setReverse_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setReverse", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setReverse(bool)
    if (numArgs == 0) {
        overloadId = 0; // setReverse(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setReverse(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setReverse_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_reverse = Shiboken::String::createStaticString("reverse");
            if (PyDict_Contains(kwds, key_reverse)) {
                value = PyDict_GetItem(kwds, key_reverse);
                if (value && pyArgs[0]) {
                    errInfo = key_reverse;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractAxisFunc_setReverse_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractAxisFunc_setReverse_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_reverse);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractAxisFunc_setReverse_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setReverse(bool)
            cppSelf->setReverse(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setReverse_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setShadesBorderColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesBorderColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setShadesBorderColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setShadesBorderColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setShadesBorderColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShadesBorderColor(QColor)
            cppSelf->setShadesBorderColor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setShadesBorderColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setShadesBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setShadesBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setShadesBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setShadesBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setShadesBrush(QBrush)
            cppSelf->setShadesBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setShadesBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setShadesColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setShadesColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setShadesColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setShadesColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShadesColor(QColor)
            cppSelf->setShadesColor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setShadesColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setShadesPen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesPen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setShadesPen(QPen)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
        overloadId = 0; // setShadesPen(QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setShadesPen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPen cppArg0_local;
        ::QPen *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setShadesPen(QPen)
            cppSelf->setShadesPen(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setShadesPen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setShadesVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractAxisFunc_setShadesVisible_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setShadesVisible", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setShadesVisible(bool)
    if (numArgs == 0) {
        overloadId = 0; // setShadesVisible(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setShadesVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setShadesVisible_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_visible = Shiboken::String::createStaticString("visible");
            if (PyDict_Contains(kwds, key_visible)) {
                value = PyDict_GetItem(kwds, key_visible);
                if (value && pyArgs[0]) {
                    errInfo = key_visible;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractAxisFunc_setShadesVisible_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractAxisFunc_setShadesVisible_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_visible);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractAxisFunc_setShadesVisible_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setShadesVisible(bool)
            cppSelf->setShadesVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setShadesVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setTitleBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setTitleBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setTitleBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setTitleBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setTitleBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTitleBrush(QBrush)
            cppSelf->setTitleBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setTitleBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setTitleFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setTitleFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setTitleFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // setTitleFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setTitleFont_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTitleFont(QFont)
            cppSelf->setTitleFont(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setTitleFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setTitleText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setTitleText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAxis::setTitleText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setTitleText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setTitleText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTitleText(QString)
            cppSelf->setTitleText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setTitleText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setTitleVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setTitleVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractAxisFunc_setTitleVisible_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setTitleVisible", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setTitleVisible(bool)
    if (numArgs == 0) {
        overloadId = 0; // setTitleVisible(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setTitleVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setTitleVisible_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_visible = Shiboken::String::createStaticString("visible");
            if (PyDict_Contains(kwds, key_visible)) {
                value = PyDict_GetItem(kwds, key_visible);
                if (value && pyArgs[0]) {
                    errInfo = key_visible;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractAxisFunc_setTitleVisible_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractAxisFunc_setTitleVisible_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_visible);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractAxisFunc_setTitleVisible_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setTitleVisible(bool)
            cppSelf->setTitleVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setTitleVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_setVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.setVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractAxisFunc_setVisible_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setVisible", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAxis::setVisible(bool)
    if (numArgs == 0) {
        overloadId = 0; // setVisible(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractAxisFunc_setVisible_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_visible = Shiboken::String::createStaticString("visible");
            if (PyDict_Contains(kwds, key_visible)) {
                value = PyDict_GetItem(kwds, key_visible);
                if (value && pyArgs[0]) {
                    errInfo = key_visible;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractAxisFunc_setVisible_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractAxisFunc_setVisible_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_visible);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractAxisFunc_setVisible_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisible(bool)
            cppSelf->setVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractAxisFunc_setVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_shadesBorderColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesBorderColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shadesBorderColor()const
            QColor cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->shadesBorderColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_shadesBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shadesBrush()const
            QBrush cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->shadesBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_shadesColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shadesColor()const
            QColor cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->shadesColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_shadesPen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesPen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shadesPen()const
            QPen cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->shadesPen();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_shadesVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shadesVisible()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->shadesVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_show(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.show";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // show()
            cppSelf->show();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_titleBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.titleBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // titleBrush()const
            QBrush cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->titleBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_titleFont(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.titleFont";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // titleFont()const
            QFont cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->titleFont();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_titleText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.titleText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // titleText()const
            QString cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->titleText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractAxisFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractAxis.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAxis.type()' not implemented.");
                return {};
            }
            QtCharts::QAbstractAxis::AxisType cppResult = const_cast<const ::QtCharts::QAbstractAxis *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtCharts_QAbstractAxis_PropertyStrings[] = {
    "alignment:",
    "color:linePenColor:setLinePenColor",
    "gridLineColor::",
    "gridLinePen::",
    "gridVisible:isGridLineVisible:setGridLineVisible",
    "labelsAngle::",
    "labelsBrush::",
    "labelsColor::",
    "labelsFont::",
    "labelsVisible::",
    "linePen::",
    "lineVisible:isLineVisible:",
    "minorGridLineColor::",
    "minorGridLinePen::",
    "minorGridVisible:isMinorGridLineVisible:setMinorGridLineVisible",
    "orientation:",
    "reverse:isReverse:",
    "shadesBorderColor::",
    "shadesBrush::",
    "shadesColor::",
    "shadesPen::",
    "shadesVisible::",
    "titleBrush::",
    "titleFont::",
    "titleText::",
    "titleVisible:isTitleVisible:",
    "visible:isVisible:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtCharts_QAbstractAxis_methods[] = {
    {"alignment", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_alignment), METH_NOARGS},
    {"gridLineColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_gridLineColor), METH_NOARGS},
    {"gridLinePen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_gridLinePen), METH_NOARGS},
    {"hide", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_hide), METH_NOARGS},
    {"isGridLineVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_isGridLineVisible), METH_NOARGS},
    {"isLineVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_isLineVisible), METH_NOARGS},
    {"isMinorGridLineVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_isMinorGridLineVisible), METH_NOARGS},
    {"isReverse", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_isReverse), METH_NOARGS},
    {"isTitleVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_isTitleVisible), METH_NOARGS},
    {"isVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_isVisible), METH_NOARGS},
    {"labelsAngle", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_labelsAngle), METH_NOARGS},
    {"labelsBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_labelsBrush), METH_NOARGS},
    {"labelsColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_labelsColor), METH_NOARGS},
    {"labelsEditable", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_labelsEditable), METH_NOARGS},
    {"labelsFont", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_labelsFont), METH_NOARGS},
    {"labelsVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_labelsVisible), METH_NOARGS},
    {"linePen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_linePen), METH_NOARGS},
    {"linePenColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_linePenColor), METH_NOARGS},
    {"minorGridLineColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_minorGridLineColor), METH_NOARGS},
    {"minorGridLinePen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_minorGridLinePen), METH_NOARGS},
    {"orientation", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_orientation), METH_NOARGS},
    {"setGridLineColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setGridLineColor), METH_O},
    {"setGridLinePen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setGridLinePen), METH_O},
    {"setGridLineVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setGridLineVisible), METH_VARARGS|METH_KEYWORDS},
    {"setLabelsAngle", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setLabelsAngle), METH_O},
    {"setLabelsBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setLabelsBrush), METH_O},
    {"setLabelsColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setLabelsColor), METH_O},
    {"setLabelsEditable", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setLabelsEditable), METH_VARARGS|METH_KEYWORDS},
    {"setLabelsFont", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setLabelsFont), METH_O},
    {"setLabelsVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setLabelsVisible), METH_VARARGS|METH_KEYWORDS},
    {"setLinePen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setLinePen), METH_O},
    {"setLinePenColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setLinePenColor), METH_O},
    {"setLineVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setLineVisible), METH_VARARGS|METH_KEYWORDS},
    {"setMax", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setMax), METH_O},
    {"setMin", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setMin), METH_O},
    {"setMinorGridLineColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineColor), METH_O},
    {"setMinorGridLinePen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLinePen), METH_O},
    {"setMinorGridLineVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setMinorGridLineVisible), METH_VARARGS|METH_KEYWORDS},
    {"setRange", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setRange), METH_VARARGS},
    {"setReverse", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setReverse), METH_VARARGS|METH_KEYWORDS},
    {"setShadesBorderColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setShadesBorderColor), METH_O},
    {"setShadesBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setShadesBrush), METH_O},
    {"setShadesColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setShadesColor), METH_O},
    {"setShadesPen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setShadesPen), METH_O},
    {"setShadesVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setShadesVisible), METH_VARARGS|METH_KEYWORDS},
    {"setTitleBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setTitleBrush), METH_O},
    {"setTitleFont", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setTitleFont), METH_O},
    {"setTitleText", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setTitleText), METH_O},
    {"setTitleVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setTitleVisible), METH_VARARGS|METH_KEYWORDS},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_setVisible), METH_VARARGS|METH_KEYWORDS},
    {"shadesBorderColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_shadesBorderColor), METH_NOARGS},
    {"shadesBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_shadesBrush), METH_NOARGS},
    {"shadesColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_shadesColor), METH_NOARGS},
    {"shadesPen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_shadesPen), METH_NOARGS},
    {"shadesVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_shadesVisible), METH_NOARGS},
    {"show", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_show), METH_NOARGS},
    {"titleBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_titleBrush), METH_NOARGS},
    {"titleFont", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_titleFont), METH_NOARGS},
    {"titleText", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_titleText), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractAxisFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtCharts_QAbstractAxis_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtCharts::QAbstractAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractAxisWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtCharts_QAbstractAxis_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtCharts_QAbstractAxis_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtCharts_QAbstractAxis_Type = nullptr;
static SbkObjectType *Sbk_QtCharts_QAbstractAxis_TypeF(void)
{
    return _Sbk_QtCharts_QAbstractAxis_Type;
}

static PyType_Slot Sbk_QtCharts_QAbstractAxis_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtCharts_QAbstractAxis_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtCharts_QAbstractAxis_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtCharts_QAbstractAxis_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtCharts_QAbstractAxis_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtCharts_QAbstractAxis_spec = {
    "2:PySide2.QtCharts.QtCharts.QAbstractAxis",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtCharts_QAbstractAxis_slots
};

} //extern "C"

static void *Sbk_QtCharts_QAbstractAxis_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtCharts::QAbstractAxis *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QtCharts_QAbstractAxis_AxisType_PythonToCpp_QtCharts_QAbstractAxis_AxisType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtCharts::QAbstractAxis::AxisType *>(cppOut) =
        static_cast<::QtCharts::QAbstractAxis::AxisType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtCharts_QAbstractAxis_AxisType_PythonToCpp_QtCharts_QAbstractAxis_AxisType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX]))
        return QtCharts_QAbstractAxis_AxisType_PythonToCpp_QtCharts_QAbstractAxis_AxisType;
    return {};
}
static PyObject *QtCharts_QAbstractAxis_AxisType_CppToPython_QtCharts_QAbstractAxis_AxisType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtCharts::QAbstractAxis::AxisType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractAxis_PythonToCpp_QAbstractAxis_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtCharts_QAbstractAxis_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractAxis_PythonToCpp_QAbstractAxis_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QAbstractAxis_TypeF())))
        return QAbstractAxis_PythonToCpp_QAbstractAxis_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractAxis_PTR_CppToPython_QAbstractAxis(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtCharts::QAbstractAxis *>(const_cast<void *>(cppIn)), Sbk_QtCharts_QAbstractAxis_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtCharts_QAbstractAxis_SignatureStrings[] = {
    "PySide2.QtCharts.QtCharts.QAbstractAxis.alignment(self)->PySide2.QtCore.Qt.Alignment",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.gridLineColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.gridLinePen(self)->PySide2.QtGui.QPen",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.hide(self)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.isGridLineVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.isLineVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.isMinorGridLineVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.isReverse(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.isTitleVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.isVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsAngle(self)->int",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsEditable(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsFont(self)->PySide2.QtGui.QFont",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.labelsVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.linePen(self)->PySide2.QtGui.QPen",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.linePenColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.minorGridLineColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.minorGridLinePen(self)->PySide2.QtGui.QPen",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.orientation(self)->PySide2.QtCore.Qt.Orientation",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setGridLineColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setGridLinePen(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setGridLineVisible(self,visible:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsAngle(self,angle:int)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsEditable(self,editable:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsFont(self,font:PySide2.QtGui.QFont)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setLabelsVisible(self,visible:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setLinePen(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setLinePenColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setLineVisible(self,visible:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setMax(self,max:QVariant)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setMin(self,min:QVariant)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setMinorGridLineColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setMinorGridLinePen(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setMinorGridLineVisible(self,visible:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setRange(self,min:QVariant,max:QVariant)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setReverse(self,reverse:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesBorderColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesPen(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setShadesVisible(self,visible:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setTitleBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setTitleFont(self,font:PySide2.QtGui.QFont)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setTitleText(self,title:QString)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setTitleVisible(self,visible:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.setVisible(self,visible:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesBorderColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesPen(self)->PySide2.QtGui.QPen",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.shadesVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.show(self)",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.titleBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.titleFont(self)->PySide2.QtGui.QFont",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.titleText(self)->QString",
    "PySide2.QtCharts.QtCharts.QAbstractAxis.type(self)->PySide2.QtCharts.QtCharts.QAbstractAxis.AxisType",
    nullptr}; // Sentinel

void init_QtCharts_QAbstractAxis(PyObject *enclosingClass)
{
    _Sbk_QtCharts_QAbstractAxis_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAbstractAxis",
        "QtCharts::QAbstractAxis*",
        &Sbk_QtCharts_QAbstractAxis_spec,
        &Shiboken::callCppDestructor< ::QtCharts::QAbstractAxis >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QAbstractAxis_Type);
    InitSignatureStrings(pyType, QtCharts_QAbstractAxis_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QAbstractAxis_Type), Sbk_QtCharts_QAbstractAxis_PropertyStrings);
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QAbstractAxis_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtCharts_QAbstractAxis_TypeF(),
        QAbstractAxis_PythonToCpp_QAbstractAxis_PTR,
        is_QAbstractAxis_PythonToCpp_QAbstractAxis_PTR_Convertible,
        QAbstractAxis_PTR_CppToPython_QAbstractAxis);

    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QAbstractAxis");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QAbstractAxis*");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QAbstractAxis&");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractAxis");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractAxis*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractAxis&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtCharts::QAbstractAxis).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractAxisWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtCharts_QAbstractAxis_TypeF(), &Sbk_QtCharts_QAbstractAxis_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'AxisType'.
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtCharts_QAbstractAxis_TypeF(),
        "AxisType",
        "2:PySide2.QtCharts.QtCharts.QAbstractAxis.AxisType",
        "QtCharts::QAbstractAxis::AxisType");
    if (!SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX],
        Sbk_QtCharts_QAbstractAxis_TypeF(), "AxisTypeNoAxis", (long) QtCharts::QAbstractAxis::AxisType::AxisTypeNoAxis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX],
        Sbk_QtCharts_QAbstractAxis_TypeF(), "AxisTypeValue", (long) QtCharts::QAbstractAxis::AxisType::AxisTypeValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX],
        Sbk_QtCharts_QAbstractAxis_TypeF(), "AxisTypeBarCategory", (long) QtCharts::QAbstractAxis::AxisType::AxisTypeBarCategory))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX],
        Sbk_QtCharts_QAbstractAxis_TypeF(), "AxisTypeCategory", (long) QtCharts::QAbstractAxis::AxisType::AxisTypeCategory))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX],
        Sbk_QtCharts_QAbstractAxis_TypeF(), "AxisTypeDateTime", (long) QtCharts::QAbstractAxis::AxisType::AxisTypeDateTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX],
        Sbk_QtCharts_QAbstractAxis_TypeF(), "AxisTypeLogValue", (long) QtCharts::QAbstractAxis::AxisType::AxisTypeLogValue))
        return;
    // Register converter for enum 'QtCharts::QAbstractAxis::AxisType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX],
            QtCharts_QAbstractAxis_AxisType_CppToPython_QtCharts_QAbstractAxis_AxisType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtCharts_QAbstractAxis_AxisType_PythonToCpp_QtCharts_QAbstractAxis_AxisType,
            is_QtCharts_QAbstractAxis_AxisType_PythonToCpp_QtCharts_QAbstractAxis_AxisType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_AXISTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtCharts::QAbstractAxis::AxisType");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractAxis::AxisType");
        Shiboken::Conversions::registerConverterName(converter, "AxisType");
    }
    // End of 'AxisType' enum.

    PySide::Signal::registerSignals(Sbk_QtCharts_QAbstractAxis_TypeF(), &::QtCharts::QAbstractAxis::staticMetaObject);
    qRegisterMetaType< ::QtCharts::QAbstractAxis::AxisType >("QAbstractAxis::AxisType");
    qRegisterMetaType< ::QtCharts::QAbstractAxis::AxisType >("QtCharts::QAbstractAxis::AxisType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtCharts_QAbstractAxis_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtCharts_QAbstractAxis_TypeF(), &::QtCharts::QAbstractAxis::staticMetaObject, sizeof(QAbstractAxisWrapper));
}
