/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtcharts_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtChartsTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtChartsModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtChartsTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtCharts_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtChartsTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef QtCharts_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtChartsQtCharts(PyObject *module);
void init_QtCharts_QXYModelMapper(PyObject *enclosingClass);
void init_QtCharts_QVXYModelMapper(PyObject *enclosingClass);
void init_QtCharts_QPieSlice(PyObject *enclosingClass);
void init_QtCharts_QPieModelMapper(PyObject *enclosingClass);
void init_QtCharts_QVPieModelMapper(PyObject *enclosingClass);
void init_QtCharts_QLegendMarker(PyObject *enclosingClass);
void init_QtCharts_QXYLegendMarker(PyObject *enclosingClass);
void init_QtCharts_QPieLegendMarker(PyObject *enclosingClass);
void init_QtCharts_QLegend(PyObject *enclosingClass);
void init_QtCharts_QHXYModelMapper(PyObject *enclosingClass);
void init_QtCharts_QHPieModelMapper(PyObject *enclosingClass);
void init_QtCharts_QChartView(PyObject *enclosingClass);
void init_QtCharts_QChart(PyObject *enclosingClass);
void init_QtCharts_QPolarChart(PyObject *enclosingClass);
void init_QtCharts_QCandlestickSet(PyObject *enclosingClass);
void init_QtCharts_QCandlestickModelMapper(PyObject *enclosingClass);
void init_QtCharts_QVCandlestickModelMapper(PyObject *enclosingClass);
void init_QtCharts_QHCandlestickModelMapper(PyObject *enclosingClass);
void init_QtCharts_QCandlestickLegendMarker(PyObject *enclosingClass);
void init_QtCharts_QBoxSet(PyObject *enclosingClass);
void init_QtCharts_QBoxPlotModelMapper(PyObject *enclosingClass);
void init_QtCharts_QVBoxPlotModelMapper(PyObject *enclosingClass);
void init_QtCharts_QHBoxPlotModelMapper(PyObject *enclosingClass);
void init_QtCharts_QBoxPlotLegendMarker(PyObject *enclosingClass);
void init_QtCharts_QBarSet(PyObject *enclosingClass);
void init_QtCharts_QBarModelMapper(PyObject *enclosingClass);
void init_QtCharts_QVBarModelMapper(PyObject *enclosingClass);
void init_QtCharts_QHBarModelMapper(PyObject *enclosingClass);
void init_QtCharts_QBarLegendMarker(PyObject *enclosingClass);
void init_QtCharts_QAreaLegendMarker(PyObject *enclosingClass);
void init_QtCharts_QAbstractSeries(PyObject *enclosingClass);
void init_QtCharts_QBoxPlotSeries(PyObject *enclosingClass);
void init_QtCharts_QAreaSeries(PyObject *enclosingClass);
void init_QtCharts_QPieSeries(PyObject *enclosingClass);
void init_QtCharts_QXYSeries(PyObject *enclosingClass);
void init_QtCharts_QLineSeries(PyObject *enclosingClass);
void init_QtCharts_QSplineSeries(PyObject *enclosingClass);
void init_QtCharts_QScatterSeries(PyObject *enclosingClass);
void init_QtCharts_QCandlestickSeries(PyObject *enclosingClass);
void init_QtCharts_QAbstractBarSeries(PyObject *enclosingClass);
void init_QtCharts_QHorizontalStackedBarSeries(PyObject *enclosingClass);
void init_QtCharts_QHorizontalPercentBarSeries(PyObject *enclosingClass);
void init_QtCharts_QHorizontalBarSeries(PyObject *enclosingClass);
void init_QtCharts_QStackedBarSeries(PyObject *enclosingClass);
void init_QtCharts_QBarSeries(PyObject *enclosingClass);
void init_QtCharts_QPercentBarSeries(PyObject *enclosingClass);
void init_QtCharts_QAbstractAxis(PyObject *enclosingClass);
void init_QtCharts_QValueAxis(PyObject *enclosingClass);
void init_QtCharts_QCategoryAxis(PyObject *enclosingClass);
void init_QtCharts_QBarCategoryAxis(PyObject *enclosingClass);
void init_QtCharts_QDateTimeAxis(PyObject *enclosingClass);
void init_QtCharts_QLogValueAxis(PyObject *enclosingClass);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtWidgetsTypes;
SbkConverter **SbkPySide2_QtWidgetsTypeConverters;
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QList<QGraphicsItem* >'.
static PyObject *_QList_QGraphicsItemPTR__CppToPython__QList_QGraphicsItemPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGraphicsItem* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGraphicsItem* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGraphicsItem* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGraphicsItem* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGraphicsItem* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX], pyIn))
        return _QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QRectF > &'.
static PyObject *_constQList_QRectF_REF_CppToPython__constQList_QRectF_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QRectF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QRectF >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QRectF cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QRectF > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QRectF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyIn))
        return _constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QAction* >'.
static PyObject *_QList_QActionPTR__CppToPython__QList_QActionPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAction* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAction* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAction* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QActionPTR__PythonToCpp__QList_QActionPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAction* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAction* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QActionPTR__PythonToCpp__QList_QActionPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], pyIn))
        return _QList_QActionPTR__PythonToCpp__QList_QActionPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtCharts::QAbstractAxis* >'.
static PyObject *_QList_QtCharts_QAbstractAxisPTR__CppToPython__QList_QtCharts_QAbstractAxisPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtCharts::QAbstractAxis* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtCharts::QAbstractAxis* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtCharts::QAbstractAxis* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtCharts_QAbstractAxisPTR__PythonToCpp__QList_QtCharts_QAbstractAxisPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtCharts::QAbstractAxis* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtCharts::QAbstractAxis* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtCharts_QAbstractAxisPTR__PythonToCpp__QList_QtCharts_QAbstractAxisPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX], pyIn))
        return _QList_QtCharts_QAbstractAxisPTR__PythonToCpp__QList_QtCharts_QAbstractAxisPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtCharts::QAbstractSeries* >'.
static PyObject *_QList_QtCharts_QAbstractSeriesPTR__CppToPython__QList_QtCharts_QAbstractSeriesPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtCharts::QAbstractSeries* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtCharts::QAbstractSeries* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtCharts::QAbstractSeries* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTSERIES_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtCharts_QAbstractSeriesPTR__PythonToCpp__QList_QtCharts_QAbstractSeriesPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtCharts::QAbstractSeries* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtCharts::QAbstractSeries* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTSERIES_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtCharts_QAbstractSeriesPTR__PythonToCpp__QList_QtCharts_QAbstractSeriesPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTSERIES_IDX], pyIn))
        return _QList_QtCharts_QAbstractSeriesPTR__PythonToCpp__QList_QtCharts_QAbstractSeriesPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<qreal > &'.
static PyObject *_constQList_qreal_REF_CppToPython__constQList_qreal_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<qreal > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<qreal >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        qreal cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_qreal_REF_PythonToCpp__constQList_qreal_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<qreal > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        qreal cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_qreal_REF_PythonToCpp__constQList_qreal_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyIn))
        return _constQList_qreal_REF_PythonToCpp__constQList_qreal_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QtCharts::QLegendMarker* >'.
static PyObject *_QList_QtCharts_QLegendMarkerPTR__CppToPython__QList_QtCharts_QLegendMarkerPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtCharts::QLegendMarker* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtCharts::QLegendMarker* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtCharts::QLegendMarker* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QLEGENDMARKER_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtCharts_QLegendMarkerPTR__PythonToCpp__QList_QtCharts_QLegendMarkerPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtCharts::QLegendMarker* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtCharts::QLegendMarker* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QLEGENDMARKER_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtCharts_QLegendMarkerPTR__PythonToCpp__QList_QtCharts_QLegendMarkerPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QLEGENDMARKER_IDX], pyIn))
        return _QList_QtCharts_QLegendMarkerPTR__PythonToCpp__QList_QtCharts_QLegendMarkerPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QtCharts::QCandlestickSet* > &'.
static PyObject *_constQList_QtCharts_QCandlestickSetPTR_REF_CppToPython__constQList_QtCharts_QCandlestickSetPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtCharts::QCandlestickSet* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtCharts::QCandlestickSet* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtCharts::QCandlestickSet* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QCANDLESTICKSET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QtCharts_QCandlestickSetPTR_REF_PythonToCpp__constQList_QtCharts_QCandlestickSetPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtCharts::QCandlestickSet* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtCharts::QCandlestickSet* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QCANDLESTICKSET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QtCharts_QCandlestickSetPTR_REF_PythonToCpp__constQList_QtCharts_QCandlestickSetPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QCANDLESTICKSET_IDX], pyIn))
        return _constQList_QtCharts_QCandlestickSetPTR_REF_PythonToCpp__constQList_QtCharts_QCandlestickSetPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QtCharts::QBoxSet* >'.
static PyObject *_QList_QtCharts_QBoxSetPTR__CppToPython__QList_QtCharts_QBoxSetPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtCharts::QBoxSet* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtCharts::QBoxSet* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtCharts::QBoxSet* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXSET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtCharts_QBoxSetPTR__PythonToCpp__QList_QtCharts_QBoxSetPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtCharts::QBoxSet* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtCharts::QBoxSet* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXSET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtCharts_QBoxSetPTR__PythonToCpp__QList_QtCharts_QBoxSetPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXSET_IDX], pyIn))
        return _QList_QtCharts_QBoxSetPTR__PythonToCpp__QList_QtCharts_QBoxSetPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtCharts::QPieSlice* >'.
static PyObject *_QList_QtCharts_QPieSlicePTR__CppToPython__QList_QtCharts_QPieSlicePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtCharts::QPieSlice* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtCharts::QPieSlice* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtCharts::QPieSlice* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtCharts_QPieSlicePTR__PythonToCpp__QList_QtCharts_QPieSlicePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtCharts::QPieSlice* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtCharts::QPieSlice* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtCharts_QPieSlicePTR__PythonToCpp__QList_QtCharts_QPieSlicePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], pyIn))
        return _QList_QtCharts_QPieSlicePTR__PythonToCpp__QList_QtCharts_QPieSlicePTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtCharts::QBarSet* >'.
static PyObject *_QList_QtCharts_QBarSetPTR__CppToPython__QList_QtCharts_QBarSetPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtCharts::QBarSet* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtCharts::QBarSet* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtCharts::QBarSet* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBARSET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtCharts_QBarSetPTR__PythonToCpp__QList_QtCharts_QBarSetPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtCharts::QBarSet* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtCharts::QBarSet* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBARSET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtCharts_QBarSetPTR__PythonToCpp__QList_QtCharts_QBarSetPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBARSET_IDX], pyIn))
        return _QList_QtCharts_QBarSetPTR__PythonToCpp__QList_QtCharts_QBarSetPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QPointF > &'.
static PyObject *_constQList_QPointF_REF_CppToPython__constQList_QPointF_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPointF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPointF >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPointF cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPointF > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPointF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyIn))
        return _constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<QPointF >'.
static PyObject *_QVector_QPointF__CppToPython__QVector_QPointF_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPointF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPointF >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPointF >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPointF cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QPointF__PythonToCpp__QVector_QPointF_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPointF > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPointF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QPointF__PythonToCpp__QVector_QPointF__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyIn))
        return _QVector_QPointF__PythonToCpp__QVector_QPointF_;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtCharts",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtCharts_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtCharts_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtCharts)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtWidgets"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtWidgetsTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtCharts_IDX_COUNT];
    SbkPySide2_QtChartsTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtCharts_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtChartsTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtCharts", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtCharts", QtCharts_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtChartsModuleObject = module;

    // Initialize classes in the type system
    init_QtChartsQtCharts(module);
    init_QtCharts_QXYModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QVXYModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QPieSlice(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QPieModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QVPieModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QLegendMarker(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QXYLegendMarker(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QPieLegendMarker(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QLegend(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QHXYModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QHPieModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QChartView(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QChart(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QPolarChart(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QCandlestickSet(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QCandlestickModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QVCandlestickModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QHCandlestickModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QCandlestickLegendMarker(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QBoxSet(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QBoxPlotModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QVBoxPlotModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QHBoxPlotModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QBoxPlotLegendMarker(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QBarSet(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QBarModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QVBarModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QHBarModelMapper(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QBarLegendMarker(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QAreaLegendMarker(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QAbstractSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QBoxPlotSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QAreaSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QPieSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QXYSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QLineSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QSplineSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QScatterSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QCandlestickSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QAbstractBarSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QHorizontalStackedBarSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QHorizontalPercentBarSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QHorizontalBarSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QStackedBarSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QBarSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QPercentBarSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QAbstractAxis(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QValueAxis(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QCategoryAxis(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QBarCategoryAxis(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QDateTimeAxis(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);
    init_QtCharts_QLogValueAxis(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtChartsTypes[SBK_QtChartsQTCHARTS_IDX])->tp_dict);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QList<QGraphicsItem*>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QGRAPHICSITEMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QGraphicsItemPTR__CppToPython__QList_QGraphicsItemPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QGRAPHICSITEMPTR_IDX], "QList<QGraphicsItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QGRAPHICSITEMPTR_IDX],
        _QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR_,
        is__QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR__Convertible);

    // Register converter for type 'const QList<QRectF>&'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QRECTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QRectF_REF_CppToPython__constQList_QRectF_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QRECTF_IDX], "const QList<QRectF>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QRECTF_IDX], "QList<QRectF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QRECTF_IDX],
        _constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF,
        is__constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF_Convertible);

    // Register converter for type 'QList<QAction*>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QACTIONPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QActionPTR__CppToPython__QList_QActionPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QACTIONPTR_IDX], "QList<QAction*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QACTIONPTR_IDX],
        _QList_QActionPTR__PythonToCpp__QList_QActionPTR_,
        is__QList_QActionPTR__PythonToCpp__QList_QActionPTR__Convertible);

    // Register converter for type 'QList<QtCharts::QAbstractAxis*>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QABSTRACTAXISPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtCharts_QAbstractAxisPTR__CppToPython__QList_QtCharts_QAbstractAxisPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QABSTRACTAXISPTR_IDX], "QList<QtCharts::QAbstractAxis*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QABSTRACTAXISPTR_IDX],
        _QList_QtCharts_QAbstractAxisPTR__PythonToCpp__QList_QtCharts_QAbstractAxisPTR_,
        is__QList_QtCharts_QAbstractAxisPTR__PythonToCpp__QList_QtCharts_QAbstractAxisPTR__Convertible);

    // Register converter for type 'QList<QtCharts::QAbstractSeries*>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QABSTRACTSERIESPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtCharts_QAbstractSeriesPTR__CppToPython__QList_QtCharts_QAbstractSeriesPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QABSTRACTSERIESPTR_IDX], "QList<QtCharts::QAbstractSeries*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QABSTRACTSERIESPTR_IDX],
        _QList_QtCharts_QAbstractSeriesPTR__PythonToCpp__QList_QtCharts_QAbstractSeriesPTR_,
        is__QList_QtCharts_QAbstractSeriesPTR__PythonToCpp__QList_QtCharts_QAbstractSeriesPTR__Convertible);

    // Register converter for type 'const QList<qreal>&'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QREAL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_qreal_REF_CppToPython__constQList_qreal_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QREAL_IDX], "const QList<qreal>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QREAL_IDX], "QList<qreal>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QREAL_IDX],
        _constQList_qreal_REF_PythonToCpp__constQList_qreal_REF,
        is__constQList_qreal_REF_PythonToCpp__constQList_qreal_REF_Convertible);

    // Register converter for type 'QList<QtCharts::QLegendMarker*>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QLEGENDMARKERPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtCharts_QLegendMarkerPTR__CppToPython__QList_QtCharts_QLegendMarkerPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QLEGENDMARKERPTR_IDX], "QList<QtCharts::QLegendMarker*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QLEGENDMARKERPTR_IDX],
        _QList_QtCharts_QLegendMarkerPTR__PythonToCpp__QList_QtCharts_QLegendMarkerPTR_,
        is__QList_QtCharts_QLegendMarkerPTR__PythonToCpp__QList_QtCharts_QLegendMarkerPTR__Convertible);

    // Register converter for type 'const QList<QtCharts::QCandlestickSet*>&'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QCANDLESTICKSETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QtCharts_QCandlestickSetPTR_REF_CppToPython__constQList_QtCharts_QCandlestickSetPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QCANDLESTICKSETPTR_IDX], "const QList<QtCharts::QCandlestickSet*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QCANDLESTICKSETPTR_IDX], "QList<QtCharts::QCandlestickSet*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QCANDLESTICKSETPTR_IDX],
        _constQList_QtCharts_QCandlestickSetPTR_REF_PythonToCpp__constQList_QtCharts_QCandlestickSetPTR_REF,
        is__constQList_QtCharts_QCandlestickSetPTR_REF_PythonToCpp__constQList_QtCharts_QCandlestickSetPTR_REF_Convertible);

    // Register converter for type 'QList<QtCharts::QBoxSet*>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBOXSETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtCharts_QBoxSetPTR__CppToPython__QList_QtCharts_QBoxSetPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBOXSETPTR_IDX], "QList<QtCharts::QBoxSet*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBOXSETPTR_IDX],
        _QList_QtCharts_QBoxSetPTR__PythonToCpp__QList_QtCharts_QBoxSetPTR_,
        is__QList_QtCharts_QBoxSetPTR__PythonToCpp__QList_QtCharts_QBoxSetPTR__Convertible);

    // Register converter for type 'QList<QtCharts::QPieSlice*>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QPIESLICEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtCharts_QPieSlicePTR__CppToPython__QList_QtCharts_QPieSlicePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QPIESLICEPTR_IDX], "QList<QtCharts::QPieSlice*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QPIESLICEPTR_IDX],
        _QList_QtCharts_QPieSlicePTR__PythonToCpp__QList_QtCharts_QPieSlicePTR_,
        is__QList_QtCharts_QPieSlicePTR__PythonToCpp__QList_QtCharts_QPieSlicePTR__Convertible);

    // Register converter for type 'QList<QtCharts::QBarSet*>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBARSETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtCharts_QBarSetPTR__CppToPython__QList_QtCharts_QBarSetPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBARSETPTR_IDX], "QList<QtCharts::QBarSet*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBARSETPTR_IDX],
        _QList_QtCharts_QBarSetPTR__PythonToCpp__QList_QtCharts_QBarSetPTR_,
        is__QList_QtCharts_QBarSetPTR__PythonToCpp__QList_QtCharts_QBarSetPTR__Convertible);

    // Register converter for type 'const QList<QPointF>&'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QPOINTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QPointF_REF_CppToPython__constQList_QPointF_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QPOINTF_IDX], "const QList<QPointF>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QPOINTF_IDX], "QList<QPointF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QPOINTF_IDX],
        _constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF,
        is__constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF_Convertible);

    // Register converter for type 'QVector<QPointF>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QVECTOR_QPOINTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QPointF__CppToPython__QVector_QPointF_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QVECTOR_QPOINTF_IDX], "QVector<QPointF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QVECTOR_QPOINTF_IDX],
        _QVector_QPointF__PythonToCpp__QVector_QPointF_,
        is__QVector_QPointF__PythonToCpp__QVector_QPointF__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtChartsTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtChartsTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtCharts");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtCharts_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
