/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qstenciloperationarguments_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QStencilOperationArgumentsWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QStencilOperationArgumentsWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStencilOperationArgumentsWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStencilOperationArgumentsWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStencilOperationArgumentsWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QStencilOperationArgumentsWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStencilOperationArguments.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QStencilOperationArgumentsWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStencilOperationArguments.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QStencilOperationArgumentsWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QStencilOperationArgumentsWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QStencilOperationArguments::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QStencilOperationArgumentsWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QStencilOperationArguments::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QStencilOperationArgumentsWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QStencilOperationArgumentsWrapper *>(this));
        return Qt3DRender::QStencilOperationArguments::qt_metacast(_clname);
}

QStencilOperationArgumentsWrapper::~QStencilOperationArgumentsWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_Qt3DRender_QStencilOperationArgumentsFunc_allTestsPassOperation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilOperationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.allTestsPassOperation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allTestsPassOperation()const
            Qt3DRender::QStencilOperationArguments::Operation cppResult = const_cast<const ::Qt3DRender::QStencilOperationArguments *>(cppSelf)->allTestsPassOperation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QStencilOperationArgumentsFunc_depthTestFailureOperation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilOperationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.depthTestFailureOperation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depthTestFailureOperation()const
            Qt3DRender::QStencilOperationArguments::Operation cppResult = const_cast<const ::Qt3DRender::QStencilOperationArguments *>(cppSelf)->depthTestFailureOperation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QStencilOperationArgumentsFunc_faceMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilOperationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.faceMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // faceMode()const
            Qt3DRender::QStencilOperationArguments::FaceMode cppResult = const_cast<const ::Qt3DRender::QStencilOperationArguments *>(cppSelf)->faceMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setAllTestsPassOperation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilOperationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.setAllTestsPassOperation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStencilOperationArguments::setAllTestsPassOperation(Qt3DRender::QStencilOperationArguments::Operation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAllTestsPassOperation(Qt3DRender::QStencilOperationArguments::Operation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setAllTestsPassOperation_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QStencilOperationArguments::Operation cppArg0{Qt3DRender::QStencilOperationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAllTestsPassOperation(Qt3DRender::QStencilOperationArguments::Operation)
            cppSelf->setAllTestsPassOperation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setAllTestsPassOperation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setDepthTestFailureOperation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilOperationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.setDepthTestFailureOperation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStencilOperationArguments::setDepthTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDepthTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setDepthTestFailureOperation_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QStencilOperationArguments::Operation cppArg0{Qt3DRender::QStencilOperationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDepthTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)
            cppSelf->setDepthTestFailureOperation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setDepthTestFailureOperation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setStencilTestFailureOperation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilOperationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.setStencilTestFailureOperation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStencilOperationArguments::setStencilTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStencilTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setStencilTestFailureOperation_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QStencilOperationArguments::Operation cppArg0{Qt3DRender::QStencilOperationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStencilTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)
            cppSelf->setStencilTestFailureOperation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setStencilTestFailureOperation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QStencilOperationArgumentsFunc_stencilTestFailureOperation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilOperationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.stencilTestFailureOperation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stencilTestFailureOperation()const
            Qt3DRender::QStencilOperationArguments::Operation cppResult = const_cast<const ::Qt3DRender::QStencilOperationArguments *>(cppSelf)->stencilTestFailureOperation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QStencilOperationArguments_PropertyStrings[] = {
    "allTestsPassOperation::",
    "depthTestFailureOperation::",
    "faceMode:",
    "stencilTestFailureOperation::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QStencilOperationArguments_methods[] = {
    {"allTestsPassOperation", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilOperationArgumentsFunc_allTestsPassOperation), METH_NOARGS},
    {"depthTestFailureOperation", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilOperationArgumentsFunc_depthTestFailureOperation), METH_NOARGS},
    {"faceMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilOperationArgumentsFunc_faceMode), METH_NOARGS},
    {"setAllTestsPassOperation", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setAllTestsPassOperation), METH_O},
    {"setDepthTestFailureOperation", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setDepthTestFailureOperation), METH_O},
    {"setStencilTestFailureOperation", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilOperationArgumentsFunc_setStencilTestFailureOperation), METH_O},
    {"stencilTestFailureOperation", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilOperationArgumentsFunc_stencilTestFailureOperation), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QStencilOperationArguments_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QStencilOperationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QStencilOperationArgumentsWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QStencilOperationArguments_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QStencilOperationArguments_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QStencilOperationArguments_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QStencilOperationArguments_TypeF(void)
{
    return _Sbk_Qt3DRender_QStencilOperationArguments_Type;
}

static PyType_Slot Sbk_Qt3DRender_QStencilOperationArguments_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QStencilOperationArguments_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QStencilOperationArguments_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QStencilOperationArguments_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QStencilOperationArguments_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QStencilOperationArguments_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QStencilOperationArguments_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QStencilOperationArguments_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QStencilOperationArguments *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QStencilOperationArguments_FaceMode_PythonToCpp_Qt3DRender_QStencilOperationArguments_FaceMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QStencilOperationArguments::FaceMode *>(cppOut) =
        static_cast<::Qt3DRender::QStencilOperationArguments::FaceMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QStencilOperationArguments_FaceMode_PythonToCpp_Qt3DRender_QStencilOperationArguments_FaceMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX]))
        return Qt3DRender_QStencilOperationArguments_FaceMode_PythonToCpp_Qt3DRender_QStencilOperationArguments_FaceMode;
    return {};
}
static PyObject *Qt3DRender_QStencilOperationArguments_FaceMode_CppToPython_Qt3DRender_QStencilOperationArguments_FaceMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QStencilOperationArguments::FaceMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX], castCppIn);

}

static void Qt3DRender_QStencilOperationArguments_Operation_PythonToCpp_Qt3DRender_QStencilOperationArguments_Operation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QStencilOperationArguments::Operation *>(cppOut) =
        static_cast<::Qt3DRender::QStencilOperationArguments::Operation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QStencilOperationArguments_Operation_PythonToCpp_Qt3DRender_QStencilOperationArguments_Operation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX]))
        return Qt3DRender_QStencilOperationArguments_Operation_PythonToCpp_Qt3DRender_QStencilOperationArguments_Operation;
    return {};
}
static PyObject *Qt3DRender_QStencilOperationArguments_Operation_CppToPython_Qt3DRender_QStencilOperationArguments_Operation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QStencilOperationArguments::Operation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStencilOperationArguments_PythonToCpp_QStencilOperationArguments_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStencilOperationArguments_PythonToCpp_QStencilOperationArguments_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QStencilOperationArguments_TypeF())))
        return QStencilOperationArguments_PythonToCpp_QStencilOperationArguments_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStencilOperationArguments_PTR_CppToPython_QStencilOperationArguments(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QStencilOperationArguments *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QStencilOperationArguments_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QStencilOperationArguments_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.allTestsPassOperation(self)->PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation",
    "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.depthTestFailureOperation(self)->PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation",
    "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.faceMode(self)->PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.FaceMode",
    "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.setAllTestsPassOperation(self,operation:PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation)",
    "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.setDepthTestFailureOperation(self,operation:PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation)",
    "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.setStencilTestFailureOperation(self,operation:PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation)",
    "PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.stencilTestFailureOperation(self)->PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation",
    nullptr}; // Sentinel

void init_Qt3DRender_QStencilOperationArguments(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QStencilOperationArguments_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QStencilOperationArguments",
        "Qt3DRender::QStencilOperationArguments*",
        &Sbk_Qt3DRender_QStencilOperationArguments_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QStencilOperationArguments >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QStencilOperationArguments_Type);
    InitSignatureStrings(pyType, Qt3DRender_QStencilOperationArguments_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QStencilOperationArguments_Type), Sbk_Qt3DRender_QStencilOperationArguments_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QStencilOperationArguments_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QStencilOperationArguments_TypeF(),
        QStencilOperationArguments_PythonToCpp_QStencilOperationArguments_PTR,
        is_QStencilOperationArguments_PythonToCpp_QStencilOperationArguments_PTR_Convertible,
        QStencilOperationArguments_PTR_CppToPython_QStencilOperationArguments);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilOperationArguments");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilOperationArguments*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilOperationArguments&");
    Shiboken::Conversions::registerConverterName(converter, "QStencilOperationArguments");
    Shiboken::Conversions::registerConverterName(converter, "QStencilOperationArguments*");
    Shiboken::Conversions::registerConverterName(converter, "QStencilOperationArguments&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QStencilOperationArguments).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStencilOperationArgumentsWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), &Sbk_Qt3DRender_QStencilOperationArguments_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'FaceMode'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QStencilOperationArguments_TypeF(),
        "FaceMode",
        "2:PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.FaceMode",
        "Qt3DRender::QStencilOperationArguments::FaceMode");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "Front", (long) Qt3DRender::QStencilOperationArguments::FaceMode::Front))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "Back", (long) Qt3DRender::QStencilOperationArguments::FaceMode::Back))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "FrontAndBack", (long) Qt3DRender::QStencilOperationArguments::FaceMode::FrontAndBack))
        return;
    // Register converter for enum 'Qt3DRender::QStencilOperationArguments::FaceMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX],
            Qt3DRender_QStencilOperationArguments_FaceMode_CppToPython_Qt3DRender_QStencilOperationArguments_FaceMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QStencilOperationArguments_FaceMode_PythonToCpp_Qt3DRender_QStencilOperationArguments_FaceMode,
            is_Qt3DRender_QStencilOperationArguments_FaceMode_PythonToCpp_Qt3DRender_QStencilOperationArguments_FaceMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_FACEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilOperationArguments::FaceMode");
        Shiboken::Conversions::registerConverterName(converter, "QStencilOperationArguments::FaceMode");
        Shiboken::Conversions::registerConverterName(converter, "FaceMode");
    }
    // End of 'FaceMode' enum.

    // Initialization of enum 'Operation'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QStencilOperationArguments_TypeF(),
        "Operation",
        "2:PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation",
        "Qt3DRender::QStencilOperationArguments::Operation");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "Zero", (long) Qt3DRender::QStencilOperationArguments::Operation::Zero))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "Keep", (long) Qt3DRender::QStencilOperationArguments::Operation::Keep))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "Replace", (long) Qt3DRender::QStencilOperationArguments::Operation::Replace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "Increment", (long) Qt3DRender::QStencilOperationArguments::Operation::Increment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "Decrement", (long) Qt3DRender::QStencilOperationArguments::Operation::Decrement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "IncrementWrap", (long) Qt3DRender::QStencilOperationArguments::Operation::IncrementWrap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "DecrementWrap", (long) Qt3DRender::QStencilOperationArguments::Operation::DecrementWrap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX],
        Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), "Invert", (long) Qt3DRender::QStencilOperationArguments::Operation::Invert))
        return;
    // Register converter for enum 'Qt3DRender::QStencilOperationArguments::Operation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX],
            Qt3DRender_QStencilOperationArguments_Operation_CppToPython_Qt3DRender_QStencilOperationArguments_Operation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QStencilOperationArguments_Operation_PythonToCpp_Qt3DRender_QStencilOperationArguments_Operation,
            is_Qt3DRender_QStencilOperationArguments_Operation_PythonToCpp_Qt3DRender_QStencilOperationArguments_Operation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILOPERATIONARGUMENTS_OPERATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilOperationArguments::Operation");
        Shiboken::Conversions::registerConverterName(converter, "QStencilOperationArguments::Operation");
        Shiboken::Conversions::registerConverterName(converter, "Operation");
    }
    // End of 'Operation' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), &::Qt3DRender::QStencilOperationArguments::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QStencilOperationArguments::FaceMode >("QStencilOperationArguments::FaceMode");
    qRegisterMetaType< ::Qt3DRender::QStencilOperationArguments::FaceMode >("Qt3DRender::QStencilOperationArguments::FaceMode");
    qRegisterMetaType< ::Qt3DRender::QStencilOperationArguments::Operation >("QStencilOperationArguments::Operation");
    qRegisterMetaType< ::Qt3DRender::QStencilOperationArguments::Operation >("Qt3DRender::QStencilOperationArguments::Operation");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QStencilOperationArguments_TypeF(), &::Qt3DRender::QStencilOperationArguments::staticMetaObject, sizeof(QStencilOperationArgumentsWrapper));
}
