/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qshaderprogram_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QShaderProgramWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QShaderProgramWrapper::QShaderProgramWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QShaderProgram(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QShaderProgramWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QShaderProgramWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QShaderProgramWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QShaderProgramWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QShaderProgramWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QShaderProgram.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QShaderProgramWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QShaderProgram.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QShaderProgramWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QShaderProgramWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QShaderProgram::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QShaderProgramWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QShaderProgram::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QShaderProgramWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QShaderProgramWrapper *>(this));
        return Qt3DRender::QShaderProgram::qt_metacast(_clname);
}

QShaderProgramWrapper::~QShaderProgramWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QShaderProgram_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QShaderProgram >()))
        return -1;

    ::QShaderProgramWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QShaderProgram", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QShaderProgram::QShaderProgram(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QShaderProgram(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QShaderProgram(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgram_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QShaderProgram_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QShaderProgram_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QShaderProgram(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QShaderProgramWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QShaderProgramWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QShaderProgram >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QShaderProgram_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QShaderProgram_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QShaderProgram_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_computeShaderCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.computeShaderCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // computeShaderCode()const
            QByteArray cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->computeShaderCode();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            Qt3DRender::QShaderProgram::Format cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_fragmentShaderCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.fragmentShaderCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fragmentShaderCode()const
            QByteArray cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->fragmentShaderCode();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_geometryShaderCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.geometryShaderCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geometryShaderCode()const
            QByteArray cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->geometryShaderCode();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_loadSource(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.loadSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QShaderProgram::loadSource(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // loadSource(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_loadSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // loadSource(QUrl)
            QByteArray cppResult = ::Qt3DRender::QShaderProgram::loadSource(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DRender_QShaderProgramFunc_loadSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_log(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.log";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // log()const
            QString cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->log();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_setComputeShaderCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setComputeShaderCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderProgram::setComputeShaderCode(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setComputeShaderCode(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_setComputeShaderCode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setComputeShaderCode(QByteArray)
            cppSelf->setComputeShaderCode(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderProgramFunc_setComputeShaderCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderProgram::setFormat(Qt3DRender::QShaderProgram::Format)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFormat(Qt3DRender::QShaderProgram::Format)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_setFormat_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QShaderProgram::Format cppArg0{Qt3DRender::QShaderProgram::GLSL};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFormat(Qt3DRender::QShaderProgram::Format)
            cppSelf->setFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderProgramFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_setFragmentShaderCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setFragmentShaderCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderProgram::setFragmentShaderCode(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setFragmentShaderCode(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_setFragmentShaderCode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFragmentShaderCode(QByteArray)
            cppSelf->setFragmentShaderCode(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderProgramFunc_setFragmentShaderCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_setGeometryShaderCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setGeometryShaderCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderProgram::setGeometryShaderCode(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setGeometryShaderCode(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_setGeometryShaderCode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGeometryShaderCode(QByteArray)
            cppSelf->setGeometryShaderCode(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderProgramFunc_setGeometryShaderCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_setShaderCode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setShaderCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setShaderCode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QShaderProgram::setShaderCode(Qt3DRender::QShaderProgram::ShaderType,QByteArray)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setShaderCode(Qt3DRender::QShaderProgram::ShaderType,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_setShaderCode_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QShaderProgram::ShaderType cppArg0{Qt3DRender::QShaderProgram::Vertex};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setShaderCode(Qt3DRender::QShaderProgram::ShaderType,QByteArray)
            cppSelf->setShaderCode(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderProgramFunc_setShaderCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_setTessellationControlShaderCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setTessellationControlShaderCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderProgram::setTessellationControlShaderCode(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setTessellationControlShaderCode(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_setTessellationControlShaderCode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTessellationControlShaderCode(QByteArray)
            cppSelf->setTessellationControlShaderCode(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderProgramFunc_setTessellationControlShaderCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_setTessellationEvaluationShaderCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setTessellationEvaluationShaderCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderProgram::setTessellationEvaluationShaderCode(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setTessellationEvaluationShaderCode(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_setTessellationEvaluationShaderCode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTessellationEvaluationShaderCode(QByteArray)
            cppSelf->setTessellationEvaluationShaderCode(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderProgramFunc_setTessellationEvaluationShaderCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_setVertexShaderCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setVertexShaderCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderProgram::setVertexShaderCode(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setVertexShaderCode(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_setVertexShaderCode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setVertexShaderCode(QByteArray)
            cppSelf->setVertexShaderCode(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderProgramFunc_setVertexShaderCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_shaderCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.shaderCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderProgram::shaderCode(Qt3DRender::QShaderProgram::ShaderType)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // shaderCode(Qt3DRender::QShaderProgram::ShaderType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderProgramFunc_shaderCode_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QShaderProgram::ShaderType cppArg0{Qt3DRender::QShaderProgram::Vertex};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // shaderCode(Qt3DRender::QShaderProgram::ShaderType)const
            QByteArray cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->shaderCode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DRender_QShaderProgramFunc_shaderCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            Qt3DRender::QShaderProgram::Status cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_tessellationControlShaderCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.tessellationControlShaderCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tessellationControlShaderCode()const
            QByteArray cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->tessellationControlShaderCode();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_tessellationEvaluationShaderCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.tessellationEvaluationShaderCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tessellationEvaluationShaderCode()const
            QByteArray cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->tessellationEvaluationShaderCode();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderProgramFunc_vertexShaderCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.vertexShaderCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertexShaderCode()const
            QByteArray cppResult = const_cast<const ::Qt3DRender::QShaderProgram *>(cppSelf)->vertexShaderCode();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QShaderProgram_PropertyStrings[] = {
    "computeShaderCode::",
    "format::",
    "fragmentShaderCode::",
    "geometryShaderCode::",
    "log:",
    "status:",
    "tessellationControlShaderCode::",
    "tessellationEvaluationShaderCode::",
    "vertexShaderCode::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QShaderProgram_methods[] = {
    {"computeShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_computeShaderCode), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_format), METH_NOARGS},
    {"fragmentShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_fragmentShaderCode), METH_NOARGS},
    {"geometryShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_geometryShaderCode), METH_NOARGS},
    {"loadSource", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_loadSource), METH_O|METH_STATIC},
    {"log", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_log), METH_NOARGS},
    {"setComputeShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_setComputeShaderCode), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_setFormat), METH_O},
    {"setFragmentShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_setFragmentShaderCode), METH_O},
    {"setGeometryShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_setGeometryShaderCode), METH_O},
    {"setShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_setShaderCode), METH_VARARGS},
    {"setTessellationControlShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_setTessellationControlShaderCode), METH_O},
    {"setTessellationEvaluationShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_setTessellationEvaluationShaderCode), METH_O},
    {"setVertexShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_setVertexShaderCode), METH_O},
    {"shaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_shaderCode), METH_O},
    {"status", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_status), METH_NOARGS},
    {"tessellationControlShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_tessellationControlShaderCode), METH_NOARGS},
    {"tessellationEvaluationShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_tessellationEvaluationShaderCode), METH_NOARGS},
    {"vertexShaderCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderProgramFunc_vertexShaderCode), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QShaderProgram_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QShaderProgramWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QShaderProgram_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QShaderProgram_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QShaderProgram_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QShaderProgram_TypeF(void)
{
    return _Sbk_Qt3DRender_QShaderProgram_Type;
}

static PyType_Slot Sbk_Qt3DRender_QShaderProgram_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderProgram_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderProgram_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderProgram_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderProgram_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderProgram_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QShaderProgram_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QShaderProgram",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QShaderProgram_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QShaderProgram_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QShaderProgram *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QShaderProgram_ShaderType_PythonToCpp_Qt3DRender_QShaderProgram_ShaderType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QShaderProgram::ShaderType *>(cppOut) =
        static_cast<::Qt3DRender::QShaderProgram::ShaderType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QShaderProgram_ShaderType_PythonToCpp_Qt3DRender_QShaderProgram_ShaderType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX]))
        return Qt3DRender_QShaderProgram_ShaderType_PythonToCpp_Qt3DRender_QShaderProgram_ShaderType;
    return {};
}
static PyObject *Qt3DRender_QShaderProgram_ShaderType_CppToPython_Qt3DRender_QShaderProgram_ShaderType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QShaderProgram::ShaderType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX], castCppIn);

}

static void Qt3DRender_QShaderProgram_Status_PythonToCpp_Qt3DRender_QShaderProgram_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QShaderProgram::Status *>(cppOut) =
        static_cast<::Qt3DRender::QShaderProgram::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QShaderProgram_Status_PythonToCpp_Qt3DRender_QShaderProgram_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX]))
        return Qt3DRender_QShaderProgram_Status_PythonToCpp_Qt3DRender_QShaderProgram_Status;
    return {};
}
static PyObject *Qt3DRender_QShaderProgram_Status_CppToPython_Qt3DRender_QShaderProgram_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QShaderProgram::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX], castCppIn);

}

static void Qt3DRender_QShaderProgram_Format_PythonToCpp_Qt3DRender_QShaderProgram_Format(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QShaderProgram::Format *>(cppOut) =
        static_cast<::Qt3DRender::QShaderProgram::Format>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QShaderProgram_Format_PythonToCpp_Qt3DRender_QShaderProgram_Format_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX]))
        return Qt3DRender_QShaderProgram_Format_PythonToCpp_Qt3DRender_QShaderProgram_Format;
    return {};
}
static PyObject *Qt3DRender_QShaderProgram_Format_CppToPython_Qt3DRender_QShaderProgram_Format(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QShaderProgram::Format *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QShaderProgram_PythonToCpp_QShaderProgram_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QShaderProgram_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QShaderProgram_PythonToCpp_QShaderProgram_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QShaderProgram_TypeF())))
        return QShaderProgram_PythonToCpp_QShaderProgram_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QShaderProgram_PTR_CppToPython_QShaderProgram(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QShaderProgram *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QShaderProgram_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QShaderProgram_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.computeShaderCode(self)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.format(self)->PySide2.Qt3DRender.Qt3DRender.QShaderProgram.Format",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.fragmentShaderCode(self)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.geometryShaderCode(self)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.loadSource(sourceUrl:PySide2.QtCore.QUrl)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.log(self)->QString",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setComputeShaderCode(self,computeShaderCode:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setFormat(self,format:PySide2.Qt3DRender.Qt3DRender.QShaderProgram.Format)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setFragmentShaderCode(self,fragmentShaderCode:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setGeometryShaderCode(self,geometryShaderCode:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setShaderCode(self,type:PySide2.Qt3DRender.Qt3DRender.QShaderProgram.ShaderType,shaderCode:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setTessellationControlShaderCode(self,tessellationControlShaderCode:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setTessellationEvaluationShaderCode(self,tessellationEvaluationShaderCode:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.setVertexShaderCode(self,vertexShaderCode:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.shaderCode(self,type:PySide2.Qt3DRender.Qt3DRender.QShaderProgram.ShaderType)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.status(self)->PySide2.Qt3DRender.Qt3DRender.QShaderProgram.Status",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.tessellationControlShaderCode(self)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.tessellationEvaluationShaderCode(self)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DRender.Qt3DRender.QShaderProgram.vertexShaderCode(self)->PySide2.QtCore.QByteArray",
    nullptr}; // Sentinel

void init_Qt3DRender_QShaderProgram(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QShaderProgram_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QShaderProgram",
        "Qt3DRender::QShaderProgram*",
        &Sbk_Qt3DRender_QShaderProgram_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QShaderProgram >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QShaderProgram_Type);
    InitSignatureStrings(pyType, Qt3DRender_QShaderProgram_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QShaderProgram_Type), Sbk_Qt3DRender_QShaderProgram_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QShaderProgram_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QShaderProgram_TypeF(),
        QShaderProgram_PythonToCpp_QShaderProgram_PTR,
        is_QShaderProgram_PythonToCpp_QShaderProgram_PTR_Convertible,
        QShaderProgram_PTR_CppToPython_QShaderProgram);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderProgram");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderProgram*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderProgram&");
    Shiboken::Conversions::registerConverterName(converter, "QShaderProgram");
    Shiboken::Conversions::registerConverterName(converter, "QShaderProgram*");
    Shiboken::Conversions::registerConverterName(converter, "QShaderProgram&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QShaderProgram).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QShaderProgramWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QShaderProgram_TypeF(), &Sbk_Qt3DRender_QShaderProgram_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ShaderType'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QShaderProgram_TypeF(),
        "ShaderType",
        "2:PySide2.Qt3DRender.Qt3DRender.QShaderProgram.ShaderType",
        "Qt3DRender::QShaderProgram::ShaderType");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "Vertex", (long) Qt3DRender::QShaderProgram::ShaderType::Vertex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "Fragment", (long) Qt3DRender::QShaderProgram::ShaderType::Fragment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "TessellationControl", (long) Qt3DRender::QShaderProgram::ShaderType::TessellationControl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "TessellationEvaluation", (long) Qt3DRender::QShaderProgram::ShaderType::TessellationEvaluation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "Geometry", (long) Qt3DRender::QShaderProgram::ShaderType::Geometry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "Compute", (long) Qt3DRender::QShaderProgram::ShaderType::Compute))
        return;
    // Register converter for enum 'Qt3DRender::QShaderProgram::ShaderType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX],
            Qt3DRender_QShaderProgram_ShaderType_CppToPython_Qt3DRender_QShaderProgram_ShaderType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QShaderProgram_ShaderType_PythonToCpp_Qt3DRender_QShaderProgram_ShaderType,
            is_Qt3DRender_QShaderProgram_ShaderType_PythonToCpp_Qt3DRender_QShaderProgram_ShaderType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_SHADERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderProgram::ShaderType");
        Shiboken::Conversions::registerConverterName(converter, "QShaderProgram::ShaderType");
        Shiboken::Conversions::registerConverterName(converter, "ShaderType");
    }
    // End of 'ShaderType' enum.

    // Initialization of enum 'Status'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QShaderProgram_TypeF(),
        "Status",
        "2:PySide2.Qt3DRender.Qt3DRender.QShaderProgram.Status",
        "Qt3DRender::QShaderProgram::Status");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "NotReady", (long) Qt3DRender::QShaderProgram::Status::NotReady))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "Ready", (long) Qt3DRender::QShaderProgram::Status::Ready))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "Error", (long) Qt3DRender::QShaderProgram::Status::Error))
        return;
    // Register converter for enum 'Qt3DRender::QShaderProgram::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX],
            Qt3DRender_QShaderProgram_Status_CppToPython_Qt3DRender_QShaderProgram_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QShaderProgram_Status_PythonToCpp_Qt3DRender_QShaderProgram_Status,
            is_Qt3DRender_QShaderProgram_Status_PythonToCpp_Qt3DRender_QShaderProgram_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderProgram::Status");
        Shiboken::Conversions::registerConverterName(converter, "QShaderProgram::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    // Initialization of enum 'Format'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QShaderProgram_TypeF(),
        "Format",
        "2:PySide2.Qt3DRender.Qt3DRender.QShaderProgram.Format",
        "Qt3DRender::QShaderProgram::Format");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "GLSL", (long) Qt3DRender::QShaderProgram::Format::GLSL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX],
        Sbk_Qt3DRender_QShaderProgram_TypeF(), "SPIRV", (long) Qt3DRender::QShaderProgram::Format::SPIRV))
        return;
    // Register converter for enum 'Qt3DRender::QShaderProgram::Format'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX],
            Qt3DRender_QShaderProgram_Format_CppToPython_Qt3DRender_QShaderProgram_Format);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QShaderProgram_Format_PythonToCpp_Qt3DRender_QShaderProgram_Format,
            is_Qt3DRender_QShaderProgram_Format_PythonToCpp_Qt3DRender_QShaderProgram_Format_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERPROGRAM_FORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderProgram::Format");
        Shiboken::Conversions::registerConverterName(converter, "QShaderProgram::Format");
        Shiboken::Conversions::registerConverterName(converter, "Format");
    }
    // End of 'Format' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QShaderProgram_TypeF(), &::Qt3DRender::QShaderProgram::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QShaderProgram::ShaderType >("QShaderProgram::ShaderType");
    qRegisterMetaType< ::Qt3DRender::QShaderProgram::ShaderType >("Qt3DRender::QShaderProgram::ShaderType");
    qRegisterMetaType< ::Qt3DRender::QShaderProgram::Status >("QShaderProgram::Status");
    qRegisterMetaType< ::Qt3DRender::QShaderProgram::Status >("Qt3DRender::QShaderProgram::Status");
    qRegisterMetaType< ::Qt3DRender::QShaderProgram::Format >("QShaderProgram::Format");
    qRegisterMetaType< ::Qt3DRender::QShaderProgram::Format >("Qt3DRender::QShaderProgram::Format");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QShaderProgram_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QShaderProgram_TypeF(), &::Qt3DRender::QShaderProgram::staticMetaObject, sizeof(QShaderProgramWrapper));
}
