/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qrendercapabilities_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QRenderCapabilitiesWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QRenderCapabilitiesWrapper::QRenderCapabilitiesWrapper(::QObject * parent) : Qt3DRender::QRenderCapabilities(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QRenderCapabilitiesWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRenderCapabilitiesWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QRenderCapabilitiesWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRenderCapabilitiesWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QRenderCapabilitiesWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRenderCapabilities.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QRenderCapabilitiesWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRenderCapabilities.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QRenderCapabilitiesWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QRenderCapabilitiesWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QRenderCapabilities::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QRenderCapabilitiesWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QRenderCapabilities::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QRenderCapabilitiesWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QRenderCapabilitiesWrapper *>(this));
        return Qt3DRender::QRenderCapabilities::qt_metacast(_clname);
}

QRenderCapabilitiesWrapper::~QRenderCapabilitiesWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QRenderCapabilities_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QRenderCapabilities >()))
        return -1;

    ::QRenderCapabilitiesWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QRenderCapabilities", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QRenderCapabilities::QRenderCapabilities(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QRenderCapabilities(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QRenderCapabilities(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QRenderCapabilities_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QRenderCapabilities_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QRenderCapabilities_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QRenderCapabilities(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QRenderCapabilitiesWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QRenderCapabilitiesWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QRenderCapabilities >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QRenderCapabilities_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QRenderCapabilities_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QRenderCapabilities_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_api(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.api";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // api()const
            Qt3DRender::QRenderCapabilities::API cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->api();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_driverVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.driverVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // driverVersion()const
            QString cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->driverVersion();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_extensions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.extensions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // extensions()const
            QStringList cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->extensions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_glslVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.glslVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glslVersion()const
            QString cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->glslVersion();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_majorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.majorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // majorVersion()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->majorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxComputeInvocations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxComputeInvocations";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxComputeInvocations()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxComputeInvocations();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxComputeSharedMemorySize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxComputeSharedMemorySize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxComputeSharedMemorySize()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxComputeSharedMemorySize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxImageUnits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxImageUnits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxImageUnits()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxImageUnits();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxSSBOBindings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxSSBOBindings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxSSBOBindings()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxSSBOBindings();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxSSBOSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxSSBOSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxSSBOSize()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxSSBOSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxSamples(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxSamples";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxSamples()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxSamples();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxTextureLayers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxTextureLayers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxTextureLayers()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxTextureLayers();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxTextureSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxTextureSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxTextureSize()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxTextureSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxTextureUnits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxTextureUnits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxTextureUnits()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxTextureUnits();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxUBOBindings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxUBOBindings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxUBOBindings()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxUBOBindings();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxUBOSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxUBOSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxUBOSize()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxUBOSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupCountX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupCountX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxWorkGroupCountX()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxWorkGroupCountX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupCountY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupCountY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxWorkGroupCountY()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxWorkGroupCountY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupCountZ(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupCountZ";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxWorkGroupCountZ()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxWorkGroupCountZ();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupSizeX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupSizeX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxWorkGroupSizeX()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxWorkGroupSizeX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupSizeY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupSizeY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxWorkGroupSizeY()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxWorkGroupSizeY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupSizeZ(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupSizeZ";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxWorkGroupSizeZ()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->maxWorkGroupSizeZ();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_minorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.minorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minorVersion()const
            int cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->minorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_profile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.profile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // profile()const
            Qt3DRender::QRenderCapabilities::Profile cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->profile();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_renderer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.renderer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderer()const
            QString cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->renderer();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_supportsCompute(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.supportsCompute";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsCompute()const
            bool cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->supportsCompute();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_supportsImageStore(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.supportsImageStore";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsImageStore()const
            bool cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->supportsImageStore();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_supportsSSBO(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.supportsSSBO";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsSSBO()const
            bool cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->supportsSSBO();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_supportsUBO(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.supportsUBO";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsUBO()const
            bool cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->supportsUBO();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRenderCapabilitiesFunc_vendor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.vendor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vendor()const
            QString cppResult = const_cast<const ::Qt3DRender::QRenderCapabilities *>(cppSelf)->vendor();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QRenderCapabilities_PropertyStrings[] = {
    "api:",
    "driverVersion:",
    "extensions:",
    "glslVersion:",
    "majorVersion:",
    "maxComputeInvocations:",
    "maxComputeSharedMemorySize:",
    "maxImageUnits:",
    "maxSSBOBindings:",
    "maxSSBOSize:",
    "maxSamples:",
    "maxTextureLayers:",
    "maxTextureSize:",
    "maxTextureUnits:",
    "maxUBOBindings:",
    "maxUBOSize:",
    "maxWorkGroupCountX:",
    "maxWorkGroupCountY:",
    "maxWorkGroupCountZ:",
    "maxWorkGroupSizeX:",
    "maxWorkGroupSizeY:",
    "maxWorkGroupSizeZ:",
    "minorVersion:",
    "profile:",
    "renderer:",
    "supportsCompute:",
    "supportsImageStore:",
    "supportsSSBO:",
    "supportsUBO:",
    "valid:isValid",
    "vendor:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QRenderCapabilities_methods[] = {
    {"api", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_api), METH_NOARGS},
    {"driverVersion", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_driverVersion), METH_NOARGS},
    {"extensions", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_extensions), METH_NOARGS},
    {"glslVersion", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_glslVersion), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_isValid), METH_NOARGS},
    {"majorVersion", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_majorVersion), METH_NOARGS},
    {"maxComputeInvocations", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxComputeInvocations), METH_NOARGS},
    {"maxComputeSharedMemorySize", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxComputeSharedMemorySize), METH_NOARGS},
    {"maxImageUnits", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxImageUnits), METH_NOARGS},
    {"maxSSBOBindings", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxSSBOBindings), METH_NOARGS},
    {"maxSSBOSize", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxSSBOSize), METH_NOARGS},
    {"maxSamples", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxSamples), METH_NOARGS},
    {"maxTextureLayers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxTextureLayers), METH_NOARGS},
    {"maxTextureSize", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxTextureSize), METH_NOARGS},
    {"maxTextureUnits", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxTextureUnits), METH_NOARGS},
    {"maxUBOBindings", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxUBOBindings), METH_NOARGS},
    {"maxUBOSize", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxUBOSize), METH_NOARGS},
    {"maxWorkGroupCountX", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupCountX), METH_NOARGS},
    {"maxWorkGroupCountY", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupCountY), METH_NOARGS},
    {"maxWorkGroupCountZ", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupCountZ), METH_NOARGS},
    {"maxWorkGroupSizeX", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupSizeX), METH_NOARGS},
    {"maxWorkGroupSizeY", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupSizeY), METH_NOARGS},
    {"maxWorkGroupSizeZ", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_maxWorkGroupSizeZ), METH_NOARGS},
    {"minorVersion", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_minorVersion), METH_NOARGS},
    {"profile", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_profile), METH_NOARGS},
    {"renderer", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_renderer), METH_NOARGS},
    {"supportsCompute", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_supportsCompute), METH_NOARGS},
    {"supportsImageStore", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_supportsImageStore), METH_NOARGS},
    {"supportsSSBO", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_supportsSSBO), METH_NOARGS},
    {"supportsUBO", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_supportsUBO), METH_NOARGS},
    {"vendor", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRenderCapabilitiesFunc_vendor), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QRenderCapabilities_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QRenderCapabilities *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QRenderCapabilitiesWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QRenderCapabilities_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QRenderCapabilities_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QRenderCapabilities_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QRenderCapabilities_TypeF(void)
{
    return _Sbk_Qt3DRender_QRenderCapabilities_Type;
}

static PyType_Slot Sbk_Qt3DRender_QRenderCapabilities_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QRenderCapabilities_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QRenderCapabilities_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QRenderCapabilities_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QRenderCapabilities_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QRenderCapabilities_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QRenderCapabilities_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QRenderCapabilities_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QRenderCapabilities_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QRenderCapabilities *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QRenderCapabilities_API_PythonToCpp_Qt3DRender_QRenderCapabilities_API(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QRenderCapabilities::API *>(cppOut) =
        static_cast<::Qt3DRender::QRenderCapabilities::API>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QRenderCapabilities_API_PythonToCpp_Qt3DRender_QRenderCapabilities_API_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX]))
        return Qt3DRender_QRenderCapabilities_API_PythonToCpp_Qt3DRender_QRenderCapabilities_API;
    return {};
}
static PyObject *Qt3DRender_QRenderCapabilities_API_CppToPython_Qt3DRender_QRenderCapabilities_API(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QRenderCapabilities::API *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX], castCppIn);

}

static void Qt3DRender_QRenderCapabilities_Profile_PythonToCpp_Qt3DRender_QRenderCapabilities_Profile(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QRenderCapabilities::Profile *>(cppOut) =
        static_cast<::Qt3DRender::QRenderCapabilities::Profile>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QRenderCapabilities_Profile_PythonToCpp_Qt3DRender_QRenderCapabilities_Profile_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX]))
        return Qt3DRender_QRenderCapabilities_Profile_PythonToCpp_Qt3DRender_QRenderCapabilities_Profile;
    return {};
}
static PyObject *Qt3DRender_QRenderCapabilities_Profile_CppToPython_Qt3DRender_QRenderCapabilities_Profile(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QRenderCapabilities::Profile *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRenderCapabilities_PythonToCpp_QRenderCapabilities_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QRenderCapabilities_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRenderCapabilities_PythonToCpp_QRenderCapabilities_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QRenderCapabilities_TypeF())))
        return QRenderCapabilities_PythonToCpp_QRenderCapabilities_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRenderCapabilities_PTR_CppToPython_QRenderCapabilities(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QRenderCapabilities *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QRenderCapabilities_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QRenderCapabilities_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.api(self)->PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.API",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.driverVersion(self)->QString",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.extensions(self)->QStringList",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.glslVersion(self)->QString",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.isValid(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.majorVersion(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxComputeInvocations(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxComputeSharedMemorySize(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxImageUnits(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxSSBOBindings(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxSSBOSize(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxSamples(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxTextureLayers(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxTextureSize(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxTextureUnits(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxUBOBindings(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxUBOSize(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupCountX(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupCountY(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupCountZ(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupSizeX(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupSizeY(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.maxWorkGroupSizeZ(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.minorVersion(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.profile(self)->PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.Profile",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.renderer(self)->QString",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.supportsCompute(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.supportsImageStore(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.supportsSSBO(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.supportsUBO(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.vendor(self)->QString",
    nullptr}; // Sentinel

void init_Qt3DRender_QRenderCapabilities(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QRenderCapabilities_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QRenderCapabilities",
        "Qt3DRender::QRenderCapabilities*",
        &Sbk_Qt3DRender_QRenderCapabilities_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QRenderCapabilities >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QRenderCapabilities_Type);
    InitSignatureStrings(pyType, Qt3DRender_QRenderCapabilities_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QRenderCapabilities_Type), Sbk_Qt3DRender_QRenderCapabilities_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QRenderCapabilities_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QRenderCapabilities_TypeF(),
        QRenderCapabilities_PythonToCpp_QRenderCapabilities_PTR,
        is_QRenderCapabilities_PythonToCpp_QRenderCapabilities_PTR_Convertible,
        QRenderCapabilities_PTR_CppToPython_QRenderCapabilities);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QRenderCapabilities");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QRenderCapabilities*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QRenderCapabilities&");
    Shiboken::Conversions::registerConverterName(converter, "QRenderCapabilities");
    Shiboken::Conversions::registerConverterName(converter, "QRenderCapabilities*");
    Shiboken::Conversions::registerConverterName(converter, "QRenderCapabilities&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QRenderCapabilities).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRenderCapabilitiesWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QRenderCapabilities_TypeF(), &Sbk_Qt3DRender_QRenderCapabilities_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'API'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QRenderCapabilities_TypeF(),
        "API",
        "2:PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.API",
        "Qt3DRender::QRenderCapabilities::API");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX],
        Sbk_Qt3DRender_QRenderCapabilities_TypeF(), "OpenGL", (long) Qt3DRender::QRenderCapabilities::API::OpenGL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX],
        Sbk_Qt3DRender_QRenderCapabilities_TypeF(), "OpenGLES", (long) Qt3DRender::QRenderCapabilities::API::OpenGLES))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX],
        Sbk_Qt3DRender_QRenderCapabilities_TypeF(), "Vulkan", (long) Qt3DRender::QRenderCapabilities::API::Vulkan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX],
        Sbk_Qt3DRender_QRenderCapabilities_TypeF(), "DirectX", (long) Qt3DRender::QRenderCapabilities::API::DirectX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX],
        Sbk_Qt3DRender_QRenderCapabilities_TypeF(), "RHI", (long) Qt3DRender::QRenderCapabilities::API::RHI))
        return;
    // Register converter for enum 'Qt3DRender::QRenderCapabilities::API'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX],
            Qt3DRender_QRenderCapabilities_API_CppToPython_Qt3DRender_QRenderCapabilities_API);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QRenderCapabilities_API_PythonToCpp_Qt3DRender_QRenderCapabilities_API,
            is_Qt3DRender_QRenderCapabilities_API_PythonToCpp_Qt3DRender_QRenderCapabilities_API_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_API_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QRenderCapabilities::API");
        Shiboken::Conversions::registerConverterName(converter, "QRenderCapabilities::API");
        Shiboken::Conversions::registerConverterName(converter, "API");
    }
    // End of 'API' enum.

    // Initialization of enum 'Profile'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QRenderCapabilities_TypeF(),
        "Profile",
        "2:PySide2.Qt3DRender.Qt3DRender.QRenderCapabilities.Profile",
        "Qt3DRender::QRenderCapabilities::Profile");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX],
        Sbk_Qt3DRender_QRenderCapabilities_TypeF(), "NoProfile", (long) Qt3DRender::QRenderCapabilities::Profile::NoProfile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX],
        Sbk_Qt3DRender_QRenderCapabilities_TypeF(), "CoreProfile", (long) Qt3DRender::QRenderCapabilities::Profile::CoreProfile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX],
        Sbk_Qt3DRender_QRenderCapabilities_TypeF(), "CompatibilityProfile", (long) Qt3DRender::QRenderCapabilities::Profile::CompatibilityProfile))
        return;
    // Register converter for enum 'Qt3DRender::QRenderCapabilities::Profile'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX],
            Qt3DRender_QRenderCapabilities_Profile_CppToPython_Qt3DRender_QRenderCapabilities_Profile);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QRenderCapabilities_Profile_PythonToCpp_Qt3DRender_QRenderCapabilities_Profile,
            is_Qt3DRender_QRenderCapabilities_Profile_PythonToCpp_Qt3DRender_QRenderCapabilities_Profile_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERCAPABILITIES_PROFILE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QRenderCapabilities::Profile");
        Shiboken::Conversions::registerConverterName(converter, "QRenderCapabilities::Profile");
        Shiboken::Conversions::registerConverterName(converter, "Profile");
    }
    // End of 'Profile' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QRenderCapabilities_TypeF(), &::Qt3DRender::QRenderCapabilities::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QRenderCapabilities::API >("QRenderCapabilities::API");
    qRegisterMetaType< ::Qt3DRender::QRenderCapabilities::API >("Qt3DRender::QRenderCapabilities::API");
    qRegisterMetaType< ::Qt3DRender::QRenderCapabilities::Profile >("QRenderCapabilities::Profile");
    qRegisterMetaType< ::Qt3DRender::QRenderCapabilities::Profile >("Qt3DRender::QRenderCapabilities::Profile");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QRenderCapabilities_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QRenderCapabilities_TypeF(), &::Qt3DRender::QRenderCapabilities::staticMetaObject, sizeof(QRenderCapabilitiesWrapper));
}
