/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qlevelofdetailboundingsphere_wrapper.h"

// inner classes

// Extra includes
#include <Qt3DRender/qlevelofdetailboundingsphere.h>
#include <QtGui/qvector3d.h>
#include <qobject.h>


#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QLevelOfDetailBoundingSphere >()))
        return -1;

    ::Qt3DRender::QLevelOfDetailBoundingSphere *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QLevelOfDetailBoundingSphere", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QLevelOfDetailBoundingSphere::QLevelOfDetailBoundingSphere(QVector3D,float)
    // 1: QLevelOfDetailBoundingSphere::QLevelOfDetailBoundingSphere(Qt3DRender::QLevelOfDetailBoundingSphere)
    if (numArgs == 0) {
        overloadId = 0; // QLevelOfDetailBoundingSphere(QVector3D,float)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLEVELOFDETAILBOUNDINGSPHERE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QLevelOfDetailBoundingSphere(Qt3DRender::QLevelOfDetailBoundingSphere)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QLevelOfDetailBoundingSphere(QVector3D,float)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
            overloadId = 0; // QLevelOfDetailBoundingSphere(QVector3D,float)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QLevelOfDetailBoundingSphere(QVector3D center, float radius)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_center = Shiboken::String::createStaticString("center");
                if (PyDict_Contains(kwds, key_center)) {
                    value = PyDict_GetItem(kwds, key_center);
                    if (value && pyArgs[0]) {
                        errInfo = key_center;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[0]))))
                            goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_center);
                }
                static PyObject *const key_radius = Shiboken::String::createStaticString("radius");
                if (PyDict_Contains(kwds, key_radius)) {
                    value = PyDict_GetItem(kwds, key_radius);
                    if (value && pyArgs[1]) {
                        errInfo = key_radius;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1]))))
                            goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_radius);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVector3D cppArg0 = QVector3D();
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1 = 1.0f;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QLevelOfDetailBoundingSphere(QVector3D,float)
                cptr = new ::Qt3DRender::QLevelOfDetailBoundingSphere(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // QLevelOfDetailBoundingSphere(const Qt3DRender::QLevelOfDetailBoundingSphere & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DRender::QLevelOfDetailBoundingSphere *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QLevelOfDetailBoundingSphere(Qt3DRender::QLevelOfDetailBoundingSphere)
                cptr = new ::Qt3DRender::QLevelOfDetailBoundingSphere(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QLevelOfDetailBoundingSphere >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QLevelOfDetailBoundingSphereFunc_center(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QLevelOfDetailBoundingSphere *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLEVELOFDETAILBOUNDINGSPHERE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere.center";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // center()const
            QVector3D cppResult = const_cast<const ::Qt3DRender::QLevelOfDetailBoundingSphere *>(cppSelf)->center();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QLevelOfDetailBoundingSphereFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QLevelOfDetailBoundingSphere *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLEVELOFDETAILBOUNDINGSPHERE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::Qt3DRender::QLevelOfDetailBoundingSphere *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QLevelOfDetailBoundingSphereFunc_radius(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QLevelOfDetailBoundingSphere *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLEVELOFDETAILBOUNDINGSPHERE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere.radius";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // radius()const
            float cppResult = const_cast<const ::Qt3DRender::QLevelOfDetailBoundingSphere *>(cppSelf)->radius();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_PropertyStrings[] = {
    "center:",
    "radius:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_methods[] = {
    {"center", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphereFunc_center), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphereFunc_isEmpty), METH_NOARGS},
    {"radius", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphereFunc_radius), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::Qt3DRender::QLevelOfDetailBoundingSphere *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLEVELOFDETAILBOUNDINGSPHERE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLEVELOFDETAILBOUNDINGSPHERE_IDX]), (pyArg)))) {
                // operator!=(const Qt3DRender::QLevelOfDetailBoundingSphere & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::Qt3DRender::QLevelOfDetailBoundingSphere *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLEVELOFDETAILBOUNDINGSPHERE_IDX]), (pyArg)))) {
                // operator==(const Qt3DRender::QLevelOfDetailBoundingSphere & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::Qt3DRender::QLevelOfDetailBoundingSphere *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_TypeF(void)
{
    return _Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Type;
}

static PyType_Slot Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QLevelOfDetailBoundingSphere_PythonToCpp_QLevelOfDetailBoundingSphere_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QLevelOfDetailBoundingSphere_PythonToCpp_QLevelOfDetailBoundingSphere_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_TypeF())))
        return QLevelOfDetailBoundingSphere_PythonToCpp_QLevelOfDetailBoundingSphere_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QLevelOfDetailBoundingSphere_PTR_CppToPython_QLevelOfDetailBoundingSphere(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DRender::QLevelOfDetailBoundingSphere *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QLevelOfDetailBoundingSphere_SignatureStrings[] = {
    "1:PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere(self,center:PySide2.QtGui.QVector3D=QVector3D(),radius:float=1.0f)",
    "0:PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere(self,other:PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere)",
    "PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere.center(self)->PySide2.QtGui.QVector3D",
    "PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere.isEmpty(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere.radius(self)->float",
    nullptr}; // Sentinel

void init_Qt3DRender_QLevelOfDetailBoundingSphere(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QLevelOfDetailBoundingSphere",
        "Qt3DRender::QLevelOfDetailBoundingSphere*",
        &Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QLevelOfDetailBoundingSphere >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Type);
    InitSignatureStrings(pyType, Qt3DRender_QLevelOfDetailBoundingSphere_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_Type), Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLEVELOFDETAILBOUNDINGSPHERE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QLevelOfDetailBoundingSphere_TypeF(),
        QLevelOfDetailBoundingSphere_PythonToCpp_QLevelOfDetailBoundingSphere_PTR,
        is_QLevelOfDetailBoundingSphere_PythonToCpp_QLevelOfDetailBoundingSphere_PTR_Convertible,
        QLevelOfDetailBoundingSphere_PTR_CppToPython_QLevelOfDetailBoundingSphere);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QLevelOfDetailBoundingSphere");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QLevelOfDetailBoundingSphere*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QLevelOfDetailBoundingSphere&");
    Shiboken::Conversions::registerConverterName(converter, "QLevelOfDetailBoundingSphere");
    Shiboken::Conversions::registerConverterName(converter, "QLevelOfDetailBoundingSphere*");
    Shiboken::Conversions::registerConverterName(converter, "QLevelOfDetailBoundingSphere&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QLevelOfDetailBoundingSphere).name());


}
