/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qgraphicsapifilter_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGraphicsApiFilterWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGraphicsApiFilterWrapper::QGraphicsApiFilterWrapper(::QObject * parent) : Qt3DRender::QGraphicsApiFilter(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QGraphicsApiFilterWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsApiFilterWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsApiFilterWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsApiFilterWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGraphicsApiFilterWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsApiFilter.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGraphicsApiFilterWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsApiFilter.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGraphicsApiFilterWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGraphicsApiFilterWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QGraphicsApiFilter::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGraphicsApiFilterWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QGraphicsApiFilter::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGraphicsApiFilterWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGraphicsApiFilterWrapper *>(this));
        return Qt3DRender::QGraphicsApiFilter::qt_metacast(_clname);
}

QGraphicsApiFilterWrapper::~QGraphicsApiFilterWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QGraphicsApiFilter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QGraphicsApiFilter >()))
        return -1;

    ::QGraphicsApiFilterWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QGraphicsApiFilter", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGraphicsApiFilter::QGraphicsApiFilter(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QGraphicsApiFilter(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGraphicsApiFilter(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QGraphicsApiFilter_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QGraphicsApiFilter_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QGraphicsApiFilter_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QGraphicsApiFilter(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QGraphicsApiFilterWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QGraphicsApiFilterWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QGraphicsApiFilter >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QGraphicsApiFilter_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QGraphicsApiFilter_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QGraphicsApiFilter_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_api(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.api";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // api()const
            Qt3DRender::QGraphicsApiFilter::Api cppResult = const_cast<const ::Qt3DRender::QGraphicsApiFilter *>(cppSelf)->api();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_extensions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.extensions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // extensions()const
            QStringList cppResult = const_cast<const ::Qt3DRender::QGraphicsApiFilter *>(cppSelf)->extensions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_majorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.majorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // majorVersion()const
            int cppResult = const_cast<const ::Qt3DRender::QGraphicsApiFilter *>(cppSelf)->majorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_minorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.minorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minorVersion()const
            int cppResult = const_cast<const ::Qt3DRender::QGraphicsApiFilter *>(cppSelf)->minorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_profile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.profile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // profile()const
            Qt3DRender::QGraphicsApiFilter::OpenGLProfile cppResult = const_cast<const ::Qt3DRender::QGraphicsApiFilter *>(cppSelf)->profile();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_setApi(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setApi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsApiFilter::setApi(Qt3DRender::QGraphicsApiFilter::Api)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setApi(Qt3DRender::QGraphicsApiFilter::Api)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QGraphicsApiFilterFunc_setApi_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QGraphicsApiFilter::Api cppArg0 = static_cast< ::Qt3DRender::QGraphicsApiFilter::Api>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setApi(Qt3DRender::QGraphicsApiFilter::Api)
            cppSelf->setApi(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QGraphicsApiFilterFunc_setApi_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_setExtensions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setExtensions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsApiFilter::setExtensions(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setExtensions(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QGraphicsApiFilterFunc_setExtensions_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExtensions(QStringList)
            cppSelf->setExtensions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QGraphicsApiFilterFunc_setExtensions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_setMajorVersion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setMajorVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsApiFilter::setMajorVersion(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMajorVersion(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QGraphicsApiFilterFunc_setMajorVersion_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMajorVersion(int)
            cppSelf->setMajorVersion(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QGraphicsApiFilterFunc_setMajorVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_setMinorVersion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setMinorVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsApiFilter::setMinorVersion(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMinorVersion(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QGraphicsApiFilterFunc_setMinorVersion_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinorVersion(int)
            cppSelf->setMinorVersion(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QGraphicsApiFilterFunc_setMinorVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_setProfile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setProfile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsApiFilter::setProfile(Qt3DRender::QGraphicsApiFilter::OpenGLProfile)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setProfile(Qt3DRender::QGraphicsApiFilter::OpenGLProfile)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QGraphicsApiFilterFunc_setProfile_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QGraphicsApiFilter::OpenGLProfile cppArg0{Qt3DRender::QGraphicsApiFilter::NoProfile};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProfile(Qt3DRender::QGraphicsApiFilter::OpenGLProfile)
            cppSelf->setProfile(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QGraphicsApiFilterFunc_setProfile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_setVendor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setVendor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsApiFilter::setVendor(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setVendor(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QGraphicsApiFilterFunc_setVendor_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVendor(QString)
            cppSelf->setVendor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QGraphicsApiFilterFunc_setVendor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QGraphicsApiFilterFunc_vendor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.vendor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vendor()const
            QString cppResult = const_cast<const ::Qt3DRender::QGraphicsApiFilter *>(cppSelf)->vendor();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QGraphicsApiFilter_PropertyStrings[] = {
    "api::",
    "extensions::",
    "majorVersion::",
    "minorVersion::",
    "profile::",
    "vendor::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QGraphicsApiFilter_methods[] = {
    {"api", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_api), METH_NOARGS},
    {"extensions", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_extensions), METH_NOARGS},
    {"majorVersion", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_majorVersion), METH_NOARGS},
    {"minorVersion", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_minorVersion), METH_NOARGS},
    {"profile", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_profile), METH_NOARGS},
    {"setApi", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_setApi), METH_O},
    {"setExtensions", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_setExtensions), METH_O},
    {"setMajorVersion", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_setMajorVersion), METH_O},
    {"setMinorVersion", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_setMinorVersion), METH_O},
    {"setProfile", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_setProfile), METH_O},
    {"setVendor", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_setVendor), METH_O},
    {"vendor", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QGraphicsApiFilterFunc_vendor), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QGraphicsApiFilter_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QGraphicsApiFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGraphicsApiFilterWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QGraphicsApiFilter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QGraphicsApiFilter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QGraphicsApiFilter_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(void)
{
    return _Sbk_Qt3DRender_QGraphicsApiFilter_Type;
}

static PyType_Slot Sbk_Qt3DRender_QGraphicsApiFilter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QGraphicsApiFilter_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QGraphicsApiFilter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QGraphicsApiFilter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QGraphicsApiFilter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QGraphicsApiFilter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QGraphicsApiFilter_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QGraphicsApiFilter_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QGraphicsApiFilter_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QGraphicsApiFilter *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QGraphicsApiFilter_Api_PythonToCpp_Qt3DRender_QGraphicsApiFilter_Api(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QGraphicsApiFilter::Api *>(cppOut) =
        static_cast<::Qt3DRender::QGraphicsApiFilter::Api>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QGraphicsApiFilter_Api_PythonToCpp_Qt3DRender_QGraphicsApiFilter_Api_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX]))
        return Qt3DRender_QGraphicsApiFilter_Api_PythonToCpp_Qt3DRender_QGraphicsApiFilter_Api;
    return {};
}
static PyObject *Qt3DRender_QGraphicsApiFilter_Api_CppToPython_Qt3DRender_QGraphicsApiFilter_Api(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QGraphicsApiFilter::Api *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX], castCppIn);

}

static void Qt3DRender_QGraphicsApiFilter_OpenGLProfile_PythonToCpp_Qt3DRender_QGraphicsApiFilter_OpenGLProfile(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QGraphicsApiFilter::OpenGLProfile *>(cppOut) =
        static_cast<::Qt3DRender::QGraphicsApiFilter::OpenGLProfile>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QGraphicsApiFilter_OpenGLProfile_PythonToCpp_Qt3DRender_QGraphicsApiFilter_OpenGLProfile_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX]))
        return Qt3DRender_QGraphicsApiFilter_OpenGLProfile_PythonToCpp_Qt3DRender_QGraphicsApiFilter_OpenGLProfile;
    return {};
}
static PyObject *Qt3DRender_QGraphicsApiFilter_OpenGLProfile_CppToPython_Qt3DRender_QGraphicsApiFilter_OpenGLProfile(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QGraphicsApiFilter::OpenGLProfile *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGraphicsApiFilter_PythonToCpp_QGraphicsApiFilter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGraphicsApiFilter_PythonToCpp_QGraphicsApiFilter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF())))
        return QGraphicsApiFilter_PythonToCpp_QGraphicsApiFilter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGraphicsApiFilter_PTR_CppToPython_QGraphicsApiFilter(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QGraphicsApiFilter *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QGraphicsApiFilter_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QGraphicsApiFilter_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.api(self)->PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.Api",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.extensions(self)->QStringList",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.majorVersion(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.minorVersion(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.profile(self)->PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.OpenGLProfile",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setApi(self,api:PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.Api)",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setExtensions(self,extensions:QStringList)",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setMajorVersion(self,majorVersion:int)",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setMinorVersion(self,minorVersion:int)",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setProfile(self,profile:PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.OpenGLProfile)",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.setVendor(self,vendor:QString)",
    "PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.vendor(self)->QString",
    nullptr}; // Sentinel

void init_Qt3DRender_QGraphicsApiFilter(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QGraphicsApiFilter_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QGraphicsApiFilter",
        "Qt3DRender::QGraphicsApiFilter*",
        &Sbk_Qt3DRender_QGraphicsApiFilter_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QGraphicsApiFilter >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QGraphicsApiFilter_Type);
    InitSignatureStrings(pyType, Qt3DRender_QGraphicsApiFilter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QGraphicsApiFilter_Type), Sbk_Qt3DRender_QGraphicsApiFilter_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(),
        QGraphicsApiFilter_PythonToCpp_QGraphicsApiFilter_PTR,
        is_QGraphicsApiFilter_PythonToCpp_QGraphicsApiFilter_PTR_Convertible,
        QGraphicsApiFilter_PTR_CppToPython_QGraphicsApiFilter);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QGraphicsApiFilter");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QGraphicsApiFilter*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QGraphicsApiFilter&");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsApiFilter");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsApiFilter*");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsApiFilter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QGraphicsApiFilter).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsApiFilterWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), &Sbk_Qt3DRender_QGraphicsApiFilter_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Api'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(),
        "Api",
        "2:PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.Api",
        "Qt3DRender::QGraphicsApiFilter::Api");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX],
        Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), "OpenGLES", (long) Qt3DRender::QGraphicsApiFilter::Api::OpenGLES))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX],
        Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), "OpenGL", (long) Qt3DRender::QGraphicsApiFilter::Api::OpenGL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX],
        Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), "Vulkan", (long) Qt3DRender::QGraphicsApiFilter::Api::Vulkan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX],
        Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), "DirectX", (long) Qt3DRender::QGraphicsApiFilter::Api::DirectX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX],
        Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), "RHI", (long) Qt3DRender::QGraphicsApiFilter::Api::RHI))
        return;
    // Register converter for enum 'Qt3DRender::QGraphicsApiFilter::Api'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX],
            Qt3DRender_QGraphicsApiFilter_Api_CppToPython_Qt3DRender_QGraphicsApiFilter_Api);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QGraphicsApiFilter_Api_PythonToCpp_Qt3DRender_QGraphicsApiFilter_Api,
            is_Qt3DRender_QGraphicsApiFilter_Api_PythonToCpp_Qt3DRender_QGraphicsApiFilter_Api_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_API_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QGraphicsApiFilter::Api");
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsApiFilter::Api");
        Shiboken::Conversions::registerConverterName(converter, "Api");
    }
    // End of 'Api' enum.

    // Initialization of enum 'OpenGLProfile'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(),
        "OpenGLProfile",
        "2:PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.OpenGLProfile",
        "Qt3DRender::QGraphicsApiFilter::OpenGLProfile");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX],
        Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), "NoProfile", (long) Qt3DRender::QGraphicsApiFilter::OpenGLProfile::NoProfile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX],
        Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), "CoreProfile", (long) Qt3DRender::QGraphicsApiFilter::OpenGLProfile::CoreProfile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX],
        Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), "CompatibilityProfile", (long) Qt3DRender::QGraphicsApiFilter::OpenGLProfile::CompatibilityProfile))
        return;
    // Register converter for enum 'Qt3DRender::QGraphicsApiFilter::OpenGLProfile'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX],
            Qt3DRender_QGraphicsApiFilter_OpenGLProfile_CppToPython_Qt3DRender_QGraphicsApiFilter_OpenGLProfile);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QGraphicsApiFilter_OpenGLProfile_PythonToCpp_Qt3DRender_QGraphicsApiFilter_OpenGLProfile,
            is_Qt3DRender_QGraphicsApiFilter_OpenGLProfile_PythonToCpp_Qt3DRender_QGraphicsApiFilter_OpenGLProfile_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGRAPHICSAPIFILTER_OPENGLPROFILE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QGraphicsApiFilter::OpenGLProfile");
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsApiFilter::OpenGLProfile");
        Shiboken::Conversions::registerConverterName(converter, "OpenGLProfile");
    }
    // End of 'OpenGLProfile' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), &::Qt3DRender::QGraphicsApiFilter::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QGraphicsApiFilter::Api >("QGraphicsApiFilter::Api");
    qRegisterMetaType< ::Qt3DRender::QGraphicsApiFilter::Api >("Qt3DRender::QGraphicsApiFilter::Api");
    qRegisterMetaType< ::Qt3DRender::QGraphicsApiFilter::OpenGLProfile >("QGraphicsApiFilter::OpenGLProfile");
    qRegisterMetaType< ::Qt3DRender::QGraphicsApiFilter::OpenGLProfile >("Qt3DRender::QGraphicsApiFilter::OpenGLProfile");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QGraphicsApiFilter_TypeF(), &::Qt3DRender::QGraphicsApiFilter::staticMetaObject, sizeof(QGraphicsApiFilterWrapper));
}
