/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qclearbuffers_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QClearBuffersWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QClearBuffersWrapper::QClearBuffersWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QClearBuffers(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QClearBuffersWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QClearBuffersWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QClearBuffersWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QClearBuffersWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QClearBuffersWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QClearBuffers.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QClearBuffersWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QClearBuffers.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QClearBuffersWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QClearBuffersWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QClearBuffers::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QClearBuffersWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QClearBuffers::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QClearBuffersWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QClearBuffersWrapper *>(this));
        return Qt3DRender::QClearBuffers::qt_metacast(_clname);
}

QClearBuffersWrapper::~QClearBuffersWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QClearBuffers_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QClearBuffers >()))
        return -1;

    ::QClearBuffersWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QClearBuffers", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QClearBuffers::QClearBuffers(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QClearBuffers(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QClearBuffers(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QClearBuffers_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QClearBuffers_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QClearBuffers_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QClearBuffers(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QClearBuffersWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QClearBuffersWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QClearBuffers >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QClearBuffers_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QClearBuffers_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QClearBuffers_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_buffers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.buffers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buffers()const
            Qt3DRender::QClearBuffers::BufferType cppResult = const_cast<const ::Qt3DRender::QClearBuffers *>(cppSelf)->buffers();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_clearColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.clearColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearColor()const
            QColor cppResult = const_cast<const ::Qt3DRender::QClearBuffers *>(cppSelf)->clearColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_clearDepthValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.clearDepthValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearDepthValue()const
            float cppResult = const_cast<const ::Qt3DRender::QClearBuffers *>(cppSelf)->clearDepthValue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_clearStencilValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.clearStencilValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearStencilValue()const
            int cppResult = const_cast<const ::Qt3DRender::QClearBuffers *>(cppSelf)->clearStencilValue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_colorBuffer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.colorBuffer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorBuffer()const
            Qt3DRender::QRenderTargetOutput * cppResult = const_cast<const ::Qt3DRender::QClearBuffers *>(cppSelf)->colorBuffer();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_setBuffers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QClearBuffers::setBuffers(Qt3DRender::QClearBuffers::BufferType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBuffers(Qt3DRender::QClearBuffers::BufferType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QClearBuffersFunc_setBuffers_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QClearBuffers::BufferType cppArg0{Qt3DRender::QClearBuffers::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBuffers(Qt3DRender::QClearBuffers::BufferType)
            cppSelf->setBuffers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QClearBuffersFunc_setBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_setClearColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setClearColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QClearBuffers::setClearColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setClearColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QClearBuffersFunc_setClearColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setClearColor(QColor)
            cppSelf->setClearColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QClearBuffersFunc_setClearColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_setClearDepthValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setClearDepthValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QClearBuffers::setClearDepthValue(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setClearDepthValue(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QClearBuffersFunc_setClearDepthValue_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setClearDepthValue(float)
            cppSelf->setClearDepthValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QClearBuffersFunc_setClearDepthValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_setClearStencilValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setClearStencilValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QClearBuffers::setClearStencilValue(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setClearStencilValue(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QClearBuffersFunc_setClearStencilValue_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setClearStencilValue(int)
            cppSelf->setClearStencilValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QClearBuffersFunc_setClearStencilValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QClearBuffersFunc_setColorBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setColorBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QClearBuffers::setColorBuffer(Qt3DRender::QRenderTargetOutput*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_IDX]), (pyArg)))) {
        overloadId = 0; // setColorBuffer(Qt3DRender::QRenderTargetOutput*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QClearBuffersFunc_setColorBuffer_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QRenderTargetOutput *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorBuffer(Qt3DRender::QRenderTargetOutput*)
            cppSelf->setColorBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QClearBuffersFunc_setColorBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_Qt3DRender_QClearBuffers_PropertyStrings[] = {
    "buffers::",
    "clearColor::",
    "clearDepthValue::",
    "clearStencilValue::",
    "colorBuffer::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QClearBuffers_methods[] = {
    {"buffers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_buffers), METH_NOARGS},
    {"clearColor", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_clearColor), METH_NOARGS},
    {"clearDepthValue", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_clearDepthValue), METH_NOARGS},
    {"clearStencilValue", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_clearStencilValue), METH_NOARGS},
    {"colorBuffer", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_colorBuffer), METH_NOARGS},
    {"setBuffers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_setBuffers), METH_O},
    {"setClearColor", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_setClearColor), METH_O},
    {"setClearDepthValue", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_setClearDepthValue), METH_O},
    {"setClearStencilValue", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_setClearStencilValue), METH_O},
    {"setColorBuffer", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QClearBuffersFunc_setColorBuffer), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QClearBuffers_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QClearBuffers *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QClearBuffersWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QClearBuffers_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QClearBuffers_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QClearBuffers_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QClearBuffers_TypeF(void)
{
    return _Sbk_Qt3DRender_QClearBuffers_Type;
}

static PyType_Slot Sbk_Qt3DRender_QClearBuffers_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QClearBuffers_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QClearBuffers_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QClearBuffers_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QClearBuffers_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QClearBuffers_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QClearBuffers_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QClearBuffers",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QClearBuffers_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QClearBuffers_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QClearBuffers *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DRender::QClearBuffers::BufferTypeFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DRender::QClearBuffers::BufferTypeFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DRender::QClearBuffers::BufferTypeFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QClearBuffers::BufferTypeFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DRender::QClearBuffers::BufferTypeFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, self, &cppSelf);
    ::Qt3DRender::QClearBuffers::BufferTypeFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QClearBuffers_BufferType_PythonToCpp_Qt3DRender_QClearBuffers_BufferType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QClearBuffers::BufferType *>(cppOut) =
        static_cast<::Qt3DRender::QClearBuffers::BufferType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QClearBuffers_BufferType_PythonToCpp_Qt3DRender_QClearBuffers_BufferType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX]))
        return Qt3DRender_QClearBuffers_BufferType_PythonToCpp_Qt3DRender_QClearBuffers_BufferType;
    return {};
}
static PyObject *Qt3DRender_QClearBuffers_BufferType_CppToPython_Qt3DRender_QClearBuffers_BufferType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QClearBuffers::BufferType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX], castCppIn);

}

static void QFlags_Qt3DRender_QClearBuffers_BufferType__PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt3DRender::QClearBuffers::BufferType> *>(cppOut) =
        ::QFlags<Qt3DRender::QClearBuffers::BufferType>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt3DRender_QClearBuffers_BufferType__PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX]))
        return QFlags_Qt3DRender_QClearBuffers_BufferType__PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType_;
    return {};
}
static PyObject *QFlags_Qt3DRender_QClearBuffers_BufferType__CppToPython_QFlags_Qt3DRender_QClearBuffers_BufferType_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt3DRender::QClearBuffers::BufferType> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX]));

}

static void Qt3DRender_QClearBuffers_BufferType_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt3DRender::QClearBuffers::BufferType> *>(cppOut) =
        ::QFlags<Qt3DRender::QClearBuffers::BufferType>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt3DRender_QClearBuffers_BufferType_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX]))
        return Qt3DRender_QClearBuffers_BufferType_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt3DRender::QClearBuffers::BufferType> *>(cppOut) =
        ::QFlags<Qt3DRender::QClearBuffers::BufferType>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX]))
        return number_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QClearBuffers_PythonToCpp_QClearBuffers_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QClearBuffers_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QClearBuffers_PythonToCpp_QClearBuffers_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QClearBuffers_TypeF())))
        return QClearBuffers_PythonToCpp_QClearBuffers_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QClearBuffers_PTR_CppToPython_QClearBuffers(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QClearBuffers *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QClearBuffers_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QClearBuffers_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.buffers(self)->PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.clearColor(self)->PySide2.QtGui.QColor",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.clearDepthValue(self)->float",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.clearStencilValue(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.colorBuffer(self)->PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setBuffers(self,buffers:PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType)",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setClearColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setClearDepthValue(self,clearDepthValue:float)",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setClearStencilValue(self,clearStencilValue:int)",
    "PySide2.Qt3DRender.Qt3DRender.QClearBuffers.setColorBuffer(self,buffer:PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput)",
    nullptr}; // Sentinel

void init_Qt3DRender_QClearBuffers(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QClearBuffers_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QClearBuffers",
        "Qt3DRender::QClearBuffers*",
        &Sbk_Qt3DRender_QClearBuffers_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QClearBuffers >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QFRAMEGRAPHNODE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QClearBuffers_Type);
    InitSignatureStrings(pyType, Qt3DRender_QClearBuffers_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QClearBuffers_Type), Sbk_Qt3DRender_QClearBuffers_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QClearBuffers_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QClearBuffers_TypeF(),
        QClearBuffers_PythonToCpp_QClearBuffers_PTR,
        is_QClearBuffers_PythonToCpp_QClearBuffers_PTR_Convertible,
        QClearBuffers_PTR_CppToPython_QClearBuffers);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QClearBuffers");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QClearBuffers*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QClearBuffers&");
    Shiboken::Conversions::registerConverterName(converter, "QClearBuffers");
    Shiboken::Conversions::registerConverterName(converter, "QClearBuffers*");
    Shiboken::Conversions::registerConverterName(converter, "QClearBuffers&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QClearBuffers).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QClearBuffersWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QClearBuffers_TypeF(), &Sbk_Qt3DRender_QClearBuffers_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'BufferType'.
    SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX] = PySide::QFlags::create("2:PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferTypeFlags", SbkPySide2_Qt3DRender_Qt3DRender_QClearBuffers_BufferType_number_slots);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QClearBuffers_TypeF(),
        "BufferType",
        "2:PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType",
        "Qt3DRender::QClearBuffers::BufferType",
        SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX]);
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QClearBuffers_TypeF(), "None_", (long) Qt3DRender::QClearBuffers::BufferType::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QClearBuffers_TypeF(), "ColorBuffer", (long) Qt3DRender::QClearBuffers::BufferType::ColorBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QClearBuffers_TypeF(), "DepthBuffer", (long) Qt3DRender::QClearBuffers::BufferType::DepthBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QClearBuffers_TypeF(), "StencilBuffer", (long) Qt3DRender::QClearBuffers::BufferType::StencilBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QClearBuffers_TypeF(), "DepthStencilBuffer", (long) Qt3DRender::QClearBuffers::BufferType::DepthStencilBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QClearBuffers_TypeF(), "ColorDepthBuffer", (long) Qt3DRender::QClearBuffers::BufferType::ColorDepthBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QClearBuffers_TypeF(), "ColorDepthStencilBuffer", (long) Qt3DRender::QClearBuffers::BufferType::ColorDepthStencilBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QClearBuffers_TypeF(), "AllBuffers", (long) Qt3DRender::QClearBuffers::BufferType::AllBuffers))
        return;
    // Register converter for enum 'Qt3DRender::QClearBuffers::BufferType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
            Qt3DRender_QClearBuffers_BufferType_CppToPython_Qt3DRender_QClearBuffers_BufferType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QClearBuffers_BufferType_PythonToCpp_Qt3DRender_QClearBuffers_BufferType,
            is_Qt3DRender_QClearBuffers_BufferType_PythonToCpp_Qt3DRender_QClearBuffers_BufferType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QClearBuffers::BufferType");
        Shiboken::Conversions::registerConverterName(converter, "QClearBuffers::BufferType");
        Shiboken::Conversions::registerConverterName(converter, "BufferType");
    }
    // Register converter for flag 'QFlags<Qt3DRender::QClearBuffers::BufferType>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX],
            QFlags_Qt3DRender_QClearBuffers_BufferType__CppToPython_QFlags_Qt3DRender_QClearBuffers_BufferType_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QClearBuffers_BufferType_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType_,
            is_Qt3DRender_QClearBuffers_BufferType_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt3DRender_QClearBuffers_BufferType__PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType_,
            is_QFlags_Qt3DRender_QClearBuffers_BufferType__PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType_,
            is_number_PythonToCpp_QFlags_Qt3DRender_QClearBuffers_BufferType__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QClearBuffers::BufferTypeFlags");
        Shiboken::Conversions::registerConverterName(converter, "QClearBuffers::BufferTypeFlags");
        Shiboken::Conversions::registerConverterName(converter, "BufferTypeFlags");
    }
    // End of 'BufferType' enum/flags.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QClearBuffers_TypeF(), &::Qt3DRender::QClearBuffers::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QClearBuffers::BufferType >("QClearBuffers::BufferType");
    qRegisterMetaType< ::Qt3DRender::QClearBuffers::BufferType >("Qt3DRender::QClearBuffers::BufferType");
    qRegisterMetaType< ::Qt3DRender::QClearBuffers::BufferTypeFlags >("Qt3DRender::QClearBuffers::BufferTypeFlags");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QClearBuffers_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QClearBuffers_TypeF(), &::Qt3DRender::QClearBuffers::staticMetaObject, sizeof(QClearBuffersWrapper));
}
