/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qbuffer_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QBufferWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QBufferWrapper::QBufferWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QBuffer(parent)
{
    resetPyMethodCache();
    // ... middle
}

QBufferWrapper::QBufferWrapper(::Qt3DRender::QBuffer::BufferType ty, ::Qt3DCore::QNode * parent) : Qt3DRender::QBuffer(ty, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QBufferWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBufferWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QBufferWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBufferWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QBufferWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBuffer.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QBufferWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBuffer.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QBufferWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QBufferWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QBuffer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QBufferWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QBuffer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QBufferWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QBufferWrapper *>(this));
        return Qt3DRender::QBuffer::qt_metacast(_clname);
}

QBufferWrapper::~QBufferWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QBuffer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QBuffer >()))
        return -1;

    ::QBufferWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QBuffer", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QBuffer::QBuffer(Qt3DCore::QNode*)
    // 1: QBuffer::QBuffer(Qt3DRender::QBuffer::BufferType,Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QBuffer(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QBuffer(Qt3DRender::QBuffer::BufferType,Qt3DCore::QNode*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QBuffer(Qt3DRender::QBuffer::BufferType,Qt3DCore::QNode*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QBuffer(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBuffer_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QBuffer(Qt3DCore::QNode * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QBuffer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                            goto Sbk_Qt3DRender_QBuffer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DCore::QNode *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QBuffer(Qt3DCore::QNode*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QBufferWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QBufferWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QBuffer(Qt3DRender::QBuffer::BufferType ty, Qt3DCore::QNode * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QBuffer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[1]))))
                            goto Sbk_Qt3DRender_QBuffer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::Qt3DRender::QBuffer::BufferType cppArg0 = static_cast< ::Qt3DRender::QBuffer::BufferType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::Qt3DCore::QNode *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QBuffer(Qt3DRender::QBuffer::BufferType,Qt3DCore::QNode*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QBufferWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QBufferWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QBuffer.QBuffer(Qt3DRender::QBuffer::BufferType ty, Qt3DCore::QNode * parent) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QBuffer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QBuffer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QBuffer_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QBuffer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_accessType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.accessType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // accessType()const
            Qt3DRender::QBuffer::AccessType cppResult = const_cast<const ::Qt3DRender::QBuffer *>(cppSelf)->accessType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            QByteArray cppResult = const_cast<const ::Qt3DRender::QBuffer *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_isSyncData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.isSyncData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSyncData()const
            bool cppResult = const_cast<const ::Qt3DRender::QBuffer *>(cppSelf)->isSyncData();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_setAccessType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.setAccessType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBuffer::setAccessType(Qt3DRender::QBuffer::AccessType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAccessType(Qt3DRender::QBuffer::AccessType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBufferFunc_setAccessType_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBuffer::AccessType cppArg0 = static_cast< ::Qt3DRender::QBuffer::AccessType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAccessType(Qt3DRender::QBuffer::AccessType)
            cppSelf->setAccessType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBufferFunc_setAccessType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_setData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBuffer::setData(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setData(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBufferFunc_setData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setData(QByteArray)
            cppSelf->setData(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBufferFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_setSyncData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.setSyncData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBuffer::setSyncData(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSyncData(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBufferFunc_setSyncData_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSyncData(bool)
            cppSelf->setSyncData(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBufferFunc_setSyncData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_setType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.setType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBuffer::setType(Qt3DRender::QBuffer::BufferType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setType(Qt3DRender::QBuffer::BufferType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBufferFunc_setType_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBuffer::BufferType cppArg0 = static_cast< ::Qt3DRender::QBuffer::BufferType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setType(Qt3DRender::QBuffer::BufferType)
            cppSelf->setType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBufferFunc_setType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_setUsage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.setUsage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBuffer::setUsage(Qt3DRender::QBuffer::UsageType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setUsage(Qt3DRender::QBuffer::UsageType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBufferFunc_setUsage_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBuffer::UsageType cppArg0 = static_cast< ::Qt3DRender::QBuffer::UsageType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUsage(Qt3DRender::QBuffer::UsageType)
            cppSelf->setUsage(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBufferFunc_setUsage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            Qt3DRender::QBuffer::BufferType cppResult = const_cast<const ::Qt3DRender::QBuffer *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_updateData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.updateData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBuffer::updateData(int,QByteArray)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // updateData(int,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBufferFunc_updateData_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // updateData(int,QByteArray)
            cppSelf->updateData(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBufferFunc_updateData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBufferFunc_usage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBuffer.usage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // usage()const
            Qt3DRender::QBuffer::UsageType cppResult = const_cast<const ::Qt3DRender::QBuffer *>(cppSelf)->usage();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QBuffer_PropertyStrings[] = {
    "accessType::",
    "syncData:isSyncData:",
    "type::",
    "usage::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QBuffer_methods[] = {
    {"accessType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_accessType), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_data), METH_NOARGS},
    {"isSyncData", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_isSyncData), METH_NOARGS},
    {"setAccessType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_setAccessType), METH_O},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_setData), METH_O},
    {"setSyncData", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_setSyncData), METH_O},
    {"setType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_setType), METH_O},
    {"setUsage", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_setUsage), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_type), METH_NOARGS},
    {"updateData", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_updateData), METH_VARARGS},
    {"usage", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBufferFunc_usage), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QBuffer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QBufferWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QBuffer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QBuffer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QBuffer_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QBuffer_TypeF(void)
{
    return _Sbk_Qt3DRender_QBuffer_Type;
}

static PyType_Slot Sbk_Qt3DRender_QBuffer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QBuffer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QBuffer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QBuffer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QBuffer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QBuffer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QBuffer_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QBuffer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QBuffer_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QBuffer_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QBuffer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QBuffer_BufferType_PythonToCpp_Qt3DRender_QBuffer_BufferType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QBuffer::BufferType *>(cppOut) =
        static_cast<::Qt3DRender::QBuffer::BufferType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QBuffer_BufferType_PythonToCpp_Qt3DRender_QBuffer_BufferType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX]))
        return Qt3DRender_QBuffer_BufferType_PythonToCpp_Qt3DRender_QBuffer_BufferType;
    return {};
}
static PyObject *Qt3DRender_QBuffer_BufferType_CppToPython_Qt3DRender_QBuffer_BufferType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QBuffer::BufferType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX], castCppIn);

}

static void Qt3DRender_QBuffer_UsageType_PythonToCpp_Qt3DRender_QBuffer_UsageType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QBuffer::UsageType *>(cppOut) =
        static_cast<::Qt3DRender::QBuffer::UsageType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QBuffer_UsageType_PythonToCpp_Qt3DRender_QBuffer_UsageType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX]))
        return Qt3DRender_QBuffer_UsageType_PythonToCpp_Qt3DRender_QBuffer_UsageType;
    return {};
}
static PyObject *Qt3DRender_QBuffer_UsageType_CppToPython_Qt3DRender_QBuffer_UsageType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QBuffer::UsageType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX], castCppIn);

}

static void Qt3DRender_QBuffer_AccessType_PythonToCpp_Qt3DRender_QBuffer_AccessType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QBuffer::AccessType *>(cppOut) =
        static_cast<::Qt3DRender::QBuffer::AccessType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QBuffer_AccessType_PythonToCpp_Qt3DRender_QBuffer_AccessType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX]))
        return Qt3DRender_QBuffer_AccessType_PythonToCpp_Qt3DRender_QBuffer_AccessType;
    return {};
}
static PyObject *Qt3DRender_QBuffer_AccessType_CppToPython_Qt3DRender_QBuffer_AccessType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QBuffer::AccessType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBuffer_PythonToCpp_QBuffer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QBuffer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBuffer_PythonToCpp_QBuffer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QBuffer_TypeF())))
        return QBuffer_PythonToCpp_QBuffer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBuffer_PTR_CppToPython_QBuffer(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QBuffer *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QBuffer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QBuffer_SignatureStrings[] = {
    "1:PySide2.Qt3DRender.Qt3DRender.QBuffer(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "0:PySide2.Qt3DRender.Qt3DRender.QBuffer(self,ty:PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.accessType(self)->PySide2.Qt3DRender.Qt3DRender.QBuffer.AccessType",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.data(self)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.isSyncData(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.setAccessType(self,access:PySide2.Qt3DRender.Qt3DRender.QBuffer.AccessType)",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.setData(self,bytes:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.setSyncData(self,syncData:bool)",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.setType(self,type:PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType)",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.setUsage(self,usage:PySide2.Qt3DRender.Qt3DRender.QBuffer.UsageType)",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.type(self)->PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.updateData(self,offset:int,bytes:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DRender.Qt3DRender.QBuffer.usage(self)->PySide2.Qt3DRender.Qt3DRender.QBuffer.UsageType",
    nullptr}; // Sentinel

void init_Qt3DRender_QBuffer(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QBuffer_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QBuffer",
        "Qt3DRender::QBuffer*",
        &Sbk_Qt3DRender_QBuffer_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QBuffer >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QBuffer_Type);
    InitSignatureStrings(pyType, Qt3DRender_QBuffer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QBuffer_Type), Sbk_Qt3DRender_QBuffer_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QBuffer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QBuffer_TypeF(),
        QBuffer_PythonToCpp_QBuffer_PTR,
        is_QBuffer_PythonToCpp_QBuffer_PTR_Convertible,
        QBuffer_PTR_CppToPython_QBuffer);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBuffer");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBuffer*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBuffer&");
    Shiboken::Conversions::registerConverterName(converter, "QBuffer");
    Shiboken::Conversions::registerConverterName(converter, "QBuffer*");
    Shiboken::Conversions::registerConverterName(converter, "QBuffer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QBuffer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBufferWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QBuffer_TypeF(), &Sbk_Qt3DRender_QBuffer_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'BufferType'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QBuffer_TypeF(),
        "BufferType",
        "2:PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType",
        "Qt3DRender::QBuffer::BufferType");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "VertexBuffer", (long) Qt3DRender::QBuffer::BufferType::VertexBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "IndexBuffer", (long) Qt3DRender::QBuffer::BufferType::IndexBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "PixelPackBuffer", (long) Qt3DRender::QBuffer::BufferType::PixelPackBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "PixelUnpackBuffer", (long) Qt3DRender::QBuffer::BufferType::PixelUnpackBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "UniformBuffer", (long) Qt3DRender::QBuffer::BufferType::UniformBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "ShaderStorageBuffer", (long) Qt3DRender::QBuffer::BufferType::ShaderStorageBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "DrawIndirectBuffer", (long) Qt3DRender::QBuffer::BufferType::DrawIndirectBuffer))
        return;
    // Register converter for enum 'Qt3DRender::QBuffer::BufferType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX],
            Qt3DRender_QBuffer_BufferType_CppToPython_Qt3DRender_QBuffer_BufferType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QBuffer_BufferType_PythonToCpp_Qt3DRender_QBuffer_BufferType,
            is_Qt3DRender_QBuffer_BufferType_PythonToCpp_Qt3DRender_QBuffer_BufferType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_BUFFERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBuffer::BufferType");
        Shiboken::Conversions::registerConverterName(converter, "QBuffer::BufferType");
        Shiboken::Conversions::registerConverterName(converter, "BufferType");
    }
    // End of 'BufferType' enum.

    // Initialization of enum 'UsageType'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QBuffer_TypeF(),
        "UsageType",
        "2:PySide2.Qt3DRender.Qt3DRender.QBuffer.UsageType",
        "Qt3DRender::QBuffer::UsageType");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "StreamDraw", (long) Qt3DRender::QBuffer::UsageType::StreamDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "StreamRead", (long) Qt3DRender::QBuffer::UsageType::StreamRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "StreamCopy", (long) Qt3DRender::QBuffer::UsageType::StreamCopy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "StaticDraw", (long) Qt3DRender::QBuffer::UsageType::StaticDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "StaticRead", (long) Qt3DRender::QBuffer::UsageType::StaticRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "StaticCopy", (long) Qt3DRender::QBuffer::UsageType::StaticCopy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "DynamicDraw", (long) Qt3DRender::QBuffer::UsageType::DynamicDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "DynamicRead", (long) Qt3DRender::QBuffer::UsageType::DynamicRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "DynamicCopy", (long) Qt3DRender::QBuffer::UsageType::DynamicCopy))
        return;
    // Register converter for enum 'Qt3DRender::QBuffer::UsageType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX],
            Qt3DRender_QBuffer_UsageType_CppToPython_Qt3DRender_QBuffer_UsageType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QBuffer_UsageType_PythonToCpp_Qt3DRender_QBuffer_UsageType,
            is_Qt3DRender_QBuffer_UsageType_PythonToCpp_Qt3DRender_QBuffer_UsageType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_USAGETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBuffer::UsageType");
        Shiboken::Conversions::registerConverterName(converter, "QBuffer::UsageType");
        Shiboken::Conversions::registerConverterName(converter, "UsageType");
    }
    // End of 'UsageType' enum.

    // Initialization of enum 'AccessType'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QBuffer_TypeF(),
        "AccessType",
        "2:PySide2.Qt3DRender.Qt3DRender.QBuffer.AccessType",
        "Qt3DRender::QBuffer::AccessType");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "Write", (long) Qt3DRender::QBuffer::AccessType::Write))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "Read", (long) Qt3DRender::QBuffer::AccessType::Read))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX],
        Sbk_Qt3DRender_QBuffer_TypeF(), "ReadWrite", (long) Qt3DRender::QBuffer::AccessType::ReadWrite))
        return;
    // Register converter for enum 'Qt3DRender::QBuffer::AccessType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX],
            Qt3DRender_QBuffer_AccessType_CppToPython_Qt3DRender_QBuffer_AccessType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QBuffer_AccessType_PythonToCpp_Qt3DRender_QBuffer_AccessType,
            is_Qt3DRender_QBuffer_AccessType_PythonToCpp_Qt3DRender_QBuffer_AccessType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_ACCESSTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBuffer::AccessType");
        Shiboken::Conversions::registerConverterName(converter, "QBuffer::AccessType");
        Shiboken::Conversions::registerConverterName(converter, "AccessType");
    }
    // End of 'AccessType' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QBuffer_TypeF(), &::Qt3DRender::QBuffer::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QBuffer::BufferType >("QBuffer::BufferType");
    qRegisterMetaType< ::Qt3DRender::QBuffer::BufferType >("Qt3DRender::QBuffer::BufferType");
    qRegisterMetaType< ::Qt3DRender::QBuffer::UsageType >("QBuffer::UsageType");
    qRegisterMetaType< ::Qt3DRender::QBuffer::UsageType >("Qt3DRender::QBuffer::UsageType");
    qRegisterMetaType< ::Qt3DRender::QBuffer::AccessType >("QBuffer::AccessType");
    qRegisterMetaType< ::Qt3DRender::QBuffer::AccessType >("Qt3DRender::QBuffer::AccessType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QBuffer_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QBuffer_TypeF(), &::Qt3DRender::QBuffer::staticMetaObject, sizeof(QBufferWrapper));
}
