/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qblendequationarguments_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QBlendEquationArgumentsWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QBlendEquationArgumentsWrapper::QBlendEquationArgumentsWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QBlendEquationArguments(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QBlendEquationArgumentsWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBlendEquationArgumentsWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QBlendEquationArgumentsWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBlendEquationArgumentsWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QBlendEquationArgumentsWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBlendEquationArguments.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QBlendEquationArgumentsWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBlendEquationArguments.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QBlendEquationArgumentsWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QBlendEquationArgumentsWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QBlendEquationArguments::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QBlendEquationArgumentsWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QBlendEquationArguments::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QBlendEquationArgumentsWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QBlendEquationArgumentsWrapper *>(this));
        return Qt3DRender::QBlendEquationArguments::qt_metacast(_clname);
}

QBlendEquationArgumentsWrapper::~QBlendEquationArgumentsWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QBlendEquationArguments_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QBlendEquationArguments >()))
        return -1;

    ::QBlendEquationArgumentsWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QBlendEquationArguments", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QBlendEquationArguments::QBlendEquationArguments(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QBlendEquationArguments(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QBlendEquationArguments(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlendEquationArguments_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QBlendEquationArguments_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QBlendEquationArguments_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QBlendEquationArguments(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QBlendEquationArgumentsWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QBlendEquationArgumentsWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QBlendEquationArguments >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QBlendEquationArguments_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QBlendEquationArguments_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QBlendEquationArguments_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_bufferIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.bufferIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bufferIndex()const
            int cppResult = const_cast<const ::Qt3DRender::QBlendEquationArguments *>(cppSelf)->bufferIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_destinationAlpha(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.destinationAlpha";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destinationAlpha()const
            Qt3DRender::QBlendEquationArguments::Blending cppResult = const_cast<const ::Qt3DRender::QBlendEquationArguments *>(cppSelf)->destinationAlpha();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_destinationRgb(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.destinationRgb";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destinationRgb()const
            Qt3DRender::QBlendEquationArguments::Blending cppResult = const_cast<const ::Qt3DRender::QBlendEquationArguments *>(cppSelf)->destinationRgb();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setBufferIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setBufferIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlendEquationArguments::setBufferIndex(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBufferIndex(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setBufferIndex_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBufferIndex(int)
            cppSelf->setBufferIndex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setBufferIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationAlpha(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setDestinationAlpha";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlendEquationArguments::setDestinationAlpha(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDestinationAlpha(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationAlpha_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDestinationAlpha(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setDestinationAlpha(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationAlpha_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationRgb(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setDestinationRgb";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlendEquationArguments::setDestinationRgb(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDestinationRgb(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationRgb_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDestinationRgb(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setDestinationRgb(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationRgb_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationRgba(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setDestinationRgba";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlendEquationArguments::setDestinationRgba(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDestinationRgba(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationRgba_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDestinationRgba(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setDestinationRgba(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationRgba_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceAlpha(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setSourceAlpha";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlendEquationArguments::setSourceAlpha(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSourceAlpha(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceAlpha_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSourceAlpha(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setSourceAlpha(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceAlpha_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceRgb(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setSourceRgb";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlendEquationArguments::setSourceRgb(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSourceRgb(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceRgb_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSourceRgb(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setSourceRgb(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceRgb_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceRgba(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setSourceRgba";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlendEquationArguments::setSourceRgba(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSourceRgba(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceRgba_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSourceRgba(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setSourceRgba(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceRgba_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_sourceAlpha(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.sourceAlpha";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceAlpha()const
            Qt3DRender::QBlendEquationArguments::Blending cppResult = const_cast<const ::Qt3DRender::QBlendEquationArguments *>(cppSelf)->sourceAlpha();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlendEquationArgumentsFunc_sourceRgb(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.sourceRgb";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceRgb()const
            Qt3DRender::QBlendEquationArguments::Blending cppResult = const_cast<const ::Qt3DRender::QBlendEquationArguments *>(cppSelf)->sourceRgb();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QBlendEquationArguments_PropertyStrings[] = {
    "bufferIndex::",
    "destinationAlpha::",
    "destinationRgb::",
    "sourceAlpha::",
    "sourceRgb::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QBlendEquationArguments_methods[] = {
    {"bufferIndex", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_bufferIndex), METH_NOARGS},
    {"destinationAlpha", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_destinationAlpha), METH_NOARGS},
    {"destinationRgb", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_destinationRgb), METH_NOARGS},
    {"setBufferIndex", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setBufferIndex), METH_O},
    {"setDestinationAlpha", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationAlpha), METH_O},
    {"setDestinationRgb", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationRgb), METH_O},
    {"setDestinationRgba", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setDestinationRgba), METH_O},
    {"setSourceAlpha", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceAlpha), METH_O},
    {"setSourceRgb", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceRgb), METH_O},
    {"setSourceRgba", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_setSourceRgba), METH_O},
    {"sourceAlpha", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_sourceAlpha), METH_NOARGS},
    {"sourceRgb", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlendEquationArgumentsFunc_sourceRgb), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QBlendEquationArguments_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QBlendEquationArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QBlendEquationArgumentsWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QBlendEquationArguments_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QBlendEquationArguments_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QBlendEquationArguments_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QBlendEquationArguments_TypeF(void)
{
    return _Sbk_Qt3DRender_QBlendEquationArguments_Type;
}

static PyType_Slot Sbk_Qt3DRender_QBlendEquationArguments_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QBlendEquationArguments_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QBlendEquationArguments_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QBlendEquationArguments_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QBlendEquationArguments_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QBlendEquationArguments_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QBlendEquationArguments_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QBlendEquationArguments_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QBlendEquationArguments_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QBlendEquationArguments *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QBlendEquationArguments_Blending_PythonToCpp_Qt3DRender_QBlendEquationArguments_Blending(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QBlendEquationArguments::Blending *>(cppOut) =
        static_cast<::Qt3DRender::QBlendEquationArguments::Blending>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QBlendEquationArguments_Blending_PythonToCpp_Qt3DRender_QBlendEquationArguments_Blending_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX]))
        return Qt3DRender_QBlendEquationArguments_Blending_PythonToCpp_Qt3DRender_QBlendEquationArguments_Blending;
    return {};
}
static PyObject *Qt3DRender_QBlendEquationArguments_Blending_CppToPython_Qt3DRender_QBlendEquationArguments_Blending(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QBlendEquationArguments::Blending *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBlendEquationArguments_PythonToCpp_QBlendEquationArguments_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBlendEquationArguments_PythonToCpp_QBlendEquationArguments_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QBlendEquationArguments_TypeF())))
        return QBlendEquationArguments_PythonToCpp_QBlendEquationArguments_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBlendEquationArguments_PTR_CppToPython_QBlendEquationArguments(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QBlendEquationArguments *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QBlendEquationArguments_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QBlendEquationArguments_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.bufferIndex(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.destinationAlpha(self)->PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.destinationRgb(self)->PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setBufferIndex(self,index:int)",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setDestinationAlpha(self,destinationAlpha:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setDestinationRgb(self,destinationRgb:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setDestinationRgba(self,destinationRgba:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setSourceAlpha(self,sourceAlpha:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setSourceRgb(self,sourceRgb:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.setSourceRgba(self,sourceRgba:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.sourceAlpha(self)->PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending",
    "PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.sourceRgb(self)->PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending",
    nullptr}; // Sentinel

void init_Qt3DRender_QBlendEquationArguments(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QBlendEquationArguments_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QBlendEquationArguments",
        "Qt3DRender::QBlendEquationArguments*",
        &Sbk_Qt3DRender_QBlendEquationArguments_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QBlendEquationArguments >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERSTATE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QBlendEquationArguments_Type);
    InitSignatureStrings(pyType, Qt3DRender_QBlendEquationArguments_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QBlendEquationArguments_Type), Sbk_Qt3DRender_QBlendEquationArguments_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QBlendEquationArguments_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QBlendEquationArguments_TypeF(),
        QBlendEquationArguments_PythonToCpp_QBlendEquationArguments_PTR,
        is_QBlendEquationArguments_PythonToCpp_QBlendEquationArguments_PTR_Convertible,
        QBlendEquationArguments_PTR_CppToPython_QBlendEquationArguments);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBlendEquationArguments");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBlendEquationArguments*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBlendEquationArguments&");
    Shiboken::Conversions::registerConverterName(converter, "QBlendEquationArguments");
    Shiboken::Conversions::registerConverterName(converter, "QBlendEquationArguments*");
    Shiboken::Conversions::registerConverterName(converter, "QBlendEquationArguments&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QBlendEquationArguments).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBlendEquationArgumentsWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), &Sbk_Qt3DRender_QBlendEquationArguments_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Blending'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QBlendEquationArguments_TypeF(),
        "Blending",
        "2:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending",
        "Qt3DRender::QBlendEquationArguments::Blending");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "Zero", (long) Qt3DRender::QBlendEquationArguments::Blending::Zero))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "One", (long) Qt3DRender::QBlendEquationArguments::Blending::One))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "SourceColor", (long) Qt3DRender::QBlendEquationArguments::Blending::SourceColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "SourceAlpha", (long) Qt3DRender::QBlendEquationArguments::Blending::SourceAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "Source1Alpha", (long) Qt3DRender::QBlendEquationArguments::Blending::Source1Alpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "Source1Color", (long) Qt3DRender::QBlendEquationArguments::Blending::Source1Color))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "DestinationColor", (long) Qt3DRender::QBlendEquationArguments::Blending::DestinationColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "DestinationAlpha", (long) Qt3DRender::QBlendEquationArguments::Blending::DestinationAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "SourceAlphaSaturate", (long) Qt3DRender::QBlendEquationArguments::Blending::SourceAlphaSaturate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "ConstantColor", (long) Qt3DRender::QBlendEquationArguments::Blending::ConstantColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "ConstantAlpha", (long) Qt3DRender::QBlendEquationArguments::Blending::ConstantAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "OneMinusSourceColor", (long) Qt3DRender::QBlendEquationArguments::Blending::OneMinusSourceColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "OneMinusSourceAlpha", (long) Qt3DRender::QBlendEquationArguments::Blending::OneMinusSourceAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "OneMinusDestinationAlpha", (long) Qt3DRender::QBlendEquationArguments::Blending::OneMinusDestinationAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "OneMinusDestinationColor", (long) Qt3DRender::QBlendEquationArguments::Blending::OneMinusDestinationColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "OneMinusConstantColor", (long) Qt3DRender::QBlendEquationArguments::Blending::OneMinusConstantColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "OneMinusConstantAlpha", (long) Qt3DRender::QBlendEquationArguments::Blending::OneMinusConstantAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "OneMinusSource1Alpha", (long) Qt3DRender::QBlendEquationArguments::Blending::OneMinusSource1Alpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "OneMinusSource1Color", (long) Qt3DRender::QBlendEquationArguments::Blending::OneMinusSource1Color))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
        Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), "OneMinusSource1Color0", (long) Qt3DRender::QBlendEquationArguments::Blending::OneMinusSource1Color0))
        return;
    // Register converter for enum 'Qt3DRender::QBlendEquationArguments::Blending'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX],
            Qt3DRender_QBlendEquationArguments_Blending_CppToPython_Qt3DRender_QBlendEquationArguments_Blending);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QBlendEquationArguments_Blending_PythonToCpp_Qt3DRender_QBlendEquationArguments_Blending,
            is_Qt3DRender_QBlendEquationArguments_Blending_PythonToCpp_Qt3DRender_QBlendEquationArguments_Blending_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBlendEquationArguments::Blending");
        Shiboken::Conversions::registerConverterName(converter, "QBlendEquationArguments::Blending");
        Shiboken::Conversions::registerConverterName(converter, "Blending");
    }
    // End of 'Blending' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), &::Qt3DRender::QBlendEquationArguments::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QBlendEquationArguments::Blending >("QBlendEquationArguments::Blending");
    qRegisterMetaType< ::Qt3DRender::QBlendEquationArguments::Blending >("Qt3DRender::QBlendEquationArguments::Blending");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QBlendEquationArguments_TypeF(), &::Qt3DRender::QBlendEquationArguments::staticMetaObject, sizeof(QBlendEquationArgumentsWrapper));
}
