/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qt3drender_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_Qt3DRenderTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_Qt3DRenderModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_Qt3DRenderTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_Qt3DRender_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_Qt3DRenderTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef Qt3DRender_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_Qt3DRenderQt3DRender(PyObject *module);
void init_Qt3DRender_QStencilTestArguments(PyObject *enclosingClass);
void init_Qt3DRender_QStencilOperationArguments(PyObject *enclosingClass);
void init_Qt3DRender_QRenderCaptureReply(PyObject *enclosingClass);
void init_Qt3DRender_QRenderCapabilities(PyObject *enclosingClass);
void init_Qt3DRender_QRayCasterHit(PyObject *enclosingClass);
void init_Qt3DRender_QPickEvent(PyObject *enclosingClass);
void init_Qt3DRender_QPickTriangleEvent(PyObject *enclosingClass);
void init_Qt3DRender_QPickPointEvent(PyObject *enclosingClass);
void init_Qt3DRender_QPickLineEvent(PyObject *enclosingClass);
void init_Qt3DRender_QLevelOfDetailBoundingSphere(PyObject *enclosingClass);
void init_Qt3DRender_QGraphicsApiFilter(PyObject *enclosingClass);
void init_Qt3DRender_QAbstractFunctor(PyObject *enclosingClass);
void init_Qt3DRender_QBufferDataGenerator(PyObject *enclosingClass);
void init_Qt3DRender_QGeometryFactory(PyObject *enclosingClass);
void init_Qt3DRender_PropertyReaderInterface(PyObject *enclosingClass);
void init_Qt3DRender_QTextureWrapMode(PyObject *enclosingClass);
void init_Qt3DRender_QTextureImageDataGenerator(PyObject *enclosingClass);
void init_Qt3DRender_QTextureImageData(PyObject *enclosingClass);
void init_Qt3DRender_QTextureGenerator(PyObject *enclosingClass);
void init_Qt3DRender_QTextureData(PyObject *enclosingClass);
void init_Qt3DRender_QFrameGraphNodeCreatedChangeBase(PyObject *enclosingClass);
void init_Qt3DRender_QRenderState(PyObject *enclosingClass);
void init_Qt3DRender_QFrontFace(PyObject *enclosingClass);
void init_Qt3DRender_QDithering(PyObject *enclosingClass);
void init_Qt3DRender_QPolygonOffset(PyObject *enclosingClass);
void init_Qt3DRender_QPointSize(PyObject *enclosingClass);
void init_Qt3DRender_QDepthTest(PyObject *enclosingClass);
void init_Qt3DRender_QCullFace(PyObject *enclosingClass);
void init_Qt3DRender_QColorMask(PyObject *enclosingClass);
void init_Qt3DRender_QStencilTest(PyObject *enclosingClass);
void init_Qt3DRender_QClipPlane(PyObject *enclosingClass);
void init_Qt3DRender_QStencilOperation(PyObject *enclosingClass);
void init_Qt3DRender_QStencilMask(PyObject *enclosingClass);
void init_Qt3DRender_QNoDepthMask(PyObject *enclosingClass);
void init_Qt3DRender_QMultiSampleAntiAliasing(PyObject *enclosingClass);
void init_Qt3DRender_QBlendEquationArguments(PyObject *enclosingClass);
void init_Qt3DRender_QBlendEquation(PyObject *enclosingClass);
void init_Qt3DRender_QSeamlessCubemap(PyObject *enclosingClass);
void init_Qt3DRender_QAlphaTest(PyObject *enclosingClass);
void init_Qt3DRender_QLineWidth(PyObject *enclosingClass);
void init_Qt3DRender_QAlphaCoverage(PyObject *enclosingClass);
void init_Qt3DRender_QScissorTest(PyObject *enclosingClass);
void init_Qt3DRender_QGeometry(PyObject *enclosingClass);
void init_Qt3DRender_QRenderPass(PyObject *enclosingClass);
void init_Qt3DRender_QFrameGraphNode(PyObject *enclosingClass);
void init_Qt3DRender_QRenderSurfaceSelector(PyObject *enclosingClass);
void init_Qt3DRender_QRenderStateSet(PyObject *enclosingClass);
void init_Qt3DRender_QRenderPassFilter(PyObject *enclosingClass);
void init_Qt3DRender_QFrustumCulling(PyObject *enclosingClass);
void init_Qt3DRender_QRenderCapture(PyObject *enclosingClass);
void init_Qt3DRender_QProximityFilter(PyObject *enclosingClass);
void init_Qt3DRender_QDispatchCompute(PyObject *enclosingClass);
void init_Qt3DRender_QTechniqueFilter(PyObject *enclosingClass);
void init_Qt3DRender_QClearBuffers(PyObject *enclosingClass);
void init_Qt3DRender_QCameraSelector(PyObject *enclosingClass);
void init_Qt3DRender_QSortPolicy(PyObject *enclosingClass);
void init_Qt3DRender_QBufferCapture(PyObject *enclosingClass);
void init_Qt3DRender_QNoPicking(PyObject *enclosingClass);
void init_Qt3DRender_QNoDraw(PyObject *enclosingClass);
void init_Qt3DRender_QBlitFramebuffer(PyObject *enclosingClass);
void init_Qt3DRender_QSetFence(PyObject *enclosingClass);
void init_Qt3DRender_QMemoryBarrier(PyObject *enclosingClass);
void init_Qt3DRender_QWaitFence(PyObject *enclosingClass);
void init_Qt3DRender_QViewport(PyObject *enclosingClass);
void init_Qt3DRender_QRenderTargetSelector(PyObject *enclosingClass);
void init_Qt3DRender_QLayerFilter(PyObject *enclosingClass);
void init_Qt3DRender_QFilterKey(PyObject *enclosingClass);
void init_Qt3DRender_QEffect(PyObject *enclosingClass);
void init_Qt3DRender_QTechnique(PyObject *enclosingClass);
void init_Qt3DRender_QPickingSettings(PyObject *enclosingClass);
void init_Qt3DRender_QParameter(PyObject *enclosingClass);
void init_Qt3DRender_QShaderProgramBuilder(PyObject *enclosingClass);
void init_Qt3DRender_QBuffer(PyObject *enclosingClass);
void init_Qt3DRender_QShaderProgram(PyObject *enclosingClass);
void init_Qt3DRender_QShaderImage(PyObject *enclosingClass);
void init_Qt3DRender_QAttribute(PyObject *enclosingClass);
void init_Qt3DRender_QAbstractTextureImage(PyObject *enclosingClass);
void init_Qt3DRender_QTextureImage(PyObject *enclosingClass);
void init_Qt3DRender_QPaintedTextureImage(PyObject *enclosingClass);
void init_Qt3DRender_QAbstractTexture(PyObject *enclosingClass);
void init_Qt3DRender_QTexture2DArray(PyObject *enclosingClass);
void init_Qt3DRender_QTexture2D(PyObject *enclosingClass);
void init_Qt3DRender_QTexture1DArray(PyObject *enclosingClass);
void init_Qt3DRender_QTexture1D(PyObject *enclosingClass);
void init_Qt3DRender_QTextureRectangle(PyObject *enclosingClass);
void init_Qt3DRender_QTextureLoader(PyObject *enclosingClass);
void init_Qt3DRender_QTextureCubeMapArray(PyObject *enclosingClass);
void init_Qt3DRender_QTextureCubeMap(PyObject *enclosingClass);
void init_Qt3DRender_QTextureBuffer(PyObject *enclosingClass);
void init_Qt3DRender_QSharedGLTexture(PyObject *enclosingClass);
void init_Qt3DRender_QTexture3D(PyObject *enclosingClass);
void init_Qt3DRender_QTexture2DMultisampleArray(PyObject *enclosingClass);
void init_Qt3DRender_QTexture2DMultisample(PyObject *enclosingClass);
void init_Qt3DRender_QRenderTargetOutput(PyObject *enclosingClass);
void init_Qt3DRender_QCamera(PyObject *enclosingClass);
void init_Qt3DRender_QShaderData(PyObject *enclosingClass);
void init_Qt3DRender_QEnvironmentLight(PyObject *enclosingClass);
void init_Qt3DRender_QSceneLoader(PyObject *enclosingClass);
void init_Qt3DRender_QMaterial(PyObject *enclosingClass);
void init_Qt3DRender_QRenderTarget(PyObject *enclosingClass);
void init_Qt3DRender_QLevelOfDetail(PyObject *enclosingClass);
void init_Qt3DRender_QLevelOfDetailSwitch(PyObject *enclosingClass);
void init_Qt3DRender_QLayer(PyObject *enclosingClass);
void init_Qt3DRender_QComputeCommand(PyObject *enclosingClass);
void init_Qt3DRender_QRenderSettings(PyObject *enclosingClass);
void init_Qt3DRender_QAbstractRayCaster(PyObject *enclosingClass);
void init_Qt3DRender_QScreenRayCaster(PyObject *enclosingClass);
void init_Qt3DRender_QRayCaster(PyObject *enclosingClass);
void init_Qt3DRender_QGeometryRenderer(PyObject *enclosingClass);
void init_Qt3DRender_QMesh(PyObject *enclosingClass);
void init_Qt3DRender_QAbstractLight(PyObject *enclosingClass);
void init_Qt3DRender_QPointLight(PyObject *enclosingClass);
void init_Qt3DRender_QDirectionalLight(PyObject *enclosingClass);
void init_Qt3DRender_QSpotLight(PyObject *enclosingClass);
void init_Qt3DRender_QObjectPicker(PyObject *enclosingClass);
void init_Qt3DRender_QCameraLens(PyObject *enclosingClass);
void init_Qt3DRender_QRenderAspect(PyObject *enclosingClass);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_Qt3DCoreTypes;
SbkConverter **SbkPySide2_Qt3DCoreTypeConverters;
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QNode* >'.
static PyObject *_QVector_Qt3DCore_QNodePTR__CppToPython__QVector_Qt3DCore_QNodePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QNode* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QNode* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QNode* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QNode* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QNode* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QNode* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], pyIn))
        return _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QFilterKey* >'.
static PyObject *_QVector_Qt3DRender_QFilterKeyPTR__CppToPython__QVector_Qt3DRender_QFilterKeyPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QFilterKey* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QFilterKey* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QFilterKey* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QFilterKey* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QFILTERKEY_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QFilterKey* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QFilterKey* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QFILTERKEY_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QFILTERKEY_IDX], pyIn))
        return _QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QParameter* >'.
static PyObject *_QVector_Qt3DRender_QParameterPTR__CppToPython__QVector_Qt3DRender_QParameterPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QParameter* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QParameter* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QParameter* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QParameter* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QPARAMETER_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QParameter* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QParameter* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QPARAMETER_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QPARAMETER_IDX], pyIn))
        return _QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QRenderPass* >'.
static PyObject *_QVector_Qt3DRender_QRenderPassPTR__CppToPython__QVector_Qt3DRender_QRenderPassPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QRenderPass* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QRenderPass* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QRenderPass* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QRenderPass* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERPASS_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QRenderPassPTR__PythonToCpp__QVector_Qt3DRender_QRenderPassPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QRenderPass* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QRenderPass* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERPASS_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QRenderPassPTR__PythonToCpp__QVector_Qt3DRender_QRenderPassPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERPASS_IDX], pyIn))
        return _QVector_Qt3DRender_QRenderPassPTR__PythonToCpp__QVector_Qt3DRender_QRenderPassPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QEntity* >'.
static PyObject *_QVector_Qt3DCore_QEntityPTR__CppToPython__QVector_Qt3DCore_QEntityPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QEntity* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QEntity* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QEntity* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QEntity* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QEntity* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QEntity* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX], pyIn))
        return _QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QRenderTargetOutput* >'.
static PyObject *_QVector_Qt3DRender_QRenderTargetOutputPTR__CppToPython__QVector_Qt3DRender_QRenderTargetOutputPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QRenderTargetOutput* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QRenderTargetOutput* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QRenderTargetOutput* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QRenderTargetOutput* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QRenderTargetOutputPTR__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutputPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QRenderTargetOutput* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QRenderTargetOutput* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QRenderTargetOutputPTR__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutputPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_IDX], pyIn))
        return _QVector_Qt3DRender_QRenderTargetOutputPTR__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutputPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QRenderState* >'.
static PyObject *_QVector_Qt3DRender_QRenderStatePTR__CppToPython__QVector_Qt3DRender_QRenderStatePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QRenderState* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QRenderState* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QRenderState* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QRenderState* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERSTATE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QRenderStatePTR__PythonToCpp__QVector_Qt3DRender_QRenderStatePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QRenderState* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QRenderState* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERSTATE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QRenderStatePTR__PythonToCpp__QVector_Qt3DRender_QRenderStatePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERSTATE_IDX], pyIn))
        return _QVector_Qt3DRender_QRenderStatePTR__PythonToCpp__QVector_Qt3DRender_QRenderStatePTR_;
    return {};
}

// C++ to Python conversion for type 'const QVector<qreal > &'.
static PyObject *_constQVector_qreal_REF_CppToPython__constQVector_qreal_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<qreal > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<qreal >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<qreal >::size_type idx = 0; idx < vectorSize; ++idx) {
        qreal cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_qreal_REF_PythonToCpp__constQVector_qreal_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<qreal > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        qreal cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_qreal_REF_PythonToCpp__constQVector_qreal_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyIn))
        return _constQVector_qreal_REF_PythonToCpp__constQVector_qreal_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QAttribute* >'.
static PyObject *_QVector_Qt3DRender_QAttributePTR__CppToPython__QVector_Qt3DRender_QAttributePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QAttribute* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QAttribute* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QAttribute* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QAttribute* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QAttribute* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QAttribute* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], pyIn))
        return _QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QTechnique* >'.
static PyObject *_QVector_Qt3DRender_QTechniquePTR__CppToPython__QVector_Qt3DRender_QTechniquePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QTechnique* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QTechnique* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QTechnique* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QTechnique* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTECHNIQUE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QTechniquePTR__PythonToCpp__QVector_Qt3DRender_QTechniquePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QTechnique* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QTechnique* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTECHNIQUE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QTechniquePTR__PythonToCpp__QVector_Qt3DRender_QTechniquePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTECHNIQUE_IDX], pyIn))
        return _QVector_Qt3DRender_QTechniquePTR__PythonToCpp__QVector_Qt3DRender_QTechniquePTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QComponent* >'.
static PyObject *_QVector_Qt3DCore_QComponentPTR__CppToPython__QVector_Qt3DCore_QComponentPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QComponent* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QComponent* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QComponent* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QComponent* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QComponent* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QComponent* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX], pyIn))
        return _QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR_;
    return {};
}

// C++ to Python conversion for type 'const QVector<Qt3DRender::QSortPolicy::SortType > &'.
static PyObject *_constQVector_Qt3DRender_QSortPolicy_SortType_REF_CppToPython__constQVector_Qt3DRender_QSortPolicy_SortType_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QSortPolicy::SortType > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QSortPolicy::SortType >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QSortPolicy::SortType >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QSortPolicy::SortType cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSORTPOLICY_SORTTYPE_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_Qt3DRender_QSortPolicy_SortType_REF_PythonToCpp__constQVector_Qt3DRender_QSortPolicy_SortType_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QSortPolicy::SortType > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QSortPolicy::SortType cppItem = static_cast< ::Qt3DRender::QSortPolicy::SortType>(0);
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSORTPOLICY_SORTTYPE_IDX])->converter, pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_Qt3DRender_QSortPolicy_SortType_REF_PythonToCpp__constQVector_Qt3DRender_QSortPolicy_SortType_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSORTPOLICY_SORTTYPE_IDX])->converter, pyIn))
        return _constQVector_Qt3DRender_QSortPolicy_SortType_REF_PythonToCpp__constQVector_Qt3DRender_QSortPolicy_SortType_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<int > &'.
static PyObject *_constQVector_int_REF_CppToPython__constQVector_int_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<int >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<int >::size_type idx = 0; idx < vectorSize; ++idx) {
        int cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_int_REF_PythonToCpp__constQVector_int_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_int_REF_PythonToCpp__constQVector_int_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _constQVector_int_REF_PythonToCpp__constQVector_int_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QLayer* >'.
static PyObject *_QVector_Qt3DRender_QLayerPTR__CppToPython__QVector_Qt3DRender_QLayerPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QLayer* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QLayer* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QLayer* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QLayer* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLAYER_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QLayerPTR__PythonToCpp__QVector_Qt3DRender_QLayerPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QLayer* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QLayer* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLAYER_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QLayerPTR__PythonToCpp__QVector_Qt3DRender_QLayerPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLAYER_IDX], pyIn))
        return _QVector_Qt3DRender_QLayerPTR__PythonToCpp__QVector_Qt3DRender_QLayerPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QRenderTargetOutput::AttachmentPoint >'.
static PyObject *_QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint__CppToPython__QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QRenderTargetOutput::AttachmentPoint > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QRenderTargetOutput::AttachmentPoint >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QRenderTargetOutput::AttachmentPoint >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QRenderTargetOutput::AttachmentPoint cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QRenderTargetOutput::AttachmentPoint > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QRenderTargetOutput::AttachmentPoint cppItem{Qt3DRender::QRenderTargetOutput::Color0};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX])->converter, pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX])->converter, pyIn))
        return _QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QAbstractTextureImage* >'.
static PyObject *_QVector_Qt3DRender_QAbstractTextureImagePTR__CppToPython__QVector_Qt3DRender_QAbstractTextureImagePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QAbstractTextureImage* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QAbstractTextureImage* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QAbstractTextureImage* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QAbstractTextureImage* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTUREIMAGE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QAbstractTextureImagePTR__PythonToCpp__QVector_Qt3DRender_QAbstractTextureImagePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QAbstractTextureImage* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QAbstractTextureImage* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTUREIMAGE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QAbstractTextureImagePTR__PythonToCpp__QVector_Qt3DRender_QAbstractTextureImagePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTUREIMAGE_IDX], pyIn))
        return _QVector_Qt3DRender_QAbstractTextureImagePTR__PythonToCpp__QVector_Qt3DRender_QAbstractTextureImagePTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QRayCasterHit >'.
static PyObject *_QVector_Qt3DRender_QRayCasterHit__CppToPython__QVector_Qt3DRender_QRayCasterHit_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QRayCasterHit > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QRayCasterHit >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QRayCasterHit >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QRayCasterHit cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QRayCasterHit__PythonToCpp__QVector_Qt3DRender_QRayCasterHit_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QRayCasterHit > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QRayCasterHit cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QRayCasterHit__PythonToCpp__QVector_Qt3DRender_QRayCasterHit__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX]), pyIn))
        return _QVector_Qt3DRender_QRayCasterHit__PythonToCpp__QVector_Qt3DRender_QRayCasterHit_;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "Qt3DRender",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ Qt3DRender_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(Qt3DRender)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.Qt3DCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_Qt3DCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_Qt3DCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_Qt3DRender_IDX_COUNT];
    SbkPySide2_Qt3DRenderTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_Qt3DRender_CONVERTERS_IDX_COUNT];
    SbkPySide2_Qt3DRenderTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("Qt3DRender", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("Qt3DRender", Qt3DRender_methods);
#endif

    // Make module available from global scope
    SbkPySide2_Qt3DRenderModuleObject = module;

    // Initialize classes in the type system
    init_Qt3DRenderQt3DRender(module);
    init_Qt3DRender_QStencilTestArguments(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QStencilOperationArguments(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderCaptureReply(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderCapabilities(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRayCasterHit(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QPickEvent(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QPickTriangleEvent(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QPickPointEvent(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QPickLineEvent(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QLevelOfDetailBoundingSphere(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QGraphicsApiFilter(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QAbstractFunctor(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QBufferDataGenerator(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QGeometryFactory(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_PropertyReaderInterface(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureWrapMode(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureImageDataGenerator(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureImageData(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureGenerator(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureData(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QFrameGraphNodeCreatedChangeBase(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderState(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QFrontFace(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QDithering(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QPolygonOffset(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QPointSize(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QDepthTest(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QCullFace(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QColorMask(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QStencilTest(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QClipPlane(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QStencilOperation(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QStencilMask(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QNoDepthMask(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QMultiSampleAntiAliasing(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QBlendEquationArguments(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QBlendEquation(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QSeamlessCubemap(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QAlphaTest(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QLineWidth(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QAlphaCoverage(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QScissorTest(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QGeometry(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderPass(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QFrameGraphNode(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderSurfaceSelector(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderStateSet(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderPassFilter(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QFrustumCulling(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderCapture(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QProximityFilter(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QDispatchCompute(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTechniqueFilter(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QClearBuffers(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QCameraSelector(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QSortPolicy(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QBufferCapture(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QNoPicking(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QNoDraw(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QBlitFramebuffer(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QSetFence(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QMemoryBarrier(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QWaitFence(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QViewport(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderTargetSelector(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QLayerFilter(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QFilterKey(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QEffect(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTechnique(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QPickingSettings(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QParameter(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QShaderProgramBuilder(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QBuffer(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QShaderProgram(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QShaderImage(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QAttribute(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QAbstractTextureImage(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureImage(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QPaintedTextureImage(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QAbstractTexture(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTexture2DArray(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTexture2D(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTexture1DArray(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTexture1D(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureRectangle(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureLoader(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureCubeMapArray(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureCubeMap(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTextureBuffer(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QSharedGLTexture(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTexture3D(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTexture2DMultisampleArray(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QTexture2DMultisample(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderTargetOutput(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QCamera(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QShaderData(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QEnvironmentLight(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QSceneLoader(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderTarget(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QLevelOfDetail(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QLevelOfDetailSwitch(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QLayer(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QComputeCommand(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderSettings(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QAbstractRayCaster(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QScreenRayCaster(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRayCaster(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QGeometryRenderer(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QMesh(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QAbstractLight(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QPointLight(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QDirectionalLight(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QSpotLight(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QObjectPicker(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QCameraLens(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);
    init_Qt3DRender_QRenderAspect(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX])->tp_dict);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QNode*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DCORE_QNODEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QNodePTR__CppToPython__QVector_Qt3DCore_QNodePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DCORE_QNODEPTR_IDX], "QVector<Qt3DCore::QNode*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DCORE_QNODEPTR_IDX],
        _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_,
        is__QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QFilterKey*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QFILTERKEYPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QFilterKeyPTR__CppToPython__QVector_Qt3DRender_QFilterKeyPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QFILTERKEYPTR_IDX], "QVector<Qt3DRender::QFilterKey*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QFILTERKEYPTR_IDX],
        _QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR_,
        is__QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QParameter*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QPARAMETERPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QParameterPTR__CppToPython__QVector_Qt3DRender_QParameterPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QPARAMETERPTR_IDX], "QVector<Qt3DRender::QParameter*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QPARAMETERPTR_IDX],
        _QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR_,
        is__QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QRenderPass*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERPASSPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QRenderPassPTR__CppToPython__QVector_Qt3DRender_QRenderPassPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERPASSPTR_IDX], "QVector<Qt3DRender::QRenderPass*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERPASSPTR_IDX],
        _QVector_Qt3DRender_QRenderPassPTR__PythonToCpp__QVector_Qt3DRender_QRenderPassPTR_,
        is__QVector_Qt3DRender_QRenderPassPTR__PythonToCpp__QVector_Qt3DRender_QRenderPassPTR__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QEntity*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DCORE_QENTITYPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QEntityPTR__CppToPython__QVector_Qt3DCore_QEntityPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DCORE_QENTITYPTR_IDX], "QVector<Qt3DCore::QEntity*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DCORE_QENTITYPTR_IDX],
        _QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR_,
        is__QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QRenderTargetOutput*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERTARGETOUTPUTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QRenderTargetOutputPTR__CppToPython__QVector_Qt3DRender_QRenderTargetOutputPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERTARGETOUTPUTPTR_IDX], "QVector<Qt3DRender::QRenderTargetOutput*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERTARGETOUTPUTPTR_IDX],
        _QVector_Qt3DRender_QRenderTargetOutputPTR__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutputPTR_,
        is__QVector_Qt3DRender_QRenderTargetOutputPTR__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutputPTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QRenderState*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERSTATEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QRenderStatePTR__CppToPython__QVector_Qt3DRender_QRenderStatePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERSTATEPTR_IDX], "QVector<Qt3DRender::QRenderState*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERSTATEPTR_IDX],
        _QVector_Qt3DRender_QRenderStatePTR__PythonToCpp__QVector_Qt3DRender_QRenderStatePTR_,
        is__QVector_Qt3DRender_QRenderStatePTR__PythonToCpp__QVector_Qt3DRender_QRenderStatePTR__Convertible);

    // Register converter for type 'const QVector<qreal>&'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QREAL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_qreal_REF_CppToPython__constQVector_qreal_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QREAL_IDX], "const QVector<qreal>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QREAL_IDX], "QVector<qreal>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QREAL_IDX],
        _constQVector_qreal_REF_PythonToCpp__constQVector_qreal_REF,
        is__constQVector_qreal_REF_PythonToCpp__constQVector_qreal_REF_Convertible);

    // Register converter for type 'QVector<Qt3DRender::QAttribute*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QATTRIBUTEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QAttributePTR__CppToPython__QVector_Qt3DRender_QAttributePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QATTRIBUTEPTR_IDX], "QVector<Qt3DRender::QAttribute*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QATTRIBUTEPTR_IDX],
        _QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR_,
        is__QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QTechnique*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QTECHNIQUEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QTechniquePTR__CppToPython__QVector_Qt3DRender_QTechniquePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QTECHNIQUEPTR_IDX], "QVector<Qt3DRender::QTechnique*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QTECHNIQUEPTR_IDX],
        _QVector_Qt3DRender_QTechniquePTR__PythonToCpp__QVector_Qt3DRender_QTechniquePTR_,
        is__QVector_Qt3DRender_QTechniquePTR__PythonToCpp__QVector_Qt3DRender_QTechniquePTR__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QComponent*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DCORE_QCOMPONENTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QComponentPTR__CppToPython__QVector_Qt3DCore_QComponentPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DCORE_QCOMPONENTPTR_IDX], "QVector<Qt3DCore::QComponent*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DCORE_QCOMPONENTPTR_IDX],
        _QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR_,
        is__QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR__Convertible);

    // Register converter for type 'const QVector<Qt3DRender::QSortPolicy::SortType>&'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QSORTPOLICY_SORTTYPE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_Qt3DRender_QSortPolicy_SortType_REF_CppToPython__constQVector_Qt3DRender_QSortPolicy_SortType_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QSORTPOLICY_SORTTYPE_IDX], "const QVector<Qt3DRender::QSortPolicy::SortType>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QSORTPOLICY_SORTTYPE_IDX], "QVector<Qt3DRender::QSortPolicy::SortType>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QSORTPOLICY_SORTTYPE_IDX],
        _constQVector_Qt3DRender_QSortPolicy_SortType_REF_PythonToCpp__constQVector_Qt3DRender_QSortPolicy_SortType_REF,
        is__constQVector_Qt3DRender_QSortPolicy_SortType_REF_PythonToCpp__constQVector_Qt3DRender_QSortPolicy_SortType_REF_Convertible);

    // Register converter for type 'const QVector<int>&'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_int_REF_CppToPython__constQVector_int_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_INT_IDX], "const QVector<int>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_INT_IDX], "QVector<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_INT_IDX],
        _constQVector_int_REF_PythonToCpp__constQVector_int_REF,
        is__constQVector_int_REF_PythonToCpp__constQVector_int_REF_Convertible);

    // Register converter for type 'QVector<Qt3DRender::QLayer*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QLAYERPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QLayerPTR__CppToPython__QVector_Qt3DRender_QLayerPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QLAYERPTR_IDX], "QVector<Qt3DRender::QLayer*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QLAYERPTR_IDX],
        _QVector_Qt3DRender_QLayerPTR__PythonToCpp__QVector_Qt3DRender_QLayerPTR_,
        is__QVector_Qt3DRender_QLayerPTR__PythonToCpp__QVector_Qt3DRender_QLayerPTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QRenderTargetOutput::AttachmentPoint>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint__CppToPython__QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX], "QVector<Qt3DRender::QRenderTargetOutput::AttachmentPoint>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX],
        _QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint_,
        is__QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint__PythonToCpp__QVector_Qt3DRender_QRenderTargetOutput_AttachmentPoint__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QAbstractTextureImage*>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QABSTRACTTEXTUREIMAGEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QAbstractTextureImagePTR__CppToPython__QVector_Qt3DRender_QAbstractTextureImagePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QABSTRACTTEXTUREIMAGEPTR_IDX], "QVector<Qt3DRender::QAbstractTextureImage*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QABSTRACTTEXTUREIMAGEPTR_IDX],
        _QVector_Qt3DRender_QAbstractTextureImagePTR__PythonToCpp__QVector_Qt3DRender_QAbstractTextureImagePTR_,
        is__QVector_Qt3DRender_QAbstractTextureImagePTR__PythonToCpp__QVector_Qt3DRender_QAbstractTextureImagePTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QRayCasterHit>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRAYCASTERHIT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QRayCasterHit__CppToPython__QVector_Qt3DRender_QRayCasterHit_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRAYCASTERHIT_IDX], "QVector<Qt3DRender::QRayCasterHit>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRAYCASTERHIT_IDX],
        _QVector_Qt3DRender_QRayCasterHit__PythonToCpp__QVector_Qt3DRender_QRayCasterHit_,
        is__QVector_Qt3DRender_QRayCasterHit__PythonToCpp__QVector_Qt3DRender_QRayCasterHit__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_Qt3DRenderTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_Qt3DRenderTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module Qt3DRender");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, Qt3DRender_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
