/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3dinput_python.h"

// main header
#include "qt3dinput_qmouseevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DInput;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QMouseEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QMouseEventWrapper::QMouseEventWrapper(const ::QMouseEvent & e) : Qt3DInput::QMouseEvent(e)
{
    resetPyMethodCache();
    // ... middle
}

void QMouseEventWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMouseEventWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QMouseEventWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMouseEventWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QMouseEventWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMouseEvent.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QMouseEventWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMouseEvent.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QMouseEventWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QMouseEventWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DInput::QMouseEvent::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QMouseEventWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DInput::QMouseEvent::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QMouseEventWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QMouseEventWrapper *>(this));
        return Qt3DInput::QMouseEvent::qt_metacast(_clname);
}

QMouseEventWrapper::~QMouseEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DInput_QMouseEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DInput::QMouseEvent >()))
        return -1;

    ::QMouseEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMouseEvent", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMouseEvent::QMouseEvent(QMouseEvent)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QMouseEvent(QMouseEvent)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DInput_QMouseEvent_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QMouseEvent *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QMouseEvent(QMouseEvent)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QMouseEventWrapper(*cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QMouseEventWrapper(*cppArg0);
            }

        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DInput::QMouseEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DInput_QMouseEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DInput_QMouseEvent_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DInput_QMouseEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DInput_QMouseEventFunc_button(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.button";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // button()const
            Qt3DInput::QMouseEvent::Buttons cppResult = const_cast<const ::Qt3DInput::QMouseEvent *>(cppSelf)->button();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QMouseEventFunc_buttons(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.buttons";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buttons()const
            int cppResult = const_cast<const ::Qt3DInput::QMouseEvent *>(cppSelf)->buttons();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QMouseEventFunc_isAccepted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.isAccepted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAccepted()const
            bool cppResult = const_cast<const ::Qt3DInput::QMouseEvent *>(cppSelf)->isAccepted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QMouseEventFunc_modifiers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.modifiers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // modifiers()const
            Qt3DInput::QMouseEvent::Modifiers cppResult = const_cast<const ::Qt3DInput::QMouseEvent *>(cppSelf)->modifiers();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QMouseEventFunc_setAccepted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.setAccepted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMouseEvent::setAccepted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAccepted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DInput_QMouseEventFunc_setAccepted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAccepted(bool)
            cppSelf->setAccepted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DInput_QMouseEventFunc_setAccepted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DInput_QMouseEventFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QEvent::Type cppResult = const_cast<const ::Qt3DInput::QMouseEvent *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QMouseEventFunc_wasHeld(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.wasHeld";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wasHeld()const
            bool cppResult = const_cast<const ::Qt3DInput::QMouseEvent *>(cppSelf)->wasHeld();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QMouseEventFunc_x(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.x";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x()const
            int cppResult = const_cast<const ::Qt3DInput::QMouseEvent *>(cppSelf)->x();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QMouseEventFunc_y(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.y";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y()const
            int cppResult = const_cast<const ::Qt3DInput::QMouseEvent *>(cppSelf)->y();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DInput_QMouseEvent_PropertyStrings[] = {
    "accepted:isAccepted:",
    "button:",
    "buttons:",
    "modifiers:",
    "wasHeld:",
    "x:",
    "y:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DInput_QMouseEvent_methods[] = {
    {"button", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QMouseEventFunc_button), METH_NOARGS},
    {"buttons", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QMouseEventFunc_buttons), METH_NOARGS},
    {"isAccepted", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QMouseEventFunc_isAccepted), METH_NOARGS},
    {"modifiers", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QMouseEventFunc_modifiers), METH_NOARGS},
    {"setAccepted", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QMouseEventFunc_setAccepted), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QMouseEventFunc_type), METH_NOARGS},
    {"wasHeld", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QMouseEventFunc_wasHeld), METH_NOARGS},
    {"x", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QMouseEventFunc_x), METH_NOARGS},
    {"y", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QMouseEventFunc_y), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DInput_QMouseEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DInput::QMouseEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QMouseEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DInput_QMouseEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DInput_QMouseEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DInput_QMouseEvent_Type = nullptr;
static SbkObjectType *Sbk_Qt3DInput_QMouseEvent_TypeF(void)
{
    return _Sbk_Qt3DInput_QMouseEvent_Type;
}

static PyType_Slot Sbk_Qt3DInput_QMouseEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DInput_QMouseEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DInput_QMouseEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DInput_QMouseEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DInput_QMouseEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DInput_QMouseEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DInput_QMouseEvent_spec = {
    "2:PySide2.Qt3DInput.Qt3DInput.QMouseEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DInput_QMouseEvent_slots
};

} //extern "C"

static void *Sbk_Qt3DInput_QMouseEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DInput::QMouseEvent *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DInput_QMouseEvent_Buttons_PythonToCpp_Qt3DInput_QMouseEvent_Buttons(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DInput::QMouseEvent::Buttons *>(cppOut) =
        static_cast<::Qt3DInput::QMouseEvent::Buttons>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DInput_QMouseEvent_Buttons_PythonToCpp_Qt3DInput_QMouseEvent_Buttons_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX]))
        return Qt3DInput_QMouseEvent_Buttons_PythonToCpp_Qt3DInput_QMouseEvent_Buttons;
    return {};
}
static PyObject *Qt3DInput_QMouseEvent_Buttons_CppToPython_Qt3DInput_QMouseEvent_Buttons(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DInput::QMouseEvent::Buttons *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX], castCppIn);

}

static void Qt3DInput_QMouseEvent_Modifiers_PythonToCpp_Qt3DInput_QMouseEvent_Modifiers(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DInput::QMouseEvent::Modifiers *>(cppOut) =
        static_cast<::Qt3DInput::QMouseEvent::Modifiers>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DInput_QMouseEvent_Modifiers_PythonToCpp_Qt3DInput_QMouseEvent_Modifiers_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX]))
        return Qt3DInput_QMouseEvent_Modifiers_PythonToCpp_Qt3DInput_QMouseEvent_Modifiers;
    return {};
}
static PyObject *Qt3DInput_QMouseEvent_Modifiers_CppToPython_Qt3DInput_QMouseEvent_Modifiers(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DInput::QMouseEvent::Modifiers *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMouseEvent_PythonToCpp_QMouseEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DInput_QMouseEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMouseEvent_PythonToCpp_QMouseEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DInput_QMouseEvent_TypeF())))
        return QMouseEvent_PythonToCpp_QMouseEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMouseEvent_PTR_CppToPython_QMouseEvent(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DInput::QMouseEvent *>(const_cast<void *>(cppIn)), Sbk_Qt3DInput_QMouseEvent_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DInput_QMouseEvent_SignatureStrings[] = {
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent(self,e:PySide2.QtGui.QMouseEvent)",
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.button(self)->PySide2.Qt3DInput.Qt3DInput.QMouseEvent.Buttons",
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.buttons(self)->int",
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.isAccepted(self)->bool",
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.modifiers(self)->PySide2.Qt3DInput.Qt3DInput.QMouseEvent.Modifiers",
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.setAccepted(self,accepted:bool)",
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.type(self)->PySide2.QtCore.QEvent.Type",
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.wasHeld(self)->bool",
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.x(self)->int",
    "PySide2.Qt3DInput.Qt3DInput.QMouseEvent.y(self)->int",
    nullptr}; // Sentinel

void init_Qt3DInput_QMouseEvent(PyObject *enclosingClass)
{
    _Sbk_Qt3DInput_QMouseEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QMouseEvent",
        "Qt3DInput::QMouseEvent*",
        &Sbk_Qt3DInput_QMouseEvent_spec,
        &Shiboken::callCppDestructor< ::Qt3DInput::QMouseEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DInput_QMouseEvent_Type);
    InitSignatureStrings(pyType, Qt3DInput_QMouseEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DInput_QMouseEvent_Type), Sbk_Qt3DInput_QMouseEvent_PropertyStrings);
    SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DInput_QMouseEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DInput_QMouseEvent_TypeF(),
        QMouseEvent_PythonToCpp_QMouseEvent_PTR,
        is_QMouseEvent_PythonToCpp_QMouseEvent_PTR_Convertible,
        QMouseEvent_PTR_CppToPython_QMouseEvent);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QMouseEvent");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QMouseEvent*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QMouseEvent&");
    Shiboken::Conversions::registerConverterName(converter, "QMouseEvent");
    Shiboken::Conversions::registerConverterName(converter, "QMouseEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QMouseEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DInput::QMouseEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMouseEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DInput_QMouseEvent_TypeF(), &Sbk_Qt3DInput_QMouseEvent_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Buttons'.
    SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DInput_QMouseEvent_TypeF(),
        "Buttons",
        "2:PySide2.Qt3DInput.Qt3DInput.QMouseEvent.Buttons",
        "Qt3DInput::QMouseEvent::Buttons");
    if (!SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "LeftButton", (long) Qt3DInput::QMouseEvent::Buttons::LeftButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "RightButton", (long) Qt3DInput::QMouseEvent::Buttons::RightButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "MiddleButton", (long) Qt3DInput::QMouseEvent::Buttons::MiddleButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "BackButton", (long) Qt3DInput::QMouseEvent::Buttons::BackButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "NoButton", (long) Qt3DInput::QMouseEvent::Buttons::NoButton))
        return;
    // Register converter for enum 'Qt3DInput::QMouseEvent::Buttons'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX],
            Qt3DInput_QMouseEvent_Buttons_CppToPython_Qt3DInput_QMouseEvent_Buttons);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DInput_QMouseEvent_Buttons_PythonToCpp_Qt3DInput_QMouseEvent_Buttons,
            is_Qt3DInput_QMouseEvent_Buttons_PythonToCpp_Qt3DInput_QMouseEvent_Buttons_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_BUTTONS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QMouseEvent::Buttons");
        Shiboken::Conversions::registerConverterName(converter, "QMouseEvent::Buttons");
        Shiboken::Conversions::registerConverterName(converter, "Buttons");
    }
    // End of 'Buttons' enum.

    // Initialization of enum 'Modifiers'.
    SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DInput_QMouseEvent_TypeF(),
        "Modifiers",
        "2:PySide2.Qt3DInput.Qt3DInput.QMouseEvent.Modifiers",
        "Qt3DInput::QMouseEvent::Modifiers");
    if (!SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "NoModifier", (long) Qt3DInput::QMouseEvent::Modifiers::NoModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "ShiftModifier", (long) Qt3DInput::QMouseEvent::Modifiers::ShiftModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "ControlModifier", (long) Qt3DInput::QMouseEvent::Modifiers::ControlModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "AltModifier", (long) Qt3DInput::QMouseEvent::Modifiers::AltModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "MetaModifier", (long) Qt3DInput::QMouseEvent::Modifiers::MetaModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QMouseEvent_TypeF(), "KeypadModifier", (long) Qt3DInput::QMouseEvent::Modifiers::KeypadModifier))
        return;
    // Register converter for enum 'Qt3DInput::QMouseEvent::Modifiers'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX],
            Qt3DInput_QMouseEvent_Modifiers_CppToPython_Qt3DInput_QMouseEvent_Modifiers);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DInput_QMouseEvent_Modifiers_PythonToCpp_Qt3DInput_QMouseEvent_Modifiers,
            is_Qt3DInput_QMouseEvent_Modifiers_PythonToCpp_Qt3DInput_QMouseEvent_Modifiers_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QMOUSEEVENT_MODIFIERS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QMouseEvent::Modifiers");
        Shiboken::Conversions::registerConverterName(converter, "QMouseEvent::Modifiers");
        Shiboken::Conversions::registerConverterName(converter, "Modifiers");
    }
    // End of 'Modifiers' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DInput_QMouseEvent_TypeF(), &::Qt3DInput::QMouseEvent::staticMetaObject);
    qRegisterMetaType< ::Qt3DInput::QMouseEvent::Buttons >("QMouseEvent::Buttons");
    qRegisterMetaType< ::Qt3DInput::QMouseEvent::Buttons >("Qt3DInput::QMouseEvent::Buttons");
    qRegisterMetaType< ::Qt3DInput::QMouseEvent::Modifiers >("QMouseEvent::Modifiers");
    qRegisterMetaType< ::Qt3DInput::QMouseEvent::Modifiers >("Qt3DInput::QMouseEvent::Modifiers");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DInput_QMouseEvent_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DInput_QMouseEvent_TypeF(), &::Qt3DInput::QMouseEvent::staticMetaObject, sizeof(QMouseEventWrapper));
}
