/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3dcore_python.h"

// main header
#include "qt3dcore_qcomponentremovedchange_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QComponentRemovedChangeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QComponentRemovedChangeWrapper::QComponentRemovedChangeWrapper(const ::Qt3DCore::QComponent * component, const ::Qt3DCore::QEntity * entity) : Qt3DCore::QComponentRemovedChange(component, entity)
{
    resetPyMethodCache();
    // ... middle
}

QComponentRemovedChangeWrapper::QComponentRemovedChangeWrapper(const ::Qt3DCore::QEntity * entity, const ::Qt3DCore::QComponent * component) : Qt3DCore::QComponentRemovedChange(entity, component)
{
    resetPyMethodCache();
    // ... middle
}

QComponentRemovedChangeWrapper::~QComponentRemovedChangeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DCore_QComponentRemovedChange_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DCore::QComponentRemovedChange >()))
        return -1;

    ::QComponentRemovedChangeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QComponentRemovedChange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QComponentRemovedChange::QComponentRemovedChange(const Qt3DCore::QComponent*,const Qt3DCore::QEntity*)
    // 1: QComponentRemovedChange::QComponentRemovedChange(const Qt3DCore::QEntity*,const Qt3DCore::QComponent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), (pyArgs[1])))) {
        overloadId = 1; // QComponentRemovedChange(const Qt3DCore::QEntity*,const Qt3DCore::QComponent*)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // QComponentRemovedChange(const Qt3DCore::QComponent*,const Qt3DCore::QEntity*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QComponentRemovedChange_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QComponentRemovedChange(const Qt3DCore::QComponent * component, const Qt3DCore::QEntity * entity)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DCore::QComponent *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::Qt3DCore::QEntity *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QComponentRemovedChange(const Qt3DCore::QComponent*,const Qt3DCore::QEntity*)
                cptr = new ::QComponentRemovedChangeWrapper(cppArg0, cppArg1);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QComponentRemovedChange.QComponentRemovedChange(const Qt3DCore::QComponent * component, const Qt3DCore::QEntity * entity) is deprecated", 1);
            break;
        }
        case 1: // QComponentRemovedChange(const Qt3DCore::QEntity * entity, const Qt3DCore::QComponent * component)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DCore::QEntity *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::Qt3DCore::QComponent *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QComponentRemovedChange(const Qt3DCore::QEntity*,const Qt3DCore::QComponent*)
                cptr = new ::QComponentRemovedChangeWrapper(cppArg0, cppArg1);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QComponentRemovedChange.QComponentRemovedChange(const Qt3DCore::QEntity * entity, const Qt3DCore::QComponent * component) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DCore::QComponentRemovedChange >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DCore_QComponentRemovedChange_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Qt3DCore_QComponentRemovedChange_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DCore_QComponentRemovedChangeFunc_componentId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QComponentRemovedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTREMOVEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange.componentId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // componentId()const
            Qt3DCore::QNodeId cppResult = const_cast<const ::Qt3DCore::QComponentRemovedChange *>(cppSelf)->componentId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QComponentRemovedChangeFunc_componentMetaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QComponentRemovedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTREMOVEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange.componentMetaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // componentMetaObject()const
            const QMetaObject * cppResult = const_cast<const ::Qt3DCore::QComponentRemovedChange *>(cppSelf)->componentMetaObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QComponentRemovedChangeFunc_entityId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QComponentRemovedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTREMOVEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange.entityId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // entityId()const
            Qt3DCore::QNodeId cppResult = const_cast<const ::Qt3DCore::QComponentRemovedChange *>(cppSelf)->entityId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DCore_QComponentRemovedChange_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DCore_QComponentRemovedChange_methods[] = {
    {"componentId", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QComponentRemovedChangeFunc_componentId), METH_NOARGS},
    {"componentMetaObject", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QComponentRemovedChangeFunc_componentMetaObject), METH_NOARGS},
    {"entityId", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QComponentRemovedChangeFunc_entityId), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DCore_QComponentRemovedChange_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DCore::QComponentRemovedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTREMOVEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QComponentRemovedChangeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DCore_QComponentRemovedChange_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DCore_QComponentRemovedChange_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DCore_QComponentRemovedChange_Type = nullptr;
static SbkObjectType *Sbk_Qt3DCore_QComponentRemovedChange_TypeF(void)
{
    return _Sbk_Qt3DCore_QComponentRemovedChange_Type;
}

static PyType_Slot Sbk_Qt3DCore_QComponentRemovedChange_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentRemovedChange_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentRemovedChange_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentRemovedChange_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentRemovedChange_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentRemovedChange_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DCore_QComponentRemovedChange_spec = {
    "2:PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DCore_QComponentRemovedChange_slots
};

} //extern "C"

static void *Sbk_Qt3DCore_QComponentRemovedChange_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::Qt3DCore::QSceneChange >()))
        return dynamic_cast< ::Qt3DCore::QComponentRemovedChange *>(reinterpret_cast< ::Qt3DCore::QSceneChange *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QComponentRemovedChange_PythonToCpp_QComponentRemovedChange_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DCore_QComponentRemovedChange_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QComponentRemovedChange_PythonToCpp_QComponentRemovedChange_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QComponentRemovedChange_TypeF())))
        return QComponentRemovedChange_PythonToCpp_QComponentRemovedChange_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QComponentRemovedChange_PTR_CppToPython_QComponentRemovedChange(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DCore::QComponentRemovedChange *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DCore_QComponentRemovedChange_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DCore_QComponentRemovedChange_SignatureStrings[] = {
    "1:PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange(self,component:PySide2.Qt3DCore.Qt3DCore.QComponent,entity:PySide2.Qt3DCore.Qt3DCore.QEntity)",
    "0:PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange(self,entity:PySide2.Qt3DCore.Qt3DCore.QEntity,component:PySide2.Qt3DCore.Qt3DCore.QComponent)",
    "PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange.componentId(self)->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    "PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange.componentMetaObject(self)->PySide2.QtCore.QMetaObject",
    "PySide2.Qt3DCore.Qt3DCore.QComponentRemovedChange.entityId(self)->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    nullptr}; // Sentinel

void init_Qt3DCore_QComponentRemovedChange(PyObject *enclosingClass)
{
    _Sbk_Qt3DCore_QComponentRemovedChange_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QComponentRemovedChange",
        "Qt3DCore::QComponentRemovedChange*",
        &Sbk_Qt3DCore_QComponentRemovedChange_spec,
        &Shiboken::callCppDestructor< ::Qt3DCore::QComponentRemovedChange >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QComponentRemovedChange_Type);
    InitSignatureStrings(pyType, Qt3DCore_QComponentRemovedChange_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QComponentRemovedChange_Type), Sbk_Qt3DCore_QComponentRemovedChange_PropertyStrings);
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTREMOVEDCHANGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QComponentRemovedChange_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DCore_QComponentRemovedChange_TypeF(),
        QComponentRemovedChange_PythonToCpp_QComponentRemovedChange_PTR,
        is_QComponentRemovedChange_PythonToCpp_QComponentRemovedChange_PTR_Convertible,
        QComponentRemovedChange_PTR_CppToPython_QComponentRemovedChange);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QComponentRemovedChange");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QComponentRemovedChange*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QComponentRemovedChange&");
    Shiboken::Conversions::registerConverterName(converter, "QComponentRemovedChange");
    Shiboken::Conversions::registerConverterName(converter, "QComponentRemovedChange*");
    Shiboken::Conversions::registerConverterName(converter, "QComponentRemovedChange&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DCore::QComponentRemovedChange).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QComponentRemovedChangeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DCore_QComponentRemovedChange_TypeF(), &Sbk_Qt3DCore_QComponentRemovedChange_typeDiscovery);

}
