#!/usr/bin/env ruby
#
# Plugin cisco_type7
# Author L
#

plugin 'cisco_type7' do 
  supported_algorithm :cisco_type7

  crack {
    xlat = [
      0x64, 0x73, 0x66, 0x64, 0x3b, 0x6b, 0x66, 0x6f, 0x41, 0x2c, 0x2e,
      0x69, 0x79, 0x65, 0x77, 0x72, 0x6b, 0x6c, 0x64, 0x4a, 0x4b, 0x44,
      0x48, 0x53, 0x55, 0x42, 0x73, 0x67, 0x76, 0x63, 0x61, 0x36, 0x39,
      0x38, 0x33, 0x34, 0x6e, 0x63, 0x78, 0x76, 0x39, 0x38, 0x37, 0x33,
      0x32, 0x35, 0x34, 0x6b, 0x3b, 0x66, 0x67, 0x38, 0x37
    ]

    s, *e = passwd.hex2bytes

    dp = ''
    e.each do |magic|
      if s <= 50
        newchar = magic ^ xlat[s]
        s += 1
      end
      s = 0 if s == 51
      dp << newchar
    end
    dp if dp.printable?
  }
end

