/// <reference types="node" />
import { API } from '@sentry/core';
import { SentryEvent, SentryResponse, Transport, TransportOptions } from '@sentry/types';
import * as http from 'http';
import * as https from 'https';
import * as url from 'url';
/** Internal used interface for typescript */
export interface HTTPRequest {
    request(options: http.RequestOptions | https.RequestOptions | string | url.URL, callback?: (res: http.IncomingMessage) => void): http.ClientRequest;
}
/** Base Transport class implementation */
export declare abstract class BaseTransport implements Transport {
    options: TransportOptions;
    /** API object */
    protected api: API;
    /** The Agent used for corresponding transport */
    module?: HTTPRequest;
    /** The Agent used for corresponding transport */
    client?: http.Agent | https.Agent;
    /** Create instance and set this.dsn */
    constructor(options: TransportOptions);
    /** Returns a build request option object used by request */
    protected getRequestOptions(): http.RequestOptions | https.RequestOptions;
    /** JSDoc */
    protected sendWithModule(httpModule: HTTPRequest, event: SentryEvent): Promise<SentryResponse>;
    /**
     * @inheritDoc
     */
    captureEvent(_: SentryEvent): Promise<SentryResponse>;
}
