"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = require("@sentry/core");
/** Global Promise Rejection handler */
var OnUnhandledRejection = /** @class */ (function () {
    function OnUnhandledRejection() {
        /**
         * @inheritDoc
         */
        this.name = OnUnhandledRejection.id;
    }
    /**
     * @inheritDoc
     */
    OnUnhandledRejection.prototype.setupOnce = function () {
        global.process.on('unhandledRejection', this.sendUnhandledPromise.bind(this));
    };
    /**
     * Send an exception with reason
     * @param reason string
     * @param promise promise
     */
    OnUnhandledRejection.prototype.sendUnhandledPromise = function (reason, promise) {
        var hub = core_1.getCurrentHub();
        if (!hub.getIntegration(OnUnhandledRejection)) {
            return;
        }
        var context = (promise.domain && promise.domain.sentryContext) || {};
        hub.withScope(function (scope) {
            scope.setExtra('unhandledPromiseRejection', true);
            // Preserve backwards compatibility with raven-node for now
            if (context.user) {
                scope.setUser(context.user);
            }
            if (context.tags) {
                Object.keys(context.tags).forEach(function (key) {
                    scope.setTag(key, context.tags[key]);
                });
            }
            if (context.extra) {
                Object.keys(context.extra).forEach(function (key) {
                    scope.setExtra(key, context.extra[key]);
                });
            }
            hub.captureException(reason, { originalException: promise });
        });
    };
    /**
     * @inheritDoc
     */
    OnUnhandledRejection.id = 'OnUnhandledRejection';
    return OnUnhandledRejection;
}());
exports.OnUnhandledRejection = OnUnhandledRejection;
//# sourceMappingURL=onunhandledrejection.js.map