"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var logger_1 = require("@sentry/utils/logger");
exports.installedIntegrations = [];
/** Gets integration to install */
function getIntegrationsToSetup(options) {
    var e_1, _a, e_2, _b;
    var defaultIntegrations = (options.defaultIntegrations && tslib_1.__spread(options.defaultIntegrations)) || [];
    var userIntegrations = options.integrations;
    var integrations = [];
    if (Array.isArray(userIntegrations)) {
        var userIntegrationsNames = userIntegrations.map(function (i) { return i.name; });
        var pickedIntegrationsNames = [];
        try {
            // Leave only unique default integrations, that were not overridden with provided user integrations
            for (var defaultIntegrations_1 = tslib_1.__values(defaultIntegrations), defaultIntegrations_1_1 = defaultIntegrations_1.next(); !defaultIntegrations_1_1.done; defaultIntegrations_1_1 = defaultIntegrations_1.next()) {
                var defaultIntegration = defaultIntegrations_1_1.value;
                if (userIntegrationsNames.indexOf(getIntegrationName(defaultIntegration)) === -1 &&
                    pickedIntegrationsNames.indexOf(getIntegrationName(defaultIntegration)) === -1) {
                    integrations.push(defaultIntegration);
                    pickedIntegrationsNames.push(getIntegrationName(defaultIntegration));
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (defaultIntegrations_1_1 && !defaultIntegrations_1_1.done && (_a = defaultIntegrations_1.return)) _a.call(defaultIntegrations_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        try {
            // Don't add same user integration twice
            for (var userIntegrations_1 = tslib_1.__values(userIntegrations), userIntegrations_1_1 = userIntegrations_1.next(); !userIntegrations_1_1.done; userIntegrations_1_1 = userIntegrations_1.next()) {
                var userIntegration = userIntegrations_1_1.value;
                if (pickedIntegrationsNames.indexOf(getIntegrationName(userIntegration)) === -1) {
                    integrations.push(userIntegration);
                    pickedIntegrationsNames.push(getIntegrationName(userIntegration));
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (userIntegrations_1_1 && !userIntegrations_1_1.done && (_b = userIntegrations_1.return)) _b.call(userIntegrations_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    else if (typeof userIntegrations === 'function') {
        integrations = userIntegrations(defaultIntegrations);
        integrations = Array.isArray(integrations) ? integrations : [integrations];
    }
    else {
        return tslib_1.__spread(defaultIntegrations);
    }
    return integrations;
}
exports.getIntegrationsToSetup = getIntegrationsToSetup;
/** Setup given integration */
function setupIntegration(integration, options) {
    if (exports.installedIntegrations.indexOf(getIntegrationName(integration)) !== -1) {
        return;
    }
    try {
        integration.setupOnce();
    }
    catch (_Oo) {
        /** @deprecated */
        // TODO: Remove in v5
        logger_1.logger.warn("Integration " + getIntegrationName(integration) + ": The install method is deprecated. Use \"setupOnce\".");
        // tslint:disable:deprecation
        if (integration.install) {
            integration.install(options);
        }
        // tslint:enable:deprecation
    }
    exports.installedIntegrations.push(getIntegrationName(integration));
    logger_1.logger.log("Integration installed: " + getIntegrationName(integration));
}
exports.setupIntegration = setupIntegration;
/**
 * Given a list of integration instances this installs them all. When `withDefaults` is set to `true` then all default
 * integrations are added unless they were already provided before.
 * @param integrations array of integration instances
 * @param withDefault should enable default integrations
 */
function setupIntegrations(options) {
    var integrations = {};
    getIntegrationsToSetup(options).forEach(function (integration) {
        integrations[getIntegrationName(integration)] = integration;
        setupIntegration(integration, options);
    });
    return integrations;
}
exports.setupIntegrations = setupIntegrations;
/**
 * Returns the integration static id.
 * @param integration Integration to retrieve id
 */
function getIntegrationName(integration) {
    /**
     * @depracted
     */
    // tslint:disable-next-line:no-unsafe-any
    return integration.constructor.id || integration.name;
}
//# sourceMappingURL=integration.js.map