const fs = require('fs'),
      path = require('path'),

      PLUGINS_DIRECTORY = 'plugins',
      APP_PATH = process.env.APP_PATH; // eslint-disable-line no-process-env

/**
 * Used to return the path for plugin residing in app
 *
 * @param  {String} id
 *
 * @returns {String}
 */
function getPluginPath (id) {
  return path.resolve(_getPrepackedPluginsPackagePath(), `${id}.zip`);
}

/**
 * Used to return the built in plugins shipped with the app
 *
 * @return {Promise<Object>}
 */
function getPrepackedInPlugins () {
  let logPrefix = 'PrePackagedPluginResolver~getPrepackedInPlugins';

  return new Promise((resolve) => {
    let builtInPluginsPath = path.resolve(_getPrepackedPluginsPackagePath(), 'prepackedPlugins.json');

    fs.readFile(builtInPluginsPath, 'utf8', (err, data) => {
      if (err) {
        pm.logger.error(`${logPrefix}: Built in plugins JSON does not exist`, err);
        throw new Error(`${logPrefix}: Built in plugins JSON does not exist, ${err.message}`);
      }

      try {
        return resolve(JSON.parse(data));
      }
      catch (e) {
        pm.logger.error(`${logPrefix}: Could not parse data received`, data, e);
        throw new Error(`${logPrefix}: Could not parse data received, "${data}"`);
      }
    });
  });
}

/**
 * Return the AppPath where package.json is present
 *
 * @returns {String}
 */
function _getPrepackedPluginsPackagePath () {
  return path.resolve(APP_PATH, PLUGINS_DIRECTORY);
}

module.exports = {
  getPluginPath,
  getPrepackedInPlugins
};
